/*!
 * Paper.js v0.10.1 - The Swiss Army Knife of Vector Graphics Scripting.
 * http://paperjs.org/
 *
 * Copyright (c) 2011 - 2016, Juerg Lehni & Jonathan Puckey
 * http://scratchdisk.com/ & http://jonathanpuckey.com/
 *
 * Distributed under the MIT license. See LICENSE file for details.
 *
 * All rights reserved.
 *
 * Date: Sat Jul 9 17:17:25 2016 +0200
 *
 ***
 *
 * Straps.js - Class inheritance library with support for bean-style accessors
 *
 * Copyright (c) 2006 - 2016 Juerg Lehni
 * http://scratchdisk.com/
 *
 * Distributed under the MIT license.
 *
 ***
 *
 * Acorn.js
 * http://marijnhaverbeke.nl/acorn/
 *
 * Acorn is a tiny, fast JavaScript parser written in JavaScript,
 * created by Marijn Haverbeke and released under an MIT license.
 *
 */
var paper=function(t,e){var n=t?t.window:require("./node/window"),i=n&&n.document;t=t||n;var r=new function(){function t(t,e,n,i,a){function o(s,o){o=o||(o=u(e,s))&&(o.get?o:o.value),"string"==typeof o&&"#"===o[0]&&(o=t[o.substring(1)]||o);var l,f="function"==typeof o,d=o,_=a||f&&!o.base?o&&o.get?s in t:t[s]:null;a&&_||(f&&_&&(o.base=_),f&&i!==!1&&(l=s.match(/^([gs]et|is)(([A-Z])(.*))$/))&&(h[l[3].toLowerCase()+l[4]]=l[2]),d&&!f&&d.get&&"function"==typeof d.get&&r.isPlainObject(d)||(d={value:d,writable:!0}),(u(t,s)||{configurable:!0}).configurable&&(d.configurable=!0,d.enumerable=n),c(t,s,d))}var h={};if(e){for(var l in e)e.hasOwnProperty(l)&&!s.test(l)&&o(l);for(var l in h){var f=h[l],d=t["set"+f],_=t["get"+f]||d&&t["is"+f];!_||i!==!0&&0!==_.length||o(l,{get:_,set:d})}}return t}function n(t,e,n){return t&&("length"in t&&!t.getLength&&"number"==typeof t.length?a:o).call(t,e,n=n||t),n}function i(t,e,n){for(var i=n,r=e.length;i<r;i++){var s=e[i];for(var a in s)s.hasOwnProperty(a)&&(t[a]=s[a])}return t}var s=/^(statics|enumerable|beans|preserve)$/,a=[].forEach||function(t,e){for(var n=0,i=this.length;n<i;n++)t.call(e,this[n],n,this)},o=function(t,e){for(var n in this)this.hasOwnProperty(n)&&t.call(e,this[n],n,this)},h=Object.create||function(t){return{__proto__:t}},u=Object.getOwnPropertyDescriptor||function(t,e){var n=t.__lookupGetter__&&t.__lookupGetter__(e);return n?{get:n,set:t.__lookupSetter__(e),enumerable:!0,configurable:!0}:t.hasOwnProperty(e)?{value:t[e],enumerable:!0,configurable:!0,writable:!0}:null},l=Object.defineProperty||function(t,e,n){return(n.get||n.set)&&t.__defineGetter__?(n.get&&t.__defineGetter__(e,n.get),n.set&&t.__defineSetter__(e,n.set)):t[e]=n.value,t},c=function(t,e,n){return delete t[e],l(t,e,n)};return t(function(){i(this,arguments,0)},{inject:function(e){if(e){var n=e.statics===!0?e:e.statics,i=e.beans,r=e.preserve;n!==e&&t(this.prototype,e,e.enumerable,i,r),t(this,n,!0,i,r)}for(var s=1,a=arguments.length;s<a;s++)this.inject(arguments[s]);return this},extend:function(){for(var e,n,i,r=this,s=0,a=arguments.length;s<a&&(!e||!n);s++)i=arguments[s],e=e||i.initialize,n=n||i.prototype;return e=e||function(){r.apply(this,arguments)},n=e.prototype=n||h(this.prototype),c(n,"constructor",{value:e,writable:!0,configurable:!0}),t(e,this,!0),arguments.length&&this.inject.apply(e,arguments),e.base=r,e}},!0).inject({inject:function(){for(var e=0,n=arguments.length;e<n;e++){var i=arguments[e];i&&t(this,i,i.enumerable,i.beans,i.preserve)}return this},extend:function(){var t=h(this);return t.inject.apply(t,arguments)},each:function(t,e){return n(this,t,e)},set:function(){return i(this,arguments,0)},clone:function(){return new this.constructor(this)},statics:{each:n,create:h,define:c,describe:u,set:function(t){return i(t,arguments,1)},clone:function(t){return i(new t.constructor,arguments,0)},isPlainObject:function(t){var e=null!=t&&t.constructor;return e&&(e===Object||e===r||"Object"===e.name)},pick:function(t,n){return t!==e?t:n}}})};"undefined"!=typeof module&&(module.exports=r),r.inject({toString:function(){return null!=this._id?(this._class||"Object")+(this._name?" '"+this._name+"'":" @"+this._id):"{ "+r.each(this,function(t,e){if(!/^_/.test(e)){var n=typeof t;this.push(e+": "+("number"===n?h.instance.number(t):"string"===n?"'"+t+"'":t))}},[]).join(", ")+" }"},getClassName:function(){return this._class||""},importJSON:function(t){return r.importJSON(t,this)},exportJSON:function(t){return r.exportJSON(this,t)},toJSON:function(){return r.serialize(this)},_set:function(t){if(t&&r.isPlainObject(t))return r.filter(this,t)},statics:{exports:{enumerable:!0},extend:function rt(){var t=rt.base.apply(this,arguments),e=t.prototype._class;return e&&!r.exports[e]&&(r.exports[e]=t),t},equals:function(t,e){if(t===e)return!0;if(t&&t.equals)return t.equals(e);if(e&&e.equals)return e.equals(t);if(t&&e&&"object"==typeof t&&"object"==typeof e){if(Array.isArray(t)&&Array.isArray(e)){var n=t.length;if(n!==e.length)return!1;for(;n--;)if(!r.equals(t[n],e[n]))return!1}else{var i=Object.keys(t),n=i.length;if(n!==Object.keys(e).length)return!1;for(;n--;){var s=i[n];if(!e.hasOwnProperty(s)||!r.equals(t[s],e[s]))return!1}}return!0}return!1},read:function(t,n,i,s){if(this===r){var a=this.peek(t,n);return t.__index++,a}var o=this.prototype,h=o._readIndex,u=n||h&&t.__index||0;s||(s=t.length-u);var l=t[u];return l instanceof this||i&&i.readNull&&null==l&&s<=1?(h&&(t.__index=u+1),l&&i&&i.clone?l.clone():l):(l=r.create(this.prototype),h&&(l.__read=!0),l=l.initialize.apply(l,u>0||s<t.length?Array.prototype.slice.call(t,u,u+s):t)||l,h&&(t.__index=u+l.__read,l.__read=e),l)},peek:function(t,e){return t[t.__index=e||t.__index||0]},remain:function(t){return t.length-(t.__index||0)},readAll:function(t,e,n){for(var i,r=[],s=e||0,a=t.length;s<a;s++)r.push(Array.isArray(i=t[s])?this.read(i,0,n):this.read(t,s,n,1));return r},readNamed:function(t,n,i,s,a){var o=this.getNamed(t,n),h=o!==e;if(h){var u=t._filtered;u||(u=t._filtered=r.create(t[0]),u._filtering=t[0]),u[n]=e}return this.read(h?[o]:t,i,s,a)},getNamed:function(t,n){var i=t[0];if(t._hasObject===e&&(t._hasObject=1===t.length&&r.isPlainObject(i)),t._hasObject)return n?i[n]:t._filtered||i},hasNamed:function(t,e){return!!this.getNamed(t,e)},filter:function(t,n,i){for(var r=Object.keys(n._filtering||n),s=0,a=r.length;s<a;s++){var o=r[s];if(!i||!i[o]){var h=n[o];h!==e&&(t[o]=h)}}return t},isPlainValue:function(t,e){return this.isPlainObject(t)||Array.isArray(t)||e&&"string"==typeof t},serialize:function(t,e,n,i){e=e||{};var s,a=!i;if(a&&(e.formatter=new h(e.precision),i={length:0,definitions:{},references:{},add:function(t,e){var n="#"+t._id,i=this.references[n];if(!i){this.length++;var r=e.call(t),s=t._class;s&&r[0]!==s&&r.unshift(s),this.definitions[n]=r,i=this.references[n]=[n]}return i}}),t&&t._serialize){s=t._serialize(e,i);var o=t._class;!o||t._compactSerialize||!a&&n||s[0]===o||s.unshift(o)}else if(Array.isArray(t)){s=[];for(var u=0,l=t.length;u<l;u++)s[u]=r.serialize(t[u],e,n,i)}else if(r.isPlainObject(t)){s={};for(var c=Object.keys(t),u=0,l=c.length;u<l;u++){var f=c[u];s[f]=r.serialize(t[f],e,n,i)}}else s="number"==typeof t?e.formatter.number(t,e.precision):t;return a&&i.length>0?[["dictionary",i.definitions],s]:s},deserialize:function(t,e,n,i,s){var a=t,o=!n,h=o&&t&&t.length&&"dictionary"===t[0][0];if(n=n||{},Array.isArray(t)){var u=t[0],l="dictionary"===u;if(1==t.length&&/^#/.test(u))return n.dictionary[u];u=r.exports[u],a=[];for(var c=u?1:0,f=t.length;c<f;c++)a.push(r.deserialize(t[c],e,n,l,h));if(u){var d=a;e?a=e(u,d,o||s):(a=r.create(u.prototype),u.apply(a,d))}}else if(r.isPlainObject(t)){a={},i&&(n.dictionary=a);for(var _ in t)a[_]=r.deserialize(t[_],e,n)}return h?a[1]:a},exportJSON:function(t,e){var n=r.serialize(t,e);return e&&e.asString===!1?n:JSON.stringify(n)},importJSON:function(t,e){return r.deserialize("string"==typeof t?JSON.parse(t):t,function(t,n,i){var s=i&&e&&e.constructor===t,a=s?e:r.create(t.prototype);if(1===n.length&&a instanceof w&&(s||!(a instanceof b))){var o=n[0];r.isPlainObject(o)&&(o.insert=!1)}return(s?a._set:t).apply(a,n),s&&(e=null),a})},splice:function(t,n,i,r){var s=n&&n.length,a=i===e;i=a?t.length:i,i>t.length&&(i=t.length);for(var o=0;o<s;o++)n[o]._index=i+o;if(a)return t.push.apply(t,n),[];var h=[i,r];n&&h.push.apply(h,n);for(var u=t.splice.apply(t,h),o=0,l=u.length;o<l;o++)u[o]._index=e;for(var o=i+s,l=t.length;o<l;o++)t[o]._index=o;return u},capitalize:function(t){return t.replace(/\b[a-z]/g,function(t){return t.toUpperCase()})},camelize:function(t){return t.replace(/-(.)/g,function(t,e){return e.toUpperCase()})},hyphenate:function(t){return t.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase()}}});var s={on:function(t,e){if("string"!=typeof t)r.each(t,function(t,e){this.on(e,t)},this);else{var n=this._eventTypes,i=n&&n[t],s=this._callbacks=this._callbacks||{};s=s[t]=s[t]||[],s.indexOf(e)===-1&&(s.push(e),i&&i.install&&1===s.length&&i.install.call(this,t))}return this},off:function(t,e){if("string"!=typeof t)return void r.each(t,function(t,e){this.off(e,t)},this);var n,i=this._eventTypes,s=i&&i[t],a=this._callbacks&&this._callbacks[t];return a&&(!e||(n=a.indexOf(e))!==-1&&1===a.length?(s&&s.uninstall&&s.uninstall.call(this,t),delete this._callbacks[t]):n!==-1&&a.splice(n,1)),this},once:function(t,e){return this.on(t,function(){e.apply(this,arguments),this.off(t,e)})},emit:function(t,e){var n=this._callbacks&&this._callbacks[t];if(!n)return!1;var i=[].slice.call(arguments,1),r=e&&e.target&&!e.currentTarget;n=n.slice(),r&&(e.currentTarget=this);for(var s=0,a=n.length;s<a;s++)if(n[s].apply(this,i)===!1){e&&e.stop&&e.stop();break}return r&&delete e.currentTarget,!0},responds:function(t){return!(!this._callbacks||!this._callbacks[t])},attach:"#on",detach:"#off",fire:"#emit",_installEvents:function(t){var e=this._eventTypes,n=this._callbacks,i=t?"install":"uninstall";if(e)for(var r in n)if(n[r].length>0){var s=e[r],a=s&&s[i];a&&a.call(this,r)}},statics:{inject:function st(t){var e=t._events;if(e){var n={};r.each(e,function(e,i){var s="string"==typeof e,a=s?e:i,o=r.capitalize(a),h=a.substring(2).toLowerCase();n[h]=s?{}:e,a="_"+a,t["get"+o]=function(){return this[a]},t["set"+o]=function(t){var e=this[a];e&&this.off(h,e),t&&this.on(h,t),this[a]=t}}),t._eventTypes=n}return st.base.apply(this,arguments)}}},a=r.extend({_class:"PaperScope",initialize:function at(){paper=this,this.settings=new r({applyMatrix:!0,insertItems:!0,handleSize:4,hitTolerance:0}),this.project=null,this.projects=[],this.tools=[],this.palettes=[],this._id=at._id++,at._scopes[this._id]=this;var e=at.prototype;if(!this.support){var n=tt.getContext(1,1)||{};e.support={nativeDash:"setLineDash"in n||"mozDash"in n,nativeBlendModes:et.nativeModes},tt.release(n)}if(!this.agent){var i=t.navigator.userAgent.toLowerCase(),s=(/(darwin|win|mac|linux|freebsd|sunos)/.exec(i)||[])[0],a="darwin"===s?"mac":s,o=e.agent=e.browser={platform:a};a&&(o[a]=!0),i.replace(/(opera|chrome|safari|webkit|firefox|msie|trident|atom|node)\/?\s*([.\d]+)(?:.*version\/([.\d]+))?(?:.*rv\:v?([.\d]+))?/g,function(t,e,n,i,r){if(!o.chrome){var s="opera"===e?i:/^(node|trident)$/.test(e)?r:n;o.version=s,o.versionNumber=parseFloat(s),e="trident"===e?"msie":e,o.name=e,o[e]=!0}}),o.chrome&&delete o.webkit,o.atom&&delete o.chrome}},version:"0.10.1",getView:function(){var t=this.project;return t&&t._view},getPaper:function(){return this},execute:function(t,e){paper.PaperScript.execute(t,this,e),Z.updateFocus()},install:function(t){var e=this;r.each(["project","view","tool"],function(n){r.define(t,n,{configurable:!0,get:function(){return e[n]}})});for(var n in this)!/^_/.test(n)&&this[n]&&(t[n]=this[n])},setup:function(t){return paper=this,this.project=new y(t),this},createCanvas:function(t,e){return tt.getCanvas(t,e)},activate:function(){paper=this},clear:function(){for(var t=this.projects,e=this.tools,n=this.palettes,i=t.length-1;i>=0;i--)t[i].remove();for(var i=e.length-1;i>=0;i--)e[i].remove();for(var i=n.length-1;i>=0;i--)n[i].remove()},remove:function(){this.clear(),delete a._scopes[this._id]},statics:new function(){function t(t){return t+="Attribute",function(e,n){return e[t](n)||e[t]("data-paper-"+n)}}return{_scopes:{},_id:0,get:function(t){return this._scopes[t]||null},getAttribute:t("get"),hasAttribute:t("has")}}}),o=r.extend(s,{initialize:function(t){this._scope=paper,this._index=this._scope[this._list].push(this)-1,!t&&this._scope[this._reference]||this.activate()},activate:function(){if(!this._scope)return!1;var t=this._scope[this._reference];return t&&t!==this&&t.emit("deactivate"),this._scope[this._reference]=this,this.emit("activate",t),!0},isActive:function(){return this._scope[this._reference]===this},remove:function(){return null!=this._index&&(r.splice(this._scope[this._list],null,this._index,1),this._scope[this._reference]==this&&(this._scope[this._reference]=null),this._scope=null,!0)},getView:function(){return this._scope.getView()}}),h=r.extend({initialize:function(t){this.precision=r.pick(t,5),this.multiplier=Math.pow(10,this.precision)},number:function(t){return this.precision<16?Math.round(t*this.multiplier)/this.multiplier:t},pair:function(t,e,n){return this.number(t)+(n||",")+this.number(e)},point:function(t,e){return this.number(t.x)+(e||",")+this.number(t.y)},size:function(t,e){return this.number(t.width)+(e||",")+this.number(t.height)},rectangle:function(t,e){return this.point(t,e)+(e||",")+this.size(t,e)}});h.instance=new h;var u=new function(){function t(t,e,n){return t<e?e:t>n?n:t}function e(t,e,n){function i(t){var e=134217729*t,n=t-e,i=n+e,r=t-i;return[i,r]}var r=e*e-t*n,a=e*e+t*n;if(3*s(r)<a){var o=i(t),h=i(e),u=i(n),l=e*e,c=h[0]*h[0]-l+2*h[0]*h[1]+h[1]*h[1],f=t*n,d=o[0]*u[0]-f+o[0]*u[1]+o[1]*u[0]+o[1]*u[1];r=l-f+(c-d)}return r}function n(){var t=Math.max.apply(Math,arguments);return t&&(t<1e-8||t>1e8)?o(2,-Math.round(h(t))):0}var i=[[.5773502691896257],[0,.7745966692414834],[.33998104358485626,.8611363115940526],[0,.5384693101056831,.906179845938664],[.2386191860831969,.6612093864662645,.932469514203152],[0,.4058451513773972,.7415311855993945,.9491079123427585],[.1834346424956498,.525532409916329,.7966664774136267,.9602898564975363],[0,.3242534234038089,.6133714327005904,.8360311073266358,.9681602395076261],[.14887433898163122,.4333953941292472,.6794095682990244,.8650633666889845,.9739065285171717],[0,.26954315595234496,.5190961292068118,.7301520055740494,.8870625997680953,.978228658146057],[.1252334085114689,.3678314989981802,.5873179542866175,.7699026741943047,.9041172563704749,.9815606342467192],[0,.2304583159551348,.44849275103644687,.6423493394403402,.8015780907333099,.9175983992229779,.9841830547185881],[.10805494870734367,.31911236892788974,.5152486363581541,.6872929048116855,.827201315069765,.9284348836635735,.9862838086968123],[0,.20119409399743451,.3941513470775634,.5709721726085388,.7244177313601701,.8482065834104272,.937273392400706,.9879925180204854],[.09501250983763744,.2816035507792589,.45801677765722737,.6178762444026438,.755404408355003,.8656312023878318,.9445750230732326,.9894009349916499]],r=[[1],[.8888888888888888,.5555555555555556],[.6521451548625461,.34785484513745385],[.5688888888888889,.47862867049936647,.23692688505618908],[.46791393457269104,.3607615730481386,.17132449237917036],[.4179591836734694,.3818300505051189,.27970539148927664,.1294849661688697],[.362683783378362,.31370664587788727,.22238103445337448,.10122853629037626],[.3302393550012598,.31234707704000286,.26061069640293544,.1806481606948574,.08127438836157441],[.29552422471475287,.26926671930999635,.21908636251598204,.1494513491505806,.06667134430868814],[.2729250867779006,.26280454451024665,.23319376459199048,.18629021092773426,.1255803694649046,.05566856711617366],[.24914704581340277,.2334925365383548,.20316742672306592,.16007832854334622,.10693932599531843,.04717533638651183],[.2325515532308739,.22628318026289723,.2078160475368885,.17814598076194574,.13887351021978725,.09212149983772845,.04048400476531588],[.2152638534631578,.2051984637212956,.18553839747793782,.15720316715819355,.12151857068790319,.08015808715976021,.03511946033175186],[.2025782419255613,.19843148532711158,.1861610000155622,.16626920581699392,.13957067792615432,.10715922046717194,.07036604748810812,.03075324199611727],[.1894506104550685,.18260341504492358,.16915651939500254,.14959598881657674,.12462897125553388,.09515851168249279,.062253523938647894,.027152459411754096]],s=Math.abs,a=Math.sqrt,o=Math.pow,h=Math.log2||function(t){return Math.log(t)*Math.LOG2E},l=1e-12,c=1.12e-16;return{TOLERANCE:1e-6,EPSILON:l,MACHINE_EPSILON:c,CURVETIME_EPSILON:4e-7,GEOMETRIC_EPSILON:2e-7,WINDING_EPSILON:2e-7,TRIGONOMETRIC_EPSILON:1e-7,CLIPPING_EPSILON:1e-9,KAPPA:4*(a(2)-1)/3,isZero:function(t){return t>=-l&&t<=l},clamp:t,integrate:function(t,e,n,s){for(var a=i[s-2],o=r[s-2],h=.5*(n-e),u=h+e,l=0,c=s+1>>1,f=1&s?o[l++]*t(u):0;l<c;){var d=h*a[l];f+=o[l++]*(t(u+d)+t(u-d))}return h*f},findRoot:function(t,e,n,i,r,a,o){for(var h=0;h<a;h++){var u=t(n),l=u/e(n),c=n-l;if(s(l)<o)return c;u>0?(r=n,n=c<=i?.5*(i+r):c):(i=n,n=c>=r?.5*(i+r):c)}return n},solveQuadratic:function(i,r,o,h,u,f){var d,_=1/0;if(s(i)<l){if(s(r)<l)return s(o)<l?-1:0;d=-o/r}else{r*=-.5;var g=e(i,r,o);if(g&&s(g)<c){var v=n(s(i),s(r),s(o));v&&(i*=v,r*=v,o*=v,g=e(i,r,o))}if(g>=-c){var p=g<0?0:a(g),m=r+(r<0?-p:p);0===m?(d=o/i,_=-d):(d=m/i,_=o/m)}}var y=0,w=null==u,x=u-l,b=f+l;return isFinite(d)&&(w||d>x&&d<b)&&(h[y++]=w?d:t(d,u,f)),_!==d&&isFinite(_)&&(w||_>x&&_<b)&&(h[y++]=w?_:t(_,u,f)),y},solveCubic:function(e,i,r,h,f,d,_){function g(t){v=t;var n=e*v;p=n+i,m=p*v+r,y=(n+p)*v+m,w=m*v+h}var v,p,m,y,w,x=n(s(e),s(i),s(r),s(h));if(x&&(e*=x,i*=x,r*=x,h*=x),s(e)<l)e=i,p=r,m=h,v=1/0;else if(s(h)<l)p=i,m=r,v=0;else{g(-(i/e)/3);var b=w/e,C=o(s(b),1/3),S=b<0?-1:1,k=-y/e,I=k>0?1.324717957244746*Math.max(C,a(k)):C,P=v-S*I;if(P!==v){do g(P),P=0===y?v:v-w/y/(1+c);while(S*P>S*v);s(e)*v*v>s(h/v)&&(m=-h/v,p=(m-r)/v)}}var M=u.solveQuadratic(e,p,m,f,d,_),A=null==d;return isFinite(v)&&(0===M||M>0&&v!==f[0]&&v!==f[1])&&(A||v>d-l&&v<_+l)&&(f[M++]=A?v:t(v,d,_)),M}}},l={_id:1,_pools:{},get:function(t){if(t){var e=this._pools[t];return e||(e=this._pools[t]={_id:1}),e._id++}return this._id++}},c=r.extend({_class:"Point",_readIndex:!0,initialize:function(t,e){var n=typeof t;if("number"===n){var i="number"==typeof e;this.x=t,this.y=i?e:t,this.__read&&(this.__read=i?2:1)}else if("undefined"===n||null===t)this.x=this.y=0,this.__read&&(this.__read=null===t?1:0);else{var r="string"===n?t.split(/[\s,]+/)||[]:t;Array.isArray(r)?(this.x=r[0],this.y=r.length>1?r[1]:r[0]):"x"in r?(this.x=r.x,this.y=r.y):"width"in r?(this.x=r.width,this.y=r.height):"angle"in r?(this.x=r.length,this.y=0,this.setAngle(r.angle)):(this.x=this.y=0,this.__read&&(this.__read=0)),this.__read&&(this.__read=1)}},set:function(t,e){return this.x=t,this.y=e,this},equals:function(t){return this===t||t&&(this.x===t.x&&this.y===t.y||Array.isArray(t)&&this.x===t[0]&&this.y===t[1])||!1},clone:function(){return new c(this.x,this.y)},toString:function(){var t=h.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.x),e.number(this.y)]},getLength:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},setLength:function(t){if(this.isZero()){var e=this._angle||0;this.set(Math.cos(e)*t,Math.sin(e)*t)}else{var n=t/this.getLength();u.isZero(n)&&this.getAngle(),this.set(this.x*n,this.y*n)}},getAngle:function(){return 180*this.getAngleInRadians.apply(this,arguments)/Math.PI},setAngle:function(t){this.setAngleInRadians.call(this,t*Math.PI/180)},getAngleInDegrees:"#getAngle",setAngleInDegrees:"#setAngle",getAngleInRadians:function(){if(arguments.length){var t=c.read(arguments),e=this.getLength()*t.getLength();if(u.isZero(e))return NaN;var n=this.dot(t)/e;return Math.acos(n<-1?-1:n>1?1:n)}return this.isZero()?this._angle||0:this._angle=Math.atan2(this.y,this.x)},setAngleInRadians:function(t){if(this._angle=t,!this.isZero()){var e=this.getLength();this.set(Math.cos(t)*e,Math.sin(t)*e)}},getQuadrant:function(){return this.x>=0?this.y>=0?1:4:this.y>=0?2:3}},{beans:!1,getDirectedAngle:function(){var t=c.read(arguments);return 180*Math.atan2(this.cross(t),this.dot(t))/Math.PI},getDistance:function(){var t=c.read(arguments),e=t.x-this.x,n=t.y-this.y,i=e*e+n*n,s=r.read(arguments);return s?i:Math.sqrt(i)},normalize:function(t){t===e&&(t=1);var n=this.getLength(),i=0!==n?t/n:0,r=new c(this.x*i,this.y*i);return i>=0&&(r._angle=this._angle),r},rotate:function(t,e){if(0===t)return this.clone();t=t*Math.PI/180;var n=e?this.subtract(e):this,i=Math.sin(t),r=Math.cos(t);return n=new c(n.x*r-n.y*i,n.x*i+n.y*r),e?n.add(e):n},transform:function(t){return t?t._transformPoint(this):this},add:function(){var t=c.read(arguments);return new c(this.x+t.x,this.y+t.y)},subtract:function(){var t=c.read(arguments);return new c(this.x-t.x,this.y-t.y)},multiply:function(){var t=c.read(arguments);return new c(this.x*t.x,this.y*t.y)},divide:function(){var t=c.read(arguments);return new c(this.x/t.x,this.y/t.y)},modulo:function(){var t=c.read(arguments);return new c(this.x%t.x,this.y%t.y)},negate:function(){return new c((-this.x),(-this.y))},isInside:function(){return g.read(arguments).contains(this)},isClose:function(){var t=c.read(arguments),e=r.read(arguments);return this.getDistance(t)<=e},isCollinear:function(){var t=c.read(arguments);return c.isCollinear(this.x,this.y,t.x,t.y)},isColinear:"#isCollinear",isOrthogonal:function(){var t=c.read(arguments);return c.isOrthogonal(this.x,this.y,t.x,t.y)},isZero:function(){return u.isZero(this.x)&&u.isZero(this.y)},isNaN:function(){return isNaN(this.x)||isNaN(this.y)},dot:function(){var t=c.read(arguments);return this.x*t.x+this.y*t.y},cross:function(){var t=c.read(arguments);return this.x*t.y-this.y*t.x},project:function(){var t=c.read(arguments),e=t.isZero()?0:this.dot(t)/t.dot(t);return new c(t.x*e,t.y*e)},statics:{min:function(){var t=c.read(arguments),e=c.read(arguments);return new c(Math.min(t.x,e.x),Math.min(t.y,e.y))},max:function(){var t=c.read(arguments),e=c.read(arguments);return new c(Math.max(t.x,e.x),Math.max(t.y,e.y))},random:function(){return new c(Math.random(),Math.random())},isCollinear:function(t,e,n,i){return Math.abs(t*i-e*n)<=1e-7*Math.sqrt((t*t+e*e)*(n*n+i*i))},isOrthogonal:function(t,e,n,i){return Math.abs(t*n+e*i)<=1e-7*Math.sqrt((t*t+e*e)*(n*n+i*i))}}},r.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new c(e(this.x),e(this.y))}},{})),f=c.extend({initialize:function(t,e,n,i){this._x=t,this._y=e,this._owner=n,this._setter=i},set:function(t,e,n){return this._x=t,this._y=e,n||this._owner[this._setter](this),this},getX:function(){return this._x},setX:function(t){this._x=t,this._owner[this._setter](this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner[this._setter](this)},isSelected:function(){return!!(this._owner._selection&this._getSelection())},setSelected:function(t){this._owner.changeSelection(this._getSelection(),t)},_getSelection:function(){return"setPosition"===this._setter?4:0}}),d=r.extend({_class:"Size",_readIndex:!0,initialize:function(t,e){var n=typeof t;if("number"===n){var i="number"==typeof e;this.width=t,this.height=i?e:t,this.__read&&(this.__read=i?2:1)}else if("undefined"===n||null===t)this.width=this.height=0,this.__read&&(this.__read=null===t?1:0);else{var r="string"===n?t.split(/[\s,]+/)||[]:t;Array.isArray(r)?(this.width=r[0],this.height=r.length>1?r[1]:r[0]):"width"in r?(this.width=r.width,this.height=r.height):"x"in r?(this.width=r.x,this.height=r.y):(this.width=this.height=0,this.__read&&(this.__read=0)),this.__read&&(this.__read=1)}},set:function(t,e){return this.width=t,this.height=e,this},equals:function(t){return t===this||t&&(this.width===t.width&&this.height===t.height||Array.isArray(t)&&this.width===t[0]&&this.height===t[1])||!1},clone:function(){return new d(this.width,this.height)},toString:function(){var t=h.instance;return"{ width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.width),e.number(this.height)]},add:function(){var t=d.read(arguments);return new d(this.width+t.width,this.height+t.height)},subtract:function(){var t=d.read(arguments);return new d(this.width-t.width,this.height-t.height)},multiply:function(){var t=d.read(arguments);return new d(this.width*t.width,this.height*t.height)},divide:function(){var t=d.read(arguments);return new d(this.width/t.width,this.height/t.height)},modulo:function(){var t=d.read(arguments);return new d(this.width%t.width,this.height%t.height)},negate:function(){return new d((-this.width),(-this.height))},isZero:function(){return u.isZero(this.width)&&u.isZero(this.height)},isNaN:function(){return isNaN(this.width)||isNaN(this.height)},statics:{min:function(t,e){return new d(Math.min(t.width,e.width),Math.min(t.height,e.height))},max:function(t,e){return new d(Math.max(t.width,e.width),Math.max(t.height,e.height))},random:function(){return new d(Math.random(),Math.random())}}},r.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new d(e(this.width),e(this.height))}},{})),_=d.extend({initialize:function(t,e,n,i){this._width=t,this._height=e,this._owner=n,this._setter=i},set:function(t,e,n){return this._width=t,this._height=e,n||this._owner[this._setter](this),this},getWidth:function(){return this._width},setWidth:function(t){this._width=t,this._owner[this._setter](this)},getHeight:function(){return this._height},setHeight:function(t){this._height=t,this._owner[this._setter](this)}}),g=r.extend({_class:"Rectangle",_readIndex:!0,beans:!0,initialize:function(t,n,i,s){var a=typeof t,o=0;if("number"===a?(this.x=t,this.y=n,this.width=i,this.height=s,o=4):"undefined"===a||null===t?(this.x=this.y=this.width=this.height=0,o=null===t?1:0):1===arguments.length&&(Array.isArray(t)?(this.x=t[0],this.y=t[1],this.width=t[2],this.height=t[3],o=1):t.x!==e||t.width!==e?(this.x=t.x||0,this.y=t.y||0,this.width=t.width||0,this.height=t.height||0,o=1):t.from===e&&t.to===e&&(this.x=this.y=this.width=this.height=0,this._set(t),o=1)),!o){var h=c.readNamed(arguments,"from"),u=r.peek(arguments);if(this.x=h.x,this.y=h.y,u&&u.x!==e||r.hasNamed(arguments,"to")){var l=c.readNamed(arguments,"to");this.width=l.x-h.x,this.height=l.y-h.y,this.width<0&&(this.x=l.x,this.width=-this.width),this.height<0&&(this.y=l.y,this.height=-this.height)}else{var f=d.read(arguments);this.width=f.width,this.height=f.height}o=arguments.__index}this.__read&&(this.__read=o)},set:function(t,e,n,i){return this.x=t,this.y=e,this.width=n,this.height=i,this},clone:function(){return new g(this.x,this.y,this.width,this.height)},equals:function(t){var e=r.isPlainValue(t)?g.read(arguments):t;return e===this||e&&this.x===e.x&&this.y===e.y&&this.width===e.width&&this.height===e.height||!1},toString:function(){var t=h.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+", width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.x),e.number(this.y),e.number(this.width),e.number(this.height)]},getPoint:function(t){var e=t?c:f;return new e(this.x,this.y,this,"setPoint")},setPoint:function(){var t=c.read(arguments);this.x=t.x,this.y=t.y},getSize:function(t){var e=t?d:_;return new e(this.width,this.height,this,"setSize")},setSize:function(){var t=d.read(arguments);this._fixX&&(this.x+=(this.width-t.width)*this._fixX),this._fixY&&(this.y+=(this.height-t.height)*this._fixY),this.width=t.width,this.height=t.height,this._fixW=1,this._fixH=1},getLeft:function(){return this.x},setLeft:function(t){this._fixW||(this.width-=t-this.x),this.x=t,this._fixX=0},getTop:function(){return this.y},setTop:function(t){this._fixH||(this.height-=t-this.y),this.y=t,this._fixY=0},getRight:function(){return this.x+this.width},setRight:function(t){this._fixX!==e&&1!==this._fixX&&(this._fixW=0),this._fixW?this.x=t-this.width:this.width=t-this.x,this._fixX=1},getBottom:function(){return this.y+this.height},setBottom:function(t){this._fixY!==e&&1!==this._fixY&&(this._fixH=0),this._fixH?this.y=t-this.height:this.height=t-this.y,this._fixY=1},getCenterX:function(){return this.x+.5*this.width},setCenterX:function(t){this.x=t-.5*this.width,this._fixX=.5},getCenterY:function(){return this.y+.5*this.height},setCenterY:function(t){this.y=t-.5*this.height,this._fixY=.5},getCenter:function(t){var e=t?c:f;return new e(this.getCenterX(),this.getCenterY(),this,"setCenter")},setCenter:function(){var t=c.read(arguments);return this.setCenterX(t.x),this.setCenterY(t.y),this},getArea:function(){return this.width*this.height},isEmpty:function(){return 0===this.width||0===this.height},contains:function(t){return t&&t.width!==e||4===(Array.isArray(t)?t:arguments).length?this._containsRectangle(g.read(arguments)):this._containsPoint(c.read(arguments))},_containsPoint:function(t){var e=t.x,n=t.y;return e>=this.x&&n>=this.y&&e<=this.x+this.width&&n<=this.y+this.height},_containsRectangle:function(t){var e=t.x,n=t.y;return e>=this.x&&n>=this.y&&e+t.width<=this.x+this.width&&n+t.height<=this.y+this.height},intersects:function(){var t=g.read(arguments);return t.x+t.width>this.x&&t.y+t.height>this.y&&t.x<this.x+this.width&&t.y<this.y+this.height},touches:function(){var t=g.read(arguments);return t.x+t.width>=this.x&&t.y+t.height>=this.y&&t.x<=this.x+this.width&&t.y<=this.y+this.height},intersect:function(){var t=g.read(arguments),e=Math.max(this.x,t.x),n=Math.max(this.y,t.y),i=Math.min(this.x+this.width,t.x+t.width),r=Math.min(this.y+this.height,t.y+t.height);return new g(e,n,i-e,r-n)},unite:function(){var t=g.read(arguments),e=Math.min(this.x,t.x),n=Math.min(this.y,t.y),i=Math.max(this.x+this.width,t.x+t.width),r=Math.max(this.y+this.height,t.y+t.height);return new g(e,n,i-e,r-n)},include:function(){var t=c.read(arguments),e=Math.min(this.x,t.x),n=Math.min(this.y,t.y),i=Math.max(this.x+this.width,t.x),r=Math.max(this.y+this.height,t.y);return new g(e,n,i-e,r-n)},expand:function(){var t=d.read(arguments),e=t.width,n=t.height;return new g(this.x-e/2,this.y-n/2,this.width+e,this.height+n)},scale:function(t,n){return this.expand(this.width*t-this.width,this.height*(n===e?t:n)-this.height)}},r.each([["Top","Left"],["Top","Right"],["Bottom","Left"],["Bottom","Right"],["Left","Center"],["Top","Center"],["Right","Center"],["Bottom","Center"]],function(t,e){var n=t.join(""),i=/^[RL]/.test(n);e>=4&&(t[1]+=i?"Y":"X");var r=t[i?0:1],s=t[i?1:0],a="get"+r,o="get"+s,h="set"+r,u="set"+s,l="get"+n,d="set"+n;this[l]=function(t){var e=t?c:f;return new e(this[a](),this[o](),this,d)},this[d]=function(){var t=c.read(arguments);this[h](t.x),this[u](t.y)}},{beans:!0})),v=g.extend({initialize:function(t,e,n,i,r,s){this.set(t,e,n,i,!0),this._owner=r,this._setter=s},set:function(t,e,n,i,r){return this._x=t,this._y=e,this._width=n,this._height=i,r||this._owner[this._setter](this),this}},new function(){var t=g.prototype;return r.each(["x","y","width","height"],function(t){var e=r.capitalize(t),n="_"+t;this["get"+e]=function(){return this[n]},this["set"+e]=function(t){this[n]=t,this._dontNotify||this._owner[this._setter](this)}},r.each(["Point","Size","Center","Left","Top","Right","Bottom","CenterX","CenterY","TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],function(e){var n="set"+e;this[n]=function(){this._dontNotify=!0,t[n].apply(this,arguments),this._dontNotify=!1,this._owner[this._setter](this)}},{isSelected:function(){return!!(2&this._owner._selection)},setSelected:function(t){var e=this._owner;e.changeSelection&&e.changeSelection(2,t)}}))}),p=r.extend({_class:"Matrix",initialize:function ot(t){var e=arguments.length,n=!0;if(6===e?this.set.apply(this,arguments):1===e?t instanceof ot?this.set(t._a,t._b,t._c,t._d,t._tx,t._ty):Array.isArray(t)?this.set.apply(this,t):n=!1:0===e?this.reset():n=!1,!n)throw new Error("Unsupported matrix parameters")},set:function(t,e,n,i,r,s,a){return this._a=t,this._b=e,this._c=n,this._d=i,this._tx=r,this._ty=s,a||this._changed(),this},_serialize:function(t,e){return r.serialize(this.getValues(),t,!0,e)},_changed:function(){var t=this._owner;t&&(t._applyMatrix?t.transform(null,!0):t._changed(9))},clone:function(){return new p(this._a,this._b,this._c,this._d,this._tx,this._ty)},equals:function(t){return t===this||t&&this._a===t._a&&this._b===t._b&&this._c===t._c&&this._d===t._d&&this._tx===t._tx&&this._ty===t._ty},toString:function(){var t=h.instance;return"[["+[t.number(this._a),t.number(this._c),t.number(this._tx)].join(", ")+"], ["+[t.number(this._b),t.number(this._d),t.number(this._ty)].join(", ")+"]]"},reset:function(t){return this._a=this._d=1,this._b=this._c=this._tx=this._ty=0,t||this._changed(),this},apply:function(t,e){var n=this._owner;return!!n&&(n.transform(null,!0,r.pick(t,!0),e),this.isIdentity())},translate:function(){var t=c.read(arguments),e=t.x,n=t.y;return this._tx+=e*this._a+n*this._c,
this._ty+=e*this._b+n*this._d,this._changed(),this},scale:function(){var t=c.read(arguments),e=c.read(arguments,0,{readNull:!0});return e&&this.translate(e),this._a*=t.x,this._b*=t.x,this._c*=t.y,this._d*=t.y,e&&this.translate(e.negate()),this._changed(),this},rotate:function(t){t*=Math.PI/180;var e=c.read(arguments,1),n=e.x,i=e.y,r=Math.cos(t),s=Math.sin(t),a=n-n*r+i*s,o=i-n*s-i*r,h=this._a,u=this._b,l=this._c,f=this._d;return this._a=r*h+s*l,this._b=r*u+s*f,this._c=-s*h+r*l,this._d=-s*u+r*f,this._tx+=a*h+o*l,this._ty+=a*u+o*f,this._changed(),this},shear:function(){var t=c.read(arguments),e=c.read(arguments,0,{readNull:!0});e&&this.translate(e);var n=this._a,i=this._b;return this._a+=t.y*this._c,this._b+=t.y*this._d,this._c+=t.x*n,this._d+=t.x*i,e&&this.translate(e.negate()),this._changed(),this},skew:function(){var t=c.read(arguments),e=c.read(arguments,0,{readNull:!0}),n=Math.PI/180,i=new c(Math.tan(t.x*n),Math.tan(t.y*n));return this.shear(i,e)},append:function(t){if(t){var e=this._a,n=this._b,i=this._c,r=this._d,s=t._a,a=t._c,o=t._b,h=t._d,u=t._tx,l=t._ty;this._a=s*e+o*i,this._c=a*e+h*i,this._b=s*n+o*r,this._d=a*n+h*r,this._tx+=u*e+l*i,this._ty+=u*n+l*r,this._changed()}return this},prepend:function(t){if(t){var e=this._a,n=this._b,i=this._c,r=this._d,s=this._tx,a=this._ty,o=t._a,h=t._c,u=t._b,l=t._d,c=t._tx,f=t._ty;this._a=o*e+h*n,this._c=o*i+h*r,this._b=u*e+l*n,this._d=u*i+l*r,this._tx=o*s+h*a+c,this._ty=u*s+l*a+f,this._changed()}return this},appended:function(t){return this.clone().append(t)},prepended:function(t){return this.clone().prepend(t)},invert:function(){var t=this._a,e=this._b,n=this._c,i=this._d,r=this._tx,s=this._ty,a=t*i-e*n,o=null;return a&&!isNaN(a)&&isFinite(r)&&isFinite(s)&&(this._a=i/a,this._b=-e/a,this._c=-n/a,this._d=t/a,this._tx=(n*s-i*r)/a,this._ty=(e*r-t*s)/a,o=this),o},inverted:function(){return this.clone().invert()},concatenate:"#append",preConcatenate:"#prepend",chain:"#appended",_shiftless:function(){return new p(this._a,this._b,this._c,this._d,0,0)},_orNullIfIdentity:function(){return this.isIdentity()?null:this},isIdentity:function(){return 1===this._a&&0===this._b&&0===this._c&&1===this._d&&0===this._tx&&0===this._ty},isInvertible:function(){var t=this._a*this._d-this._c*this._b;return t&&!isNaN(t)&&isFinite(this._tx)&&isFinite(this._ty)},isSingular:function(){return!this.isInvertible()},transform:function(t,e,n){return arguments.length<3?this._transformPoint(c.read(arguments)):this._transformCoordinates(t,e,n)},_transformPoint:function(t,e,n){var i=t.x,r=t.y;return e||(e=new c),e.set(i*this._a+r*this._c+this._tx,i*this._b+r*this._d+this._ty,n)},_transformCoordinates:function(t,e,n){for(var i=0,r=2*n;i<r;i+=2){var s=t[i],a=t[i+1];e[i]=s*this._a+a*this._c+this._tx,e[i+1]=s*this._b+a*this._d+this._ty}return e},_transformCorners:function(t){var e=t.x,n=t.y,i=e+t.width,r=n+t.height,s=[e,n,i,n,i,r,e,r];return this._transformCoordinates(s,s,4)},_transformBounds:function(t,e,n){for(var i=this._transformCorners(t),r=i.slice(0,2),s=r.slice(),a=2;a<8;a++){var o=i[a],h=1&a;o<r[h]?r[h]=o:o>s[h]&&(s[h]=o)}return e||(e=new g),e.set(r[0],r[1],s[0]-r[0],s[1]-r[1],n)},inverseTransform:function(){return this._inverseTransform(c.read(arguments))},_inverseTransform:function(t,e,n){var i=this._a,r=this._b,s=this._c,a=this._d,o=this._tx,h=this._ty,u=i*a-r*s,l=null;if(u&&!isNaN(u)&&isFinite(o)&&isFinite(h)){var f=t.x-this._tx,d=t.y-this._ty;e||(e=new c),l=e.set((f*a-d*s)/u,(d*i-f*r)/u,n)}return l},decompose:function(){var t,e,n,i=this._a,r=this._b,s=this._c,a=this._d,o=i*a-r*s,h=Math.sqrt,u=Math.atan2,l=180/Math.PI;if(0!==i||0!==r){var f=h(i*i+r*r);t=Math.acos(i/f)*(r>0?1:-1),e=[f,o/f],n=[u(i*s+r*a,f*f),0]}else if(0!==s||0!==a){var d=h(s*s+a*a);t=Math.asin(s/d)*(a>0?1:-1),e=[o/d,d],n=[0,u(i*s+r*a,d*d)]}else t=0,n=e=[0,0];return{translation:this.getTranslation(),rotation:t*l,scaling:new c(e),skewing:new c(n[0]*l,n[1]*l)}},getValues:function(){return[this._a,this._b,this._c,this._d,this._tx,this._ty]},getTranslation:function(){return new c(this._tx,this._ty)},getScaling:function(){return(this.decompose()||{}).scaling},getRotation:function(){return(this.decompose()||{}).rotation},applyToContext:function(t){this.isIdentity()||t.transform(this._a,this._b,this._c,this._d,this._tx,this._ty)}},r.each(["a","b","c","d","tx","ty"],function(t){var e=r.capitalize(t),n="_"+t;this["get"+e]=function(){return this[n]},this["set"+e]=function(t){this[n]=t,this._changed()}},{})),m=r.extend({_class:"Line",initialize:function(t,e,n,i,r){var s=!1;arguments.length>=4?(this._px=t,this._py=e,this._vx=n,this._vy=i,s=r):(this._px=t.x,this._py=t.y,this._vx=e.x,this._vy=e.y,s=n),s||(this._vx-=this._px,this._vy-=this._py)},getPoint:function(){return new c(this._px,this._py)},getVector:function(){return new c(this._vx,this._vy)},getLength:function(){return this.getVector().getLength()},intersect:function(t,e){return m.intersect(this._px,this._py,this._vx,this._vy,t._px,t._py,t._vx,t._vy,!0,e)},getSide:function(t,e){return m.getSide(this._px,this._py,this._vx,this._vy,t.x,t.y,!0,e)},getDistance:function(t){return Math.abs(m.getSignedDistance(this._px,this._py,this._vx,this._vy,t.x,t.y,!0))},isCollinear:function(t){return c.isCollinear(this._vx,this._vy,t._vx,t._vy)},isOrthogonal:function(t){return c.isOrthogonal(this._vx,this._vy,t._vx,t._vy)},statics:{intersect:function(t,e,n,i,r,s,a,o,h,l){h||(n-=t,i-=e,a-=r,o-=s);var f=n*o-i*a;if(!u.isZero(f)){var d=t-r,_=e-s,g=(a*_-o*d)/f,v=(n*_-i*d)/f,p=1e-12,m=-p,y=1+p;if(l||m<g&&g<y&&m<v&&v<y)return l||(g=g<=0?0:g>=1?1:g),new c(t+g*n,e+g*i)}},getSide:function(t,e,n,i,r,s,a,o){a||(n-=t,i-=e);var h=r-t,u=s-e,l=h*i-u*n;return 0!==l||o||(l=(h*n+h*n)/(n*n+i*i),l>=0&&l<=1&&(l=0)),l<0?-1:l>0?1:0},getSignedDistance:function(t,e,n,i,r,s,a){return a||(n-=t,i-=e),0===n?i>0?r-t:t-r:0===i?n<0?s-e:e-s:((r-t)*i-(s-e)*n)/Math.sqrt(n*n+i*i)}}}),y=o.extend({_class:"Project",_list:"projects",_reference:"project",_compactSerialize:!0,initialize:function(t){o.call(this,!0),this._children=[],this._namedChildren={},this._activeLayer=null,this._currentStyle=new V(null,null,this),this._view=Z.create(this,t||tt.getCanvas(1,1)),this._selectionItems={},this._selectionCount=0,this._updateVersion=0},_serialize:function(t,e){return r.serialize(this._children,t,!0,e)},_changed:function(t,e){if(1&t){var n=this._view;n&&(n._needsUpdate=!0,!n._requested&&n._autoUpdate&&n.requestUpdate())}var i=this._changes;if(i&&e){var r=this._changesById,s=e._id,a=r[s];a?a.flags|=t:i.push(r[s]={item:e,flags:t})}},clear:function(){for(var t=this._children,e=t.length-1;e>=0;e--)t[e].remove()},isEmpty:function(){return 0===this._children.length},remove:function ht(){return!!ht.base.call(this)&&(this._view&&this._view.remove(),!0)},getView:function(){return this._view},getCurrentStyle:function(){return this._currentStyle},setCurrentStyle:function(t){this._currentStyle.initialize(t)},getIndex:function(){return this._index},getOptions:function(){return this._scope.settings},getLayers:function(){return this._children},getActiveLayer:function(){return this._activeLayer||new b({project:this,insert:!0})},getSymbolDefinitions:function(){var t=[],e={};return this.getItems({"class":k,match:function(n){var i=n._definition,r=i._id;return e[r]||(e[r]=!0,t.push(i)),!1}}),t},getSymbols:"getSymbolDefinitions",getSelectedItems:function(){var t=this._selectionItems,e=[];for(var n in t){var i=t[n],r=i._selection;1&r&&i.isInserted()?e.push(i):r||this._updateSelection(i)}return e},_updateSelection:function(t){var e=t._id,n=this._selectionItems;t._selection?n[e]!==t&&(this._selectionCount++,n[e]=t):n[e]===t&&(this._selectionCount--,delete n[e])},selectAll:function(){for(var t=this._children,e=0,n=t.length;e<n;e++)t[e].setFullySelected(!0)},deselectAll:function(){var t=this._selectionItems;for(var e in t)t[e].setFullySelected(!1)},addLayer:function(t){return this.insertLayer(e,t)},insertLayer:function(t,e){if(e instanceof b){e._remove(!1,!0),r.splice(this._children,[e],t,0),e._setProject(this,!0);var n=e._name;n&&e.setName(n),this._changes&&e._changed(5),this._activeLayer||(this._activeLayer=e)}else e=null;return e},_insertItem:function(t,n,i,r){return n=this.insertLayer(t,n)||(this._activeLayer||this._insertItem(e,new b(w.NO_INSERT),!0,!0)).insertChild(t,n,i),r&&n.activate&&n.activate(),n},getItems:function(t){return w._getItems(this,t)},getItem:function(t){return w._getItems(this,t,null,null,!0)[0]||null},importJSON:function(t){this.activate();var e=this._activeLayer;return r.importJSON(t,e&&e.isEmpty()&&e)},removeOn:function(t){var e=this._removeSets;if(e){"mouseup"===t&&(e.mousedrag=null);var n=e[t];if(n){for(var i in n){var r=n[i];for(var s in e){var a=e[s];a&&a!=n&&delete a[r._id]}r.remove()}e[t]=null}}},draw:function(t,e,n){this._updateVersion++,t.save(),e.applyToContext(t);for(var i=this._children,s=new r({offset:new c(0,0),pixelRatio:n,viewMatrix:e.isIdentity()?null:e,matrices:[new p],updateMatrix:!0}),a=0,o=i.length;a<o;a++)i[a].draw(t,s);if(t.restore(),this._selectionCount>0){t.save(),t.strokeWidth=1;var h=this._selectionItems,u=this._scope.settings.handleSize,l=this._updateVersion;for(var f in h)h[f]._drawSelection(t,e,u,h,l);t.restore()}}}),w=r.extend(s,{statics:{extend:function ut(t){return t._serializeFields&&(t._serializeFields=r.set({},this.prototype._serializeFields,t._serializeFields)),ut.base.apply(this,arguments)},NO_INSERT:{insert:!1}},_class:"Item",_name:null,_applyMatrix:!0,_canApplyMatrix:!0,_canScaleStroke:!1,_pivot:null,_visible:!0,_blendMode:"normal",_opacity:1,_locked:!1,_guide:!1,_clipMask:!1,_selection:0,_selectBounds:!0,_selectChildren:!1,_serializeFields:{name:null,applyMatrix:null,matrix:new p,pivot:null,visible:!0,blendMode:"normal",opacity:1,locked:!1,guide:!1,clipMask:!1,selected:!1,data:{}}},new function(){var t=["onMouseDown","onMouseUp","onMouseDrag","onClick","onDoubleClick","onMouseMove","onMouseEnter","onMouseLeave"];return r.each(t,function(t){this._events[t]={install:function(t){this.getView()._countItemEvent(t,1)},uninstall:function(t){this.getView()._countItemEvent(t,-1)}}},{_events:{onFrame:{install:function(){this.getView()._animateItem(this,!0)},uninstall:function(){this.getView()._animateItem(this,!1)}},onLoad:{},onError:{}},statics:{_itemHandlers:t}})},{initialize:function(){},_initialize:function(t,n){var i=t&&r.isPlainObject(t),s=i&&t.internal===!0,a=this._matrix=new p,o=i&&t.project||paper.project,h=paper.settings;return this._id=s?null:l.get(),this._parent=this._index=null,this._applyMatrix=this._canApplyMatrix&&h.applyMatrix,n&&a.translate(n),a._owner=this,this._style=new V(o._currentStyle,this,o),s||i&&t.insert===!1||!h.insertItems&&(!i||t.insert!==!0)?this._setProject(o):(i&&t.parent||o)._insertItem(e,this,!0,!0),i&&t!==w.NO_INSERT&&r.filter(this,t,{internal:!0,insert:!0,project:!0,parent:!0}),i},_serialize:function(t,e){function n(n){for(var a in n){var o=s[a];r.equals(o,"leading"===a?1.2*n.fontSize:n[a])||(i[a]=r.serialize(o,t,"data"!==a,e))}}var i={},s=this;return n(this._serializeFields),this instanceof x||n(this._style._defaults),[this._class,i]},_changed:function(t){var n=this._symbol,i=this._parent||n,r=this._project;8&t&&(this._bounds=this._position=this._decomposed=this._globalMatrix=e),i&&40&t&&w._clearBoundsCache(i),2&t&&w._clearBoundsCache(this),r&&r._changed(t,this),n&&n._changed(t)},set:function(t){return t&&this._set(t),this},getId:function(){return this._id},getName:function(){return this._name},setName:function(t){if(this._name&&this._removeNamed(),t===+t+"")throw new Error("Names consisting only of numbers are not supported.");var n=this._getOwner();if(t&&n){var i=n._children,r=n._namedChildren;(r[t]=r[t]||[]).push(this),t in i||(i[t]=this)}this._name=t||e,this._changed(128)},getStyle:function(){return this._style},setStyle:function(t){this.getStyle().set(t)}},r.each(["locked","visible","blendMode","opacity","guide"],function(t){var e=r.capitalize(t),t="_"+t;this["get"+e]=function(){return this[t]},this["set"+e]=function(e){e!=this[t]&&(this[t]=e,this._changed("_locked"===t?128:129))}},{}),{beans:!0,getSelection:function(){return this._selection},setSelection:function(t){if(t!==this._selection){this._selection=t;var e=this._project;e&&(e._updateSelection(this),this._changed(129))}},changeSelection:function(t,e){var n=this._selection;this.setSelection(e?n|t:n&~t)},isSelected:function(){if(this._selectChildren)for(var t=this._children,e=0,n=t.length;e<n;e++)if(t[e].isSelected())return!0;return!!(1&this._selection)},setSelected:function(t){if(this._selectChildren)for(var e=this._children,n=0,i=e.length;n<i;n++)e[n].setSelected(t);this.changeSelection(1,t)},isFullySelected:function(){var t=this._children,e=!!(1&this._selection);if(t&&e){for(var n=0,i=t.length;n<i;n++)if(!t[n].isFullySelected())return!1;return!0}return e},setFullySelected:function(t){var e=this._children;if(e)for(var n=0,i=e.length;n<i;n++)e[n].setFullySelected(t);this.changeSelection(1,t)},isClipMask:function(){return this._clipMask},setClipMask:function(t){this._clipMask!=(t=!!t)&&(this._clipMask=t,t&&(this.setFillColor(null),this.setStrokeColor(null)),this._changed(129),this._parent&&this._parent._changed(1024))},getData:function(){return this._data||(this._data={}),this._data},setData:function(t){this._data=t},getPosition:function(t){var e=this._position,n=t?c:f;if(!e){var i=this._pivot;e=this._position=i?this._matrix._transformPoint(i):this.getBounds().getCenter(!0)}return new n(e.x,e.y,this,"setPosition")},setPosition:function(){this.translate(c.read(arguments).subtract(this.getPosition(!0)))},getPivot:function(t){var e=this._pivot;if(e){var n=t?c:f;e=new n(e.x,e.y,this,"setPivot")}return e},setPivot:function(){this._pivot=c.read(arguments,0,{clone:!0,readNull:!0}),this._position=e}},r.each({getStrokeBounds:{stroke:!0},getHandleBounds:{handle:!0},getInternalBounds:{internal:!0}},function(t,e){this[e]=function(e){return this.getBounds(e,t)}},{beans:!0,getBounds:function(t,e){var n=e||t instanceof p,i=r.set({},n?e:t,this._boundsOptions);i.stroke&&!this.getStrokeScaling()||(i.cacheItem=this);var s=this._getCachedBounds(n&&t,i);return 0===arguments.length?new v(s.x,s.y,s.width,s.height,this,"setBounds"):s},setBounds:function(){var t=g.read(arguments),e=this.getBounds(),n=this._matrix,i=new p,r=t.getCenter();i.translate(r),t.width==e.width&&t.height==e.height||(n.isInvertible()||(n.initialize(n._backup||(new p).translate(n.getTranslation())),e=this.getBounds()),i.scale(0!==e.width?t.width/e.width:0,0!==e.height?t.height/e.height:0)),r=e.getCenter(),i.translate(-r.x,-r.y),this.transform(i)},_getBounds:function(t,e){var n=this._children;return n&&0!==n.length?(w._updateBoundsCache(this,e.cacheItem),w._getBounds(n,t,e)):new g},_getCachedBounds:function(t,e){t=t&&t._orNullIfIdentity();var n=e.internal,i=e.cacheItem,r=n?null:this._matrix._orNullIfIdentity(),s=i&&(!t||t.equals(r))&&[e.stroke?1:0,e.handle?1:0,n?1:0].join("");if(w._updateBoundsCache(this._parent||this._symbol,i),s&&this._bounds&&s in this._bounds)return this._bounds[s].rect.clone();var a=this._getBounds(t||r,e);if(s){this._bounds||(this._bounds={});this._bounds[s]={rect:a.clone(),internal:e.internal}}return a},_getStrokeMatrix:function(t,e){var n=this.getStrokeScaling()?null:e&&e.internal?this:this._parent||this._symbol&&this._symbol._item,i=n?n.getViewMatrix().invert():t;return i&&i._shiftless()},statics:{_updateBoundsCache:function(t,e){if(t&&e){var n=e._id,i=t._boundsCache=t._boundsCache||{ids:{},list:[]};i.ids[n]||(i.list.push(e),i.ids[n]=e)}},_clearBoundsCache:function(t){var n=t._boundsCache;if(n){t._bounds=t._position=t._boundsCache=e;for(var i=0,r=n.list,s=r.length;i<s;i++){var a=r[i];a!==t&&(a._bounds=a._position=e,a._boundsCache&&w._clearBoundsCache(a))}}},_getBounds:function(t,e,n){var i=1/0,r=-i,s=i,a=r;n=n||{};for(var o=0,h=t.length;o<h;o++){var u=t[o];if(u._visible&&!u.isEmpty()){var l=u._getCachedBounds(e&&e.appended(u._matrix),n);i=Math.min(l.x,i),s=Math.min(l.y,s),r=Math.max(l.x+l.width,r),a=Math.max(l.y+l.height,a)}}return isFinite(i)?new g(i,s,r-i,a-s):new g}}}),{beans:!0,_decompose:function(){return this._decomposed||(this._decomposed=this._matrix.decompose())},getRotation:function(){var t=this._decompose();return t&&t.rotation},setRotation:function(t){var e=this.getRotation();null!=e&&null!=t&&this.rotate(t-e)},getScaling:function(t){var e=this._decompose(),n=e&&e.scaling,i=t?c:f;return n&&new i(n.x,n.y,this,"setScaling")},setScaling:function(){var t=this.getScaling(),e=c.read(arguments,0,{clone:!0,readNull:!0});t&&e&&this.scale(e.x/t.x,e.y/t.y)},getMatrix:function(){return this._matrix},setMatrix:function(){var t=this._matrix;t.initialize.apply(t,arguments)},getGlobalMatrix:function(t){var e=this._globalMatrix,n=this._project._updateVersion;if(e&&e._updateVersion!==n&&(e=null),!e){e=this._globalMatrix=this._matrix.clone();var i=this._parent;i&&e.prepend(i.getGlobalMatrix(!0)),e._updateVersion=n}return t?e:e.clone()},getViewMatrix:function(){return this.getGlobalMatrix().prepend(this.getView()._matrix)},getApplyMatrix:function(){return this._applyMatrix},setApplyMatrix:function(t){(this._applyMatrix=this._canApplyMatrix&&!!t)&&this.transform(null,!0)},getTransformContent:"#getApplyMatrix",setTransformContent:"#setApplyMatrix"},{getProject:function(){return this._project},_setProject:function(t,e){if(this._project!==t){this._project&&this._installEvents(!1),this._project=t;for(var n=this._children,i=0,r=n&&n.length;i<r;i++)n[i]._setProject(t);e=!0}e&&this._installEvents(!0)},getView:function(){return this._project._view},_installEvents:function lt(t){lt.base.call(this,t);for(var e=this._children,n=0,i=e&&e.length;n<i;n++)e[n]._installEvents(t)},getLayer:function(){for(var t=this;t=t._parent;)if(t instanceof b)return t;return null},getParent:function(){return this._parent},setParent:function(t){return t.addChild(this)},_getOwner:"#getParent",getChildren:function(){return this._children},setChildren:function(t,e){this.removeChildren(),this.addChildren(t,e)},getFirstChild:function(){return this._children&&this._children[0]||null},getLastChild:function(){return this._children&&this._children[this._children.length-1]||null},getNextSibling:function(){var t=this._getOwner();return t&&t._children[this._index+1]||null},getPreviousSibling:function(){var t=this._getOwner();return t&&t._children[this._index-1]||null},getIndex:function(){return this._index},equals:function(t){return t===this||t&&this._class===t._class&&this._style.equals(t._style)&&this._matrix.equals(t._matrix)&&this._locked===t._locked&&this._visible===t._visible&&this._blendMode===t._blendMode&&this._opacity===t._opacity&&this._clipMask===t._clipMask&&this._guide===t._guide&&this._equals(t)||!1},_equals:function(t){return r.equals(this._children,t._children)},clone:function(t){var n=new this.constructor(w.NO_INSERT),i=this._children,s=r.pick(t?t.insert:e,t===e||t===!0),a=r.pick(t?t.deep:e,!0);i&&n.copyAttributes(this),i&&!a||n.copyContent(this),i||n.copyAttributes(this),s&&n.insertAbove(this);var o=this._name,h=this._parent;if(o&&h){for(var i=h._children,u=o,l=1;i[o];)o=u+" "+l++;o!==u&&n.setName(o)}return n},copyContent:function(t){for(var e=t._children,n=0,i=e&&e.length;n<i;n++)this.addChild(e[n].clone(!1),!0)},copyAttributes:function(t,e){this.setStyle(t._style);for(var n=["_locked","_visible","_blendMode","_opacity","_clipMask","_guide"],i=0,s=n.length;i<s;i++){var a=n[i];t.hasOwnProperty(a)&&(this[a]=t[a])}e||this._matrix.initialize(t._matrix),this.setApplyMatrix(t._applyMatrix),this.setPivot(t._pivot),this.setSelection(t._selection);var o=t._data,h=t._name;this._data=o?r.clone(o):null,h&&this.setName(h)},rasterize:function(t,n){var i=this.getStrokeBounds(),s=(t||this.getView().getResolution())/72,a=i.getTopLeft().floor(),o=i.getBottomRight().ceil(),h=new d(o.subtract(a)),u=new S(w.NO_INSERT);if(!h.isZero()){var l=tt.getCanvas(h.multiply(s)),c=l.getContext("2d"),f=(new p).scale(s).translate(a.negate());c.save(),f.applyToContext(c),this.draw(c,new r({matrices:[f]})),c.restore(),u.setCanvas(l)}return u.transform((new p).translate(a.add(h.divide(2))).scale(1/s)),(n===e||n)&&u.insertAbove(this),u},contains:function(){return!!this._contains(this._matrix._inverseTransform(c.read(arguments)))},_contains:function(t){var e=this._children;if(e){for(var n=e.length-1;n>=0;n--)if(e[n].contains(t))return!0;return!1}return t.isInside(this.getInternalBounds())},isInside:function(){return g.read(arguments).contains(this.getBounds())},_asPathItem:function(){return new E.Rectangle({rectangle:this.getInternalBounds(),matrix:this._matrix,insert:!1})},intersects:function(t,e){return t instanceof w&&this._asPathItem().getIntersections(t._asPathItem(),null,e,!0).length>0}},new function(){function t(){return this._hitTest(c.read(arguments),P.getOptions(arguments))}function e(){var t=c.read(arguments),e=P.getOptions(arguments),n=e.match,i=[];return e=r.set({},e,{match:function(t){n&&!n(t)||i.push(t)}}),this._hitTest(t,e),i}function n(t,e,n,i){var r=this._children;if(r)for(var s=r.length-1;s>=0;s--){var a=r[s],o=a!==i&&a._hitTest(t,e,n);if(o)return o}return null}return y.inject({hitTest:t,hitTestAll:e,_hitTest:n}),{hitTest:t,hitTestAll:e,_hitTestChildren:n}},{_hitTest:function(t,e,n){function i(t){return!g||t&&g(t)?t:null}function s(e,n){var i=c["get"+n]();if(t.subtract(i).divide(l).length<=1)return new P(e,v,{name:r.hyphenate(n),point:i})}if(this._locked||!this._visible||this._guide&&!e.guides||this.isEmpty())return null;var a=this._matrix,o=n?n.appended(a):this.getGlobalMatrix().prepend(this.getView()._matrix),h=this.getStrokeScaling()?null:o.inverted()._shiftless(),u=Math.max(e.tolerance,1e-6),l=e._tolerancePadding=new d(E._getStrokePadding(u,h));if(t=a._inverseTransform(t),!t||!this._children&&!this.getBounds({internal:!0,stroke:!0,handle:!0}).expand(l.multiply(2))._containsPoint(t))return null;var c,f,_=!(e.guides&&!this._guide||e.selected&&!this.isSelected()||e.type&&e.type!==r.hyphenate(this._class)||e["class"]&&!(this instanceof e["class"])),g=e.match,v=this;if(_&&(e.center||e.bounds)&&this._parent){if(c=this.getInternalBounds(),e.center&&(f=s("center","Center")),!f&&e.bounds)for(var p=["TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],m=0;m<8&&!f;m++)f=s("bounds",p[m]);f=i(f)}return f||(f=this._hitTestChildren(t,e,o)||_&&i(this._hitTestSelf(t,e,o,h))||null),f&&f.point&&(f.point=a.transform(f.point)),f},_hitTestSelf:function(t,e){if(e.fill&&this.hasFill()&&this._contains(t))return new P("fill",this)},matches:function(t,e){function n(t,e){for(var i in t)if(t.hasOwnProperty(i)){var s=t[i],a=e[i];if(r.isPlainObject(s)&&r.isPlainObject(a)){if(!n(s,a))return!1}else if(!r.equals(s,a))return!1}return!0}var i=typeof t;if("object"===i){for(var s in t)if(t.hasOwnProperty(s)&&!this.matches(s,t[s]))return!1;return!0}if("function"===i)return t(this);if("match"===t)return e(this);var a=/^(empty|editable)$/.test(t)?this["is"+r.capitalize(t)]():"type"===t?r.hyphenate(this._class):this[t];if("class"===t){if("function"==typeof e)return this instanceof e;a=this._class}if("function"==typeof e)return!!e(a);if(e){if(e.test)return e.test(a);if(r.isPlainObject(e))return n(e,a)}return r.equals(a,e)},getItems:function(t){return w._getItems(this,t,this._matrix)},getItem:function(t){return w._getItems(this,t,this._matrix,null,!0)[0]||null},statics:{_getItems:function ct(t,e,n,i,s){if(!i){var a="object"==typeof e&&e,o=a&&a.overlapping,h=a&&a.inside,u=o||h,l=u&&g.read([u]);i={items:[],recursive:a&&a.recursive!==!1,inside:!!h,overlapping:!!o,rect:l,path:o&&new E.Rectangle({rectangle:l,insert:!1})},a&&(e=r.filter({},e,{recursive:!0,inside:!0,overlapping:!0}))}var c=t._children,f=i.items,l=i.rect;n=l&&(n||new p);for(var d=0,_=c&&c.length;d<_;d++){var v=c[d],m=n&&n.appended(v._matrix),y=!0;if(l){var u=v.getBounds(m);if(!l.intersects(u))continue;l.contains(u)||i.overlapping&&(u.contains(l)||i.path.intersects(v,m))||(y=!1)}if(y&&v.matches(e)&&(f.push(v),s))break;if(i.recursive!==!1&&ct(v,e,m,i,s),s&&f.length>0)break}return f}}},{importJSON:function(t){var e=r.importJSON(t,this);return e!==this?this.addChild(e):e},addChild:function(t,n){return this.insertChild(e,t,n)},insertChild:function(t,e,n){var i=e?this.insertChildren(t,[e],n):null;return i&&i[0]},addChildren:function(t,e){return this.insertChildren(this._children.length,t,e)},insertChildren:function(t,e,n,i){var s=this._children;if(s&&e&&e.length>0){e=Array.prototype.slice.apply(e);for(var a=e.length-1;a>=0;a--){var o=e[a];o&&(!i||o instanceof i)?o._remove(!1,!0):e.splice(a,1)}r.splice(s,e,t,0);for(var h=this._project,u=h._changes,a=0,l=e.length;a<l;a++){var o=e[a],c=o._name;o._parent=this,o._setProject(h,!0),c&&o.setName(c),u&&this._changed(5)}this._changed(11)}else e=null;return e},_insertItem:"#insertChild",_insertAt:function(t,e,n){var i=this;if(i!==t){var r=t&&t._getOwner();r?(i._remove(!1,!0),r._insertItem(t._index+e,i,n)):i=null}return i},insertAbove:function(t,e){return this._insertAt(t,1,e)},insertBelow:function(t,e){return this._insertAt(t,0,e)},sendToBack:function(){var t=this._getOwner();return t?t._insertItem(0,this):null},bringToFront:function(){var t=this._getOwner();return t?t._insertItem(e,this):null},appendTop:"#addChild",appendBottom:function(t){return this.insertChild(0,t)},moveAbove:"#insertAbove",moveBelow:"#insertBelow",copyTo:function(t){return t._insertItem(e,this.clone(!1))},reduce:function(t){var e=this._children;if(e&&1===e.length){var n=e[0].reduce(t);return this._parent?(n.insertAbove(this),this.remove()):n.remove(),n}return this},_removeNamed:function(){var t=this._getOwner();if(t){var e=t._children,n=t._namedChildren,i=this._name,r=n[i],s=r?r.indexOf(this):-1;s!==-1&&(e[i]==this&&delete e[i],r.splice(s,1),r.length?e[i]=r[0]:delete n[i])}},_remove:function(t,e){var n=this._getOwner(),i=this._project,s=this._index;return!!n&&(null!=s&&(i._activeLayer===this&&(i._activeLayer=this.getNextSibling()||this.getPreviousSibling()),r.splice(n._children,null,s,1)),this._name&&this._removeNamed(),this._installEvents(!1),t&&i._changes&&this._changed(5),e&&n._changed(11,this),this._parent=null,!0)},remove:function(){return this._remove(!0,!0)},replaceWith:function(t){var e=t&&t.insertBelow(this);return e&&this.remove(),e},removeChildren:function(t,e){if(!this._children)return null;t=t||0,e=r.pick(e,this._children.length);for(var n=r.splice(this._children,null,t,e-t),i=n.length-1;i>=0;i--)n[i]._remove(!0,!1);return n.length>0&&this._changed(11),n},clear:"#removeChildren",reverseChildren:function(){if(this._children){this._children.reverse();for(var t=0,e=this._children.length;t<e;t++)this._children[t]._index=t;this._changed(11)}},isEmpty:function(){return!this._children||0===this._children.length},isEditable:function(){for(var t=this;t;){if(!t._visible||t._locked)return!1;t=t._parent}return!0},hasFill:function(){return this.getStyle().hasFill()},hasStroke:function(){return this.getStyle().hasStroke()},hasShadow:function(){return this.getStyle().hasShadow()},_getOrder:function(t){function e(t){var e=[];do e.unshift(t);while(t=t._parent);return e}for(var n=e(this),i=e(t),r=0,s=Math.min(n.length,i.length);r<s;r++)if(n[r]!=i[r])return n[r]._index<i[r]._index?1:-1;return 0},hasChildren:function(){return this._children&&this._children.length>0},isInserted:function(){return!!this._parent&&this._parent.isInserted()},isAbove:function(t){return this._getOrder(t)===-1},isBelow:function(t){return 1===this._getOrder(t)},isParent:function(t){return this._parent===t},isChild:function(t){return t&&t._parent===this},isDescendant:function(t){for(var e=this;e=e._parent;)if(e===t)return!0;return!1},isAncestor:function(t){return!!t&&t.isDescendant(this)},isSibling:function(t){return this._parent===t._parent},isGroupedWith:function(t){for(var e=this._parent;e;){if(e._parent&&/^(Group|Layer|CompoundPath)$/.test(e._class)&&t.isDescendant(e))return!0;e=e._parent}return!1}},r.each(["rotate","scale","shear","skew"],function(t){var e="rotate"===t;this[t]=function(){var n=(e?r:c).read(arguments),i=c.read(arguments,0,{readNull:!0});return this.transform((new p)[t](n,i||this.getPosition(!0)))}},{translate:function(){var t=new p;return this.transform(t.translate.apply(t,arguments))},transform:function(t,e,n,i){t&&t.isIdentity()&&(t=null);var r=this._matrix,s=(e||this._applyMatrix)&&(!r.isIdentity()||t||e&&n&&this._children);if(!t&&!s)return this;if(t&&(!t.isInvertible()&&r.isInvertible()&&(r._backup=r.getValues()),r.prepend(t)),s=s&&this._transformContent(r,n,i)){var a=this._pivot,o=this._style,h=o.getFillColor(!0),u=o.getStrokeColor(!0);a&&r._transformPoint(a,a,!0),h&&h.transform(r),u&&u.transform(r),r.reset(!0),i&&this._canApplyMatrix&&(this._applyMatrix=!0)}var l=this._bounds,c=this._position;this._changed(9);var f=l&&t&&t.decompose();if(f&&!f.shearing&&f.rotation%90===0){for(var d in l){var _=l[d];if(s||!_.internal){var g=_.rect;t._transformBounds(g,g)}}var v=this._boundsGetter,g=l[v&&v.getBounds||v||"getBounds"];g&&(this._position=g.getCenter(!0)),this._bounds=l}else t&&c&&(this._position=t._transformPoint(c,c));return this},_transformContent:function(t,e,n){var i=this._children;if(i){for(var r=0,s=i.length;r<s;r++)i[r].transform(t,!0,e,n);return!0}},globalToLocal:function(){return this.getGlobalMatrix(!0)._inverseTransform(c.read(arguments))},localToGlobal:function(){return this.getGlobalMatrix(!0)._transformPoint(c.read(arguments))},parentToLocal:function(){return this._matrix._inverseTransform(c.read(arguments))},localToParent:function(){return this._matrix._transformPoint(c.read(arguments))},fitBounds:function(t,e){t=g.read(arguments);var n=this.getBounds(),i=n.height/n.width,r=t.height/t.width,s=(e?i>r:i<r)?t.width/n.width:t.height/n.height,a=new g(new c,new d(n.width*s,n.height*s));a.setCenter(t.getCenter()),this.setBounds(a)}}),{_setStyles:function(t,e,n){var i=this._style;if(i.hasFill()&&(t.fillStyle=i.getFillColor().toCanvasStyle(t)),i.hasStroke()){t.strokeStyle=i.getStrokeColor().toCanvasStyle(t),t.lineWidth=i.getStrokeWidth();var r=i.getStrokeJoin(),s=i.getStrokeCap(),a=i.getMiterLimit();if(r&&(t.lineJoin=r),s&&(t.lineCap=s),a&&(t.miterLimit=a),paper.support.nativeDash){var o=i.getDashArray(),h=i.getDashOffset();o&&o.length&&("setLineDash"in t?(t.setLineDash(o),t.lineDashOffset=h):(t.mozDash=o,t.mozDashOffset=h))}}if(i.hasShadow()){var u=e.pixelRatio||1,l=n._shiftless().prepend((new p).scale(u,u)),f=l.transform(new c(i.getShadowBlur(),0)),d=l.transform(this.getShadowOffset());t.shadowColor=i.getShadowColor().toCanvasStyle(t),t.shadowBlur=f.getLength(),t.shadowOffsetX=d.x,t.shadowOffsetY=d.y}},draw:function(t,e,n){var i=this._updateVersion=this._project._updateVersion;if(this._visible&&0!==this._opacity){var r=e.matrices,s=e.viewMatrix,a=this._matrix,o=r[r.length-1].appended(a);if(o.isInvertible()){s=s?s.appended(o):o,r.push(o),e.updateMatrix&&(o._updateVersion=i,this._globalMatrix=o);var h,u,l,c=this._blendMode,f=this._opacity,d="normal"===c,_=et.nativeModes[c],g=d&&1===f||e.dontStart||e.clip||(_||d&&f<1)&&this._canComposite(),v=e.pixelRatio||1;if(!g){var p=this.getStrokeBounds(s);if(!p.width||!p.height)return;l=e.offset,u=e.offset=p.getTopLeft().floor(),h=t,t=tt.getContext(p.getSize().ceil().add(1).multiply(v)),1!==v&&t.scale(v,v)}t.save();var m=n?n.appended(a):this._canScaleStroke&&!this.getStrokeScaling(!0)&&s,y=!g&&e.clipItem,w=!m||y;if(g?(t.globalAlpha=f,_&&(t.globalCompositeOperation=c)):w&&t.translate(-u.x,-u.y),w&&(g?a:s).applyToContext(t),y&&e.clipItem.draw(t,e.extend({clip:!0})),m){t.setTransform(v,0,0,v,0,0);var x=e.offset;x&&t.translate(-x.x,-x.y)}this._draw(t,e,s,m),t.restore(),r.pop(),e.clip&&!e.dontFinish&&t.clip(),g||(et.process(c,t,h,f,u.subtract(l).multiply(v)),tt.release(t),e.offset=l)}}},_isUpdated:function(t){var e=this._parent;if(e instanceof L)return e._isUpdated(t);var n=this._updateVersion===t;return!n&&e&&e._visible&&e._isUpdated(t)&&(this._updateVersion=t,n=!0),n},_drawSelection:function(t,e,n,i,r){var s=this._selection,a=1&s,o=2&s||a&&this._selectBounds,h=4&s;if(this._drawSelected||(a=!1),
(a||o||h)&&this._isUpdated(r)){var u,l=this.getSelectedColor(!0)||(u=this.getLayer())&&u.getSelectedColor(!0),c=e.appended(this.getGlobalMatrix(!0)),f=n/2;if(t.strokeStyle=t.fillStyle=l?l.toCanvasStyle(t):"#009dec",a&&this._drawSelected(t,c,i),h){var d=this.getPosition(!0),_=d.x,g=d.y;t.beginPath(),t.arc(_,g,f,0,2*Math.PI,!0),t.stroke();for(var v=[[0,-1],[1,0],[0,1],[-1,0]],p=f,m=n+1,y=0;y<4;y++){var w=v[y],x=w[0],b=w[1];t.moveTo(_+x*p,g+b*p),t.lineTo(_+x*m,g+b*m),t.stroke()}}if(o){var C=c._transformCorners(this.getInternalBounds());t.beginPath();for(var y=0;y<8;y++)t[0===y?"moveTo":"lineTo"](C[y],C[++y]);t.closePath(),t.stroke();for(var y=0;y<8;y++)t.fillRect(C[y]-f,C[++y]-f,n,n)}}},_canComposite:function(){return!1}},r.each(["down","drag","up","move"],function(t){this["removeOn"+r.capitalize(t)]=function(){var e={};return e[t]=!0,this.removeOn(e)}},{removeOn:function(t){for(var e in t)if(t[e]){var n="mouse"+e,i=this._project,r=i._removeSets=i._removeSets||{};r[n]=r[n]||{},r[n][this._id]=this}return this}})),x=w.extend({_class:"Group",_selectBounds:!1,_selectChildren:!0,_serializeFields:{children:[]},initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||this.addChildren(Array.isArray(t)?t:arguments)},_changed:function ft(t){ft.base.call(this,t),1026&t&&(this._clipItem=e)},_getClipItem:function(){var t=this._clipItem;if(t===e){t=null;for(var n=this._children,i=0,r=n.length;i<r;i++)if(n[i]._clipMask){t=n[i];break}this._clipItem=t}return t},isClipped:function(){return!!this._getClipItem()},setClipped:function(t){var e=this.getFirstChild();e&&e.setClipMask(t)},_getBounds:function dt(t,e){var n=this._getClipItem();return n?n._getCachedBounds(t&&t.appended(n._matrix),r.set({},e,{stroke:!1})):dt.base.call(this,t,e)},_hitTestChildren:function _t(t,e,n){var i=this._getClipItem();return(!i||i.contains(t))&&_t.base.call(this,t,e,n,i)},_draw:function(t,e){var n=e.clip,i=!n&&this._getClipItem();e=e.extend({clipItem:i,clip:!1}),n?(t.beginPath(),e.dontStart=e.dontFinish=!0):i&&i.draw(t,e.extend({clip:!0}));for(var r=this._children,s=0,a=r.length;s<a;s++){var o=r[s];o!==i&&o.draw(t,e)}}}),b=x.extend({_class:"Layer",initialize:function(){x.apply(this,arguments)},_getOwner:function(){return this._parent||null!=this._index&&this._project},isInserted:function gt(){return this._parent?gt.base.call(this):null!=this._index},activate:function(){this._project._activeLayer=this},_hitTestSelf:function(){}}),C=w.extend({_class:"Shape",_applyMatrix:!1,_canApplyMatrix:!1,_canScaleStroke:!0,_serializeFields:{type:null,size:null,radius:null},initialize:function(t){this._initialize(t)},_equals:function(t){return this._type===t._type&&this._size.equals(t._size)&&r.equals(this._radius,t._radius)},copyContent:function(t){this.setType(t._type),this.setSize(t._size),this.setRadius(t._radius)},getType:function(){return this._type},setType:function(t){this._type=t},getShape:"#getType",setShape:"#setType",getSize:function(){var t=this._size;return new _(t.width,t.height,this,"setSize")},setSize:function(){var t=d.read(arguments);if(this._size){if(!this._size.equals(t)){var e=this._type,n=t.width,i=t.height;if("rectangle"===e){var r=d.min(this._radius,t.divide(2));this._radius.set(r.width,r.height)}else"circle"===e?(n=i=(n+i)/2,this._radius=n/2):"ellipse"===e&&this._radius.set(n/2,i/2);this._size.set(n,i),this._changed(9)}}else this._size=t.clone()},getRadius:function(){var t=this._radius;return"circle"===this._type?t:new _(t.width,t.height,this,"setRadius")},setRadius:function(t){var e=this._type;if("circle"===e){if(t===this._radius)return;var n=2*t;this._radius=t,this._size.set(n,n)}else if(t=d.read(arguments),this._radius){if(this._radius.equals(t))return;if(this._radius.set(t.width,t.height),"rectangle"===e){var n=d.max(this._size,t.multiply(2));this._size.set(n.width,n.height)}else"ellipse"===e&&this._size.set(2*t.width,2*t.height)}else this._radius=t.clone();this._changed(9)},isEmpty:function(){return!1},toPath:function(t){var n=new(E[r.capitalize(this._type)])({center:new c,size:this._size,radius:this._radius,insert:!1});return n.copyAttributes(this),paper.settings.applyMatrix&&n.setApplyMatrix(!0),(t===e||t)&&n.insertAbove(this),n},toShape:"#clone",_draw:function(t,e,n,i){var r=this._style,s=r.hasFill(),a=r.hasStroke(),o=e.dontFinish||e.clip,h=!i;if(s||a||o){var u=this._type,l=this._radius,c="circle"===u;if(e.dontStart||t.beginPath(),h&&c)t.arc(0,0,l,0,2*Math.PI,!0);else{var f=c?l:l.width,d=c?l:l.height,_=this._size,g=_.width,v=_.height;if(h&&"rectangle"===u&&0===f&&0===d)t.rect(-g/2,-v/2,g,v);else{var p=g/2,m=v/2,y=.44771525016920644,w=f*y,x=d*y,b=[-p,-m+d,-p,-m+x,-p+w,-m,-p+f,-m,p-f,-m,p-w,-m,p,-m+x,p,-m+d,p,m-d,p,m-x,p-w,m,p-f,m,-p+f,m,-p+w,m,-p,m-x,-p,m-d];i&&i.transform(b,b,32),t.moveTo(b[0],b[1]),t.bezierCurveTo(b[2],b[3],b[4],b[5],b[6],b[7]),p!==f&&t.lineTo(b[8],b[9]),t.bezierCurveTo(b[10],b[11],b[12],b[13],b[14],b[15]),m!==d&&t.lineTo(b[16],b[17]),t.bezierCurveTo(b[18],b[19],b[20],b[21],b[22],b[23]),p!==f&&t.lineTo(b[24],b[25]),t.bezierCurveTo(b[26],b[27],b[28],b[29],b[30],b[31])}}t.closePath()}o||!s&&!a||(this._setStyles(t,e,n),s&&(t.fill(r.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),a&&t.stroke())},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_getBounds:function(t,e){var n=new g(this._size).setCenter(0,0),i=this._style,r=e.stroke&&i.hasStroke()&&i.getStrokeWidth();return t&&(n=t._transformBounds(n)),r?n.expand(E._getStrokePadding(r,this._getStrokeMatrix(t,e))):n}},new function(){function t(t,e,n){var i=t._radius;if(!i.isZero())for(var r=t._size.divide(2),s=0;s<4;s++){var a=new c(1&s?1:-1,s>1?1:-1),o=a.multiply(r),h=o.subtract(a.multiply(i)),u=new g(o,h);if((n?u.expand(n):u).contains(e))return h}}function e(t,e,n,i){var r=t.divide(e);return(!i||r.quadrant===i)&&r.subtract(r.normalize()).multiply(e).divide(n).length<=1}return{_contains:function n(e){if("rectangle"===this._type){var i=t(this,e);return i?e.subtract(i).divide(this._radius).getLength()<=1:n.base.call(this,e)}return e.divide(this.size).getLength()<=.5},_hitTestSelf:function i(n,r,s,a){var o=!1,h=this._style,u=r.stroke&&h.hasStroke(),l=r.fill&&h.hasFill();if(u||l){var c=this._type,f=this._radius,d=u?h.getStrokeWidth()/2:0,_=r._tolerancePadding.add(E._getStrokePadding(d,!h.getStrokeScaling()&&a));if("rectangle"===c){var v=_.multiply(2),p=t(this,n,v);if(p)o=e(n.subtract(p),f,_,p.getQuadrant());else{var m=new g(this._size).setCenter(0,0),y=m.expand(v),w=m.expand(v.negate());o=y._containsPoint(n)&&!w._containsPoint(n)}}else o=e(n,f,_)}return o?new P(u?"stroke":"fill",this):i.base.apply(this,arguments)}}},{statics:new function(){function t(t,e,n,i,s){var a=new C(r.getNamed(s));return a._type=t,a._size=n,a._radius=i,a.translate(e)}return{Circle:function(){var e=c.readNamed(arguments,"center"),n=r.readNamed(arguments,"radius");return t("circle",e,new d(2*n),n,arguments)},Rectangle:function(){var e=g.readNamed(arguments,"rectangle"),n=d.min(d.readNamed(arguments,"radius"),e.getSize(!0).divide(2));return t("rectangle",e.getCenter(!0),e.getSize(!0),n,arguments)},Ellipse:function(){var e=C._readEllipse(arguments),n=e.radius;return t("ellipse",e.center,n.multiply(2),n,arguments)},_readEllipse:function(t){var e,n;if(r.hasNamed(t,"radius"))e=c.readNamed(t,"center"),n=d.readNamed(t,"radius");else{var i=g.readNamed(t,"rectangle");e=i.getCenter(!0),n=i.getSize(!0).divide(2)}return{center:e,radius:n}}}}}),S=w.extend({_class:"Raster",_applyMatrix:!1,_canApplyMatrix:!1,_boundsOptions:{stroke:!1,handle:!1},_serializeFields:{crossOrigin:null,source:null},initialize:function(t,n){if(!this._initialize(t,n!==e&&c.read(arguments,1))){var r="string"==typeof t?i.getElementById(t):t;r?this.setImage(r):this.setSource(t)}this._size||(this._size=new d,this._loaded=!1)},_equals:function(t){return this.getSource()===t.getSource()},copyContent:function(t){var e=t._image,n=t._canvas;if(e)this._setImage(e);else if(n){var i=tt.getCanvas(t._size);i.getContext("2d").drawImage(n,0,0),this._setImage(i)}this._crossOrigin=t._crossOrigin},getSize:function(){var t=this._size;return new _(t?t.width:0,t?t.height:0,this,"setSize")},setSize:function(){var t=d.read(arguments);if(!t.equals(this._size))if(t.width>0&&t.height>0){var e=this.getElement();this._setImage(tt.getCanvas(t)),e&&this.getContext(!0).drawImage(e,0,0,t.width,t.height)}else this._canvas&&tt.release(this._canvas),this._size=t.clone()},getWidth:function(){return this._size?this._size.width:0},setWidth:function(t){this.setSize(t,this.getHeight())},getHeight:function(){return this._size?this._size.height:0},setHeight:function(t){this.setSize(this.getWidth(),t)},getLoaded:function(){return this._loaded},isEmpty:function(){var t=this._size;return!t||0===t.width&&0===t.height},getResolution:function(){var t=this._matrix,e=new c(0,0).transform(t),n=new c(1,0).transform(t).subtract(e),i=new c(0,1).transform(t).subtract(e);return new d(72/n.getLength(),72/i.getLength())},getPpi:"#getResolution",getImage:function(){return this._image},setImage:function(t){function e(t){var e=n.getView(),i=t&&t.type||"load";e&&n.responds(i)&&(paper=e._scope,n.emit(i,new G(t)))}var n=this;this._setImage(t),this._loaded?setTimeout(e,0):t&&U.add(t,{load:function(i){n._setImage(t),e(i)},error:e})},_setImage:function(t){this._canvas&&tt.release(this._canvas),t&&t.getContext?(this._image=null,this._canvas=t,this._loaded=!0):(this._image=t,this._canvas=null,this._loaded=!!(t&&t.src&&t.complete)),this._size=new d(t?t.naturalWidth||t.width:0,t?t.naturalHeight||t.height:0),this._context=null,this._changed(521)},getCanvas:function(){if(!this._canvas){var t=tt.getContext(this._size);try{this._image&&t.drawImage(this._image,0,0),this._canvas=t.canvas}catch(e){tt.release(t)}}return this._canvas},setCanvas:"#setImage",getContext:function(t){return this._context||(this._context=this.getCanvas().getContext("2d")),t&&(this._image=null,this._changed(513)),this._context},setContext:function(t){this._context=t},getSource:function(){var t=this._image;return t&&t.src||this.toDataURL()},setSource:function(t){var e=new n.Image,i=this._crossOrigin;i&&(e.crossOrigin=i),e.src=t,this.setImage(e)},getCrossOrigin:function(){var t=this._image;return t&&t.crossOrigin||this._crossOrigin||""},setCrossOrigin:function(t){this._crossOrigin=t;var e=this._image;e&&(e.crossOrigin=t)},getElement:function(){return this._canvas||this._loaded&&this._image}},{beans:!1,getSubCanvas:function(){var t=g.read(arguments),e=tt.getContext(t.getSize());return e.drawImage(this.getCanvas(),t.x,t.y,t.width,t.height,0,0,t.width,t.height),e.canvas},getSubRaster:function(){var t=g.read(arguments),e=new S(w.NO_INSERT);return e._setImage(this.getSubCanvas(t)),e.translate(t.getCenter().subtract(this.getSize().divide(2))),e._matrix.prepend(this._matrix),e.insertAbove(this),e},toDataURL:function(){var t=this._image,e=t&&t.src;if(/^data:/.test(e))return e;var n=this.getCanvas();return n?n.toDataURL.apply(n,arguments):null},drawImage:function(t){var e=c.read(arguments,1);this.getContext(!0).drawImage(t,e.x,e.y)},getAverageColor:function(t){var e,n;if(t?t instanceof O?(n=t,e=t.getBounds()):"object"==typeof t&&("width"in t?e=new g(t):"x"in t&&(e=new g(t.x-.5,t.y-.5,1,1))):e=this.getBounds(),!e)return null;var i=32,s=Math.min(e.width,i),a=Math.min(e.height,i),o=S._sampleContext;o?o.clearRect(0,0,i+1,i+1):o=S._sampleContext=tt.getContext(new d(i)),o.save();var h=(new p).scale(s/e.width,a/e.height).translate(-e.x,-e.y);h.applyToContext(o),n&&n.draw(o,new r({clip:!0,matrices:[h]})),this._matrix.applyToContext(o);var u=this.getElement(),l=this._size;u&&o.drawImage(u,-l.width/2,-l.height/2),o.restore();for(var c=o.getImageData(.5,.5,Math.ceil(s),Math.ceil(a)).data,f=[0,0,0],_=0,v=0,m=c.length;v<m;v+=4){var y=c[v+3];_+=y,y/=255,f[0]+=c[v]*y,f[1]+=c[v+1]*y,f[2]+=c[v+2]*y}for(var v=0;v<3;v++)f[v]/=_;return _?D.read(f):null},getPixel:function(){var t=c.read(arguments),e=this.getContext().getImageData(t.x,t.y,1,1).data;return new D("rgb",[e[0]/255,e[1]/255,e[2]/255],e[3]/255)},setPixel:function(){var t=c.read(arguments),e=D.read(arguments),n=e._convert("rgb"),i=e._alpha,r=this.getContext(!0),s=r.createImageData(1,1),a=s.data;a[0]=255*n[0],a[1]=255*n[1],a[2]=255*n[2],a[3]=null!=i?255*i:255,r.putImageData(s,t.x,t.y)},createImageData:function(){var t=d.read(arguments);return this.getContext().createImageData(t.width,t.height)},getImageData:function(){var t=g.read(arguments);return t.isEmpty()&&(t=new g(this._size)),this.getContext().getImageData(t.x,t.y,t.width,t.height)},setImageData:function(t){var e=c.read(arguments,1);this.getContext(!0).putImageData(t,e.x,e.y)},_getBounds:function(t,e){var n=new g(this._size).setCenter(0,0);return t?t._transformBounds(n):n},_hitTestSelf:function(t){if(this._contains(t)){var e=this;return new P("pixel",e,{offset:t.add(e._size.divide(2)).round(),color:{get:function(){return e.getPixel(this.offset)}}})}},_draw:function(t){var e=this.getElement();e&&(t.globalAlpha=this._opacity,t.drawImage(e,-this._size.width/2,-this._size.height/2))},_canComposite:function(){return!0}}),k=w.extend({_class:"SymbolItem",_applyMatrix:!1,_canApplyMatrix:!1,_boundsOptions:{stroke:!0},_serializeFields:{symbol:null},initialize:function(t,n){this._initialize(t,n!==e&&c.read(arguments,1))||this.setDefinition(t instanceof I?t:new I(t))},_equals:function(t){return this._definition===t._definition},copyContent:function(t){this.setDefinition(t._definition)},getDefinition:function(){return this._definition},setDefinition:function(t){this._definition=t,this._changed(9)},getSymbol:"#getDefinition",setSymbol:"#setDefinition",isEmpty:function(){return this._definition._item.isEmpty()},_getBounds:function(t,e){var n=this._definition._item;return n._getCachedBounds(n._matrix.prepended(t),e)},_hitTestSelf:function(t,e,n,i){var r=this._definition._item._hitTest(t,e,n);return r&&(r.item=this),r},_draw:function(t,e){this._definition._item.draw(t,e)}}),I=r.extend({_class:"SymbolDefinition",initialize:function(t,e){this._id=l.get(),this.project=paper.project,t&&this.setItem(t,e)},_serialize:function(t,e){return e.add(this,function(){return r.serialize([this._class,this._item],t,!1,e)})},_changed:function(t){8&t&&w._clearBoundsCache(this),1&t&&this.project._changed(t)},getItem:function(){return this._item},setItem:function(t,e){t._symbol&&(t=t.clone()),this._item&&(this._item._symbol=null),this._item=t,t.remove(),t.setSelected(!1),e||t.setPosition(new c),t._symbol=this,this._changed(9)},getDefinition:"#getItem",setDefinition:"#setItem",place:function(t){return new k(this,t)},clone:function(){return new I(this._item.clone(!1))},equals:function(t){return t===this||t&&this._item.equals(t._item)||!1}}),P=r.extend({_class:"HitResult",initialize:function(t,e,n){this.type=t,this.item=e,n&&(n.enumerable=!0,this.inject(n))},statics:{getOptions:function(t){var e=t&&r.read(t);return r.set({type:null,tolerance:paper.settings.hitTolerance,fill:!e,stroke:!e,segments:!e,handles:!1,ends:!1,center:!1,bounds:!1,guides:!1,selected:!1},e)}}}),M=r.extend({_class:"Segment",beans:!0,_selection:0,initialize:function(t,n,i,r,s,a){var o,h,u,l,c=arguments.length;0===c||(1===c?t&&"point"in t?(o=t.point,h=t.handleIn,u=t.handleOut,l=t.selection):o=t:null==t||"object"==typeof t?(o=t,h=n,u=i,l=r):(o=t!==e?[t,n]:null,h=i!==e?[i,r]:null,u=s!==e?[s,a]:null)),new A(o,this,"_point"),new A(h,this,"_handleIn"),new A(u,this,"_handleOut"),l&&this.setSelection(l)},_serialize:function(t,e){var n=this._point,i=this._selection,s=i||this.hasHandles()?[n,this._handleIn,this._handleOut]:n;return i&&s.push(i),r.serialize(s,t,!0,e)},_changed:function(t){var e=this._path;if(e){var n,i=e._curves,r=this._index;i&&(t&&t!==this._point&&t!==this._handleIn||!(n=r>0?i[r-1]:e._closed?i[i.length-1]:null)||n._changed(),t&&t!==this._point&&t!==this._handleOut||!(n=i[r])||n._changed()),e._changed(25)}},getPoint:function(){return this._point},setPoint:function(){var t=c.read(arguments);this._point.set(t.x,t.y)},getHandleIn:function(){return this._handleIn},setHandleIn:function(){var t=c.read(arguments);this._handleIn.set(t.x,t.y)},getHandleOut:function(){return this._handleOut},setHandleOut:function(){var t=c.read(arguments);this._handleOut.set(t.x,t.y)},hasHandles:function(){return!this._handleIn.isZero()||!this._handleOut.isZero()},clearHandles:function(){this._handleIn.set(0,0),this._handleOut.set(0,0)},getSelection:function(){return this._selection},setSelection:function(t){var e=this._selection,n=this._path;this._selection=t=t||0,n&&t!==e&&(n._updateSelection(this,e,t),n._changed(129))},changeSelection:function(t,e){var n=this._selection;this.setSelection(e?n|t:n&~t)},isSelected:function(){return!!(7&this._selection)},setSelected:function(t){this.changeSelection(7,t)},getIndex:function(){return this._index!==e?this._index:null},getPath:function(){return this._path||null},getCurve:function(){var t=this._path,e=this._index;return t?(e>0&&!t._closed&&e===t._segments.length-1&&e--,t.getCurves()[e]||null):null},getLocation:function(){var t=this.getCurve();return t?new z(t,this===t._segment1?0:1):null},getNext:function(){var t=this._path&&this._path._segments;return t&&(t[this._index+1]||this._path._closed&&t[0])||null},smooth:function(t,n,i){var r=t||{},s=r.type,a=r.factor,o=this.getPrevious(),h=this.getNext(),u=(o||this)._point,l=this._point,f=(h||this)._point,d=u.getDistance(l),_=l.getDistance(f);if(s&&"catmull-rom"!==s){if("geometric"!==s)throw new Error("Smoothing method '"+s+"' not supported.");if(o&&h){var g=u.subtract(f),v=a===e?.4:a,p=v*d/(d+_);n||this.setHandleIn(g.multiply(p)),i||this.setHandleOut(g.multiply(p-v))}}else{var m=a===e?.5:a,y=Math.pow(d,m),w=y*y,x=Math.pow(_,m),b=x*x;if(!n&&o){var C=2*b+3*x*y+w,S=3*x*(x+y);this.setHandleIn(0!==S?new c((b*u._x+C*l._x-w*f._x)/S-l._x,(b*u._y+C*l._y-w*f._y)/S-l._y):new c)}if(!i&&h){var C=2*w+3*y*x+b,S=3*y*(y+x);this.setHandleOut(0!==S?new c((w*f._x+C*l._x-b*u._x)/S-l._x,(w*f._y+C*l._y-b*u._y)/S-l._y):new c)}}},getPrevious:function(){var t=this._path&&this._path._segments;return t&&(t[this._index-1]||this._path._closed&&t[t.length-1])||null},isFirst:function(){return 0===this._index},isLast:function(){var t=this._path;return t&&this._index===t._segments.length-1||!1},reverse:function(){var t=this._handleIn,e=this._handleOut,n=t._x,i=t._y;t.set(e._x,e._y),e.set(n,i)},reversed:function(){return new M(this._point,this._handleOut,this._handleIn)},remove:function(){return!!this._path&&!!this._path.removeSegment(this._index)},clone:function(){return new M(this._point,this._handleIn,this._handleOut)},equals:function(t){return t===this||t&&this._class===t._class&&this._point.equals(t._point)&&this._handleIn.equals(t._handleIn)&&this._handleOut.equals(t._handleOut)||!1},toString:function(){var t=["point: "+this._point];return this._handleIn.isZero()||t.push("handleIn: "+this._handleIn),this._handleOut.isZero()||t.push("handleOut: "+this._handleOut),"{ "+t.join(", ")+" }"},transform:function(t){this._transformCoordinates(t,new Array(6),!0),this._changed()},interpolate:function(t,e,n){var i=1-n,r=n,s=t._point,a=e._point,o=t._handleIn,h=e._handleIn,u=e._handleOut,l=t._handleOut;this._point.set(i*s._x+r*a._x,i*s._y+r*a._y,!0),this._handleIn.set(i*o._x+r*h._x,i*o._y+r*h._y,!0),this._handleOut.set(i*l._x+r*u._x,i*l._y+r*u._y,!0),this._changed()},_transformCoordinates:function(t,e,n){var i=this._point,r=n&&this._handleIn.isZero()?null:this._handleIn,s=n&&this._handleOut.isZero()?null:this._handleOut,a=i._x,o=i._y,h=2;return e[0]=a,e[1]=o,r&&(e[h++]=r._x+a,e[h++]=r._y+o),s&&(e[h++]=s._x+a,e[h++]=s._y+o),t&&(t._transformCoordinates(e,e,h/2),a=e[0],o=e[1],n?(i._x=a,i._y=o,h=2,r&&(r._x=e[h++]-a,r._y=e[h++]-o),s&&(s._x=e[h++]-a,s._y=e[h++]-o)):(r||(e[h++]=a,e[h++]=o),s||(e[h++]=a,e[h++]=o))),e}}),A=c.extend({initialize:function(t,n,i){var r,s,a;if(t)if((r=t[0])!==e)s=t[1];else{var o=t;(r=o.x)===e&&(o=c.read(arguments),r=o.x),s=o.y,a=o.selected}else r=s=0;this._x=r,this._y=s,this._owner=n,n[i]=this,a&&this.setSelected(!0)},set:function(t,e){return this._x=t,this._y=e,this._owner._changed(this),this},getX:function(){return this._x},setX:function(t){this._x=t,this._owner._changed(this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner._changed(this)},isZero:function(){return u.isZero(this._x)&&u.isZero(this._y)},isSelected:function(){return!!(this._owner._selection&this._getSelection())},setSelected:function(t){this._owner.changeSelection(this._getSelection(),t)},_getSelection:function(){var t=this._owner;return this===t._point?1:this===t._handleIn?2:this===t._handleOut?4:0}}),T=r.extend({_class:"Curve",initialize:function(t,e,n,i,r,s,a,o){var h,u,l,c,f,d,_=arguments.length;3===_?(this._path=t,h=e,u=n):0===_?(h=new M,u=new M):1===_?"segment1"in t?(h=new M(t.segment1),u=new M(t.segment2)):"point1"in t?(l=t.point1,f=t.handle1,d=t.handle2,c=t.point2):Array.isArray(t)&&(l=[t[0],t[1]],c=[t[6],t[7]],f=[t[2]-t[0],t[3]-t[1]],d=[t[4]-t[6],t[5]-t[7]]):2===_?(h=new M(t),u=new M(e)):4===_?(l=t,f=e,d=n,c=i):8===_&&(l=[t,e],c=[a,o],f=[n-t,i-e],d=[r-a,s-o]),this._segment1=h||new M(l,null,f),this._segment2=u||new M(c,d,null)},_serialize:function(t,e){return r.serialize(this.hasHandles()?[this.getPoint1(),this.getHandle1(),this.getHandle2(),this.getPoint2()]:[this.getPoint1(),this.getPoint2()],t,!0,e)},_changed:function(){this._length=this._bounds=e},clone:function(){return new T(this._segment1,this._segment2)},toString:function(){var t=["point1: "+this._segment1._point];return this._segment1._handleOut.isZero()||t.push("handle1: "+this._segment1._handleOut),this._segment2._handleIn.isZero()||t.push("handle2: "+this._segment2._handleIn),t.push("point2: "+this._segment2._point),"{ "+t.join(", ")+" }"},remove:function(){var t=!1;if(this._path){var e=this._segment2,n=e._handleOut;t=e.remove(),t&&this._segment1._handleOut.set(n.x,n.y)}return t},getPoint1:function(){return this._segment1._point},setPoint1:function(){var t=c.read(arguments);this._segment1._point.set(t.x,t.y)},getPoint2:function(){return this._segment2._point},setPoint2:function(){var t=c.read(arguments);this._segment2._point.set(t.x,t.y)},getHandle1:function(){return this._segment1._handleOut},setHandle1:function(){var t=c.read(arguments);this._segment1._handleOut.set(t.x,t.y)},getHandle2:function(){return this._segment2._handleIn},setHandle2:function(){var t=c.read(arguments);this._segment2._handleIn.set(t.x,t.y)},getSegment1:function(){return this._segment1},getSegment2:function(){return this._segment2},getPath:function(){return this._path},getIndex:function(){return this._segment1._index},getNext:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index+1]||this._path._closed&&t[0])||null},getPrevious:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index-1]||this._path._closed&&t[t.length-1])||null},isFirst:function(){return 0===this._segment1._index},isLast:function(){var t=this._path;return t&&this._segment1._index===t._curves.length-1||!1},isSelected:function(){return this.getPoint1().isSelected()&&this.getHandle2().isSelected()&&this.getHandle2().isSelected()&&this.getPoint2().isSelected()},setSelected:function(t){this.getPoint1().setSelected(t),this.getHandle1().setSelected(t),this.getHandle2().setSelected(t),this.getPoint2().setSelected(t)},getValues:function(t){return T.getValues(this._segment1,this._segment2,t)},getPoints:function(){for(var t=this.getValues(),e=[],n=0;n<8;n+=2)e.push(new c(t[n],t[n+1]));return e},getLength:function(){return null==this._length&&(this._length=T.getLength(this.getValues(),0,1)),this._length},getArea:function(){return T.getArea(this.getValues())},getLine:function(){return new m(this._segment1._point,this._segment2._point)},getPart:function(t,e){return new T(T.getPart(this.getValues(),t,e))},getPartLength:function(t,e){return T.getLength(this.getValues(),t,e)},getIntersections:function(t){return T._getIntersections(this.getValues(),t&&t!==this?t.getValues():null,this,t,[],{})},divideAt:function(t){return this.divideAtTime(t&&t.curve===this?t.time:t)},divideAtTime:function(t,e){var n=4e-7,i=1-n,r=null;if(t>=n&&t<=i){var s=T.subdivide(this.getValues(),t),a=s[0],o=s[1],h=e||this.hasHandles(),u=this._segment1,l=this._segment2,f=this._path;h&&(u._handleOut.set(a[2]-a[0],a[3]-a[1]),l._handleIn.set(o[4]-o[6],o[5]-o[7]));var d=a[6],_=a[7],g=new M(new c(d,_),h&&new c(a[4]-d,a[5]-_),h&&new c(o[2]-d,o[3]-_));f?(f.insert(u._index+1,g),r=this.getNext()):(this._segment2=g,this._changed(),r=new T(g,l))}return r},splitAt:function(t){return this._path?this._path.splitAt(t):null},splitAtTime:function(t){return this.splitAt(this.getLocationAtTime(t))},divide:function(t,n){return this.divideAtTime(t===e?.5:n?t:this.getTimeAt(t))},split:function(t,n){return this.splitAtTime(t===e?.5:n?t:this.getTimeAt(t))},reversed:function(){return new T(this._segment2.reversed(),this._segment1.reversed())},clearHandles:function(){this._segment1._handleOut.set(0,0),this._segment2._handleIn.set(0,0)},statics:{getValues:function(t,e,n){var i=t._point,r=t._handleOut,s=e._handleIn,a=e._point,o=[i._x,i._y,i._x+r._x,i._y+r._y,a._x+s._x,a._y+s._y,a._x,a._y];return n&&n._transformCoordinates(o,o,4),o},subdivide:function(t,n){var i=t[0],r=t[1],s=t[2],a=t[3],o=t[4],h=t[5],u=t[6],l=t[7];n===e&&(n=.5);var c=1-n,f=c*i+n*s,d=c*r+n*a,_=c*s+n*o,g=c*a+n*h,v=c*o+n*u,p=c*h+n*l,m=c*f+n*_,y=c*d+n*g,w=c*_+n*v,x=c*g+n*p,b=c*m+n*w,C=c*y+n*x;return[[i,r,f,d,m,y,b,C],[b,C,w,x,v,p,u,l]]},solveCubic:function(t,e,n,i,r,s){var a=t[e],o=t[e+2],h=t[e+4],l=t[e+6],c=0;if(!(a<n&&l<n&&o<n&&h<n||a>n&&l>n&&o>n&&h>n)){var f=3*(o-a),d=3*(h-o)-f,_=l-a-f-d;c=u.solveCubic(_,d,f,a-n,i,r,s)}return c},getTimeOf:function(t,e){var n=new c(t[0],t[1]),i=new c(t[6],t[7]),r=1e-12,s=e.isClose(n,r)?0:e.isClose(i,r)?1:null;if(null!==s)return s;for(var a=[e.x,e.y],o=[],h=2e-7,u=0;u<2;u++)for(var l=T.solveCubic(t,u,a[u],o,0,1),f=0;f<l;f++)if(s=o[f],e.isClose(T.getPoint(t,s),h))return s;return e.isClose(n,h)?0:e.isClose(i,h)?1:null},getNearestTime:function(t,e){function n(n){if(n>=0&&n<=1){var i=e.getDistance(T.getPoint(t,n),!0);if(i<d)return d=i,_=n,!0}}if(T.isStraight(t)){var i=t[0],r=t[1],s=t[6],a=t[7],o=s-i,h=a-r,u=o*o+h*h;if(0===u)return 0;var l=((e.x-i)*o+(e.y-r)*h)/u;return l<1e-12?0:l>.999999999999?1:T.getTimeOf(t,new c(i+l*o,r+l*h))}for(var f=100,d=1/0,_=0,g=0;g<=f;g++)n(g/f);for(var v=1/(2*f);v>4e-7;)n(_-v)||n(_+v)||(v/=2);return _},getPart:function(t,e,n){var i=e>n;if(i){var r=e;e=n,n=r}return e>0&&(t=T.subdivide(t,e)[1]),n<1&&(t=T.subdivide(t,(n-e)/(1-e))[0]),i?[t[6],t[7],t[4],t[5],t[2],t[3],t[0],t[1]]:t},isFlatEnough:function(t,e){var n=t[0],i=t[1],r=t[2],s=t[3],a=t[4],o=t[5],h=t[6],u=t[7],l=3*r-2*n-h,c=3*s-2*i-u,f=3*a-2*h-n,d=3*o-2*u-i;return Math.max(l*l,f*f)+Math.max(c*c,d*d)<=16*e*e},getArea:function(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7];return 3*((h-n)*(i+s)-(o-e)*(r+a)+r*(e-s)-i*(n-a)+h*(s+e/3)-o*(a+n/3))/20},getBounds:function(t){for(var e=t.slice(0,2),n=e.slice(),i=[0,0],r=0;r<2;r++)T._addBounds(t[r],t[r+2],t[r+4],t[r+6],r,0,e,n,i);return new g(e[0],e[1],n[0]-e[0],n[1]-e[1])},_addBounds:function(t,e,n,i,r,s,a,o,h){function l(t,e){var n=t-e,i=t+e;n<a[r]&&(a[r]=n),i>o[r]&&(o[r]=i)}s/=2;var c=a[r]-s,f=o[r]+s;if(t<c||e<c||n<c||i<c||t>f||e>f||n>f||i>f)if(e<t!=e<i&&n<t!=n<i)l(t,s),l(i,s);else{var d=3*(e-n)-t+i,_=2*(t+n)-4*e,g=e-t,v=u.solveQuadratic(d,_,g,h),p=4e-7,m=1-p;l(i,0);for(var y=0;y<v;y++){var w=h[y],x=1-w;p<w&&w<m&&l(x*x*x*t+3*x*x*w*e+3*x*w*w*n+w*w*w*i,s)}}}}},r.each(["getBounds","getStrokeBounds","getHandleBounds"],function(t){this[t]=function(){this._bounds||(this._bounds={});var e=this._bounds[t];return e||(e=this._bounds[t]=E[t]([this._segment1,this._segment2],!1,this._path)),e.clone()}},{}),r.each({isStraight:function(t,e,n){if(e.isZero()&&n.isZero())return!0;var i=t.getVector(),r=2e-7;if(i.isZero())return!1;if(t.getDistance(e)<r&&t.getDistance(n)<r){var s=i.dot(i),a=i.dot(e)/s,o=i.dot(n)/s;return a>=0&&a<=1&&o<=0&&o>=-1}return!1},isLinear:function(t,e,n){var i=t.getVector().divide(3);return e.equals(i)&&n.negate().equals(i)}},function(t,e){this[e]=function(){var e=this._segment1,n=this._segment2;return t(new m(e._point,n._point),e._handleOut,n._handleIn)},this.statics[e]=function(e){var n=e[0],i=e[1],r=e[6],s=e[7];return t(new m(n,i,r,s),new c(e[2]-n,e[3]-i),new c(e[4]-r,e[5]-s))}},{statics:{},hasHandles:function(){return!this._segment1._handleOut.isZero()||!this._segment2._handleIn.isZero()},isCollinear:function(t){return t&&this.isStraight()&&t.isStraight()&&this.getLine().isCollinear(t.getLine())},isHorizontal:function(){return this.isStraight()&&Math.abs(this.getTangentAtTime(.5).y)<1e-7},isVertical:function(){return this.isStraight()&&Math.abs(this.getTangentAtTime(.5).x)<1e-7}}),{beans:!1,getLocationAt:function(t,e){return this.getLocationAtTime(e?t:this.getTimeAt(t))},getLocationAtTime:function(t){return null!=t&&t>=0&&t<=1?new z(this,t):null},getTimeAt:function(t,e){return T.getTimeAt(this.getValues(),t,e)},getParameterAt:"#getTimeAt",getOffsetAtTime:function(t){return this.getPartLength(0,t)},getLocationOf:function(){return this.getLocationAtTime(this.getTimeOf(c.read(arguments)))},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getTimeOf:function(){return T.getTimeOf(this.getValues(),c.read(arguments))},getParameterOf:"#getTimeOf",getNearestLocation:function(){var t=c.read(arguments),e=this.getValues(),n=T.getNearestTime(e,t),i=T.getPoint(e,n);return new z(this,n,i,null,t.getDistance(i))},getNearestPoint:function(){var t=this.getNearestLocation.apply(this,arguments);return t?t.getPoint():t}},new function(){var t=["getPoint","getTangent","getNormal","getWeightedTangent","getWeightedNormal","getCurvature"];return r.each(t,function(t){this[t+"At"]=function(e,n){var i=this.getValues();return T[t](i,n?e:T.getTimeAt(i,e))},this[t+"AtTime"]=function(e){return T[t](this.getValues(),e)}},{statics:{_evaluateMethods:t}})},new function(){function t(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7],u=9*(i-s)+3*(o-e),l=6*(e+s)-12*i,c=3*(i-e),f=9*(r-a)+3*(h-n),d=6*(n+a)-12*r,_=3*(r-n);return function(t){var e=(u*t+l)*t+c,n=(f*t+d)*t+_;return Math.sqrt(e*e+n*n)}}function n(t,e){return Math.max(2,Math.min(16,Math.ceil(32*Math.abs(e-t))))}function i(t,e,n,i){if(null==e||e<0||e>1)return null;var r=t[0],s=t[1],a=t[2],o=t[3],h=t[4],l=t[5],f=t[6],d=t[7],_=u.isZero;_(a-r)&&_(o-s)&&(a=r,o=s),_(h-f)&&_(l-d)&&(h=f,l=d);var g,v,p=3*(a-r),m=3*(h-a)-p,y=f-r-p-m,w=3*(o-s),x=3*(l-o)-w,b=d-s-w-x;if(0===n)g=0===e?r:1===e?f:((y*e+m)*e+p)*e+r,v=0===e?s:1===e?d:((b*e+x)*e+w)*e+s;else{var C=4e-7,S=1-C;if(e<C?(g=p,v=w):e>S?(g=3*(f-h),v=3*(d-l)):(g=(3*y*e+2*m)*e+p,v=(3*b*e+2*x)*e+w),i){0===g&&0===v&&(e<C||e>S)&&(g=h-a,v=l-o);var k=Math.sqrt(g*g+v*v);k&&(g/=k,v/=k)}if(3===n){var I=6*y*e+2*m,P=6*b*e+2*x,M=Math.pow(g*g+v*v,1.5);g=0!==M?(g*P-v*I)/M:0,v=0}}return 2===n?new c(v,(-g)):new c(g,v)}return{statics:{getLength:function(i,r,s,a){if(r===e&&(r=0),s===e&&(s=1),T.isStraight(i)){var o=i;s<1&&(o=T.subdivide(o,s)[0],r/=s),r>0&&(o=T.subdivide(o,r)[1]);var h=o[6]-o[0],l=o[7]-o[1];return Math.sqrt(h*h+l*l)}return u.integrate(a||t(i),r,s,n(r,s))},getTimeAt:function(i,r,s){function a(t){return p+=u.integrate(d,s,t,n(s,t)),s=t,p-r}if(s===e&&(s=r<0?1:0),0===r)return s;var o=Math.abs,h=1e-12,l=r>0,c=l?s:0,f=l?1:s,d=t(i),_=T.getLength(i,c,f,d),g=o(r)-_;if(o(g)<h)return l?f:c;if(g>h)return null;var v=r/_,p=0;return u.findRoot(a,d,s+v,c,f,32,1e-12)},getPoint:function(t,e){return i(t,e,0,!1)},getTangent:function(t,e){return i(t,e,1,!0)},getWeightedTangent:function(t,e){return i(t,e,1,!1)},getNormal:function(t,e){return i(t,e,2,!0)},getWeightedNormal:function(t,e){return i(t,e,2,!1)},getCurvature:function(t,e){return i(t,e,3,!1).x}}}},new function(){function t(t,e,n,i,r,s,a,o,h,u,l){var c=!l&&e.excludeStart,f=!l&&e.excludeEnd,d=4e-7,_=1-d;if(null==r&&(r=T.getTimeOf(n,s)),null!==r&&r>=(c?d:0)&&r<=(f?_:1)&&(null==h&&(h=T.getTimeOf(a,u)),null!==h&&h>=(f?d:0)&&h<=(c?_:1))){var g=e.renormalize;
if(g){var v=g(r,h);r=v[0],h=v[1]}var p=new z(i,r,s||T.getPoint(n,r),l),m=new z(o,h,u||T.getPoint(a,h),l),y=p.getPath()===m.getPath()&&p.getIndex()>m.getIndex(),w=y?m:p,x=e.include;p._intersection=m,m._intersection=p,x&&!x(w)||z.insert(t,w,!0)}}function e(r,s,a,o,h,u,l,c,f,d,_,g,v){if(++g>=48||++v>4096)return v;var p,y,w=s[0],x=s[1],b=s[6],C=s[7],S=m.getSignedDistance,k=S(w,x,b,C,s[2],s[3]),I=S(w,x,b,C,s[4],s[5]),P=k*I>0?.75:4/9,M=P*Math.min(0,k,I),A=P*Math.max(0,k,I),z=S(w,x,b,C,r[0],r[1]),O=S(w,x,b,C,r[2],r[3]),E=S(w,x,b,C,r[4],r[5]),L=S(w,x,b,C,r[6],r[7]),N=n(z,O,E,L),B=N[0],j=N[1];if(0===k&&0===I&&0===z&&0===O&&0===E&&0===L||null==(p=i(B,j,M,A))||null==(y=i(B.reverse(),j.reverse(),M,A)))return v;var F=l+(c-l)*p,D=l+(c-l)*y;if(Math.max(d-f,D-F)<1e-9){var R=(F+D)/2,q=(f+d)/2;r=a.getValues(),s=o.getValues(),t(h,u,_?s:r,_?o:a,_?q:R,null,_?r:s,_?a:o,_?R:q,null)}else if(r=T.getPart(r,p,y),y-p>.8)if(D-F>d-f){var V=T.subdivide(r,.5),R=(F+D)/2;v=e(s,V[0],o,a,h,u,f,d,F,R,!_,g,v),v=e(s,V[1],o,a,h,u,f,d,R,D,!_,g,v)}else{var V=T.subdivide(s,.5),q=(f+d)/2;v=e(V[0],r,o,a,h,u,f,q,F,D,!_,g,v),v=e(V[1],r,o,a,h,u,q,d,F,D,!_,g,v)}else v=e(s,r,o,a,h,u,f,d,F,D,!_,g,v);return v}function n(t,e,n,i){var r,s=[0,t],a=[1/3,e],o=[2/3,n],h=[1,i],u=e-(2*t+i)/3,l=n-(t+2*i)/3;if(u*l<0)r=[[s,a,h],[s,o,h]];else{var c=u/l;r=[c>=2?[s,a,h]:c<=.5?[s,o,h]:[s,a,o,h],[s,h]]}return(u||l)<0?r.reverse():r}function i(t,e,n,i){return t[0][1]<n?r(t,!0,n):e[0][1]>i?r(e,!1,i):t[0][0]}function r(t,e,n){for(var i=t[0][0],r=t[0][1],s=1,a=t.length;s<a;s++){var o=t[s][0],h=t[s][1];if(e?h>=n:h<=n)return h===n?o:i+(n-r)*(o-i)/(h-r);i=o,r=h}return null}function s(e,n,i,r,s,a){for(var o=T.isStraight(e),h=o?n:e,l=o?e:n,c=l[0],f=l[1],d=l[6],_=l[7],g=d-c,v=_-f,p=Math.atan2(-v,g),m=Math.sin(p),y=Math.cos(p),w=[],x=0;x<8;x+=2){var b=h[x]-c,C=h[x+1]-f;w.push(b*y-C*m,b*m+C*y)}for(var S=[],k=T.solveCubic(w,1,0,S,0,1),x=0;x<k;x++){var I=S[x],P=T.getPoint(h,I),M=T.getTimeOf(l,P);if(null!==M){var A=T.getPoint(l,M),z=o?M:I,O=o?I:M;(!a.excludeEnd||O>u.CURVETIME_EPSILON)&&t(s,a,e,i,z,o?A:P,n,r,O,o?P:A)}}}function a(e,n,i,r,s,a){var o=m.intersect(e[0],e[1],e[6],e[7],n[0],n[1],n[6],n[7]);o&&t(s,a,e,i,null,o,n,r,null,o)}return{statics:{_getIntersections:function(n,i,r,o,h,u){if(!i)return T._getSelfIntersection(n,r,h,u);var l=2e-7,f=n[0],d=n[1],_=n[6],g=n[7],v=i[0],p=i[1],m=i[6],y=i[7],w=(3*n[2]+f)/4,x=(3*n[3]+d)/4,b=(3*n[4]+_)/4,C=(3*n[5]+g)/4,S=(3*i[2]+v)/4,k=(3*i[3]+p)/4,I=(3*i[4]+m)/4,P=(3*i[5]+y)/4,M=Math.min,A=Math.max;if(!(A(f,w,b,_)+l>M(v,S,I,m)&&M(f,w,b,_)-l<A(v,S,I,m)&&A(d,x,C,g)+l>M(p,k,P,y)&&M(d,x,C,g)-l<A(p,k,P,y)))return h;var z=T.getOverlaps(n,i);if(z){for(var O=0;O<2;O++){var E=z[O];t(h,u,n,r,E[0],null,i,o,E[1],null,!0)}return h}var L=T.isStraight(n),N=T.isStraight(i),B=L&&N,j=h.length;if((B?a:L||N?s:e)(n,i,r,o,h,u,0,1,0,1,0,0,0),B&&h.length>j)return h;var F=new c(f,d),D=new c(_,g),R=new c(v,p),q=new c(m,y);return F.isClose(R,l)&&t(h,u,n,r,0,F,i,o,0,R),!u.excludeStart&&F.isClose(q,l)&&t(h,u,n,r,0,F,i,o,1,q),!u.excludeEnd&&D.isClose(R,l)&&t(h,u,n,r,1,D,i,o,0,R),D.isClose(q,l)&&t(h,u,n,r,1,D,i,o,1,q),h},_getSelfIntersection:function(t,e,n,i){var r=t[0],s=t[1],a=t[2],o=t[3],h=t[4],l=t[5],f=t[6],d=t[7],_=new m(r,s,f,d,(!1)),g=_.getSide(new c(a,o),!0),v=_.getSide(new c(h,l),!0);if(g===v){var p=(r-h)*(o-d)+(a-f)*(l-s);if(p*g>0)return n}var y=f-3*h+3*a-r,w=h-2*a+r,x=a-r,b=d-3*l+3*o-s,C=l-2*o+s,S=o-s,k=b*x-y*S,I=b*w-y*C,P=C*x-w*S;if(k*k-4*I*P<0){var M,A=[],z=u.solveCubic(y*y+b*b,3*(y*w+b*C),2*(w*w+C*C)+y*x+b*S,w*x+C*S,A,0,1);if(z>0){for(var O=0,E=0;O<z;O++){var L=Math.abs(e.getCurvatureAtTime(A[O]));L>E&&(E=L,M=A[O])}var N=T.subdivide(t,M);i.excludeEnd=!0,i.renormalize=function(t,e){return[t*M,e*(1-M)+M]},T._getIntersections(N[0],N[1],e,e,n,i)}}return n},getOverlaps:function(t,e){function n(t){var e=t[6]-t[0],n=t[7]-t[1];return e*e+n*n}var i=Math.abs,r=4e-7,s=2e-7,a=T.isStraight(t),o=T.isStraight(e),h=a&&o,u=n(t)<n(e),l=u?e:t,f=u?t:e,d=new m(l[0],l[1],l[6],l[7]);if(d.getDistance(new c(f[0],f[1]))<s&&d.getDistance(new c(f[6],f[7]))<s)!h&&d.getDistance(new c(l[2],l[3]))<s&&d.getDistance(new c(l[4],l[5]))<s&&d.getDistance(new c(f[2],f[3]))<s&&d.getDistance(new c(f[4],f[5]))<s&&(a=o=h=!0);else if(h)return null;if(a^o)return null;for(var _=[t,e],g=[],v=0,p=0;v<2&&g.length<2;v+=0===p?0:1,p=1^p){var y=T.getTimeOf(_[1^v],new c(_[v][0===p?0:6],_[v][0===p?1:7]));if(null!=y){var w=0===v?[p,y]:[y,p];(0===g.length||i(w[0]-g[0][0])>r&&i(w[1]-g[0][1])>r)&&g.push(w)}if(1===v&&0===g.length)break}if(2!==g.length)g=null;else if(!h){var x=T.getPart(t,g[0][0],g[1][0]),b=T.getPart(e,g[0][1],g[1][1]);(i(b[2]-x[2])>s||i(b[3]-x[3])>s||i(b[4]-x[4])>s||i(b[5]-x[5])>s)&&(g=null)}return g}}}}),z=r.extend({_class:"CurveLocation",beans:!0,initialize:function(t,e,n,i,r){if(e>.9999996){var s=t.getNext();s&&(e=0,t=s)}this._setCurve(t),this._time=e,this._point=n||t.getPointAtTime(e),this._overlap=i,this._distance=r,this._intersection=this._next=this._previous=null},_setCurve:function(t){var e=t._path;this._path=e,this._version=e?e._version:0,this._curve=t,this._segment=null,this._segment1=t._segment1,this._segment2=t._segment2},_setSegment:function(t){this._setCurve(t.getCurve()),this._segment=t,this._time=t===this._segment1?0:1,this._point=t._point.clone()},getSegment:function(){var t=this.getCurve(),e=this._segment;if(!e){var n=this.getTime();0===n?e=t._segment1:1===n?e=t._segment2:null!=n&&(e=t.getPartLength(0,n)<t.getPartLength(n,1)?t._segment1:t._segment2),this._segment=e}return e},getCurve:function(){function t(t){var e=t&&t.getCurve();if(e&&null!=(n._time=e.getTimeOf(n._point)))return n._setCurve(e),n._segment=t,e}var e=this._path,n=this;return e&&e._version!==this._version&&(this._time=this._curve=this._offset=null),this._curve||t(this._segment)||t(this._segment1)||t(this._segment2.getPrevious())},getPath:function(){var t=this.getCurve();return t&&t._path},getIndex:function(){var t=this.getCurve();return t&&t.getIndex()},getTime:function(){var t=this.getCurve(),e=this._time;return t&&null==e?this._time=t.getTimeOf(this._point):e},getParameter:"#getTime",getPoint:function(){return this._point},getOffset:function(){var t=this._offset;if(null==t){t=0;var e=this.getPath(),n=this.getIndex();if(e&&null!=n)for(var i=e.getCurves(),r=0;r<n;r++)t+=i[r].getLength();this._offset=t+=this.getCurveOffset()}return t},getCurveOffset:function(){var t=this.getCurve(),e=this.getTime();return null!=e&&t&&t.getPartLength(0,e)},getIntersection:function(){return this._intersection},getDistance:function(){return this._distance},divide:function(){var t=this.getCurve(),e=null;return t&&(e=t.divideAtTime(this.getTime()),e&&this._setSegment(e._segment1)),e},split:function(){var t=this.getCurve();return t?t.splitAtTime(this.getTime()):null},equals:function(t,e){var n=this===t,i=2e-7;if(!n&&t instanceof z&&this.getPath()===t.getPath()&&this.getPoint().isClose(t.getPoint(),i)){var r=this.getCurve(),s=t.getCurve(),a=Math.abs,o=a((r.isLast()&&s.isFirst()?-1:r.getIndex())+this.getTime()-((s.isLast()&&r.isFirst()?-1:s.getIndex())+t.getTime()));n=(o<4e-7||(o=a(this.getOffset()-t.getOffset()))<i||a(this.getPath().getLength()-o)<i)&&(e||!this._intersection&&!t._intersection||this._intersection&&this._intersection.equals(t._intersection,!0))}return n},toString:function(){var t=[],e=this.getPoint(),n=h.instance;e&&t.push("point: "+e);var i=this.getIndex();null!=i&&t.push("index: "+i);var r=this.getTime();return null!=r&&t.push("time: "+n.number(r)),null!=this._distance&&t.push("distance: "+n.number(this._distance)),"{ "+t.join(", ")+" }"},isTouching:function(){var t=this._intersection;if(t&&this.getTangent().isCollinear(t.getTangent())){var e=this.getCurve(),n=t.getCurve();return!(e.isStraight()&&n.isStraight()&&e.getLine().intersect(n.getLine()))}return!1},isCrossing:function(){function t(t,e,n){return e<n?t>e&&t<n:t>e||t<n}var e=this._intersection;if(!e)return!1;var n=this.getTime(),i=e.getTime(),r=4e-7,s=1-r,a=n>r&&n<s,o=i>r&&i<s;if(a&&o)return!this.isTouching();var h=this.getCurve(),u=n<=r?h.getPrevious():h,l=e.getCurve(),c=i<=r?l.getPrevious():l;if(n>=s&&(h=h.getNext()),i>=s&&(l=l.getNext()),!(u&&h&&c&&l))return!1;var f=[];a||f.push(u.getLength(),h.getLength()),o||f.push(c.getLength(),l.getLength());var d=this.getPoint(),_=Math.min.apply(Math,f)/64,g=a?h.getTangentAtTime(n):h.getPointAt(_).subtract(d),v=a?g.negate():u.getPointAt(-_).subtract(d),p=o?l.getTangentAtTime(i):l.getPointAt(_).subtract(d),m=o?p.negate():c.getPointAt(-_).subtract(d),y=v.getAngle(),w=g.getAngle(),x=m.getAngle(),b=p.getAngle();return!!(a?t(y,x,b)^t(w,x,b)&&t(y,b,x)^t(w,b,x):t(x,y,w)^t(b,y,w)&&t(x,w,y)^t(b,w,y))},hasOverlap:function(){return!!this._overlap}},r.each(T._evaluateMethods,function(t){var e=t+"At";this[t]=function(){var t=this.getCurve(),n=this.getTime();return null!=n&&t&&t[e](n,!0)}},{preserve:!0}),new function(){function t(t,e,n){function i(n,i){for(var s=n+i;s>=-1&&s<=r;s+=i){var a=t[(s%r+r)%r];if(!e.getPoint().isClose(a.getPoint(),2e-7))break;if(e.equals(a))return a}return null}for(var r=t.length,s=0,a=r-1;s<=a;){var o,h=s+a>>>1,u=t[h];if(n&&(o=e.equals(u)?u:i(h,-1)||i(h,1)))return e._overlap&&(o._overlap=o._intersection._overlap=!0),o;var l=e.getPath(),c=u.getPath(),f=l===c?e.getIndex()+e.getTime()-(u.getIndex()+u.getTime()):l._id-c._id;f<0?a=h-1:s=h+1}return t.splice(s,0,e),e}return{statics:{insert:t,expand:function(e){for(var n=e.slice(),i=e.length-1;i>=0;i--)t(n,e[i]._intersection,!1);return n}}}}),O=w.extend({_class:"PathItem",_selectBounds:!1,_canScaleStroke:!0,initialize:function(){},statics:{create:function(t){var e=(t&&t.match(/m/gi)||[]).length>1||/z\s*\S+/i.test(t)?L:E;return new e(t)}},_asPathItem:function(){return this},setPathData:function(t){function e(t,e){var n=+i[t];return o&&(n+=h[e]),n}function n(t){return new c(e(t,"x"),e(t+1,"y"))}var i,r,s,a=t&&t.match(/[mlhvcsqtaz][^mlhvcsqtaz]*/gi),o=!1,h=new c,u=new c;this.clear();for(var l=0,f=a&&a.length;l<f;l++){var _=a[l],g=_[0],v=g.toLowerCase();i=_.match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g);var p=i&&i.length;switch(o=g===v,"z"!==r||/[mz]/.test(v)||this.moveTo(h=u),v){case"m":case"l":for(var m="m"===v,y=0;y<p;y+=2)this[0===y&&m?"moveTo":"lineTo"](h=n(y));s=h,m&&(u=h);break;case"h":case"v":for(var w="h"===v?"x":"y",y=0;y<p;y++)h[w]=e(y,w),this.lineTo(h);s=h;break;case"c":for(var y=0;y<p;y+=6)this.cubicCurveTo(n(y),s=n(y+2),h=n(y+4));break;case"s":for(var y=0;y<p;y+=4)this.cubicCurveTo(/[cs]/.test(r)?h.multiply(2).subtract(s):h,s=n(y),h=n(y+2)),r=v;break;case"q":for(var y=0;y<p;y+=4)this.quadraticCurveTo(s=n(y),h=n(y+2));break;case"t":for(var y=0;y<p;y+=2)this.quadraticCurveTo(s=/[qt]/.test(r)?h.multiply(2).subtract(s):h,h=n(y)),r=v;break;case"a":for(var y=0;y<p;y+=7)this.arcTo(h=n(y+5),new d((+i[y]),(+i[y+1])),+i[y+2],+i[y+4],+i[y+3]);break;case"z":this.closePath(1e-12)}r=v}},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_contains:function(t){var e=t.isInside(this.getBounds({internal:!0,handle:!0}))&&this._getWinding(t);return!!("evenodd"===this.getFillRule()?1&e:e)},getIntersections:function(t,e,n,i){var r=this===t||!t,s=this._matrix._orNullIfIdentity(),a=r?s:(n||t._matrix)._orNullIfIdentity();if(!r&&!this.getBounds(s).touches(t.getBounds(a)))return[];for(var o,t,h=this.getCurves(),u=r?h:t.getCurves(),l=h.length,c=r?l:u.length,f=[],d=[],_=0;_<c;_++)f[_]=u[_].getValues(a);for(var _=0;_<l;_++){var g=h[_],v=r?f[_]:g.getValues(s),p=g.getPath();p!==t&&(t=p,o=[],d.push(o)),r&&T._getSelfIntersection(v,g,o,{include:e,excludeStart:1===l&&g.getPoint1().equals(g.getPoint2())});for(var m=r?_+1:0;m<c;m++){if(i&&o.length)return o;var y=u[m];T._getIntersections(v,f[m],g,y,o,{include:e,excludeStart:r&&g.getPrevious()===y,excludeEnd:r&&g.getNext()===y})}}o=[];for(var _=0,w=d.length;_<w;_++)o.push.apply(o,d[_]);return o},getCrossings:function(t){return this.getIntersections(t,function(t){return t._overlap||t.isCrossing()})},getNearestLocation:function(){for(var t=c.read(arguments),e=this.getCurves(),n=1/0,i=null,r=0,s=e.length;r<s;r++){var a=e[r].getNearestLocation(t);a._distance<n&&(n=a._distance,i=a)}return i},getNearestPoint:function(){var t=this.getNearestLocation.apply(this,arguments);return t?t.getPoint():t},interpolate:function(t,e,n){var i=!this._children,r=i?"_segments":"_children",s=t[r],a=e[r],o=this[r];if(!s||!a||s.length!==a.length)throw new Error("Invalid operands in interpolate() call: "+t+", "+e);var h=o.length,u=a.length;if(h<u)for(var l=i?M:E,c=h;c<u;c++)this.add(new l);else h>u&&this[i?"removeSegments":"removeChildren"](u,h);for(var c=0;c<u;c++)o[c].interpolate(s[c],a[c],n);i&&(this.setClosed(t._closed),this._changed(9))}}),E=O.extend({_class:"Path",_serializeFields:{segments:[],closed:!1},initialize:function(t){this._closed=!1,this._segments=[],this._version=0;var n=Array.isArray(t)?"object"==typeof t[0]?t:arguments:!t||t.size!==e||t.x===e&&t.point===e?null:arguments;n&&n.length>0?this.setSegments(n):(this._curves=e,this._segmentSelection=0,n||"string"!=typeof t||(this.setPathData(t),t=null)),this._initialize(!n&&t)},_equals:function(t){return this._closed===t._closed&&r.equals(this._segments,t._segments)},copyContent:function(t){this.setSegments(t._segments),this._closed=t._closed;var n=t._clockwise;n!==e&&(this._clockwise=n)},_changed:function vt(t){if(vt.base.call(this,t),8&t){if(this._length=this._area=this._clockwise=this._monoCurves=e,16&t)this._version++;else if(this._curves)for(var n=0,i=this._curves.length;n<i;n++)this._curves[n]._changed()}else 32&t&&(this._bounds=e)},getStyle:function(){var t=this._parent;return(t instanceof L?t:this)._style},getSegments:function(){return this._segments},setSegments:function(t){var n=this.isFullySelected();this._segments.length=0,this._segmentSelection=0,this._curves=e,t&&t.length>0&&this._add(M.readAll(t)),n&&this.setFullySelected(!0)},getFirstSegment:function(){return this._segments[0]},getLastSegment:function(){return this._segments[this._segments.length-1]},getCurves:function(){var t=this._curves,e=this._segments;if(!t){var n=this._countCurves();t=this._curves=new Array(n);for(var i=0;i<n;i++)t[i]=new T(this,e[i],e[i+1]||e[0])}return t},getFirstCurve:function(){return this.getCurves()[0]},getLastCurve:function(){var t=this.getCurves();return t[t.length-1]},isClosed:function(){return this._closed},setClosed:function(t){if(this._closed!=(t=!!t)){if(this._closed=t,this._curves){var e=this._curves.length=this._countCurves();t&&(this._curves[e-1]=new T(this,this._segments[e-1],this._segments[0]))}this._changed(25)}}},{beans:!0,getPathData:function(t,e){function n(e,n){e._transformCoordinates(t,g),i=g[0],r=g[1],v?(p.push("M"+_.pair(i,r)),v=!1):(o=g[2],u=g[3],o===i&&u===r&&l===s&&c===a?n||p.push("l"+_.pair(i-s,r-a)):p.push("c"+_.pair(l-s,c-a)+" "+_.pair(o-s,u-a)+" "+_.pair(i-s,r-a))),s=i,a=r,l=g[4],c=g[5]}var i,r,s,a,o,u,l,c,f=this._segments,d=f.length,_=new h(e),g=new Array(6),v=!0,p=[];if(0===d)return"";for(var m=0;m<d;m++)n(f[m]);return this._closed&&d>0&&(n(f[0],!0),p.push("z")),p.join("")},isEmpty:function(){return 0===this._segments.length},_transformContent:function(t){for(var e=this._segments,n=new Array(6),i=0,r=e.length;i<r;i++)e[i]._transformCoordinates(t,n,!0);return!0},_add:function(t,e){for(var n=this._segments,i=this._curves,r=t.length,s=null==e,e=s?n.length:e,a=0;a<r;a++){var o=t[a];o._path&&(o=t[a]=o.clone()),o._path=this,o._index=e+a,o._selection&&this._updateSelection(o,0,o._selection)}if(s)n.push.apply(n,t);else{n.splice.apply(n,[e,0].concat(t));for(var a=e+r,h=n.length;a<h;a++)n[a]._index=a}if(i){var u=this._countCurves(),l=e>0&&e+r-1===u?e-1:e,c=l,f=Math.min(l+r,u);t._curves&&(i.splice.apply(i,[l,0].concat(t._curves)),c+=t._curves.length);for(var a=c;a<f;a++)i.splice(a,0,new T(this,null,null));this._adjustCurves(l,f)}return this._changed(25),t},_adjustCurves:function(t,e){for(var n,i=this._segments,r=this._curves,s=t;s<e;s++)n=r[s],n._path=this,n._segment1=i[s],n._segment2=i[s+1]||i[0],n._changed();(n=r[this._closed&&0===t?i.length-1:t-1])&&(n._segment2=i[t]||i[0],n._changed()),(n=r[e])&&(n._segment1=i[e],n._changed())},_countCurves:function(){var t=this._segments.length;return!this._closed&&t>0?t-1:t},add:function(t){return arguments.length>1&&"number"!=typeof t?this._add(M.readAll(arguments)):this._add([M.read(arguments)])[0]},insert:function(t,e){return arguments.length>2&&"number"!=typeof e?this._add(M.readAll(arguments,1),t):this._add([M.read(arguments,1)],t)[0]},addSegment:function(){return this._add([M.read(arguments)])[0]},insertSegment:function(t){return this._add([M.read(arguments,1)],t)[0]},addSegments:function(t){return this._add(M.readAll(t))},insertSegments:function(t,e){return this._add(M.readAll(e),t)},removeSegment:function(t){return this.removeSegments(t,t+1)[0]||null},removeSegments:function(t,e,n){t=t||0,e=r.pick(e,this._segments.length);var i=this._segments,s=this._curves,a=i.length,o=i.splice(t,e-t),h=o.length;if(!h)return o;for(var u=0;u<h;u++){var l=o[u];l._selection&&this._updateSelection(l,l._selection,0),l._index=l._path=null}for(var u=t,c=i.length;u<c;u++)i[u]._index=u;if(s){for(var f=t>0&&e===a+(this._closed?1:0)?t-1:t,s=s.splice(f,h),u=s.length-1;u>=0;u--)s[u]._path=null;n&&(o._curves=s.slice(1)),this._adjustCurves(f,f)}return this._changed(25),o},clear:"#removeSegments",hasHandles:function(){for(var t=this._segments,e=0,n=t.length;e<n;e++)if(t[e].hasHandles())return!0;return!1},clearHandles:function(){for(var t=this._segments,e=0,n=t.length;e<n;e++)t[e].clearHandles()},getLength:function(){if(null==this._length){for(var t=this.getCurves(),e=0,n=0,i=t.length;n<i;n++)e+=t[n].getLength();this._length=e}return this._length},getArea:function(t){var n=t===e,i=this._area;if(!n||null==i){var r=this._segments,s=r.length,a=n?this._closed:t,o=s-1;i=0;for(var h=0,u=a?s:o;h<u;h++)i+=T.getArea(T.getValues(r[h],r[h<o?h+1:0]));n&&(this._area=i)}return i},isClockwise:function(){return this._clockwise!==e?this._clockwise:this.getArea()>=0},setClockwise:function(t){this.isClockwise()!=(t=!!t)&&this.reverse(),this._clockwise=t},isFullySelected:function(){var t=this._segments.length;return this.isSelected()&&t>0&&this._segmentSelection===7*t},setFullySelected:function(t){t&&this._selectSegments(!0),this.setSelected(t)},setSelection:function pt(t){1&t||this._selectSegments(!1),pt.base.call(this,t)},_selectSegments:function(t){var e=this._segments,n=e.length,i=t?7:0;this._segmentSelection=i*n;for(var r=0;r<n;r++)e[r]._selection=i},_updateSelection:function(t,e,n){t._selection=n;var i=this._segmentSelection+=n-e;i>0&&this.setSelected(!0)},splitAt:function(t){var e="number"==typeof t?this.getLocationAt(t):t,n=e&&e.index,i=e&&e.time,r=4e-7,s=1-r;i>=s&&(n++,i=0);var a=this.getCurves();if(n>=0&&n<a.length){i>=r&&a[n++].divideAtTime(i);var o,h=this.removeSegments(n,this._segments.length,!0);return this._closed?(this.setClosed(!1),o=this):(o=new E(w.NO_INSERT),o.insertAbove(this,!0),o.copyAttributes(this)),o._add(h,0),this.addSegment(h[0]),o}return null},split:function(t,n){var i,r=n===e?t:(i=this.getCurves()[t])&&i.getLocationAtTime(n);return null!=r?this.splitAt(r):null},join:function(t,e){var n=e||0;if(t&&t!==this){var i=t._segments,r=this.getLastSegment(),s=t.getLastSegment();if(!s)return this;r&&r._point.isClose(s._point,n)&&t.reverse();var a=t.getFirstSegment();if(r&&r._point.isClose(a._point,n))r.setHandleOut(a._handleOut),this._add(i.slice(1));else{var o=this.getFirstSegment();o&&o._point.isClose(a._point,n)&&t.reverse(),s=t.getLastSegment(),o&&o._point.isClose(s._point,n)?(o.setHandleIn(s._handleIn),this._add(i.slice(0,i.length-1),0)):this._add(i.slice())}t._closed&&this._add([i[0]]),t.remove()}var h=this.getFirstSegment(),u=this.getLastSegment();return h!==u&&h._point.isClose(u._point,n)&&(h.setHandleIn(u._handleIn),u.remove(),this.setClosed(!0)),this},reduce:function(t){for(var e=this.getCurves(),n=t&&t.simplify,i=n?2e-7:0,r=e.length-1;r>=0;r--){var s=e[r];!s.hasHandles()&&(s.getLength()<i||n&&s.isCollinear(s.getNext()))&&s.remove()}return this},reverse:function(){this._segments.reverse();for(var t=0,n=this._segments.length;t<n;t++){var i=this._segments[t],r=i._handleIn;i._handleIn=i._handleOut,i._handleOut=r,i._index=t}this._curves=null,this._clockwise!==e&&(this._clockwise=!this._clockwise),this._changed(9)},flatten:function(t){for(var e=new N(this,t||.25,256,(!0)),n=e.parts,i=n.length,r=[],s=0;s<i;s++)r.push(new M(n[s].curve.slice(0,2)));!this._closed&&i>0&&r.push(new M(n[i-1].curve.slice(6))),this.setSegments(r)},simplify:function(t){var e=new B(this).fit(t||2.5);return e&&this.setSegments(e),!!e},smooth:function(t){function n(t,e){var n=t&&t.index;if(null!=n){var r=t.path;if(r&&r!==i)throw new Error(t._class+" "+n+" of "+r+" is not part of "+i);e&&t instanceof T&&n++}else n="number"==typeof t?t:e;return Math.min(n<0&&h?n%o:n<0?n+o:n,o-1)}var i=this,r=t||{},s=r.type||"asymmetric",a=this._segments,o=a.length,h=this._closed,u=h&&r.from===e&&r.to===e,l=n(r.from,0),c=n(r.to,o-1);if(l>c)if(h)l-=o;else{var f=l;l=c,c=f}if(/^(?:asymmetric|continuous)$/.test(s)){var d="asymmetric"===s,_=Math.min,g=c-l+1,v=g-1,p=u?_(g,4):1,m=p,y=p,w=[];if(h||(m=_(1,l),y=_(1,o-c-1)),v+=m+y,v<=1)return;for(var x=0,b=l-m;x<=v;x++,b++)w[x]=a[(b<0?b+o:b)%o]._point;for(var C=w[0]._x+2*w[1]._x,S=w[0]._y+2*w[1]._y,k=2,I=v-1,P=[C],M=[S],A=[k],z=[],O=[],x=1;x<v;x++){var E=x<I,L=E?1:d?1:2,N=E?4:d?2:7,B=E?4:d?3:8,j=E?2:d?0:1,F=L/k;k=A[x]=N-F,C=P[x]=B*w[x]._x+j*w[x+1]._x-F*C,S=M[x]=B*w[x]._y+j*w[x+1]._y-F*S}z[I]=P[I]/A[I],O[I]=M[I]/A[I];for(var x=v-2;x>=0;x--)z[x]=(P[x]-z[x+1])/A[x],O[x]=(M[x]-O[x+1])/A[x];z[v]=(3*w[v]._x-z[I])/2,O[v]=(3*w[v]._y-O[I])/2;for(var x=m,D=v-y,b=l;x<=D;x++,b++){var R=a[b<0?b+o:b],q=R._point,V=z[x]-q._x,H=O[x]-q._y;(u||x<D)&&R.setHandleOut(V,H),(u||x>m)&&R.setHandleIn(-V,-H)}}else for(var x=l;x<=c;x++)a[x<0?x+o:x].smooth(r,!u&&x===l,!u&&x===c)},toShape:function(t){function n(t,e){var n=c[t],i=n.getNext(),r=c[e],s=r.getNext();return n._handleOut.isZero()&&i._handleIn.isZero()&&r._handleOut.isZero()&&s._handleIn.isZero()&&i._point.subtract(n._point).isCollinear(s._point.subtract(r._point))}function i(t){var e=c[t],n=e.getPrevious(),i=e.getNext();return n._handleOut.isZero()&&e._handleIn.isZero()&&e._handleOut.isZero()&&i._handleIn.isZero()&&e._point.subtract(n._point).isOrthogonal(i._point.subtract(e._point))}function r(t){var e=c[t],n=e.getNext(),i=e._handleOut,r=n._handleIn,s=.5522847498307936;if(i.isOrthogonal(r)){var a=e._point,o=n._point,h=new m(a,i,(!0)).intersect(new m(o,r,(!0)),!0);return h&&u.isZero(i.getLength()/h.subtract(a).getLength()-s)&&u.isZero(r.getLength()/h.subtract(o).getLength()-s)}return!1}function s(t,e){return c[t]._point.getDistance(c[e]._point)}if(!this._closed)return null;var a,o,h,l,c=this._segments;if(!this.hasHandles()&&4===c.length&&n(0,2)&&n(1,3)&&i(1)?(a=C.Rectangle,o=new d(s(0,3),s(0,1)),l=c[1]._point.add(c[2]._point).divide(2)):8===c.length&&r(0)&&r(2)&&r(4)&&r(6)&&n(1,5)&&n(3,7)?(a=C.Rectangle,o=new d(s(1,6),s(0,3)),h=o.subtract(new d(s(0,7),s(1,2))).divide(2),l=c[3]._point.add(c[4]._point).divide(2)):4===c.length&&r(0)&&r(1)&&r(2)&&r(3)&&(u.isZero(s(0,2)-s(1,3))?(a=C.Circle,h=s(0,2)/2):(a=C.Ellipse,h=new d(s(2,0)/2,s(3,1)/2)),l=c[1]._point),a){var f=this.getPosition(!0),_=new a({center:f,size:o,radius:h,insert:!1});return _.copyAttributes(this,!0),_._matrix.prepend(this._matrix),_.rotate(l.subtract(f).getAngle()+90),(t===e||t)&&_.insertAbove(this),_}return null},toPath:"#clone",_hitTestSelf:function(t,e,n,i){function r(e,n){return t.subtract(e).divide(n).length<=1}function s(t,n,i){if(!e.selected||n.isSelected()){var s=t._point;if(n!==s&&(n=n.add(s)),r(n,x))return new P(i,g,{segment:t,point:n})}}function a(t,n){return(n||e.segments)&&s(t,t._point,"segment")||!n&&e.handles&&(s(t,t._handleIn,"handle-in")||s(t,t._handleOut,"handle-out"))}function o(t){f.add(t)}function h(e){if(("round"!==u||"round"!==l)&&(f=new E({internal:!0,closed:!0}),y||e._index>0&&e._index<m-1?"round"!==u&&(e._handleIn.isZero()||e._handleOut.isZero())&&E._addBevelJoin(e,u,k,c,null,i,o,!0):"round"!==l&&E._addSquareCap(e,l,k,null,i,o,!0),!f.isEmpty())){var n;return f.contains(t)||(n=f.getNearestLocation(t))&&r(n.getPoint(),w)}return r(e._point,x)}var u,l,c,f,d,_,g=this,v=this.getStyle(),p=this._segments,m=p.length,y=this._closed,w=e._tolerancePadding,x=w,b=e.stroke&&v.hasStroke(),C=e.fill&&v.hasFill(),S=e.curves,k=b?v.getStrokeWidth()/2:C&&e.tolerance>0||S?0:null;if(null!==k&&(k>0?(u=v.getStrokeJoin(),l=v.getStrokeCap(),c=k*v.getMiterLimit(),x=x.add(E._getStrokePadding(k,i))):u=l="round"),!e.ends||e.segments||y){if(e.segments||e.handles)for(var I=0;I<m;I++)if(_=a(p[I]))return _}else if(_=a(p[0],!0)||a(p[m-1],!0))return _;if(null!==k){if(d=this.getNearestLocation(t)){var M=d.getTime();0===M||1===M&&m>1?h(d.getSegment())||(d=null):r(d.getPoint(),x)||(d=null)}if(!d&&"miter"===u&&m>1)for(var I=0;I<m;I++){var A=p[I];if(t.getDistance(A._point)<=c&&h(A)){d=A.getLocation();break}}}return!d&&C&&this._contains(t)||d&&!b&&!S?new P("fill",this):d?new P(b?"stroke":"curve",this,{location:d,point:d.getPoint()}):null}},r.each(T._evaluateMethods,function(t){this[t+"At"]=function(e){var n=this.getLocationAt(e);return n&&n[t]()}},{beans:!1,getLocationOf:function(){for(var t=c.read(arguments),e=this.getCurves(),n=0,i=e.length;n<i;n++){var r=e[n].getLocationOf(t);if(r)return r}return null},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getLocationAt:function(t){for(var e=this.getCurves(),n=0,i=0,r=e.length;i<r;i++){var s=n,a=e[i];if(n+=a.getLength(),n>t)return a.getLocationAt(t-s)}return e.length>0&&t<=this.getLength()?new z(e[e.length-1],1):null}}),new function(){function t(t,e,n,i){function r(e){var n=h[e],i=h[e+1];s==n&&a==i||(t.beginPath(),t.moveTo(s,a),t.lineTo(n,i),t.stroke(),t.beginPath(),t.arc(n,i,o,0,2*Math.PI,!0),t.fill())}for(var s,a,o=i/2,h=new Array(6),u=0,l=e.length;u<l;u++){var c=e[u],f=c._selection;if(c._transformCoordinates(n,h),s=h[0],a=h[1],2&f&&r(2),4&f&&r(4),t.fillRect(s-o,a-o,i,i),!(1&f)){var d=t.fillStyle;t.fillStyle="#ffffff",t.fillRect(s-o+1,a-o+1,i-2,i-2),t.fillStyle=d}}}function e(t,e,n){function i(e){if(n)e._transformCoordinates(n,_),r=_[0],s=_[1];else{var i=e._point;r=i._x,s=i._y}if(g)t.moveTo(r,s),g=!1;else{if(n)h=_[2],u=_[3];else{var f=e._handleIn;h=r+f._x,u=s+f._y}h===r&&u===s&&l===a&&c===o?t.lineTo(r,s):t.bezierCurveTo(l,c,h,u,r,s)}if(a=r,o=s,n)l=_[4],c=_[5];else{var f=e._handleOut;l=a+f._x,c=o+f._y}}for(var r,s,a,o,h,u,l,c,f=e._segments,d=f.length,_=new Array(6),g=!0,v=0;v<d;v++)i(f[v]);e._closed&&d>0&&i(f[0])}return{_draw:function(t,n,i,r){function s(t){return c[(t%f+f)%f]}var a=n.dontStart,o=n.dontFinish||n.clip,h=this.getStyle(),u=h.hasFill(),l=h.hasStroke(),c=h.getDashArray(),f=!paper.support.nativeDash&&l&&c&&c.length;if(a||t.beginPath(),(u||l&&!f||o)&&(e(t,this,r),this._closed&&t.closePath()),!o&&(u||l)&&(this._setStyles(t,n,i),u&&(t.fill(h.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),l)){if(f){a||t.beginPath();var d,_=new N(this,.25,32,(!1),r),g=_.length,v=-h.getDashOffset(),p=0;for(v%=g;v>0;)v-=s(p--)+s(p--);for(;v<g;)d=v+s(p++),(v>0||d>0)&&_.drawPart(t,Math.max(v,0),Math.max(d,0)),v=d+s(p++)}t.stroke()}},_drawSelected:function(n,i){n.beginPath(),e(n,this,i),n.stroke(),t(n,this._segments,i,paper.settings.handleSize)}}},new function(){function t(t){var e=t._segments;if(0===e.length)throw new Error("Use a moveTo() command first");return e[e.length-1]}return{moveTo:function(){var t=this._segments;1===t.length&&this.removeSegment(0),t.length||this._add([new M(c.read(arguments))])},moveBy:function(){throw new Error("moveBy() is unsupported on Path items.")},lineTo:function(){this._add([new M(c.read(arguments))])},cubicCurveTo:function(){var e=c.read(arguments),n=c.read(arguments),i=c.read(arguments),r=t(this);r.setHandleOut(e.subtract(r._point)),this._add([new M(i,n.subtract(i))])},quadraticCurveTo:function(){var e=c.read(arguments),n=c.read(arguments),i=t(this)._point;this.cubicCurveTo(e.add(i.subtract(e).multiply(1/3)),e.add(n.subtract(e).multiply(1/3)),n)},curveTo:function(){var e=c.read(arguments),n=c.read(arguments),i=r.pick(r.read(arguments),.5),s=1-i,a=t(this)._point,o=e.subtract(a.multiply(s*s)).subtract(n.multiply(i*i)).divide(2*i*s);if(o.isNaN())throw new Error("Cannot put a curve through points with parameter = "+i);this.quadraticCurveTo(o,n)},arcTo:function(){var e,n,i,s,a,o=t(this),h=o._point,l=c.read(arguments),f=r.peek(arguments),_=r.pick(f,!0);if("boolean"==typeof _)var g=h.add(l).divide(2),e=g.add(g.subtract(h).rotate(_?-90:90));else if(r.remain(arguments)<=2)e=l,l=c.read(arguments);else{var v=d.read(arguments),y=u.isZero;if(y(v.width)||y(v.height))return this.lineTo(l);var w=r.read(arguments),_=!!r.read(arguments),x=!!r.read(arguments),g=h.add(l).divide(2),b=h.subtract(g).rotate(-w),C=b.x,S=b.y,k=Math.abs,I=k(v.width),P=k(v.height),A=I*I,T=P*P,z=C*C,O=S*S,E=Math.sqrt(z/A+O/T);if(E>1&&(I*=E,P*=E,A=I*I,T=P*P),E=(A*T-A*O-T*z)/(A*O+T*z),k(E)<1e-12&&(E=0),E<0)throw new Error("Cannot create an arc with the given arguments");n=new c(I*S/P,-P*C/I).multiply((x===_?-1:1)*Math.sqrt(E)).rotate(w).add(g),a=(new p).translate(n).rotate(w).scale(I,P),s=a._inverseTransform(h),i=s.getDirectedAngle(a._inverseTransform(l)),!_&&i>0?i-=360:_&&i<0&&(i+=360)}if(e){var L=new m(h.add(e).divide(2),e.subtract(h).rotate(90),(!0)),N=new m(e.add(l).divide(2),l.subtract(e).rotate(90),(!0)),B=new m(h,l),j=B.getSide(e);if(n=L.intersect(N,!0),!n){if(!j)return this.lineTo(l);throw new Error("Cannot create an arc with the given arguments")}s=h.subtract(n),i=s.getDirectedAngle(l.subtract(n));var F=B.getSide(n);0===F?i=j*Math.abs(i):j===F&&(i+=i<0?360:-360)}for(var D=Math.abs(i),R=D>=360?4:Math.ceil(D/90),q=i/R,V=q*Math.PI/360,H=4/3*Math.sin(V)/(1+Math.cos(V)),U=[],Z=0;Z<=R;Z++){var b=l,W=null;if(Z<R&&(W=s.rotate(90).multiply(H),a?(b=a._transformPoint(s),W=a._transformPoint(s.add(W)).subtract(b)):b=n.add(s)),0===Z)o.setHandleOut(W);else{var G=s.rotate(-90).multiply(H);a&&(G=a._transformPoint(s.add(G)).subtract(b)),U.push(new M(b,G,W))}s=s.rotate(q)}this._add(U)},lineBy:function(){var e=c.read(arguments),n=t(this)._point;this.lineTo(n.add(e))},curveBy:function(){var e=c.read(arguments),n=c.read(arguments),i=r.read(arguments),s=t(this)._point;this.curveTo(s.add(e),s.add(n),i)},cubicCurveBy:function(){var e=c.read(arguments),n=c.read(arguments),i=c.read(arguments),r=t(this)._point;this.cubicCurveTo(r.add(e),r.add(n),r.add(i))},quadraticCurveBy:function(){var e=c.read(arguments),n=c.read(arguments),i=t(this)._point;this.quadraticCurveTo(i.add(e),i.add(n))},arcBy:function(){var e=t(this)._point,n=e.add(c.read(arguments)),i=r.pick(r.peek(arguments),!0);"boolean"==typeof i?this.arcTo(n,i):this.arcTo(n,e.add(c.read(arguments)))},closePath:function(t){this.setClosed(!0),this.join(this,t)}}},{_getBounds:function(t,e){var n=e.handle?"getHandleBounds":e.stroke?"getStrokeBounds":"getBounds";return E[n](this._segments,this._closed,this,t,e)},statics:{getBounds:function(t,e,n,i,r,s){function a(t){t._transformCoordinates(i,h);for(var e=0;e<2;e++)T._addBounds(u[e],u[e+4],h[e+2],h[e],e,s?s[e]:0,l,c,f);var n=u;u=h,h=n}var o=t[0];if(!o)return new g;for(var h=new Array(6),u=o._transformCoordinates(i,new Array(6)),l=u.slice(0,2),c=l.slice(),f=new Array(2),d=1,_=t.length;d<_;d++)a(t[d]);return e&&a(o),new g(l[0],l[1],c[0]-l[0],c[1]-l[1])},getStrokeBounds:function(t,e,n,i,r){function s(t){v=v.include(t)}function a(t){v=v.unite(x.setCenter(t._point.transform(i)))}function o(t,e){var n=t._handleIn,r=t._handleOut;"round"===e||!n.isZero()&&!r.isZero()&&n.isCollinear(r)?a(t):E._addBevelJoin(t,e,p,w,i,f,s)}function h(t,e){"round"===e?a(t):E._addSquareCap(t,e,p,i,f,s)}var u=n.getStyle(),l=u.hasStroke(),c=u.getStrokeWidth(),f=l&&n._getStrokeMatrix(i,r),_=l&&E._getStrokePadding(c,f),v=E.getBounds(t,e,n,i,r,_);if(!l)return v;for(var p=c/2,m=u.getStrokeJoin(),y=u.getStrokeCap(),w=p*u.getMiterLimit(),x=new g(new d(_)),b=t.length-(e?0:1),C=1;C<b;C++)o(t[C],m);return e?o(t[0],m):b>0&&(h(t[0],y),h(t[t.length-1],y)),v},_getStrokePadding:function(t,e){
if(!e)return[t,t];var n=new c(t,0).transform(e),i=new c(0,t).transform(e),r=n.getAngleInRadians(),s=n.getLength(),a=i.getLength(),o=Math.sin(r),h=Math.cos(r),u=Math.tan(r),l=Math.atan2(a*u,s),f=Math.atan2(a,u*s);return[Math.abs(s*Math.cos(l)*h+a*Math.sin(l)*o),Math.abs(a*Math.sin(f)*h+s*Math.cos(f)*o)]},_addBevelJoin:function(t,e,n,i,r,s,a,o){var h=t.getCurve(),u=h.getPrevious(),l=h.getPointAtTime(0),f=u.getNormalAtTime(1),d=h.getNormalAtTime(0),_=f.getDirectedAngle(d)<0?-n:n;if(f.setLength(_),d.setLength(_),r&&r._transformPoint(l,l),s&&(s._transformPoint(f,f),s._transformPoint(d,d)),o&&(a(l),a(l.add(f))),"miter"===e){var g=new m(l.add(f),new c((-f.y),f.x),(!0)).intersect(new m(l.add(d),new c((-d.y),d.x),(!0)),!0);if(g&&l.getDistance(g)<=i&&(a(g),!o))return}o||a(l.add(f)),a(l.add(d))},_addSquareCap:function(t,e,n,i,r,s,a){var o=t._point,h=t.getLocation(),u=h.getNormal().multiply(n);i&&i._transformPoint(o,o),r&&r._transformPoint(u,u),a&&(s(o.subtract(u)),s(o.add(u))),"square"===e&&(o=o.add(u.rotate(0===h.getTime()?-90:90))),s(o.add(u)),s(o.subtract(u))},getHandleBounds:function(t,e,n,i,r){var s,a,o=n.getStyle(),h=r.stroke&&o.hasStroke();if(h){var u=n._getStrokeMatrix(i,r),l=o.getStrokeWidth()/2,c=l;"miter"===o.getStrokeJoin()&&(c=l*o.getMiterLimit()),"square"===o.getStrokeCap()&&(c=Math.max(c,l*Math.sqrt(2))),s=E._getStrokePadding(l,u),a=E._getStrokePadding(c,u)}for(var f=new Array(6),d=1/0,_=-d,v=d,p=_,m=0,y=t.length;m<y;m++){var w=t[m];w._transformCoordinates(i,f);for(var x=0;x<6;x+=2){var b=0===x?a:s,C=b?b[0]:0,S=b?b[1]:0,k=f[x],I=f[x+1],P=k-C,M=k+C,A=I-S,T=I+S;P<d&&(d=P),M>_&&(_=M),A<v&&(v=A),T>p&&(p=T)}}return new g(d,v,_-d,p-v)}}});E.inject({statics:new function(){function t(t,e,n){var i=r.getNamed(n),s=new E(i&&i.insert===!1&&w.NO_INSERT);return s._add(t),s._closed=e,s.set(i)}function e(e,n,r){for(var s=new Array(4),a=0;a<4;a++){var o=i[a];s[a]=new M(o._point.multiply(n).add(e),o._handleIn.multiply(n),o._handleOut.multiply(n))}return t(s,!0,r)}var n=.5522847498307936,i=[new M([-1,0],[0,n],[0,-n]),new M([0,-1],[-n,0],[n,0]),new M([1,0],[0,-n],[0,n]),new M([0,1],[n,0],[-n,0])];return{Line:function(){return t([new M(c.readNamed(arguments,"from")),new M(c.readNamed(arguments,"to"))],!1,arguments)},Circle:function(){var t=c.readNamed(arguments,"center"),n=r.readNamed(arguments,"radius");return e(t,new d(n),arguments)},Rectangle:function(){var e,i=g.readNamed(arguments,"rectangle"),r=d.readNamed(arguments,"radius",0,{readNull:!0}),s=i.getBottomLeft(!0),a=i.getTopLeft(!0),o=i.getTopRight(!0),h=i.getBottomRight(!0);if(!r||r.isZero())e=[new M(s),new M(a),new M(o),new M(h)];else{r=d.min(r,i.getSize(!0).divide(2));var u=r.width,l=r.height,c=u*n,f=l*n;e=[new M(s.add(u,0),null,[-c,0]),new M(s.subtract(0,l),[0,f]),new M(a.add(0,l),null,[0,-f]),new M(a.add(u,0),[-c,0],null),new M(o.subtract(u,0),null,[c,0]),new M(o.add(0,l),[0,-f],null),new M(h.subtract(0,l),null,[0,f]),new M(h.subtract(u,0),[c,0])]}return t(e,!0,arguments)},RoundRectangle:"#Rectangle",Ellipse:function(){var t=C._readEllipse(arguments);return e(t.center,t.radius,arguments)},Oval:"#Ellipse",Arc:function(){var t=c.readNamed(arguments,"from"),e=c.readNamed(arguments,"through"),n=c.readNamed(arguments,"to"),i=r.getNamed(arguments),s=new E(i&&i.insert===!1&&w.NO_INSERT);return s.moveTo(t),s.arcTo(e,n),s.set(i)},RegularPolygon:function(){for(var e=c.readNamed(arguments,"center"),n=r.readNamed(arguments,"sides"),i=r.readNamed(arguments,"radius"),s=360/n,a=n%3===0,o=new c(0,a?-i:i),h=a?-1:.5,u=new Array(n),l=0;l<n;l++)u[l]=new M(e.add(o.rotate((l+h)*s)));return t(u,!0,arguments)},Star:function(){for(var e=c.readNamed(arguments,"center"),n=2*r.readNamed(arguments,"points"),i=r.readNamed(arguments,"radius1"),s=r.readNamed(arguments,"radius2"),a=360/n,o=new c(0,(-1)),h=new Array(n),u=0;u<n;u++)h[u]=new M(e.add(o.rotate(a*u).multiply(u%2?s:i)));return t(h,!0,arguments)}}}});var L=O.extend({_class:"CompoundPath",_serializeFields:{children:[]},initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||("string"==typeof t?this.setPathData(t):this.addChildren(Array.isArray(t)?t:arguments))},insertChildren:function mt(t,n,i){for(var r=n.length-1;r>=0;r--){var s=n[r];s instanceof L&&(n=n.slice(),n.splice.apply(n,[r,1].concat(s.removeChildren())),s.remove())}n=mt.base.call(this,t,n,i,E);for(var r=0,a=!i&&n&&n.length;r<a;r++){var s=n[r];s._clockwise===e&&s.setClockwise(0===s._index)}return n},reduce:function yt(t){for(var e=this._children,n=e.length-1;n>=0;n--){var i=e[n].reduce(t);i.isEmpty()&&i.remove()}if(0===e.length){var i=new E(w.NO_INSERT);return i.copyAttributes(this),i.insertAbove(this),this.remove(),i}return yt.base.call(this)},isClockwise:function(){var t=this.getFirstChild();return t&&t.isClockwise()},setClockwise:function(t){this.isClockwise()^!!t&&this.reverse()},getFirstSegment:function(){var t=this.getFirstChild();return t&&t.getFirstSegment()},getLastSegment:function(){var t=this.getLastChild();return t&&t.getLastSegment()},getCurves:function(){for(var t=this._children,e=[],n=0,i=t.length;n<i;n++)e.push.apply(e,t[n].getCurves());return e},getFirstCurve:function(){var t=this.getFirstChild();return t&&t.getFirstCurve()},getLastCurve:function(){var t=this.getLastChild();return t&&t.getFirstCurve()},getArea:function(){for(var t=this._children,e=0,n=0,i=t.length;n<i;n++)e+=t[n].getArea();return e}},{beans:!0,getPathData:function(t,e){for(var n=this._children,i=[],r=0,s=n.length;r<s;r++){var a=n[r],o=a._matrix;i.push(a.getPathData(t&&!o.isIdentity()?t.appended(o):t,e))}return i.join(" ")}},{_hitTestChildren:function wt(t,e,n){return wt.base.call(this,t,e["class"]===E||"path"===e.type?e:r.set({},e,{fill:!1}),n)},_draw:function(t,e,n,i){var r=this._children;if(0!==r.length){e=e.extend({dontStart:!0,dontFinish:!0}),t.beginPath();for(var s=0,a=r.length;s<a;s++)r[s].draw(t,e,i);if(!e.clip){this._setStyles(t,e,n);var o=this._style;o.hasFill()&&(t.fill(o.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),o.hasStroke()&&t.stroke()}}},_drawSelected:function(t,e,n){for(var i=this._children,r=0,s=i.length;r<s;r++){var a=i[r],o=a._matrix;n[a._id]||a._drawSelected(t,o.isIdentity()?e:e.appended(o))}}},new function(){function t(t,e){var n=t._children;if(e&&0===n.length)throw new Error("Use a moveTo() command first");return n[n.length-1]}return r.each(["lineTo","cubicCurveTo","quadraticCurveTo","curveTo","arcTo","lineBy","cubicCurveBy","quadraticCurveBy","curveBy","arcBy"],function(e){this[e]=function(){var n=t(this,!0);n[e].apply(n,arguments)}},{moveTo:function(){var e=t(this),n=e&&e.isEmpty()?e:new E(w.NO_INSERT);n!==e&&this.addChild(n),n.moveTo.apply(n,arguments)},moveBy:function(){var e=t(this,!0),n=e&&e.getLastSegment(),i=c.read(arguments);this.moveTo(n?i.add(n._point):i)},closePath:function(e){t(this,!0).closePath(e)}})},r.each(["reverse","flatten","simplify","smooth"],function(t){this[t]=function(e){for(var n,i=this._children,r=0,s=i.length;r<s;r++)n=i[r][t](e)||n;return n}},{}));O.inject(new function(){function t(t,e){var n=t.clone(!1).reduce({simplify:!0}).transform(null,!0,!0);return e?n.resolveCrossings():n}function e(t,e,n,i,r){var s=new t(w.NO_INSERT);return s.addChildren(e,!0),n&&(s=s.reduce({simplify:!0})),s.insertAbove(r&&i.isSibling(r)&&i.getIndex()<r.getIndex()?r:i),s.copyAttributes(i,!0),s}function n(n,r,s){function o(t){for(var e=0,n=t.length;e<n;e++){var i=t[e];g.push.apply(g,i._segments),v.push.apply(v,i._getMonoCurves()),i._overlapsOnly=i._validOverlapsOnly=!0}}var u=f[s];if(u[s]=!0,!n._children&&!n._closed)return i(n,r,u);var c=t(n,!0),d=r&&n!==r&&t(r,!0);d&&(u.subtract||u.exclude)^(d.isClockwise()^c.isClockwise())&&d.reverse();var _=a(z.expand(c.getCrossings(d))),g=[],v=[];o(c._children||[c]),d&&o(d._children||[d]);for(var p=0,m=_.length;p<m;p++)h(_[p]._segment,c,d,v,u);for(var p=0,m=g.length;p<m;p++){var y=g[p],w=y._intersection;if(null==y._winding&&h(y,c,d,v,u),!w||!w._overlap){var x=y._path;x._overlapsOnly=!1,u[y._winding]&&(x._validOverlapsOnly=!1)}}return e(L,l(g,u),!0,n,r)}function i(n,i,r){function s(t){if(o.contains(t.getPointAt(t.getLength()/2))^u)return l.unshift(t),!0}if(!i||!i._children&&!i._closed||!r.subtract&&!r.intersect)return null;for(var a=t(n,!1),o=t(i,!1),h=a.getCrossings(o),u=r.subtract,l=[],c=h.length-1;c>=0;c--){var f=h[c].split();f&&(s(f)&&f.getFirstSegment().setHandleIn(0,0),a.getLastSegment().setHandleOut(0,0))}return s(a),e(x,l,!1,n,i)}function s(t,e){for(var n=t;n;){if(n===e)return;n=n._previous}for(;t._next&&t._next!==e;)t=t._next;if(!t._next){for(;e._previous;)e=e._previous;t._next=e,e._previous=t}}function a(t,e){for(var n,i,r=e&&[],a=4e-7,o=1-a,h=!1,u=[],l=t.length-1;l>=0;l--){var c=t[l];if(e){if(!e(c))continue;r.unshift(c)}var f,d=c._curve,_=c._time,g=_;if(d!==n?h=!d.hasHandles():i>=a&&i<=o&&(_/=i),_<a)f=d._segment1;else if(_>o)f=d._segment2;else{var v=d.divideAtTime(_,!0);h&&u.push(d,v),f=v._segment1}c._setSegment(f);var p=f._intersection,m=c._intersection;if(p){s(p,m);for(var y=p;y;)s(y._intersection,p),y=y._next}else f._intersection=m;n=d,i=g}for(var l=0,w=u.length;l<w;l++)u[l].clearHandles();return r||t}function o(t,e,n){var i=2e-7,r=t.x,s=t.y,a=0,h=0,u=e.length,l=[],f=Math.abs;if(n){for(var d=-(1/0),_=1/0,g=s-i,v=s+i,p=0;p<u;p++)for(var m=e[p].values,y=T.solveCubic(m,0,r,l,0,1),w=y-1;w>=0;w--){var x=T.getPoint(m,l[w]).y;x<g&&x>d?d=x:x>v&&x<_&&(_=x)}d=(d+s)/2,_=(_+s)/2,d>-(1/0)&&(a=o(new c(r,d),e).winding),_<1/0&&(h=o(new c(r,_),e).winding)}else{for(var b,C,S=r-i,k=r+i,I=0,P=0,M=!1,p=0;p<u;p++){var A=e[p],z=A.winding,m=A.values,O=m[1],E=m[7];if(A.last&&(b=A.last.winding,C=A.last.values[6],M=!1),s>=O&&s<=E||s>=E&&s<=O)if(z){var L=s===O?m[0]:s===E?m[6]:1===T.solveCubic(m,1,s,l,0,1)?T.getPoint(m,l[0]).x:null;null!=L&&(L>=S&&L<=k?M=!0:s===O&&z===b||s===O&&(r-L)*(r-C)<0||(L<S?a+=z:L>k&&(h+=z))),b=z,C=m[6]}else(r-m[0])*(r-m[6])<=0&&(M=!0);M&&(p>=u-1||e[p+1].last)&&(I+=1,P-=1)}0===a&&0===h&&(a=I,h=P)}return{winding:Math.max(f(a),f(h)),contour:!a^!h}}function h(t,e,n,i,r){var s,a=[],h=t,u=0;do{var l=t.getCurve(),c=l.getLength();a.push({segment:t,curve:l,length:c}),u+=c,t=t.getNext()}while(t&&!t._intersection&&t!==h);for(var c=u/2,f=0,d=a.length;f<d;f++){var _=a[f],g=_.length;if(c<=g){var l=_.curve,v=l._path,p=v._parent,m=l.getTimeAt(c),y=l.getPointAtTime(m),w=Math.abs(l.getTangentAtTime(m).y)<1e-7;p instanceof L&&(v=p),s=r.subtract&&n&&(v===e&&n._getWinding(y,w)||v===n&&!e._getWinding(y,w))?{winding:0}:o(y,i,w);break}c-=g}for(var f=a.length-1;f>=0;f--){var x=a[f].segment;x._winding=s.winding,x._contour=s.contour}}function l(t,e){function n(t,n){return!(!t||t._visited||!(!e||e[t._winding]||!n&&e.unite&&t._contour))}function i(t){return t===a||t===o}function s(t,r){if(!t._next)return t;for(;t;){var s=t._segment,a=s.getNext(),o=a&&a._intersection;if(s!==r&&(i(s)||i(a)||!s._visited&&!a._visited&&(!e||n(s)&&(n(a)||o&&n(o._segment)))))return t;t=t._next}return null}for(var a,o,h=[],l=0,c=t.length;l<c;l++){var f,d=null,_=!1,g=t[l],v=g._intersection;if(!g._visited&&g._path._overlapsOnly){var p=g._path,m=v._segment._path,y=p._segments,x=m._segments;if(r.equals(y,x)){(e.unite||e.intersect)&&p.getArea()&&h.push(p.clone(!1));for(var b=0,C=y.length;b<C;b++)y[b]._visited=x[b]._visited=!0}}if(n(g,!0)&&(g._path._validOverlapsOnly||!v||!v._overlap)){for(a=o=null;;){v=v&&s(v,g)||v;var S=v&&v._segment;if(i(g)?_=!0:S&&(i(S)?(_=!0,g=S):n(S,n(g,!0))&&(e&&(e.intersect||e.subtract)&&(g._visited=!0),g=S)),_||g._visited){g._visited=!0;break}if(g._path._validOverlapsOnly&&!n(g))break;d||(d=new E(w.NO_INSERT),a=g,o=S);var k=g.getNext();d.add(new M(g._point,f,k&&g._handleOut)),g._visited=!0,g=k||g._path.getFirstSegment(),f=k&&k._handleIn,v=g._intersection}if(_)d.firstSegment.setHandleIn(f),d.setClosed(!0);else if(d){var I=d.getArea(!0);Math.abs(I)>=2e-7&&console.error("Boolean operation resulted in open path","segments =",d._segments.length,"length =",d.getLength(),"area=",I),d=null}d&&(d._segments.length>8||!u.isZero(d.getArea()))&&(h.push(d),d=null)}}return h}var f={unite:{1:!0},intersect:{2:!0},subtract:{1:!0},exclude:{1:!0}};return{_getWinding:function(t,e){return o(t,this._getMonoCurves(),e).winding},unite:function(t){return n(this,t,"unite")},intersect:function(t){return n(this,t,"intersect")},subtract:function(t){return n(this,t,"subtract")},exclude:function(t){return n(this,t,"exclude")},divide:function(t){return e(x,[this.subtract(t),this.intersect(t)],!0,this,t)},resolveCrossings:function(){function t(t){var e=t&&t._intersection;return e&&e._overlap}var e=this._children,n=e||[this],i=!1,s=!1,o=this.getIntersections(null,function(t){return t._overlap&&(i=!0)||t.isCrossing()&&(s=!0)});if(o=z.expand(o),i)for(var h=a(o,function(t){return t._overlap}),u=h.length-1;u>=0;u--){var c=h[u]._segment,f=c.getPrevious(),d=c.getNext();if(c._path&&t(f)&&t(d)){c.remove(),f._handleOut.set(0,0),d._handleIn.set(0,0);var _=f.getCurve();_.isStraight()&&0===_.getLength()&&f.remove()}}s&&(a(o,i&&function(t){var e=t.getCurve(),n=t._intersection._curve,i=t._segment;return!!(e&&n&&e._path&&n._path)||void(i&&(i._intersection=null))}),n=l(r.each(n,function(t){this.push.apply(this,t._segments)},[])));var g,v=n.length;if(v>1){n=n.slice().sort(function(t,e){return e.getBounds().getArea()-t.getBounds().getArea()});for(var p=n[0],m=[p],y={},x="nonzero"===this.getFillRule(),b=x&&r.each(n,function(t){this.push(t.isClockwise()?1:-1)},[]),u=1;u<v;u++){for(var C=n[u],S=C.getInteriorPoint(),k=!1,I=null,P=!1,M=u-1;M>=0&&!I;M--)if(n[M].contains(S)){if(x&&!k&&(b[u]+=b[M],b[u]&&b[M])){P=y[u]=!0;break}k=!0,I=!y[M]&&n[M]}P||(C.setClockwise(I?!I.isClockwise():p.isClockwise()),m.push(C))}n=m,v=m.length}return v>1&&e?(n!==e&&this.setChildren(n,!0),g=this):1!==v||e||(n[0]!==this&&this.setSegments(n[0].removeSegments()),g=this),g||(g=new L(w.NO_INSERT),g.addChildren(n,!0),g=g.reduce(),g.copyAttributes(this),this.replaceWith(g)),g}}}),E.inject({_getMonoCurves:function(){function t(t){var e=t[1],r=t[7],s=Math.abs((e-r)/(t[0]-t[6]))<2e-7?0:e>r?-1:1,a={values:t,winding:s};i.push(a),s&&(n=a)}function e(e){if(0!==T.getLength(e)){var n=e[1],i=e[3],r=e[5],s=e[7];if(T.isStraight(e)||n>=i==i>=r&&i>=r==r>=s)t(e);else{var a=3*(i-r)-n+s,o=2*(n+r)-4*i,h=i-n,l=4e-7,c=1-l,f=[],d=u.solveQuadratic(a,o,h,f,l,c);if(d<1)t(e);else{f.sort();var _=f[0],g=T.subdivide(e,_);t(g[0]),d>1&&(_=(f[1]-_)/(1-_),g=T.subdivide(g[1],_),t(g[0])),t(g[1])}}}}var n,i=this._monoCurves;if(!i){i=this._monoCurves=[];for(var r=this.getCurves(),s=this._segments,a=0,o=r.length;a<o;a++)e(r[a].getValues());if(!this._closed&&s.length>1){var h=s[s.length-1]._point,l=s[0]._point,c=h._x,f=h._y,d=l._x,_=l._y;e([c,f,c,f,d,_,d,_])}i.length>0&&(i[0].last=n)}return i},getInteriorPoint:function(){var t=this.getBounds(),e=t.getCenter(!0);if(!this.contains(e)){for(var n=this._getMonoCurves(),i=[],r=e.y,s=[],a=0,o=n.length;a<o;a++){var h=n[a].values;if(1===n[a].winding&&r>h[1]&&r<=h[7]||r>=h[7]&&r<h[1])for(var u=T.solveCubic(h,1,r,i,0,1),l=u-1;l>=0;l--)s.push(T.getPoint(h,i[l]).x)}s.sort(function(t,e){return t-e}),e.x=(s[0]+s[1])/2}return e}}),L.inject({_getMonoCurves:function(){for(var t=this._children,e=[],n=0,i=t.length;n<i;n++)e.push.apply(e,t[n]._getMonoCurves());return e}});var N=r.extend({_class:"PathIterator",initialize:function(t,e,n,i,r){function s(t,e){var n=T.getValues(t,e,r);h.push(n),a(n,t._index,0,1)}function a(t,n,r,s){if(!(s-r>c)||i&&T.isStraight(t)||T.isFlatEnough(t,e||.25)){var o=t[6]-t[0],h=t[7]-t[1],f=Math.sqrt(o*o+h*h);f>0&&(l+=f,u.push({offset:l,curve:t,index:n,time:s}))}else{var d=T.subdivide(t,.5),_=(r+s)/2;a(d[0],n,r,_),a(d[1],n,_,s)}}for(var o,h=[],u=[],l=0,c=1/(n||32),f=t._segments,d=f[0],_=1,g=f.length;_<g;_++)o=f[_],s(d,o),d=o;t._closed&&s(o,f[0]),this.curves=h,this.parts=u,this.length=l,this.index=0},_get:function(t){for(var e,n=this.index;e=n,!(0===n||this.parts[--n].offset<t););for(var i=this.parts.length;e<i;e++){var r=this.parts[e];if(r.offset>=t){this.index=e;var s=this.parts[e-1],a=s&&s.index===r.index?s.time:0,o=s?s.offset:0;return{index:r.index,time:a+(r.time-a)*(t-o)/(r.offset-o)}}}var r=this.parts[this.parts.length-1];return{index:r.index,time:1}},drawPart:function(t,e,n){for(var i=this._get(e),r=this._get(n),s=i.index,a=r.index;s<=a;s++){var o=T.getPart(this.curves[s],s===i.index?i.time:0,s===r.index?r.time:1);s===i.index&&t.moveTo(o[0],o[1]),t.bezierCurveTo.apply(t,o.slice(2))}}},r.each(T._evaluateMethods,function(t){this[t+"At"]=function(e){var n=this._get(e);return T[t](this.curves[n.index],n.time)}},{})),B=r.extend({initialize:function(t){for(var e,n=this.points=[],i=t._segments,r=t._closed,s=0,a=i.length;s<a;s++){var o=i[s].point;e&&e.equals(o)||n.push(e=o.clone())}r&&(n.unshift(n[n.length-1]),n.push(n[1])),this.closed=r},fit:function(t){var e=this.points,n=e.length,i=null;return n>0&&(i=[new M(e[0])],n>1&&(this.fitCubic(i,t,0,n-1,e[1].subtract(e[0]),e[n-2].subtract(e[n-1])),this.closed&&(i.shift(),i.pop()))),i},fitCubic:function(t,e,n,i,r,s){var a=this.points;if(i-n===1){var o=a[n],h=a[i],u=o.getDistance(h)/3;return void this.addCurve(t,[o,o.add(r.normalize(u)),h.add(s.normalize(u)),h])}for(var l,c=this.chordLengthParameterize(n,i),f=Math.max(e,e*e),d=!0,_=0;_<=4;_++){var g=this.generateBezier(n,i,c,r,s),v=this.findMaxError(n,i,g,c);if(v.error<e&&d)return void this.addCurve(t,g);if(l=v.index,v.error>=f)break;d=this.reparameterize(n,i,c,g),f=v.error}var p=a[l-1].subtract(a[l+1]);this.fitCubic(t,e,n,l,r,p),this.fitCubic(t,e,l,i,p.negate(),s)},addCurve:function(t,e){var n=t[t.length-1];n.setHandleOut(e[1].subtract(e[0])),t.push(new M(e[3],e[2].subtract(e[3])))},generateBezier:function(t,e,n,i,r){for(var s=1e-12,a=Math.abs,o=this.points,h=o[t],u=o[e],l=[[0,0],[0,0]],c=[0,0],f=0,d=e-t+1;f<d;f++){var _=n[f],g=1-_,v=3*_*g,p=g*g*g,m=v*g,y=v*_,w=_*_*_,x=i.normalize(m),b=r.normalize(y),C=o[t+f].subtract(h.multiply(p+m)).subtract(u.multiply(y+w));l[0][0]+=x.dot(x),l[0][1]+=x.dot(b),l[1][0]=l[0][1],l[1][1]+=b.dot(b),c[0]+=x.dot(C),c[1]+=b.dot(C)}var S,k,I=l[0][0]*l[1][1]-l[1][0]*l[0][1];if(a(I)>s){var P=l[0][0]*c[1]-l[1][0]*c[0],M=c[0]*l[1][1]-c[1]*l[0][1];S=M/I,k=P/I}else{var A=l[0][0]+l[0][1],T=l[1][0]+l[1][1];S=k=a(A)>s?c[0]/A:a(T)>s?c[1]/T:0}var z,O,E=u.getDistance(h),L=s*E;if(S<L||k<L)S=k=E/3;else{var N=u.subtract(h);z=i.normalize(S),O=r.normalize(k),z.dot(N)-O.dot(N)>E*E&&(S=k=E/3,z=O=null)}return[h,h.add(z||i.normalize(S)),u.add(O||r.normalize(k)),u]},reparameterize:function(t,e,n,i){for(var r=t;r<=e;r++)n[r-t]=this.findRoot(i,this.points[r],n[r-t]);for(var r=1,s=n.length;r<s;r++)if(n[r]<=n[r-1])return!1;return!0},findRoot:function(t,e,n){for(var i=[],r=[],s=0;s<=2;s++)i[s]=t[s+1].subtract(t[s]).multiply(3);for(var s=0;s<=1;s++)r[s]=i[s+1].subtract(i[s]).multiply(2);var a=this.evaluate(3,t,n),o=this.evaluate(2,i,n),h=this.evaluate(1,r,n),u=a.subtract(e),l=o.dot(o)+u.dot(h);return Math.abs(l)<1e-6?n:n-u.dot(o)/l},evaluate:function(t,e,n){for(var i=e.slice(),r=1;r<=t;r++)for(var s=0;s<=t-r;s++)i[s]=i[s].multiply(1-n).add(i[s+1].multiply(n));return i[0]},chordLengthParameterize:function(t,e){for(var n=[0],i=t+1;i<=e;i++)n[i-t]=n[i-t-1]+this.points[i].getDistance(this.points[i-1]);for(var i=1,r=e-t;i<=r;i++)n[i]/=n[r];return n},findMaxError:function(t,e,n,i){for(var r=Math.floor((e-t+1)/2),s=0,a=t+1;a<e;a++){var o=this.evaluate(3,n,i[a-t]),h=o.subtract(this.points[a]),u=h.x*h.x+h.y*h.y;u>=s&&(s=u,r=a)}return{error:s,index:r}}}),j=w.extend({_class:"TextItem",_applyMatrix:!1,_canApplyMatrix:!1,_serializeFields:{content:null},_boundsOptions:{stroke:!1,handle:!1},initialize:function(t){this._content="",this._lines=[];var n=t&&r.isPlainObject(t)&&t.x===e&&t.y===e;this._initialize(n&&t,!n&&c.read(arguments))},_equals:function(t){return this._content===t._content},copyContent:function(t){this.setContent(t._content)},getContent:function(){return this._content},setContent:function(t){this._content=""+t,this._lines=this._content.split(/\r\n|\n|\r/gm),this._changed(265)},isEmpty:function(){return!this._content},getCharacterStyle:"#getStyle",setCharacterStyle:"#setStyle",getParagraphStyle:"#getStyle",setParagraphStyle:"#setStyle"}),F=j.extend({_class:"PointText",initialize:function(){j.apply(this,arguments)},getPoint:function(){var t=this._matrix.getTranslation();return new f(t.x,t.y,this,"setPoint")},setPoint:function(){var t=c.read(arguments);this.translate(t.subtract(this._matrix.getTranslation()))},_draw:function(t,e,n){if(this._content){this._setStyles(t,e,n);var i=this._lines,r=this._style,s=r.hasFill(),a=r.hasStroke(),o=r.getLeading(),h=t.shadowColor;t.font=r.getFontStyle(),t.textAlign=r.getJustification();for(var u=0,l=i.length;u<l;u++){t.shadowColor=h;var c=i[u];s&&(t.fillText(c,0,0),t.shadowColor="rgba(0,0,0,0)"),a&&t.strokeText(c,0,0),t.translate(0,o)}}},_getBounds:function(t,e){var n=this._style,i=this._lines,r=i.length,s=n.getJustification(),a=n.getLeading(),o=this.getView().getTextWidth(n.getFontStyle(),i),h=0;"left"!==s&&(h-=o/("center"===s?2:1));var u=new g(h,r?-.75*a:0,o,r*a);return t?t._transformBounds(u,u):u}}),D=r.extend(new function(){function t(t){var i,r=t.match(/^#(\w{1,2})(\w{1,2})(\w{1,2})$/);if(r){i=[0,0,0];for(var s=0;s<3;s++){var o=r[s+1];i[s]=parseInt(1==o.length?o+o:o,16)/255}}else if(r=t.match(/^rgba?\((.*)\)$/)){i=r[1].split(",");for(var s=0,h=i.length;s<h;s++){var o=+i[s];i[s]=s<3?o/255:o}}else if(n){var u=a[t];if(!u){e||(e=tt.getContext(1,1),e.globalCompositeOperation="copy"),e.fillStyle="rgba(0,0,0,0)",e.fillStyle=t,e.fillRect(0,0,1,1);var l=e.getImageData(0,0,1,1).data;u=a[t]=[l[0]/255,l[1]/255,l[2]/255]}i=u.slice()}else i=[0,0,0];return i}var e,i={gray:["gray"],rgb:["red","green","blue"],hsb:["hue","saturation","brightness"],hsl:["hue","saturation","lightness"],gradient:["gradient","origin","destination","highlight"]},s={},a={},o=[[0,3,1],[2,0,1],[1,0,3],[1,2,0],[3,1,0],[0,1,2]],u={"rgb-hsb":function(t,e,n){var i=Math.max(t,e,n),r=Math.min(t,e,n),s=i-r,a=0===s?0:60*(i==t?(e-n)/s+(e<n?6:0):i==e?(n-t)/s+2:(t-e)/s+4);return[a,0===i?0:s/i,i]},"hsb-rgb":function(t,e,n){t=(t/60%6+6)%6;var i=Math.floor(t),r=t-i,i=o[i],s=[n,n*(1-e),n*(1-e*r),n*(1-e*(1-r))];return[s[i[0]],s[i[1]],s[i[2]]]},"rgb-hsl":function(t,e,n){var i=Math.max(t,e,n),r=Math.min(t,e,n),s=i-r,a=0===s,o=a?0:60*(i==t?(e-n)/s+(e<n?6:0):i==e?(n-t)/s+2:(t-e)/s+4),h=(i+r)/2,u=a?0:h<.5?s/(i+r):s/(2-i-r);return[o,u,h]},"hsl-rgb":function(t,e,n){if(t=(t/360%1+1)%1,0===e)return[n,n,n];for(var i=[t+1/3,t,t-1/3],r=n<.5?n*(1+e):n+e-n*e,s=2*n-r,a=[],o=0;o<3;o++){var h=i[o];h<0&&(h+=1),h>1&&(h-=1),a[o]=6*h<1?s+6*(r-s)*h:2*h<1?r:3*h<2?s+(r-s)*(2/3-h)*6:s}return a},"rgb-gray":function(t,e,n){return[.2989*t+.587*e+.114*n]},"gray-rgb":function(t){return[t,t,t]},"gray-hsb":function(t){return[0,0,t]},"gray-hsl":function(t){return[0,0,t]},"gradient-rgb":function(){return[]},"rgb-gradient":function(){return[]}};return r.each(i,function(t,e){s[e]=[],r.each(t,function(t,n){var a=r.capitalize(t),o=/^(hue|saturation)$/.test(t),h=s[e][n]="gradient"===t?function(t){var e=this._components[0];return t=R.read(Array.isArray(t)?t:arguments,0,{readNull:!0}),e!==t&&(e&&e._removeOwner(this),t&&t._addOwner(this)),t}:"gradient"===e?function(){return c.read(arguments,0,{readNull:"highlight"===t,clone:!0})}:function(t){return null==t||isNaN(t)?0:t};this["get"+a]=function(){return this._type===e||o&&/^hs[bl]$/.test(this._type)?this._components[n]:this._convert(e)[n]},this["set"+a]=function(t){this._type===e||o&&/^hs[bl]$/.test(this._type)||(this._components=this._convert(e),this._properties=i[e],this._type=e),this._components[n]=h.call(this,t),this._changed()}},this)},{_class:"Color",_readIndex:!0,initialize:function l(e){var n,r,a,o,h=Array.prototype.slice,u=arguments,c=this.__read,f=0;Array.isArray(e)&&(u=e,e=u[0]);var d=null!=e&&typeof e;if("string"===d&&e in i&&(n=e,e=u[1],Array.isArray(e)?(r=e,a=u[2]):(c&&(f=1),u=h.call(u,1),d=typeof e)),!r){if(o="number"===d?u:"object"===d&&null!=e.length?e:null){n||(n=o.length>=3?"rgb":"gray");var _=i[n].length;a=o[_],c&&(f+=o===arguments?_+(null!=a?1:0):1),o.length>_&&(o=h.call(o,0,_))}else if("string"===d)n="rgb",r=t(e),4===r.length&&(a=r[3],r.length--);else if("object"===d)if(e.constructor===l){if(n=e._type,r=e._components.slice(),a=e._alpha,"gradient"===n)for(var g=1,v=r.length;g<v;g++){var p=r[g];p&&(r[g]=p.clone())}}else if(e.constructor===R)n="gradient",o=u;else{n="hue"in e?"lightness"in e?"hsl":"hsb":"gradient"in e||"stops"in e||"radial"in e?"gradient":"gray"in e?"gray":"rgb";var m=i[n],y=s[n];this._components=r=[];for(var g=0,v=m.length;g<v;g++){var w=e[m[g]];null==w&&0===g&&"gradient"===n&&"stops"in e&&(w={stops:e.stops,radial:e.radial}),w=y[g].call(this,w),null!=w&&(r[g]=w)}a=e.alpha}c&&n&&(f=1)}if(this._type=n||"rgb",!r){this._components=r=[];for(var y=s[this._type],g=0,v=y.length;g<v;g++){var w=y[g].call(this,o&&o[g]);null!=w&&(r[g]=w)}}this._components=r,this._properties=i[this._type],this._alpha=a,c&&(this.__read=f)},_set:"#initialize",_serialize:function(t,e){var n=this.getComponents();return r.serialize(/^(gray|rgb)$/.test(this._type)?n:[this._type].concat(n),t,!0,e)},_changed:function(){this._canvasStyle=null,this._owner&&this._owner._changed(65)},_convert:function(t){var e;return this._type===t?this._components.slice():(e=u[this._type+"-"+t])?e.apply(this,this._components):u["rgb-"+t].apply(this,u[this._type+"-rgb"].apply(this,this._components))},convert:function(t){return new D(t,this._convert(t),this._alpha)},getType:function(){return this._type},setType:function(t){this._components=this._convert(t),this._properties=i[t],this._type=t},getComponents:function(){var t=this._components.slice();return null!=this._alpha&&t.push(this._alpha),t},getAlpha:function(){return null!=this._alpha?this._alpha:1},setAlpha:function(t){this._alpha=null==t?null:Math.min(Math.max(t,0),1),this._changed()},hasAlpha:function(){return null!=this._alpha},equals:function(t){var e=r.isPlainValue(t,!0)?D.read(arguments):t;return e===this||e&&this._class===e._class&&this._type===e._type&&this._alpha===e._alpha&&r.equals(this._components,e._components)||!1},toString:function(){for(var t=this._properties,e=[],n="gradient"===this._type,i=h.instance,r=0,s=t.length;r<s;r++){var a=this._components[r];null!=a&&e.push(t[r]+": "+(n?a:i.number(a)))}return null!=this._alpha&&e.push("alpha: "+i.number(this._alpha)),"{ "+e.join(", ")+" }"},toCSS:function(t){function e(t){return Math.round(255*(t<0?0:t>1?1:t))}var n=this._convert("rgb"),i=t||null==this._alpha?1:this._alpha;return n=[e(n[0]),e(n[1]),e(n[2])],i<1&&n.push(i<0?0:i),t?"#"+((1<<24)+(n[0]<<16)+(n[1]<<8)+n[2]).toString(16).slice(1):(4==n.length?"rgba(":"rgb(")+n.join(",")+")"},toCanvasStyle:function(t){if(this._canvasStyle)return this._canvasStyle;if("gradient"!==this._type)return this._canvasStyle=this.toCSS();var e,n=this._components,i=n[0],r=i._stops,s=n[1],a=n[2];if(i._radial){var o=a.getDistance(s),h=n[3];if(h){var u=h.subtract(s);u.getLength()>o&&(h=s.add(u.normalize(o-.1)))}var l=h||s;e=t.createRadialGradient(l.x,l.y,0,s.x,s.y,o)}else e=t.createLinearGradient(s.x,s.y,a.x,a.y);for(var c=0,f=r.length;c<f;c++){var d=r[c];e.addColorStop(d._offset||c/(f-1),d._color.toCanvasStyle())}return this._canvasStyle=e},transform:function(t){if("gradient"===this._type){for(var e=this._components,n=1,i=e.length;n<i;n++){var r=e[n];t._transformPoint(r,r,!0)}this._changed()}},statics:{_types:i,random:function(){var t=Math.random;return new D(t(),t(),t())}}})},new function(){var t={add:function(t,e){return t+e},subtract:function(t,e){return t-e},multiply:function(t,e){return t*e},divide:function(t,e){return t/e}};return r.each(t,function(t,e){this[e]=function(e){e=D.read(arguments);for(var n=this._type,i=this._components,r=e._convert(n),s=0,a=i.length;s<a;s++)r[s]=t(i[s],r[s]);return new D(n,r,null!=this._alpha?t(this._alpha,e.getAlpha()):null)}},{})}),R=r.extend({_class:"Gradient",initialize:function(t,e){this._id=l.get(),t&&this._set(t)&&(t=e=null),this._stops||this.setStops(t||["white","black"]),null==this._radial&&this.setRadial("string"==typeof e&&"radial"===e||e||!1)},_serialize:function(t,e){return e.add(this,function(){return r.serialize([this._stops,this._radial],t,!0,e)})},_changed:function(){for(var t=0,e=this._owners&&this._owners.length;t<e;t++)this._owners[t]._changed()},_addOwner:function(t){this._owners||(this._owners=[]),this._owners.push(t)},_removeOwner:function(t){var n=this._owners?this._owners.indexOf(t):-1;n!=-1&&(this._owners.splice(n,1),0===this._owners.length&&(this._owners=e))},clone:function(){for(var t=[],e=0,n=this._stops.length;e<n;e++)t[e]=this._stops[e].clone();return new R(t,this._radial)},getStops:function(){return this._stops},setStops:function(t){if(t.length<2)throw new Error("Gradient stop list needs to contain at least two stops.");var n=this._stops;if(n)for(var i=0,r=n.length;i<r;i++)n[i]._owner=e;n=this._stops=q.readAll(t,0,{clone:!0});for(var i=0,r=n.length;i<r;i++)n[i]._owner=this;this._changed()},getRadial:function(){return this._radial},setRadial:function(t){this._radial=t,this._changed()},equals:function(t){if(t===this)return!0;if(t&&this._class===t._class){var e=this._stops,n=t._stops,i=e.length;if(i===n.length){for(var r=0;r<i;r++)if(!e[r].equals(n[r]))return!1;return!0}}return!1}}),q=r.extend({_class:"GradientStop",initialize:function(t,n){var i=t,r=n;"object"==typeof t&&n===e&&(Array.isArray(t)&&"number"!=typeof t[0]?(i=t[0],r=t[1]):("color"in t||"offset"in t||"rampPoint"in t)&&(i=t.color,r=t.offset||t.rampPoint||0)),this.setColor(i),this.setOffset(r)},clone:function(){return new q(this._color.clone(),this._offset)},_serialize:function(t,e){var n=this._color,i=this._offset;return r.serialize(null==i?[n]:[n,i],t,!0,e)},_changed:function(){this._owner&&this._owner._changed(65)},getOffset:function(){return this._offset},setOffset:function(t){this._offset=t,this._changed()},getRampPoint:"#getOffset",setRampPoint:"#setOffset",getColor:function(){return this._color},setColor:function(){var t=D.read(arguments,0,{clone:!0});t&&(t._owner=this),this._color=t,this._changed()},equals:function(t){return t===this||t&&this._class===t._class&&this._color.equals(t._color)&&this._offset==t._offset||!1}}),V=r.extend(new function(){var t={fillColor:null,fillRule:"nonzero",strokeColor:null,strokeWidth:1,strokeCap:"butt",strokeJoin:"miter",strokeScaling:!0,miterLimit:10,dashOffset:0,dashArray:[],shadowColor:null,shadowBlur:0,shadowOffset:new c,selectedColor:null},n=r.set({},t,{fontFamily:"sans-serif",fontWeight:"normal",fontSize:12,leading:null,justification:"left"}),i=r.set({},n,{fillColor:new D}),s={strokeWidth:97,strokeCap:97,strokeJoin:97,strokeScaling:105,miterLimit:97,fontFamily:9,fontWeight:9,fontSize:9,font:9,leading:9,justification:9},a={beans:!0},o={_class:"Style",beans:!0,initialize:function(e,r,s){this._values={},this._owner=r,this._project=r&&r._project||s||paper.project,this._defaults=!r||r instanceof x?n:r instanceof j?i:t,e&&this.set(e)}};return r.each(n,function(t,n){var i=/Color$/.test(n),h="shadowOffset"===n,u=r.capitalize(n),l=s[n],f="set"+u,d="get"+u;o[f]=function(t){var r=this._owner,s=r&&r._children;if(s&&s.length>0&&!(r instanceof L))for(var a=0,o=s.length;a<o;a++)s[a]._style[f](t);else if(n in this._defaults){var h=this._values[n];h!==t&&(i&&(h&&h._owner!==e&&(h._owner=e),t&&t.constructor===D&&(t._owner&&(t=t.clone()),t._owner=r)),this._values[n]=t,r&&r._changed(l||65))}},o[d]=function(t){var s,a=this._owner,o=a&&a._children;if(n in this._defaults&&(!o||0===o.length||t||a instanceof L)){var s=this._values[n];if(s===e)s=this._defaults[n],s&&s.clone&&(s=s.clone());else{var u=i?D:h?c:null;!u||s&&s.constructor===u||(this._values[n]=s=u.read([s],0,{readNull:!0,clone:!0}),s&&i&&(s._owner=a))}}else if(o)for(var l=0,f=o.length;l<f;l++){var _=o[l]._style[d]();if(0===l)s=_;else if(!r.equals(s,_))return e}return s},a[d]=function(t){return this._style[d](t)},a[f]=function(t){this._style[f](t)}}),r.each({Font:"FontFamily",WindingRule:"FillRule"},function(t,e){var n="get"+e,i="set"+e;o[n]=a[n]="#get"+t,o[i]=a[i]="#set"+t}),w.inject(a),o},{set:function(t){var e=t instanceof V,n=e?t._values:t;if(n)for(var i in n)if(i in this._defaults){
var r=n[i];this[i]=r&&e&&r.clone?r.clone():r}},equals:function(t){return t===this||t&&this._class===t._class&&r.equals(this._values,t._values)||!1},hasFill:function(){var t=this.getFillColor();return!!t&&t.alpha>0},hasStroke:function(){var t=this.getStrokeColor();return!!t&&t.alpha>0&&this.getStrokeWidth()>0},hasShadow:function(){var t=this.getShadowColor();return!!t&&t.alpha>0&&(this.getShadowBlur()>0||!this.getShadowOffset().isZero())},getView:function(){return this._project._view},getFontStyle:function(){var t=this.getFontSize();return this.getFontWeight()+" "+t+(/[a-z]/i.test(t+"")?" ":"px ")+this.getFontFamily()},getFont:"#getFontFamily",setFont:"#setFontFamily",getLeading:function xt(){var t=xt.base.call(this),e=this.getFontSize();return/pt|em|%|px/.test(e)&&(e=this.getView().getPixelSize(e)),null!=t?t:1.2*e}}),H=new function(){function t(t,e,n,i){for(var r=["","webkit","moz","Moz","ms","o"],s=e[0].toUpperCase()+e.substring(1),a=0;a<6;a++){var o=r[a],h=o?o+s:e;if(h in t){if(!n)return t[h];t[h]=i;break}}}return{getStyles:function(t){var e=t&&9!==t.nodeType?t.ownerDocument:t,n=e&&e.defaultView;return n&&n.getComputedStyle(t,"")},getBounds:function(t,e){var n,i=t.ownerDocument,r=i.body,s=i.documentElement;try{n=t.getBoundingClientRect()}catch(a){n={left:0,top:0,width:0,height:0}}var o=n.left-(s.clientLeft||r.clientLeft||0),h=n.top-(s.clientTop||r.clientTop||0);if(!e){var u=i.defaultView;o+=u.pageXOffset||s.scrollLeft||r.scrollLeft,h+=u.pageYOffset||s.scrollTop||r.scrollTop}return new g(o,h,n.width,n.height)},getViewportBounds:function(t){var e=t.ownerDocument,n=e.defaultView,i=e.documentElement;return new g(0,0,n.innerWidth||i.clientWidth,n.innerHeight||i.clientHeight)},getOffset:function(t,e){return H.getBounds(t,e).getPoint()},getSize:function(t){return H.getBounds(t,!0).getSize()},isInvisible:function(t){return H.getSize(t).equals(new d(0,0))},isInView:function(t){return!H.isInvisible(t)&&H.getViewportBounds(t).intersects(H.getBounds(t,!0))},isInserted:function(t){return i.body.contains(t)},getPrefixed:function(e,n){return e&&t(e,n)},setPrefixed:function(e,n,i){if("object"==typeof n)for(var r in n)t(e,r,!0,n[r]);else t(e,n,!0,i)}}},U={add:function(t,e){if(t)for(var n in e)for(var i=e[n],r=n.split(/[\s,]+/g),s=0,a=r.length;s<a;s++)t.addEventListener(r[s],i,!1)},remove:function(t,e){if(t)for(var n in e)for(var i=e[n],r=n.split(/[\s,]+/g),s=0,a=r.length;s<a;s++)t.removeEventListener(r[s],i,!1)},getPoint:function(t){var e=t.targetTouches?t.targetTouches.length?t.targetTouches[0]:t.changedTouches[0]:t;return new c(e.pageX||e.clientX+i.documentElement.scrollLeft,e.pageY||e.clientY+i.documentElement.scrollTop)},getTarget:function(t){return t.target||t.srcElement},getRelatedTarget:function(t){return t.relatedTarget||t.toElement},getOffset:function(t,e){return U.getPoint(t).subtract(H.getOffset(e||U.getTarget(t)))}};U.requestAnimationFrame=new function(){function t(){var e=s;s=[];for(var n=0,a=e.length;n<a;n++)e[n]();r=i&&s.length,r&&i(t)}var e,i=H.getPrefixed(n,"requestAnimationFrame"),r=!1,s=[];return function(n){s.push(n),i?r||(i(t),r=!0):e||(e=setInterval(t,1e3/60))}};var Z=r.extend(s,{_class:"View",initialize:function bt(t,e){function r(t){return e[t]||parseInt(e.getAttribute(t),10)}function s(){var t=H.getSize(e);return t.isNaN()||t.isZero()?new d(r("width"),r("height")):t}var o;if(n&&e){this._id=e.getAttribute("id"),null==this._id&&e.setAttribute("id",this._id="view-"+bt._id++),U.add(e,this._viewEvents);var h="none";if(H.setPrefixed(e.style,{userDrag:h,userSelect:h,touchCallout:h,contentZooming:h,tapHighlightColor:"rgba(0,0,0,0)"}),a.hasAttribute(e,"resize")){var u=this;U.add(n,this._windowEvents={resize:function(){u.setViewSize(s())}})}if(o=s(),a.hasAttribute(e,"stats")&&"undefined"!=typeof Stats){this._stats=new Stats;var l=this._stats.domElement,c=l.style,f=H.getOffset(e);c.position="absolute",c.left=f.x+"px",c.top=f.y+"px",i.body.appendChild(l)}}else o=new d(e),e=null;this._project=t,this._scope=t._scope,this._element=e,this._pixelRatio||(this._pixelRatio=n&&n.devicePixelRatio||1),this._setElementSize(o.width,o.height),this._viewSize=o,bt._views.push(this),bt._viewsById[this._id]=this,(this._matrix=new p)._owner=this,this._zoom=1,bt._focused||(bt._focused=this),this._frameItems={},this._frameItemCount=0,this._itemEvents={"native":{},virtual:{}},this._autoUpdate=!paper.agent.node,this._needsUpdate=!1},remove:function(){if(!this._project)return!1;Z._focused===this&&(Z._focused=null),Z._views.splice(Z._views.indexOf(this),1),delete Z._viewsById[this._id];var t=this._project;return t._view===this&&(t._view=null),U.remove(this._element,this._viewEvents),U.remove(n,this._windowEvents),this._element=this._project=null,this.off("frame"),this._animate=!1,this._frameItems={},!0},_events:r.each(w._itemHandlers.concat(["onResize","onKeyDown","onKeyUp"]),function(t){this[t]={}},{onFrame:{install:function(){this.play()},uninstall:function(){this.pause()}}}),_animate:!1,_time:0,_count:0,getAutoUpdate:function(){return this._autoUpdate},setAutoUpdate:function(t){this._autoUpdate=t,t&&this.requestUpdate()},update:function(){},draw:function(){this.update()},requestUpdate:function(){if(!this._requested){var t=this;U.requestAnimationFrame(function(){if(t._requested=!1,t._animate){t.requestUpdate();var e=t._element;H.getPrefixed(i,"hidden")&&"true"!==a.getAttribute(e,"keepalive")||!H.isInView(e)||t._handleFrame()}t._autoUpdate&&t.update()}),this._requested=!0}},play:function(){this._animate=!0,this.requestUpdate()},pause:function(){this._animate=!1},_handleFrame:function(){paper=this._scope;var t=Date.now()/1e3,e=this._last?t-this._last:0;this._last=t,this.emit("frame",new r({delta:e,time:this._time+=e,count:this._count++})),this._stats&&this._stats.update()},_animateItem:function(t,e){var n=this._frameItems;e?(n[t._id]={item:t,time:0,count:0},1===++this._frameItemCount&&this.on("frame",this._handleFrameItems)):(delete n[t._id],0===--this._frameItemCount&&this.off("frame",this._handleFrameItems))},_handleFrameItems:function(t){for(var e in this._frameItems){var n=this._frameItems[e];n.item.emit("frame",new r(t,{time:n.time+=t.delta,count:n.count++}))}},_changed:function(){this._project._changed(2049),this._bounds=null},getElement:function(){return this._element},getPixelRatio:function(){return this._pixelRatio},getResolution:function(){return 72*this._pixelRatio},getViewSize:function(){var t=this._viewSize;return new _(t.width,t.height,this,"setViewSize")},setViewSize:function(){var t=d.read(arguments),e=t.width,n=t.height,i=t.subtract(this._viewSize);i.isZero()||(this._setElementSize(e,n),this._viewSize.set(e,n),this.emit("resize",{size:t,delta:i}),this._changed(),this._autoUpdate&&this.requestUpdate())},_setElementSize:function(t,e){var n=this._element;n&&(n.width!==t&&(n.width=t),n.height!==e&&(n.height=e))},getBounds:function(){return this._bounds||(this._bounds=this._matrix.inverted()._transformBounds(new g(new c,this._viewSize))),this._bounds},getSize:function(){return this.getBounds().getSize()},getCenter:function(){return this.getBounds().getCenter()},setCenter:function(){var t=c.read(arguments);this.translate(this.getCenter().subtract(t))},getZoom:function(){return this._zoom},setZoom:function(t){this.transform((new p).scale(t/this._zoom,this.getCenter())),this._zoom=t},getMatrix:function(){return this._matrix},setMatrix:function(){var t=this._matrix;t.initialize.apply(t,arguments)},isVisible:function(){return H.isInView(this._element)},isInserted:function(){return H.isInserted(this._element)},getPixelSize:function(t){var e,n=this._element;if(n){var r=n.parentNode,s=i.createElement("div");s.style.fontSize=t,r.appendChild(s),e=parseFloat(H.getStyles(s).fontSize),r.removeChild(s)}else e=parseFloat(e);return e},getTextWidth:function(t,e){return 0}},r.each(["rotate","scale","shear","skew"],function(t){var e="rotate"===t;this[t]=function(){var n=(e?r:c).read(arguments),i=c.read(arguments,0,{readNull:!0});return this.transform((new p)[t](n,i||this.getCenter(!0)))}},{translate:function(){var t=new p;return this.transform(t.translate.apply(t,arguments))},transform:function(t){this._matrix.append(t)},scrollBy:function(){this.translate(c.read(arguments).negate())}}),{projectToView:function(){return this._matrix._transformPoint(c.read(arguments))},viewToProject:function(){return this._matrix._inverseTransform(c.read(arguments))},getEventPoint:function(t){return this.viewToProject(U.getOffset(t,this._element))}},{statics:{_views:[],_viewsById:{},_id:0,create:function(t,e){i&&"string"==typeof e&&(e=i.getElementById(e));var r=n?W:Z;return new r(t,e)}}},new function(){function t(t){var e=U.getTarget(t);return e.getAttribute&&Z._viewsById[e.getAttribute("id")]}function e(){var t=Z._focused;if(!t||!t.isVisible())for(var e=0,n=Z._views.length;e<n;e++)if((t=Z._views[e]).isVisible()){Z._focused=h=t;break}}function r(t,e,n){t._handleMouseEvent("mousemove",e,n)}function s(t,e,n,i,r,s,a){function o(t,n){if(t.responds(n)){if(h||(h=new X(n,i,r,e||t,s?r.subtract(s):null)),t.emit(n,h)&&(I=!0,h.prevented&&(P=!0),h.stopped))return u=!0}else{var a=M[n];if(a)return o(t,a)}}for(var h,u=!1;t&&t!==a&&!o(t,n);)t=t._parent;return u}function a(t,e,n,i,r,a){return t._project.removeOn(n),P=I=!1,b&&s(b,null,n,i,r,a)||e&&e!==b&&!e.isDescendant(b)&&s(e,null,M[n]||n,i,r,a,b)||s(t,b||e||t,n,i,r,a)}if(n){var o,h,u,l,c,f=!1,d=!1,_=n.navigator;_.pointerEnabled||_.msPointerEnabled?(u="pointerdown MSPointerDown",l="pointermove MSPointerMove",c="pointerup pointercancel MSPointerUp MSPointerCancel"):(u="touchstart",l="touchmove",c="touchend touchcancel","ontouchstart"in n&&_.userAgent.match(/mobile|tablet|ip(ad|hone|od)|android|silk/i)||(u+=" mousedown",l+=" mousemove",c+=" mouseup"));var g={},v={mouseout:function(t){var e=Z._focused,n=U.getRelatedTarget(t);if(e&&(!n||"HTML"===n.nodeName)){var i=U.getOffset(t,e._element),s=i.x,a=Math.abs,o=a(s),h=1<<25,u=o-h;i.x=a(u)<o?u*(s<0?-1:1):s,r(e,t,e.viewToProject(i))}},scroll:e};g[u]=function(e){var n=Z._focused=t(e);f||(f=!0,n._handleMouseEvent("mousedown",e))},v[l]=function(n){var i=Z._focused;if(!d){var s=t(n);s?i!==s&&(i&&r(i,n),o||(o=i),i=Z._focused=h=s):h&&h===i&&(o&&!o.isInserted()&&(o=null),i=Z._focused=o,o=null,e())}i&&r(i,n)},v[u]=function(){d=!0},v[c]=function(t){var e=Z._focused;e&&f&&e._handleMouseEvent("mouseup",t),d=f=!1},U.add(i,v),U.add(n,{load:e});var p,m,y,w,x,b,C,S,k,I=!1,P=!1,M={doubleclick:"click",mousedrag:"mousemove"},A=!1,T={mousedown:{mousedown:1,mousedrag:1,click:1,doubleclick:1},mouseup:{mouseup:1,mousedrag:1,click:1,doubleclick:1},mousemove:{mousedrag:1,mousemove:1,mouseenter:1,mouseleave:1}};return{_viewEvents:g,_handleMouseEvent:function(t,e,n){function i(t){return r.virtual[t]||l.responds(t)||u&&u.responds(t)}var r=this._itemEvents,o=r["native"][t],h="mousemove"===t,u=this._scope.tool,l=this;h&&f&&i("mousedrag")&&(t="mousedrag"),n||(n=this.getEventPoint(e));var c=this.getBounds().contains(n),d=o&&c&&l._project.hitTest(n,{tolerance:0,fill:!0,stroke:!0}),_=d&&d.item||null,g=!1,v={};v[t.substr(5)]=!0,o&&_!==x&&(x&&s(x,null,"mouseleave",e,n),_&&s(_,null,"mouseenter",e,n),x=_),A^c&&(s(this,null,c?"mouseenter":"mouseleave",e,n),p=c?this:null,g=!0),!c&&!v.drag||n.equals(y)||(a(this,_,h?t:"mousemove",e,n,y),g=!0),A=c,(v.down&&c||v.up&&m)&&(a(this,_,t,e,n,m),v.down?(k=_===C&&Date.now()-S<300,w=C=_,b=!P&&_,m=n):v.up&&(P||_!==w||(S=Date.now(),a(this,_,k?"doubleclick":"click",e,n,m),k=!1),w=b=null),A=!1,g=!0),y=n,g&&u&&(I=u._handleMouseEvent(t,e,n,v)||I),(I&&!v.move||v.down&&i("mouseup"))&&e.preventDefault()},_handleKeyEvent:function(t,e,n,i){function r(r){r.responds(t)&&(paper=a,r.emit(t,s=s||new $(t,e,n,i)))}var s,a=this._scope,o=a.tool;this.isVisible()&&(r(this),o&&o.responds(t)&&r(o))},_countItemEvent:function(t,e){var n=this._itemEvents,i=n["native"],r=n.virtual;for(var s in T)i[s]=(i[s]||0)+(T[s][t]||0)*e;r[t]=(r[t]||0)+e},statics:{updateFocus:e}}}}),W=Z.extend({_class:"CanvasView",initialize:function(t,e){if(!(e instanceof n.HTMLCanvasElement)){var i=d.read(arguments,1);if(i.isZero())throw new Error("Cannot create CanvasView with the provided argument: "+[].slice.call(arguments,1));e=tt.getCanvas(i)}var r=this._context=e.getContext("2d");if(r.save(),this._pixelRatio=1,!/^off|false$/.test(a.getAttribute(e,"hidpi"))){var s=n.devicePixelRatio||1,o=H.getPrefixed(r,"backingStorePixelRatio")||1;this._pixelRatio=s/o}Z.call(this,t,e),this._needsUpdate=!0},remove:function Ct(){return this._context.restore(),Ct.base.call(this)},_setElementSize:function St(t,e){var n=this._pixelRatio;if(St.base.call(this,t*n,e*n),1!==n){var i=this._element,r=this._context;if(!a.hasAttribute(i,"resize")){var s=i.style;s.width=t+"px",s.height=e+"px"}r.restore(),r.save(),r.scale(n,n)}},getPixelSize:function kt(t){var e,n=paper.agent;if(n&&n.firefox)e=kt.base.call(this,t);else{var i=this._context,r=i.font;i.font=t+" serif",e=parseFloat(i.font),i.font=r}return e},getTextWidth:function(t,e){var n=this._context,i=n.font,r=0;n.font=t;for(var s=0,a=e.length;s<a;s++)r=Math.max(r,n.measureText(e[s]).width);return n.font=i,r},update:function(){if(!this._needsUpdate)return!1;var t=this._project,e=this._context,n=this._viewSize;return e.clearRect(0,0,n.width+1,n.height+1),t&&t.draw(e,this._matrix,this._pixelRatio),this._needsUpdate=!1,!0}}),G=r.extend({_class:"Event",initialize:function(t){this.event=t,this.type=t&&t.type},prevented:!1,stopped:!1,preventDefault:function(){this.prevented=!0,this.event.preventDefault()},stopPropagation:function(){this.stopped=!0,this.event.stopPropagation()},stop:function(){this.stopPropagation(),this.preventDefault()},getTimeStamp:function(){return this.event.timeStamp},getModifiers:function(){return J.modifiers}}),$=G.extend({_class:"KeyEvent",initialize:function(t,e,n,i){this.type=t,this.event=e,this.key=n,this.character=i},toString:function(){return"{ type: '"+this.type+"', key: '"+this.key+"', character: '"+this.character+"', modifiers: "+this.getModifiers()+" }"}}),J=new function(){function t(t){var e=t.key||t.keyIdentifier;return e=/^U\+/.test(e)?String.fromCharCode(parseInt(e.substr(2),16)):/^Arrow[A-Z]/.test(e)?e.substr(5):"Unidentified"===e?String.fromCharCode(t.keyCode):e,o[e]||(e.length>1?r.hyphenate(e):e.toLowerCase())}function e(t,n,i,a){var o,h=Z._focused;if(u[n]=t,t?l[n]=i:delete l[n],n.length>1&&(o=r.camelize(n))in c){c[o]=t;var f=paper&&paper.agent;if("meta"===o&&f&&f.mac)if(t)s={};else{for(var d in s)d in l&&e(!1,d,s[d],a);s=null}}else t&&s&&(s[n]=i);h&&h._handleKeyEvent(t?"keydown":"keyup",a,n,i)}var s,a,o={"\t":"tab"," ":"space","\b":"backspace","\x7f":"delete",Spacebar:"space",Del:"delete",Win:"meta",Esc:"escape"},h={tab:"\t",space:" ",enter:"\r"},u={},l={},c=new r({shift:!1,control:!1,alt:!1,meta:!1,capsLock:!1,space:!1}).inject({option:{get:function(){return this.alt}},command:{get:function(){var t=paper&&paper.agent;return t&&t.mac?this.meta:this.control}}});return U.add(i,{keydown:function(n){var i=t(n),r=paper&&paper.agent;i.length>1||r&&r.chrome&&(n.altKey||r.mac&&n.metaKey||!r.mac&&n.ctrlKey)?e(!0,i,h[i]||(i.length>1?"":i),n):a=i},keypress:function(n){if(a){var i=t(n),r=n.charCode,s=r>=32?String.fromCharCode(r):i.length>1?"":i;i!==a&&(i=s.toLowerCase()),e(!0,i,s,n),a=null}},keyup:function(n){var i=t(n);i in l&&e(!1,i,l[i],n)}}),U.add(n,{blur:function(t){for(var n in l)e(!1,n,l[n],t)}}),{modifiers:c,isDown:function(t){return!!u[t]}}},X=G.extend({_class:"MouseEvent",initialize:function(t,e,n,i,r){this.type=t,this.event=e,this.point=n,this.target=i,this.delta=r},toString:function(){return"{ type: '"+this.type+"', point: "+this.point+", target: "+this.target+(this.delta?", delta: "+this.delta:"")+", modifiers: "+this.getModifiers()+" }"}}),Y=G.extend({_class:"ToolEvent",_item:null,initialize:function(t,e,n){this.tool=t,this.type=e,this.event=n},_choosePoint:function(t,e){return t?t:e?e.clone():null},getPoint:function(){return this._choosePoint(this._point,this.tool._point)},setPoint:function(t){this._point=t},getLastPoint:function(){return this._choosePoint(this._lastPoint,this.tool._lastPoint)},setLastPoint:function(t){this._lastPoint=t},getDownPoint:function(){return this._choosePoint(this._downPoint,this.tool._downPoint)},setDownPoint:function(t){this._downPoint=t},getMiddlePoint:function(){return!this._middlePoint&&this.tool._lastPoint?this.tool._point.add(this.tool._lastPoint).divide(2):this._middlePoint},setMiddlePoint:function(t){this._middlePoint=t},getDelta:function(){return!this._delta&&this.tool._lastPoint?this.tool._point.subtract(this.tool._lastPoint):this._delta},setDelta:function(t){this._delta=t},getCount:function(){return this.tool[/^mouse(down|up)$/.test(this.type)?"_downCount":"_moveCount"]},setCount:function(t){this.tool[/^mouse(down|up)$/.test(this.type)?"downCount":"count"]=t},getItem:function(){if(!this._item){var t=this.tool._scope.project.hitTest(this.getPoint());if(t){for(var e=t.item,n=e._parent;/^(Group|CompoundPath)$/.test(n._class);)e=n,n=n._parent;this._item=e}}return this._item},setItem:function(t){this._item=t},toString:function(){return"{ type: "+this.type+", point: "+this.getPoint()+", count: "+this.getCount()+", modifiers: "+this.getModifiers()+" }"}}),K=o.extend({_class:"Tool",_list:"tools",_reference:"tool",_events:["onMouseDown","onMouseUp","onMouseDrag","onMouseMove","onActivate","onDeactivate","onEditOptions","onKeyDown","onKeyUp"],initialize:function(t){o.call(this),this._moveCount=-1,this._downCount=-1,this._set(t)},getMinDistance:function(){return this._minDistance},setMinDistance:function(t){this._minDistance=t,null!=t&&null!=this._maxDistance&&t>this._maxDistance&&(this._maxDistance=t)},getMaxDistance:function(){return this._maxDistance},setMaxDistance:function(t){this._maxDistance=t,null!=this._minDistance&&null!=t&&t<this._minDistance&&(this._minDistance=t)},getFixedDistance:function(){return this._minDistance==this._maxDistance?this._minDistance:null},setFixedDistance:function(t){this._minDistance=this._maxDistance=t},_handleMouseEvent:function(t,e,n,i){function r(t,e){var r=n,s=a?c._point:c._downPoint||r;if(a){if(c._moveCount&&r.equals(s))return!1;if(s&&(null!=t||null!=e)){var o=r.subtract(s),h=o.getLength();if(h<(t||0))return!1;e&&(r=s.add(o.normalize(Math.min(h,e))))}c._moveCount++}return c._point=r,c._lastPoint=s||r,i.down&&(c._moveCount=-1,c._downPoint=r,c._downCount++),!0}function s(){o&&(l=c.emit(t,new Y(c,t,e))||l)}paper=this._scope,i.drag&&!this.responds(t)&&(t="mousemove");var a=i.move||i.drag,o=this.responds(t),h=this.minDistance,u=this.maxDistance,l=!1,c=this;if(i.down)r(),s();else if(i.up)r(null,u),s();else if(o)for(;r(h,u);)s();return l}}),Q={request:function(t){var e=new n.XMLHttpRequest;return e.open((t.method||"get").toUpperCase(),t.url,r.pick(t.async,!0)),t.mimeType&&e.overrideMimeType(t.mimeType),e.onload=function(){var n=e.status;0===n||200===n?t.onLoad&&t.onLoad.call(e,e.responseText):e.onerror()},e.onerror=function(){var n=e.status,i='Could not load "'+t.url+'" (Status: '+n+")";if(!t.onError)throw new Error(i);t.onError(i,n)},e.send(null)}},tt={canvases:[],getCanvas:function(t,e){if(!n)return null;var r,s=!0;"object"==typeof t&&(e=t.height,t=t.width),this.canvases.length?r=this.canvases.pop():(r=i.createElement("canvas"),s=!1);var a=r.getContext("2d");if(!a)throw new Error("Canvas "+r+" is unable toprovide a 2D context.");return r.width===t&&r.height===e?s&&a.clearRect(0,0,t+1,e+1):(r.width=t,r.height=e),a.save(),r},getContext:function(t,e){var n=this.getCanvas(t,e);return n?n.getContext("2d"):null},release:function(t){var e=t&&t.canvas?t.canvas:t;e&&e.getContext&&(e.getContext("2d").restore(),this.canvases.push(e))}},et=new function(){function t(t,e,n){return.2989*t+.587*e+.114*n}function e(e,n,i,r){var s=r-t(e,n,i);d=e+s,_=n+s,g=i+s;var r=t(d,_,g),a=v(d,_,g),o=p(d,_,g);if(a<0){var h=r-a;d=r+(d-r)*r/h,_=r+(_-r)*r/h,g=r+(g-r)*r/h}if(o>255){var u=255-r,l=o-r;d=r+(d-r)*u/l,_=r+(_-r)*u/l,g=r+(g-r)*u/l}}function n(t,e,n){return p(t,e,n)-v(t,e,n)}function i(t,e,n,i){var r,s=[t,e,n],a=p(t,e,n),o=v(t,e,n);o=o===t?0:o===e?1:2,a=a===t?0:a===e?1:2,r=0===v(o,a)?1===p(o,a)?2:1:0,s[a]>s[o]?(s[r]=(s[r]-s[o])*i/(s[a]-s[o]),s[a]=i):s[r]=s[a]=0,s[o]=0,d=s[0],_=s[1],g=s[2]}var s,a,o,h,u,l,c,f,d,_,g,v=Math.min,p=Math.max,m=Math.abs,y={multiply:function(){d=u*s/255,_=l*a/255,g=c*o/255},screen:function(){d=u+s-u*s/255,_=l+a-l*a/255,g=c+o-c*o/255},overlay:function(){d=u<128?2*u*s/255:255-2*(255-u)*(255-s)/255,_=l<128?2*l*a/255:255-2*(255-l)*(255-a)/255,g=c<128?2*c*o/255:255-2*(255-c)*(255-o)/255},"soft-light":function(){var t=s*u/255;d=t+u*(255-(255-u)*(255-s)/255-t)/255,t=a*l/255,_=t+l*(255-(255-l)*(255-a)/255-t)/255,t=o*c/255,g=t+c*(255-(255-c)*(255-o)/255-t)/255},"hard-light":function(){d=s<128?2*s*u/255:255-2*(255-s)*(255-u)/255,_=a<128?2*a*l/255:255-2*(255-a)*(255-l)/255,g=o<128?2*o*c/255:255-2*(255-o)*(255-c)/255},"color-dodge":function(){d=0===u?0:255===s?255:v(255,255*u/(255-s)),_=0===l?0:255===a?255:v(255,255*l/(255-a)),g=0===c?0:255===o?255:v(255,255*c/(255-o))},"color-burn":function(){d=255===u?255:0===s?0:p(0,255-255*(255-u)/s),_=255===l?255:0===a?0:p(0,255-255*(255-l)/a),g=255===c?255:0===o?0:p(0,255-255*(255-c)/o)},darken:function(){d=u<s?u:s,_=l<a?l:a,g=c<o?c:o},lighten:function(){d=u>s?u:s,_=l>a?l:a,g=c>o?c:o},difference:function(){d=u-s,d<0&&(d=-d),_=l-a,_<0&&(_=-_),g=c-o,g<0&&(g=-g)},exclusion:function(){d=u+s*(255-u-u)/255,_=l+a*(255-l-l)/255,g=c+o*(255-c-c)/255},hue:function(){i(s,a,o,n(u,l,c)),e(d,_,g,t(u,l,c))},saturation:function(){i(u,l,c,n(s,a,o)),e(d,_,g,t(u,l,c))},luminosity:function(){e(u,l,c,t(s,a,o))},color:function(){e(s,a,o,t(u,l,c))},add:function(){d=v(u+s,255),_=v(l+a,255),g=v(c+o,255)},subtract:function(){d=p(u-s,0),_=p(l-a,0),g=p(c-o,0)},average:function(){d=(u+s)/2,_=(l+a)/2,g=(c+o)/2},negation:function(){d=255-m(255-s-u),_=255-m(255-a-l),g=255-m(255-o-c)}},w=this.nativeModes=r.each(["source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","lighter","darker","copy","xor"],function(t){this[t]=!0},{}),x=tt.getContext(1,1);x&&(r.each(y,function(t,e){var n="darken"===e,i=!1;x.save();try{x.fillStyle=n?"#300":"#a00",x.fillRect(0,0,1,1),x.globalCompositeOperation=e,x.globalCompositeOperation===e&&(x.fillStyle=n?"#a00":"#300",x.fillRect(0,0,1,1),i=x.getImageData(0,0,1,1).data[0]!==n?170:51)}catch(r){}x.restore(),w[e]=i}),tt.release(x)),this.process=function(t,e,n,i,r){var v=e.canvas,p="normal"===t;if(p||w[t])n.save(),n.setTransform(1,0,0,1,0,0),n.globalAlpha=i,p||(n.globalCompositeOperation=t),n.drawImage(v,r.x,r.y),n.restore();else{var m=y[t];if(!m)return;for(var x=n.getImageData(r.x,r.y,v.width,v.height),b=x.data,C=e.getImageData(0,0,v.width,v.height).data,S=0,k=b.length;S<k;S+=4){s=C[S],u=b[S],a=C[S+1],l=b[S+1],o=C[S+2],c=b[S+2],h=C[S+3],f=b[S+3],m();var I=h*i/255,P=1-I;b[S]=I*d+P*u,b[S+1]=I*_+P*l,b[S+2]=I*g+P*c,b[S+3]=h*i+P*f}n.putImageData(x,r.x,r.y)}}},nt=new function(){function t(t,e,s){return n(i.createElementNS(r,t),e,s)}function e(t,e){var n=o[e],i=n?t.getAttributeNS(n,e):t.getAttribute(e);return"null"===i?null:i}function n(t,e,n){for(var i in e){var r=e[i],s=o[i];"number"==typeof r&&n&&(r=n.number(r)),s?t.setAttributeNS(s,i,r):t.setAttribute(i,r)}return t}var r="http://www.w3.org/2000/svg",s="http://www.w3.org/2000/xmlns",a="http://www.w3.org/1999/xlink",o={href:a,xlink:s,xmlns:s+"/","xmlns:xlink":s+"/"};return{svg:r,xmlns:s,xlink:a,create:t,get:e,set:n}},it=r.each({fillColor:["fill","color"],fillRule:["fill-rule","string"],strokeColor:["stroke","color"],strokeWidth:["stroke-width","number"],strokeCap:["stroke-linecap","string"],strokeJoin:["stroke-linejoin","string"],strokeScaling:["vector-effect","lookup",{"true":"none","false":"non-scaling-stroke"},function(t,e){return!e&&(t instanceof O||t instanceof C||t instanceof j)}],miterLimit:["stroke-miterlimit","number"],dashArray:["stroke-dasharray","array"],dashOffset:["stroke-dashoffset","number"],fontFamily:["font-family","string"],fontWeight:["font-weight","string"],fontSize:["font-size","number"],justification:["text-anchor","lookup",{left:"start",center:"middle",right:"end"}],opacity:["opacity","number"],blendMode:["mix-blend-mode","style"]},function(t,e){var n=r.capitalize(e),i=t[2];this[e]={type:t[1],property:e,attribute:t[0],toSVG:i,fromSVG:i&&r.each(i,function(t,e){this[t]=e},{}),exportFilter:t[3],get:"get"+n,set:"set"+n}},{});return new function(){function t(t,e,n){var i=new r,s=t.getTranslation();if(e){t=t._shiftless();var a=t._inverseTransform(s);i[n?"cx":"x"]=a.x,i[n?"cy":"y"]=a.y,s=null}if(!t.isIdentity()){var o=t.decompose();if(o){var h=[],l=o.rotation,c=o.scaling,f=o.skewing;s&&!s.isZero()&&h.push("translate("+S.point(s)+")"),l&&h.push("rotate("+S.number(l)+")"),u.isZero(c.x-1)&&u.isZero(c.y-1)||h.push("scale("+S.point(c)+")"),f&&f.x&&h.push("skewX("+S.number(f.x)+")"),f&&f.y&&h.push("skewY("+S.number(f.y)+")"),i.transform=h.join(" ")}else i.transform="matrix("+t.getValues().join(",")+")"}return i}function e(e,n){for(var i=t(e._matrix),r=e._children,s=nt.create("g",i,S),a=0,o=r.length;a<o;a++){var h=r[a],u=b(h,n);if(u)if(h.isClipMask()){var l=nt.create("clipPath");l.appendChild(u),m(h,l,"clip"),nt.set(s,{"clip-path":"url(#"+l.id+")"})}else s.appendChild(u)}return s}function i(e,n){var i=t(e._matrix,!0),r=e.getSize(),s=e.getImage();return i.x-=r.width/2,i.y-=r.height/2,i.width=r.width,i.height=r.height,i.href=n.embedImages===!1&&s&&s.src||e.toDataURL(),nt.create("image",i,S)}function s(e,n){var i=n.matchShapes;if(i){var r=e.toShape(!1);if(r)return a(r,n)}var s,o=e._segments,h=o.length,u=t(e._matrix);if(i&&h>=2&&!e.hasHandles())if(h>2){s=e._closed?"polygon":"polyline";for(var l=[],c=0;c<h;c++)l.push(S.point(o[c]._point));u.points=l.join(" ")}else{s="line";var f=o[0]._point,d=o[1]._point;u.set({x1:f.x,y1:f.y,x2:d.x,y2:d.y})}else s="path",u.d=e.getPathData(null,n.precision);return nt.create(s,u,S)}function a(e){var n=e._type,i=e._radius,r=t(e._matrix,!0,"rectangle"!==n);if("rectangle"===n){n="rect";var s=e._size,a=s.width,o=s.height;r.x-=a/2,r.y-=o/2,r.width=a,r.height=o,i.isZero()&&(i=null)}return i&&("circle"===n?r.r=i:(r.rx=i.width,r.ry=i.height)),nt.create(n,r,S)}function o(e,n){var i=t(e._matrix),r=e.getPathData(null,n.precision);return r&&(i.d=r),nt.create("path",i,S)}function c(e,n){var i=t(e._matrix,!0),r=e._definition,s=v(r,"symbol"),a=r._item,o=a.getBounds();return s||(s=nt.create("symbol",{viewBox:S.rectangle(o)}),s.appendChild(b(a,n)),m(r,s,"symbol")),i.href="#"+s.id,i.x+=o.x,i.y+=o.y,i.width=o.width,i.height=o.height,i.overflow="visible",nt.create("use",i,S)}function f(t){var e=v(t,"color");if(!e){var n,i=t.getGradient(),r=i._radial,s=t.getOrigin(),a=t.getDestination();if(r){n={cx:s.x,cy:s.y,r:s.getDistance(a)};var o=t.getHighlight();o&&(n.fx=o.x,n.fy=o.y)}else n={x1:s.x,y1:s.y,x2:a.x,y2:a.y};n.gradientUnits="userSpaceOnUse",e=nt.create((r?"radial":"linear")+"Gradient",n,S);for(var h=i._stops,u=0,l=h.length;u<l;u++){var c=h[u],f=c._color,d=f.getAlpha();n={offset:c._offset||u/(l-1)},f&&(n["stop-color"]=f.toCSS(!0)),d<1&&(n["stop-opacity"]=d),e.appendChild(nt.create("stop",n,S))}m(t,e,"color")}return"url(#"+e.id+")"}function d(e){var n=nt.create("text",t(e._matrix,!0),S);return n.textContent=e._content,n}function _(t,e,n){var i={},s=!n&&t.getParent(),a=[];return null!=t._name&&(i.id=t._name),r.each(it,function(e){var n=e.get,o=e.type,h=t[n]();if(e.exportFilter?e.exportFilter(t,h):!s||!r.equals(s[n](),h)){if("color"===o&&null!=h){var u=h.getAlpha();u<1&&(i[e.attribute+"-opacity"]=u)}"style"===o?a.push(e.attribute+": "+h):i[e.attribute]=null==h?"none":"color"===o?h.gradient?f(h,t):h.toCSS(!0):"array"===o?h.join(","):"lookup"===o?e.toSVG[h]:h}}),a.length&&(i.style=a.join(";")),1===i.opacity&&delete i.opacity,t._visible||(i.visibility="hidden"),nt.set(e,i,S)}function v(t,e){k||(k={ids:{},svgs:{}});var n=t._id||t.__id||(t.__id=l.get("svg"));return t&&k.svgs[e+"-"+n]}function m(t,e,n){k||v();var i=k.ids[n]=(k.ids[n]||0)+1;e.id=n+"-"+i,k.svgs[n+"-"+(t._id||t.__id)]=e}function x(t,e){var i=t,r=null;if(k){i="svg"===t.nodeName.toLowerCase()&&t;for(var s in k.svgs)r||(i||(i=nt.create("svg"),i.appendChild(t)),r=i.insertBefore(nt.create("defs"),i.firstChild)),r.appendChild(k.svgs[s]);k=null}return e.asString?(new n.XMLSerializer).serializeToString(i):i}function b(t,e,n){var i=I[t._class],r=i&&i(t,e);if(r){var s=e.onExport;s&&(r=s(t,r,e)||r);var a=JSON.stringify(t._data);a&&"{}"!==a&&"null"!==a&&r.setAttribute("data-paper-data",a)}return r&&_(t,r,n)}function C(t){return t||(t={}),S=new h(t.precision),t}var S,k,I={Group:e,Layer:e,Raster:i,Path:s,Shape:a,CompoundPath:o,SymbolItem:c,PointText:d};w.inject({exportSVG:function(t){return t=C(t),x(b(this,t,!0),t)}}),y.inject({exportSVG:function(e){e=C(e);var n=this._children,i=this.getView(),s=r.pick(e.bounds,"view"),a=e.matrix||"view"===s&&i._matrix,o=a&&p.read([a]),h="view"===s?new g([0,0],i.getViewSize()):"content"===s?w._getBounds(n,o,{stroke:!0}):g.read([s],0,{readNull:!0}),u={version:"1.1",xmlns:nt.svg,"xmlns:xlink":nt.xlink};h&&(u.width=h.width,u.height=h.height,(h.x||h.y)&&(u.viewBox=S.rectangle(h)));var l=nt.create("svg",u,S),c=l;o&&!o.isIdentity()&&(c=l.appendChild(nt.create("g",t(o),S)));for(var f=0,d=n.length;f<d;f++)c.appendChild(b(n[f],e,!0));return x(l,e)}})},new function(){function t(t,e,n,i,r){var s=nt.get(t,e),a=null==s?i?null:n?"":0:n?s:parseFloat(s);return/%\s*$/.test(s)?a/100*(r?1:A[/x|^width/.test(e)?"width":"height"]):a}function s(e,n,i,r,s){return n=t(e,n||"x",!1,r,s),i=t(e,i||"y",!1,r,s),!r||null!=n&&null!=i?new c(n,i):null}function a(e,n,i,r,s){return n=t(e,n||"width",!1,r,s),i=t(e,i||"height",!1,r,s),!r||null!=n&&null!=i?new d(n,i):null}function o(t,e,n){return"none"===t?null:"number"===e?parseFloat(t):"array"===e?t?t.split(/[\s,]+/g).map(parseFloat):[]:"color"===e?k(t)||t:"lookup"===e?n[t]:t}function h(t,e,n,i){var r=t.childNodes,s="clippath"===e,a="defs"===e,o=new x,h=o._project,u=h._currentStyle,l=[];if(s||a||(o=b(o,t,i),h._currentStyle=o._style.clone()),i)for(var c=t.querySelectorAll("defs"),f=0,d=c.length;f<d;f++)P(c[f],n,!1);for(var f=0,d=r.length;f<d;f++){var _,g=r[f];1!==g.nodeType||/^defs$/i.test(g.nodeName)||!(_=P(g,n,!1))||_ instanceof I||l.push(_)}return o.addChildren(l),s&&(o=b(o.reduce(),t,i)),h._currentStyle=u,(s||a)&&(o.remove(),o=null),o}function u(t,e){for(var n=t.getAttribute("points").match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g),i=[],r=0,s=n.length;r<s;r+=2)i.push(new c(parseFloat(n[r]),parseFloat(n[r+1])));var a=new E(i);return"polygon"===e&&a.closePath(),a}function l(t){return O.create(t.getAttribute("d"))}function f(e,n){var i,r=(t(e,"href",!0)||"").substring(1),a="radialgradient"===n;if(r)i=T[r].getGradient(),i._radial^a&&(i=i.clone(),i._radial=a);else{for(var o=e.childNodes,h=[],u=0,l=o.length;u<l;u++){var c=o[u];1===c.nodeType&&h.push(b(new q,c))}i=new R(h,a)}var f,d,_,g="userSpaceOnUse"!==t(e,"gradientUnits",!0);a?(f=s(e,"cx","cy",!1,g),d=f.add(t(e,"r",!1,!1,g),0),_=s(e,"fx","fy",!0,g)):(f=s(e,"x1","y1",!1,g),d=s(e,"x2","y2",!1,g));var v=b(new D(i,f,d,_),e);return v._scaleToBounds=g,null}function _(t,e,n,i){if(t.transform){for(var r=(i.getAttribute(n)||"").split(/\)\s*/g),s=new p,a=0,o=r.length;a<o;a++){var h=r[a];if(!h)break;for(var u=h.split(/\(\s*/),l=u[0],c=u[1].split(/[\s,]+/g),f=0,d=c.length;f<d;f++)c[f]=parseFloat(c[f]);switch(l){case"matrix":s.append(new p(c[0],c[1],c[2],c[3],c[4],c[5]));break;case"rotate":s.rotate(c[0],c[1],c[2]);break;case"translate":s.translate(c[0],c[1]);break;case"scale":s.scale(c);break;case"skewX":s.skew(c[0],0);break;case"skewY":s.skew(0,c[0])}}t.transform(s)}}function v(t,e,n){var i="fill-opacity"===n?"getFillColor":"getStrokeColor",r=t[i]&&t[i]();r&&r.setAlpha(parseFloat(e))}function m(t,n,i){var s=t.attributes[n],a=s&&s.value;if(!a){var o=r.camelize(n);a=t.style[o],a||i.node[o]===i.parent[o]||(a=i.node[o])}return a?"none"===a?null:a:e}function b(t,n,i){var s=n.parentNode,a={node:H.getStyles(n)||{},parent:!i&&!/^defs$/i.test(s.tagName)&&H.getStyles(s)||{}};return r.each(L,function(i,r){var s=m(n,r,a);t=s!==e&&i(t,s,r,n,a)||t;
}),t}function k(t){var e=t&&t.match(/\((?:["'#]*)([^"')]+)/),i=e&&T[e[1].replace(n.location.href.split("#")[0]+"#","")];return i&&i._scaleToBounds&&(i=i.clone(),i._scaleToBounds=!0),i}function P(t,e,n){var s,o,h,u=t.nodeName.toLowerCase(),l="#document"!==u,c=i.body;n&&l&&(A=a(t,null,null,!0)||paper.getView().getSize(),s=nt.create("svg",{style:"stroke-width: 1px; stroke-miterlimit: 10"}),o=t.parentNode,h=t.nextSibling,s.appendChild(t),c.appendChild(s));var f=paper.settings,d=f.applyMatrix,_=f.insertItems;f.applyMatrix=!1,f.insertItems=!1;var g=z[u],v=g&&g(t,u,e,n)||null;if(f.insertItems=_,f.applyMatrix=d,v){!l||v instanceof x||(v=b(v,t,n));var p=e.onImport,m=l&&t.getAttribute("data-paper-data");p&&(v=p(t,v,e)||v),e.expandShapes&&v instanceof C&&(v.remove(),v=v.toPath()),m&&(v._data=JSON.parse(m))}return s&&(c.removeChild(s),o&&(h?o.insertBefore(t,h):o.appendChild(t))),n&&(T={},v&&r.pick(e.applyMatrix,d)&&v.matrix.apply(!0,!0)),v}function M(t,r,s){function a(i){try{var a="object"==typeof i?i:(new n.DOMParser).parseFromString(i,"image/svg+xml");if(!a.nodeName)throw a=null,new Error("Unsupported SVG source: "+t);paper=h,u=P(a,r,!0),r&&r.insert===!1||s._insertItem(e,u);var l=r.onLoad;l&&l(u,i)}catch(c){o(c)}}function o(t,e){var n=r.onError;if(!n)throw new Error(t);n(t,e)}if(!t)return null;r="function"==typeof r?{onLoad:r}:r||{};var h=paper,u=null;if("string"!=typeof t||/^.*</.test(t)){if("undefined"!=typeof File&&t instanceof File){var l=new FileReader;return l.onload=function(){a(l.result)},l.onerror=function(){o(l.error)},l.readAsText(t)}a(t)}else{var c=i.getElementById(t);c?a(c):Q.request({url:t,async:!0,onLoad:a,onError:o})}return u}var A,T={},z={"#document":function(t,e,n,i){for(var r=t.childNodes,s=0,a=r.length;s<a;s++){var o=r[s];if(1===o.nodeType)return P(o,n,i)}},g:h,svg:h,clippath:h,polygon:u,polyline:u,path:l,lineargradient:f,radialgradient:f,image:function(e){var n=new S(t(e,"href",!0));return n.on("load",function(){var t=a(e);this.setSize(t);var n=this._matrix._transformPoint(s(e).add(t.divide(2)));this.translate(n)}),n},symbol:function(t,e,n,i){return new I(h(t,e,n,i),(!0))},defs:h,use:function(e){var n=(t(e,"href",!0)||"").substring(1),i=T[n],r=s(e);return i?i instanceof I?i.place(r):i.clone().translate(r):null},circle:function(e){return new C.Circle(s(e,"cx","cy"),t(e,"r"))},ellipse:function(t){return new C.Ellipse({center:s(t,"cx","cy"),radius:a(t,"rx","ry")})},rect:function(t){return new C.Rectangle(new g(s(t),a(t)),a(t,"rx","ry"))},line:function(t){return new E.Line(s(t,"x1","y1"),s(t,"x2","y2"))},text:function(t){var e=new F(s(t).add(s(t,"dx","dy")));return e.setContent(t.textContent.trim()||""),e}},L=r.set(r.each(it,function(t){this[t.attribute]=function(e,n){if(e[t.set]&&(e[t.set](o(n,t.type,t.fromSVG)),"color"===t.type)){var i=e[t.get]();if(i){if(i._scaleToBounds){var r=e.getBounds();i.transform((new p).translate(r.getPoint()).scale(r.getSize()))}e instanceof C&&i.transform((new p).translate(e.getPosition(!0).negate()))}}}},{}),{id:function(t,e){T[e]=t,t.setName&&t.setName(e)},"clip-path":function(t,e){var n=k(e);if(n){if(n=n.clone(),n.setClipMask(!0),!(t instanceof x))return new x(n,t);t.insertChild(0,n)}},gradientTransform:_,transform:_,"fill-opacity":v,"stroke-opacity":v,visibility:function(t,e){t.setVisible&&t.setVisible("visible"===e)},display:function(t,e){t.setVisible&&t.setVisible(null!==e)},"stop-color":function(t,e){t.setColor&&t.setColor(e)},"stop-opacity":function(t,e){t._color&&t._color.setAlpha(parseFloat(e))},offset:function(t,e){if(t.setOffset){var n=e.match(/(.*)%$/);t.setOffset(n?n[1]/100:parseFloat(e))}},viewBox:function(t,e,n,i,r){var s,h,u=new g(o(e,"array")),l=a(i,null,null,!0);if(t instanceof x){var c=l?l.divide(u.getSize()):1,h=(new p).scale(c).translate(u.getPoint().negate());s=t}else t instanceof I&&(l&&u.setSize(l),s=t._item);if(s){if("visible"!==m(i,"overflow",r)){var f=new C.Rectangle(u);f.setClipMask(!0),s.addChild(f)}h&&s.transform(h)}}});w.inject({importSVG:function(t,e){return M(t,e,this)}}),y.inject({importSVG:function(t,e){return this.activate(),M(t,e,this)}})},r.exports.PaperScript=function(){function t(t,e,n){var i=p[e];if(t&&t[i]){var r=t[i](n);return"!="===e?!r:r}switch(e){case"+":return t+n;case"-":return t-n;case"*":return t*n;case"/":return t/n;case"%":return t%n;case"==":return t==n;case"!=":return t!=n}}function e(t,e){var n=m[t];if(n&&e&&e[n])return e[n]();switch(t){case"+":return+e;case"-":return-e}}function s(t,e){return v.acorn.parse(t,e)}function o(t,e){function r(t){for(var e=0,n=f.length;e<n;e++){var i=f[e];if(i[0]>=t)break;t+=i[1]}return t}function a(e){return t.substring(r(e.range[0]),r(e.range[1]))}function o(e,n){return t.substring(r(e.range[1]),r(n.range[0]))}function h(e,n){for(var i=r(e.range[0]),s=r(e.range[1]),a=0,o=f.length-1;o>=0;o--)if(i>f[o][0]){a=o+1;break}f.splice(a,0,[i,n.length-s+i]),t=t.substring(0,i)+n+t.substring(s)}function u(t,e){if(t){for(var n in t)if("range"!==n&&"loc"!==n){var i=t[n];if(Array.isArray(i))for(var r=0,s=i.length;r<s;r++)u(i[r],t);else i&&"object"==typeof i&&u(i,t)}switch(t.type){case"UnaryExpression":if(t.operator in m&&"Literal"!==t.argument.type){var l=a(t.argument);h(t,'$__("'+t.operator+'", '+l+")")}break;case"BinaryExpression":if(t.operator in p&&"Literal"!==t.left.type){var c=a(t.left),f=a(t.right),d=o(t.left,t.right),_=t.operator;h(t,"__$__("+c+","+d.replace(new RegExp("\\"+_),'"'+_+'"')+", "+f+")")}break;case"UpdateExpression":case"AssignmentExpression":var g=e&&e.type;if(!("ForStatement"===g||"BinaryExpression"===g&&/^[=!<>]/.test(e.operator)||"MemberExpression"===g&&e.computed))if("UpdateExpression"===t.type){var l=a(t.argument),v="__$__("+l+', "'+t.operator[0]+'", 1)',y=l+" = "+v;t.prefix||"AssignmentExpression"!==g&&"VariableDeclarator"!==g||(a(e.left||e.id)===l&&(y=v),y=l+"; "+y),h(t,y)}else if(/^.=$/.test(t.operator)&&"Literal"!==t.left.type){var c=a(t.left),f=a(t.right);h(t,c+" = __$__("+c+', "'+t.operator[0]+'", '+f+")")}}}}function l(t){var e="",n="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";for(t=(Math.abs(t)<<1)+(t<0?1:0);t||!e;){var i=31&t;t>>=5,t&&(i|=32),e+=n[i]}return e}if(!t)return"";e=e||{};var c,f=[],d=e.url||"",_=paper.agent,g=_.versionNumber,v=!1,y=e.sourceMaps,w=e.source||t,x=/\r\n|\n|\r/gm,b=e.offset||0;if(y&&(_.chrome&&g>=30||_.webkit&&g>=537.76||_.firefox&&g>=23||_.node)){if(_.node)b-=2;else if(n&&d&&!n.location.href.indexOf(d)){var C=i.getElementsByTagName("html")[0].innerHTML;b=C.substr(0,C.indexOf(t)+1).match(x).length+1}v=b>0&&!(_.chrome&&g>=36||_.safari&&g>=600||_.firefox&&g>=40||_.node);var S=["AA"+l(v?0:b)+"A"];S.length=(t.match(x)||[]).length+1+(v?b:0),c={version:3,file:d,names:[],mappings:S.join(";AACA"),sourceRoot:"",sources:[d],sourcesContent:[w]}}return u(s(t,{ranges:!0})),c&&(v&&(t=new Array(b+1).join("\n")+t),/^(inline|both)$/.test(y)&&(t+="\n//# sourceMappingURL=data:application/json;base64,"+n.btoa(unescape(encodeURIComponent(JSON.stringify(c))))),t+="\n//# sourceURL="+(d||"paperscript")),{url:d,source:w,code:t,map:c}}function h(n,s,a){function h(t,e){for(var i in t)!e&&/^_/.test(i)||!new RegExp("([\\b\\s\\W]|^)"+i.replace(/\$/g,"\\$")+"\\b").test(n)||(g.push(i),v.push(t[i]))}paper=s;var u,l=s.getView(),f=/\btool\.\w+|\s+on(?:Key|Mouse)(?:Up|Down|Move|Drag)\b/.test(n)&&!/\bnew\s+Tool\b/.test(n)?new K:null,d=f?f._events:[],_=["onFrame","onResize"].concat(d),g=[],v=[],p="object"==typeof n?n:o(n,a);n=p.code,h({__$__:t,$__:e,paper:s,view:l,tool:f},!0),h(s),_=r.each(_,function(t){new RegExp("\\s+"+t+"\\b").test(n)&&(g.push(t),this.push(t+": "+t))},[]).join(", "),_&&(n+="\nreturn { "+_+" };");var m=paper.agent;if(i&&(m.chrome||m.firefox&&m.versionNumber<40)){var y=i.createElement("script"),w=i.head||i.getElementsByTagName("head")[0];m.firefox&&(n="\n"+n),y.appendChild(i.createTextNode("paper._execute = function("+g+") {"+n+"\n}")),w.appendChild(y),u=paper._execute,delete paper._execute,w.removeChild(y)}else u=Function(g,n);var x=u.apply(s,v)||{};return r.each(d,function(t){var e=x[t];e&&(f[t]=e)}),l&&(x.onResize&&l.setOnResize(x.onResize),l.emit("resize",{size:l.size,delta:new c}),x.onFrame&&l.setOnFrame(x.onFrame),l.requestUpdate()),p}function u(t){if(/^text\/(?:x-|)paperscript$/.test(t.type)&&"true"!==a.getAttribute(t,"ignore")){var e=a.getAttribute(t,"canvas"),n=i.getElementById(e),r=t.src||t.getAttribute("data-src"),s=a.hasAttribute(t,"async"),o="data-paper-scope";if(!n)throw new Error('Unable to find canvas with id "'+e+'"');var u=a.get(n.getAttribute(o))||(new a).setup(n);return n.setAttribute(o,u._id),r?Q.request({url:r,async:s,mimeType:"text/plain",onLoad:function(t){h(t,u,r)}}):h(t.innerHTML,u,t.baseURI),t.setAttribute("data-paper-ignore","true"),u}}function l(){r.each(i&&i.getElementsByTagName("script"),u)}function f(t){return t?u(t):l()}var _,g,v=this;!function(t,e){return"object"==typeof _&&"object"==typeof module?e(_):"function"==typeof g&&g.amd?g(["exports"],e):void e(t.acorn||(t.acorn={}))}(this,function(t){"use strict";function e(t){ct=t||{};for(var e in gt)Object.prototype.hasOwnProperty.call(ct,e)||(ct[e]=gt[e]);_t=ct.sourceFile||null}function n(t,e){var n=vt(ft,t);e+=" ("+n.line+":"+n.column+")";var i=new SyntaxError(e);throw i.pos=t,i.loc=n,i.raisedAt=pt,i}function i(t){function e(t){if(1==t.length)return n+="return str === "+JSON.stringify(t[0])+";";n+="switch(str){";for(var e=0;e<t.length;++e)n+="case "+JSON.stringify(t[e])+":";n+="return true}return false;"}t=t.split(" ");var n="",i=[];t:for(var r=0;r<t.length;++r){for(var s=0;s<i.length;++s)if(i[s][0].length==t[r].length){i[s].push(t[r]);continue t}i.push([t[r]])}if(i.length>3){i.sort(function(t,e){return e.length-t.length}),n+="switch(str.length){";for(var r=0;r<i.length;++r){var a=i[r];n+="case "+a[0].length+":",e(a)}n+="}"}else e(t);return new Function("str",n)}function r(){this.line=kt,this.column=pt-It}function s(){kt=1,pt=It=0,St=!0,u()}function a(t,e){yt=pt,ct.locations&&(xt=new r),bt=t,u(),Ct=e,St=t.beforeExpr}function o(){var t=ct.onComment&&ct.locations&&new r,e=pt,i=ft.indexOf("*/",pt+=2);if(-1===i&&n(pt-2,"Unterminated comment"),pt=i+2,ct.locations){Xe.lastIndex=e;for(var s;(s=Xe.exec(ft))&&s.index<pt;)++kt,It=s.index+s[0].length}ct.onComment&&ct.onComment(!0,ft.slice(e+2,i),e,pt,t,ct.locations&&new r)}function h(){for(var t=pt,e=ct.onComment&&ct.locations&&new r,n=ft.charCodeAt(pt+=2);dt>pt&&10!==n&&13!==n&&8232!==n&&8233!==n;)++pt,n=ft.charCodeAt(pt);ct.onComment&&ct.onComment(!1,ft.slice(t+2,pt),t,pt,e,ct.locations&&new r)}function u(){for(;dt>pt;){var t=ft.charCodeAt(pt);if(32===t)++pt;else if(13===t){++pt;var e=ft.charCodeAt(pt);10===e&&++pt,ct.locations&&(++kt,It=pt)}else if(10===t||8232===t||8233===t)++pt,ct.locations&&(++kt,It=pt);else if(t>8&&14>t)++pt;else if(47===t){var e=ft.charCodeAt(pt+1);if(42===e)o();else{if(47!==e)break;h()}}else if(160===t)++pt;else{if(!(t>=5760&&Ue.test(String.fromCharCode(t))))break;++pt}}}function l(){var t=ft.charCodeAt(pt+1);return t>=48&&57>=t?S(!0):(++pt,a(we))}function c(){var t=ft.charCodeAt(pt+1);return St?(++pt,x()):61===t?w(Se,2):w(be,1)}function f(){var t=ft.charCodeAt(pt+1);return 61===t?w(Se,2):w(Be,1)}function d(t){var e=ft.charCodeAt(pt+1);return e===t?w(124===t?Pe:Me,2):61===e?w(Se,2):w(124===t?Ae:ze,1)}function _(){var t=ft.charCodeAt(pt+1);return 61===t?w(Se,2):w(Te,1)}function g(t){var e=ft.charCodeAt(pt+1);return e===t?45==e&&62==ft.charCodeAt(pt+2)&&Je.test(ft.slice(Mt,pt))?(pt+=3,h(),u(),y()):w(ke,2):61===e?w(Se,2):w(Ne,1)}function v(t){var e=ft.charCodeAt(pt+1),n=1;return e===t?(n=62===t&&62===ft.charCodeAt(pt+2)?3:2,61===ft.charCodeAt(pt+n)?w(Se,n+1):w(Le,n)):33==e&&60==t&&45==ft.charCodeAt(pt+2)&&45==ft.charCodeAt(pt+3)?(pt+=4,h(),u(),y()):(61===e&&(n=61===ft.charCodeAt(pt+2)?3:2),w(Ee,n))}function p(t){var e=ft.charCodeAt(pt+1);return 61===e?w(Oe,61===ft.charCodeAt(pt+2)?3:2):w(61===t?Ce:Ie,1)}function m(t){switch(t){case 46:return l();case 40:return++pt,a(ge);case 41:return++pt,a(ve);case 59:return++pt,a(me);case 44:return++pt,a(pe);case 91:return++pt,a(ce);case 93:return++pt,a(fe);case 123:return++pt,a(de);case 125:return++pt,a(_e);case 58:return++pt,a(ye);case 63:return++pt,a(xe);case 48:var e=ft.charCodeAt(pt+1);if(120===e||88===e)return C();case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:return S(!1);case 34:case 39:return k(t);case 47:return c(t);case 37:case 42:return f();case 124:case 38:return d(t);case 94:return _();case 43:case 45:return g(t);case 60:case 62:return v(t);case 61:case 33:return p(t);case 126:return w(Ie,1)}return!1}function y(t){if(t?pt=mt+1:mt=pt,ct.locations&&(wt=new r),t)return x();if(pt>=dt)return a(Ft);var e=ft.charCodeAt(pt);if(Ye(e)||92===e)return M();var i=m(e);if(i===!1){var s=String.fromCharCode(e);if("\\"===s||Ge.test(s))return M();n(pt,"Unexpected character '"+s+"'")}return i}function w(t,e){var n=ft.slice(pt,pt+e);pt+=e,a(t,n)}function x(){for(var t,e,i="",r=pt;;){pt>=dt&&n(r,"Unterminated regular expression");var s=ft.charAt(pt);if(Je.test(s)&&n(r,"Unterminated regular expression"),t)t=!1;else{if("["===s)e=!0;else if("]"===s&&e)e=!1;else if("/"===s&&!e)break;t="\\"===s}++pt}var i=ft.slice(r,pt);++pt;var o=P();o&&!/^[gmsiy]*$/.test(o)&&n(r,"Invalid regexp flag");try{var h=new RegExp(i,o)}catch(u){u instanceof SyntaxError&&n(r,u.message),n(u)}return a(Nt,h)}function b(t,e){for(var n=pt,i=0,r=0,s=null==e?1/0:e;s>r;++r){var a,o=ft.charCodeAt(pt);if(a=o>=97?o-97+10:o>=65?o-65+10:o>=48&&57>=o?o-48:1/0,a>=t)break;++pt,i=i*t+a}return pt===n||null!=e&&pt-n!==e?null:i}function C(){pt+=2;var t=b(16);return null==t&&n(mt+2,"Expected hexadecimal number"),Ye(ft.charCodeAt(pt))&&n(pt,"Identifier directly after number"),a(Lt,t)}function S(t){var e=pt,i=!1,r=48===ft.charCodeAt(pt);t||null!==b(10)||n(e,"Invalid number"),46===ft.charCodeAt(pt)&&(++pt,b(10),i=!0);var s=ft.charCodeAt(pt);69!==s&&101!==s||(s=ft.charCodeAt(++pt),43!==s&&45!==s||++pt,null===b(10)&&n(e,"Invalid number"),i=!0),Ye(ft.charCodeAt(pt))&&n(pt,"Identifier directly after number");var o,h=ft.slice(e,pt);return i?o=parseFloat(h):r&&1!==h.length?/[89]/.test(h)||Ot?n(e,"Invalid number"):o=parseInt(h,8):o=parseInt(h,10),a(Lt,o)}function k(t){pt++;for(var e="";;){pt>=dt&&n(mt,"Unterminated string constant");var i=ft.charCodeAt(pt);if(i===t)return++pt,a(Bt,e);if(92===i){i=ft.charCodeAt(++pt);var r=/^[0-7]+/.exec(ft.slice(pt,pt+3));for(r&&(r=r[0]);r&&parseInt(r,8)>255;)r=r.slice(0,-1);if("0"===r&&(r=null),++pt,r)Ot&&n(pt-2,"Octal literal in strict mode"),e+=String.fromCharCode(parseInt(r,8)),pt+=r.length-1;else switch(i){case 110:e+="\n";break;case 114:e+="\r";break;case 120:e+=String.fromCharCode(I(2));break;case 117:e+=String.fromCharCode(I(4));break;case 85:e+=String.fromCharCode(I(8));break;case 116:e+="\t";break;case 98:e+="\b";break;case 118:e+="\x0B";break;case 102:e+="\f";break;case 48:e+="\0";break;case 13:10===ft.charCodeAt(pt)&&++pt;case 10:ct.locations&&(It=pt,++kt);break;default:e+=String.fromCharCode(i)}}else 13!==i&&10!==i&&8232!==i&&8233!==i||n(mt,"Unterminated string constant"),e+=String.fromCharCode(i),++pt}}function I(t){var e=b(16,t);return null===e&&n(mt,"Bad character escape sequence"),e}function P(){Fe=!1;for(var t,e=!0,i=pt;;){var r=ft.charCodeAt(pt);if(Ke(r))Fe&&(t+=ft.charAt(pt)),++pt;else{if(92!==r)break;Fe||(t=ft.slice(i,pt)),Fe=!0,117!=ft.charCodeAt(++pt)&&n(pt,"Expecting Unicode escape sequence \\uXXXX"),++pt;var s=I(4),a=String.fromCharCode(s);a||n(pt-1,"Invalid Unicode escape"),(e?Ye(s):Ke(s))||n(pt-4,"Invalid Unicode escape"),t+=a}e=!1}return Fe?t:ft.slice(i,pt)}function M(){var t=P(),e=jt;return!Fe&&He(t)&&(e=le[t]),a(e,t)}function A(){Pt=mt,Mt=yt,At=xt,y()}function T(t){if(Ot=t,pt=mt,ct.locations)for(;It>pt;)It=ft.lastIndexOf("\n",It-2)+1,--kt;u(),y()}function z(){this.type=null,this.start=mt,this.end=null}function O(){this.start=wt,this.end=null,null!==_t&&(this.source=_t)}function E(){var t=new z;return ct.locations&&(t.loc=new O),ct.directSourceFile&&(t.sourceFile=ct.directSourceFile),ct.ranges&&(t.range=[mt,0]),t}function L(t){var e=new z;return e.start=t.start,ct.locations&&(e.loc=new O,e.loc.start=t.loc.start),ct.ranges&&(e.range=[t.range[0],0]),e}function N(t,e){return t.type=e,t.end=Mt,ct.locations&&(t.loc.end=At),ct.ranges&&(t.range[1]=Mt),t}function B(t){return ct.ecmaVersion>=5&&"ExpressionStatement"===t.type&&"Literal"===t.expression.type&&"use strict"===t.expression.value}function j(t){return bt===t?(A(),!0):void 0}function F(){return!ct.strictSemicolons&&(bt===Ft||bt===_e||Je.test(ft.slice(Mt,mt)))}function D(){j(me)||F()||q()}function R(t){bt===t?A():q()}function q(){n(mt,"Unexpected token")}function V(t){"Identifier"!==t.type&&"MemberExpression"!==t.type&&n(t.start,"Assigning to rvalue"),Ot&&"Identifier"===t.type&&Ve(t.name)&&n(t.start,"Assigning to "+t.name+" in strict mode")}function H(t){Pt=Mt=pt,ct.locations&&(At=new r),Tt=Ot=null,zt=[],y();var e=t||E(),n=!0;for(t||(e.body=[]);bt!==Ft;){var i=U();e.body.push(i),n&&B(i)&&T(!0),n=!1}return N(e,"Program")}function U(){(bt===be||bt===Se&&"/="==Ct)&&y(!0);var t=bt,e=E();switch(t){case Dt:case Vt:A();var i=t===Dt;j(me)||F()?e.label=null:bt!==jt?q():(e.label=lt(),D());for(var r=0;r<zt.length;++r){var s=zt[r];if(null==e.label||s.name===e.label.name){if(null!=s.kind&&(i||"loop"===s.kind))break;if(e.label&&i)break}}return r===zt.length&&n(e.start,"Unsyntactic "+t.keyword),N(e,i?"BreakStatement":"ContinueStatement");case Ht:return A(),D(),N(e,"DebuggerStatement");case Zt:return A(),zt.push(Qe),e.body=U(),zt.pop(),R(ne),e.test=Z(),D(),N(e,"DoWhileStatement");case $t:if(A(),zt.push(Qe),R(ge),bt===me)return G(e,null);if(bt===ee){var a=E();return A(),J(a,!0),N(a,"VariableDeclaration"),1===a.declarations.length&&j(ue)?$(e,a):G(e,a)}var a=X(!1,!0);return j(ue)?(V(a),$(e,a)):G(e,a);case Jt:return A(),ht(e,!0);case Xt:return A(),e.test=Z(),e.consequent=U(),e.alternate=j(Wt)?U():null,N(e,"IfStatement");case Yt:return Tt||ct.allowReturnOutsideFunction||n(mt,"'return' outside of function"),A(),j(me)||F()?e.argument=null:(e.argument=X(),D()),N(e,"ReturnStatement");case Kt:A(),e.discriminant=Z(),e.cases=[],R(de),zt.push(tn);for(var o,h;bt!=_e;)if(bt===Rt||bt===Ut){var u=bt===Rt;o&&N(o,"SwitchCase"),e.cases.push(o=E()),o.consequent=[],A(),u?o.test=X():(h&&n(Pt,"Multiple default clauses"),h=!0,o.test=null),R(ye)}else o||q(),o.consequent.push(U());return o&&N(o,"SwitchCase"),A(),zt.pop(),N(e,"SwitchStatement");case Qt:return A(),Je.test(ft.slice(Mt,mt))&&n(Mt,"Illegal newline after throw"),e.argument=X(),D(),N(e,"ThrowStatement");case te:if(A(),e.block=W(),e.handler=null,bt===qt){var l=E();A(),R(ge),l.param=lt(),Ot&&Ve(l.param.name)&&n(l.param.start,"Binding "+l.param.name+" in strict mode"),R(ve),l.guard=null,l.body=W(),e.handler=N(l,"CatchClause")}return e.guardedHandlers=Et,e.finalizer=j(Gt)?W():null,e.handler||e.finalizer||n(e.start,"Missing catch or finally clause"),N(e,"TryStatement");case ee:return A(),J(e),D(),N(e,"VariableDeclaration");case ne:return A(),e.test=Z(),zt.push(Qe),e.body=U(),zt.pop(),N(e,"WhileStatement");case ie:return Ot&&n(mt,"'with' in strict mode"),A(),e.object=Z(),e.body=U(),N(e,"WithStatement");case de:return W();case me:return A(),N(e,"EmptyStatement");default:var c=Ct,f=X();if(t===jt&&"Identifier"===f.type&&j(ye)){for(var r=0;r<zt.length;++r)zt[r].name===c&&n(f.start,"Label '"+c+"' is already declared");var d=bt.isLoop?"loop":bt===Kt?"switch":null;return zt.push({name:c,kind:d}),e.body=U(),zt.pop(),e.label=f,N(e,"LabeledStatement")}return e.expression=f,D(),N(e,"ExpressionStatement")}}function Z(){R(ge);var t=X();return R(ve),t}function W(t){var e,n=E(),i=!0,r=!1;for(n.body=[],R(de);!j(_e);){var s=U();n.body.push(s),i&&t&&B(s)&&(e=r,T(r=!0)),i=!1}return r&&!e&&T(!1),N(n,"BlockStatement")}function G(t,e){return t.init=e,R(me),t.test=bt===me?null:X(),R(me),t.update=bt===ve?null:X(),R(ve),t.body=U(),zt.pop(),N(t,"ForStatement")}function $(t,e){return t.left=e,t.right=X(),R(ve),t.body=U(),zt.pop(),N(t,"ForInStatement")}function J(t,e){for(t.declarations=[],t.kind="var";;){var i=E();if(i.id=lt(),Ot&&Ve(i.id.name)&&n(i.id.start,"Binding "+i.id.name+" in strict mode"),i.init=j(Ce)?X(!0,e):null,t.declarations.push(N(i,"VariableDeclarator")),!j(pe))break}return t}function X(t,e){var n=Y(e);if(!t&&bt===pe){var i=L(n);for(i.expressions=[n];j(pe);)i.expressions.push(Y(e));return N(i,"SequenceExpression")}return n}function Y(t){var e=K(t);if(bt.isAssign){var n=L(e);return n.operator=Ct,n.left=e,A(),n.right=Y(t),V(e),N(n,"AssignmentExpression")}return e}function K(t){var e=Q(t);if(j(xe)){var n=L(e);return n.test=e,n.consequent=X(!0),R(ye),n.alternate=X(!0,t),N(n,"ConditionalExpression")}return e}function Q(t){return tt(et(),-1,t)}function tt(t,e,n){var i=bt.binop;if(null!=i&&(!n||bt!==ue)&&i>e){var r=L(t);r.left=t,r.operator=Ct;var s=bt;A(),r.right=tt(et(),i,n);var a=N(r,s===Pe||s===Me?"LogicalExpression":"BinaryExpression");return tt(a,e,n)}return t}function et(){if(bt.prefix){var t=E(),e=bt.isUpdate;return t.operator=Ct,t.prefix=!0,St=!0,A(),t.argument=et(),e?V(t.argument):Ot&&"delete"===t.operator&&"Identifier"===t.argument.type&&n(t.start,"Deleting local variable in strict mode"),N(t,e?"UpdateExpression":"UnaryExpression")}for(var i=nt();bt.postfix&&!F();){var t=L(i);t.operator=Ct,t.prefix=!1,t.argument=i,V(i),A(),i=N(t,"UpdateExpression")}return i}function nt(){return it(rt())}function it(t,e){if(j(we)){var n=L(t);return n.object=t,n.property=lt(!0),n.computed=!1,it(N(n,"MemberExpression"),e)}if(j(ce)){var n=L(t);return n.object=t,n.property=X(),n.computed=!0,R(fe),it(N(n,"MemberExpression"),e)}if(!e&&j(ge)){var n=L(t);return n.callee=t,n.arguments=ut(ve,!1),it(N(n,"CallExpression"),e)}return t}function rt(){switch(bt){case se:var t=E();return A(),N(t,"ThisExpression");case jt:return lt();case Lt:case Bt:case Nt:var t=E();return t.value=Ct,t.raw=ft.slice(mt,yt),A(),N(t,"Literal");case ae:case oe:case he:var t=E();return t.value=bt.atomValue,t.raw=bt.keyword,A(),N(t,"Literal");case ge:var e=wt,n=mt;A();var i=X();return i.start=n,i.end=yt,ct.locations&&(i.loc.start=e,i.loc.end=xt),ct.ranges&&(i.range=[n,yt]),R(ve),i;case ce:var t=E();return A(),t.elements=ut(fe,!0,!0),N(t,"ArrayExpression");case de:return at();case Jt:var t=E();return A(),ht(t,!1);case re:return st();default:q()}}function st(){var t=E();return A(),t.callee=it(rt(),!0),j(ge)?t.arguments=ut(ve,!1):t.arguments=Et,N(t,"NewExpression")}function at(){var t=E(),e=!0,i=!1;for(t.properties=[],A();!j(_e);){if(e)e=!1;else if(R(pe),ct.allowTrailingCommas&&j(_e))break;var r,s={key:ot()},a=!1;if(j(ye)?(s.value=X(!0),r=s.kind="init"):ct.ecmaVersion>=5&&"Identifier"===s.key.type&&("get"===s.key.name||"set"===s.key.name)?(a=i=!0,r=s.kind=s.key.name,s.key=ot(),bt!==ge&&q(),s.value=ht(E(),!1)):q(),"Identifier"===s.key.type&&(Ot||i))for(var o=0;o<t.properties.length;++o){var h=t.properties[o];if(h.key.name===s.key.name){var u=r==h.kind||a&&"init"===h.kind||"init"===r&&("get"===h.kind||"set"===h.kind);u&&!Ot&&"init"===r&&"init"===h.kind&&(u=!1),u&&n(s.key.start,"Redefinition of property")}}t.properties.push(s)}return N(t,"ObjectExpression")}function ot(){return bt===Lt||bt===Bt?rt():lt(!0)}function ht(t,e){bt===jt?t.id=lt():e?q():t.id=null,t.params=[];var i=!0;for(R(ge);!j(ve);)i?i=!1:R(pe),t.params.push(lt());var r=Tt,s=zt;if(Tt=!0,zt=[],t.body=W(!0),Tt=r,zt=s,Ot||t.body.body.length&&B(t.body.body[0]))for(var a=t.id?-1:0;a<t.params.length;++a){var o=0>a?t.id:t.params[a];if((qe(o.name)||Ve(o.name))&&n(o.start,"Defining '"+o.name+"' in strict mode"),a>=0)for(var h=0;a>h;++h)o.name===t.params[h].name&&n(o.start,"Argument name clash in strict mode")}return N(t,e?"FunctionDeclaration":"FunctionExpression")}function ut(t,e,n){for(var i=[],r=!0;!j(t);){if(r)r=!1;else if(R(pe),e&&ct.allowTrailingCommas&&j(t))break;n&&bt===pe?i.push(null):i.push(X(!0))}return i}function lt(t){var e=E();return t&&"everywhere"==ct.forbidReserved&&(t=!1),bt===jt?(!t&&(ct.forbidReserved&&(3===ct.ecmaVersion?De:Re)(Ct)||Ot&&qe(Ct))&&-1==ft.slice(mt,yt).indexOf("\\")&&n(mt,"The keyword '"+Ct+"' is reserved"),e.name=Ct):t&&bt.keyword?e.name=bt.keyword:q(),St=!1,A(),N(e,"Identifier")}t.version="0.5.0";var ct,ft,dt,_t;t.parse=function(t,n){return ft=String(t),dt=ft.length,e(n),s(),H(ct.program)};var gt=t.defaultOptions={ecmaVersion:5,strictSemicolons:!1,allowTrailingCommas:!0,forbidReserved:!1,allowReturnOutsideFunction:!1,locations:!1,onComment:null,ranges:!1,program:null,sourceFile:null,directSourceFile:null},vt=t.getLineInfo=function(t,e){for(var n=1,i=0;;){Xe.lastIndex=i;var r=Xe.exec(t);if(!(r&&r.index<e))break;++n,i=r.index+r[0].length}return{line:n,column:e-i}};t.tokenize=function(t,n){function i(t){return Mt=yt,y(t),r.start=mt,r.end=yt,r.startLoc=wt,r.endLoc=xt,r.type=bt,r.value=Ct,r}ft=String(t),dt=ft.length,e(n),s();var r={};return i.jumpTo=function(t,e){if(pt=t,ct.locations){kt=1,It=Xe.lastIndex=0;for(var n;(n=Xe.exec(ft))&&n.index<t;)++kt,It=n.index+n[0].length}St=e,u()},i};var pt,mt,yt,wt,xt,bt,Ct,St,kt,It,Pt,Mt,At,Tt,zt,Ot,Et=[],Lt={type:"num"},Nt={type:"regexp"},Bt={type:"string"},jt={type:"name"},Ft={type:"eof"},Dt={keyword:"break"},Rt={keyword:"case",beforeExpr:!0},qt={keyword:"catch"},Vt={keyword:"continue"},Ht={keyword:"debugger"},Ut={keyword:"default"},Zt={keyword:"do",isLoop:!0},Wt={keyword:"else",beforeExpr:!0},Gt={keyword:"finally"},$t={keyword:"for",isLoop:!0},Jt={keyword:"function"},Xt={keyword:"if"},Yt={keyword:"return",beforeExpr:!0},Kt={keyword:"switch"},Qt={keyword:"throw",beforeExpr:!0},te={keyword:"try"},ee={keyword:"var"},ne={keyword:"while",isLoop:!0},ie={keyword:"with"},re={keyword:"new",beforeExpr:!0},se={keyword:"this"},ae={keyword:"null",atomValue:null},oe={keyword:"true",atomValue:!0},he={keyword:"false",atomValue:!1},ue={keyword:"in",binop:7,beforeExpr:!0},le={"break":Dt,"case":Rt,"catch":qt,"continue":Vt,"debugger":Ht,"default":Ut,"do":Zt,"else":Wt,"finally":Gt,"for":$t,"function":Jt,"if":Xt,"return":Yt,"switch":Kt,"throw":Qt,"try":te,"var":ee,"while":ne,"with":ie,"null":ae,"true":oe,"false":he,"new":re,"in":ue,"instanceof":{keyword:"instanceof",binop:7,beforeExpr:!0},"this":se,"typeof":{keyword:"typeof",prefix:!0,beforeExpr:!0},"void":{keyword:"void",prefix:!0,beforeExpr:!0},"delete":{keyword:"delete",prefix:!0,beforeExpr:!0}},ce={type:"[",beforeExpr:!0},fe={type:"]"},de={type:"{",beforeExpr:!0},_e={type:"}"},ge={type:"(",beforeExpr:!0},ve={type:")"},pe={type:",",beforeExpr:!0},me={type:";",beforeExpr:!0},ye={type:":",beforeExpr:!0},we={type:"."},xe={type:"?",beforeExpr:!0},be={binop:10,beforeExpr:!0},Ce={isAssign:!0,beforeExpr:!0},Se={isAssign:!0,beforeExpr:!0},ke={postfix:!0,prefix:!0,isUpdate:!0},Ie={prefix:!0,beforeExpr:!0},Pe={binop:1,beforeExpr:!0},Me={binop:2,beforeExpr:!0},Ae={binop:3,beforeExpr:!0},Te={binop:4,beforeExpr:!0},ze={binop:5,beforeExpr:!0},Oe={binop:6,beforeExpr:!0},Ee={binop:7,beforeExpr:!0},Le={binop:8,beforeExpr:!0},Ne={binop:9,prefix:!0,beforeExpr:!0},Be={binop:10,beforeExpr:!0};t.tokTypes={bracketL:ce,bracketR:fe,braceL:de,braceR:_e,parenL:ge,parenR:ve,comma:pe,semi:me,colon:ye,dot:we,question:xe,slash:be,eq:Ce,name:jt,eof:Ft,num:Lt,regexp:Nt,string:Bt};for(var je in le)t.tokTypes["_"+je]=le[je];var Fe,De=i("abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile"),Re=i("class enum extends super const export import"),qe=i("implements interface let package private protected public static yield"),Ve=i("eval arguments"),He=i("break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this"),Ue=/[\u1680\u180e\u2000-\u200a\u202f\u205f\u3000\ufeff]/,Ze="\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05d0-\u05ea\u05f0-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u08a0\u08a2-\u08ac\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0977\u0979-\u097f\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3d\u0c58\u0c59\u0c60\u0c61\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d60\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e87\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa\u0eab\u0ead-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f4\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f0\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1877\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191c\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19c1-\u19c7\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1ce9-\u1cec\u1cee-\u1cf1\u1cf5\u1cf6\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u212d\u212f-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2e2f\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309d-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312d\u3131-\u318e\u31a0-\u31ba\u31f0-\u31ff\u3400-\u4db5\u4e00-\u9fcc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua697\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua78e\ua790-\ua793\ua7a0-\ua7aa\ua7f8-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa80-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uabc0-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc",We="\u0300-\u036f\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u0620-\u0649\u0672-\u06d3\u06e7-\u06e8\u06fb-\u06fc\u0730-\u074a\u0800-\u0814\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0840-\u0857\u08e4-\u08fe\u0900-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962-\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09d7\u09df-\u09e0\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2-\u0ae3\u0ae6-\u0aef\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b56\u0b57\u0b5f-\u0b60\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c01-\u0c03\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62-\u0c63\u0c66-\u0c6f\u0c82\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2-\u0ce3\u0ce6-\u0cef\u0d02\u0d03\u0d46-\u0d48\u0d57\u0d62-\u0d63\u0d66-\u0d6f\u0d82\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0df2\u0df3\u0e34-\u0e3a\u0e40-\u0e45\u0e50-\u0e59\u0eb4-\u0eb9\u0ec8-\u0ecd\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f41-\u0f47\u0f71-\u0f84\u0f86-\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u1000-\u1029\u1040-\u1049\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u170e-\u1710\u1720-\u1730\u1740-\u1750\u1772\u1773\u1780-\u17b2\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u1920-\u192b\u1930-\u193b\u1951-\u196d\u19b0-\u19c0\u19c8-\u19c9\u19d0-\u19d9\u1a00-\u1a15\u1a20-\u1a53\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1b46-\u1b4b\u1b50-\u1b59\u1b6b-\u1b73\u1bb0-\u1bb9\u1be6-\u1bf3\u1c00-\u1c22\u1c40-\u1c49\u1c5b-\u1c7d\u1cd0-\u1cd2\u1d00-\u1dbe\u1e01-\u1f15\u200c\u200d\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2d81-\u2d96\u2de0-\u2dff\u3021-\u3028\u3099\u309a\ua640-\ua66d\ua674-\ua67d\ua69f\ua6f0-\ua6f1\ua7f8-\ua800\ua806\ua80b\ua823-\ua827\ua880-\ua881\ua8b4-\ua8c4\ua8d0-\ua8d9\ua8f3-\ua8f7\ua900-\ua909\ua926-\ua92d\ua930-\ua945\ua980-\ua983\ua9b3-\ua9c0\uaa00-\uaa27\uaa40-\uaa41\uaa4c-\uaa4d\uaa50-\uaa59\uaa7b\uaae0-\uaae9\uaaf2-\uaaf3\uabc0-\uabe1\uabec\uabed\uabf0-\uabf9\ufb20-\ufb28\ufe00-\ufe0f\ufe20-\ufe26\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f",Ge=new RegExp("["+Ze+"]"),$e=new RegExp("["+Ze+We+"]"),Je=/[\n\r\u2028\u2029]/,Xe=/\r\n|[\n\r\u2028\u2029]/g,Ye=t.isIdentifierStart=function(t){
return 65>t?36===t:91>t||(97>t?95===t:123>t||t>=170&&Ge.test(String.fromCharCode(t)))},Ke=t.isIdentifierChar=function(t){return 48>t?36===t:58>t||!(65>t)&&(91>t||(97>t?95===t:123>t||t>=170&&$e.test(String.fromCharCode(t))))},Qe={kind:"loop"},tn={kind:"switch"}});var p={"+":"__add","-":"__subtract","*":"__multiply","/":"__divide","%":"__modulo","==":"__equals","!=":"__equals"},m={"-":"__negate","+":null},y=r.each(["add","subtract","multiply","divide","modulo","equals","negate"],function(t){this["__"+t]="#"+t},{});return c.inject(y),d.inject(y),D.inject(y),n&&("complete"===i.readyState?setTimeout(l):U.add(n,{load:l})),{compile:o,execute:h,load:f,parse:s}}.call(this),paper=new(a.inject(r.exports,{enumerable:!0,Base:r,Numerical:u,Key:J,DomEvent:U,DomElement:H,document:i,window:n,Symbol:I,PlacedSymbol:k})),paper.agent.node&&require("./node/extend")(paper),"function"==typeof define&&define.amd?define("paper",paper):"object"==typeof module&&module&&(module.exports=paper),paper}.call(this,"object"==typeof self?self:null);