/*!
 * Paper.js v0.12.0 - The Swiss Army Knife of Vector Graphics Scripting.
 * http://paperjs.org/
 *
 * Copyright (c) 2011 - 2016, Juerg Lehni & Jonathan Puckey
 * http://scratchdisk.com/ & https://puckey.studio/
 *
 * Distributed under the MIT license. See LICENSE file for details.
 *
 * All rights reserved.
 *
 * Date: Mon Dec 3 14:19:11 2018 +0100
 *
 ***
 *
 * Straps.js - Class inheritance library with support for bean-style accessors
 *
 * Copyright (c) 2006 - 2016 Juerg Lehni
 * http://scratchdisk.com/
 *
 * Distributed under the MIT license.
 *
 ***
 *
 * Acorn.js
 * https://marijnhaverbeke.nl/acorn/
 *
 * Acorn is a tiny, fast JavaScript parser written in JavaScript,
 * created by Marijn Haverbeke and released under an MIT license.
 *
 */
var paper=function(t,e){t=t||require("./node/self.js");var n=t.window,i=t.document,r=new function(){function t(t,e,r,s,a){function u(i,u){u=u||(u=o(e,i))&&(u.get?u:u.value),"string"==typeof u&&"#"===u[0]&&(u=t[u.substring(1)]||u);var c,f="function"==typeof u,d=u,_=a||f&&!u.base?u&&u.get?i in t:t[i]:null;a&&_||(f&&_&&(u.base=_),f&&s!==!1&&(c=i.match(/^([gs]et|is)(([A-Z])(.*))$/))&&(l[c[3].toLowerCase()+c[4]]=c[2]),d&&!f&&d.get&&"function"==typeof d.get&&n.isPlainObject(d)||(d={value:d,writable:!0}),(o(t,i)||{configurable:!0}).configurable&&(d.configurable=!0,d.enumerable=null!=r?r:!c),h(t,i,d))}var l={};if(e){for(var c in e)e.hasOwnProperty(c)&&!i.test(c)&&u(c);for(var c in l){var f=l[c],d=t["set"+f],_=t["get"+f]||d&&t["is"+f];!_||s!==!0&&0!==_.length||u(c,{get:_,set:d})}}return t}function n(){for(var t=0,e=arguments.length;t<e;t++){var n=arguments[t];n&&c(this,n)}return this}var i=/^(statics|enumerable|beans|preserve)$/,r=[],s=r.slice,a=Object.create,o=Object.getOwnPropertyDescriptor,h=Object.defineProperty,u=r.forEach||function(t,e){for(var n=0,i=this.length;n<i;n++)t.call(e,this[n],n,this)},l=function(t,e){for(var n in this)this.hasOwnProperty(n)&&t.call(e,this[n],n,this)},c=Object.assign||function(t){for(var e=1,n=arguments.length;e<n;e++){var i=arguments[e];for(var r in i)i.hasOwnProperty(r)&&(t[r]=i[r])}return t},f=function(t,e,n){if(t){var i=o(t,"length");(i&&"number"==typeof i.value?u:l).call(t,e,n=n||t)}return n};return t(n,{inject:function(e){if(e){var n=e.statics===!0?e:e.statics,i=e.beans,r=e.preserve;n!==e&&t(this.prototype,e,e.enumerable,i,r),t(this,n,null,i,r)}for(var s=1,a=arguments.length;s<a;s++)this.inject(arguments[s]);return this},extend:function(){for(var e,n,i,r=this,s=0,o=arguments.length;s<o&&(!e||!n);s++)i=arguments[s],e=e||i.initialize,n=n||i.prototype;return e=e||function(){r.apply(this,arguments)},n=e.prototype=n||a(this.prototype),h(n,"constructor",{value:e,writable:!0,configurable:!0}),t(e,this),arguments.length&&this.inject.apply(e,arguments),e.base=r,e}}).inject({enumerable:!1,initialize:n,set:n,inject:function(){for(var e=0,n=arguments.length;e<n;e++){var i=arguments[e];i&&t(this,i,i.enumerable,i.beans,i.preserve)}return this},extend:function(){var t=a(this);return t.inject.apply(t,arguments)},each:function(t,e){return f(this,t,e)},clone:function(){return new this.constructor(this)},statics:{set:c,each:f,create:a,define:h,describe:o,clone:function(t){return c(new t.constructor,t)},isPlainObject:function(t){var e=null!=t&&t.constructor;return e&&(e===Object||e===n||"Object"===e.name)},pick:function(t,n){return t!==e?t:n},slice:function(t,e,n){return s.call(t,e,n)}}})};"undefined"!=typeof module&&(module.exports=r),r.inject({enumerable:!1,toString:function(){return null!=this._id?(this._class||"Object")+(this._name?" '"+this._name+"'":" @"+this._id):"{ "+r.each(this,function(t,e){if(!/^_/.test(e)){var n=typeof t;this.push(e+": "+("number"===n?h.instance.number(t):"string"===n?"'"+t+"'":t))}},[]).join(", ")+" }"},getClassName:function(){return this._class||""},importJSON:function(t){return r.importJSON(t,this)},exportJSON:function(t){return r.exportJSON(this,t)},toJSON:function(){return r.serialize(this)},set:function(t,e){return t&&r.filter(this,t,e,this._prioritize),this}},{beans:!1,statics:{exports:{},extend:function at(){var t=at.base.apply(this,arguments),e=t.prototype._class;return e&&!r.exports[e]&&(r.exports[e]=t),t},equals:function(t,e){if(t===e)return!0;if(t&&t.equals)return t.equals(e);if(e&&e.equals)return e.equals(t);if(t&&e&&"object"==typeof t&&"object"==typeof e){if(Array.isArray(t)&&Array.isArray(e)){var n=t.length;if(n!==e.length)return!1;for(;n--;)if(!r.equals(t[n],e[n]))return!1}else{var i=Object.keys(t),n=i.length;if(n!==Object.keys(e).length)return!1;for(;n--;){var s=i[n];if(!e.hasOwnProperty(s)||!r.equals(t[s],e[s]))return!1}}return!0}return!1},read:function(t,n,i,s){if(this===r){var a=this.peek(t,n);return t.__index++,a}var o=this.prototype,h=o._readIndex,u=n||h&&t.__index||0,l=t.length,c=t[u];if(s=s||l-u,c instanceof this||i&&i.readNull&&null==c&&s<=1)return h&&(t.__index=u+1),c&&i&&i.clone?c.clone():c;if(c=r.create(o),h&&(c.__read=!0),c=c.initialize.apply(c,u>0||u+s<l?r.slice(t,u,u+s):t)||c,h){t.__index=u+c.__read;var f=c.__filtered;f&&(t.__filtered=f,c.__filtered=e),c.__read=e}return c},peek:function(t,e){return t[t.__index=e||t.__index||0]},remain:function(t){return t.length-(t.__index||0)},readList:function(t,e,n,i){for(var r,s=[],a=e||0,o=i?a+i:t.length,h=a;h<o;h++)s.push(Array.isArray(r=t[h])?this.read(r,0,n):this.read(t,h,n,1));return s},readNamed:function(t,n,i,s,a){var o=this.getNamed(t,n),h=o!==e;if(h){var u=t.__filtered;u||(u=t.__filtered=r.create(t[0]),u.__unfiltered=t[0]),u[n]=e}var l=h?[o]:t,c=this.read(l,i,s,a);return c},getNamed:function(t,n){var i=t[0];if(t._hasObject===e&&(t._hasObject=1===t.length&&r.isPlainObject(i)),t._hasObject)return n?i[n]:t.__filtered||i},hasNamed:function(t,e){return!!this.getNamed(t,e)},filter:function(t,n,i,r){function s(r){if(!(i&&r in i||a&&r in a)){var s=n[r];s!==e&&(t[r]=s)}}var a;if(r){for(var o,h={},u=0,l=r.length;u<l;u++)(o=r[u])in n&&(s(o),h[o]=!0);a=h}return Object.keys(n.__unfiltered||n).forEach(s),t},isPlainValue:function(t,e){return r.isPlainObject(t)||Array.isArray(t)||e&&"string"==typeof t},serialize:function(t,e,n,i){e=e||{};var s,a=!i;if(a&&(e.formatter=new h(e.precision),i={length:0,definitions:{},references:{},add:function(t,e){var n="#"+t._id,i=this.references[n];if(!i){this.length++;var r=e.call(t),s=t._class;s&&r[0]!==s&&r.unshift(s),this.definitions[n]=r,i=this.references[n]=[n]}return i}}),t&&t._serialize){s=t._serialize(e,i);var o=t._class;!o||t._compactSerialize||!a&&n||s[0]===o||s.unshift(o)}else if(Array.isArray(t)){s=[];for(var u=0,l=t.length;u<l;u++)s[u]=r.serialize(t[u],e,n,i)}else if(r.isPlainObject(t)){s={};for(var c=Object.keys(t),u=0,l=c.length;u<l;u++){var f=c[u];s[f]=r.serialize(t[f],e,n,i)}}else s="number"==typeof t?e.formatter.number(t,e.precision):t;return a&&i.length>0?[["dictionary",i.definitions],s]:s},deserialize:function(t,e,n,i,s){var a=t,o=!n,h=o&&t&&t.length&&"dictionary"===t[0][0];if(n=n||{},Array.isArray(t)){var u=t[0],l="dictionary"===u;if(1==t.length&&/^#/.test(u))return n.dictionary[u];u=r.exports[u],a=[];for(var c=u?1:0,f=t.length;c<f;c++)a.push(r.deserialize(t[c],e,n,l,h));if(u){var d=a;a=e?e(u,d,o||s):new u(d)}}else if(r.isPlainObject(t)){a={},i&&(n.dictionary=a);for(var _ in t)a[_]=r.deserialize(t[_],e,n)}return h?a[1]:a},exportJSON:function(t,e){var n=r.serialize(t,e);return e&&0==e.asString?n:JSON.stringify(n)},importJSON:function(t,e){return r.deserialize("string"==typeof t?JSON.parse(t):t,function(t,n,i){var s=i&&e&&e.constructor===t,a=s?e:r.create(t.prototype);if(1===n.length&&a instanceof w&&(s||!(a instanceof b))){var o=n[0];r.isPlainObject(o)&&(o.insert=!1)}return(s?a.set:t).apply(a,n),s&&(e=null),a})},push:function(t,e){var n=e.length;if(n<4096)t.push.apply(t,e);else{var i=t.length;t.length+=n;for(var r=0;r<n;r++)t[i+r]=e[r]}return t},splice:function(t,n,i,s){var a=n&&n.length,o=i===e;i=o?t.length:i,i>t.length&&(i=t.length);for(var h=0;h<a;h++)n[h]._index=i+h;if(o)return r.push(t,n),[];var u=[i,s];n&&r.push(u,n);for(var l=t.splice.apply(t,u),h=0,c=l.length;h<c;h++)l[h]._index=e;for(var h=i+a,c=t.length;h<c;h++)t[h]._index=h;return l},capitalize:function(t){return t.replace(/\b[a-z]/g,function(t){return t.toUpperCase()})},camelize:function(t){return t.replace(/-(.)/g,function(t,e){return e.toUpperCase()})},hyphenate:function(t){return t.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase()}}});var s={on:function(t,e){if("string"!=typeof t)r.each(t,function(t,e){this.on(e,t)},this);else{var n=this._eventTypes,i=n&&n[t],s=this._callbacks=this._callbacks||{};s=s[t]=s[t]||[],s.indexOf(e)===-1&&(s.push(e),i&&i.install&&1===s.length&&i.install.call(this,t))}return this},off:function(t,e){if("string"!=typeof t)return void r.each(t,function(t,e){this.off(e,t)},this);var n,i=this._eventTypes,s=i&&i[t],a=this._callbacks&&this._callbacks[t];return a&&(!e||(n=a.indexOf(e))!==-1&&1===a.length?(s&&s.uninstall&&s.uninstall.call(this,t),delete this._callbacks[t]):n!==-1&&a.splice(n,1)),this},once:function(t,e){return this.on(t,function n(){e.apply(this,arguments),this.off(t,n)})},emit:function(t,e){var n=this._callbacks&&this._callbacks[t];if(!n)return!1;var i=r.slice(arguments,1),s=e&&e.target&&!e.currentTarget;n=n.slice(),s&&(e.currentTarget=this);for(var a=0,o=n.length;a<o;a++)if(0==n[a].apply(this,i)){e&&e.stop&&e.stop();break}return s&&delete e.currentTarget,!0},responds:function(t){return!(!this._callbacks||!this._callbacks[t])},attach:"#on",detach:"#off",fire:"#emit",_installEvents:function(t){var e=this._eventTypes,n=this._callbacks,i=t?"install":"uninstall";if(e)for(var r in n)if(n[r].length>0){var s=e[r],a=s&&s[i];a&&a.call(this,r)}},statics:{inject:function ot(t){var e=t._events;if(e){var n={};r.each(e,function(e,i){var s="string"==typeof e,a=s?e:i,o=r.capitalize(a),h=a.substring(2).toLowerCase();n[h]=s?{}:e,a="_"+a,t["get"+o]=function(){return this[a]},t["set"+o]=function(t){var e=this[a];e&&this.off(h,e),t&&this.on(h,t),this[a]=t}}),t._eventTypes=n}return ot.base.apply(this,arguments)}}},a=r.extend({_class:"PaperScope",initialize:function ht(){st=this,this.settings=new r({applyMatrix:!0,insertItems:!0,handleSize:4,hitTolerance:0}),this.project=null,this.projects=[],this.tools=[],this._id=ht._id++,ht._scopes[this._id]=this;var e=ht.prototype;if(!this.support){var n=et.getContext(1,1)||{};e.support={nativeDash:"setLineDash"in n||"mozDash"in n,nativeBlendModes:nt.nativeModes},et.release(n)}if(!this.agent){var i=t.navigator.userAgent.toLowerCase(),s=(/(darwin|win|mac|linux|freebsd|sunos)/.exec(i)||[])[0],a="darwin"===s?"mac":s,o=e.agent=e.browser={platform:a};a&&(o[a]=!0),i.replace(/(opera|chrome|safari|webkit|firefox|msie|trident|atom|node)\/?\s*([.\d]+)(?:.*version\/([.\d]+))?(?:.*rv\:v?([.\d]+))?/g,function(t,e,n,i,r){if(!o.chrome){var s="opera"===e?i:/^(node|trident)$/.test(e)?r:n;o.version=s,o.versionNumber=parseFloat(s),e="trident"===e?"msie":e,o.name=e,o[e]=!0}}),o.chrome&&delete o.webkit,o.atom&&delete o.chrome}},version:"0.12.0",getView:function(){var t=this.project;return t&&t._view},getPaper:function(){return this},execute:function(t,e){var n=st.PaperScript.execute(t,this,e);return Z.updateFocus(),n},install:function(t){var e=this;r.each(["project","view","tool"],function(n){r.define(t,n,{configurable:!0,get:function(){return e[n]}})});for(var n in this)!/^_/.test(n)&&this[n]&&(t[n]=this[n])},setup:function(t){return st=this,this.project=new y(t),this},createCanvas:function(t,e){return et.getCanvas(t,e)},activate:function(){st=this},clear:function(){for(var t=this.projects,e=this.tools,n=t.length-1;n>=0;n--)t[n].remove();for(var n=e.length-1;n>=0;n--)e[n].remove()},remove:function(){this.clear(),delete a._scopes[this._id]},statics:new function(){function t(t){return t+="Attribute",function(e,n){return e[t](n)||e[t]("data-paper-"+n)}}return{_scopes:{},_id:0,get:function(t){return this._scopes[t]||null},getAttribute:t("get"),hasAttribute:t("has")}}}),o=r.extend(s,{initialize:function(t){this._scope=st,this._index=this._scope[this._list].push(this)-1,!t&&this._scope[this._reference]||this.activate()},activate:function(){if(!this._scope)return!1;var t=this._scope[this._reference];return t&&t!==this&&t.emit("deactivate"),this._scope[this._reference]=this,this.emit("activate",t),!0},isActive:function(){return this._scope[this._reference]===this},remove:function(){return null!=this._index&&(r.splice(this._scope[this._list],null,this._index,1),this._scope[this._reference]==this&&(this._scope[this._reference]=null),this._scope=null,!0)},getView:function(){return this._scope.getView()}}),h=r.extend({initialize:function(t){this.precision=r.pick(t,5),this.multiplier=Math.pow(10,this.precision)},number:function(t){return this.precision<16?Math.round(t*this.multiplier)/this.multiplier:t},pair:function(t,e,n){return this.number(t)+(n||",")+this.number(e)},point:function(t,e){return this.number(t.x)+(e||",")+this.number(t.y)},size:function(t,e){return this.number(t.width)+(e||",")+this.number(t.height)},rectangle:function(t,e){return this.point(t,e)+(e||",")+this.size(t,e)}});h.instance=new h;var u=new function(){function t(t,e,n){return t<e?e:t>n?n:t}function e(t,e,n){function i(t){var e=134217729*t,n=t-e,i=n+e,r=t-i;return[i,r]}var r=e*e-t*n,a=e*e+t*n;if(3*s(r)<a){var o=i(t),h=i(e),u=i(n),l=e*e,c=h[0]*h[0]-l+2*h[0]*h[1]+h[1]*h[1],f=t*n,d=o[0]*u[0]-f+o[0]*u[1]+o[1]*u[0]+o[1]*u[1];r=l-f+(c-d)}return r}function n(){var t=Math.max.apply(Math,arguments);return t&&(t<1e-8||t>1e8)?o(2,-Math.round(h(t))):0}var i=[[.5773502691896257],[0,.7745966692414834],[.33998104358485626,.8611363115940526],[0,.5384693101056831,.906179845938664],[.2386191860831969,.6612093864662645,.932469514203152],[0,.4058451513773972,.7415311855993945,.9491079123427585],[.1834346424956498,.525532409916329,.7966664774136267,.9602898564975363],[0,.3242534234038089,.6133714327005904,.8360311073266358,.9681602395076261],[.14887433898163122,.4333953941292472,.6794095682990244,.8650633666889845,.9739065285171717],[0,.26954315595234496,.5190961292068118,.7301520055740494,.8870625997680953,.978228658146057],[.1252334085114689,.3678314989981802,.5873179542866175,.7699026741943047,.9041172563704749,.9815606342467192],[0,.2304583159551348,.44849275103644687,.6423493394403402,.8015780907333099,.9175983992229779,.9841830547185881],[.10805494870734367,.31911236892788974,.5152486363581541,.6872929048116855,.827201315069765,.9284348836635735,.9862838086968123],[0,.20119409399743451,.3941513470775634,.5709721726085388,.7244177313601701,.8482065834104272,.937273392400706,.9879925180204854],[.09501250983763744,.2816035507792589,.45801677765722737,.6178762444026438,.755404408355003,.8656312023878318,.9445750230732326,.9894009349916499]],r=[[1],[.8888888888888888,.5555555555555556],[.6521451548625461,.34785484513745385],[.5688888888888889,.47862867049936647,.23692688505618908],[.46791393457269104,.3607615730481386,.17132449237917036],[.4179591836734694,.3818300505051189,.27970539148927664,.1294849661688697],[.362683783378362,.31370664587788727,.22238103445337448,.10122853629037626],[.3302393550012598,.31234707704000286,.26061069640293544,.1806481606948574,.08127438836157441],[.29552422471475287,.26926671930999635,.21908636251598204,.1494513491505806,.06667134430868814],[.2729250867779006,.26280454451024665,.23319376459199048,.18629021092773426,.1255803694649046,.05566856711617366],[.24914704581340277,.2334925365383548,.20316742672306592,.16007832854334622,.10693932599531843,.04717533638651183],[.2325515532308739,.22628318026289723,.2078160475368885,.17814598076194574,.13887351021978725,.09212149983772845,.04048400476531588],[.2152638534631578,.2051984637212956,.18553839747793782,.15720316715819355,.12151857068790319,.08015808715976021,.03511946033175186],[.2025782419255613,.19843148532711158,.1861610000155622,.16626920581699392,.13957067792615432,.10715922046717194,.07036604748810812,.03075324199611727],[.1894506104550685,.18260341504492358,.16915651939500254,.14959598881657674,.12462897125553388,.09515851168249279,.062253523938647894,.027152459411754096]],s=Math.abs,a=Math.sqrt,o=Math.pow,h=Math.log2||function(t){return Math.log(t)*Math.LOG2E},l=1e-12,c=1.12e-16;return{EPSILON:l,MACHINE_EPSILON:c,CURVETIME_EPSILON:1e-8,GEOMETRIC_EPSILON:1e-7,TRIGONOMETRIC_EPSILON:1e-8,KAPPA:4*(a(2)-1)/3,isZero:function(t){return t>=-l&&t<=l},clamp:t,integrate:function(t,e,n,s){for(var a=i[s-2],o=r[s-2],h=.5*(n-e),u=h+e,l=0,c=s+1>>1,f=1&s?o[l++]*t(u):0;l<c;){var d=h*a[l];f+=o[l++]*(t(u+d)+t(u-d))}return h*f},findRoot:function(e,n,i,r,a,o,h){for(var u=0;u<o;u++){var l=e(i),c=l/n(i),f=i-c;if(s(c)<h){i=f;break}l>0?(a=i,i=f<=r?.5*(r+a):f):(r=i,i=f>=a?.5*(r+a):f)}return t(i,r,a)},solveQuadratic:function(i,r,o,h,u,f){var d,_=1/0;if(s(i)<l){if(s(r)<l)return s(o)<l?-1:0;d=-o/r}else{r*=-.5;var g=e(i,r,o);if(g&&s(g)<c){var v=n(s(i),s(r),s(o));v&&(i*=v,r*=v,o*=v,g=e(i,r,o))}if(g>=-c){var p=g<0?0:a(g),m=r+(r<0?-p:p);0===m?(d=o/i,_=-d):(d=m/i,_=o/m)}}var y=0,w=null==u,x=u-l,b=f+l;return isFinite(d)&&(w||d>x&&d<b)&&(h[y++]=w?d:t(d,u,f)),_!==d&&isFinite(_)&&(w||_>x&&_<b)&&(h[y++]=w?_:t(_,u,f)),y},solveCubic:function(e,i,r,h,f,d,_){function g(t){v=t;var n=e*v;p=n+i,m=p*v+r,y=(n+p)*v+m,w=m*v+h}var v,p,m,y,w,x=n(s(e),s(i),s(r),s(h));if(x&&(e*=x,i*=x,r*=x,h*=x),s(e)<l)e=i,p=r,m=h,v=1/0;else if(s(h)<l)p=i,m=r,v=0;else{g(-(i/e)/3);var b=w/e,C=o(s(b),1/3),S=b<0?-1:1,k=-y/e,I=k>0?1.324717957244746*Math.max(C,a(k)):C,P=v-S*I;if(P!==v){do g(P),P=0===y?v:v-w/y/(1+c);while(S*P>S*v);s(e)*v*v>s(h/v)&&(m=-h/v,p=(m-r)/v)}}var T=u.solveQuadratic(e,p,m,f,d,_),M=null==d;return isFinite(v)&&(0===T||T>0&&v!==f[0]&&v!==f[1])&&(M||v>d-l&&v<_+l)&&(f[T++]=M?v:t(v,d,_)),T}}},l={_id:1,_pools:{},get:function(t){if(t){var e=this._pools[t];return e||(e=this._pools[t]={_id:1}),e._id++}return this._id++}},c=r.extend({_class:"Point",_readIndex:!0,initialize:function(t,e){var n=typeof t,i=this.__read,r=0;if("number"===n){var s="number"==typeof e;this._set(t,s?e:t),i&&(r=s?2:1)}else if("undefined"===n||null===t)this._set(0,0),i&&(r=null===t?1:0);else{var a="string"===n?t.split(/[\s,]+/)||[]:t;r=1,Array.isArray(a)?this._set(+a[0],+(a.length>1?a[1]:a[0])):"x"in a?this._set(a.x||0,a.y||0):"width"in a?this._set(a.width||0,a.height||0):"angle"in a?(this._set(a.length||0,0),this.setAngle(a.angle||0)):(this._set(0,0),r=0)}return i&&(this.__read=r),this},set:"#initialize",_set:function(t,e){return this.x=t,this.y=e,this},equals:function(t){return this===t||t&&(this.x===t.x&&this.y===t.y||Array.isArray(t)&&this.x===t[0]&&this.y===t[1])||!1},clone:function(){return new c(this.x,this.y)},toString:function(){var t=h.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.x),e.number(this.y)]},getLength:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},setLength:function(t){if(this.isZero()){var e=this._angle||0;this._set(Math.cos(e)*t,Math.sin(e)*t)}else{var n=t/this.getLength();u.isZero(n)&&this.getAngle(),this._set(this.x*n,this.y*n)}},getAngle:function(){return 180*this.getAngleInRadians.apply(this,arguments)/Math.PI},setAngle:function(t){this.setAngleInRadians.call(this,t*Math.PI/180)},getAngleInDegrees:"#getAngle",setAngleInDegrees:"#setAngle",getAngleInRadians:function(){if(arguments.length){var t=c.read(arguments),e=this.getLength()*t.getLength();if(u.isZero(e))return NaN;var n=this.dot(t)/e;return Math.acos(n<-1?-1:n>1?1:n)}return this.isZero()?this._angle||0:this._angle=Math.atan2(this.y,this.x)},setAngleInRadians:function(t){if(this._angle=t,!this.isZero()){var e=this.getLength();this._set(Math.cos(t)*e,Math.sin(t)*e)}},getQuadrant:function(){return this.x>=0?this.y>=0?1:4:this.y>=0?2:3}},{beans:!1,getDirectedAngle:function(){var t=c.read(arguments);return 180*Math.atan2(this.cross(t),this.dot(t))/Math.PI},getDistance:function(){var t=c.read(arguments),e=t.x-this.x,n=t.y-this.y,i=e*e+n*n,s=r.read(arguments);return s?i:Math.sqrt(i)},normalize:function(t){t===e&&(t=1);var n=this.getLength(),i=0!==n?t/n:0,r=new c(this.x*i,this.y*i);return i>=0&&(r._angle=this._angle),r},rotate:function(t,e){if(0===t)return this.clone();t=t*Math.PI/180;var n=e?this.subtract(e):this,i=Math.sin(t),r=Math.cos(t);return n=new c(n.x*r-n.y*i,n.x*i+n.y*r),e?n.add(e):n},transform:function(t){return t?t._transformPoint(this):this},add:function(){var t=c.read(arguments);return new c(this.x+t.x,this.y+t.y)},subtract:function(){var t=c.read(arguments);return new c(this.x-t.x,this.y-t.y)},multiply:function(){var t=c.read(arguments);return new c(this.x*t.x,this.y*t.y)},divide:function(){var t=c.read(arguments);return new c(this.x/t.x,this.y/t.y)},modulo:function(){var t=c.read(arguments);return new c(this.x%t.x,this.y%t.y)},negate:function(){return new c((-this.x),(-this.y))},isInside:function(){return g.read(arguments).contains(this)},isClose:function(){var t=c.read(arguments),e=r.read(arguments);return this.getDistance(t)<=e},isCollinear:function(){var t=c.read(arguments);return c.isCollinear(this.x,this.y,t.x,t.y)},isColinear:"#isCollinear",isOrthogonal:function(){var t=c.read(arguments);return c.isOrthogonal(this.x,this.y,t.x,t.y)},isZero:function(){var t=u.isZero;return t(this.x)&&t(this.y)},isNaN:function(){return isNaN(this.x)||isNaN(this.y)},isInQuadrant:function(t){return this.x*(t>1&&t<4?-1:1)>=0&&this.y*(t>2?-1:1)>=0},dot:function(){var t=c.read(arguments);return this.x*t.x+this.y*t.y},cross:function(){var t=c.read(arguments);return this.x*t.y-this.y*t.x},project:function(){var t=c.read(arguments),e=t.isZero()?0:this.dot(t)/t.dot(t);return new c(t.x*e,t.y*e)},statics:{min:function(){var t=c.read(arguments),e=c.read(arguments);return new c(Math.min(t.x,e.x),Math.min(t.y,e.y))},max:function(){var t=c.read(arguments),e=c.read(arguments);return new c(Math.max(t.x,e.x),Math.max(t.y,e.y))},random:function(){return new c(Math.random(),Math.random())},isCollinear:function(t,e,n,i){return Math.abs(t*i-e*n)<=1e-8*Math.sqrt((t*t+e*e)*(n*n+i*i))},isOrthogonal:function(t,e,n,i){return Math.abs(t*n+e*i)<=1e-8*Math.sqrt((t*t+e*e)*(n*n+i*i))}}},r.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new c(e(this.x),e(this.y))}},{})),f=c.extend({initialize:function(t,e,n,i){this._x=t,this._y=e,this._owner=n,this._setter=i},_set:function(t,e,n){return this._x=t,this._y=e,n||this._owner[this._setter](this),this},getX:function(){return this._x},setX:function(t){this._x=t,this._owner[this._setter](this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner[this._setter](this)},isSelected:function(){return!!(this._owner._selection&this._getSelection())},setSelected:function(t){this._owner._changeSelection(this._getSelection(),t)},_getSelection:function(){return"setPosition"===this._setter?4:0}}),d=r.extend({_class:"Size",_readIndex:!0,initialize:function(t,e){var n=typeof t,i=this.__read,r=0;if("number"===n){var s="number"==typeof e;this._set(t,s?e:t),i&&(r=s?2:1)}else if("undefined"===n||null===t)this._set(0,0),i&&(r=null===t?1:0);else{var a="string"===n?t.split(/[\s,]+/)||[]:t;r=1,Array.isArray(a)?this._set(+a[0],+(a.length>1?a[1]:a[0])):"width"in a?this._set(a.width||0,a.height||0):"x"in a?this._set(a.x||0,a.y||0):(this._set(0,0),r=0)}return i&&(this.__read=r),this},set:"#initialize",_set:function(t,e){return this.width=t,this.height=e,this},equals:function(t){return t===this||t&&(this.width===t.width&&this.height===t.height||Array.isArray(t)&&this.width===t[0]&&this.height===t[1])||!1},clone:function(){return new d(this.width,this.height)},toString:function(){var t=h.instance;return"{ width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.width),e.number(this.height)]},add:function(){var t=d.read(arguments);return new d(this.width+t.width,this.height+t.height)},subtract:function(){var t=d.read(arguments);return new d(this.width-t.width,this.height-t.height)},multiply:function(){var t=d.read(arguments);return new d(this.width*t.width,this.height*t.height)},divide:function(){var t=d.read(arguments);return new d(this.width/t.width,this.height/t.height)},modulo:function(){var t=d.read(arguments);return new d(this.width%t.width,this.height%t.height)},negate:function(){return new d((-this.width),(-this.height))},isZero:function(){var t=u.isZero;return t(this.width)&&t(this.height)},isNaN:function(){return isNaN(this.width)||isNaN(this.height)},statics:{min:function(t,e){return new d(Math.min(t.width,e.width),Math.min(t.height,e.height))},max:function(t,e){return new d(Math.max(t.width,e.width),Math.max(t.height,e.height))},random:function(){return new d(Math.random(),Math.random())}}},r.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new d(e(this.width),e(this.height))}},{})),_=d.extend({initialize:function(t,e,n,i){this._width=t,this._height=e,this._owner=n,this._setter=i},_set:function(t,e,n){return this._width=t,this._height=e,n||this._owner[this._setter](this),this},getWidth:function(){return this._width},setWidth:function(t){this._width=t,this._owner[this._setter](this)},getHeight:function(){return this._height},setHeight:function(t){this._height=t,this._owner[this._setter](this)}}),g=r.extend({_class:"Rectangle",_readIndex:!0,beans:!0,initialize:function(t,n,i,s){var a,o=typeof t;if("number"===o?(this._set(t,n,i,s),a=4):"undefined"===o||null===t?(this._set(0,0,0,0),a=null===t?1:0):1===arguments.length&&(Array.isArray(t)?(this._set.apply(this,t),a=1):t.x!==e||t.width!==e?(this._set(t.x||0,t.y||0,t.width||0,t.height||0),a=1):t.from===e&&t.to===e&&(this._set(0,0,0,0),r.filter(this,t),a=1)),a===e){var h,u,l=c.readNamed(arguments,"from"),f=r.peek(arguments),_=l.x,g=l.y;if(f&&f.x!==e||r.hasNamed(arguments,"to")){var v=c.readNamed(arguments,"to");h=v.x-_,u=v.y-g,h<0&&(_=v.x,h=-h),u<0&&(g=v.y,u=-u)}else{var p=d.read(arguments);h=p.width,u=p.height}this._set(_,g,h,u),a=arguments.__index;var m=arguments.__filtered;m&&(this.__filtered=m)}return this.__read&&(this.__read=a),this},set:"#initialize",_set:function(t,e,n,i){return this.x=t,this.y=e,this.width=n,this.height=i,this},clone:function(){return new g(this.x,this.y,this.width,this.height)},equals:function(t){var e=r.isPlainValue(t)?g.read(arguments):t;return e===this||e&&this.x===e.x&&this.y===e.y&&this.width===e.width&&this.height===e.height||!1},toString:function(){var t=h.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+", width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.x),e.number(this.y),e.number(this.width),e.number(this.height)]},getPoint:function(t){var e=t?c:f;return new e(this.x,this.y,this,"setPoint")},setPoint:function(){var t=c.read(arguments);this.x=t.x,this.y=t.y},getSize:function(t){var e=t?d:_;return new e(this.width,this.height,this,"setSize")},_fw:1,_fh:1,setSize:function(){var t=d.read(arguments),e=this._sx,n=this._sy,i=t.width,r=t.height;e&&(this.x+=(this.width-i)*e),n&&(this.y+=(this.height-r)*n),this.width=i,this.height=r,this._fw=this._fh=1},getLeft:function(){return this.x},setLeft:function(t){if(!this._fw){var e=t-this.x;this.width-=.5===this._sx?2*e:e}this.x=t,this._sx=this._fw=0},getTop:function(){return this.y},setTop:function(t){if(!this._fh){var e=t-this.y;this.height-=.5===this._sy?2*e:e}this.y=t,this._sy=this._fh=0},getRight:function(){return this.x+this.width},setRight:function(t){if(!this._fw){var e=t-this.x;this.width=.5===this._sx?2*e:e}this.x=t-this.width,this._sx=1,this._fw=0},getBottom:function(){return this.y+this.height},setBottom:function(t){if(!this._fh){var e=t-this.y;this.height=.5===this._sy?2*e:e}this.y=t-this.height,this._sy=1,this._fh=0},getCenterX:function(){return this.x+this.width/2},setCenterX:function(t){this._fw||.5===this._sx?this.x=t-this.width/2:(this._sx&&(this.x+=2*(t-this.x)*this._sx),this.width=2*(t-this.x)),this._sx=.5,this._fw=0},getCenterY:function(){return this.y+this.height/2},setCenterY:function(t){this._fh||.5===this._sy?this.y=t-this.height/2:(this._sy&&(this.y+=2*(t-this.y)*this._sy),this.height=2*(t-this.y)),this._sy=.5,this._fh=0},getCenter:function(t){var e=t?c:f;return new e(this.getCenterX(),this.getCenterY(),this,"setCenter")},setCenter:function(){var t=c.read(arguments);return this.setCenterX(t.x),this.setCenterY(t.y),this},getArea:function(){return this.width*this.height},isEmpty:function(){return 0===this.width||0===this.height},contains:function(t){return t&&t.width!==e||4===(Array.isArray(t)?t:arguments).length?this._containsRectangle(g.read(arguments)):this._containsPoint(c.read(arguments))},_containsPoint:function(t){var e=t.x,n=t.y;return e>=this.x&&n>=this.y&&e<=this.x+this.width&&n<=this.y+this.height},_containsRectangle:function(t){var e=t.x,n=t.y;return e>=this.x&&n>=this.y&&e+t.width<=this.x+this.width&&n+t.height<=this.y+this.height},intersects:function(){var t=g.read(arguments),e=r.read(arguments)||0;return t.x+t.width>this.x-e&&t.y+t.height>this.y-e&&t.x<this.x+this.width+e&&t.y<this.y+this.height+e},intersect:function(){var t=g.read(arguments),e=Math.max(this.x,t.x),n=Math.max(this.y,t.y),i=Math.min(this.x+this.width,t.x+t.width),r=Math.min(this.y+this.height,t.y+t.height);return new g(e,n,i-e,r-n)},unite:function(){var t=g.read(arguments),e=Math.min(this.x,t.x),n=Math.min(this.y,t.y),i=Math.max(this.x+this.width,t.x+t.width),r=Math.max(this.y+this.height,t.y+t.height);return new g(e,n,i-e,r-n)},include:function(){var t=c.read(arguments),e=Math.min(this.x,t.x),n=Math.min(this.y,t.y),i=Math.max(this.x+this.width,t.x),r=Math.max(this.y+this.height,t.y);return new g(e,n,i-e,r-n)},expand:function(){var t=d.read(arguments),e=t.width,n=t.height;return new g(this.x-e/2,this.y-n/2,this.width+e,this.height+n)},scale:function(t,n){return this.expand(this.width*t-this.width,this.height*(n===e?t:n)-this.height)}},r.each([["Top","Left"],["Top","Right"],["Bottom","Left"],["Bottom","Right"],["Left","Center"],["Top","Center"],["Right","Center"],["Bottom","Center"]],function(t,e){var n=t.join(""),i=/^[RL]/.test(n);e>=4&&(t[1]+=i?"Y":"X");var r=t[i?0:1],s=t[i?1:0],a="get"+r,o="get"+s,h="set"+r,u="set"+s,l="get"+n,d="set"+n;this[l]=function(t){var e=t?c:f;return new e(this[a](),this[o](),this,d)},this[d]=function(){var t=c.read(arguments);this[h](t.x),this[u](t.y)}},{beans:!0})),v=g.extend({initialize:function(t,e,n,i,r,s){this._set(t,e,n,i,!0),this._owner=r,this._setter=s},_set:function(t,e,n,i,r){return this._x=t,this._y=e,this._width=n,this._height=i,r||this._owner[this._setter](this),this}},new function(){var t=g.prototype;return r.each(["x","y","width","height"],function(t){var e=r.capitalize(t),n="_"+t;this["get"+e]=function(){return this[n]},this["set"+e]=function(t){this[n]=t,this._dontNotify||this._owner[this._setter](this)}},r.each(["Point","Size","Center","Left","Top","Right","Bottom","CenterX","CenterY","TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],function(e){var n="set"+e;this[n]=function(){this._dontNotify=!0,t[n].apply(this,arguments),this._dontNotify=!1,this._owner[this._setter](this)}},{isSelected:function(){return!!(2&this._owner._selection)},setSelected:function(t){var e=this._owner;e._changeSelection&&e._changeSelection(2,t)}}))}),p=r.extend({_class:"Matrix",initialize:function ut(t,e){var n=arguments.length,i=!0;if(n>=6?this._set.apply(this,arguments):1===n||2===n?t instanceof ut?this._set(t._a,t._b,t._c,t._d,t._tx,t._ty,e):Array.isArray(t)?this._set.apply(this,e?t.concat([e]):t):i=!1:n?i=!1:this.reset(),!i)throw new Error("Unsupported matrix parameters");return this},set:"#initialize",_set:function(t,e,n,i,r,s,a){return this._a=t,this._b=e,this._c=n,this._d=i,this._tx=r,this._ty=s,a||this._changed(),this},_serialize:function(t,e){return r.serialize(this.getValues(),t,!0,e)},_changed:function(){var t=this._owner;t&&(t._applyMatrix?t.transform(null,!0):t._changed(25))},clone:function(){return new p(this._a,this._b,this._c,this._d,this._tx,this._ty)},equals:function(t){return t===this||t&&this._a===t._a&&this._b===t._b&&this._c===t._c&&this._d===t._d&&this._tx===t._tx&&this._ty===t._ty},toString:function(){var t=h.instance;return"[["+[t.number(this._a),t.number(this._c),t.number(this._tx)].join(", ")+"], ["+[t.number(this._b),t.number(this._d),t.number(this._ty)].join(", ")+"]]"},reset:function(t){return this._a=this._d=1,this._b=this._c=this._tx=this._ty=0,t||this._changed(),this},apply:function(t,e){var n=this._owner;return!!n&&(n.transform(null,!0,r.pick(t,!0),e),this.isIdentity())},translate:function(){var t=c.read(arguments),e=t.x,n=t.y;return this._tx+=e*this._a+n*this._c,this._ty+=e*this._b+n*this._d,this._changed(),this},scale:function(){var t=c.read(arguments),e=c.read(arguments,0,{readNull:!0});return e&&this.translate(e),this._a*=t.x,this._b*=t.x,
this._c*=t.y,this._d*=t.y,e&&this.translate(e.negate()),this._changed(),this},rotate:function(t){t*=Math.PI/180;var e=c.read(arguments,1),n=e.x,i=e.y,r=Math.cos(t),s=Math.sin(t),a=n-n*r+i*s,o=i-n*s-i*r,h=this._a,u=this._b,l=this._c,f=this._d;return this._a=r*h+s*l,this._b=r*u+s*f,this._c=-s*h+r*l,this._d=-s*u+r*f,this._tx+=a*h+o*l,this._ty+=a*u+o*f,this._changed(),this},shear:function(){var t=c.read(arguments),e=c.read(arguments,0,{readNull:!0});e&&this.translate(e);var n=this._a,i=this._b;return this._a+=t.y*this._c,this._b+=t.y*this._d,this._c+=t.x*n,this._d+=t.x*i,e&&this.translate(e.negate()),this._changed(),this},skew:function(){var t=c.read(arguments),e=c.read(arguments,0,{readNull:!0}),n=Math.PI/180,i=new c(Math.tan(t.x*n),Math.tan(t.y*n));return this.shear(i,e)},append:function(t,e){if(t){var n=this._a,i=this._b,r=this._c,s=this._d,a=t._a,o=t._c,h=t._b,u=t._d,l=t._tx,c=t._ty;this._a=a*n+h*r,this._c=o*n+u*r,this._b=a*i+h*s,this._d=o*i+u*s,this._tx+=l*n+c*r,this._ty+=l*i+c*s,e||this._changed()}return this},prepend:function(t,e){if(t){var n=this._a,i=this._b,r=this._c,s=this._d,a=this._tx,o=this._ty,h=t._a,u=t._c,l=t._b,c=t._d,f=t._tx,d=t._ty;this._a=h*n+u*i,this._c=h*r+u*s,this._b=l*n+c*i,this._d=l*r+c*s,this._tx=h*a+u*o+f,this._ty=l*a+c*o+d,e||this._changed()}return this},appended:function(t){return this.clone().append(t)},prepended:function(t){return this.clone().prepend(t)},invert:function(){var t=this._a,e=this._b,n=this._c,i=this._d,r=this._tx,s=this._ty,a=t*i-e*n,o=null;return a&&!isNaN(a)&&isFinite(r)&&isFinite(s)&&(this._a=i/a,this._b=-e/a,this._c=-n/a,this._d=t/a,this._tx=(n*s-i*r)/a,this._ty=(e*r-t*s)/a,o=this),o},inverted:function(){return this.clone().invert()},concatenate:"#append",preConcatenate:"#prepend",chain:"#appended",_shiftless:function(){return new p(this._a,this._b,this._c,this._d,0,0)},_orNullIfIdentity:function(){return this.isIdentity()?null:this},isIdentity:function(){return 1===this._a&&0===this._b&&0===this._c&&1===this._d&&0===this._tx&&0===this._ty},isInvertible:function(){var t=this._a*this._d-this._c*this._b;return t&&!isNaN(t)&&isFinite(this._tx)&&isFinite(this._ty)},isSingular:function(){return!this.isInvertible()},transform:function(t,e,n){return arguments.length<3?this._transformPoint(c.read(arguments)):this._transformCoordinates(t,e,n)},_transformPoint:function(t,e,n){var i=t.x,r=t.y;return e||(e=new c),e._set(i*this._a+r*this._c+this._tx,i*this._b+r*this._d+this._ty,n)},_transformCoordinates:function(t,e,n){for(var i=0,r=2*n;i<r;i+=2){var s=t[i],a=t[i+1];e[i]=s*this._a+a*this._c+this._tx,e[i+1]=s*this._b+a*this._d+this._ty}return e},_transformCorners:function(t){var e=t.x,n=t.y,i=e+t.width,r=n+t.height,s=[e,n,i,n,i,r,e,r];return this._transformCoordinates(s,s,4)},_transformBounds:function(t,e,n){for(var i=this._transformCorners(t),r=i.slice(0,2),s=r.slice(),a=2;a<8;a++){var o=i[a],h=1&a;o<r[h]?r[h]=o:o>s[h]&&(s[h]=o)}return e||(e=new g),e._set(r[0],r[1],s[0]-r[0],s[1]-r[1],n)},inverseTransform:function(){return this._inverseTransform(c.read(arguments))},_inverseTransform:function(t,e,n){var i=this._a,r=this._b,s=this._c,a=this._d,o=this._tx,h=this._ty,u=i*a-r*s,l=null;if(u&&!isNaN(u)&&isFinite(o)&&isFinite(h)){var f=t.x-this._tx,d=t.y-this._ty;e||(e=new c),l=e._set((f*a-d*s)/u,(d*i-f*r)/u,n)}return l},decompose:function(){var t,e,n,i=this._a,r=this._b,s=this._c,a=this._d,o=i*a-r*s,h=Math.sqrt,u=Math.atan2,l=180/Math.PI;if(0!==i||0!==r){var f=h(i*i+r*r);t=Math.acos(i/f)*(r>0?1:-1),e=[f,o/f],n=[u(i*s+r*a,f*f),0]}else if(0!==s||0!==a){var d=h(s*s+a*a);t=Math.asin(s/d)*(a>0?1:-1),e=[o/d,d],n=[0,u(i*s+r*a,d*d)]}else t=0,n=e=[0,0];return{translation:this.getTranslation(),rotation:t*l,scaling:new c(e),skewing:new c(n[0]*l,n[1]*l)}},getValues:function(){return[this._a,this._b,this._c,this._d,this._tx,this._ty]},getTranslation:function(){return new c(this._tx,this._ty)},getScaling:function(){return this.decompose().scaling},getRotation:function(){return this.decompose().rotation},applyToContext:function(t){this.isIdentity()||t.transform(this._a,this._b,this._c,this._d,this._tx,this._ty)}},r.each(["a","b","c","d","tx","ty"],function(t){var e=r.capitalize(t),n="_"+t;this["get"+e]=function(){return this[n]},this["set"+e]=function(t){this[n]=t,this._changed()}},{})),m=r.extend({_class:"Line",initialize:function(t,e,n,i,r){var s=!1;arguments.length>=4?(this._px=t,this._py=e,this._vx=n,this._vy=i,s=r):(this._px=t.x,this._py=t.y,this._vx=e.x,this._vy=e.y,s=n),s||(this._vx-=this._px,this._vy-=this._py)},getPoint:function(){return new c(this._px,this._py)},getVector:function(){return new c(this._vx,this._vy)},getLength:function(){return this.getVector().getLength()},intersect:function(t,e){return m.intersect(this._px,this._py,this._vx,this._vy,t._px,t._py,t._vx,t._vy,!0,e)},getSide:function(t,e){return m.getSide(this._px,this._py,this._vx,this._vy,t.x,t.y,!0,e)},getDistance:function(t){return Math.abs(this.getSignedDistance(t))},getSignedDistance:function(t){return m.getSignedDistance(this._px,this._py,this._vx,this._vy,t.x,t.y,!0)},isCollinear:function(t){return c.isCollinear(this._vx,this._vy,t._vx,t._vy)},isOrthogonal:function(t){return c.isOrthogonal(this._vx,this._vy,t._vx,t._vy)},statics:{intersect:function(t,e,n,i,r,s,a,o,h,l){h||(n-=t,i-=e,a-=r,o-=s);var f=n*o-i*a;if(!u.isZero(f)){var d=t-r,_=e-s,g=(a*_-o*d)/f,v=(n*_-i*d)/f,p=1e-12,m=-p,y=1+p;if(l||m<g&&g<y&&m<v&&v<y)return l||(g=g<=0?0:g>=1?1:g),new c(t+g*n,e+g*i)}},getSide:function(t,e,n,i,r,s,a,o){a||(n-=t,i-=e);var h=r-t,l=s-e,c=h*i-l*n;return!o&&u.isZero(c)&&(c=(h*n+h*n)/(n*n+i*i),c>=0&&c<=1&&(c=0)),c<0?-1:c>0?1:0},getSignedDistance:function(t,e,n,i,r,s,a){return a||(n-=t,i-=e),0===n?i>0?r-t:t-r:0===i?n<0?s-e:e-s:((r-t)*i-(s-e)*n)/Math.sqrt(n*n+i*i)},getDistance:function(t,e,n,i,r,s,a){return Math.abs(m.getSignedDistance(t,e,n,i,r,s,a))}}}),y=o.extend({_class:"Project",_list:"projects",_reference:"project",_compactSerialize:!0,initialize:function(t){o.call(this,!0),this._children=[],this._namedChildren={},this._activeLayer=null,this._currentStyle=new V(null,null,this),this._view=Z.create(this,t||et.getCanvas(1,1)),this._selectionItems={},this._selectionCount=0,this._updateVersion=0},_serialize:function(t,e){return r.serialize(this._children,t,!0,e)},_changed:function(t,e){if(1&t){var n=this._view;n&&(n._needsUpdate=!0,!n._requested&&n._autoUpdate&&n.requestUpdate())}var i=this._changes;if(i&&e){var r=this._changesById,s=e._id,a=r[s];a?a.flags|=t:i.push(r[s]={item:e,flags:t})}},clear:function(){for(var t=this._children,e=t.length-1;e>=0;e--)t[e].remove()},isEmpty:function(){return!this._children.length},remove:function lt(){return!!lt.base.call(this)&&(this._view&&this._view.remove(),!0)},getView:function(){return this._view},getCurrentStyle:function(){return this._currentStyle},setCurrentStyle:function(t){this._currentStyle.set(t)},getIndex:function(){return this._index},getOptions:function(){return this._scope.settings},getLayers:function(){return this._children},getActiveLayer:function(){return this._activeLayer||new b({project:this,insert:!0})},getSymbolDefinitions:function(){var t=[],e={};return this.getItems({"class":k,match:function(n){var i=n._definition,r=i._id;return e[r]||(e[r]=!0,t.push(i)),!1}}),t},getSymbols:"getSymbolDefinitions",getSelectedItems:function(){var t=this._selectionItems,e=[];for(var n in t){var i=t[n],r=i._selection;1&r&&i.isInserted()?e.push(i):r||this._updateSelection(i)}return e},_updateSelection:function(t){var e=t._id,n=this._selectionItems;t._selection?n[e]!==t&&(this._selectionCount++,n[e]=t):n[e]===t&&(this._selectionCount--,delete n[e])},selectAll:function(){for(var t=this._children,e=0,n=t.length;e<n;e++)t[e].setFullySelected(!0)},deselectAll:function(){var t=this._selectionItems;for(var e in t)t[e].setFullySelected(!1)},addLayer:function(t){return this.insertLayer(e,t)},insertLayer:function(t,e){if(e instanceof b){e._remove(!1,!0),r.splice(this._children,[e],t,0),e._setProject(this,!0);var n=e._name;n&&e.setName(n),this._changes&&e._changed(5),this._activeLayer||(this._activeLayer=e)}else e=null;return e},_insertItem:function(t,n,i){return n=this.insertLayer(t,n)||(this._activeLayer||this._insertItem(e,new b(w.NO_INSERT),!0)).insertChild(t,n),i&&n.activate&&n.activate(),n},getItems:function(t){return w._getItems(this,t)},getItem:function(t){return w._getItems(this,t,null,null,!0)[0]||null},importJSON:function(t){this.activate();var e=this._activeLayer;return r.importJSON(t,e&&e.isEmpty()&&e)},removeOn:function(t){var e=this._removeSets;if(e){"mouseup"===t&&(e.mousedrag=null);var n=e[t];if(n){for(var i in n){var r=n[i];for(var s in e){var a=e[s];a&&a!=n&&delete a[r._id]}r.remove()}e[t]=null}}},draw:function(t,e,n){this._updateVersion++,t.save(),e.applyToContext(t);for(var i=this._children,s=new r({offset:new c(0,0),pixelRatio:n,viewMatrix:e.isIdentity()?null:e,matrices:[new p],updateMatrix:!0}),a=0,o=i.length;a<o;a++)i[a].draw(t,s);if(t.restore(),this._selectionCount>0){t.save(),t.strokeWidth=1;var h=this._selectionItems,u=this._scope.settings.handleSize,l=this._updateVersion;for(var f in h)h[f]._drawSelection(t,e,u,h,l);t.restore()}}}),w=r.extend(s,{statics:{extend:function ct(t){return t._serializeFields&&(t._serializeFields=r.set({},this.prototype._serializeFields,t._serializeFields)),ct.base.apply(this,arguments)},NO_INSERT:{insert:!1}},_class:"Item",_name:null,_applyMatrix:!0,_canApplyMatrix:!0,_canScaleStroke:!1,_pivot:null,_visible:!0,_blendMode:"normal",_opacity:1,_locked:!1,_guide:!1,_clipMask:!1,_selection:0,_selectBounds:!0,_selectChildren:!1,_serializeFields:{name:null,applyMatrix:null,matrix:new p,pivot:null,visible:!0,blendMode:"normal",opacity:1,locked:!1,guide:!1,clipMask:!1,selected:!1,data:{}},_prioritize:["applyMatrix"]},new function(){var t=["onMouseDown","onMouseUp","onMouseDrag","onClick","onDoubleClick","onMouseMove","onMouseEnter","onMouseLeave"];return r.each(t,function(t){this._events[t]={install:function(t){this.getView()._countItemEvent(t,1)},uninstall:function(t){this.getView()._countItemEvent(t,-1)}}},{_events:{onFrame:{install:function(){this.getView()._animateItem(this,!0)},uninstall:function(){this.getView()._animateItem(this,!1)}},onLoad:{},onError:{}},statics:{_itemHandlers:t}})},{initialize:function(){},_initialize:function(t,n){var i=t&&r.isPlainObject(t),s=i&&t.internal===!0,a=this._matrix=new p,o=i&&t.project||st.project,h=st.settings;return this._id=s?null:l.get(),this._parent=this._index=null,this._applyMatrix=this._canApplyMatrix&&h.applyMatrix,n&&a.translate(n),a._owner=this,this._style=new V(o._currentStyle,this,o),s||i&&0==t.insert||!h.insertItems&&(!i||t.insert!==!0)?this._setProject(o):(i&&t.parent||o)._insertItem(e,this,!0),i&&t!==w.NO_INSERT&&this.set(t,{internal:!0,insert:!0,project:!0,parent:!0}),i},_serialize:function(t,e){function n(n){for(var a in n){var o=s[a];r.equals(o,"leading"===a?1.2*n.fontSize:n[a])||(i[a]=r.serialize(o,t,"data"!==a,e))}}var i={},s=this;return n(this._serializeFields),this instanceof x||n(this._style._defaults),[this._class,i]},_changed:function(t){var n=this._symbol,i=this._parent||n,r=this._project;8&t&&(this._bounds=this._position=this._decomposed=e),16&t&&(this._globalMatrix=e),i&&72&t&&w._clearBoundsCache(i),2&t&&w._clearBoundsCache(this),r&&r._changed(t,this),n&&n._changed(t)},getId:function(){return this._id},getName:function(){return this._name},setName:function(t){if(this._name&&this._removeNamed(),t===+t+"")throw new Error("Names consisting only of numbers are not supported.");var n=this._getOwner();if(t&&n){var i=n._children,r=n._namedChildren;(r[t]=r[t]||[]).push(this),t in i||(i[t]=this)}this._name=t||e,this._changed(256)},getStyle:function(){return this._style},setStyle:function(t){this.getStyle().set(t)}},r.each(["locked","visible","blendMode","opacity","guide"],function(t){var e=r.capitalize(t),n="_"+t,i={locked:256,visible:265};this["get"+e]=function(){return this[n]},this["set"+e]=function(e){e!=this[n]&&(this[n]=e,this._changed(i[t]||257))}},{}),{beans:!0,getSelection:function(){return this._selection},setSelection:function(t){if(t!==this._selection){this._selection=t;var e=this._project;e&&(e._updateSelection(this),this._changed(257))}},_changeSelection:function(t,e){var n=this._selection;this.setSelection(e?n|t:n&~t)},isSelected:function(){if(this._selectChildren)for(var t=this._children,e=0,n=t.length;e<n;e++)if(t[e].isSelected())return!0;return!!(1&this._selection)},setSelected:function(t){if(this._selectChildren)for(var e=this._children,n=0,i=e.length;n<i;n++)e[n].setSelected(t);this._changeSelection(1,t)},isFullySelected:function(){var t=this._children,e=!!(1&this._selection);if(t&&e){for(var n=0,i=t.length;n<i;n++)if(!t[n].isFullySelected())return!1;return!0}return e},setFullySelected:function(t){var e=this._children;if(e)for(var n=0,i=e.length;n<i;n++)e[n].setFullySelected(t);this._changeSelection(1,t)},isClipMask:function(){return this._clipMask},setClipMask:function(t){this._clipMask!=(t=!!t)&&(this._clipMask=t,t&&(this.setFillColor(null),this.setStrokeColor(null)),this._changed(257),this._parent&&this._parent._changed(2048))},getData:function(){return this._data||(this._data={}),this._data},setData:function(t){this._data=t},getPosition:function(t){var e=t?c:f,n=this._position||(this._position=this._getPositionFromBounds());return new e(n.x,n.y,this,"setPosition")},setPosition:function(){this.translate(c.read(arguments).subtract(this.getPosition(!0)))},_getPositionFromBounds:function(t){return this._pivot?this._matrix._transformPoint(this._pivot):(t||this.getBounds()).getCenter(!0)},getPivot:function(){var t=this._pivot;return t?new f(t.x,t.y,this,"setPivot"):null},setPivot:function(){this._pivot=c.read(arguments,0,{clone:!0,readNull:!0}),this._position=e}},r.each({getStrokeBounds:{stroke:!0},getHandleBounds:{handle:!0},getInternalBounds:{internal:!0}},function(t,e){this[e]=function(e){return this.getBounds(e,t)}},{beans:!0,getBounds:function(t,e){var n=e||t instanceof p,i=r.set({},n?e:t,this._boundsOptions);i.stroke&&!this.getStrokeScaling()||(i.cacheItem=this);var s=this._getCachedBounds(n&&t,i).rect;return arguments.length?s:new v(s.x,s.y,s.width,s.height,this,"setBounds")},setBounds:function(){var t=g.read(arguments),e=this.getBounds(),n=this._matrix,i=new p,r=t.getCenter();i.translate(r),t.width==e.width&&t.height==e.height||(n.isInvertible()||(n.set(n._backup||(new p).translate(n.getTranslation())),e=this.getBounds()),i.scale(0!==e.width?t.width/e.width:0,0!==e.height?t.height/e.height:0)),r=e.getCenter(),i.translate(-r.x,-r.y),this.transform(i)},_getBounds:function(t,e){var n=this._children;return n&&n.length?(w._updateBoundsCache(this,e.cacheItem),w._getBounds(n,t,e)):new g},_getBoundsCacheKey:function(t,e){return[t.stroke?1:0,t.handle?1:0,e?1:0].join("")},_getCachedBounds:function(t,e,n){t=t&&t._orNullIfIdentity();var i=e.internal&&!n,r=e.cacheItem,s=i?null:this._matrix._orNullIfIdentity(),a=r&&(!t||t.equals(s))&&this._getBoundsCacheKey(e,i),o=this._bounds;if(w._updateBoundsCache(this._parent||this._symbol,r),a&&o&&a in o){var h=o[a];return{rect:h.rect.clone(),nonscaling:h.nonscaling}}var u=this._getBounds(t||s,e),l=u.rect||u,c=this._style,f=u.nonscaling||c.hasStroke()&&!c.getStrokeScaling();if(a){o||(this._bounds=o={});var h=o[a]={rect:l.clone(),nonscaling:f,internal:i}}return{rect:l,nonscaling:f}},_getStrokeMatrix:function(t,e){var n=this.getStrokeScaling()?null:e&&e.internal?this:this._parent||this._symbol&&this._symbol._item,i=n?n.getViewMatrix().invert():t;return i&&i._shiftless()},statics:{_updateBoundsCache:function(t,e){if(t&&e){var n=e._id,i=t._boundsCache=t._boundsCache||{ids:{},list:[]};i.ids[n]||(i.list.push(e),i.ids[n]=e)}},_clearBoundsCache:function(t){var n=t._boundsCache;if(n){t._bounds=t._position=t._boundsCache=e;for(var i=0,r=n.list,s=r.length;i<s;i++){var a=r[i];a!==t&&(a._bounds=a._position=e,a._boundsCache&&w._clearBoundsCache(a))}}},_getBounds:function(t,e,n){var i=1/0,r=-i,s=i,a=r,o=!1;n=n||{};for(var h=0,u=t.length;h<u;h++){var l=t[h];if(l._visible&&!l.isEmpty()){var c=l._getCachedBounds(e&&e.appended(l._matrix),n,!0),f=c.rect;i=Math.min(f.x,i),s=Math.min(f.y,s),r=Math.max(f.x+f.width,r),a=Math.max(f.y+f.height,a),c.nonscaling&&(o=!0)}}return{rect:isFinite(i)?new g(i,s,r-i,a-s):new g,nonscaling:o}}}}),{beans:!0,_decompose:function(){return this._applyMatrix?null:this._decomposed||(this._decomposed=this._matrix.decompose())},getRotation:function(){var t=this._decompose();return t?t.rotation:0},setRotation:function(t){var e=this.getRotation();if(null!=e&&null!=t){var n=this._decomposed;this.rotate(t-e),n&&(n.rotation=t,this._decomposed=n)}},getScaling:function(){var t=this._decompose(),e=t&&t.scaling;return new f(e?e.x:1,e?e.y:1,this,"setScaling")},setScaling:function(){var t=this.getScaling(),e=c.read(arguments,0,{clone:!0,readNull:!0});if(t&&e&&!t.equals(e)){var n=this.getRotation(),i=this._decomposed,r=new p,s=this.getPosition(!0);r.translate(s),n&&r.rotate(n),r.scale(e.x/t.x,e.y/t.y),n&&r.rotate(-n),r.translate(s.negate()),this.transform(r),i&&(i.scaling=e,this._decomposed=i)}},getMatrix:function(){return this._matrix},setMatrix:function(){var t=this._matrix;t.initialize.apply(t,arguments)},getGlobalMatrix:function(t){var e=this._globalMatrix;if(e)for(var n=this._parent,i=[];n;){if(!n._globalMatrix){e=null;for(var r=0,s=i.length;r<s;r++)i[r]._globalMatrix=null;break}i.push(n),n=n._parent}if(!e){e=this._globalMatrix=this._matrix.clone();var n=this._parent;n&&e.prepend(n.getGlobalMatrix(!0))}return t?e:e.clone()},getViewMatrix:function(){return this.getGlobalMatrix().prepend(this.getView()._matrix)},getApplyMatrix:function(){return this._applyMatrix},setApplyMatrix:function(t){(this._applyMatrix=this._canApplyMatrix&&!!t)&&this.transform(null,!0)},getTransformContent:"#getApplyMatrix",setTransformContent:"#setApplyMatrix"},{getProject:function(){return this._project},_setProject:function(t,e){if(this._project!==t){this._project&&this._installEvents(!1),this._project=t;for(var n=this._children,i=0,r=n&&n.length;i<r;i++)n[i]._setProject(t);e=!0}e&&this._installEvents(!0)},getView:function(){return this._project._view},_installEvents:function ft(t){ft.base.call(this,t);for(var e=this._children,n=0,i=e&&e.length;n<i;n++)e[n]._installEvents(t)},getLayer:function(){for(var t=this;t=t._parent;)if(t instanceof b)return t;return null},getParent:function(){return this._parent},setParent:function(t){return t.addChild(this)},_getOwner:"#getParent",getChildren:function(){return this._children},setChildren:function(t){this.removeChildren(),this.addChildren(t)},getFirstChild:function(){return this._children&&this._children[0]||null},getLastChild:function(){return this._children&&this._children[this._children.length-1]||null},getNextSibling:function(){var t=this._getOwner();return t&&t._children[this._index+1]||null},getPreviousSibling:function(){var t=this._getOwner();return t&&t._children[this._index-1]||null},getIndex:function(){return this._index},equals:function(t){return t===this||t&&this._class===t._class&&this._style.equals(t._style)&&this._matrix.equals(t._matrix)&&this._locked===t._locked&&this._visible===t._visible&&this._blendMode===t._blendMode&&this._opacity===t._opacity&&this._clipMask===t._clipMask&&this._guide===t._guide&&this._equals(t)||!1},_equals:function(t){return r.equals(this._children,t._children)},clone:function(t){var n=new this.constructor(w.NO_INSERT),i=this._children,s=r.pick(t?t.insert:e,t===e||t===!0),a=r.pick(t?t.deep:e,!0);i&&n.copyAttributes(this),i&&!a||n.copyContent(this),i||n.copyAttributes(this),s&&n.insertAbove(this);var o=this._name,h=this._parent;if(o&&h){for(var i=h._children,u=o,l=1;i[o];)o=u+" "+l++;o!==u&&n.setName(o)}return n},copyContent:function(t){for(var e=t._children,n=0,i=e&&e.length;n<i;n++)this.addChild(e[n].clone(!1),!0)},copyAttributes:function(t,e){this.setStyle(t._style);for(var n=["_locked","_visible","_blendMode","_opacity","_clipMask","_guide"],i=0,s=n.length;i<s;i++){var a=n[i];t.hasOwnProperty(a)&&(this[a]=t[a])}e||this._matrix.set(t._matrix,!0),this.setApplyMatrix(t._applyMatrix),this.setPivot(t._pivot),this.setSelection(t._selection);var o=t._data,h=t._name;this._data=o?r.clone(o):null,h&&this.setName(h)},rasterize:function(t,n){var i=this.getStrokeBounds(),s=(t||this.getView().getResolution())/72,a=i.getTopLeft().floor(),o=i.getBottomRight().ceil(),h=new d(o.subtract(a)),u=new S(w.NO_INSERT);if(!h.isZero()){var l=et.getCanvas(h.multiply(s)),c=l.getContext("2d"),f=(new p).scale(s).translate(a.negate());c.save(),f.applyToContext(c),this.draw(c,new r({matrices:[f]})),c.restore(),u.setCanvas(l)}return u.transform((new p).translate(a.add(h.divide(2))).scale(1/s)),(n===e||n)&&u.insertAbove(this),u},contains:function(){return!!this._contains(this._matrix._inverseTransform(c.read(arguments)))},_contains:function(t){var e=this._children;if(e){for(var n=e.length-1;n>=0;n--)if(e[n].contains(t))return!0;return!1}return t.isInside(this.getInternalBounds())},isInside:function(){return g.read(arguments).contains(this.getBounds())},_asPathItem:function(){return new L.Rectangle({rectangle:this.getInternalBounds(),matrix:this._matrix,insert:!1})},intersects:function(t,e){return t instanceof w&&this._asPathItem().getIntersections(t._asPathItem(),null,e,!0).length>0}},new function(){function t(){return this._hitTest(c.read(arguments),P.getOptions(arguments))}function e(){var t=c.read(arguments),e=P.getOptions(arguments),n=[];return this._hitTest(t,r.set({all:n},e)),n}function n(t,e,n,i){var r=this._children;if(r)for(var s=r.length-1;s>=0;s--){var a=r[s],o=a!==i&&a._hitTest(t,e,n);if(o&&!e.all)return o}return null}return y.inject({hitTest:t,hitTestAll:e,_hitTest:n}),{hitTest:t,hitTestAll:e,_hitTestChildren:n}},{_hitTest:function(t,e,n){function i(t){return t&&_&&!_(t)&&(t=null),t&&e.all&&e.all.push(t),t}function s(e,n){var i=n?l["get"+n]():g.getPosition();if(t.subtract(i).divide(u).length<=1)return new P(e,g,{name:n?r.hyphenate(n):e,point:i})}if(this._locked||!this._visible||this._guide&&!e.guides||this.isEmpty())return null;var a=this._matrix,o=n?n.appended(a):this.getGlobalMatrix().prepend(this.getView()._matrix),h=Math.max(e.tolerance,1e-12),u=e._tolerancePadding=new d(L._getStrokePadding(h,a._shiftless().invert()));if(t=a._inverseTransform(t),!t||!this._children&&!this.getBounds({internal:!0,stroke:!0,handle:!0}).expand(u.multiply(2))._containsPoint(t))return null;var l,c,f=!(e.guides&&!this._guide||e.selected&&!this.isSelected()||e.type&&e.type!==r.hyphenate(this._class)||e["class"]&&!(this instanceof e["class"])),_=e.match,g=this,v=e.position,p=e.center,m=e.bounds;if(f&&this._parent&&(v||p||m)){if((p||m)&&(l=this.getInternalBounds()),c=v&&s("position")||p&&s("center","Center"),!c&&m)for(var y=["TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],w=0;w<8&&!c;w++)c=s("bounds",y[w]);c=i(c)}return c||(c=this._hitTestChildren(t,e,o)||f&&i(this._hitTestSelf(t,e,o,this.getStrokeScaling()?null:o._shiftless().invert()))||null),c&&c.point&&(c.point=a.transform(c.point)),c},_hitTestSelf:function(t,e){if(e.fill&&this.hasFill()&&this._contains(t))return new P("fill",this)},matches:function(t,e){function n(t,e){for(var i in t)if(t.hasOwnProperty(i)){var s=t[i],a=e[i];if(r.isPlainObject(s)&&r.isPlainObject(a)){if(!n(s,a))return!1}else if(!r.equals(s,a))return!1}return!0}var i=typeof t;if("object"===i){for(var s in t)if(t.hasOwnProperty(s)&&!this.matches(s,t[s]))return!1;return!0}if("function"===i)return t(this);if("match"===t)return e(this);var a=/^(empty|editable)$/.test(t)?this["is"+r.capitalize(t)]():"type"===t?r.hyphenate(this._class):this[t];if("class"===t){if("function"==typeof e)return this instanceof e;a=this._class}if("function"==typeof e)return!!e(a);if(e){if(e.test)return e.test(a);if(r.isPlainObject(e))return n(e,a)}return r.equals(a,e)},getItems:function(t){return w._getItems(this,t,this._matrix)},getItem:function(t){return w._getItems(this,t,this._matrix,null,!0)[0]||null},statics:{_getItems:function dt(t,e,n,i,s){if(!i){var a="object"==typeof e&&e,o=a&&a.overlapping,h=a&&a.inside,u=o||h,l=u&&g.read([u]);i={items:[],recursive:a&&a.recursive!==!1,inside:!!h,overlapping:!!o,rect:l,path:o&&new L.Rectangle({rectangle:l,insert:!1})},a&&(e=r.filter({},e,{recursive:!0,inside:!0,overlapping:!0}))}var c=t._children,f=i.items,l=i.rect;n=l&&(n||new p);for(var d=0,_=c&&c.length;d<_;d++){var v=c[d],m=n&&n.appended(v._matrix),y=!0;if(l){var u=v.getBounds(m);if(!l.intersects(u))continue;l.contains(u)||i.overlapping&&(u.contains(l)||i.path.intersects(v,m))||(y=!1)}if(y&&v.matches(e)&&(f.push(v),s))break;if(i.recursive!==!1&&dt(v,e,m,i,s),s&&f.length>0)break}return f}}},{importJSON:function(t){var e=r.importJSON(t,this);return e!==this?this.addChild(e):e},addChild:function(t){return this.insertChild(e,t)},insertChild:function(t,e){var n=e?this.insertChildren(t,[e]):null;return n&&n[0]},addChildren:function(t){return this.insertChildren(this._children.length,t)},insertChildren:function(t,e){var n=this._children;if(n&&e&&e.length>0){e=r.slice(e);for(var i={},s=e.length-1;s>=0;s--){var a=e[s],o=a&&a._id;!a||i[o]?e.splice(s,1):(a._remove(!1,!0),i[o]=!0)}r.splice(n,e,t,0);for(var h=this._project,u=h._changes,s=0,l=e.length;s<l;s++){var a=e[s],c=a._name;a._parent=this,a._setProject(h,!0),c&&a.setName(c),u&&a._changed(5)}this._changed(11)}else e=null;return e},_insertItem:"#insertChild",_insertAt:function(t,e){var n=t&&t._getOwner(),i=t!==this&&n?this:null;return i&&(i._remove(!1,!0),n._insertItem(t._index+e,i)),i},insertAbove:function(t){return this._insertAt(t,1)},insertBelow:function(t){return this._insertAt(t,0)},sendToBack:function(){var t=this._getOwner();return t?t._insertItem(0,this):null},bringToFront:function(){var t=this._getOwner();return t?t._insertItem(e,this):null},appendTop:"#addChild",appendBottom:function(t){return this.insertChild(0,t)},moveAbove:"#insertAbove",moveBelow:"#insertBelow",addTo:function(t){return t._insertItem(e,this)},copyTo:function(t){return this.clone(!1).addTo(t)},reduce:function(t){var e=this._children;if(e&&1===e.length){var n=e[0].reduce(t);return this._parent?(n.insertAbove(this),this.remove()):n.remove(),n}return this},_removeNamed:function(){var t=this._getOwner();if(t){var e=t._children,n=t._namedChildren,i=this._name,r=n[i],s=r?r.indexOf(this):-1;s!==-1&&(e[i]==this&&delete e[i],r.splice(s,1),r.length?e[i]=r[0]:delete n[i])}},_remove:function(t,e){var n=this._getOwner(),i=this._project,s=this._index;return this._style&&this._style._dispose(),!!n&&(this._name&&this._removeNamed(),null!=s&&(i._activeLayer===this&&(i._activeLayer=this.getNextSibling()||this.getPreviousSibling()),r.splice(n._children,null,s,1)),this._installEvents(!1),t&&i._changes&&this._changed(5),e&&n._changed(11,this),this._parent=null,!0)},remove:function(){return this._remove(!0,!0)},replaceWith:function(t){var e=t&&t.insertBelow(this);return e&&this.remove(),e},removeChildren:function(t,e){if(!this._children)return null;t=t||0,e=r.pick(e,this._children.length);for(var n=r.splice(this._children,null,t,e-t),i=n.length-1;i>=0;i--)n[i]._remove(!0,!1);return n.length>0&&this._changed(11),n},clear:"#removeChildren",reverseChildren:function(){if(this._children){this._children.reverse();for(var t=0,e=this._children.length;t<e;t++)this._children[t]._index=t;this._changed(11)}},isEmpty:function(){var t=this._children;return!t||!t.length},isEditable:function(){for(var t=this;t;){if(!t._visible||t._locked)return!1;t=t._parent}return!0},hasFill:function(){return this.getStyle().hasFill()},hasStroke:function(){return this.getStyle().hasStroke()},hasShadow:function(){return this.getStyle().hasShadow()},_getOrder:function(t){function e(t){var e=[];do e.unshift(t);while(t=t._parent);return e}for(var n=e(this),i=e(t),r=0,s=Math.min(n.length,i.length);r<s;r++)if(n[r]!=i[r])return n[r]._index<i[r]._index?1:-1;return 0},hasChildren:function(){return this._children&&this._children.length>0},isInserted:function(){return!!this._parent&&this._parent.isInserted()},isAbove:function(t){return this._getOrder(t)===-1},isBelow:function(t){return 1===this._getOrder(t)},isParent:function(t){return this._parent===t},isChild:function(t){return t&&t._parent===this},isDescendant:function(t){for(var e=this;e=e._parent;)if(e===t)return!0;return!1},isAncestor:function(t){return!!t&&t.isDescendant(this)},isSibling:function(t){return this._parent===t._parent},isGroupedWith:function(t){for(var e=this._parent;e;){if(e._parent&&/^(Group|Layer|CompoundPath)$/.test(e._class)&&t.isDescendant(e))return!0;e=e._parent}return!1}},r.each(["rotate","scale","shear","skew"],function(t){var e="rotate"===t;this[t]=function(){var n=(e?r:c).read(arguments),i=c.read(arguments,0,{readNull:!0});return this.transform((new p)[t](n,i||this.getPosition(!0)))}},{translate:function(){var t=new p;return this.transform(t.translate.apply(t,arguments))},transform:function(t,e,n,i){var r=this._matrix,s=t&&!t.isIdentity(),a=(e||this._applyMatrix)&&(!r.isIdentity()||s||e&&n&&this._children);if(!s&&!a)return this;if(s){!t.isInvertible()&&r.isInvertible()&&(r._backup=r.getValues()),r.prepend(t,!0);var o=this._style,h=o.getFillColor(!0),u=o.getStrokeColor(!0);h&&h.transform(t),u&&u.transform(t)}if(a&&(a=this._transformContent(r,n,i))){var l=this._pivot;l&&r._transformPoint(l,l,!0),r.reset(!0),i&&this._canApplyMatrix&&(this._applyMatrix=!0)}var c=this._bounds,f=this._position;(s||a)&&this._changed(25);var d=s&&c&&t.decompose();if(d&&d.skewing.isZero()&&d.rotation%90===0){for(var _ in c){var g=c[_];if(g.nonscaling)delete c[_];else if(a||!g.internal){var v=g.rect;t._transformBounds(v,v)}}this._bounds=c;var p=c[this._getBoundsCacheKey(this._boundsOptions||{})];p&&(this._position=this._getPositionFromBounds(p.rect))}else s&&f&&this._pivot&&(this._position=t._transformPoint(f,f));return this},_transformContent:function(t,e,n){var i=this._children;if(i){for(var r=0,s=i.length;r<s;r++)i[r].transform(t,!0,e,n);return!0}},globalToLocal:function(){return this.getGlobalMatrix(!0)._inverseTransform(c.read(arguments))},localToGlobal:function(){return this.getGlobalMatrix(!0)._transformPoint(c.read(arguments))},parentToLocal:function(){return this._matrix._inverseTransform(c.read(arguments))},localToParent:function(){return this._matrix._transformPoint(c.read(arguments))},fitBounds:function(t,e){t=g.read(arguments);var n=this.getBounds(),i=n.height/n.width,r=t.height/t.width,s=(e?i>r:i<r)?t.width/n.width:t.height/n.height,a=new g(new c,new d(n.width*s,n.height*s));a.setCenter(t.getCenter()),this.setBounds(a)}}),{_setStyles:function(t,e,n){var i=this._style,r=this._matrix;if(i.hasFill()&&(t.fillStyle=i.getFillColor().toCanvasStyle(t,r)),i.hasStroke()){t.strokeStyle=i.getStrokeColor().toCanvasStyle(t,r),t.lineWidth=i.getStrokeWidth();var s=i.getStrokeJoin(),a=i.getStrokeCap(),o=i.getMiterLimit();if(s&&(t.lineJoin=s),a&&(t.lineCap=a),o&&(t.miterLimit=o),st.support.nativeDash){var h=i.getDashArray(),u=i.getDashOffset();h&&h.length&&("setLineDash"in t?(t.setLineDash(h),t.lineDashOffset=u):(t.mozDash=h,t.mozDashOffset=u))}}if(i.hasShadow()){var l=e.pixelRatio||1,f=n._shiftless().prepend((new p).scale(l,l)),d=f.transform(new c(i.getShadowBlur(),0)),_=f.transform(this.getShadowOffset());t.shadowColor=i.getShadowColor().toCanvasStyle(t),t.shadowBlur=d.getLength(),t.shadowOffsetX=_.x,t.shadowOffsetY=_.y}},draw:function(t,e,n){this._updateVersion=this._project._updateVersion;if(this._visible&&0!==this._opacity){var i=e.matrices,r=e.viewMatrix,s=this._matrix,a=i[i.length-1].appended(s);if(a.isInvertible()){r=r?r.appended(a):a,i.push(a),e.updateMatrix&&(this._globalMatrix=a);var o,h,u,l=this._blendMode,c=this._opacity,f="normal"===l,d=nt.nativeModes[l],_=f&&1===c||e.dontStart||e.clip||(d||f&&c<1)&&this._canComposite(),g=e.pixelRatio||1;if(!_){var v=this.getStrokeBounds(r);if(!v.width||!v.height)return void i.pop();u=e.offset,h=e.offset=v.getTopLeft().floor(),o=t,t=et.getContext(v.getSize().ceil().add(1).multiply(g)),1!==g&&t.scale(g,g)}t.save();
var p=n?n.appended(s):this._canScaleStroke&&!this.getStrokeScaling(!0)&&r,m=!_&&e.clipItem,y=!p||m;if(_?(t.globalAlpha=c,d&&(t.globalCompositeOperation=l)):y&&t.translate(-h.x,-h.y),y&&(_?s:r).applyToContext(t),m&&e.clipItem.draw(t,e.extend({clip:!0})),p){t.setTransform(g,0,0,g,0,0);var w=e.offset;w&&t.translate(-w.x,-w.y)}this._draw(t,e,r,p),t.restore(),i.pop(),e.clip&&!e.dontFinish&&t.clip(),_||(nt.process(l,t,o,c,h.subtract(u).multiply(g)),et.release(t),e.offset=u)}}},_isUpdated:function(t){var e=this._parent;if(e instanceof E)return e._isUpdated(t);var n=this._updateVersion===t;return!n&&e&&e._visible&&e._isUpdated(t)&&(this._updateVersion=t,n=!0),n},_drawSelection:function(t,e,n,i,r){var s=this._selection,a=1&s,o=2&s||a&&this._selectBounds,h=4&s;if(this._drawSelected||(a=!1),(a||o||h)&&this._isUpdated(r)){var u,l=this.getSelectedColor(!0)||(u=this.getLayer())&&u.getSelectedColor(!0),c=e.appended(this.getGlobalMatrix(!0)),f=n/2;if(t.strokeStyle=t.fillStyle=l?l.toCanvasStyle(t):"#009dec",a&&this._drawSelected(t,c,i),h){var d=this.getPosition(!0),_=this._parent,g=_?_.localToGlobal(d):d,v=g.x,p=g.y;t.beginPath(),t.arc(v,p,f,0,2*Math.PI,!0),t.stroke();for(var m=[[0,-1],[1,0],[0,1],[-1,0]],y=f,w=n+1,x=0;x<4;x++){var b=m[x],C=b[0],S=b[1];t.moveTo(v+C*y,p+S*y),t.lineTo(v+C*w,p+S*w),t.stroke()}}if(o){var k=c._transformCorners(this.getInternalBounds());t.beginPath();for(var x=0;x<8;x++)t[x?"lineTo":"moveTo"](k[x],k[++x]);t.closePath(),t.stroke();for(var x=0;x<8;x++)t.fillRect(k[x]-f,k[++x]-f,n,n)}}},_canComposite:function(){return!1}},r.each(["down","drag","up","move"],function(t){this["removeOn"+r.capitalize(t)]=function(){var e={};return e[t]=!0,this.removeOn(e)}},{removeOn:function(t){for(var e in t)if(t[e]){var n="mouse"+e,i=this._project,r=i._removeSets=i._removeSets||{};r[n]=r[n]||{},r[n][this._id]=this}return this}}),{tween:function(t,e,n){function i(t){o._handleFrame(1e3*t.time),o.running||this.off("frame",i)}n||(n=e,e=t,t=null,n||(n=e,e=null));var r=n&&n.easing,s=n&&n.start,a=null!=n&&("number"==typeof n?n:n.duration),o=new Y(this,t,e,a,r,s);return a&&this.on("frame",i),o},tweenTo:function(t,e){return this.tween(null,t,e)},tweenFrom:function(t,e){return this.tween(t,null,e)}}),x=w.extend({_class:"Group",_selectBounds:!1,_selectChildren:!0,_serializeFields:{children:[]},initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||this.addChildren(Array.isArray(t)?t:arguments)},_changed:function _t(t){_t.base.call(this,t),2050&t&&(this._clipItem=e)},_getClipItem:function(){var t=this._clipItem;if(t===e){t=null;for(var n=this._children,i=0,r=n.length;i<r;i++)if(n[i]._clipMask){t=n[i];break}this._clipItem=t}return t},isClipped:function(){return!!this._getClipItem()},setClipped:function(t){var e=this.getFirstChild();e&&e.setClipMask(t)},_getBounds:function gt(t,e){var n=this._getClipItem();return n?n._getCachedBounds(t&&t.appended(n._matrix),r.set({},e,{stroke:!1})):gt.base.call(this,t,e)},_hitTestChildren:function vt(t,e,n){var i=this._getClipItem();return(!i||i.contains(t))&&vt.base.call(this,t,e,n,i)},_draw:function(t,e){var n=e.clip,i=!n&&this._getClipItem();e=e.extend({clipItem:i,clip:!1}),n?(t.beginPath(),e.dontStart=e.dontFinish=!0):i&&i.draw(t,e.extend({clip:!0}));for(var r=this._children,s=0,a=r.length;s<a;s++){var o=r[s];o!==i&&o.draw(t,e)}}}),b=x.extend({_class:"Layer",initialize:function(){x.apply(this,arguments)},_getOwner:function(){return this._parent||null!=this._index&&this._project},isInserted:function pt(){return this._parent?pt.base.call(this):null!=this._index},activate:function(){this._project._activeLayer=this},_hitTestSelf:function(){}}),C=w.extend({_class:"Shape",_applyMatrix:!1,_canApplyMatrix:!1,_canScaleStroke:!0,_serializeFields:{type:null,size:null,radius:null},initialize:function(t,e){this._initialize(t,e)},_equals:function(t){return this._type===t._type&&this._size.equals(t._size)&&r.equals(this._radius,t._radius)},copyContent:function(t){this.setType(t._type),this.setSize(t._size),this.setRadius(t._radius)},getType:function(){return this._type},setType:function(t){this._type=t},getShape:"#getType",setShape:"#setType",getSize:function(){var t=this._size;return new _(t.width,t.height,this,"setSize")},setSize:function(){var t=d.read(arguments);if(this._size){if(!this._size.equals(t)){var e=this._type,n=t.width,i=t.height;"rectangle"===e?this._radius.set(d.min(this._radius,t.divide(2))):"circle"===e?(n=i=(n+i)/2,this._radius=n/2):"ellipse"===e&&this._radius._set(n/2,i/2),this._size._set(n,i),this._changed(9)}}else this._size=t.clone()},getRadius:function(){var t=this._radius;return"circle"===this._type?t:new _(t.width,t.height,this,"setRadius")},setRadius:function(t){var e=this._type;if("circle"===e){if(t===this._radius)return;var n=2*t;this._radius=t,this._size._set(n,n)}else if(t=d.read(arguments),this._radius){if(this._radius.equals(t))return;if(this._radius.set(t),"rectangle"===e){var n=d.max(this._size,t.multiply(2));this._size.set(n)}else"ellipse"===e&&this._size._set(2*t.width,2*t.height)}else this._radius=t.clone();this._changed(9)},isEmpty:function(){return!1},toPath:function(t){var n=new(L[r.capitalize(this._type)])({center:new c,size:this._size,radius:this._radius,insert:!1});return n.copyAttributes(this),st.settings.applyMatrix&&n.setApplyMatrix(!0),(t===e||t)&&n.insertAbove(this),n},toShape:"#clone",_asPathItem:function(){return this.toPath(!1)},_draw:function(t,e,n,i){var r=this._style,s=r.hasFill(),a=r.hasStroke(),o=e.dontFinish||e.clip,h=!i;if(s||a||o){var u=this._type,l=this._radius,c="circle"===u;if(e.dontStart||t.beginPath(),h&&c)t.arc(0,0,l,0,2*Math.PI,!0);else{var f=c?l:l.width,d=c?l:l.height,_=this._size,g=_.width,v=_.height;if(h&&"rectangle"===u&&0===f&&0===d)t.rect(-g/2,-v/2,g,v);else{var p=g/2,m=v/2,y=.44771525016920644,w=f*y,x=d*y,b=[-p,-m+d,-p,-m+x,-p+w,-m,-p+f,-m,p-f,-m,p-w,-m,p,-m+x,p,-m+d,p,m-d,p,m-x,p-w,m,p-f,m,-p+f,m,-p+w,m,-p,m-x,-p,m-d];i&&i.transform(b,b,32),t.moveTo(b[0],b[1]),t.bezierCurveTo(b[2],b[3],b[4],b[5],b[6],b[7]),p!==f&&t.lineTo(b[8],b[9]),t.bezierCurveTo(b[10],b[11],b[12],b[13],b[14],b[15]),m!==d&&t.lineTo(b[16],b[17]),t.bezierCurveTo(b[18],b[19],b[20],b[21],b[22],b[23]),p!==f&&t.lineTo(b[24],b[25]),t.bezierCurveTo(b[26],b[27],b[28],b[29],b[30],b[31])}}t.closePath()}o||!s&&!a||(this._setStyles(t,e,n),s&&(t.fill(r.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),a&&t.stroke())},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_getBounds:function(t,e){var n=new g(this._size).setCenter(0,0),i=this._style,r=e.stroke&&i.hasStroke()&&i.getStrokeWidth();return t&&(n=t._transformBounds(n)),r?n.expand(L._getStrokePadding(r,this._getStrokeMatrix(t,e))):n}},new function(){function t(t,e,n){var i=t._radius;if(!i.isZero())for(var r=t._size.divide(2),s=1;s<=4;s++){var a=new c(s>1&&s<4?-1:1,s>2?-1:1),o=a.multiply(r),h=o.subtract(a.multiply(i)),u=new g(n?o.add(a.multiply(n)):o,h);if(u.contains(e))return{point:h,quadrant:s}}}function e(t,e,n,i){var r=t.divide(e);return(!i||r.isInQuadrant(i))&&r.subtract(r.normalize()).multiply(e).divide(n).length<=1}return{_contains:function n(e){if("rectangle"===this._type){var i=t(this,e);return i?e.subtract(i.point).divide(this._radius).getLength()<=1:n.base.call(this,e)}return e.divide(this.size).getLength()<=.5},_hitTestSelf:function i(n,r,s,a){var o=!1,h=this._style,u=r.stroke&&h.hasStroke(),l=r.fill&&h.hasFill();if(u||l){var c=this._type,f=this._radius,d=u?h.getStrokeWidth()/2:0,_=r._tolerancePadding.add(L._getStrokePadding(d,!h.getStrokeScaling()&&a));if("rectangle"===c){var v=_.multiply(2),p=t(this,n,v);if(p)o=e(n.subtract(p.point),f,_,p.quadrant);else{var m=new g(this._size).setCenter(0,0),y=m.expand(v),w=m.expand(v.negate());o=y._containsPoint(n)&&!w._containsPoint(n)}}else o=e(n,f,_)}return o?new P(u?"stroke":"fill",this):i.base.apply(this,arguments)}}},{statics:new function(){function t(t,e,n,i,s){var a=new C(r.getNamed(s),e);return a._type=t,a._size=n,a._radius=i,a}return{Circle:function(){var e=c.readNamed(arguments,"center"),n=r.readNamed(arguments,"radius");return t("circle",e,new d(2*n),n,arguments)},Rectangle:function(){var e=g.readNamed(arguments,"rectangle"),n=d.min(d.readNamed(arguments,"radius"),e.getSize(!0).divide(2));return t("rectangle",e.getCenter(!0),e.getSize(!0),n,arguments)},Ellipse:function(){var e=C._readEllipse(arguments),n=e.radius;return t("ellipse",e.center,n.multiply(2),n,arguments)},_readEllipse:function(t){var e,n;if(r.hasNamed(t,"radius"))e=c.readNamed(t,"center"),n=d.readNamed(t,"radius");else{var i=g.readNamed(t,"rectangle");e=i.getCenter(!0),n=i.getSize(!0).divide(2)}return{center:e,radius:n}}}}}),S=w.extend({_class:"Raster",_applyMatrix:!1,_canApplyMatrix:!1,_boundsOptions:{stroke:!1,handle:!1},_serializeFields:{crossOrigin:null,source:null},_prioritize:["crossOrigin"],_smoothing:!0,initialize:function(t,n){if(!this._initialize(t,n!==e&&c.read(arguments,1))){var r="string"==typeof t?i.getElementById(t):t;r?this.setImage(r):this.setSource(t)}this._size||(this._size=new d,this._loaded=!1)},_equals:function(t){return this.getSource()===t.getSource()},copyContent:function(t){var e=t._image,n=t._canvas;if(e)this._setImage(e);else if(n){var i=et.getCanvas(t._size);i.getContext("2d").drawImage(n,0,0),this._setImage(i)}this._crossOrigin=t._crossOrigin},getSize:function(){var t=this._size;return new _(t?t.width:0,t?t.height:0,this,"setSize")},setSize:function(){var t=d.read(arguments);if(!t.equals(this._size))if(t.width>0&&t.height>0){var e=this.getElement();this._setImage(et.getCanvas(t)),e&&this.getContext(!0).drawImage(e,0,0,t.width,t.height)}else this._canvas&&et.release(this._canvas),this._size=t.clone()},getWidth:function(){return this._size?this._size.width:0},setWidth:function(t){this.setSize(t,this.getHeight())},getHeight:function(){return this._size?this._size.height:0},setHeight:function(t){this.setSize(this.getWidth(),t)},getLoaded:function(){return this._loaded},isEmpty:function(){var t=this._size;return!t||0===t.width&&0===t.height},getResolution:function(){var t=this._matrix,e=new c(0,0).transform(t),n=new c(1,0).transform(t).subtract(e),i=new c(0,1).transform(t).subtract(e);return new d(72/n.getLength(),72/i.getLength())},getPpi:"#getResolution",getImage:function(){return this._image},setImage:function(t){function e(t){var e=n.getView(),i=t&&t.type||"load";e&&n.responds(i)&&(st=e._scope,n.emit(i,new $(t)))}var n=this;this._setImage(t),this._loaded?setTimeout(e,0):t&&H.add(t,{load:function(i){n._setImage(t),e(i)},error:e})},_setImage:function(t){this._canvas&&et.release(this._canvas),t&&t.getContext?(this._image=null,this._canvas=t,this._loaded=!0):(this._image=t,this._canvas=null,this._loaded=!!(t&&t.src&&t.complete)),this._size=new d(t?t.naturalWidth||t.width:0,t?t.naturalHeight||t.height:0),this._context=null,this._changed(1033)},getCanvas:function(){if(!this._canvas){var t=et.getContext(this._size);try{this._image&&t.drawImage(this._image,0,0),this._canvas=t.canvas}catch(e){et.release(t)}}return this._canvas},setCanvas:"#setImage",getContext:function(t){return this._context||(this._context=this.getCanvas().getContext("2d")),t&&(this._image=null,this._changed(1025)),this._context},setContext:function(t){this._context=t},getSource:function(){var t=this._image;return t&&t.src||this.toDataURL()},setSource:function(e){var n=new t.Image,i=this._crossOrigin;i&&(n.crossOrigin=i),n.src=e,this.setImage(n)},getCrossOrigin:function(){var t=this._image;return t&&t.crossOrigin||this._crossOrigin||""},setCrossOrigin:function(t){this._crossOrigin=t;var e=this._image;e&&(e.crossOrigin=t)},getSmoothing:function(){return this._smoothing},setSmoothing:function(t){this._smoothing=t,this._changed(257)},getElement:function(){return this._canvas||this._loaded&&this._image}},{beans:!1,getSubCanvas:function(){var t=g.read(arguments),e=et.getContext(t.getSize());return e.drawImage(this.getCanvas(),t.x,t.y,t.width,t.height,0,0,t.width,t.height),e.canvas},getSubRaster:function(){var t=g.read(arguments),e=new S(w.NO_INSERT);return e._setImage(this.getSubCanvas(t)),e.translate(t.getCenter().subtract(this.getSize().divide(2))),e._matrix.prepend(this._matrix),e.insertAbove(this),e},toDataURL:function(){var t=this._image,e=t&&t.src;if(/^data:/.test(e))return e;var n=this.getCanvas();return n?n.toDataURL.apply(n,arguments):null},drawImage:function(t){var e=c.read(arguments,1);this.getContext(!0).drawImage(t,e.x,e.y)},getAverageColor:function(t){var e,n;if(t?t instanceof z?(n=t,e=t.getBounds()):"object"==typeof t&&("width"in t?e=new g(t):"x"in t&&(e=new g(t.x-.5,t.y-.5,1,1))):e=this.getBounds(),!e)return null;var i=32,s=Math.min(e.width,i),a=Math.min(e.height,i),o=S._sampleContext;o?o.clearRect(0,0,i+1,i+1):o=S._sampleContext=et.getContext(new d(i)),o.save();var h=(new p).scale(s/e.width,a/e.height).translate(-e.x,-e.y);h.applyToContext(o),n&&n.draw(o,new r({clip:!0,matrices:[h]})),this._matrix.applyToContext(o);var u=this.getElement(),l=this._size;u&&o.drawImage(u,-l.width/2,-l.height/2),o.restore();for(var c=o.getImageData(.5,.5,Math.ceil(s),Math.ceil(a)).data,f=[0,0,0],_=0,v=0,m=c.length;v<m;v+=4){var y=c[v+3];_+=y,y/=255,f[0]+=c[v]*y,f[1]+=c[v+1]*y,f[2]+=c[v+2]*y}for(var v=0;v<3;v++)f[v]/=_;return _?D.read(f):null},getPixel:function(){var t=c.read(arguments),e=this.getContext().getImageData(t.x,t.y,1,1).data;return new D("rgb",[e[0]/255,e[1]/255,e[2]/255],e[3]/255)},setPixel:function(){var t=c.read(arguments),e=D.read(arguments),n=e._convert("rgb"),i=e._alpha,r=this.getContext(!0),s=r.createImageData(1,1),a=s.data;a[0]=255*n[0],a[1]=255*n[1],a[2]=255*n[2],a[3]=null!=i?255*i:255,r.putImageData(s,t.x,t.y)},createImageData:function(){var t=d.read(arguments);return this.getContext().createImageData(t.width,t.height)},getImageData:function(){var t=g.read(arguments);return t.isEmpty()&&(t=new g(this._size)),this.getContext().getImageData(t.x,t.y,t.width,t.height)},setImageData:function(t){var e=c.read(arguments,1);this.getContext(!0).putImageData(t,e.x,e.y)},_getBounds:function(t,e){var n=new g(this._size).setCenter(0,0);return t?t._transformBounds(n):n},_hitTestSelf:function(t){if(this._contains(t)){var e=this;return new P("pixel",e,{offset:t.add(e._size.divide(2)).round(),color:{get:function(){return e.getPixel(this.offset)}}})}},_draw:function(t,e,n){var i=this.getElement();i&&i.width>0&&i.height>0&&(t.globalAlpha=this._opacity,this._setStyles(t,e,n),U.setPrefixed(t,"imageSmoothingEnabled",this._smoothing),t.drawImage(i,-this._size.width/2,-this._size.height/2))},_canComposite:function(){return!0}}),k=w.extend({_class:"SymbolItem",_applyMatrix:!1,_canApplyMatrix:!1,_boundsOptions:{stroke:!0},_serializeFields:{symbol:null},initialize:function(t,n){this._initialize(t,n!==e&&c.read(arguments,1))||this.setDefinition(t instanceof I?t:new I(t))},_equals:function(t){return this._definition===t._definition},copyContent:function(t){this.setDefinition(t._definition)},getDefinition:function(){return this._definition},setDefinition:function(t){this._definition=t,this._changed(9)},getSymbol:"#getDefinition",setSymbol:"#setDefinition",isEmpty:function(){return this._definition._item.isEmpty()},_getBounds:function(t,e){var n=this._definition._item;return n._getCachedBounds(n._matrix.prepended(t),e)},_hitTestSelf:function(t,e,n){var i=this._definition._item._hitTest(t,e,n);return i&&(i.item=this),i},_draw:function(t,e){this._definition._item.draw(t,e)}}),I=r.extend({_class:"SymbolDefinition",initialize:function(t,e){this._id=l.get(),this.project=st.project,t&&this.setItem(t,e)},_serialize:function(t,e){return e.add(this,function(){return r.serialize([this._class,this._item],t,!1,e)})},_changed:function(t){8&t&&w._clearBoundsCache(this),1&t&&this.project._changed(t)},getItem:function(){return this._item},setItem:function(t,e){t._symbol&&(t=t.clone()),this._item&&(this._item._symbol=null),this._item=t,t.remove(),t.setSelected(!1),e||t.setPosition(new c),t._symbol=this,this._changed(9)},getDefinition:"#getItem",setDefinition:"#setItem",place:function(t){return new k(this,t)},clone:function(){return new I(this._item.clone(!1))},equals:function(t){return t===this||t&&this._item.equals(t._item)||!1}}),P=r.extend({_class:"HitResult",initialize:function(t,e,n){this.type=t,this.item=e,n&&this.inject(n)},statics:{getOptions:function(t){var e=t&&r.read(t);return r.set({type:null,tolerance:st.settings.hitTolerance,fill:!e,stroke:!e,segments:!e,handles:!1,ends:!1,position:!1,center:!1,bounds:!1,guides:!1,selected:!1},e)}}}),T=r.extend({_class:"Segment",beans:!0,_selection:0,initialize:function(t,n,i,r,s,a){var o,h,u,l,c=arguments.length;c>0&&(null==t||"object"==typeof t?1===c&&t&&"point"in t?(o=t.point,h=t.handleIn,u=t.handleOut,l=t.selection):(o=t,h=n,u=i,l=r):(o=[t,n],h=i!==e?[i,r]:null,u=s!==e?[s,a]:null)),new M(o,this,"_point"),new M(h,this,"_handleIn"),new M(u,this,"_handleOut"),l&&this.setSelection(l)},_serialize:function(t,e){var n=this._point,i=this._selection,s=i||this.hasHandles()?[n,this._handleIn,this._handleOut]:n;return i&&s.push(i),r.serialize(s,t,!0,e)},_changed:function(t){var e=this._path;if(e){var n,i=e._curves,r=this._index;i&&(t&&t!==this._point&&t!==this._handleIn||!(n=r>0?i[r-1]:e._closed?i[i.length-1]:null)||n._changed(),t&&t!==this._point&&t!==this._handleOut||!(n=i[r])||n._changed()),e._changed(41)}},getPoint:function(){return this._point},setPoint:function(){this._point.set(c.read(arguments))},getHandleIn:function(){return this._handleIn},setHandleIn:function(){this._handleIn.set(c.read(arguments))},getHandleOut:function(){return this._handleOut},setHandleOut:function(){this._handleOut.set(c.read(arguments))},hasHandles:function(){return!this._handleIn.isZero()||!this._handleOut.isZero()},isSmooth:function(){var t=this._handleIn,e=this._handleOut;return!t.isZero()&&!e.isZero()&&t.isCollinear(e)},clearHandles:function(){this._handleIn._set(0,0),this._handleOut._set(0,0)},getSelection:function(){return this._selection},setSelection:function(t){var e=this._selection,n=this._path;this._selection=t=t||0,n&&t!==e&&(n._updateSelection(this,e,t),n._changed(257))},_changeSelection:function(t,e){var n=this._selection;this.setSelection(e?n|t:n&~t)},isSelected:function(){return!!(7&this._selection)},setSelected:function(t){this._changeSelection(7,t)},getIndex:function(){return this._index!==e?this._index:null},getPath:function(){return this._path||null},getCurve:function(){var t=this._path,e=this._index;return t?(e>0&&!t._closed&&e===t._segments.length-1&&e--,t.getCurves()[e]||null):null},getLocation:function(){var t=this.getCurve();return t?new O(t,this===t._segment1?0:1):null},getNext:function(){var t=this._path&&this._path._segments;return t&&(t[this._index+1]||this._path._closed&&t[0])||null},smooth:function(t,n,i){var r=t||{},s=r.type,a=r.factor,o=this.getPrevious(),h=this.getNext(),u=(o||this)._point,l=this._point,f=(h||this)._point,d=u.getDistance(l),_=l.getDistance(f);if(s&&"catmull-rom"!==s){if("geometric"!==s)throw new Error("Smoothing method '"+s+"' not supported.");if(o&&h){var g=u.subtract(f),v=a===e?.4:a,p=v*d/(d+_);n||this.setHandleIn(g.multiply(p)),i||this.setHandleOut(g.multiply(p-v))}}else{var m=a===e?.5:a,y=Math.pow(d,m),w=y*y,x=Math.pow(_,m),b=x*x;if(!n&&o){var C=2*b+3*x*y+w,S=3*x*(x+y);this.setHandleIn(0!==S?new c((b*u._x+C*l._x-w*f._x)/S-l._x,(b*u._y+C*l._y-w*f._y)/S-l._y):new c)}if(!i&&h){var C=2*w+3*y*x+b,S=3*y*(y+x);this.setHandleOut(0!==S?new c((w*f._x+C*l._x-b*u._x)/S-l._x,(w*f._y+C*l._y-b*u._y)/S-l._y):new c)}}},getPrevious:function(){var t=this._path&&this._path._segments;return t&&(t[this._index-1]||this._path._closed&&t[t.length-1])||null},isFirst:function(){return!this._index},isLast:function(){var t=this._path;return t&&this._index===t._segments.length-1||!1},reverse:function(){var t=this._handleIn,e=this._handleOut,n=t.clone();t.set(e),e.set(n)},reversed:function(){return new T(this._point,this._handleOut,this._handleIn)},remove:function(){return!!this._path&&!!this._path.removeSegment(this._index)},clone:function(){return new T(this._point,this._handleIn,this._handleOut)},equals:function(t){return t===this||t&&this._class===t._class&&this._point.equals(t._point)&&this._handleIn.equals(t._handleIn)&&this._handleOut.equals(t._handleOut)||!1},toString:function(){var t=["point: "+this._point];return this._handleIn.isZero()||t.push("handleIn: "+this._handleIn),this._handleOut.isZero()||t.push("handleOut: "+this._handleOut),"{ "+t.join(", ")+" }"},transform:function(t){this._transformCoordinates(t,new Array(6),!0),this._changed()},interpolate:function(t,e,n){var i=1-n,r=n,s=t._point,a=e._point,o=t._handleIn,h=e._handleIn,u=e._handleOut,l=t._handleOut;this._point._set(i*s._x+r*a._x,i*s._y+r*a._y,!0),this._handleIn._set(i*o._x+r*h._x,i*o._y+r*h._y,!0),this._handleOut._set(i*l._x+r*u._x,i*l._y+r*u._y,!0),this._changed()},_transformCoordinates:function(t,e,n){var i=this._point,r=n&&this._handleIn.isZero()?null:this._handleIn,s=n&&this._handleOut.isZero()?null:this._handleOut,a=i._x,o=i._y,h=2;return e[0]=a,e[1]=o,r&&(e[h++]=r._x+a,e[h++]=r._y+o),s&&(e[h++]=s._x+a,e[h++]=s._y+o),t&&(t._transformCoordinates(e,e,h/2),a=e[0],o=e[1],n?(i._x=a,i._y=o,h=2,r&&(r._x=e[h++]-a,r._y=e[h++]-o),s&&(s._x=e[h++]-a,s._y=e[h++]-o)):(r||(e[h++]=a,e[h++]=o),s||(e[h++]=a,e[h++]=o))),e}}),M=c.extend({initialize:function(t,n,i){var r,s,a;if(t)if((r=t[0])!==e)s=t[1];else{var o=t;(r=o.x)===e&&(o=c.read(arguments),r=o.x),s=o.y,a=o.selected}else r=s=0;this._x=r,this._y=s,this._owner=n,n[i]=this,a&&this.setSelected(!0)},_set:function(t,e){return this._x=t,this._y=e,this._owner._changed(this),this},getX:function(){return this._x},setX:function(t){this._x=t,this._owner._changed(this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner._changed(this)},isZero:function(){var t=u.isZero;return t(this._x)&&t(this._y)},isSelected:function(){return!!(this._owner._selection&this._getSelection())},setSelected:function(t){this._owner._changeSelection(this._getSelection(),t)},_getSelection:function(){var t=this._owner;return this===t._point?1:this===t._handleIn?2:this===t._handleOut?4:0}}),A=r.extend({_class:"Curve",beans:!0,initialize:function(t,e,n,i,r,s,a,o){var h,u,l,c,f,d,_=arguments.length;3===_?(this._path=t,h=e,u=n):_?1===_?"segment1"in t?(h=new T(t.segment1),u=new T(t.segment2)):"point1"in t?(l=t.point1,f=t.handle1,d=t.handle2,c=t.point2):Array.isArray(t)&&(l=[t[0],t[1]],c=[t[6],t[7]],f=[t[2]-t[0],t[3]-t[1]],d=[t[4]-t[6],t[5]-t[7]]):2===_?(h=new T(t),u=new T(e)):4===_?(l=t,f=e,d=n,c=i):8===_&&(l=[t,e],c=[a,o],f=[n-t,i-e],d=[r-a,s-o]):(h=new T,u=new T),this._segment1=h||new T(l,null,f),this._segment2=u||new T(c,d,null)},_serialize:function(t,e){return r.serialize(this.hasHandles()?[this.getPoint1(),this.getHandle1(),this.getHandle2(),this.getPoint2()]:[this.getPoint1(),this.getPoint2()],t,!0,e)},_changed:function(){this._length=this._bounds=e},clone:function(){return new A(this._segment1,this._segment2)},toString:function(){var t=["point1: "+this._segment1._point];return this._segment1._handleOut.isZero()||t.push("handle1: "+this._segment1._handleOut),this._segment2._handleIn.isZero()||t.push("handle2: "+this._segment2._handleIn),t.push("point2: "+this._segment2._point),"{ "+t.join(", ")+" }"},classify:function(){return A.classify(this.getValues())},remove:function(){var t=!1;if(this._path){var e=this._segment2,n=e._handleOut;t=e.remove(),t&&this._segment1._handleOut.set(n)}return t},getPoint1:function(){return this._segment1._point},setPoint1:function(){this._segment1._point.set(c.read(arguments))},getPoint2:function(){return this._segment2._point},setPoint2:function(){this._segment2._point.set(c.read(arguments))},getHandle1:function(){return this._segment1._handleOut},setHandle1:function(){this._segment1._handleOut.set(c.read(arguments))},getHandle2:function(){return this._segment2._handleIn},setHandle2:function(){this._segment2._handleIn.set(c.read(arguments))},getSegment1:function(){return this._segment1},getSegment2:function(){return this._segment2},getPath:function(){return this._path},getIndex:function(){return this._segment1._index},getNext:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index+1]||this._path._closed&&t[0])||null},getPrevious:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index-1]||this._path._closed&&t[t.length-1])||null},isFirst:function(){return!this._segment1._index},isLast:function(){var t=this._path;return t&&this._segment1._index===t._curves.length-1||!1},isSelected:function(){return this.getPoint1().isSelected()&&this.getHandle1().isSelected()&&this.getHandle2().isSelected()&&this.getPoint2().isSelected()},setSelected:function(t){this.getPoint1().setSelected(t),this.getHandle1().setSelected(t),this.getHandle2().setSelected(t),this.getPoint2().setSelected(t)},getValues:function(t){return A.getValues(this._segment1,this._segment2,t)},getPoints:function(){for(var t=this.getValues(),e=[],n=0;n<8;n+=2)e.push(new c(t[n],t[n+1]));return e}},{getLength:function(){return null==this._length&&(this._length=A.getLength(this.getValues(),0,1)),this._length},getArea:function(){return A.getArea(this.getValues())},getLine:function(){return new m(this._segment1._point,this._segment2._point)},getPart:function(t,e){return new A(A.getPart(this.getValues(),t,e))},getPartLength:function(t,e){return A.getLength(this.getValues(),t,e)},divideAt:function(t){return this.divideAtTime(t&&t.curve===this?t.time:this.getTimeAt(t))},divideAtTime:function(t,e){var n=1e-8,i=1-n,r=null;if(t>=n&&t<=i){var s=A.subdivide(this.getValues(),t),a=s[0],o=s[1],h=e||this.hasHandles(),u=this._segment1,l=this._segment2,f=this._path;h&&(u._handleOut._set(a[2]-a[0],a[3]-a[1]),l._handleIn._set(o[4]-o[6],o[5]-o[7]));var d=a[6],_=a[7],g=new T(new c(d,_),h&&new c(a[4]-d,a[5]-_),h&&new c(o[2]-d,o[3]-_));f?(f.insert(u._index+1,g),r=this.getNext()):(this._segment2=g,this._changed(),r=new A(g,l))}return r},splitAt:function(t){var e=this._path;return e?e.splitAt(t):null},splitAtTime:function(t){return this.splitAt(this.getLocationAtTime(t))},divide:function(t,n){return this.divideAtTime(t===e?.5:n?t:this.getTimeAt(t))},split:function(t,n){return this.splitAtTime(t===e?.5:n?t:this.getTimeAt(t))},reversed:function(){return new A(this._segment2.reversed(),this._segment1.reversed())},clearHandles:function(){this._segment1._handleOut._set(0,0),this._segment2._handleIn._set(0,0)},statics:{getValues:function(t,e,n,i){var r=t._point,s=t._handleOut,a=e._handleIn,o=e._point,h=r.x,u=r.y,l=o.x,c=o.y,f=i?[h,u,h,u,l,c,l,c]:[h,u,h+s._x,u+s._y,l+a._x,c+a._y,l,c];return n&&n._transformCoordinates(f,f,4),f},subdivide:function(t,n){var i=t[0],r=t[1],s=t[2],a=t[3],o=t[4],h=t[5],u=t[6],l=t[7];n===e&&(n=.5);var c=1-n,f=c*i+n*s,d=c*r+n*a,_=c*s+n*o,g=c*a+n*h,v=c*o+n*u,p=c*h+n*l,m=c*f+n*_,y=c*d+n*g,w=c*_+n*v,x=c*g+n*p,b=c*m+n*w,C=c*y+n*x;return[[i,r,f,d,m,y,b,C],[b,C,w,x,v,p,u,l]]},getMonoCurves:function(t,e){var n=[],i=e?0:1,r=t[i+0],s=t[i+2],a=t[i+4],o=t[i+6];if(r>=s==s>=a&&s>=a==a>=o||A.isStraight(t))n.push(t);else{var h=3*(s-a)-r+o,l=2*(r+a)-4*s,c=s-r,f=1e-8,d=1-f,_=[],g=u.solveQuadratic(h,l,c,_,f,d);if(g){_.sort();var v=_[0],p=A.subdivide(t,v);n.push(p[0]),g>1&&(v=(_[1]-v)/(1-v),p=A.subdivide(p[1],v),n.push(p[0])),n.push(p[1])}else n.push(t)}return n},solveCubic:function(t,e,n,i,r,s){var a=t[e],o=t[e+2],h=t[e+4],l=t[e+6],c=0;if(!(a<n&&l<n&&o<n&&h<n||a>n&&l>n&&o>n&&h>n)){var f=3*(o-a),d=3*(h-o)-f,_=l-a-f-d;c=u.solveCubic(_,d,f,a-n,i,r,s)}return c},getTimeOf:function(t,e){var n=new c(t[0],t[1]),i=new c(t[6],t[7]),r=1e-12,s=1e-7,a=e.isClose(n,r)?0:e.isClose(i,r)?1:null;if(null===a)for(var o=[e.x,e.y],h=[],u=0;u<2;u++)for(var l=A.solveCubic(t,u,o[u],h,0,1),f=0;f<l;f++){var d=h[f];if(e.isClose(A.getPoint(t,d),s))return d}return e.isClose(n,s)?0:e.isClose(i,s)?1:null},getNearestTime:function(t,e){function n(n){if(n>=0&&n<=1){var i=e.getDistance(A.getPoint(t,n),!0);if(i<d)return d=i,_=n,!0}}if(A.isStraight(t)){var i=t[0],r=t[1],s=t[6],a=t[7],o=s-i,h=a-r,u=o*o+h*h;if(0===u)return 0;var l=((e.x-i)*o+(e.y-r)*h)/u;return l<1e-12?0:l>.999999999999?1:A.getTimeOf(t,new c(i+l*o,r+l*h))}for(var f=100,d=1/0,_=0,g=0;g<=f;g++)n(g/f);for(var v=1/(2*f);v>1e-8;)n(_-v)||n(_+v)||(v/=2);return _},getPart:function(t,e,n){var i=e>n;if(i){var r=e;e=n,n=r}return e>0&&(t=A.subdivide(t,e)[1]),n<1&&(t=A.subdivide(t,(n-e)/(1-e))[0]),i?[t[6],t[7],t[4],t[5],t[2],t[3],t[0],t[1]]:t},isFlatEnough:function(t,e){var n=t[0],i=t[1],r=t[2],s=t[3],a=t[4],o=t[5],h=t[6],u=t[7],l=3*r-2*n-h,c=3*s-2*i-u,f=3*a-2*h-n,d=3*o-2*u-i;return Math.max(l*l,f*f)+Math.max(c*c,d*d)<=16*e*e},getArea:function(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7];return 3*((h-n)*(i+s)-(o-e)*(r+a)+r*(e-s)-i*(n-a)+h*(s+e/3)-o*(a+n/3))/20},getBounds:function(t){for(var e=t.slice(0,2),n=e.slice(),i=[0,0],r=0;r<2;r++)A._addBounds(t[r],t[r+2],t[r+4],t[r+6],r,0,e,n,i);return new g(e[0],e[1],n[0]-e[0],n[1]-e[1])},_addBounds:function(t,e,n,i,r,s,a,o,h){function l(t,e){var n=t-e,i=t+e;n<a[r]&&(a[r]=n),i>o[r]&&(o[r]=i)}s/=2;var c=a[r]-s,f=o[r]+s;if(t<c||e<c||n<c||i<c||t>f||e>f||n>f||i>f)if(e<t!=e<i&&n<t!=n<i)l(t,s),l(i,s);else{var d=3*(e-n)-t+i,_=2*(t+n)-4*e,g=e-t,v=u.solveQuadratic(d,_,g,h),p=1e-8,m=1-p;l(i,0);for(var y=0;y<v;y++){var w=h[y],x=1-w;p<=w&&w<=m&&l(x*x*x*t+3*x*x*w*e+3*x*w*w*n+w*w*w*i,s)}}}}},r.each(["getBounds","getStrokeBounds","getHandleBounds"],function(t){this[t]=function(){this._bounds||(this._bounds={});var e=this._bounds[t];return e||(e=this._bounds[t]=L[t]([this._segment1,this._segment2],!1,this._path)),e.clone()}},{}),r.each({isStraight:function(t,e,n,i){if(e.isZero()&&n.isZero())return!0;var r=i.subtract(t);if(r.isZero())return!1;if(r.isCollinear(e)&&r.isCollinear(n)){var s=new m(t,i),a=1e-7;if(s.getDistance(t.add(e))<a&&s.getDistance(i.add(n))<a){var o=r.dot(r),h=r.dot(e)/o,u=r.dot(n)/o;return h>=0&&h<=1&&u<=0&&u>=-1}}return!1},isLinear:function(t,e,n,i){var r=i.subtract(t).divide(3);return e.equals(r)&&n.negate().equals(r)}},function(t,e){this[e]=function(e){var n=this._segment1,i=this._segment2;return t(n._point,n._handleOut,i._handleIn,i._point,e)},this.statics[e]=function(e,n){var i=e[0],r=e[1],s=e[6],a=e[7];return t(new c(i,r),new c(e[2]-i,e[3]-r),new c(e[4]-s,e[5]-a),new c(s,a),n)}},{statics:{},hasHandles:function(){return!this._segment1._handleOut.isZero()||!this._segment2._handleIn.isZero()},hasLength:function(t){return(!this.getPoint1().equals(this.getPoint2())||this.hasHandles())&&this.getLength()>(t||0)},isCollinear:function(t){return t&&this.isStraight()&&t.isStraight()&&this.getLine().isCollinear(t.getLine())},isHorizontal:function(){return this.isStraight()&&Math.abs(this.getTangentAtTime(.5).y)<1e-8},isVertical:function(){return this.isStraight()&&Math.abs(this.getTangentAtTime(.5).x)<1e-8}}),{beans:!1,getLocationAt:function(t,e){return this.getLocationAtTime(e?t:this.getTimeAt(t))},getLocationAtTime:function(t){return null!=t&&t>=0&&t<=1?new O(this,t):null},getTimeAt:function(t,e){return A.getTimeAt(this.getValues(),t,e)},getParameterAt:"#getTimeAt",getTimesWithTangent:function(){var t=c.read(arguments);return t.isZero()?[]:A.getTimesWithTangent(this.getValues(),t)},getOffsetAtTime:function(t){return this.getPartLength(0,t)},getLocationOf:function(){return this.getLocationAtTime(this.getTimeOf(c.read(arguments)))},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getTimeOf:function(){return A.getTimeOf(this.getValues(),c.read(arguments))},getParameterOf:"#getTimeOf",getNearestLocation:function(){var t=c.read(arguments),e=this.getValues(),n=A.getNearestTime(e,t),i=A.getPoint(e,n);return new O(this,n,i,null,t.getDistance(i))},getNearestPoint:function(){var t=this.getNearestLocation.apply(this,arguments);return t?t.getPoint():t}},new function(){var t=["getPoint","getTangent","getNormal","getWeightedTangent","getWeightedNormal","getCurvature"];return r.each(t,function(t){this[t+"At"]=function(e,n){var i=this.getValues();return A[t](i,n?e:A.getTimeAt(i,e))},this[t+"AtTime"]=function(e){return A[t](this.getValues(),e);
}},{statics:{_evaluateMethods:t}})},new function(){function t(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7],u=9*(i-s)+3*(o-e),l=6*(e+s)-12*i,c=3*(i-e),f=9*(r-a)+3*(h-n),d=6*(n+a)-12*r,_=3*(r-n);return function(t){var e=(u*t+l)*t+c,n=(f*t+d)*t+_;return Math.sqrt(e*e+n*n)}}function n(t,e){return Math.max(2,Math.min(16,Math.ceil(32*Math.abs(e-t))))}function i(t,e,n,i){if(null==e||e<0||e>1)return null;var r=t[0],s=t[1],a=t[2],o=t[3],h=t[4],l=t[5],f=t[6],d=t[7],_=u.isZero;_(a-r)&&_(o-s)&&(a=r,o=s),_(h-f)&&_(l-d)&&(h=f,l=d);var g,v,p=3*(a-r),m=3*(h-a)-p,y=f-r-p-m,w=3*(o-s),x=3*(l-o)-w,b=d-s-w-x;if(0===n)g=0===e?r:1===e?f:((y*e+m)*e+p)*e+r,v=0===e?s:1===e?d:((b*e+x)*e+w)*e+s;else{var C=1e-8,S=1-C;if(e<C?(g=p,v=w):e>S?(g=3*(f-h),v=3*(d-l)):(g=(3*y*e+2*m)*e+p,v=(3*b*e+2*x)*e+w),i){0===g&&0===v&&(e<C||e>S)&&(g=h-a,v=l-o);var k=Math.sqrt(g*g+v*v);k&&(g/=k,v/=k)}if(3===n){var h=6*y*e+2*m,l=6*b*e+2*x,I=Math.pow(g*g+v*v,1.5);g=0!==I?(g*l-v*h)/I:0,v=0}}return 2===n?new c(v,(-g)):new c(g,v)}return{statics:{classify:function(t){function n(t,n,i){var r=n!==e,s=r&&n>0&&n<1,a=r&&i>0&&i<1;return!r||(s||a)&&("loop"!==t||s&&a)||(t="arch",s=a=!1),{type:t,roots:s||a?s&&a?n<i?[n,i]:[i,n]:[s?n:i]:null}}var i=t[0],r=t[1],s=t[2],a=t[3],o=t[4],h=t[5],l=t[6],c=t[7],f=i*(c-h)+r*(o-l)+l*h-c*o,d=s*(r-c)+a*(l-i)+i*c-r*l,_=o*(a-r)+h*(i-s)+s*r-a*i,g=3*_,v=g-d,p=v-d+f,m=Math.sqrt(p*p+v*v+g*g),y=0!==m?1/m:0,w=u.isZero,x="serpentine";if(p*=y,v*=y,g*=y,w(p))return w(v)?n(w(g)?"line":"quadratic"):n(x,g/(3*v));var b=3*v*v-4*p*g;if(w(b))return n("cusp",v/(2*p));var C=b>0?Math.sqrt(b/3):Math.sqrt(-b),S=2*p;return n(b>0?x:"loop",(v+C)/S,(v-C)/S)},getLength:function(i,r,s,a){if(r===e&&(r=0),s===e&&(s=1),A.isStraight(i)){var o=i;s<1&&(o=A.subdivide(o,s)[0],r/=s),r>0&&(o=A.subdivide(o,r)[1]);var h=o[6]-o[0],l=o[7]-o[1];return Math.sqrt(h*h+l*l)}return u.integrate(a||t(i),r,s,n(r,s))},getTimeAt:function(i,r,s){function a(t){return p+=u.integrate(d,s,t,n(s,t)),s=t,p-r}if(s===e&&(s=r<0?1:0),0===r)return s;var o=Math.abs,h=1e-12,l=r>0,c=l?s:0,f=l?1:s,d=t(i),_=A.getLength(i,c,f,d),g=o(r)-_;if(o(g)<h)return l?f:c;if(g>h)return null;var v=r/_,p=0;return u.findRoot(a,d,s+v,c,f,32,1e-12)},getPoint:function(t,e){return i(t,e,0,!1)},getTangent:function(t,e){return i(t,e,1,!0)},getWeightedTangent:function(t,e){return i(t,e,1,!1)},getNormal:function(t,e){return i(t,e,2,!0)},getWeightedNormal:function(t,e){return i(t,e,2,!1)},getCurvature:function(t,e){return i(t,e,3,!1).x},getPeaks:function(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7],l=-e+3*i-3*s+o,c=3*e-6*i+3*s,f=-3*e+3*i,d=-n+3*r-3*a+h,_=3*n-6*r+3*a,g=-3*n+3*r,v=1e-8,p=1-v,m=[];return u.solveCubic(9*(l*l+d*d),9*(l*c+_*d),2*(c*c+_*_)+3*(f*l+g*d),f*c+_*g,m,v,p),m.sort()}}}},new function(){function t(t,e,n,i,r,s,a){var o=!a&&n.getPrevious()===r,h=!a&&n!==r&&n.getNext()===r,u=1e-8,l=1-u;if(null!==i&&i>=(o?u:0)&&i<=(h?l:1)&&null!==s&&s>=(h?u:0)&&s<=(o?l:1)){var c=new O(n,i,null,a),f=new O(r,s,null,a);c._intersection=f,f._intersection=c,e&&!e(c)||O.insert(t,c,!0)}}function e(r,s,a,o,h,u,l,c,f,d,_,g,v){if(++f>=4096||++c>=40)return f;var p,y,w=1e-9,x=s[0],b=s[1],C=s[6],S=s[7],k=m.getSignedDistance,I=k(x,b,C,S,s[2],s[3]),P=k(x,b,C,S,s[4],s[5]),T=I*P>0?.75:4/9,M=T*Math.min(0,I,P),O=T*Math.max(0,I,P),z=k(x,b,C,S,r[0],r[1]),L=k(x,b,C,S,r[2],r[3]),E=k(x,b,C,S,r[4],r[5]),N=k(x,b,C,S,r[6],r[7]),B=n(z,L,E,N),F=B[0],j=B[1];if(0===I&&0===P&&0===z&&0===L&&0===E&&0===N||null==(p=i(F,j,M,O))||null==(y=i(F.reverse(),j.reverse(),M,O)))return f;var D=d+(_-d)*p,R=d+(_-d)*y;if(Math.max(v-g,R-D)<w){var q=(D+R)/2,V=(g+v)/2;t(h,u,l?o:a,l?V:q,l?a:o,l?q:V)}else if(r=A.getPart(r,p,y),y-p>.8)if(R-D>v-g){var U=A.subdivide(r,.5),q=(D+R)/2;f=e(s,U[0],o,a,h,u,!l,c,f,g,v,D,q),f=e(s,U[1],o,a,h,u,!l,c,f,g,v,q,R)}else{var U=A.subdivide(s,.5),V=(g+v)/2;f=e(U[0],r,o,a,h,u,!l,c,f,g,V,D,R),f=e(U[1],r,o,a,h,u,!l,c,f,V,v,D,R)}else f=v-g>=w?e(s,r,o,a,h,u,!l,c,f,g,v,D,R):e(r,s,a,o,h,u,l,c,f,D,R,g,v);return f}function n(t,e,n,i){var r,s=[0,t],a=[1/3,e],o=[2/3,n],h=[1,i],u=e-(2*t+i)/3,l=n-(t+2*i)/3;if(u*l<0)r=[[s,a,h],[s,o,h]];else{var c=u/l;r=[c>=2?[s,a,h]:c<=.5?[s,o,h]:[s,a,o,h],[s,h]]}return(u||l)<0?r.reverse():r}function i(t,e,n,i){return t[0][1]<n?s(t,!0,n):e[0][1]>i?s(e,!1,i):t[0][0]}function s(t,e,n){for(var i=t[0][0],r=t[0][1],s=1,a=t.length;s<a;s++){var o=t[s][0],h=t[s][1];if(e?h>=n:h<=n)return h===n?o:i+(n-r)*(o-i)/(h-r);i=o,r=h}return null}function a(t,e,n,i,r){var s=u.isZero;if(s(i)&&s(r)){var a=A.getTimeOf(t,new c(e,n));return null===a?[]:[a]}for(var o=Math.atan2(-r,i),h=Math.sin(o),l=Math.cos(o),f=[],d=[],_=0;_<8;_+=2){var g=t[_]-e,v=t[_+1]-n;f.push(g*l-v*h,g*h+v*l)}return A.solveCubic(f,1,0,d,0,1),d}function o(e,n,i,r,s,o,h){for(var u=n[0],l=n[1],c=n[6],f=n[7],d=a(e,u,l,c-u,f-l),_=0,g=d.length;_<g;_++){var v=d[_],p=A.getPoint(e,v),m=A.getTimeOf(n,p);null!==m&&t(s,o,h?r:i,h?m:v,h?i:r,h?v:m)}}function h(e,n,i,r,s,a){var o=m.intersect(e[0],e[1],e[6],e[7],n[0],n[1],n[6],n[7]);o&&t(s,a,i,A.getTimeOf(e,o),r,A.getTimeOf(n,o))}function l(n,i,r,s,a,u){var l=1e-12,f=Math.min,d=Math.max;if(d(n[0],n[2],n[4],n[6])+l>f(i[0],i[2],i[4],i[6])&&f(n[0],n[2],n[4],n[6])-l<d(i[0],i[2],i[4],i[6])&&d(n[1],n[3],n[5],n[7])+l>f(i[1],i[3],i[5],i[7])&&f(n[1],n[3],n[5],n[7])-l<d(i[1],i[3],i[5],i[7])){var g=_(n,i);if(g)for(var v=0;v<2;v++){var p=g[v];t(a,u,r,p[0],s,p[1],!0)}else{var m=A.isStraight(n),y=A.isStraight(i),w=m&&y,x=m&&!y,b=a.length;if((w?h:m||y?o:e)(x?i:n,x?n:i,x?s:r,x?r:s,a,u,x,0,0,0,1,0,1),!w||a.length===b)for(var v=0;v<4;v++){var C=v>>1,S=1&v,k=6*C,I=6*S,P=new c(n[k],n[k+1]),T=new c(i[I],i[I+1]);P.isClose(T,l)&&t(a,u,r,C,s,S)}}}return a}function f(e,n,i,r){var s=A.classify(e);if("loop"===s.type){var a=s.roots;t(i,r,n,a[0],n,a[1])}return i}function d(t,e,n,i,s,a){var o=!e;o&&(e=t);for(var h,u,c=t.length,d=e.length,_=[],g=[],v=0;v<d;v++)_[v]=e[v].getValues(s);for(var v=0;v<c;v++){var p=t[v],m=o?_[v]:p.getValues(i),y=p.getPath();y!==u&&(u=y,h=[],g.push(h)),o&&f(m,p,h,n);for(var w=o?v+1:0;w<d;w++){if(a&&h.length)return h;l(m,_[w],p,e[w],h,n)}}h=[];for(var v=0,x=g.length;v<x;v++)r.push(h,g[v]);return h}function _(t,e){function n(t){var e=t[6]-t[0],n=t[7]-t[1];return e*e+n*n}var i=Math.abs,r=m.getDistance,s=1e-8,a=1e-7,o=A.isStraight(t),h=A.isStraight(e),u=o&&h,l=n(t)<n(e),f=l?e:t,d=l?t:e,_=f[0],g=f[1],v=f[6]-_,p=f[7]-g;if(r(_,g,v,p,d[0],d[1],!0)<a&&r(_,g,v,p,d[6],d[7],!0)<a)!u&&r(_,g,v,p,f[2],f[3],!0)<a&&r(_,g,v,p,f[4],f[5],!0)<a&&r(_,g,v,p,d[2],d[3],!0)<a&&r(_,g,v,p,d[4],d[5],!0)<a&&(o=h=u=!0);else if(u)return null;if(o^h)return null;for(var y=[t,e],w=[],x=0;x<4&&w.length<2;x++){var b=1&x,C=1^b,S=x>>1,k=A.getTimeOf(y[b],new c(y[C][S?6:0],y[C][S?7:1]));if(null!=k){var I=b?[S,k]:[k,S];(!w.length||i(I[0]-w[0][0])>s&&i(I[1]-w[0][1])>s)&&w.push(I)}if(x>2&&!w.length)break}if(2!==w.length)w=null;else if(!u){var P=A.getPart(t,w[0][0],w[1][0]),T=A.getPart(e,w[0][1],w[1][1]);(i(T[2]-P[2])>a||i(T[3]-P[3])>a||i(T[4]-P[4])>a||i(T[5]-P[5])>a)&&(w=null)}return w}function g(t,e){var n=t[0],i=t[1],r=t[2],s=t[3],a=t[4],o=t[5],h=t[6],l=t[7],c=e.normalize(),f=c.x,d=c.y,_=3*h-9*a+9*r-3*n,g=3*l-9*o+9*s-3*i,v=6*a-12*r+6*n,p=6*o-12*s+6*i,m=3*r-3*n,y=3*s-3*i,w=2*_*d-2*g*f,x=[];if(Math.abs(w)<u.CURVETIME_EPSILON){var b=_*y-g*m,w=_*p-g*v;if(0!=w){var C=-b/w;C>=0&&C<=1&&x.push(C)}}else{var S=(v*v-4*_*m)*d*d+(-2*v*p+4*g*m+4*_*y)*f*d+(p*p-4*g*y)*f*f,k=v*d-p*f;if(S>=0&&0!=w){var I=Math.sqrt(S),P=-(k+I)/w,T=(-k+I)/w;P>=0&&P<=1&&x.push(P),T>=0&&T<=1&&x.push(T)}}return x}return{getIntersections:function(t){var e=this.getValues(),n=t&&t!==this&&t.getValues();return n?l(e,n,this,t,[]):f(e,this,[])},statics:{getOverlaps:_,getIntersections:d,getCurveLineIntersections:a,getTimesWithTangent:g}}}),O=r.extend({_class:"CurveLocation",initialize:function(t,e,n,i,r){if(e>=.99999999){var s=t.getNext();s&&(e=0,t=s)}this._setCurve(t),this._time=e,this._point=n||t.getPointAtTime(e),this._overlap=i,this._distance=r,this._intersection=this._next=this._previous=null},_setCurve:function(t){var e=t._path;this._path=e,this._version=e?e._version:0,this._curve=t,this._segment=null,this._segment1=t._segment1,this._segment2=t._segment2},_setSegment:function(t){this._setCurve(t.getCurve()),this._segment=t,this._time=t===this._segment1?0:1,this._point=t._point.clone()},getSegment:function(){var t=this._segment;if(!t){var e=this.getCurve(),n=this.getTime();0===n?t=e._segment1:1===n?t=e._segment2:null!=n&&(t=e.getPartLength(0,n)<e.getPartLength(n,1)?e._segment1:e._segment2),this._segment=t}return t},getCurve:function(){function t(t){var e=t&&t.getCurve();if(e&&null!=(n._time=e.getTimeOf(n._point)))return n._setCurve(e),e}var e=this._path,n=this;return e&&e._version!==this._version&&(this._time=this._offset=this._curveOffset=this._curve=null),this._curve||t(this._segment)||t(this._segment1)||t(this._segment2.getPrevious())},getPath:function(){var t=this.getCurve();return t&&t._path},getIndex:function(){var t=this.getCurve();return t&&t.getIndex()},getTime:function(){var t=this.getCurve(),e=this._time;return t&&null==e?this._time=t.getTimeOf(this._point):e},getParameter:"#getTime",getPoint:function(){return this._point},getOffset:function(){var t=this._offset;if(null==t){t=0;var e=this.getPath(),n=this.getIndex();if(e&&null!=n)for(var i=e.getCurves(),r=0;r<n;r++)t+=i[r].getLength();this._offset=t+=this.getCurveOffset()}return t},getCurveOffset:function(){var t=this._curveOffset;if(null==t){var e=this.getCurve(),n=this.getTime();this._curveOffset=t=null!=n&&e&&e.getPartLength(0,n)}return t},getIntersection:function(){return this._intersection},getDistance:function(){return this._distance},divide:function(){var t=this.getCurve(),e=t&&t.divideAtTime(this.getTime());return e&&this._setSegment(e._segment1),e},split:function(){var t=this.getCurve(),e=t._path,n=t&&t.splitAtTime(this.getTime());return n&&this._setSegment(e.getLastSegment()),n},equals:function(t,e){var n=this===t;if(!n&&t instanceof O){var i=this.getCurve(),r=t.getCurve(),s=i._path,a=r._path;if(s===a){var o=Math.abs,h=1e-7,u=o(this.getOffset()-t.getOffset()),l=!e&&this._intersection,c=!e&&t._intersection;n=(u<h||s&&o(s.getLength()-u)<h)&&(!l&&!c||l&&c&&l.equals(c,!0))}}return n},toString:function(){var t=[],e=this.getPoint(),n=h.instance;e&&t.push("point: "+e);var i=this.getIndex();null!=i&&t.push("index: "+i);var r=this.getTime();return null!=r&&t.push("time: "+n.number(r)),null!=this._distance&&t.push("distance: "+n.number(this._distance)),"{ "+t.join(", ")+" }"},isTouching:function(){var t=this._intersection;if(t&&this.getTangent().isCollinear(t.getTangent())){var e=this.getCurve(),n=t.getCurve();return!(e.isStraight()&&n.isStraight()&&e.getLine().intersect(n.getLine()))}return!1},isCrossing:function(){function t(t,e){var n=t.getValues(),i=A.classify(n).roots||A.getPeaks(n),r=i.length,s=e&&r>1?i[r-1]:r>0?i[0]:.5;d.push(A.getLength(n,e?s:0,e?1:s)/2)}function e(t,e,n){return e<n?t>e&&t<n:t>e||t<n}var n=this._intersection;if(!n)return!1;var i=this.getTime(),r=n.getTime(),s=1e-8,a=1-s,o=i>=s&&i<=a,h=r>=s&&r<=a;if(o&&h)return!this.isTouching();var u=this.getCurve(),l=i<s?u.getPrevious():u,c=n.getCurve(),f=r<s?c.getPrevious():c;if(i>a&&(u=u.getNext()),r>a&&(c=c.getNext()),!(l&&u&&f&&c))return!1;var d=[];o||(t(l,!0),t(u,!1)),h||(t(f,!0),t(c,!1));var _=this.getPoint(),g=Math.min.apply(Math,d),v=o?u.getTangentAtTime(i):u.getPointAt(g).subtract(_),p=o?v.negate():l.getPointAt(-g).subtract(_),m=h?c.getTangentAtTime(r):c.getPointAt(g).subtract(_),y=h?m.negate():f.getPointAt(-g).subtract(_),w=p.getAngle(),x=v.getAngle(),b=y.getAngle(),C=m.getAngle();return!!(o?e(w,b,C)^e(x,b,C)&&e(w,C,b)^e(x,C,b):e(b,w,x)^e(C,w,x)&&e(b,x,w)^e(C,x,w))},hasOverlap:function(){return!!this._overlap}},r.each(A._evaluateMethods,function(t){var e=t+"At";this[t]=function(){var t=this.getCurve(),n=this.getTime();return null!=n&&t&&t[e](n,!0)}},{preserve:!0}),new function(){function t(t,e,n){function i(n,i){for(var s=n+i;s>=-1&&s<=r;s+=i){var a=t[(s%r+r)%r];if(!e.getPoint().isClose(a.getPoint(),1e-7))break;if(e.equals(a))return a}return null}for(var r=t.length,s=0,a=r-1;s<=a;){var o,h=s+a>>>1,u=t[h];if(n&&(o=e.equals(u)?u:i(h,-1)||i(h,1)))return e._overlap&&(o._overlap=o._intersection._overlap=!0),o;var l=e.getPath(),c=u.getPath(),f=l!==c?l._id-c._id:e.getIndex()+e.getTime()-(u.getIndex()+u.getTime());f<0?a=h-1:s=h+1}return t.splice(s,0,e),e}return{statics:{insert:t,expand:function(e){for(var n=e.slice(),i=e.length-1;i>=0;i--)t(n,e[i]._intersection,!1);return n}}}}),z=w.extend({_class:"PathItem",_selectBounds:!1,_canScaleStroke:!0,beans:!0,initialize:function(){},statics:{create:function(t){var e,n,i;if(r.isPlainObject(t)?(n=t.segments,e=t.pathData):Array.isArray(t)?n=t:"string"==typeof t&&(e=t),n){var s=n[0];i=s&&Array.isArray(s[0])}else e&&(i=(e.match(/m/gi)||[]).length>1||/z\s*\S+/i.test(e));var a=i?E:L;return new a(t)}},_asPathItem:function(){return this},isClockwise:function(){return this.getArea()>=0},setClockwise:function(t){this.isClockwise()!=(t=!!t)&&this.reverse()},setPathData:function(t){function e(t,e){var n=+i[t];return o&&(n+=h[e]),n}function n(t){return new c(e(t,"x"),e(t+1,"y"))}var i,r,s,a=t&&t.match(/[mlhvcsqtaz][^mlhvcsqtaz]*/gi),o=!1,h=new c,u=new c;this.clear();for(var l=0,f=a&&a.length;l<f;l++){var _=a[l],g=_[0],v=g.toLowerCase();i=_.match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g);var p=i&&i.length;switch(o=g===v,"z"!==r||/[mz]/.test(v)||this.moveTo(h),v){case"m":case"l":for(var m="m"===v,y=0;y<p;y+=2)this[m?"moveTo":"lineTo"](h=n(y)),m&&(u=h,m=!1);s=h;break;case"h":case"v":var w="h"===v?"x":"y";h=h.clone();for(var y=0;y<p;y++)h[w]=e(y,w),this.lineTo(h);s=h;break;case"c":for(var y=0;y<p;y+=6)this.cubicCurveTo(n(y),s=n(y+2),h=n(y+4));break;case"s":for(var y=0;y<p;y+=4)this.cubicCurveTo(/[cs]/.test(r)?h.multiply(2).subtract(s):h,s=n(y),h=n(y+2)),r=v;break;case"q":for(var y=0;y<p;y+=4)this.quadraticCurveTo(s=n(y),h=n(y+2));break;case"t":for(var y=0;y<p;y+=2)this.quadraticCurveTo(s=/[qt]/.test(r)?h.multiply(2).subtract(s):h,h=n(y)),r=v;break;case"a":for(var y=0;y<p;y+=7)this.arcTo(h=n(y+5),new d((+i[y]),(+i[y+1])),+i[y+2],+i[y+4],+i[y+3]);break;case"z":this.closePath(1e-12),h=u}r=v}},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_contains:function(t){var e=t.isInside(this.getBounds({internal:!0,handle:!0}))?this._getWinding(t):{};return e.onPath||!!("evenodd"===this.getFillRule()?1&e.windingL||1&e.windingR:e.winding)},getIntersections:function(t,e,n,i){var r=this===t||!t,s=this._matrix._orNullIfIdentity(),a=r?s:(n||t._matrix)._orNullIfIdentity();return r||this.getBounds(s).intersects(t.getBounds(a),1e-12)?A.getIntersections(this.getCurves(),!r&&t.getCurves(),e,s,a,i):[]},getCrossings:function(t){return this.getIntersections(t,function(t){return t.hasOverlap()||t.isCrossing()})},getNearestLocation:function(){for(var t=c.read(arguments),e=this.getCurves(),n=1/0,i=null,r=0,s=e.length;r<s;r++){var a=e[r].getNearestLocation(t);a._distance<n&&(n=a._distance,i=a)}return i},getNearestPoint:function(){var t=this.getNearestLocation.apply(this,arguments);return t?t.getPoint():t},interpolate:function(t,e,n){var i=!this._children,r=i?"_segments":"_children",s=t[r],a=e[r],o=this[r];if(!s||!a||s.length!==a.length)throw new Error("Invalid operands in interpolate() call: "+t+", "+e);var h=o.length,u=a.length;if(h<u)for(var l=i?T:L,c=h;c<u;c++)this.add(new l);else h>u&&this[i?"removeSegments":"removeChildren"](u,h);for(var c=0;c<u;c++)o[c].interpolate(s[c],a[c],n);i&&(this.setClosed(t._closed),this._changed(9))},compare:function(t){var e=!1;if(t){var n=this._children||[this],i=t._children?t._children.slice():[t],r=n.length,s=i.length,a=[],o=0;e=!0;for(var h=r-1;h>=0&&e;h--){var u=n[h];e=!1;for(var l=s-1;l>=0&&!e;l--)u.compare(i[l])&&(a[l]||(a[l]=!0,o++),e=!0)}e=e&&o===s}return e}}),L=z.extend({_class:"Path",_serializeFields:{segments:[],closed:!1},initialize:function(t){this._closed=!1,this._segments=[],this._version=0;var n=Array.isArray(t)?"object"==typeof t[0]?t:arguments:!t||t.size!==e||t.x===e&&t.point===e?null:arguments;n&&n.length>0?this.setSegments(n):(this._curves=e,this._segmentSelection=0,n||"string"!=typeof t||(this.setPathData(t),t=null)),this._initialize(!n&&t)},_equals:function(t){return this._closed===t._closed&&r.equals(this._segments,t._segments)},copyContent:function(t){this.setSegments(t._segments),this._closed=t._closed},_changed:function mt(t){if(mt.base.call(this,t),8&t){if(this._length=this._area=e,32&t)this._version++;else if(this._curves)for(var n=0,i=this._curves.length;n<i;n++)this._curves[n]._changed()}else 64&t&&(this._bounds=e)},getStyle:function(){var t=this._parent;return(t instanceof E?t:this)._style},getSegments:function(){return this._segments},setSegments:function(t){var n=this.isFullySelected(),i=t&&t.length;if(this._segments.length=0,this._segmentSelection=0,this._curves=e,i){var r=t[i-1];"boolean"==typeof r&&(this.setClosed(r),i--),this._add(T.readList(t,0,{},i))}n&&this.setFullySelected(!0)},getFirstSegment:function(){return this._segments[0]},getLastSegment:function(){return this._segments[this._segments.length-1]},getCurves:function(){var t=this._curves,e=this._segments;if(!t){var n=this._countCurves();t=this._curves=new Array(n);for(var i=0;i<n;i++)t[i]=new A(this,e[i],e[i+1]||e[0])}return t},getFirstCurve:function(){return this.getCurves()[0]},getLastCurve:function(){var t=this.getCurves();return t[t.length-1]},isClosed:function(){return this._closed},setClosed:function(t){if(this._closed!=(t=!!t)){if(this._closed=t,this._curves){var e=this._curves.length=this._countCurves();t&&(this._curves[e-1]=new A(this,this._segments[e-1],this._segments[0]))}this._changed(41)}}},{beans:!0,getPathData:function(t,e){function n(e,n){if(e._transformCoordinates(t,g),i=g[0],r=g[1],v)p.push("M"+_.pair(i,r)),v=!1;else if(o=g[2],u=g[3],o===i&&u===r&&l===s&&c===a){if(!n){var h=i-s,f=r-a;p.push(0===h?"v"+_.number(f):0===f?"h"+_.number(h):"l"+_.pair(h,f))}}else p.push("c"+_.pair(l-s,c-a)+" "+_.pair(o-s,u-a)+" "+_.pair(i-s,r-a));s=i,a=r,l=g[4],c=g[5]}var i,r,s,a,o,u,l,c,f=this._segments,d=f.length,_=new h(e),g=new Array(6),v=!0,p=[];if(!d)return"";for(var m=0;m<d;m++)n(f[m]);return this._closed&&d>0&&(n(f[0],!0),p.push("z")),p.join("")},isEmpty:function(){return!this._segments.length},_transformContent:function(t){for(var e=this._segments,n=new Array(6),i=0,r=e.length;i<r;i++)e[i]._transformCoordinates(t,n,!0);return!0},_add:function(t,e){for(var n=this._segments,i=this._curves,s=t.length,a=null==e,e=a?n.length:e,o=0;o<s;o++){var h=t[o];h._path&&(h=t[o]=h.clone()),h._path=this,h._index=e+o,h._selection&&this._updateSelection(h,0,h._selection)}if(a)r.push(n,t);else{n.splice.apply(n,[e,0].concat(t));for(var o=e+s,u=n.length;o<u;o++)n[o]._index=o}if(i){var l=this._countCurves(),c=e>0&&e+s-1===l?e-1:e,f=c,d=Math.min(c+s,l);t._curves&&(i.splice.apply(i,[c,0].concat(t._curves)),f+=t._curves.length);for(var o=f;o<d;o++)i.splice(o,0,new A(this,null,null));this._adjustCurves(c,d)}return this._changed(41),t},_adjustCurves:function(t,e){for(var n,i=this._segments,r=this._curves,s=t;s<e;s++)n=r[s],n._path=this,n._segment1=i[s],n._segment2=i[s+1]||i[0],n._changed();(n=r[this._closed&&!t?i.length-1:t-1])&&(n._segment2=i[t]||i[0],n._changed()),(n=r[e])&&(n._segment1=i[e],n._changed())},_countCurves:function(){var t=this._segments.length;return!this._closed&&t>0?t-1:t},add:function(t){return arguments.length>1&&"number"!=typeof t?this._add(T.readList(arguments)):this._add([T.read(arguments)])[0]},insert:function(t,e){return arguments.length>2&&"number"!=typeof e?this._add(T.readList(arguments,1),t):this._add([T.read(arguments,1)],t)[0]},addSegment:function(){return this._add([T.read(arguments)])[0]},insertSegment:function(t){return this._add([T.read(arguments,1)],t)[0]},addSegments:function(t){return this._add(T.readList(t))},insertSegments:function(t,e){return this._add(T.readList(e),t)},removeSegment:function(t){return this.removeSegments(t,t+1)[0]||null},removeSegments:function(t,e,n){t=t||0,e=r.pick(e,this._segments.length);var i=this._segments,s=this._curves,a=i.length,o=i.splice(t,e-t),h=o.length;if(!h)return o;for(var u=0;u<h;u++){var l=o[u];l._selection&&this._updateSelection(l,l._selection,0),l._index=l._path=null}for(var u=t,c=i.length;u<c;u++)i[u]._index=u;if(s){for(var f=t>0&&e===a+(this._closed?1:0)?t-1:t,s=s.splice(f,h),u=s.length-1;u>=0;u--)s[u]._path=null;n&&(o._curves=s.slice(1)),this._adjustCurves(f,f)}return this._changed(41),o},clear:"#removeSegments",hasHandles:function(){for(var t=this._segments,e=0,n=t.length;e<n;e++)if(t[e].hasHandles())return!0;return!1},clearHandles:function(){for(var t=this._segments,e=0,n=t.length;e<n;e++)t[e].clearHandles()},getLength:function(){if(null==this._length){for(var t=this.getCurves(),e=0,n=0,i=t.length;n<i;n++)e+=t[n].getLength();this._length=e}return this._length},getArea:function(){var t=this._area;if(null==t){var e=this._segments,n=this._closed;t=0;for(var i=0,r=e.length;i<r;i++){var s=i+1===r;t+=A.getArea(A.getValues(e[i],e[s?0:i+1],null,s&&!n))}this._area=t}return t},isFullySelected:function(){var t=this._segments.length;return this.isSelected()&&t>0&&this._segmentSelection===7*t},setFullySelected:function(t){t&&this._selectSegments(!0),this.setSelected(t)},setSelection:function yt(t){1&t||this._selectSegments(!1),yt.base.call(this,t)},_selectSegments:function(t){var e=this._segments,n=e.length,i=t?7:0;this._segmentSelection=i*n;for(var r=0;r<n;r++)e[r]._selection=i},_updateSelection:function(t,e,n){t._selection=n;var i=this._segmentSelection+=n-e;i>0&&this.setSelected(!0)},divideAt:function(t){var e,n=this.getLocationAt(t);return n&&(e=n.getCurve().divideAt(n.getCurveOffset()))?e._segment1:null},splitAt:function(t){var e=this.getLocationAt(t),n=e&&e.index,i=e&&e.time,r=1e-8,s=1-r;i>s&&(n++,i=0);var a=this.getCurves();if(n>=0&&n<a.length){i>=r&&a[n++].divideAtTime(i);var o,h=this.removeSegments(n,this._segments.length,!0);return this._closed?(this.setClosed(!1),o=this):(o=new L(w.NO_INSERT),o.insertAbove(this),o.copyAttributes(this)),o._add(h,0),this.addSegment(h[0]),o}return null},split:function(t,n){var i,r=n===e?t:(i=this.getCurves()[t])&&i.getLocationAtTime(n);return null!=r?this.splitAt(r):null},join:function(t,e){var n=e||0;if(t&&t!==this){var i=t._segments,r=this.getLastSegment(),s=t.getLastSegment();if(!s)return this;r&&r._point.isClose(s._point,n)&&t.reverse();var a=t.getFirstSegment();if(r&&r._point.isClose(a._point,n))r.setHandleOut(a._handleOut),this._add(i.slice(1));else{var o=this.getFirstSegment();o&&o._point.isClose(a._point,n)&&t.reverse(),s=t.getLastSegment(),o&&o._point.isClose(s._point,n)?(o.setHandleIn(s._handleIn),this._add(i.slice(0,i.length-1),0)):this._add(i.slice())}t._closed&&this._add([i[0]]),t.remove()}var h=this.getFirstSegment(),u=this.getLastSegment();return h!==u&&h._point.isClose(u._point,n)&&(h.setHandleIn(u._handleIn),u.remove(),this.setClosed(!0)),this},reduce:function(t){for(var e=this.getCurves(),n=t&&t.simplify,i=n?1e-7:0,r=e.length-1;r>=0;r--){var s=e[r];!s.hasHandles()&&(!s.hasLength(i)||n&&s.isCollinear(s.getNext()))&&s.remove()}return this},reverse:function(){this._segments.reverse();for(var t=0,e=this._segments.length;t<e;t++){var n=this._segments[t],i=n._handleIn;n._handleIn=n._handleOut,n._handleOut=i,n._index=t}this._curves=null,this._changed(9)},flatten:function(t){for(var e=new N(this,t||.25,256,(!0)),n=e.parts,i=n.length,r=[],s=0;s<i;s++)r.push(new T(n[s].curve.slice(0,2)));!this._closed&&i>0&&r.push(new T(n[i-1].curve.slice(6))),this.setSegments(r)},simplify:function(t){var e=new B(this).fit(t||2.5);return e&&this.setSegments(e),!!e},smooth:function(t){function n(t,e){var n=t&&t.index;if(null!=n){var r=t.path;if(r&&r!==i)throw new Error(t._class+" "+n+" of "+r+" is not part of "+i);e&&t instanceof A&&n++}else n="number"==typeof t?t:e;return Math.min(n<0&&h?n%o:n<0?n+o:n,o-1)}var i=this,r=t||{},s=r.type||"asymmetric",a=this._segments,o=a.length,h=this._closed,u=h&&r.from===e&&r.to===e,l=n(r.from,0),c=n(r.to,o-1);if(l>c)if(h)l-=o;else{var f=l;l=c,c=f}if(/^(?:asymmetric|continuous)$/.test(s)){var d="asymmetric"===s,_=Math.min,g=c-l+1,v=g-1,p=u?_(g,4):1,m=p,y=p,w=[];if(h||(m=_(1,l),y=_(1,o-c-1)),v+=m+y,v<=1)return;for(var x=0,b=l-m;x<=v;x++,b++)w[x]=a[(b<0?b+o:b)%o]._point;for(var C=w[0]._x+2*w[1]._x,S=w[0]._y+2*w[1]._y,k=2,I=v-1,P=[C],T=[S],M=[k],O=[],z=[],x=1;x<v;x++){var L=x<I,E=L?1:d?1:2,N=L?4:d?2:7,B=L?4:d?3:8,F=L?2:d?0:1,j=E/k;k=M[x]=N-j,C=P[x]=B*w[x]._x+F*w[x+1]._x-j*C,S=T[x]=B*w[x]._y+F*w[x+1]._y-j*S}O[I]=P[I]/M[I],z[I]=T[I]/M[I];for(var x=v-2;x>=0;x--)O[x]=(P[x]-O[x+1])/M[x],z[x]=(T[x]-z[x+1])/M[x];O[v]=(3*w[v]._x-O[I])/2,z[v]=(3*w[v]._y-z[I])/2;for(var x=m,D=v-y,b=l;x<=D;x++,b++){var R=a[b<0?b+o:b],q=R._point,V=O[x]-q._x,U=z[x]-q._y;(u||x<D)&&R.setHandleOut(V,U),(u||x>m)&&R.setHandleIn(-V,-U)}}else for(var x=l;x<=c;x++)a[x<0?x+o:x].smooth(r,!u&&x===l,!u&&x===c)},toShape:function(t){function n(t,e){var n=c[t],i=n.getNext(),r=c[e],s=r.getNext();return n._handleOut.isZero()&&i._handleIn.isZero()&&r._handleOut.isZero()&&s._handleIn.isZero()&&i._point.subtract(n._point).isCollinear(s._point.subtract(r._point))}function i(t){var e=c[t],n=e.getPrevious(),i=e.getNext();return n._handleOut.isZero()&&e._handleIn.isZero()&&e._handleOut.isZero()&&i._handleIn.isZero()&&e._point.subtract(n._point).isOrthogonal(i._point.subtract(e._point))}function r(t){var e=c[t],n=e.getNext(),i=e._handleOut,r=n._handleIn,s=.5522847498307936;if(i.isOrthogonal(r)){var a=e._point,o=n._point,h=new m(a,i,(!0)).intersect(new m(o,r,(!0)),!0);return h&&u.isZero(i.getLength()/h.subtract(a).getLength()-s)&&u.isZero(r.getLength()/h.subtract(o).getLength()-s)}return!1}function s(t,e){return c[t]._point.getDistance(c[e]._point)}if(!this._closed)return null;var a,o,h,l,c=this._segments;if(!this.hasHandles()&&4===c.length&&n(0,2)&&n(1,3)&&i(1)?(a=C.Rectangle,o=new d(s(0,3),s(0,1)),l=c[1]._point.add(c[2]._point).divide(2)):8===c.length&&r(0)&&r(2)&&r(4)&&r(6)&&n(1,5)&&n(3,7)?(a=C.Rectangle,o=new d(s(1,6),s(0,3)),h=o.subtract(new d(s(0,7),s(1,2))).divide(2),l=c[3]._point.add(c[4]._point).divide(2)):4===c.length&&r(0)&&r(1)&&r(2)&&r(3)&&(u.isZero(s(0,2)-s(1,3))?(a=C.Circle,h=s(0,2)/2):(a=C.Ellipse,h=new d(s(2,0)/2,s(3,1)/2)),l=c[1]._point),a){var f=this.getPosition(!0),_=new a({center:f,size:o,radius:h,insert:!1});return _.copyAttributes(this,!0),_._matrix.prepend(this._matrix),_.rotate(l.subtract(f).getAngle()+90),(t===e||t)&&_.insertAbove(this),_}return null},toPath:"#clone",compare:function wt(t){if(!t||t instanceof E)return wt.base.call(this,t);var e=this.getCurves(),n=t.getCurves(),i=e.length,r=n.length;if(!i||!r)return i==r;for(var s,a,o=e[0].getValues(),h=[],u=0,l=0,c=0;c<r;c++){var f=n[c].getValues();h.push(f);var d=A.getOverlaps(o,f);if(d){s=!c&&d[0][0]>0?r-1:c,a=d[0][1];break}}for(var _,g=Math.abs,v=1e-8,f=h[s];o&&f;){var d=A.getOverlaps(o,f);if(d){var p=d[0][0];if(g(p-l)<v){l=d[1][0],1===l&&(o=++u<i?e[u].getValues():null,l=0);var m=d[0][1];if(g(m-a)<v){if(_||(_=[s,m]),a=d[1][1],1===a&&(++s>=r&&(s=0),f=h[s]||n[s].getValues(),a=0),!o)return _[0]===s&&_[1]===a;continue}}}break}return!1},_hitTestSelf:function(t,e,n,i){function r(e,n){return t.subtract(e).divide(n).length<=1}function s(t,n,i){if(!e.selected||n.isSelected()){var s=t._point;if(n!==s&&(n=n.add(s)),r(n,x))return new P(i,g,{segment:t,point:n})}}function a(t,n){return(n||e.segments)&&s(t,t._point,"segment")||!n&&e.handles&&(s(t,t._handleIn,"handle-in")||s(t,t._handleOut,"handle-out"))}function o(t){f.add(t)}function h(e){var n=y||e._index>0&&e._index<m-1;if("round"===(n?u:l))return r(e._point,x);if(f=new L({internal:!0,closed:!0}),n?e.isSmooth()||L._addBevelJoin(e,u,k,c,null,i,o,!0):"square"===l&&L._addSquareCap(e,l,k,null,i,o,!0),!f.isEmpty()){var s;return f.contains(t)||(s=f.getNearestLocation(t))&&r(s.getPoint(),w)}}var u,l,c,f,d,_,g=this,v=this.getStyle(),p=this._segments,m=p.length,y=this._closed,w=e._tolerancePadding,x=w,b=e.stroke&&v.hasStroke(),C=e.fill&&v.hasFill(),S=e.curves,k=b?v.getStrokeWidth()/2:C&&e.tolerance>0||S?0:null;if(null!==k&&(k>0?(u=v.getStrokeJoin(),l=v.getStrokeCap(),c=v.getMiterLimit(),x=x.add(L._getStrokePadding(k,i))):u=l="round"),!e.ends||e.segments||y){if(e.segments||e.handles)for(var I=0;I<m;I++)if(_=a(p[I]))return _}else if(_=a(p[0],!0)||a(p[m-1],!0))return _;if(null!==k){if(d=this.getNearestLocation(t)){var T=d.getTime();0===T||1===T&&m>1?h(d.getSegment())||(d=null):r(d.getPoint(),x)||(d=null)}if(!d&&"miter"===u&&m>1)for(var I=0;I<m;I++){var M=p[I];if(t.getDistance(M._point)<=c*k&&h(M)){d=M.getLocation();break}}}return!d&&C&&this._contains(t)||d&&!b&&!S?new P("fill",this):d?new P(b?"stroke":"curve",this,{location:d,point:d.getPoint()}):null}},r.each(A._evaluateMethods,function(t){this[t+"At"]=function(e){var n=this.getLocationAt(e);return n&&n[t]()}},{beans:!1,getLocationOf:function(){for(var t=c.read(arguments),e=this.getCurves(),n=0,i=e.length;n<i;n++){var r=e[n].getLocationOf(t);if(r)return r}return null},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getLocationAt:function(t){if("number"==typeof t){for(var e=this.getCurves(),n=0,i=0,r=e.length;i<r;i++){var s=n,a=e[i];if(n+=a.getLength(),n>t)return a.getLocationAt(t-s)}if(e.length>0&&t<=this.getLength())return new O(e[e.length-1],1)}else if(t&&t.getPath&&t.getPath()===this)return t;return null},getOffsetsWithTangent:function(){var t=c.read(arguments);if(t.isZero())return[];for(var e=[],n=0,i=this.getCurves(),r=0,s=i.length;r<s;r++){for(var a=i[r],o=a.getTimesWithTangent(t),h=0,u=o.length;h<u;h++){var l=n+a.getOffsetAtTime(o[h]);e.indexOf(l)<0&&e.push(l)}n+=a.length}return e}}),new function(){function t(t,e,n,i){function r(e){var n=h[e],i=h[e+1];s==n&&a==i||(t.beginPath(),t.moveTo(s,a),t.lineTo(n,i),t.stroke(),t.beginPath(),t.arc(n,i,o,0,2*Math.PI,!0),t.fill())}for(var s,a,o=i/2,h=new Array(6),u=0,l=e.length;u<l;u++){var c=e[u],f=c._selection;if(c._transformCoordinates(n,h),s=h[0],a=h[1],2&f&&r(2),4&f&&r(4),t.fillRect(s-o,a-o,i,i),!(1&f)){var d=t.fillStyle;t.fillStyle="#ffffff",t.fillRect(s-o+1,a-o+1,i-2,i-2),t.fillStyle=d}}}function e(t,e,n){function i(e){if(n)e._transformCoordinates(n,_),r=_[0],s=_[1];else{var i=e._point;r=i._x,s=i._y}if(g)t.moveTo(r,s),g=!1;else{if(n)h=_[2],u=_[3];else{var f=e._handleIn;h=r+f._x,u=s+f._y}h===r&&u===s&&l===a&&c===o?t.lineTo(r,s):t.bezierCurveTo(l,c,h,u,r,s)}if(a=r,o=s,n)l=_[4],c=_[5];else{var f=e._handleOut;l=a+f._x,c=o+f._y}}for(var r,s,a,o,h,u,l,c,f=e._segments,d=f.length,_=new Array(6),g=!0,v=0;v<d;v++)i(f[v]);e._closed&&d>0&&i(f[0])}return{_draw:function(t,n,i,r){function s(t){return c[(t%f+f)%f]}var a=n.dontStart,o=n.dontFinish||n.clip,h=this.getStyle(),u=h.hasFill(),l=h.hasStroke(),c=h.getDashArray(),f=!st.support.nativeDash&&l&&c&&c.length;if(a||t.beginPath(),(u||l&&!f||o)&&(e(t,this,r),this._closed&&t.closePath()),!o&&(u||l)&&(this._setStyles(t,n,i),u&&(t.fill(h.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),l)){if(f){a||t.beginPath();var d,_=new N(this,.25,32,(!1),r),g=_.length,v=-h.getDashOffset(),p=0;for(v%=g;v>0;)v-=s(p--)+s(p--);for(;v<g;)d=v+s(p++),(v>0||d>0)&&_.drawPart(t,Math.max(v,0),Math.max(d,0)),v=d+s(p++)}t.stroke()}},_drawSelected:function(n,i){n.beginPath(),e(n,this,i),n.stroke(),t(n,this._segments,i,st.settings.handleSize)}}},new function(){function t(t){var e=t._segments;if(!e.length)throw new Error("Use a moveTo() command first");return e[e.length-1]}return{moveTo:function(){var t=this._segments;1===t.length&&this.removeSegment(0),t.length||this._add([new T(c.read(arguments))])},moveBy:function(){throw new Error("moveBy() is unsupported on Path items.")},lineTo:function(){this._add([new T(c.read(arguments))])},cubicCurveTo:function(){var e=c.read(arguments),n=c.read(arguments),i=c.read(arguments),r=t(this);r.setHandleOut(e.subtract(r._point)),this._add([new T(i,n.subtract(i))])},quadraticCurveTo:function(){var e=c.read(arguments),n=c.read(arguments),i=t(this)._point;this.cubicCurveTo(e.add(i.subtract(e).multiply(1/3)),e.add(n.subtract(e).multiply(1/3)),n)},curveTo:function(){var e=c.read(arguments),n=c.read(arguments),i=r.pick(r.read(arguments),.5),s=1-i,a=t(this)._point,o=e.subtract(a.multiply(s*s)).subtract(n.multiply(i*i)).divide(2*i*s);
if(o.isNaN())throw new Error("Cannot put a curve through points with parameter = "+i);this.quadraticCurveTo(o,n)},arcTo:function(){var e,n,i,s,a,o=Math.abs,h=Math.sqrt,l=t(this),f=l._point,_=c.read(arguments),g=r.peek(arguments),v=r.pick(g,!0);if("boolean"==typeof v)var y=f.add(_).divide(2),e=y.add(y.subtract(f).rotate(v?-90:90));else if(r.remain(arguments)<=2)e=_,_=c.read(arguments);else{var w=d.read(arguments),x=u.isZero;if(x(w.width)||x(w.height))return this.lineTo(_);var b=r.read(arguments),v=!!r.read(arguments),C=!!r.read(arguments),y=f.add(_).divide(2),S=f.subtract(y).rotate(-b),k=S.x,I=S.y,P=o(w.width),M=o(w.height),A=P*P,O=M*M,z=k*k,L=I*I,E=h(z/A+L/O);if(E>1&&(P*=E,M*=E,A=P*P,O=M*M),E=(A*O-A*L-O*z)/(A*L+O*z),o(E)<1e-12&&(E=0),E<0)throw new Error("Cannot create an arc with the given arguments");n=new c(P*I/M,-M*k/P).multiply((C===v?-1:1)*h(E)).rotate(b).add(y),a=(new p).translate(n).rotate(b).scale(P,M),s=a._inverseTransform(f),i=s.getDirectedAngle(a._inverseTransform(_)),!v&&i>0?i-=360:v&&i<0&&(i+=360)}if(e){var N=new m(f.add(e).divide(2),e.subtract(f).rotate(90),(!0)),B=new m(e.add(_).divide(2),_.subtract(e).rotate(90),(!0)),F=new m(f,_),j=F.getSide(e);if(n=N.intersect(B,!0),!n){if(!j)return this.lineTo(_);throw new Error("Cannot create an arc with the given arguments")}s=f.subtract(n),i=s.getDirectedAngle(_.subtract(n));var D=F.getSide(n,!0);0===D?i=j*o(i):j===D&&(i+=i<0?360:-360)}for(var R=1e-7,q=o(i),V=q>=360?4:Math.ceil((q-R)/90),U=i/V,H=U*Math.PI/360,Z=4/3*Math.sin(H)/(1+Math.cos(H)),W=[],$=0;$<=V;$++){var S=_,G=null;if($<V&&(G=s.rotate(90).multiply(Z),a?(S=a._transformPoint(s),G=a._transformPoint(s.add(G)).subtract(S)):S=n.add(s)),$){var J=s.rotate(-90).multiply(Z);a&&(J=a._transformPoint(s.add(J)).subtract(S)),W.push(new T(S,J,G))}else l.setHandleOut(G);s=s.rotate(U)}this._add(W)},lineBy:function(){var e=c.read(arguments),n=t(this)._point;this.lineTo(n.add(e))},curveBy:function(){var e=c.read(arguments),n=c.read(arguments),i=r.read(arguments),s=t(this)._point;this.curveTo(s.add(e),s.add(n),i)},cubicCurveBy:function(){var e=c.read(arguments),n=c.read(arguments),i=c.read(arguments),r=t(this)._point;this.cubicCurveTo(r.add(e),r.add(n),r.add(i))},quadraticCurveBy:function(){var e=c.read(arguments),n=c.read(arguments),i=t(this)._point;this.quadraticCurveTo(i.add(e),i.add(n))},arcBy:function(){var e=t(this)._point,n=e.add(c.read(arguments)),i=r.pick(r.peek(arguments),!0);"boolean"==typeof i?this.arcTo(n,i):this.arcTo(n,e.add(c.read(arguments)))},closePath:function(t){this.setClosed(!0),this.join(this,t)}}},{_getBounds:function(t,e){var n=e.handle?"getHandleBounds":e.stroke?"getStrokeBounds":"getBounds";return L[n](this._segments,this._closed,this,t,e)},statics:{getBounds:function(t,e,n,i,r,s){function a(t){t._transformCoordinates(i,h);for(var e=0;e<2;e++)A._addBounds(u[e],u[e+4],h[e+2],h[e],e,s?s[e]:0,l,c,f);var n=u;u=h,h=n}var o=t[0];if(!o)return new g;for(var h=new Array(6),u=o._transformCoordinates(i,new Array(6)),l=u.slice(0,2),c=l.slice(),f=new Array(2),d=1,_=t.length;d<_;d++)a(t[d]);return e&&a(o),new g(l[0],l[1],c[0]-l[0],c[1]-l[1])},getStrokeBounds:function(t,e,n,i,r){function s(t){v=v.include(t)}function a(t){v=v.unite(x.setCenter(t._point.transform(i)))}function o(t,e){"round"===e||t.isSmooth()?a(t):L._addBevelJoin(t,e,p,w,i,f,s)}function h(t,e){"round"===e?a(t):L._addSquareCap(t,e,p,i,f,s)}var u=n.getStyle(),l=u.hasStroke(),c=u.getStrokeWidth(),f=l&&n._getStrokeMatrix(i,r),_=l&&L._getStrokePadding(c,f),v=L.getBounds(t,e,n,i,r,_);if(!l)return v;for(var p=c/2,m=u.getStrokeJoin(),y=u.getStrokeCap(),w=u.getMiterLimit(),x=new g(new d(_)),b=t.length-(e?0:1),C=1;C<b;C++)o(t[C],m);return e?o(t[0],m):b>0&&(h(t[0],y),h(t[t.length-1],y)),v},_getStrokePadding:function(t,e){if(!e)return[t,t];var n=new c(t,0).transform(e),i=new c(0,t).transform(e),r=n.getAngleInRadians(),s=n.getLength(),a=i.getLength(),o=Math.sin(r),h=Math.cos(r),u=Math.tan(r),l=Math.atan2(a*u,s),f=Math.atan2(a,u*s);return[Math.abs(s*Math.cos(l)*h+a*Math.sin(l)*o),Math.abs(a*Math.sin(f)*h+s*Math.cos(f)*o)]},_addBevelJoin:function(t,e,n,i,r,s,a,o){var h=t.getCurve(),u=h.getPrevious(),l=h.getPoint1().transform(r),f=u.getNormalAtTime(1).multiply(n).transform(s),d=h.getNormalAtTime(0).multiply(n).transform(s);if(f.getDirectedAngle(d)<0&&(f=f.negate(),d=d.negate()),o&&a(l),a(l.add(f)),"miter"===e){var _=new m(l.add(f),new c((-f.y),f.x),(!0)).intersect(new m(l.add(d),new c((-d.y),d.x),(!0)),!0);_&&l.getDistance(_)<=i*n&&a(_)}a(l.add(d))},_addSquareCap:function(t,e,n,i,r,s,a){var o=t._point.transform(i),h=t.getLocation(),u=h.getNormal().multiply(0===h.getTime()?n:-n).transform(r);"square"===e&&(a&&(s(o.subtract(u)),s(o.add(u))),o=o.add(u.rotate(-90))),s(o.add(u)),s(o.subtract(u))},getHandleBounds:function(t,e,n,i,r){var s,a,o=n.getStyle(),h=r.stroke&&o.hasStroke();if(h){var u=n._getStrokeMatrix(i,r),l=o.getStrokeWidth()/2,c=l;"miter"===o.getStrokeJoin()&&(c=l*o.getMiterLimit()),"square"===o.getStrokeCap()&&(c=Math.max(c,l*Math.SQRT2)),s=L._getStrokePadding(l,u),a=L._getStrokePadding(c,u)}for(var f=new Array(6),d=1/0,_=-d,v=d,p=_,m=0,y=t.length;m<y;m++){var w=t[m];w._transformCoordinates(i,f);for(var x=0;x<6;x+=2){var b=x?s:a,C=b?b[0]:0,S=b?b[1]:0,k=f[x],I=f[x+1],P=k-C,T=k+C,M=I-S,A=I+S;P<d&&(d=P),T>_&&(_=T),M<v&&(v=M),A>p&&(p=A)}}return new g(d,v,_-d,p-v)}}});L.inject({statics:new function(){function t(t,e,n){var i=r.getNamed(n),s=new L(i&&0==i.insert&&w.NO_INSERT);return s._add(t),s._closed=e,s.set(i,{insert:!0})}function e(e,n,r){for(var s=new Array(4),a=0;a<4;a++){var o=i[a];s[a]=new T(o._point.multiply(n).add(e),o._handleIn.multiply(n),o._handleOut.multiply(n))}return t(s,!0,r)}var n=.5522847498307936,i=[new T([-1,0],[0,n],[0,-n]),new T([0,-1],[-n,0],[n,0]),new T([1,0],[0,-n],[0,n]),new T([0,1],[n,0],[-n,0])];return{Line:function(){return t([new T(c.readNamed(arguments,"from")),new T(c.readNamed(arguments,"to"))],!1,arguments)},Circle:function(){var t=c.readNamed(arguments,"center"),n=r.readNamed(arguments,"radius");return e(t,new d(n),arguments)},Rectangle:function(){var e,i=g.readNamed(arguments,"rectangle"),r=d.readNamed(arguments,"radius",0,{readNull:!0}),s=i.getBottomLeft(!0),a=i.getTopLeft(!0),o=i.getTopRight(!0),h=i.getBottomRight(!0);if(!r||r.isZero())e=[new T(s),new T(a),new T(o),new T(h)];else{r=d.min(r,i.getSize(!0).divide(2));var u=r.width,l=r.height,c=u*n,f=l*n;e=[new T(s.add(u,0),null,[-c,0]),new T(s.subtract(0,l),[0,f]),new T(a.add(0,l),null,[0,-f]),new T(a.add(u,0),[-c,0],null),new T(o.subtract(u,0),null,[c,0]),new T(o.add(0,l),[0,-f],null),new T(h.subtract(0,l),null,[0,f]),new T(h.subtract(u,0),[c,0])]}return t(e,!0,arguments)},RoundRectangle:"#Rectangle",Ellipse:function(){var t=C._readEllipse(arguments);return e(t.center,t.radius,arguments)},Oval:"#Ellipse",Arc:function(){var t=c.readNamed(arguments,"from"),e=c.readNamed(arguments,"through"),n=c.readNamed(arguments,"to"),i=r.getNamed(arguments),s=new L(i&&0==i.insert&&w.NO_INSERT);return s.moveTo(t),s.arcTo(e,n),s.set(i)},RegularPolygon:function(){for(var e=c.readNamed(arguments,"center"),n=r.readNamed(arguments,"sides"),i=r.readNamed(arguments,"radius"),s=360/n,a=n%3===0,o=new c(0,a?-i:i),h=a?-1:.5,u=new Array(n),l=0;l<n;l++)u[l]=new T(e.add(o.rotate((l+h)*s)));return t(u,!0,arguments)},Star:function(){for(var e=c.readNamed(arguments,"center"),n=2*r.readNamed(arguments,"points"),i=r.readNamed(arguments,"radius1"),s=r.readNamed(arguments,"radius2"),a=360/n,o=new c(0,(-1)),h=new Array(n),u=0;u<n;u++)h[u]=new T(e.add(o.rotate(a*u).multiply(u%2?s:i)));return t(h,!0,arguments)}}}});var E=z.extend({_class:"CompoundPath",_serializeFields:{children:[]},beans:!0,initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||("string"==typeof t?this.setPathData(t):this.addChildren(Array.isArray(t)?t:arguments))},insertChildren:function xt(t,e){var n=e,i=n[0];i&&"number"==typeof i[0]&&(n=[n]);for(var s=e.length-1;s>=0;s--){var a=n[s];n!==e||a instanceof L||(n=r.slice(n)),Array.isArray(a)?n[s]=new L({segments:a,insert:!1}):a instanceof E&&(n.splice.apply(n,[s,1].concat(a.removeChildren())),a.remove())}return xt.base.call(this,t,n)},reduce:function bt(t){for(var e=this._children,n=e.length-1;n>=0;n--){var i=e[n].reduce(t);i.isEmpty()&&i.remove()}if(!e.length){var i=new L(w.NO_INSERT);return i.copyAttributes(this),i.insertAbove(this),this.remove(),i}return bt.base.call(this)},isClosed:function(){for(var t=this._children,e=0,n=t.length;e<n;e++)if(!t[e]._closed)return!1;return!0},setClosed:function(t){for(var e=this._children,n=0,i=e.length;n<i;n++)e[n].setClosed(t)},getFirstSegment:function(){var t=this.getFirstChild();return t&&t.getFirstSegment()},getLastSegment:function(){var t=this.getLastChild();return t&&t.getLastSegment()},getCurves:function(){for(var t=this._children,e=[],n=0,i=t.length;n<i;n++)r.push(e,t[n].getCurves());return e},getFirstCurve:function(){var t=this.getFirstChild();return t&&t.getFirstCurve()},getLastCurve:function(){var t=this.getLastChild();return t&&t.getLastCurve()},getArea:function(){for(var t=this._children,e=0,n=0,i=t.length;n<i;n++)e+=t[n].getArea();return e},getLength:function(){for(var t=this._children,e=0,n=0,i=t.length;n<i;n++)e+=t[n].getLength();return e},getPathData:function(t,e){for(var n=this._children,i=[],r=0,s=n.length;r<s;r++){var a=n[r],o=a._matrix;i.push(a.getPathData(t&&!o.isIdentity()?t.appended(o):t,e))}return i.join("")},_hitTestChildren:function Ct(t,e,n){return Ct.base.call(this,t,e["class"]===L||"path"===e.type?e:r.set({},e,{fill:!1}),n)},_draw:function(t,e,n,i){var r=this._children;if(r.length){e=e.extend({dontStart:!0,dontFinish:!0}),t.beginPath();for(var s=0,a=r.length;s<a;s++)r[s].draw(t,e,i);if(!e.clip){this._setStyles(t,e,n);var o=this._style;o.hasFill()&&(t.fill(o.getFillRule()),t.shadowColor="rgba(0,0,0,0)"),o.hasStroke()&&t.stroke()}}},_drawSelected:function(t,e,n){for(var i=this._children,r=0,s=i.length;r<s;r++){var a=i[r],o=a._matrix;n[a._id]||a._drawSelected(t,o.isIdentity()?e:e.appended(o))}}},new function(){function t(t,e){var n=t._children;if(e&&!n.length)throw new Error("Use a moveTo() command first");return n[n.length-1]}return r.each(["lineTo","cubicCurveTo","quadraticCurveTo","curveTo","arcTo","lineBy","cubicCurveBy","quadraticCurveBy","curveBy","arcBy"],function(e){this[e]=function(){var n=t(this,!0);n[e].apply(n,arguments)}},{moveTo:function(){var e=t(this),n=e&&e.isEmpty()?e:new L(w.NO_INSERT);n!==e&&this.addChild(n),n.moveTo.apply(n,arguments)},moveBy:function(){var e=t(this,!0),n=e&&e.getLastSegment(),i=c.read(arguments);this.moveTo(n?i.add(n._point):i)},closePath:function(e){t(this,!0).closePath(e)}})},r.each(["reverse","flatten","simplify","smooth"],function(t){this[t]=function(e){for(var n,i=this._children,r=0,s=i.length;r<s;r++)n=i[r][t](e)||n;return n}},{}));z.inject(new function(){function t(t,e){var n=t.clone(!1).reduce({simplify:!0}).transform(null,!0,!0);return e?n.resolveCrossings().reorient("nonzero"===n.getFillRule(),!0):n}function n(t,e,n,i,r){var s=new E(w.NO_INSERT);return s.addChildren(t,!0),s=s.reduce({simplify:e}),r&&0==r.insert||s.insertAbove(i&&n.isSibling(i)&&n.getIndex()<i.getIndex()?i:n),s.copyAttributes(n,!0),s}function i(e,i,a,o){function u(t){for(var e=0,n=t.length;e<n;e++){var i=t[e];r.push(x,i._segments),r.push(b,i.getCurves()),i._overlapsOnly=!0}}if(o&&(0==o.trace||o.stroke)&&/^(subtract|intersect)$/.test(a))return s(e,i,a);var c=t(e,!0),_=i&&e!==i&&t(i,!0),g=p[a];g[a]=!0,_&&(g.subtract||g.exclude)^(_.isClockwise()^c.isClockwise())&&_.reverse();var v,m=l(O.expand(c.getCrossings(_))),y=c._children||[c],w=_&&(_._children||[_]),x=[],b=[];if(m.length){u(y),w&&u(w);for(var C=0,S=m.length;C<S;C++)f(m[C]._segment,c,_,b,g);for(var C=0,S=x.length;C<S;C++){var k=x[C],I=k._intersection;k._winding||f(k,c,_,b,g),I&&I._overlap||(k._path._overlapsOnly=!1)}v=d(x,g)}else v=h(w?y.concat(w):y.slice(),function(t){return!!g[t]});return n(v,!0,e,i,o)}function s(e,i,r){function s(t){if(!c[t._id]&&(l||o.contains(t.getPointAt(t.getLength()/2))^u))return f.unshift(t),c[t._id]=!0}for(var a=t(e),o=t(i),h=a.getCrossings(o),u="subtract"===r,l="divide"===r,c={},f=[],d=h.length-1;d>=0;d--){var _=h[d].split();_&&(s(_)&&_.getFirstSegment().setHandleIn(0,0),a.getLastSegment().setHandleOut(0,0))}return s(a),n(f,!1,e,i)}function a(t,e){for(var n=t;n;){if(n===e)return;n=n._previous}for(;t._next&&t._next!==e;)t=t._next;if(!t._next){for(;e._previous;)e=e._previous;t._next=e,e._previous=t}}function o(t){for(var e=t.length-1;e>=0;e--)t[e].clearHandles()}function h(t,e,n){var i=t&&t.length;if(i){var s=r.each(t,function(t,e){this[t._id]={container:null,winding:t.isClockwise()?1:-1,index:e}},{}),a=t.slice().sort(function(t,e){return v(e.getArea())-v(t.getArea())}),o=a[0];null==n&&(n=o.isClockwise());for(var h=0;h<i;h++){for(var u=a[h],l=s[u._id],c=u.getInteriorPoint(),f=0,d=h-1;d>=0;d--){var _=a[d];if(_.contains(c)){var g=s[_._id];f=g.winding,l.winding+=f,l.container=g.exclude?g.container:_;break}}if(e(l.winding)===e(f))l.exclude=!0,t[l.index]=null;else{var p=l.container;u.setClockwise(p?!p.isClockwise():n)}}}return t}function l(t,e,n){function i(t){return t._path._id+"."+t._segment1._index}for(var r,s,h,u=e&&[],l=1e-8,c=1-l,f=!1,d=n||[],_=n&&{},g=(n&&n.length)-1;g>=0;g--){var v=n[g];v._path&&(_[i(v)]=!0)}for(var g=t.length-1;g>=0;g--){var p,m=t[g],y=m._time,w=y,x=e&&!e(m),v=m._curve;if(v&&(v!==s?(f=!v.hasHandles()||_&&_[i(v)],r=[],h=null,s=v):h>=l&&(y/=h)),x)r&&r.push(m);else{if(e&&u.unshift(m),h=w,y<l)p=v._segment1;else if(y>c)p=v._segment2;else{var b=v.divideAtTime(y,!0);f&&d.push(v,b),p=b._segment1;for(var C=r.length-1;C>=0;C--){var S=r[C];S._time=(S._time-y)/(1-y)}}m._setSegment(p);var k=p._intersection,I=m._intersection;if(k){a(k,I);for(var P=k;P;)a(P._intersection,k),P=P._next}else p._intersection=I}}return n||o(d),u||t}function c(t,e,n,i,r){function s(s){var a=s[l+0],h=s[l+6];if(!(p<_(a,h)||p>g(a,h))){var f=s[u+0],v=s[u+2],m=s[u+4],b=s[u+6];if(a===h)return void((f<x&&b>w||b<x&&f>w)&&(I=!0));var C=p===a?0:p===h?1:w>g(f,v,m,b)||x<_(f,v,m,b)?1:A.solveCubic(s,l,p,M,0,1)>0?M[0]:1,P=0===C?f:1===C?b:A.getPoint(s,C)[n?"y":"x"],O=a>h?1:-1,z=o[l]>o[l+6]?1:-1,L=o[u+6];return p!==a?(P<w?S+=O:P>x?k+=O:I=!0,P>d-y&&P<d+y&&(T/=2)):(O!==z?f<w?S+=O:f>x&&(k+=O):f!=L&&(L<x&&P>x?(k+=O,I=!0):L>w&&P<w&&(S+=O,I=!0)),T=0),o=s,!r&&P>w&&P<x&&0===A.getTangent(s,C)[n?"x":"y"]&&c(t,e,!n,i,!0)}}function a(t){var e=t[l+0],i=t[l+2],r=t[l+4],a=t[l+6];if(p<=g(e,i,r,a)&&p>=_(e,i,r,a))for(var o,h=t[u+0],c=t[u+2],f=t[u+4],d=t[u+6],v=w>g(h,c,f,d)||x<_(h,c,f,d)?[t]:A.getMonoCurves(t,n),m=0,y=v.length;m<y;m++)if(o=s(v[m]))return o}for(var o,h,u=n?1:0,l=1^u,f=[t.x,t.y],d=f[u],p=f[l],m=1e-9,y=1e-6,w=d-m,x=d+m,b=0,C=0,S=0,k=0,I=!1,P=!1,T=1,M=[],O=0,z=e.length;O<z;O++){var L,E=e[O],N=E._path,B=E.getValues();if(!(O&&e[O-1]._path===N||(o=null,N._closed||(h=A.getValues(N.getLastCurve().getSegment2(),E.getSegment1(),null,!i),h[l]!==h[l+6]&&(o=h)),o))){o=B;for(var F=N.getLastCurve();F&&F!==E;){var j=F.getValues();if(j[l]!==j[l+6]){o=j;break}F=F.getPrevious()}}if(L=a(B))return L;if(O+1===z||e[O+1]._path!==N){if(h&&(L=a(h)))return L;!I||S||k||(S=k=N.isClockwise(i)^n?1:-1),b+=S,C+=k,S=k=0,I&&(P=!0,I=!1),h=null}}return b=v(b),C=v(C),{winding:g(b,C),windingL:b,windingR:C,quality:T,onPath:P}}function f(t,e,n,i,r){var s,a=[],o=t,h=0;do{var l=t.getCurve(),f=l.getLength();a.push({segment:t,curve:l,length:f}),h+=f,t=t.getNext()}while(t&&!t._intersection&&t!==o);for(var d=[.5,.25,.75],s={winding:0,quality:-1},_=1e-8,g=1-_,p=0;p<d.length&&s.quality<.5;p++)for(var f=h*d[p],m=0,y=a.length;m<y;m++){var w=a[m],x=w.length;if(f<=x){var l=w.curve,b=l._path,C=b._parent,S=C instanceof E?C:b,k=u.clamp(l.getTimeAt(f),_,g),I=l.getPointAtTime(k),P=v(l.getTangentAtTime(k).y)<Math.SQRT1_2,T=null;if(r.subtract&&n){var M=S===e?n._getWinding(I,P,!0):e._getWinding(I,P,!0);if(S===e&&M.winding||S===n&&!M.winding){if(M.quality<1)continue;T={winding:0,quality:1}}}T=T||c(I,i,P,!0),T.quality>s.quality&&(s=T);break}f-=x}for(var m=a.length-1;m>=0;m--)a[m].segment._winding=s}function d(t,e){function n(t){var n;return!(!t||t._visited||e&&(!e[(n=t._winding||{}).winding]||e.unite&&2===n.winding&&n.windingL&&n.windingR))}function i(t){if(t)for(var e=0,n=a.length;e<n;e++)if(t===a[e])return!0;return!1}function r(t){for(var e=t._segments,n=0,i=e.length;n<i;n++)e[n]._visited=!0}function s(t,e){function r(r,s){for(;r&&r!==s;){var o=r._segment,u=o&&o._path;if(u){var l=o.getNext()||u.getFirstSegment(),c=l._intersection;o!==t&&(i(o)||i(l)||l&&n(o)&&(n(l)||c&&n(c._segment)))&&h.push(o),e&&a.push(o)}r=r._next}}var s=t._intersection,o=s,h=[];if(e&&(a=[t]),s){for(r(s);s&&s._prev;)s=s._prev;r(s,o)}return h}var a,o=[];t.sort(function(t,e){var n=t._intersection,i=e._intersection,r=!(!n||!n._overlap),s=!(!i||!i._overlap),a=t._path,o=e._path;return r^s?r?1:-1:!n^!i?n?1:-1:a!==o?a._id-o._id:t._index-e._index});for(var h=0,u=t.length;h<u;h++){var l,c,f,d=t[h],_=n(d),g=null,v=!1,p=!0,m=[];if(_&&d._path._overlapsOnly){var y=d._path,x=d._intersection._segment._path;y.compare(x)&&(y.getArea()&&o.push(y.clone(!1)),r(y),r(x),_=!1)}for(;_;){var b=!g,C=s(d,b),S=C.shift(),v=!b&&(i(d)||i(S)),k=!v&&S;if(b&&(g=new L(w.NO_INSERT),l=null),v){(d.isFirst()||d.isLast())&&(p=d._path._closed),d._visited=!0;break}if(k&&l&&(m.push(l),l=null),l||(k&&C.push(d),l={start:g._segments.length,crossings:C,visited:c=[],handleIn:f}),k&&(d=S),!n(d)){g.removeSegments(l.start);for(var I=0,P=c.length;I<P;I++)c[I]._visited=!1;c.length=0;do d=l&&l.crossings.shift(),d&&d._path||(d=null,l=m.pop(),l&&(c=l.visited,f=l.handleIn));while(l&&!n(d));if(!d)break}var M=d.getNext();g.add(new T(d._point,f,M&&d._handleOut)),d._visited=!0,c.push(d),d=M||d._path.getFirstSegment(),f=M&&M._handleIn}v&&(p&&(g.getFirstSegment().setHandleIn(f),g.setClosed(p)),0!==g.getArea()&&o.push(g))}return o}var _=Math.min,g=Math.max,v=Math.abs,p={unite:{1:!0,2:!0},intersect:{2:!0},subtract:{1:!0},exclude:{1:!0,"-1":!0}};return{_getWinding:function(t,e,n){return c(t,this.getCurves(),e,n)},unite:function(t,e){return i(this,t,"unite",e)},intersect:function(t,e){return i(this,t,"intersect",e)},subtract:function(t,e){return i(this,t,"subtract",e)},exclude:function(t,e){return i(this,t,"exclude",e)},divide:function(t,e){return e&&(0==e.trace||e.stroke)?s(this,t,"divide"):n([this.subtract(t,e),this.intersect(t,e)],!0,this,t,e)},resolveCrossings:function(){function t(t,e){var n=t&&t._intersection;return n&&n._overlap&&n._path===e}var e=this._children,n=e||[this],i=!1,s=!1,a=this.getIntersections(null,function(t){return t.hasOverlap()&&(i=!0)||t.isCrossing()&&(s=!0)}),h=i&&s&&[];if(a=O.expand(a),i)for(var u=l(a,function(t){return t.hasOverlap()},h),c=u.length-1;c>=0;c--){var f=u[c],_=f._path,g=f._segment,v=g.getPrevious(),p=g.getNext();t(v,_)&&t(p,_)&&(g.remove(),v._handleOut._set(0,0),p._handleIn._set(0,0),v===g||v.getCurve().hasLength()||(p._handleIn.set(v._handleIn),v.remove()))}s&&(l(a,i&&function(t){var e=t.getCurve(),n=t.getSegment(),i=t._intersection,r=i._curve,s=i._segment;return!!(e&&r&&e._path&&r._path)||(n&&(n._intersection=null),void(s&&(s._intersection=null)))},h),h&&o(h),n=d(r.each(n,function(t){r.push(this,t._segments)},[])));var m,y=n.length;return y>1&&e?(n!==e&&this.setChildren(n),m=this):1!==y||e||(n[0]!==this&&this.setSegments(n[0].removeSegments()),m=this),m||(m=new E(w.NO_INSERT),m.addChildren(n),m=m.reduce(),m.copyAttributes(this),this.replaceWith(m)),m},reorient:function(t,n){var i=this._children;return i&&i.length?this.setChildren(h(this.removeChildren(),function(e){return!!(t?e:1&e)},n)):n!==e&&this.setClockwise(n),this},getInteriorPoint:function(){var t=this.getBounds(),e=t.getCenter(!0);if(!this.contains(e)){for(var n=this.getCurves(),i=e.y,r=[],s=[],a=0,o=n.length;a<o;a++){var h=n[a].getValues(),u=h[1],l=h[3],c=h[5],f=h[7];if(i>=_(u,l,c,f)&&i<=g(u,l,c,f))for(var d=A.getMonoCurves(h),v=0,p=d.length;v<p;v++){var m=d[v],y=m[1],w=m[7];if(y!==w&&(i>=y&&i<=w||i>=w&&i<=y)){var x=i===y?m[0]:i===w?m[6]:1===A.solveCubic(m,1,i,s,0,1)?A.getPoint(m,s[0]).x:(m[0]+m[6])/2;r.push(x)}}}r.length>1&&(r.sort(function(t,e){return t-e}),e.x=(r[0]+r[1])/2)}return e}}});var N=r.extend({_class:"PathFlattener",initialize:function(t,e,n,i,r){function s(t,e){var n=A.getValues(t,e,r);h.push(n),a(n,t._index,0,1)}function a(t,n,r,s){if(!(s-r>c)||i&&A.isStraight(t)||A.isFlatEnough(t,e||.25)){var o=t[6]-t[0],h=t[7]-t[1],f=Math.sqrt(o*o+h*h);f>0&&(l+=f,u.push({offset:l,curve:t,index:n,time:s}))}else{var d=A.subdivide(t,.5),_=(r+s)/2;a(d[0],n,r,_),a(d[1],n,_,s)}}for(var o,h=[],u=[],l=0,c=1/(n||32),f=t._segments,d=f[0],_=1,g=f.length;_<g;_++)o=f[_],s(d,o),d=o;t._closed&&s(o||d,f[0]),this.curves=h,this.parts=u,this.length=l,this.index=0},_get:function(t){for(var e,n=this.parts,i=n.length,r=this.index;e=r,r&&!(n[--r].offset<t););for(;e<i;e++){var s=n[e];if(s.offset>=t){this.index=e;var a=n[e-1],o=a&&a.index===s.index?a.time:0,h=a?a.offset:0;return{index:s.index,time:o+(s.time-o)*(t-h)/(s.offset-h)}}}return{index:n[i-1].index,time:1}},drawPart:function(t,e,n){for(var i=this._get(e),r=this._get(n),s=i.index,a=r.index;s<=a;s++){var o=A.getPart(this.curves[s],s===i.index?i.time:0,s===r.index?r.time:1);s===i.index&&t.moveTo(o[0],o[1]),t.bezierCurveTo.apply(t,o.slice(2))}}},r.each(A._evaluateMethods,function(t){this[t+"At"]=function(e){var n=this._get(e);return A[t](this.curves[n.index],n.time)}},{})),B=r.extend({initialize:function(t){for(var e,n=this.points=[],i=t._segments,r=t._closed,s=0,a=i.length;s<a;s++){var o=i[s].point;e&&e.equals(o)||n.push(e=o.clone())}r&&(n.unshift(n[n.length-1]),n.push(n[1])),this.closed=r},fit:function(t){var e=this.points,n=e.length,i=null;return n>0&&(i=[new T(e[0])],n>1&&(this.fitCubic(i,t,0,n-1,e[1].subtract(e[0]),e[n-2].subtract(e[n-1])),this.closed&&(i.shift(),i.pop()))),i},fitCubic:function(t,e,n,i,r,s){var a=this.points;if(i-n===1){var o=a[n],h=a[i],u=o.getDistance(h)/3;return void this.addCurve(t,[o,o.add(r.normalize(u)),h.add(s.normalize(u)),h])}for(var l,c=this.chordLengthParameterize(n,i),f=Math.max(e,e*e),d=!0,_=0;_<=4;_++){var g=this.generateBezier(n,i,c,r,s),v=this.findMaxError(n,i,g,c);if(v.error<e&&d)return void this.addCurve(t,g);if(l=v.index,v.error>=f)break;d=this.reparameterize(n,i,c,g),f=v.error}var p=a[l-1].subtract(a[l+1]);this.fitCubic(t,e,n,l,r,p),this.fitCubic(t,e,l,i,p.negate(),s)},addCurve:function(t,e){var n=t[t.length-1];n.setHandleOut(e[1].subtract(e[0])),t.push(new T(e[3],e[2].subtract(e[3])))},generateBezier:function(t,e,n,i,r){for(var s=1e-12,a=Math.abs,o=this.points,h=o[t],u=o[e],l=[[0,0],[0,0]],c=[0,0],f=0,d=e-t+1;f<d;f++){var _=n[f],g=1-_,v=3*_*g,p=g*g*g,m=v*g,y=v*_,w=_*_*_,x=i.normalize(m),b=r.normalize(y),C=o[t+f].subtract(h.multiply(p+m)).subtract(u.multiply(y+w));l[0][0]+=x.dot(x),l[0][1]+=x.dot(b),l[1][0]=l[0][1],l[1][1]+=b.dot(b),c[0]+=x.dot(C),c[1]+=b.dot(C)}var S,k,I=l[0][0]*l[1][1]-l[1][0]*l[0][1];if(a(I)>s){var P=l[0][0]*c[1]-l[1][0]*c[0],T=c[0]*l[1][1]-c[1]*l[0][1];S=T/I,k=P/I}else{var M=l[0][0]+l[0][1],A=l[1][0]+l[1][1];S=k=a(M)>s?c[0]/M:a(A)>s?c[1]/A:0}var O,z,L=u.getDistance(h),E=s*L;if(S<E||k<E)S=k=L/3;else{var N=u.subtract(h);O=i.normalize(S),z=r.normalize(k),O.dot(N)-z.dot(N)>L*L&&(S=k=L/3,O=z=null)}return[h,h.add(O||i.normalize(S)),u.add(z||r.normalize(k)),u]},reparameterize:function(t,e,n,i){for(var r=t;r<=e;r++)n[r-t]=this.findRoot(i,this.points[r],n[r-t]);for(var r=1,s=n.length;r<s;r++)if(n[r]<=n[r-1])return!1;return!0},findRoot:function(t,e,n){for(var i=[],r=[],s=0;s<=2;s++)i[s]=t[s+1].subtract(t[s]).multiply(3);for(var s=0;s<=1;s++)r[s]=i[s+1].subtract(i[s]).multiply(2);var a=this.evaluate(3,t,n),o=this.evaluate(2,i,n),h=this.evaluate(1,r,n),l=a.subtract(e),c=o.dot(o)+l.dot(h);return u.isZero(c)?n:n-l.dot(o)/c},evaluate:function(t,e,n){for(var i=e.slice(),r=1;r<=t;r++)for(var s=0;s<=t-r;s++)i[s]=i[s].multiply(1-n).add(i[s+1].multiply(n));return i[0]},chordLengthParameterize:function(t,e){for(var n=[0],i=t+1;i<=e;i++)n[i-t]=n[i-t-1]+this.points[i].getDistance(this.points[i-1]);for(var i=1,r=e-t;i<=r;i++)n[i]/=n[r];return n},findMaxError:function(t,e,n,i){for(var r=Math.floor((e-t+1)/2),s=0,a=t+1;a<e;a++){var o=this.evaluate(3,n,i[a-t]),h=o.subtract(this.points[a]),u=h.x*h.x+h.y*h.y;u>=s&&(s=u,r=a)}return{error:s,index:r}}}),F=w.extend({_class:"TextItem",_applyMatrix:!1,_canApplyMatrix:!1,_serializeFields:{content:null},_boundsOptions:{stroke:!1,handle:!1},initialize:function(t){this._content="",this._lines=[];var n=t&&r.isPlainObject(t)&&t.x===e&&t.y===e;this._initialize(n&&t,!n&&c.read(arguments))},_equals:function(t){return this._content===t._content},copyContent:function(t){this.setContent(t._content)},getContent:function(){return this._content},setContent:function(t){this._content=""+t,this._lines=this._content.split(/\r\n|\n|\r/gm),this._changed(521)},isEmpty:function(){return!this._content},getCharacterStyle:"#getStyle",setCharacterStyle:"#setStyle",getParagraphStyle:"#getStyle",setParagraphStyle:"#setStyle"}),j=F.extend({_class:"PointText",initialize:function(){F.apply(this,arguments)},getPoint:function(){var t=this._matrix.getTranslation();return new f(t.x,t.y,this,"setPoint")},setPoint:function(){var t=c.read(arguments);this.translate(t.subtract(this._matrix.getTranslation()))},_draw:function(t,e,n){if(this._content){this._setStyles(t,e,n);var i=this._lines,r=this._style,s=r.hasFill(),a=r.hasStroke(),o=r.getLeading(),h=t.shadowColor;t.font=r.getFontStyle(),t.textAlign=r.getJustification();for(var u=0,l=i.length;u<l;u++){t.shadowColor=h;var c=i[u];s&&(t.fillText(c,0,0),t.shadowColor="rgba(0,0,0,0)"),a&&t.strokeText(c,0,0),t.translate(0,o)}}},_getBounds:function(t,e){var n=this._style,i=this._lines,r=i.length,s=n.getJustification(),a=n.getLeading(),o=this.getView().getTextWidth(n.getFontStyle(),i),h=0;"left"!==s&&(h-=o/("center"===s?2:1));var u=new g(h,r?-.75*a:0,o,r*a);return t?t._transformBounds(u,u):u}}),D=r.extend(new function(){function t(t){var i,r=t.match(/^#([\da-f]{2})([\da-f]{2})([\da-f]{2})([\da-f]{2})?$/i)||t.match(/^#([\da-f])([\da-f])([\da-f])([\da-f])?$/i),s="rgb";if(r){var o=r[4]?4:3;i=new Array(o);for(var h=0;h<o;h++){var u=r[h+1];i[h]=parseInt(1==u.length?u+u:u,16)/255}}else if(r=t.match(/^(rgb|hsl)a?\((.*)\)$/)){s=r[1],i=r[2].split(/[,\s]+/g);for(var l="hsl"===s,h=0,c=Math.min(i.length,4);h<c;h++){var f=i[h],u=parseFloat(f);if(l)if(0===h){var d=f.match(/([a-z]*)$/)[1];u*={turn:360,rad:180/Math.PI,grad:.9}[d]||1}else h<3&&(u/=100);else h<3&&(u/=255);i[h]=u}}else{var _=a[t];if(!_)if(n){e||(e=et.getContext(1,1),e.globalCompositeOperation="copy"),e.fillStyle="rgba(0,0,0,0)",e.fillStyle=t,e.fillRect(0,0,1,1);var g=e.getImageData(0,0,1,1).data;_=a[t]=[g[0]/255,g[1]/255,g[2]/255]}else _=[0,0,0];i=_.slice()}return[s,i]}var e,i={gray:["gray"],rgb:["red","green","blue"],hsb:["hue","saturation","brightness"],hsl:["hue","saturation","lightness"],gradient:["gradient","origin","destination","highlight"]},s={},a={transparent:[0,0,0,0]},o=[[0,3,1],[2,0,1],[1,0,3],[1,2,0],[3,1,0],[0,1,2]],u={"rgb-hsb":function(t,e,n){var i=Math.max(t,e,n),r=Math.min(t,e,n),s=i-r,a=0===s?0:60*(i==t?(e-n)/s+(e<n?6:0):i==e?(n-t)/s+2:(t-e)/s+4);return[a,0===i?0:s/i,i]},"hsb-rgb":function(t,e,n){t=(t/60%6+6)%6;var i=Math.floor(t),r=t-i,i=o[i],s=[n,n*(1-e),n*(1-e*r),n*(1-e*(1-r))];return[s[i[0]],s[i[1]],s[i[2]]]},"rgb-hsl":function(t,e,n){var i=Math.max(t,e,n),r=Math.min(t,e,n),s=i-r,a=0===s,o=a?0:60*(i==t?(e-n)/s+(e<n?6:0):i==e?(n-t)/s+2:(t-e)/s+4),h=(i+r)/2,u=a?0:h<.5?s/(i+r):s/(2-i-r);return[o,u,h]},"hsl-rgb":function(t,e,n){if(t=(t/360%1+1)%1,0===e)return[n,n,n];for(var i=[t+1/3,t,t-1/3],r=n<.5?n*(1+e):n+e-n*e,s=2*n-r,a=[],o=0;o<3;o++){var h=i[o];h<0&&(h+=1),h>1&&(h-=1),a[o]=6*h<1?s+6*(r-s)*h:2*h<1?r:3*h<2?s+(r-s)*(2/3-h)*6:s}return a},"rgb-gray":function(t,e,n){return[.2989*t+.587*e+.114*n]},"gray-rgb":function(t){return[t,t,t]},"gray-hsb":function(t){return[0,0,t]},"gray-hsl":function(t){return[0,0,t]},"gradient-rgb":function(){return[]},"rgb-gradient":function(){return[]}};return r.each(i,function(t,e){s[e]=[],r.each(t,function(t,n){var a=r.capitalize(t),o=/^(hue|saturation)$/.test(t),h=s[e][n]="gradient"===e?"gradient"===t?function(t){var e=this._components[0];return t=R.read(Array.isArray(t)?t:arguments,0,{readNull:!0}),e!==t&&(e&&e._removeOwner(this),t&&t._addOwner(this)),t}:function(){return c.read(arguments,0,{readNull:"highlight"===t,clone:!0})}:function(t){return null==t||isNaN(t)?0:+t};this["get"+a]=function(){return this._type===e||o&&/^hs[bl]$/.test(this._type)?this._components[n]:this._convert(e)[n]},this["set"+a]=function(t){this._type===e||o&&/^hs[bl]$/.test(this._type)||(this._components=this._convert(e),this._properties=i[e],this._type=e),this._components[n]=h.call(this,t),this._changed()}},this)},{_class:"Color",_readIndex:!0,initialize:function l(e){var n,a,o,h,u=arguments,c=this.__read,f=0;Array.isArray(e)&&(u=e,e=u[0]);var d=null!=e&&typeof e;if("string"===d&&e in i&&(n=e,e=u[1],Array.isArray(e)?(a=e,o=u[2]):(c&&(f=1),u=r.slice(u,1),d=typeof e)),!a){if(h="number"===d?u:"object"===d&&null!=e.length?e:null){n||(n=h.length>=3?"rgb":"gray");var _=i[n].length;o=h[_],c&&(f+=h===arguments?_+(null!=o?1:0):1),h.length>_&&(h=r.slice(h,0,_))}else if("string"===d){var g=t(e);n=g[0],a=g[1],4===a.length&&(o=a[3],a.length--)}else if("object"===d)if(e.constructor===l){if(n=e._type,a=e._components.slice(),o=e._alpha,"gradient"===n)for(var v=1,p=a.length;v<p;v++){var m=a[v];m&&(a[v]=m.clone())}}else if(e.constructor===R)n="gradient",h=u;else{n="hue"in e?"lightness"in e?"hsl":"hsb":"gradient"in e||"stops"in e||"radial"in e?"gradient":"gray"in e?"gray":"rgb";var y=i[n],w=s[n];this._components=a=[];for(var v=0,p=y.length;v<p;v++){var x=e[y[v]];null==x&&!v&&"gradient"===n&&"stops"in e&&(x={stops:e.stops,radial:e.radial}),x=w[v].call(this,x),null!=x&&(a[v]=x)}o=e.alpha}c&&n&&(f=1)}if(this._type=n||"rgb",!a){this._components=a=[];for(var w=s[this._type],v=0,p=w.length;v<p;v++){var x=w[v].call(this,h&&h[v]);null!=x&&(a[v]=x)}}return this._components=a,this._properties=i[this._type],this._alpha=o,c&&(this.__read=f),this},set:"#initialize",_serialize:function(t,e){var n=this.getComponents();return r.serialize(/^(gray|rgb)$/.test(this._type)?n:[this._type].concat(n),t,!0,e)},_changed:function(){this._canvasStyle=null,this._owner&&this._owner._changed(129)},_convert:function(t){var e;return this._type===t?this._components.slice():(e=u[this._type+"-"+t])?e.apply(this,this._components):u["rgb-"+t].apply(this,u[this._type+"-rgb"].apply(this,this._components))},convert:function(t){return new D(t,this._convert(t),this._alpha)},getType:function(){return this._type},setType:function(t){this._components=this._convert(t),this._properties=i[t],this._type=t},getComponents:function(){var t=this._components.slice();return null!=this._alpha&&t.push(this._alpha),t},getAlpha:function(){return null!=this._alpha?this._alpha:1},setAlpha:function(t){this._alpha=null==t?null:Math.min(Math.max(t,0),1),this._changed()},hasAlpha:function(){return null!=this._alpha},equals:function(t){var e=r.isPlainValue(t,!0)?D.read(arguments):t;return e===this||e&&this._class===e._class&&this._type===e._type&&this.getAlpha()===e.getAlpha()&&r.equals(this._components,e._components)||!1},toString:function(){for(var t=this._properties,e=[],n="gradient"===this._type,i=h.instance,r=0,s=t.length;r<s;r++){var a=this._components[r];null!=a&&e.push(t[r]+": "+(n?a:i.number(a)))}return null!=this._alpha&&e.push("alpha: "+i.number(this._alpha)),"{ "+e.join(", ")+" }"},toCSS:function(t){function e(t){return Math.round(255*(t<0?0:t>1?1:t))}var n=this._convert("rgb"),i=t||null==this._alpha?1:this._alpha;return n=[e(n[0]),e(n[1]),e(n[2])],i<1&&n.push(i<0?0:i),t?"#"+((1<<24)+(n[0]<<16)+(n[1]<<8)+n[2]).toString(16).slice(1):(4==n.length?"rgba(":"rgb(")+n.join(",")+")"},toCanvasStyle:function(t,e){if(this._canvasStyle)return this._canvasStyle;if("gradient"!==this._type)return this._canvasStyle=this.toCSS();var n,i=this._components,r=i[0],s=r._stops,a=i[1],o=i[2],h=i[3],u=e&&e.inverted();if(u&&(a=u._transformPoint(a),o=u._transformPoint(o),h&&(h=u._transformPoint(h))),
r._radial){var l=o.getDistance(a);if(h){var c=h.subtract(a);c.getLength()>l&&(h=a.add(c.normalize(l-.1)))}var f=h||a;n=t.createRadialGradient(f.x,f.y,0,a.x,a.y,l)}else n=t.createLinearGradient(a.x,a.y,o.x,o.y);for(var d=0,_=s.length;d<_;d++){var g=s[d],v=g._offset;n.addColorStop(null==v?d/(_-1):v,g._color.toCanvasStyle())}return this._canvasStyle=n},transform:function(t){if("gradient"===this._type){for(var e=this._components,n=1,i=e.length;n<i;n++){var r=e[n];t._transformPoint(r,r,!0)}this._changed()}},statics:{_types:i,random:function(){var t=Math.random;return new D(t(),t(),t())}}})},new function(){var t={add:function(t,e){return t+e},subtract:function(t,e){return t-e},multiply:function(t,e){return t*e},divide:function(t,e){return t/e}};return r.each(t,function(t,e){this[e]=function(e){e=D.read(arguments);for(var n=this._type,i=this._components,r=e._convert(n),s=0,a=i.length;s<a;s++)r[s]=t(i[s],r[s]);return new D(n,r,null!=this._alpha?t(this._alpha,e.getAlpha()):null)}},{})}),R=r.extend({_class:"Gradient",initialize:function(t,e){this._id=l.get(),t&&r.isPlainObject(t)&&(this.set(t),t=e=null),null==this._stops&&this.setStops(t||["white","black"]),null==this._radial&&this.setRadial("string"==typeof e&&"radial"===e||e||!1)},_serialize:function(t,e){return e.add(this,function(){return r.serialize([this._stops,this._radial],t,!0,e)})},_changed:function(){for(var t=0,e=this._owners&&this._owners.length;t<e;t++)this._owners[t]._changed()},_addOwner:function(t){this._owners||(this._owners=[]),this._owners.push(t)},_removeOwner:function(t){var n=this._owners?this._owners.indexOf(t):-1;n!=-1&&(this._owners.splice(n,1),this._owners.length||(this._owners=e))},clone:function(){for(var t=[],e=0,n=this._stops.length;e<n;e++)t[e]=this._stops[e].clone();return new R(t,this._radial)},getStops:function(){return this._stops},setStops:function(t){if(t.length<2)throw new Error("Gradient stop list needs to contain at least two stops.");var n=this._stops;if(n)for(var i=0,r=n.length;i<r;i++)n[i]._owner=e;n=this._stops=q.readList(t,0,{clone:!0});for(var i=0,r=n.length;i<r;i++)n[i]._owner=this;this._changed()},getRadial:function(){return this._radial},setRadial:function(t){this._radial=t,this._changed()},equals:function(t){if(t===this)return!0;if(t&&this._class===t._class){var e=this._stops,n=t._stops,i=e.length;if(i===n.length){for(var r=0;r<i;r++)if(!e[r].equals(n[r]))return!1;return!0}}return!1}}),q=r.extend({_class:"GradientStop",initialize:function(t,n){var i=t,r=n;"object"==typeof t&&n===e&&(Array.isArray(t)&&"number"!=typeof t[0]?(i=t[0],r=t[1]):("color"in t||"offset"in t||"rampPoint"in t)&&(i=t.color,r=t.offset||t.rampPoint||0)),this.setColor(i),this.setOffset(r)},clone:function(){return new q(this._color.clone(),this._offset)},_serialize:function(t,e){var n=this._color,i=this._offset;return r.serialize(null==i?[n]:[n,i],t,!0,e)},_changed:function(){this._owner&&this._owner._changed(129)},getOffset:function(){return this._offset},setOffset:function(t){this._offset=t,this._changed()},getRampPoint:"#getOffset",setRampPoint:"#setOffset",getColor:function(){return this._color},setColor:function(){var t=D.read(arguments,0,{clone:!0});t&&(t._owner=this),this._color=t,this._changed()},equals:function(t){return t===this||t&&this._class===t._class&&this._color.equals(t._color)&&this._offset==t._offset||!1}}),V=r.extend(new function(){var t={fillColor:null,fillRule:"nonzero",strokeColor:null,strokeWidth:1,strokeCap:"butt",strokeJoin:"miter",strokeScaling:!0,miterLimit:10,dashOffset:0,dashArray:[],shadowColor:null,shadowBlur:0,shadowOffset:new c,selectedColor:null},n=r.set({},t,{fontFamily:"sans-serif",fontWeight:"normal",fontSize:12,leading:null,justification:"left"}),i=r.set({},n,{fillColor:new D}),s={strokeWidth:193,strokeCap:193,strokeJoin:193,strokeScaling:201,miterLimit:193,fontFamily:9,fontWeight:9,fontSize:9,font:9,leading:9,justification:9},a={beans:!0},o={_class:"Style",beans:!0,initialize:function(e,r,s){this._values={},this._owner=r,this._project=r&&r._project||s||st.project,this._defaults=!r||r instanceof x?n:r instanceof F?i:t,e&&this.set(e)}};return r.each(n,function(t,n){var i=/Color$/.test(n),h="shadowOffset"===n,u=r.capitalize(n),l=s[n],f="set"+u,d="get"+u;o[f]=function(t){var r=this._owner,s=r&&r._children,a=s&&s.length>0&&!(r instanceof E);if(a)for(var o=0,h=s.length;o<h;o++)s[o]._style[f](t);if(("selectedColor"===n||!a)&&n in this._defaults){var u=this._values[n];u!==t&&(i&&(u&&u._owner!==e&&(u._owner=e,u._canvasStyle=null),t&&t.constructor===D&&(t._owner&&(t=t.clone()),t._owner=r)),this._values[n]=t,r&&r._changed(l||129))}},o[d]=function(t){var s,a=this._owner,o=a&&a._children;if(n in this._defaults&&(!o||!o.length||t||a instanceof E)){var s=this._values[n];if(s===e)s=this._defaults[n],s&&s.clone&&(s=s.clone());else{var u=i?D:h?c:null;!u||s&&s.constructor===u||(this._values[n]=s=u.read([s],0,{readNull:!0,clone:!0}),s&&i&&(s._owner=a))}}else if(o)for(var l=0,f=o.length;l<f;l++){var _=o[l]._style[d]();if(l){if(!r.equals(s,_))return e}else s=_}return s},a[d]=function(t){return this._style[d](t)},a[f]=function(t){this._style[f](t)}}),r.each({Font:"FontFamily",WindingRule:"FillRule"},function(t,e){var n="get"+e,i="set"+e;o[n]=a[n]="#get"+t,o[i]=a[i]="#set"+t}),w.inject(a),o},{set:function(t){var e=t instanceof V,n=e?t._values:t;if(n)for(var i in n)if(i in this._defaults){var r=n[i];this[i]=r&&e&&r.clone?r.clone():r}},equals:function(t){function n(t,n,i){var s=t._values,a=n._values,o=n._defaults;for(var h in s){var u=s[h],l=a[h];if(!(i&&h in a||r.equals(u,l===e?o[h]:l)))return!1}return!0}return t===this||t&&this._class===t._class&&n(this,t)&&n(t,this,!0)||!1},_dispose:function(){var t;t=this.getFillColor(),t&&(t._canvasStyle=null),t=this.getStrokeColor(),t&&(t._canvasStyle=null),t=this.getShadowColor(),t&&(t._canvasStyle=null)},hasFill:function(){var t=this.getFillColor();return!!t&&t.alpha>0},hasStroke:function(){var t=this.getStrokeColor();return!!t&&t.alpha>0&&this.getStrokeWidth()>0},hasShadow:function(){var t=this.getShadowColor();return!!t&&t.alpha>0&&(this.getShadowBlur()>0||!this.getShadowOffset().isZero())},getView:function(){return this._project._view},getFontStyle:function(){var t=this.getFontSize();return this.getFontWeight()+" "+t+(/[a-z]/i.test(t+"")?" ":"px ")+this.getFontFamily()},getFont:"#getFontFamily",setFont:"#setFontFamily",getLeading:function St(){var t=St.base.call(this),e=this.getFontSize();return/pt|em|%|px/.test(e)&&(e=this.getView().getPixelSize(e)),null!=t?t:1.2*e}}),U=new function(){function t(t,e,n,i){for(var r=["","webkit","moz","Moz","ms","o"],s=e[0].toUpperCase()+e.substring(1),a=0;a<6;a++){var o=r[a],h=o?o+s:e;if(h in t){if(!n)return t[h];t[h]=i;break}}}return{getStyles:function(t){var e=t&&9!==t.nodeType?t.ownerDocument:t,n=e&&e.defaultView;return n&&n.getComputedStyle(t,"")},getBounds:function(t,e){var n,i=t.ownerDocument,r=i.body,s=i.documentElement;try{n=t.getBoundingClientRect()}catch(a){n={left:0,top:0,width:0,height:0}}var o=n.left-(s.clientLeft||r.clientLeft||0),h=n.top-(s.clientTop||r.clientTop||0);if(!e){var u=i.defaultView;o+=u.pageXOffset||s.scrollLeft||r.scrollLeft,h+=u.pageYOffset||s.scrollTop||r.scrollTop}return new g(o,h,n.width,n.height)},getViewportBounds:function(t){var e=t.ownerDocument,n=e.defaultView,i=e.documentElement;return new g(0,0,n.innerWidth||i.clientWidth,n.innerHeight||i.clientHeight)},getOffset:function(t,e){return U.getBounds(t,e).getPoint()},getSize:function(t){return U.getBounds(t,!0).getSize()},isInvisible:function(t){return U.getSize(t).equals(new d(0,0))},isInView:function(t){return!U.isInvisible(t)&&U.getViewportBounds(t).intersects(U.getBounds(t,!0))},isInserted:function(t){return i.body.contains(t)},getPrefixed:function(e,n){return e&&t(e,n)},setPrefixed:function(e,n,i){if("object"==typeof n)for(var r in n)t(e,r,!0,n[r]);else t(e,n,!0,i)}}},H={add:function(t,e){if(t)for(var n in e)for(var r=e[n],s=n.split(/[\s,]+/g),a=0,o=s.length;a<o;a++){var h=s[a],u=t===i&&("touchstart"===h||"touchmove"===h)&&{passive:!1};t.addEventListener(h,r,u)}},remove:function(t,e){if(t)for(var n in e)for(var i=e[n],r=n.split(/[\s,]+/g),s=0,a=r.length;s<a;s++)t.removeEventListener(r[s],i,!1)},getPoint:function(t){var e=t.targetTouches?t.targetTouches.length?t.targetTouches[0]:t.changedTouches[0]:t;return new c(e.pageX||e.clientX+i.documentElement.scrollLeft,e.pageY||e.clientY+i.documentElement.scrollTop)},getTarget:function(t){return t.target||t.srcElement},getRelatedTarget:function(t){return t.relatedTarget||t.toElement},getOffset:function(t,e){return H.getPoint(t).subtract(U.getOffset(e||H.getTarget(t)))}};H.requestAnimationFrame=new function(){function t(){var e=s;s=[];for(var n=0,a=e.length;n<a;n++)e[n]();r=i&&s.length,r&&i(t)}var e,i=U.getPrefixed(n,"requestAnimationFrame"),r=!1,s=[];return function(n){s.push(n),i?r||(i(t),r=!0):e||(e=setInterval(t,1e3/60))}};var Z=r.extend(s,{_class:"View",initialize:function kt(t,e){function r(t){return e[t]||parseInt(e.getAttribute(t),10)}function s(){var t=U.getSize(e);return t.isNaN()||t.isZero()?new d(r("width"),r("height")):t}var o;if(n&&e){this._id=e.getAttribute("id"),null==this._id&&e.setAttribute("id",this._id="view-"+kt._id++),H.add(e,this._viewEvents);var h="none";if(U.setPrefixed(e.style,{userDrag:h,userSelect:h,touchCallout:h,contentZooming:h,tapHighlightColor:"rgba(0,0,0,0)"}),a.hasAttribute(e,"resize")){var u=this;H.add(n,this._windowEvents={resize:function(){u.setViewSize(s())}})}if(o=s(),a.hasAttribute(e,"stats")&&"undefined"!=typeof Stats){this._stats=new Stats;var l=this._stats.domElement,c=l.style,f=U.getOffset(e);c.position="absolute",c.left=f.x+"px",c.top=f.y+"px",i.body.appendChild(l)}}else o=new d(e),e=null;this._project=t,this._scope=t._scope,this._element=e,this._pixelRatio||(this._pixelRatio=n&&n.devicePixelRatio||1),this._setElementSize(o.width,o.height),this._viewSize=o,kt._views.push(this),kt._viewsById[this._id]=this,(this._matrix=new p)._owner=this,kt._focused||(kt._focused=this),this._frameItems={},this._frameItemCount=0,this._itemEvents={"native":{},virtual:{}},this._autoUpdate=!st.agent.node,this._needsUpdate=!1},remove:function(){if(!this._project)return!1;Z._focused===this&&(Z._focused=null),Z._views.splice(Z._views.indexOf(this),1),delete Z._viewsById[this._id];var t=this._project;return t._view===this&&(t._view=null),H.remove(this._element,this._viewEvents),H.remove(n,this._windowEvents),this._element=this._project=null,this.off("frame"),this._animate=!1,this._frameItems={},!0},_events:r.each(w._itemHandlers.concat(["onResize","onKeyDown","onKeyUp"]),function(t){this[t]={}},{onFrame:{install:function(){this.play()},uninstall:function(){this.pause()}}}),_animate:!1,_time:0,_count:0,getAutoUpdate:function(){return this._autoUpdate},setAutoUpdate:function(t){this._autoUpdate=t,t&&this.requestUpdate()},update:function(){},draw:function(){this.update()},requestUpdate:function(){if(!this._requested){var t=this;H.requestAnimationFrame(function(){if(t._requested=!1,t._animate){t.requestUpdate();var e=t._element;U.getPrefixed(i,"hidden")&&"true"!==a.getAttribute(e,"keepalive")||!U.isInView(e)||t._handleFrame()}t._autoUpdate&&t.update()}),this._requested=!0}},play:function(){this._animate=!0,this.requestUpdate()},pause:function(){this._animate=!1},_handleFrame:function(){st=this._scope;var t=Date.now()/1e3,e=this._last?t-this._last:0;this._last=t,this.emit("frame",new r({delta:e,time:this._time+=e,count:this._count++})),this._stats&&this._stats.update()},_animateItem:function(t,e){var n=this._frameItems;e?(n[t._id]={item:t,time:0,count:0},1===++this._frameItemCount&&this.on("frame",this._handleFrameItems)):(delete n[t._id],0===--this._frameItemCount&&this.off("frame",this._handleFrameItems))},_handleFrameItems:function(t){for(var e in this._frameItems){var n=this._frameItems[e];n.item.emit("frame",new r(t,{time:n.time+=t.delta,count:n.count++}))}},_changed:function(){this._project._changed(4097),this._bounds=this._decomposed=e},getElement:function(){return this._element},getPixelRatio:function(){return this._pixelRatio},getResolution:function(){return 72*this._pixelRatio},getViewSize:function(){var t=this._viewSize;return new _(t.width,t.height,this,"setViewSize")},setViewSize:function(){var t=d.read(arguments),e=t.subtract(this._viewSize);e.isZero()||(this._setElementSize(t.width,t.height),this._viewSize.set(t),this._changed(),this.emit("resize",{size:t,delta:e}),this._autoUpdate&&this.update())},_setElementSize:function(t,e){var n=this._element;n&&(n.width!==t&&(n.width=t),n.height!==e&&(n.height=e))},getBounds:function(){return this._bounds||(this._bounds=this._matrix.inverted()._transformBounds(new g(new c,this._viewSize))),this._bounds},getSize:function(){return this.getBounds().getSize()},isVisible:function(){return U.isInView(this._element)},isInserted:function(){return U.isInserted(this._element)},getPixelSize:function(t){var e,n=this._element;if(n){var r=n.parentNode,s=i.createElement("div");s.style.fontSize=t,r.appendChild(s),e=parseFloat(U.getStyles(s).fontSize),r.removeChild(s)}else e=parseFloat(e);return e},getTextWidth:function(t,e){return 0}},r.each(["rotate","scale","shear","skew"],function(t){var e="rotate"===t;this[t]=function(){var n=(e?r:c).read(arguments),i=c.read(arguments,0,{readNull:!0});return this.transform((new p)[t](n,i||this.getCenter(!0)))}},{_decompose:function(){return this._decomposed||(this._decomposed=this._matrix.decompose())},translate:function(){var t=new p;return this.transform(t.translate.apply(t,arguments))},getCenter:function(){return this.getBounds().getCenter()},setCenter:function(){var t=c.read(arguments);this.translate(this.getCenter().subtract(t))},getZoom:function(){var t=this._decompose().scaling;return(t.x+t.y)/2},setZoom:function(t){this.transform((new p).scale(t/this.getZoom(),this.getCenter()))},getRotation:function(){return this._decompose().rotation},setRotation:function(t){var e=this.getRotation();null!=e&&null!=t&&this.rotate(t-e)},getScaling:function(){var t=this._decompose().scaling;return new f(t.x,t.y,this,"setScaling")},setScaling:function(){var t=this.getScaling(),e=c.read(arguments,0,{clone:!0,readNull:!0});t&&e&&this.scale(e.x/t.x,e.y/t.y)},getMatrix:function(){return this._matrix},setMatrix:function(){var t=this._matrix;t.initialize.apply(t,arguments)},transform:function(t){this._matrix.append(t)},scrollBy:function(){this.translate(c.read(arguments).negate())}}),{projectToView:function(){return this._matrix._transformPoint(c.read(arguments))},viewToProject:function(){return this._matrix._inverseTransform(c.read(arguments))},getEventPoint:function(t){return this.viewToProject(H.getOffset(t,this._element))}},{statics:{_views:[],_viewsById:{},_id:0,create:function(t,e){i&&"string"==typeof e&&(e=i.getElementById(e));var r=n?W:Z;return new r(t,e)}}},new function(){function t(t){var e=H.getTarget(t);return e.getAttribute&&Z._viewsById[e.getAttribute("id")]}function e(){var t=Z._focused;if(!t||!t.isVisible())for(var e=0,n=Z._views.length;e<n;e++)if((t=Z._views[e]).isVisible()){Z._focused=h=t;break}}function r(t,e,n){t._handleMouseEvent("mousemove",e,n)}function s(t,e,n,i,r,s,a){function o(t,n){if(t.responds(n)){if(h||(h=new X(n,i,r,e||t,s?r.subtract(s):null)),t.emit(n,h)&&(I=!0,h.prevented&&(P=!0),h.stopped))return u=!0}else{var a=T[n];if(a)return o(t,a)}}for(var h,u=!1;t&&t!==a&&!o(t,n);)t=t._parent;return u}function a(t,e,n,i,r,a){return t._project.removeOn(n),P=I=!1,b&&s(b,null,n,i,r,a)||e&&e!==b&&!e.isDescendant(b)&&s(e,null,"mousedrag"===n?"mousemove":n,i,r,a,b)||s(t,b||e||t,n,i,r,a)}if(n){var o,h,u,l,c,f=!1,d=!1,_=n.navigator;_.pointerEnabled||_.msPointerEnabled?(u="pointerdown MSPointerDown",l="pointermove MSPointerMove",c="pointerup pointercancel MSPointerUp MSPointerCancel"):(u="touchstart",l="touchmove",c="touchend touchcancel","ontouchstart"in n&&_.userAgent.match(/mobile|tablet|ip(ad|hone|od)|android|silk/i)||(u+=" mousedown",l+=" mousemove",c+=" mouseup"));var g={},v={mouseout:function(t){var e=Z._focused,n=H.getRelatedTarget(t);if(e&&(!n||"HTML"===n.nodeName)){var i=H.getOffset(t,e._element),s=i.x,a=Math.abs,o=a(s),h=1<<25,u=o-h;i.x=a(u)<o?u*(s<0?-1:1):s,r(e,t,e.viewToProject(i))}},scroll:e};g[u]=function(e){var n=Z._focused=t(e);f||(f=!0,n._handleMouseEvent("mousedown",e))},v[l]=function(n){var i=Z._focused;if(!d){var s=t(n);s?i!==s&&(i&&r(i,n),o||(o=i),i=Z._focused=h=s):h&&h===i&&(o&&!o.isInserted()&&(o=null),i=Z._focused=o,o=null,e())}i&&r(i,n)},v[u]=function(){d=!0},v[c]=function(t){var e=Z._focused;e&&f&&e._handleMouseEvent("mouseup",t),d=f=!1},H.add(i,v),H.add(n,{load:e});var p,m,y,w,x,b,C,S,k,I=!1,P=!1,T={doubleclick:"click",mousedrag:"mousemove"},M=!1,A={mousedown:{mousedown:1,mousedrag:1,click:1,doubleclick:1},mouseup:{mouseup:1,mousedrag:1,click:1,doubleclick:1},mousemove:{mousedrag:1,mousemove:1,mouseenter:1,mouseleave:1}};return{_viewEvents:g,_handleMouseEvent:function(t,e,n){function i(t){return r.virtual[t]||l.responds(t)||u&&u.responds(t)}var r=this._itemEvents,o=r["native"][t],h="mousemove"===t,u=this._scope.tool,l=this;h&&f&&i("mousedrag")&&(t="mousedrag"),n||(n=this.getEventPoint(e));var c=this.getBounds().contains(n),d=o&&c&&l._project.hitTest(n,{tolerance:0,fill:!0,stroke:!0}),_=d&&d.item||null,g=!1,v={};if(v[t.substr(5)]=!0,o&&_!==x&&(x&&s(x,null,"mouseleave",e,n),_&&s(_,null,"mouseenter",e,n),x=_),M^c&&(s(this,null,c?"mouseenter":"mouseleave",e,n),p=c?this:null,g=!0),!c&&!v.drag||n.equals(y)||(a(this,_,h?t:"mousemove",e,n,y),g=!0),M=c,v.down&&c||v.up&&m){if(a(this,_,t,e,n,m),v.down){if(k=_===C&&Date.now()-S<300,w=C=_,!P&&_){for(var T=_;T&&!T.responds("mousedrag");)T=T._parent;T&&(b=_)}m=n}else v.up&&(P||_!==w||(S=Date.now(),a(this,_,k?"doubleclick":"click",e,n,m),k=!1),w=b=null);M=!1,g=!0}y=n,g&&u&&(I=u._handleMouseEvent(t,e,n,v)||I),e.cancelable!==!1&&(I&&!v.move||v.down&&i("mouseup"))&&e.preventDefault()},_handleKeyEvent:function(t,e,n,i){function r(r){r.responds(t)&&(st=a,r.emit(t,s=s||new G(t,e,n,i)))}var s,a=this._scope,o=a.tool;this.isVisible()&&(r(this),o&&o.responds(t)&&r(o))},_countItemEvent:function(t,e){var n=this._itemEvents,i=n["native"],r=n.virtual;for(var s in A)i[s]=(i[s]||0)+(A[s][t]||0)*e;r[t]=(r[t]||0)+e},statics:{updateFocus:e,_resetState:function(){f=d=I=M=!1,o=h=p=m=y=w=x=b=C=S=k=null}}}}}),W=Z.extend({_class:"CanvasView",initialize:function(t,e){if(!(e instanceof n.HTMLCanvasElement)){var i=d.read(arguments,1);if(i.isZero())throw new Error("Cannot create CanvasView with the provided argument: "+r.slice(arguments,1));e=et.getCanvas(i)}var s=this._context=e.getContext("2d");if(s.save(),this._pixelRatio=1,!/^off|false$/.test(a.getAttribute(e,"hidpi"))){var o=n.devicePixelRatio||1,h=U.getPrefixed(s,"backingStorePixelRatio")||1;this._pixelRatio=o/h}Z.call(this,t,e),this._needsUpdate=!0},remove:function It(){return this._context.restore(),It.base.call(this)},_setElementSize:function Pt(t,e){var n=this._pixelRatio;if(Pt.base.call(this,t*n,e*n),1!==n){var i=this._element,r=this._context;if(!a.hasAttribute(i,"resize")){var s=i.style;s.width=t+"px",s.height=e+"px"}r.restore(),r.save(),r.scale(n,n)}},getPixelSize:function Tt(t){var e,n=st.agent;if(n&&n.firefox)e=Tt.base.call(this,t);else{var i=this._context,r=i.font;i.font=t+" serif",e=parseFloat(i.font),i.font=r}return e},getTextWidth:function(t,e){var n=this._context,i=n.font,r=0;n.font=t;for(var s=0,a=e.length;s<a;s++)r=Math.max(r,n.measureText(e[s]).width);return n.font=i,r},update:function(){if(!this._needsUpdate)return!1;var t=this._project,e=this._context,n=this._viewSize;return e.clearRect(0,0,n.width+1,n.height+1),t&&t.draw(e,this._matrix,this._pixelRatio),this._needsUpdate=!1,!0}}),$=r.extend({_class:"Event",initialize:function(t){this.event=t,this.type=t&&t.type},prevented:!1,stopped:!1,preventDefault:function(){this.prevented=!0,this.event.preventDefault()},stopPropagation:function(){this.stopped=!0,this.event.stopPropagation()},stop:function(){this.stopPropagation(),this.preventDefault()},getTimeStamp:function(){return this.event.timeStamp},getModifiers:function(){return J.modifiers}}),G=$.extend({_class:"KeyEvent",initialize:function(t,e,n,i){this.type=t,this.event=e,this.key=n,this.character=i},toString:function(){return"{ type: '"+this.type+"', key: '"+this.key+"', character: '"+this.character+"', modifiers: "+this.getModifiers()+" }"}}),J=new function(){function t(t){var n=t.key||t.keyIdentifier;return n=/^U\+/.test(n)?String.fromCharCode(parseInt(n.substr(2),16)):/^Arrow[A-Z]/.test(n)?n.substr(5):"Unidentified"===n||n===e?String.fromCharCode(t.keyCode):n,h[n]||(n.length>1?r.hyphenate(n):n.toLowerCase())}function s(t,e,n,i){var o,h=Z._focused;if(l[e]=t,t?c[e]=n:delete c[e],e.length>1&&(o=r.camelize(e))in f){f[o]=t;var u=st&&st.agent;if("meta"===o&&u&&u.mac)if(t)a={};else{for(var d in a)d in c&&s(!1,d,a[d],i);a=null}}else t&&a&&(a[e]=n);h&&h._handleKeyEvent(t?"keydown":"keyup",i,e,n)}var a,o,h={"\t":"tab"," ":"space","\b":"backspace","\x7f":"delete",Spacebar:"space",Del:"delete",Win:"meta",Esc:"escape"},u={tab:"\t",space:" ",enter:"\r"},l={},c={},f=new r({shift:!1,control:!1,alt:!1,meta:!1,capsLock:!1,space:!1}).inject({option:{get:function(){return this.alt}},command:{get:function(){var t=st&&st.agent;return t&&t.mac?this.meta:this.control}}});return H.add(i,{keydown:function(e){var n=t(e),i=st&&st.agent;n.length>1||i&&i.chrome&&(e.altKey||i.mac&&e.metaKey||!i.mac&&e.ctrlKey)?s(!0,n,u[n]||(n.length>1?"":n),e):o=n},keypress:function(e){if(o){var n=t(e),i=e.charCode,r=i>=32?String.fromCharCode(i):n.length>1?"":n;n!==o&&(n=r.toLowerCase()),s(!0,n,r,e),o=null}},keyup:function(e){var n=t(e);n in c&&s(!1,n,c[n],e)}}),H.add(n,{blur:function(t){for(var e in c)s(!1,e,c[e],t)}}),{modifiers:f,isDown:function(t){return!!l[t]}}},X=$.extend({_class:"MouseEvent",initialize:function(t,e,n,i,r){this.type=t,this.event=e,this.point=n,this.target=i,this.delta=r},toString:function(){return"{ type: '"+this.type+"', point: "+this.point+", target: "+this.target+(this.delta?", delta: "+this.delta:"")+", modifiers: "+this.getModifiers()+" }"}}),K=$.extend({_class:"ToolEvent",_item:null,initialize:function(t,e,n){this.tool=t,this.type=e,this.event=n},_choosePoint:function(t,e){return t?t:e?e.clone():null},getPoint:function(){return this._choosePoint(this._point,this.tool._point)},setPoint:function(t){this._point=t},getLastPoint:function(){return this._choosePoint(this._lastPoint,this.tool._lastPoint)},setLastPoint:function(t){this._lastPoint=t},getDownPoint:function(){return this._choosePoint(this._downPoint,this.tool._downPoint)},setDownPoint:function(t){this._downPoint=t},getMiddlePoint:function(){return!this._middlePoint&&this.tool._lastPoint?this.tool._point.add(this.tool._lastPoint).divide(2):this._middlePoint},setMiddlePoint:function(t){this._middlePoint=t},getDelta:function(){return!this._delta&&this.tool._lastPoint?this.tool._point.subtract(this.tool._lastPoint):this._delta},setDelta:function(t){this._delta=t},getCount:function(){return this.tool[/^mouse(down|up)$/.test(this.type)?"_downCount":"_moveCount"]},setCount:function(t){this.tool[/^mouse(down|up)$/.test(this.type)?"downCount":"count"]=t},getItem:function(){if(!this._item){var t=this.tool._scope.project.hitTest(this.getPoint());if(t){for(var e=t.item,n=e._parent;/^(Group|CompoundPath)$/.test(n._class);)e=n,n=n._parent;this._item=e}}return this._item},setItem:function(t){this._item=t},toString:function(){return"{ type: "+this.type+", point: "+this.getPoint()+", count: "+this.getCount()+", modifiers: "+this.getModifiers()+" }"}}),Q=o.extend({_class:"Tool",_list:"tools",_reference:"tool",_events:["onMouseDown","onMouseUp","onMouseDrag","onMouseMove","onActivate","onDeactivate","onEditOptions","onKeyDown","onKeyUp"],initialize:function(t){o.call(this),this._moveCount=-1,this._downCount=-1,this.set(t)},getMinDistance:function(){return this._minDistance},setMinDistance:function(t){this._minDistance=t,null!=t&&null!=this._maxDistance&&t>this._maxDistance&&(this._maxDistance=t)},getMaxDistance:function(){return this._maxDistance},setMaxDistance:function(t){this._maxDistance=t,null!=this._minDistance&&null!=t&&t<this._minDistance&&(this._minDistance=t)},getFixedDistance:function(){return this._minDistance==this._maxDistance?this._minDistance:null},setFixedDistance:function(t){this._minDistance=this._maxDistance=t},_handleMouseEvent:function(t,e,n,i){function r(t,e){var r=n,s=a?c._point:c._downPoint||r;if(a){if(c._moveCount>=0&&r.equals(s))return!1;if(s&&(null!=t||null!=e)){var o=r.subtract(s),h=o.getLength();if(h<(t||0))return!1;e&&(r=s.add(o.normalize(Math.min(h,e))))}c._moveCount++}return c._point=r,c._lastPoint=s||r,i.down&&(c._moveCount=-1,c._downPoint=r,c._downCount++),!0}function s(){o&&(l=c.emit(t,new K(c,t,e))||l)}st=this._scope,i.drag&&!this.responds(t)&&(t="mousemove");var a=i.move||i.drag,o=this.responds(t),h=this.minDistance,u=this.maxDistance,l=!1,c=this;if(i.down)r(),s();else if(i.up)r(null,u),s();else if(o)for(;r(h,u);)s();return l}}),Y=r.extend(s,{_class:"Tween",statics:{easings:{linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return t*(2-t)},easeInOutQuad:function(t){return t<.5?2*t*t:-1+2*(2-t)*t},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return--t*t*t+1},easeInOutCubic:function(t){return t<.5?4*t*t*t:(t-1)*(2*t-2)*(2*t-2)+1},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return 1- --t*t*t*t},easeInOutQuart:function(t){return t<.5?8*t*t*t*t:1-8*--t*t*t*t},easeInQuint:function(t){return t*t*t*t*t},easeOutQuint:function(t){return 1+--t*t*t*t*t},easeInOutQuint:function(t){return t<.5?16*t*t*t*t*t:1+16*--t*t*t*t*t}}},initialize:function Mt(t,e,n,i,r,s){this.object=t;var a=typeof r,o="function"===a;this.type=o?a:"string"===a?r:"linear",this.easing=o?r:Mt.easings[this.type],this.duration=i,this.running=!1,this._then=null,this._startTime=null;var h=e||n;this._keys=h?Object.keys(h):[],this._parsedKeys=this._parseKeys(this._keys),this._from=h&&this._getState(e),this._to=h&&this._getState(n),s!==!1&&this.start()},then:function(t){return this._then=t,this},start:function(){return this._startTime=null,this.running=!0,this},stop:function(){return this.running=!1,this},update:function(t){if(this.running){t>1&&(t=1,this.running=!1);for(var e=this.easing(t),n=this._keys,i=function(n){return"function"==typeof n?n(e,t):n},s=0,a=n&&n.length;s<a;s++){var o=n[s],h=i(this._from[o]),u=i(this._to[o]),l=h&&u&&h.__add&&u.__add?u.__subtract(h).__multiply(e).__add(h):(u-h)*e+h;this._setProperty(this._parsedKeys[o],l)}!this.running&&this._then&&this._then(this.object),this.responds("update")&&this.emit("update",new r({progress:t,factor:e}))}return this},_events:{onUpdate:{}},_handleFrame:function(t){var e=this._startTime,n=e?(t-e)/this.duration:0;e||(this._startTime=t),this.update(n)},_getState:function(t){for(var e=this._keys,n={},i=0,r=e.length;i<r;i++){var s,a=e[i],o=this._parsedKeys[a],h=this._getProperty(o);if(t){var u=this._resolveValue(h,t[a]);this._setProperty(o,u),s=this._getProperty(o),s=s&&s.clone?s.clone():s,this._setProperty(o,h)}else s=h&&h.clone?h.clone():h;n[a]=s}return n},_resolveValue:function(t,e){if(e){if(Array.isArray(e)&&2===e.length){var n=e[0];return n&&n.match&&n.match(/^[+\-*\/]=/)?this._calculate(t,n[0],e[1]):e}if("string"==typeof e){var i=e.match(/^[+\-*\/]=(.*)/);if(i){var r=JSON.parse(i[1].replace(/(['"])?([a-zA-Z0-9_]+)(['"])?:/g,'"$2": '));return this._calculate(t,e[0],r)}}}return e},_calculate:function(t,e,n){return st.PaperScript.calculateBinary(t,e,n)},_parseKeys:function(t){for(var e={},n=0,i=t.length;n<i;n++){var r=t[n],s=r.replace(/\.([^.]*)/g,"/$1").replace(/\[['"]?([^'"\]]*)['"]?\]/g,"/$1");e[r]=s.split("/")}return e},_getProperty:function(t,e){for(var n=this.object,i=0,r=t.length-(e||0);i<r&&n;i++)n=n[t[i]];return n},_setProperty:function(t,e){var n=this._getProperty(t,1);n&&(n[t[t.length-1]]=e)}}),tt={request:function(e){var n=new t.XMLHttpRequest;return n.open((e.method||"get").toUpperCase(),e.url,r.pick(e.async,!0)),e.mimeType&&n.overrideMimeType(e.mimeType),n.onload=function(){var t=n.status;0===t||200===t?e.onLoad&&e.onLoad.call(n,n.responseText):n.onerror()},n.onerror=function(){var t=n.status,i='Could not load "'+e.url+'" (Status: '+t+")";if(!e.onError)throw new Error(i);e.onError(i,t)},n.send(null)}},et={canvases:[],getCanvas:function(t,e){if(!n)return null;var r,s=!0;"object"==typeof t&&(e=t.height,t=t.width),this.canvases.length?r=this.canvases.pop():(r=i.createElement("canvas"),s=!1);var a=r.getContext("2d");if(!a)throw new Error("Canvas "+r+" is unable to provide a 2D context.");return r.width===t&&r.height===e?s&&a.clearRect(0,0,t+1,e+1):(r.width=t,r.height=e),a.save(),r},getContext:function(t,e){var n=this.getCanvas(t,e);return n?n.getContext("2d"):null},release:function(t){var e=t&&t.canvas?t.canvas:t;e&&e.getContext&&(e.getContext("2d").restore(),this.canvases.push(e))}},nt=new function(){function t(t,e,n){return.2989*t+.587*e+.114*n}function e(e,n,i,r){var s=r-t(e,n,i);d=e+s,_=n+s,g=i+s;var r=t(d,_,g),a=v(d,_,g),o=p(d,_,g);if(a<0){var h=r-a;d=r+(d-r)*r/h,_=r+(_-r)*r/h,g=r+(g-r)*r/h}if(o>255){var u=255-r,l=o-r;d=r+(d-r)*u/l,_=r+(_-r)*u/l,g=r+(g-r)*u/l}}function n(t,e,n){return p(t,e,n)-v(t,e,n)}function i(t,e,n,i){var r,s=[t,e,n],a=p(t,e,n),o=v(t,e,n);o=o===t?0:o===e?1:2,a=a===t?0:a===e?1:2,r=0===v(o,a)?1===p(o,a)?2:1:0,s[a]>s[o]?(s[r]=(s[r]-s[o])*i/(s[a]-s[o]),s[a]=i):s[r]=s[a]=0,s[o]=0,d=s[0],_=s[1],g=s[2]}var s,a,o,h,u,l,c,f,d,_,g,v=Math.min,p=Math.max,m=Math.abs,y={multiply:function(){d=u*s/255,_=l*a/255,g=c*o/255},screen:function(){d=u+s-u*s/255,_=l+a-l*a/255,g=c+o-c*o/255},overlay:function(){d=u<128?2*u*s/255:255-2*(255-u)*(255-s)/255,_=l<128?2*l*a/255:255-2*(255-l)*(255-a)/255,g=c<128?2*c*o/255:255-2*(255-c)*(255-o)/255},"soft-light":function(){var t=s*u/255;d=t+u*(255-(255-u)*(255-s)/255-t)/255,t=a*l/255,_=t+l*(255-(255-l)*(255-a)/255-t)/255,t=o*c/255,g=t+c*(255-(255-c)*(255-o)/255-t)/255},"hard-light":function(){d=s<128?2*s*u/255:255-2*(255-s)*(255-u)/255,_=a<128?2*a*l/255:255-2*(255-a)*(255-l)/255,g=o<128?2*o*c/255:255-2*(255-o)*(255-c)/255},"color-dodge":function(){d=0===u?0:255===s?255:v(255,255*u/(255-s)),_=0===l?0:255===a?255:v(255,255*l/(255-a)),g=0===c?0:255===o?255:v(255,255*c/(255-o))},"color-burn":function(){d=255===u?255:0===s?0:p(0,255-255*(255-u)/s),_=255===l?255:0===a?0:p(0,255-255*(255-l)/a),g=255===c?255:0===o?0:p(0,255-255*(255-c)/o)},darken:function(){d=u<s?u:s,_=l<a?l:a,g=c<o?c:o},lighten:function(){d=u>s?u:s,_=l>a?l:a,g=c>o?c:o},difference:function(){d=u-s,d<0&&(d=-d),_=l-a,_<0&&(_=-_),g=c-o,g<0&&(g=-g)},exclusion:function(){d=u+s*(255-u-u)/255,_=l+a*(255-l-l)/255,g=c+o*(255-c-c)/255},hue:function(){i(s,a,o,n(u,l,c)),e(d,_,g,t(u,l,c))},saturation:function(){i(u,l,c,n(s,a,o)),e(d,_,g,t(u,l,c))},luminosity:function(){e(u,l,c,t(s,a,o))},color:function(){e(s,a,o,t(u,l,c))},add:function(){d=v(u+s,255),_=v(l+a,255),g=v(c+o,255)},subtract:function(){d=p(u-s,0),_=p(l-a,0),g=p(c-o,0)},average:function(){d=(u+s)/2,_=(l+a)/2,g=(c+o)/2},negation:function(){d=255-m(255-s-u),_=255-m(255-a-l),g=255-m(255-o-c)}},w=this.nativeModes=r.each(["source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","lighter","darker","copy","xor"],function(t){this[t]=!0},{}),x=et.getContext(1,1);x&&(r.each(y,function(t,e){var n="darken"===e,i=!1;x.save();try{x.fillStyle=n?"#300":"#a00",x.fillRect(0,0,1,1),x.globalCompositeOperation=e,x.globalCompositeOperation===e&&(x.fillStyle=n?"#a00":"#300",x.fillRect(0,0,1,1),i=x.getImageData(0,0,1,1).data[0]!==n?170:51)}catch(r){}x.restore(),w[e]=i}),et.release(x)),this.process=function(t,e,n,i,r){var v=e.canvas,p="normal"===t;if(p||w[t])n.save(),n.setTransform(1,0,0,1,0,0),n.globalAlpha=i,p||(n.globalCompositeOperation=t),n.drawImage(v,r.x,r.y),n.restore();else{var m=y[t];if(!m)return;for(var x=n.getImageData(r.x,r.y,v.width,v.height),b=x.data,C=e.getImageData(0,0,v.width,v.height).data,S=0,k=b.length;S<k;S+=4){s=C[S],u=b[S],a=C[S+1],l=b[S+1],o=C[S+2],
c=b[S+2],h=C[S+3],f=b[S+3],m();var I=h*i/255,P=1-I;b[S]=I*d+P*u,b[S+1]=I*_+P*l,b[S+2]=I*g+P*c,b[S+3]=h*i+P*f}n.putImageData(x,r.x,r.y)}}},it=new function(){function t(t,e,s){return n(i.createElementNS(r,t),e,s)}function e(t,e){var n=o[e],i=n?t.getAttributeNS(n,e):t.getAttribute(e);return"null"===i?null:i}function n(t,e,n){for(var i in e){var r=e[i],s=o[i];"number"==typeof r&&n&&(r=n.number(r)),s?t.setAttributeNS(s,i,r):t.setAttribute(i,r)}return t}var r="http://www.w3.org/2000/svg",s="http://www.w3.org/2000/xmlns",a="http://www.w3.org/1999/xlink",o={href:a,xlink:s,xmlns:s+"/","xmlns:xlink":s+"/"};return{svg:r,xmlns:s,xlink:a,create:t,get:e,set:n}},rt=r.each({fillColor:["fill","color"],fillRule:["fill-rule","string"],strokeColor:["stroke","color"],strokeWidth:["stroke-width","number"],strokeCap:["stroke-linecap","string"],strokeJoin:["stroke-linejoin","string"],strokeScaling:["vector-effect","lookup",{"true":"none","false":"non-scaling-stroke"},function(t,e){return!e&&(t instanceof z||t instanceof C||t instanceof F)}],miterLimit:["stroke-miterlimit","number"],dashArray:["stroke-dasharray","array"],dashOffset:["stroke-dashoffset","number"],fontFamily:["font-family","string"],fontWeight:["font-weight","string"],fontSize:["font-size","number"],justification:["text-anchor","lookup",{left:"start",center:"middle",right:"end"}],opacity:["opacity","number"],blendMode:["mix-blend-mode","style"]},function(t,e){var n=r.capitalize(e),i=t[2];this[e]={type:t[1],property:e,attribute:t[0],toSVG:i,fromSVG:i&&r.each(i,function(t,e){this[t]=e},{}),exportFilter:t[3],get:"get"+n,set:"set"+n}},{});new function(){function e(t,e,n){var i=new r,s=t.getTranslation();if(e){t=t._shiftless();var a=t._inverseTransform(s);i[n?"cx":"x"]=a.x,i[n?"cy":"y"]=a.y,s=null}if(!t.isIdentity()){var o=t.decompose();if(o){var h=[],l=o.rotation,c=o.scaling,f=o.skewing;s&&!s.isZero()&&h.push("translate("+S.point(s)+")"),l&&h.push("rotate("+S.number(l)+")"),u.isZero(c.x-1)&&u.isZero(c.y-1)||h.push("scale("+S.point(c)+")"),f.x&&h.push("skewX("+S.number(f.x)+")"),f.y&&h.push("skewY("+S.number(f.y)+")"),i.transform=h.join(" ")}else i.transform="matrix("+t.getValues().join(",")+")"}return i}function n(t,n){for(var i=e(t._matrix),r=t._children,s=it.create("g",i,S),a=0,o=r.length;a<o;a++){var h=r[a],u=b(h,n);if(u)if(h.isClipMask()){var l=it.create("clipPath");l.appendChild(u),m(h,l,"clip"),it.set(s,{"clip-path":"url(#"+l.id+")"})}else s.appendChild(u)}return s}function i(t,n){var i=e(t._matrix,!0),r=t.getSize(),s=t.getImage();return i.x-=r.width/2,i.y-=r.height/2,i.width=r.width,i.height=r.height,i.href=0==n.embedImages&&s&&s.src||t.toDataURL(),it.create("image",i,S)}function s(t,n){var i=n.matchShapes;if(i){var r=t.toShape(!1);if(r)return a(r,n)}var s,o=t._segments,h=o.length,u=e(t._matrix);if(i&&h>=2&&!t.hasHandles())if(h>2){s=t._closed?"polygon":"polyline";for(var l=[],c=0;c<h;c++)l.push(S.point(o[c]._point));u.points=l.join(" ")}else{s="line";var f=o[0]._point,d=o[1]._point;u.set({x1:f.x,y1:f.y,x2:d.x,y2:d.y})}else s="path",u.d=t.getPathData(null,n.precision);return it.create(s,u,S)}function a(t){var n=t._type,i=t._radius,r=e(t._matrix,!0,"rectangle"!==n);if("rectangle"===n){n="rect";var s=t._size,a=s.width,o=s.height;r.x-=a/2,r.y-=o/2,r.width=a,r.height=o,i.isZero()&&(i=null)}return i&&("circle"===n?r.r=i:(r.rx=i.width,r.ry=i.height)),it.create(n,r,S)}function o(t,n){var i=e(t._matrix),r=t.getPathData(null,n.precision);return r&&(i.d=r),it.create("path",i,S)}function c(t,n){var i=e(t._matrix,!0),r=t._definition,s=v(r,"symbol"),a=r._item,o=a.getBounds();return s||(s=it.create("symbol",{viewBox:S.rectangle(o)}),s.appendChild(b(a,n)),m(r,s,"symbol")),i.href="#"+s.id,i.x+=o.x,i.y+=o.y,i.width=o.width,i.height=o.height,i.overflow="visible",it.create("use",i,S)}function f(t){var e=v(t,"color");if(!e){var n,i=t.getGradient(),r=i._radial,s=t.getOrigin(),a=t.getDestination();if(r){n={cx:s.x,cy:s.y,r:s.getDistance(a)};var o=t.getHighlight();o&&(n.fx=o.x,n.fy=o.y)}else n={x1:s.x,y1:s.y,x2:a.x,y2:a.y};n.gradientUnits="userSpaceOnUse",e=it.create((r?"radial":"linear")+"Gradient",n,S);for(var h=i._stops,u=0,l=h.length;u<l;u++){var c=h[u],f=c._color,d=f.getAlpha(),_=c._offset;n={offset:null==_?u/(l-1):_},f&&(n["stop-color"]=f.toCSS(!0)),d<1&&(n["stop-opacity"]=d),e.appendChild(it.create("stop",n,S))}m(t,e,"color")}return"url(#"+e.id+")"}function d(t){var n=it.create("text",e(t._matrix,!0),S);return n.textContent=t._content,n}function _(t,e,n){var i={},s=!n&&t.getParent(),a=[];return null!=t._name&&(i.id=t._name),r.each(rt,function(e){var n=e.get,o=e.type,h=t[n]();if(e.exportFilter?e.exportFilter(t,h):!s||!r.equals(s[n](),h)){if("color"===o&&null!=h){var u=h.getAlpha();u<1&&(i[e.attribute+"-opacity"]=u)}"style"===o?a.push(e.attribute+": "+h):i[e.attribute]=null==h?"none":"color"===o?h.gradient?f(h,t):h.toCSS(!0):"array"===o?h.join(","):"lookup"===o?e.toSVG[h]:h}}),a.length&&(i.style=a.join(";")),1===i.opacity&&delete i.opacity,t._visible||(i.visibility="hidden"),it.set(e,i,S)}function v(t,e){return k||(k={ids:{},svgs:{}}),t&&k.svgs[e+"-"+(t._id||t.__id||(t.__id=l.get("svg")))]}function m(t,e,n){k||v();var i=k.ids[n]=(k.ids[n]||0)+1;e.id=n+"-"+i,k.svgs[n+"-"+(t._id||t.__id)]=e}function x(e,n){var i=e,r=null;if(k){i="svg"===e.nodeName.toLowerCase()&&e;for(var s in k.svgs)r||(i||(i=it.create("svg"),i.appendChild(e)),r=i.insertBefore(it.create("defs"),i.firstChild)),r.appendChild(k.svgs[s]);k=null}return n.asString?(new t.XMLSerializer).serializeToString(i):i}function b(t,e,n){var i=I[t._class],r=i&&i(t,e);if(r){var s=e.onExport;s&&(r=s(t,r,e)||r);var a=JSON.stringify(t._data);a&&"{}"!==a&&"null"!==a&&r.setAttribute("data-paper-data",a)}return r&&_(t,r,n)}function C(t){return t||(t={}),S=new h(t.precision),t}var S,k,I={Group:n,Layer:n,Raster:i,Path:s,Shape:a,CompoundPath:o,SymbolItem:c,PointText:d};w.inject({exportSVG:function(t){return t=C(t),x(b(this,t,!0),t)}}),y.inject({exportSVG:function(t){t=C(t);var n=this._children,i=this.getView(),s=r.pick(t.bounds,"view"),a=t.matrix||"view"===s&&i._matrix,o=a&&p.read([a]),h="view"===s?new g([0,0],i.getViewSize()):"content"===s?w._getBounds(n,o,{stroke:!0}).rect:g.read([s],0,{readNull:!0}),u={version:"1.1",xmlns:it.svg,"xmlns:xlink":it.xlink};h&&(u.width=h.width,u.height=h.height,(h.x||h.y)&&(u.viewBox=S.rectangle(h)));var l=it.create("svg",u,S),c=l;o&&!o.isIdentity()&&(c=l.appendChild(it.create("g",e(o),S)));for(var f=0,d=n.length;f<d;f++)c.appendChild(b(n[f],t,!0));return x(l,t)}})},new function(){function s(t,e,n,i,r){var s=it.get(t,e),a=null==s?i?null:n?"":0:n?s:parseFloat(s);return/%\s*$/.test(s)?a/100*(r?1:A[/x|^width/.test(e)?"width":"height"]):a}function a(t,e,n,i,r){return e=s(t,e||"x",!1,i,r),n=s(t,n||"y",!1,i,r),!i||null!=e&&null!=n?new c(e,n):null}function o(t,e,n,i,r){return e=s(t,e||"width",!1,i,r),n=s(t,n||"height",!1,i,r),!i||null!=e&&null!=n?new d(e,n):null}function h(t,e,n){return"none"===t?null:"number"===e?parseFloat(t):"array"===e?t?t.split(/[\s,]+/g).map(parseFloat):[]:"color"===e?P(t)||t:"lookup"===e?n[t]:t}function u(t,e,n,i){var r=t.childNodes,s="clippath"===e,a="defs"===e,o=new x,h=o._project,u=h._currentStyle,l=[];if(s||a||(o=k(o,t,i),h._currentStyle=o._style.clone()),i)for(var c=t.querySelectorAll("defs"),f=0,d=c.length;f<d;f++)T(c[f],n,!1);for(var f=0,d=r.length;f<d;f++){var _,g=r[f];1!==g.nodeType||/^defs$/i.test(g.nodeName)||!(_=T(g,n,!1))||_ instanceof I||l.push(_)}return o.addChildren(l),s&&(o=k(o.reduce(),t,i)),h._currentStyle=u,(s||a)&&(o.remove(),o=null),o}function l(t,e){for(var n=t.getAttribute("points").match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g),i=[],r=0,s=n.length;r<s;r+=2)i.push(new c(parseFloat(n[r]),parseFloat(n[r+1])));var a=new L(i);return"polygon"===e&&a.closePath(),a}function f(t){return z.create(t.getAttribute("d"))}function _(t,e){var n,i=(s(t,"href",!0)||"").substring(1),r="radialgradient"===e;if(i)n=O[i].getGradient(),n._radial^r&&(n=n.clone(),n._radial=r);else{for(var o=t.childNodes,h=[],u=0,l=o.length;u<l;u++){var c=o[u];1===c.nodeType&&h.push(k(new q,c))}n=new R(h,r)}var f,d,_,g="userSpaceOnUse"!==s(t,"gradientUnits",!0);r?(f=a(t,"cx","cy",!1,g),d=f.add(s(t,"r",!1,!1,g),0),_=a(t,"fx","fy",!0,g)):(f=a(t,"x1","y1",!1,g),d=a(t,"x2","y2",!1,g));var v=k(new D(n,f,d,_),t);return v._scaleToBounds=g,null}function v(t,e,n,i){if(t.transform){for(var r=(i.getAttribute(n)||"").split(/\)\s*/g),s=new p,a=0,o=r.length;a<o;a++){var h=r[a];if(!h)break;for(var u=h.split(/\(\s*/),l=u[0],c=u[1].split(/[\s,]+/g),f=0,d=c.length;f<d;f++)c[f]=parseFloat(c[f]);switch(l){case"matrix":s.append(new p(c[0],c[1],c[2],c[3],c[4],c[5]));break;case"rotate":s.rotate(c[0],c[1]||0,c[2]||0);break;case"translate":s.translate(c[0],c[1]||0);break;case"scale":s.scale(c);break;case"skewX":s.skew(c[0],0);break;case"skewY":s.skew(0,c[0])}}t.transform(s)}}function m(t,e,n){var i="fill-opacity"===n?"getFillColor":"getStrokeColor",r=t[i]&&t[i]();r&&r.setAlpha(parseFloat(e))}function b(t,n,i){var s=t.attributes[n],a=s&&s.value;if(!a&&t.style){var o=r.camelize(n);a=t.style[o],a||i.node[o]===i.parent[o]||(a=i.node[o])}return a?"none"===a?null:a:e}function k(t,n,i){var s=n.parentNode,a={node:U.getStyles(n)||{},parent:!i&&!/^defs$/i.test(s.tagName)&&U.getStyles(s)||{}};return r.each(N,function(i,r){var s=b(n,r,a);t=s!==e&&i(t,s,r,n,a)||t}),t}function P(t){var e=t&&t.match(/\((?:["'#]*)([^"')]+)/),i=e&&e[1],r=i&&O[n?i.replace(n.location.href.split("#")[0]+"#",""):i];return r&&r._scaleToBounds&&(r=r.clone(),r._scaleToBounds=!0),r}function T(t,e,n){var s,a,h,u=t.nodeName.toLowerCase(),l="#document"!==u,c=i.body;n&&l&&(A=st.getView().getSize(),A=o(t,null,null,!0)||A,s=it.create("svg",{style:"stroke-width: 1px; stroke-miterlimit: 10"}),a=t.parentNode,h=t.nextSibling,s.appendChild(t),c.appendChild(s));var f=st.settings,d=f.applyMatrix,_=f.insertItems;f.applyMatrix=!1,f.insertItems=!1;var g=E[u],v=g&&g(t,u,e,n)||null;if(f.insertItems=_,f.applyMatrix=d,v){!l||v instanceof x||(v=k(v,t,n));var p=e.onImport,m=l&&t.getAttribute("data-paper-data");p&&(v=p(t,v,e)||v),e.expandShapes&&v instanceof C&&(v.remove(),v=v.toPath()),m&&(v._data=JSON.parse(m))}return s&&(c.removeChild(s),a&&(h?a.insertBefore(t,h):a.appendChild(t))),n&&(O={},v&&r.pick(e.applyMatrix,d)&&v.matrix.apply(!0,!0)),v}function M(n,r,s){function a(i){try{var a="object"==typeof i?i:(new t.DOMParser).parseFromString(i,"image/svg+xml");if(!a.nodeName)throw a=null,new Error("Unsupported SVG source: "+n);st=h,u=T(a,r,!0),r&&r.insert===!1||s._insertItem(e,u);var l=r.onLoad;l&&l(u,i)}catch(c){o(c)}}function o(t,e){var n=r.onError;if(!n)throw new Error(t);n(t,e)}if(!n)return null;r="function"==typeof r?{onLoad:r}:r||{};var h=st,u=null;if("string"!=typeof n||/^.*</.test(n)){if("undefined"!=typeof File&&n instanceof File){var l=new FileReader;return l.onload=function(){a(l.result)},l.onerror=function(){o(l.error)},l.readAsText(n)}a(n)}else{var c=i.getElementById(n);c?a(c):tt.request({url:n,async:!0,onLoad:a,onError:o})}return u}var A,O={},E={"#document":function(t,e,n,i){for(var r=t.childNodes,s=0,a=r.length;s<a;s++){var o=r[s];if(1===o.nodeType)return T(o,n,i)}},g:u,svg:u,clippath:u,polygon:l,polyline:l,path:f,lineargradient:_,radialgradient:_,image:function(t){var e=new S(s(t,"href",!0));return e.on("load",function(){var e=o(t);this.setSize(e);var n=a(t).add(e.divide(2));this._matrix.append((new p).translate(n))}),e},symbol:function(t,e,n,i){return new I(u(t,e,n,i),(!0))},defs:u,use:function(t){var e=(s(t,"href",!0)||"").substring(1),n=O[e],i=a(t);return n?n instanceof I?n.place(i):n.clone().translate(i):null},circle:function(t){return new C.Circle(a(t,"cx","cy"),s(t,"r"))},ellipse:function(t){return new C.Ellipse({center:a(t,"cx","cy"),radius:o(t,"rx","ry")})},rect:function(t){return new C.Rectangle(new g(a(t),o(t)),o(t,"rx","ry"))},line:function(t){return new L.Line(a(t,"x1","y1"),a(t,"x2","y2"))},text:function(t){var e=new j(a(t).add(a(t,"dx","dy")));return e.setContent(t.textContent.trim()||""),e}},N=r.set(r.each(rt,function(t){this[t.attribute]=function(e,n){if(e[t.set]&&(e[t.set](h(n,t.type,t.fromSVG)),"color"===t.type)){var i=e[t.get]();if(i&&i._scaleToBounds){var r=e.getBounds();i.transform((new p).translate(r.getPoint()).scale(r.getSize()))}}}},{}),{id:function(t,e){O[e]=t,t.setName&&t.setName(e)},"clip-path":function(t,e){var n=P(e);if(n){if(n=n.clone(),n.setClipMask(!0),!(t instanceof x))return new x(n,t);t.insertChild(0,n)}},gradientTransform:v,transform:v,"fill-opacity":m,"stroke-opacity":m,visibility:function(t,e){t.setVisible&&t.setVisible("visible"===e)},display:function(t,e){t.setVisible&&t.setVisible(null!==e)},"stop-color":function(t,e){t.setColor&&t.setColor(e)},"stop-opacity":function(t,e){t._color&&t._color.setAlpha(parseFloat(e))},offset:function(t,e){if(t.setOffset){var n=e.match(/(.*)%$/);t.setOffset(n?n[1]/100:parseFloat(e))}},viewBox:function(t,e,n,i,r){var s,a,u=new g(h(e,"array")),l=o(i,null,null,!0);if(t instanceof x){var c=l?l.divide(u.getSize()):1,a=(new p).scale(c).translate(u.getPoint().negate());s=t}else t instanceof I&&(l&&u.setSize(l),s=t._item);if(s){if("visible"!==b(i,"overflow",r)){var f=new C.Rectangle(u);f.setClipMask(!0),s.addChild(f)}a&&s.transform(a)}}});w.inject({importSVG:function(t,e){return M(t,e,this)}}),y.inject({importSVG:function(t,e){return this.activate(),M(t,e,this)}})},r.exports.PaperScript=function(){function e(t,e){return(g.acorn||v).parse(t,e)}function s(t,e,n){var i=w[e];if(t&&t[i]){var r=t[i](n);return"!="===e?!r:r}switch(e){case"+":return t+n;case"-":return t-n;case"*":return t*n;case"/":return t/n;case"%":return t%n;case"==":return t==n;case"!=":return t!=n}}function o(t,e){var n=x[t];if(e&&e[n])return e[n]();switch(t){case"+":return+e;case"-":return-e}}function h(r,s){function a(t){for(var e=0,n=d.length;e<n;e++){var i=d[e];if(i[0]>=t)break;t+=i[1]}return t}function o(t){return r.substring(a(t.range[0]),a(t.range[1]))}function h(t,e){return r.substring(a(t.range[1]),a(e.range[0]))}function u(t,e){for(var n=a(t.range[0]),i=a(t.range[1]),s=0,o=d.length-1;o>=0;o--)if(n>d[o][0]){s=o+1;break}d.splice(s,0,[n,e.length-i+n]),r=r.substring(0,n)+e+r.substring(i)}function l(t,e){if(t){for(var n in t)if("range"!==n&&"loc"!==n){var i=t[n];if(Array.isArray(i))for(var r=0,s=i.length;r<s;r++)l(i[r],t);else i&&"object"==typeof i&&l(i,t)}switch(t.type){case"UnaryExpression":if(t.operator in x&&"Literal"!==t.argument.type){var a=o(t.argument);u(t,'$__("'+t.operator+'", '+a+")")}break;case"BinaryExpression":if(t.operator in w&&"Literal"!==t.left.type){var c=o(t.left),f=o(t.right),d=h(t.left,t.right),_=t.operator;u(t,"__$__("+c+","+d.replace(new RegExp("\\"+_),'"'+_+'"')+", "+f+")")}break;case"UpdateExpression":case"AssignmentExpression":var g=e&&e.type;if(!("ForStatement"===g||"BinaryExpression"===g&&/^[=!<>]/.test(e.operator)||"MemberExpression"===g&&e.computed))if("UpdateExpression"===t.type){var a=o(t.argument),v="__$__("+a+', "'+t.operator[0]+'", 1)',p=a+" = "+v;t.prefix||"AssignmentExpression"!==g&&"VariableDeclarator"!==g||(o(e.left||e.id)===a&&(p=v),p=a+"; "+p),u(t,p)}else if(/^.=$/.test(t.operator)&&"Literal"!==t.left.type){var c=o(t.left),f=o(t.right),v=c+" = __$__("+c+', "'+t.operator[0]+'", '+f+")";u(t,/^\(.*\)$/.test(o(t))?"("+v+")":v)}break;case"ExportDefaultDeclaration":u({range:[t.start,t.declaration.start]},"module.exports = ");break;case"ExportNamedDeclaration":var m=t.declaration,y=t.specifiers;if(m){var b=m.declarations;b&&(b.forEach(function(t){u(t,"module.exports."+o(t))}),u({range:[t.start,m.start+m.kind.length]},""))}else if(y){var C=y.map(function(t){var e=o(t);return"module.exports."+e+" = "+e+"; "}).join("");C&&u(t,C)}}}}function c(t){var e="",n="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";for(t=(Math.abs(t)<<1)+(t<0?1:0);t||!e;){var i=31&t;t>>=5,t&&(i|=32),e+=n[i]}return e}if(!r)return"";s=s||{};var f,d=[],_=s.url||"",g=st.agent,v=g.versionNumber,p=!1,m=s.sourceMaps,y=s.source||r,b=/\r\n|\n|\r/gm,C=s.offset||0;if(m&&(g.chrome&&v>=30||g.webkit&&v>=537.76||g.firefox&&v>=23||g.node)){if(g.node)C-=2;else if(n&&_&&!n.location.href.indexOf(_)){var S=i.getElementsByTagName("html")[0].innerHTML;C=S.substr(0,S.indexOf(r)+1).match(b).length+1}p=C>0&&!(g.chrome&&v>=36||g.safari&&v>=600||g.firefox&&v>=40||g.node);var k=["AA"+c(p?0:C)+"A"];k.length=(r.match(b)||[]).length+1+(p?C:0),f={version:3,file:_,names:[],mappings:k.join(";AACA"),sourceRoot:"",sources:[_],sourcesContent:[y]}}return l(e(r,{ranges:!0,preserveParens:!0,sourceType:"module"})),f&&(p&&(r=new Array(C+1).join("\n")+r),/^(inline|both)$/.test(m)&&(r+="\n//# sourceMappingURL=data:application/json;base64,"+t.btoa(unescape(encodeURIComponent(JSON.stringify(f))))),r+="\n//# sourceURL="+(_||"paperscript")),{url:_,source:y,code:r,map:f}}function u(t,e,n){function a(e,n){for(var i in e)!n&&/^_/.test(i)||!new RegExp("([\\b\\s\\W]|^)"+i.replace(/\$/g,"\\$")+"\\b").test(t)||(g.push(i),v.push(e[i]))}st=e;var u,l=e.getView(),f=/\btool\.\w+|\s+on(?:Key|Mouse)(?:Up|Down|Move|Drag)\b/.test(t)&&!/\bnew\s+Tool\b/.test(t)?new Q:null,d=f?f._events:[],_=["onFrame","onResize"].concat(d),g=[],v=[],p="object"==typeof t?t:h(t,n);t=p.code,a({__$__:s,$__:o,paper:e,view:l,tool:f},!0),a(e),t="var module = { exports: {} }; "+t;var m=r.each(_,function(e){new RegExp("\\s+"+e+"\\b").test(t)&&(g.push(e),this.push("module.exports."+e+" = "+e+";"))},[]).join("\n");m&&(t+="\n"+m),t+="\nreturn module.exports;";var y=st.agent;if(i&&(y.chrome||y.firefox&&y.versionNumber<40)){var w=i.createElement("script"),x=i.head||i.getElementsByTagName("head")[0];y.firefox&&(t="\n"+t),w.appendChild(i.createTextNode("document.__paperscript__ = function("+g+") {"+t+"\n}")),x.appendChild(w),u=i.__paperscript__,delete i.__paperscript__,x.removeChild(w)}else u=Function(g,t);var m=u&&u.apply(e,v),b=m||{};return r.each(d,function(t){var e=b[t];e&&(f[t]=e)}),l&&(b.onResize&&l.setOnResize(b.onResize),l.emit("resize",{size:l.size,delta:new c}),b.onFrame&&l.setOnFrame(b.onFrame),l.requestUpdate()),m}function l(t){if(/^text\/(?:x-|)paperscript$/.test(t.type)&&"true"!==a.getAttribute(t,"ignore")){var e=a.getAttribute(t,"canvas"),n=i.getElementById(e),r=t.src||t.getAttribute("data-src"),s=a.hasAttribute(t,"async"),o="data-paper-scope";if(!n)throw new Error('Unable to find canvas with id "'+e+'"');var h=a.get(n.getAttribute(o))||(new a).setup(n);return n.setAttribute(o,h._id),r?tt.request({url:r,async:s,mimeType:"text/plain",onLoad:function(t){u(t,h,r)}}):u(t.innerHTML,h,t.baseURI),t.setAttribute("data-paper-ignore","true"),h}}function f(){r.each(i&&i.getElementsByTagName("script"),l)}function _(t){return t?l(t):f()}var g=this,v=g.acorn;if(!v&&"undefined"!=typeof require)try{v=require("acorn")}catch(p){}if(!v){var m,y;v=m=y={},function(t,e){return"object"==typeof m&&"object"==typeof y?e(m):"function"==typeof define&&define.amd?define(["exports"],e):void e(t.acorn||(t.acorn={}))}(this,function(t){"use strict";function e(t){ct=t||{};for(var e in gt)Object.prototype.hasOwnProperty.call(ct,e)||(ct[e]=gt[e]);_t=ct.sourceFile||null}function n(t,e){var n=vt(ft,t);e+=" ("+n.line+":"+n.column+")";var i=new SyntaxError(e);throw i.pos=t,i.loc=n,i.raisedAt=pt,i}function i(t){function e(t){if(1==t.length)return n+="return str === "+JSON.stringify(t[0])+";";n+="switch(str){";for(var e=0;e<t.length;++e)n+="case "+JSON.stringify(t[e])+":";n+="return true}return false;"}t=t.split(" ");var n="",i=[];t:for(var r=0;r<t.length;++r){for(var s=0;s<i.length;++s)if(i[s][0].length==t[r].length){i[s].push(t[r]);continue t}i.push([t[r]])}if(i.length>3){i.sort(function(t,e){return e.length-t.length}),n+="switch(str.length){";for(var r=0;r<i.length;++r){var a=i[r];n+="case "+a[0].length+":",e(a)}n+="}"}else e(t);return new Function("str",n)}function r(){this.line=kt,this.column=pt-It}function s(){kt=1,pt=It=0,St=!0,u()}function a(t,e){yt=pt,ct.locations&&(xt=new r),bt=t,u(),Ct=e,St=t.beforeExpr}function o(){var t=ct.onComment&&ct.locations&&new r,e=pt,i=ft.indexOf("*/",pt+=2);if(i===-1&&n(pt-2,"Unterminated comment"),pt=i+2,ct.locations){Xe.lastIndex=e;for(var s;(s=Xe.exec(ft))&&s.index<pt;)++kt,It=s.index+s[0].length}ct.onComment&&ct.onComment(!0,ft.slice(e+2,i),e,pt,t,ct.locations&&new r)}function h(){for(var t=pt,e=ct.onComment&&ct.locations&&new r,n=ft.charCodeAt(pt+=2);pt<dt&&10!==n&&13!==n&&8232!==n&&8233!==n;)++pt,n=ft.charCodeAt(pt);ct.onComment&&ct.onComment(!1,ft.slice(t+2,pt),t,pt,e,ct.locations&&new r)}function u(){for(;pt<dt;){var t=ft.charCodeAt(pt);if(32===t)++pt;else if(13===t){++pt;var e=ft.charCodeAt(pt);10===e&&++pt,ct.locations&&(++kt,It=pt)}else if(10===t||8232===t||8233===t)++pt,ct.locations&&(++kt,It=pt);else if(t>8&&t<14)++pt;else if(47===t){var e=ft.charCodeAt(pt+1);if(42===e)o();else{if(47!==e)break;h()}}else if(160===t)++pt;else{if(!(t>=5760&&He.test(String.fromCharCode(t))))break;++pt}}}function l(){var t=ft.charCodeAt(pt+1);return t>=48&&t<=57?S(!0):(++pt,a(we))}function c(){var t=ft.charCodeAt(pt+1);return St?(++pt,x()):61===t?w(Se,2):w(be,1)}function f(){var t=ft.charCodeAt(pt+1);return 61===t?w(Se,2):w(Be,1)}function d(t){var e=ft.charCodeAt(pt+1);return e===t?w(124===t?Pe:Te,2):61===e?w(Se,2):w(124===t?Me:Oe,1)}function _(){var t=ft.charCodeAt(pt+1);return 61===t?w(Se,2):w(Ae,1)}function g(t){var e=ft.charCodeAt(pt+1);return e===t?45==e&&62==ft.charCodeAt(pt+2)&&Je.test(ft.slice(Tt,pt))?(pt+=3,h(),u(),y()):w(ke,2):61===e?w(Se,2):w(Ne,1)}function v(t){var e=ft.charCodeAt(pt+1),n=1;return e===t?(n=62===t&&62===ft.charCodeAt(pt+2)?3:2,61===ft.charCodeAt(pt+n)?w(Se,n+1):w(Ee,n)):33==e&&60==t&&45==ft.charCodeAt(pt+2)&&45==ft.charCodeAt(pt+3)?(pt+=4,h(),u(),y()):(61===e&&(n=61===ft.charCodeAt(pt+2)?3:2),w(Le,n))}function p(t){var e=ft.charCodeAt(pt+1);return 61===e?w(ze,61===ft.charCodeAt(pt+2)?3:2):w(61===t?Ce:Ie,1)}function m(t){switch(t){case 46:return l();case 40:return++pt,a(ge);case 41:return++pt,a(ve);case 59:return++pt,a(me);case 44:return++pt,a(pe);case 91:return++pt,a(ce);case 93:return++pt,a(fe);case 123:return++pt,a(de);case 125:return++pt,a(_e);case 58:return++pt,a(ye);case 63:return++pt,a(xe);case 48:var e=ft.charCodeAt(pt+1);if(120===e||88===e)return C();case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:return S(!1);case 34:case 39:return k(t);case 47:return c(t);case 37:case 42:return f();case 124:case 38:return d(t);case 94:return _();case 43:case 45:return g(t);case 60:case 62:return v(t);case 61:case 33:return p(t);case 126:return w(Ie,1)}return!1}function y(t){if(t?pt=mt+1:mt=pt,ct.locations&&(wt=new r),t)return x();if(pt>=dt)return a(jt);var e=ft.charCodeAt(pt);if(Ke(e)||92===e)return T();var i=m(e);if(i===!1){var s=String.fromCharCode(e);if("\\"===s||$e.test(s))return T();n(pt,"Unexpected character '"+s+"'")}return i}function w(t,e){var n=ft.slice(pt,pt+e);pt+=e,a(t,n)}function x(){for(var t,e,i="",r=pt;;){pt>=dt&&n(r,"Unterminated regular expression");var s=ft.charAt(pt);if(Je.test(s)&&n(r,"Unterminated regular expression"),t)t=!1;else{if("["===s)e=!0;else if("]"===s&&e)e=!1;else if("/"===s&&!e)break;t="\\"===s}++pt}var i=ft.slice(r,pt);++pt;var o=P();o&&!/^[gmsiy]*$/.test(o)&&n(r,"Invalid regexp flag");try{var h=new RegExp(i,o)}catch(u){u instanceof SyntaxError&&n(r,u.message),n(u)}return a(Nt,h)}function b(t,e){for(var n=pt,i=0,r=0,s=null==e?1/0:e;r<s;++r){var a,o=ft.charCodeAt(pt);if(a=o>=97?o-97+10:o>=65?o-65+10:o>=48&&o<=57?o-48:1/0,a>=t)break;++pt,i=i*t+a}return pt===n||null!=e&&pt-n!==e?null:i}function C(){pt+=2;var t=b(16);return null==t&&n(mt+2,"Expected hexadecimal number"),Ke(ft.charCodeAt(pt))&&n(pt,"Identifier directly after number"),a(Et,t)}function S(t){var e=pt,i=!1,r=48===ft.charCodeAt(pt);t||null!==b(10)||n(e,"Invalid number"),46===ft.charCodeAt(pt)&&(++pt,b(10),i=!0);var s=ft.charCodeAt(pt);69!==s&&101!==s||(s=ft.charCodeAt(++pt),43!==s&&45!==s||++pt,null===b(10)&&n(e,"Invalid number"),i=!0),Ke(ft.charCodeAt(pt))&&n(pt,"Identifier directly after number");var o,h=ft.slice(e,pt);return i?o=parseFloat(h):r&&1!==h.length?/[89]/.test(h)||zt?n(e,"Invalid number"):o=parseInt(h,8):o=parseInt(h,10),a(Et,o)}function k(t){pt++;for(var e="";;){pt>=dt&&n(mt,"Unterminated string constant");var i=ft.charCodeAt(pt);if(i===t)return++pt,a(Bt,e);if(92===i){i=ft.charCodeAt(++pt);var r=/^[0-7]+/.exec(ft.slice(pt,pt+3));for(r&&(r=r[0]);r&&parseInt(r,8)>255;)r=r.slice(0,-1);if("0"===r&&(r=null),++pt,r)zt&&n(pt-2,"Octal literal in strict mode"),e+=String.fromCharCode(parseInt(r,8)),pt+=r.length-1;else switch(i){case 110:e+="\n";break;case 114:e+="\r";break;case 120:e+=String.fromCharCode(I(2));break;case 117:e+=String.fromCharCode(I(4));break;case 85:e+=String.fromCharCode(I(8));break;case 116:e+="\t";break;case 98:e+="\b";break;case 118:e+="\x0B";break;case 102:e+="\f";break;case 48:e+="\0";break;case 13:10===ft.charCodeAt(pt)&&++pt;case 10:ct.locations&&(It=pt,++kt);break;default:e+=String.fromCharCode(i)}}else 13!==i&&10!==i&&8232!==i&&8233!==i||n(mt,"Unterminated string constant"),e+=String.fromCharCode(i),++pt}}function I(t){var e=b(16,t);return null===e&&n(mt,"Bad character escape sequence"),e}function P(){je=!1;for(var t,e=!0,i=pt;;){var r=ft.charCodeAt(pt);if(Qe(r))je&&(t+=ft.charAt(pt)),++pt;else{if(92!==r)break;je||(t=ft.slice(i,pt)),je=!0,117!=ft.charCodeAt(++pt)&&n(pt,"Expecting Unicode escape sequence \\uXXXX"),++pt;var s=I(4),a=String.fromCharCode(s);a||n(pt-1,"Invalid Unicode escape"),(e?Ke(s):Qe(s))||n(pt-4,"Invalid Unicode escape"),t+=a}e=!1}return je?t:ft.slice(i,pt)}function T(){var t=P(),e=Ft;return!je&&Ue(t)&&(e=le[t]),a(e,t)}function M(){Pt=mt,Tt=yt,Mt=xt,y()}function A(t){if(zt=t,pt=mt,ct.locations)for(;pt<It;)It=ft.lastIndexOf("\n",It-2)+1,--kt;u(),y()}function O(){this.type=null,this.start=mt,this.end=null}function z(){this.start=wt,this.end=null,null!==_t&&(this.source=_t)}function L(){var t=new O;return ct.locations&&(t.loc=new z),ct.directSourceFile&&(t.sourceFile=ct.directSourceFile),ct.ranges&&(t.range=[mt,0]),t}function E(t){var e=new O;return e.start=t.start,ct.locations&&(e.loc=new z,e.loc.start=t.loc.start),ct.ranges&&(e.range=[t.range[0],0]),e}function N(t,e){return t.type=e,t.end=Tt,ct.locations&&(t.loc.end=Mt),ct.ranges&&(t.range[1]=Tt),t}function B(t){return ct.ecmaVersion>=5&&"ExpressionStatement"===t.type&&"Literal"===t.expression.type&&"use strict"===t.expression.value}function F(t){if(bt===t)return M(),!0}function j(){return!ct.strictSemicolons&&(bt===jt||bt===_e||Je.test(ft.slice(Tt,mt)))}function D(){F(me)||j()||q()}function R(t){bt===t?M():q()}function q(){n(mt,"Unexpected token")}function V(t){"Identifier"!==t.type&&"MemberExpression"!==t.type&&n(t.start,"Assigning to rvalue"),zt&&"Identifier"===t.type&&Ve(t.name)&&n(t.start,"Assigning to "+t.name+" in strict mode")}function U(t){Pt=Tt=pt,ct.locations&&(Mt=new r),At=zt=null,Ot=[],y();var e=t||L(),n=!0;for(t||(e.body=[]);bt!==jt;){var i=H();e.body.push(i),n&&B(i)&&A(!0),n=!1}return N(e,"Program")}function H(){(bt===be||bt===Se&&"/="==Ct)&&y(!0);var t=bt,e=L();switch(t){case Dt:case Vt:M();var i=t===Dt;F(me)||j()?e.label=null:bt!==Ft?q():(e.label=lt(),D());for(var r=0;r<Ot.length;++r){var s=Ot[r];if(null==e.label||s.name===e.label.name){if(null!=s.kind&&(i||"loop"===s.kind))break;if(e.label&&i)break}}return r===Ot.length&&n(e.start,"Unsyntactic "+t.keyword),N(e,i?"BreakStatement":"ContinueStatement");case Ut:return M(),D(),N(e,"DebuggerStatement");case Zt:return M(),Ot.push(Ye),e.body=H(),Ot.pop(),R(ne),e.test=Z(),D(),N(e,"DoWhileStatement");case Gt:if(M(),Ot.push(Ye),R(ge),bt===me)return $(e,null);if(bt===ee){var a=L();return M(),J(a,!0),N(a,"VariableDeclaration"),1===a.declarations.length&&F(ue)?G(e,a):$(e,a)}var a=X(!1,!0);return F(ue)?(V(a),G(e,a)):$(e,a);case Jt:return M(),ht(e,!0);case Xt:return M(),e.test=Z(),e.consequent=H(),e.alternate=F(Wt)?H():null,N(e,"IfStatement");case Kt:return At||ct.allowReturnOutsideFunction||n(mt,"'return' outside of function"),M(),F(me)||j()?e.argument=null:(e.argument=X(),D()),N(e,"ReturnStatement");case Qt:M(),e.discriminant=Z(),e.cases=[],R(de),Ot.push(tn);for(var o,h;bt!=_e;)if(bt===Rt||bt===Ht){var u=bt===Rt;o&&N(o,"SwitchCase"),e.cases.push(o=L()),o.consequent=[],M(),u?o.test=X():(h&&n(Pt,"Multiple default clauses"),h=!0,o.test=null),R(ye)}else o||q(),o.consequent.push(H());return o&&N(o,"SwitchCase"),M(),Ot.pop(),N(e,"SwitchStatement");case Yt:return M(),Je.test(ft.slice(Tt,mt))&&n(Tt,"Illegal newline after throw"),e.argument=X(),D(),N(e,"ThrowStatement");case te:if(M(),e.block=W(),e.handler=null,bt===qt){var l=L();M(),R(ge),l.param=lt(),zt&&Ve(l.param.name)&&n(l.param.start,"Binding "+l.param.name+" in strict mode"),R(ve),l.guard=null,l.body=W(),e.handler=N(l,"CatchClause")}return e.guardedHandlers=Lt,e.finalizer=F($t)?W():null,e.handler||e.finalizer||n(e.start,"Missing catch or finally clause"),N(e,"TryStatement");case ee:return M(),J(e),D(),N(e,"VariableDeclaration");case ne:return M(),e.test=Z(),Ot.push(Ye),e.body=H(),Ot.pop(),N(e,"WhileStatement");case ie:return zt&&n(mt,"'with' in strict mode"),M(),e.object=Z(),e.body=H(),N(e,"WithStatement");case de:return W();case me:return M(),N(e,"EmptyStatement");default:var c=Ct,f=X();if(t===Ft&&"Identifier"===f.type&&F(ye)){for(var r=0;r<Ot.length;++r)Ot[r].name===c&&n(f.start,"Label '"+c+"' is already declared");var d=bt.isLoop?"loop":bt===Qt?"switch":null;return Ot.push({name:c,kind:d}),e.body=H(),Ot.pop(),e.label=f,N(e,"LabeledStatement")}return e.expression=f,D(),N(e,"ExpressionStatement")}}function Z(){R(ge);var t=X();return R(ve),t}function W(t){var e,n=L(),i=!0,r=!1;for(n.body=[],R(de);!F(_e);){var s=H();n.body.push(s),i&&t&&B(s)&&(e=r,A(r=!0)),i=!1}return r&&!e&&A(!1),N(n,"BlockStatement")}function $(t,e){return t.init=e,R(me),t.test=bt===me?null:X(),R(me),t.update=bt===ve?null:X(),R(ve),t.body=H(),Ot.pop(),N(t,"ForStatement")}function G(t,e){return t.left=e,t.right=X(),R(ve),t.body=H(),Ot.pop(),N(t,"ForInStatement")}function J(t,e){for(t.declarations=[],t.kind="var";;){var i=L();if(i.id=lt(),zt&&Ve(i.id.name)&&n(i.id.start,"Binding "+i.id.name+" in strict mode"),i.init=F(Ce)?X(!0,e):null,t.declarations.push(N(i,"VariableDeclarator")),!F(pe))break}return t}function X(t,e){var n=K(e);if(!t&&bt===pe){var i=E(n);for(i.expressions=[n];F(pe);)i.expressions.push(K(e));return N(i,"SequenceExpression")}return n}function K(t){var e=Q(t);if(bt.isAssign){var n=E(e);return n.operator=Ct,n.left=e,M(),n.right=K(t),V(e),N(n,"AssignmentExpression")}return e}function Q(t){var e=Y(t);if(F(xe)){var n=E(e);return n.test=e,n.consequent=X(!0),R(ye),n.alternate=X(!0,t),N(n,"ConditionalExpression")}return e}function Y(t){return tt(et(),-1,t)}function tt(t,e,n){var i=bt.binop;if(null!=i&&(!n||bt!==ue)&&i>e){var r=E(t);r.left=t,r.operator=Ct;var s=bt;M(),r.right=tt(et(),i,n);var a=N(r,s===Pe||s===Te?"LogicalExpression":"BinaryExpression");return tt(a,e,n)}return t}function et(){if(bt.prefix){var t=L(),e=bt.isUpdate;return t.operator=Ct,t.prefix=!0,St=!0,M(),t.argument=et(),e?V(t.argument):zt&&"delete"===t.operator&&"Identifier"===t.argument.type&&n(t.start,"Deleting local variable in strict mode"),N(t,e?"UpdateExpression":"UnaryExpression")}for(var i=nt();bt.postfix&&!j();){var t=E(i);t.operator=Ct,t.prefix=!1,t.argument=i,V(i),M(),i=N(t,"UpdateExpression")}return i}function nt(){return it(rt())}function it(t,e){if(F(we)){var n=E(t);return n.object=t,n.property=lt(!0),n.computed=!1,it(N(n,"MemberExpression"),e)}if(F(ce)){var n=E(t);return n.object=t,n.property=X(),n.computed=!0,R(fe),it(N(n,"MemberExpression"),e)}if(!e&&F(ge)){var n=E(t);return n.callee=t,n.arguments=ut(ve,!1),it(N(n,"CallExpression"),e)}return t}function rt(){switch(bt){case se:var t=L();return M(),N(t,"ThisExpression");case Ft:return lt();case Et:case Bt:case Nt:var t=L();return t.value=Ct,t.raw=ft.slice(mt,yt),M(),N(t,"Literal");case ae:case oe:case he:var t=L();return t.value=bt.atomValue,t.raw=bt.keyword,M(),N(t,"Literal");case ge:var e=wt,n=mt;M();var i=X();return i.start=n,i.end=yt,ct.locations&&(i.loc.start=e,i.loc.end=xt),ct.ranges&&(i.range=[n,yt]),R(ve),i;case ce:var t=L();return M(),t.elements=ut(fe,!0,!0),
N(t,"ArrayExpression");case de:return at();case Jt:var t=L();return M(),ht(t,!1);case re:return st();default:q()}}function st(){var t=L();return M(),t.callee=it(rt(),!0),F(ge)?t.arguments=ut(ve,!1):t.arguments=Lt,N(t,"NewExpression")}function at(){var t=L(),e=!0,i=!1;for(t.properties=[],M();!F(_e);){if(e)e=!1;else if(R(pe),ct.allowTrailingCommas&&F(_e))break;var r,s={key:ot()},a=!1;if(F(ye)?(s.value=X(!0),r=s.kind="init"):ct.ecmaVersion>=5&&"Identifier"===s.key.type&&("get"===s.key.name||"set"===s.key.name)?(a=i=!0,r=s.kind=s.key.name,s.key=ot(),bt!==ge&&q(),s.value=ht(L(),!1)):q(),"Identifier"===s.key.type&&(zt||i))for(var o=0;o<t.properties.length;++o){var h=t.properties[o];if(h.key.name===s.key.name){var u=r==h.kind||a&&"init"===h.kind||"init"===r&&("get"===h.kind||"set"===h.kind);u&&!zt&&"init"===r&&"init"===h.kind&&(u=!1),u&&n(s.key.start,"Redefinition of property")}}t.properties.push(s)}return N(t,"ObjectExpression")}function ot(){return bt===Et||bt===Bt?rt():lt(!0)}function ht(t,e){bt===Ft?t.id=lt():e?q():t.id=null,t.params=[];var i=!0;for(R(ge);!F(ve);)i?i=!1:R(pe),t.params.push(lt());var r=At,s=Ot;if(At=!0,Ot=[],t.body=W(!0),At=r,Ot=s,zt||t.body.body.length&&B(t.body.body[0]))for(var a=t.id?-1:0;a<t.params.length;++a){var o=a<0?t.id:t.params[a];if((qe(o.name)||Ve(o.name))&&n(o.start,"Defining '"+o.name+"' in strict mode"),a>=0)for(var h=0;h<a;++h)o.name===t.params[h].name&&n(o.start,"Argument name clash in strict mode")}return N(t,e?"FunctionDeclaration":"FunctionExpression")}function ut(t,e,n){for(var i=[],r=!0;!F(t);){if(r)r=!1;else if(R(pe),e&&ct.allowTrailingCommas&&F(t))break;n&&bt===pe?i.push(null):i.push(X(!0))}return i}function lt(t){var e=L();return t&&"everywhere"==ct.forbidReserved&&(t=!1),bt===Ft?(!t&&(ct.forbidReserved&&(3===ct.ecmaVersion?De:Re)(Ct)||zt&&qe(Ct))&&ft.slice(mt,yt).indexOf("\\")==-1&&n(mt,"The keyword '"+Ct+"' is reserved"),e.name=Ct):t&&bt.keyword?e.name=bt.keyword:q(),St=!1,M(),N(e,"Identifier")}t.version="0.5.0";var ct,ft,dt,_t;t.parse=function(t,n){return ft=String(t),dt=ft.length,e(n),s(),U(ct.program)};var gt=t.defaultOptions={ecmaVersion:5,strictSemicolons:!1,allowTrailingCommas:!0,forbidReserved:!1,allowReturnOutsideFunction:!1,locations:!1,onComment:null,ranges:!1,program:null,sourceFile:null,directSourceFile:null},vt=t.getLineInfo=function(t,e){for(var n=1,i=0;;){Xe.lastIndex=i;var r=Xe.exec(t);if(!(r&&r.index<e))break;++n,i=r.index+r[0].length}return{line:n,column:e-i}};t.tokenize=function(t,n){function i(t){return Tt=yt,y(t),r.start=mt,r.end=yt,r.startLoc=wt,r.endLoc=xt,r.type=bt,r.value=Ct,r}ft=String(t),dt=ft.length,e(n),s();var r={};return i.jumpTo=function(t,e){if(pt=t,ct.locations){kt=1,It=Xe.lastIndex=0;for(var n;(n=Xe.exec(ft))&&n.index<t;)++kt,It=n.index+n[0].length}St=e,u()},i};var pt,mt,yt,wt,xt,bt,Ct,St,kt,It,Pt,Tt,Mt,At,Ot,zt,Lt=[],Et={type:"num"},Nt={type:"regexp"},Bt={type:"string"},Ft={type:"name"},jt={type:"eof"},Dt={keyword:"break"},Rt={keyword:"case",beforeExpr:!0},qt={keyword:"catch"},Vt={keyword:"continue"},Ut={keyword:"debugger"},Ht={keyword:"default"},Zt={keyword:"do",isLoop:!0},Wt={keyword:"else",beforeExpr:!0},$t={keyword:"finally"},Gt={keyword:"for",isLoop:!0},Jt={keyword:"function"},Xt={keyword:"if"},Kt={keyword:"return",beforeExpr:!0},Qt={keyword:"switch"},Yt={keyword:"throw",beforeExpr:!0},te={keyword:"try"},ee={keyword:"var"},ne={keyword:"while",isLoop:!0},ie={keyword:"with"},re={keyword:"new",beforeExpr:!0},se={keyword:"this"},ae={keyword:"null",atomValue:null},oe={keyword:"true",atomValue:!0},he={keyword:"false",atomValue:!1},ue={keyword:"in",binop:7,beforeExpr:!0},le={"break":Dt,"case":Rt,"catch":qt,"continue":Vt,"debugger":Ut,"default":Ht,"do":Zt,"else":Wt,"finally":$t,"for":Gt,"function":Jt,"if":Xt,"return":Kt,"switch":Qt,"throw":Yt,"try":te,"var":ee,"while":ne,"with":ie,"null":ae,"true":oe,"false":he,"new":re,"in":ue,"instanceof":{keyword:"instanceof",binop:7,beforeExpr:!0},"this":se,"typeof":{keyword:"typeof",prefix:!0,beforeExpr:!0},"void":{keyword:"void",prefix:!0,beforeExpr:!0},"delete":{keyword:"delete",prefix:!0,beforeExpr:!0}},ce={type:"[",beforeExpr:!0},fe={type:"]"},de={type:"{",beforeExpr:!0},_e={type:"}"},ge={type:"(",beforeExpr:!0},ve={type:")"},pe={type:",",beforeExpr:!0},me={type:";",beforeExpr:!0},ye={type:":",beforeExpr:!0},we={type:"."},xe={type:"?",beforeExpr:!0},be={binop:10,beforeExpr:!0},Ce={isAssign:!0,beforeExpr:!0},Se={isAssign:!0,beforeExpr:!0},ke={postfix:!0,prefix:!0,isUpdate:!0},Ie={prefix:!0,beforeExpr:!0},Pe={binop:1,beforeExpr:!0},Te={binop:2,beforeExpr:!0},Me={binop:3,beforeExpr:!0},Ae={binop:4,beforeExpr:!0},Oe={binop:5,beforeExpr:!0},ze={binop:6,beforeExpr:!0},Le={binop:7,beforeExpr:!0},Ee={binop:8,beforeExpr:!0},Ne={binop:9,prefix:!0,beforeExpr:!0},Be={binop:10,beforeExpr:!0};t.tokTypes={bracketL:ce,bracketR:fe,braceL:de,braceR:_e,parenL:ge,parenR:ve,comma:pe,semi:me,colon:ye,dot:we,question:xe,slash:be,eq:Ce,name:Ft,eof:jt,num:Et,regexp:Nt,string:Bt};for(var Fe in le)t.tokTypes["_"+Fe]=le[Fe];var je,De=i("abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile"),Re=i("class enum extends super const export import"),qe=i("implements interface let package private protected public static yield"),Ve=i("eval arguments"),Ue=i("break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this"),He=/[\u1680\u180e\u2000-\u200a\u202f\u205f\u3000\ufeff]/,Ze="\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05d0-\u05ea\u05f0-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u08a0\u08a2-\u08ac\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0977\u0979-\u097f\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3d\u0c58\u0c59\u0c60\u0c61\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d60\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e87\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa\u0eab\u0ead-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f4\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f0\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1877\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191c\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19c1-\u19c7\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1ce9-\u1cec\u1cee-\u1cf1\u1cf5\u1cf6\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u212d\u212f-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2e2f\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309d-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312d\u3131-\u318e\u31a0-\u31ba\u31f0-\u31ff\u3400-\u4db5\u4e00-\u9fcc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua697\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua78e\ua790-\ua793\ua7a0-\ua7aa\ua7f8-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa80-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uabc0-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc",We="\u0300-\u036f\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u0620-\u0649\u0672-\u06d3\u06e7-\u06e8\u06fb-\u06fc\u0730-\u074a\u0800-\u0814\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0840-\u0857\u08e4-\u08fe\u0900-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962-\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09d7\u09df-\u09e0\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2-\u0ae3\u0ae6-\u0aef\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b56\u0b57\u0b5f-\u0b60\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c01-\u0c03\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62-\u0c63\u0c66-\u0c6f\u0c82\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2-\u0ce3\u0ce6-\u0cef\u0d02\u0d03\u0d46-\u0d48\u0d57\u0d62-\u0d63\u0d66-\u0d6f\u0d82\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0df2\u0df3\u0e34-\u0e3a\u0e40-\u0e45\u0e50-\u0e59\u0eb4-\u0eb9\u0ec8-\u0ecd\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f41-\u0f47\u0f71-\u0f84\u0f86-\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u1000-\u1029\u1040-\u1049\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u170e-\u1710\u1720-\u1730\u1740-\u1750\u1772\u1773\u1780-\u17b2\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u1920-\u192b\u1930-\u193b\u1951-\u196d\u19b0-\u19c0\u19c8-\u19c9\u19d0-\u19d9\u1a00-\u1a15\u1a20-\u1a53\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1b46-\u1b4b\u1b50-\u1b59\u1b6b-\u1b73\u1bb0-\u1bb9\u1be6-\u1bf3\u1c00-\u1c22\u1c40-\u1c49\u1c5b-\u1c7d\u1cd0-\u1cd2\u1d00-\u1dbe\u1e01-\u1f15\u200c\u200d\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2d81-\u2d96\u2de0-\u2dff\u3021-\u3028\u3099\u309a\ua640-\ua66d\ua674-\ua67d\ua69f\ua6f0-\ua6f1\ua7f8-\ua800\ua806\ua80b\ua823-\ua827\ua880-\ua881\ua8b4-\ua8c4\ua8d0-\ua8d9\ua8f3-\ua8f7\ua900-\ua909\ua926-\ua92d\ua930-\ua945\ua980-\ua983\ua9b3-\ua9c0\uaa00-\uaa27\uaa40-\uaa41\uaa4c-\uaa4d\uaa50-\uaa59\uaa7b\uaae0-\uaae9\uaaf2-\uaaf3\uabc0-\uabe1\uabec\uabed\uabf0-\uabf9\ufb20-\ufb28\ufe00-\ufe0f\ufe20-\ufe26\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f",$e=new RegExp("["+Ze+"]"),Ge=new RegExp("["+Ze+We+"]"),Je=/[\n\r\u2028\u2029]/,Xe=/\r\n|[\n\r\u2028\u2029]/g,Ke=t.isIdentifierStart=function(t){return t<65?36===t:t<91||(t<97?95===t:t<123||t>=170&&$e.test(String.fromCharCode(t)))},Qe=t.isIdentifierChar=function(t){return t<48?36===t:t<58||!(t<65)&&(t<91||(t<97?95===t:t<123||t>=170&&Ge.test(String.fromCharCode(t))))},Ye={kind:"loop"},tn={kind:"switch"}}),v.version||(v=null)}var w={"+":"__add","-":"__subtract","*":"__multiply","/":"__divide","%":"__modulo","==":"__equals","!=":"__equals"},x={"-":"__negate","+":"__self"},b=r.each(["add","subtract","multiply","divide","modulo","equals","negate"],function(t){this["__"+t]="#"+t},{__self:function(){return this}});return c.inject(b),d.inject(b),D.inject(b),n&&("complete"===i.readyState?setTimeout(f):H.add(n,{load:f})),{compile:h,execute:u,load:_,parse:e,calculateBinary:s,calculateUnary:o}}.call(this);var st=new(a.inject(r.exports,{Base:r,Numerical:u,Key:J,DomEvent:H,DomElement:U,document:i,window:n,Symbol:I,PlacedSymbol:k}));return st.agent.node&&require("./node/extend.js")(st),"function"==typeof define&&define.amd?define("paper",st):"object"==typeof module&&module&&(module.exports=st),st}.call(this,"object"==typeof self?self:null);