/*!
 * Paper.js v0.9.25 - The Swiss Army Knife of Vector Graphics Scripting.
 * http://paperjs.org/
 *
 * Copyright (c) 2011 - 2014, Juerg Lehni & Jonathan Puckey
 * http://scratchdisk.com/ & http://jonathanpuckey.com/
 *
 * Distributed under the MIT license. See LICENSE file for details.
 *
 * All rights reserved.
 *
 * Date: Sun Oct 25 11:23:38 2015 +0100
 *
 ***
 *
 * Straps.js - Class inheritance library with support for bean-style accessors
 *
 * Copyright (c) 2006 - 2013 Juerg Lehni
 * http://scratchdisk.com/
 *
 * Distributed under the MIT license.
 *
 ***
 *
 * Acorn.js
 * http://marijnhaverbeke.nl/acorn/
 *
 * Acorn is a tiny, fast JavaScript parser written in JavaScript,
 * created by Marijn Haverbeke and released under an MIT license.
 *
 */
var paper=new function(t){var e=new function(){function n(t,n,i,r,a){function o(s,o){o=o||(o=u(n,s))&&(o.get?o:o.value),"string"==typeof o&&"#"===o[0]&&(o=t[o.substring(1)]||o);var l,d="function"==typeof o,f=o,g=a||d&&!o.base?o&&o.get?s in t:t[s]:null;a&&g||(d&&g&&(o.base=g),d&&r!==!1&&(l=s.match(/^([gs]et|is)(([A-Z])(.*))$/))&&(h[l[3].toLowerCase()+l[4]]=l[2]),f&&!d&&f.get&&"function"==typeof f.get&&e.isPlainObject(f)||(f={value:f,writable:!0}),(u(t,s)||{configurable:!0}).configurable&&(f.configurable=!0,f.enumerable=i),c(t,s,f))}var h={};if(n){for(var l in n)n.hasOwnProperty(l)&&!s.test(l)&&o(l);for(var l in h){var d=h[l],f=t["set"+d],g=t["get"+d]||f&&t["is"+d];!g||r!==!0&&0!==g.length||o(l,{get:g,set:f})}}return t}function i(t,e,n){return t&&("length"in t&&!t.getLength&&"number"==typeof t.length?a:o).call(t,e,n=n||t),n}function r(t,e,n){for(var i in e)!e.hasOwnProperty(i)||n&&n[i]||(t[i]=e[i]);return t}var s=/^(statics|enumerable|beans|preserve)$/,a=[].forEach||function(t,e){for(var n=0,i=this.length;i>n;n++)t.call(e,this[n],n,this)},o=function(t,e){for(var n in this)this.hasOwnProperty(n)&&t.call(e,this[n],n,this)},h=Object.create||function(t){return{__proto__:t}},u=Object.getOwnPropertyDescriptor||function(t,e){var n=t.__lookupGetter__&&t.__lookupGetter__(e);return n?{get:n,set:t.__lookupSetter__(e),enumerable:!0,configurable:!0}:t.hasOwnProperty(e)?{value:t[e],enumerable:!0,configurable:!0,writable:!0}:null},l=Object.defineProperty||function(t,e,n){return(n.get||n.set)&&t.__defineGetter__?(n.get&&t.__defineGetter__(e,n.get),n.set&&t.__defineSetter__(e,n.set)):t[e]=n.value,t},c=function(t,e,n){return delete t[e],l(t,e,n)};return n(function(){for(var t=0,e=arguments.length;e>t;t++)r(this,arguments[t])},{inject:function(t){if(t){var e=t.statics===!0?t:t.statics,i=t.beans,r=t.preserve;e!==t&&n(this.prototype,t,t.enumerable,i,r),n(this,e,!0,i,r)}for(var s=1,a=arguments.length;a>s;s++)this.inject(arguments[s]);return this},extend:function(){for(var t,e,i=this,r=0,s=arguments.length;s>r&&!(t=arguments[r].initialize);r++);return t=t||function(){i.apply(this,arguments)},e=t.prototype=h(this.prototype),c(e,"constructor",{value:t,writable:!0,configurable:!0}),n(t,this,!0),arguments.length&&this.inject.apply(t,arguments),t.base=i,t}},!0).inject({inject:function(){for(var t=0,e=arguments.length;e>t;t++){var i=arguments[t];i&&n(this,i,i.enumerable,i.beans,i.preserve)}return this},extend:function(){var t=h(this);return t.inject.apply(t,arguments)},each:function(t,e){return i(this,t,e)},set:function(t){return r(this,t)},clone:function(){return new this.constructor(this)},statics:{each:i,create:h,define:c,describe:u,set:r,clone:function(t){return r(new t.constructor,t)},isPlainObject:function(t){var n=null!=t&&t.constructor;return n&&(n===Object||n===e||"Object"===n.name)},pick:function(e,n){return e!==t?e:n}}})};"undefined"!=typeof module&&(module.exports=e),e.inject({toString:function(){return null!=this._id?(this._class||"Object")+(this._name?" '"+this._name+"'":" @"+this._id):"{ "+e.each(this,function(t,e){if(!/^_/.test(e)){var n=typeof t;this.push(e+": "+("number"===n?s.instance.number(t):"string"===n?"'"+t+"'":t))}},[]).join(", ")+" }"},getClassName:function(){return this._class||""},exportJSON:function(t){return e.exportJSON(this,t)},toJSON:function(){return e.serialize(this)},_set:function(n,i,r){if(n&&(r||e.isPlainObject(n))){for(var s=Object.keys(n._filtering||n),a=0,o=s.length;o>a;a++){var h=s[a];if(!i||!i[h]){var u=n[h];u!==t&&(this[h]=u)}}return!0}},statics:{exports:{enumerable:!0},extend:function et(){var t=et.base.apply(this,arguments),n=t.prototype._class;return n&&!e.exports[n]&&(e.exports[n]=t),t},equals:function(t,n){if(t===n)return!0;if(t&&t.equals)return t.equals(n);if(n&&n.equals)return n.equals(t);if(t&&n&&"object"==typeof t&&"object"==typeof n){if(Array.isArray(t)&&Array.isArray(n)){var i=t.length;if(i!==n.length)return!1;for(;i--;)if(!e.equals(t[i],n[i]))return!1}else{var r=Object.keys(t),i=r.length;if(i!==Object.keys(n).length)return!1;for(;i--;){var s=r[i];if(!n.hasOwnProperty(s)||!e.equals(t[s],n[s]))return!1}}return!0}return!1},read:function(n,i,r,s){if(this===e){var a=this.peek(n,i);return n.__index++,a}var o=this.prototype,h=o._readIndex,u=i||h&&n.__index||0;s||(s=n.length-u);var l=n[u];return l instanceof this||r&&r.readNull&&null==l&&1>=s?(h&&(n.__index=u+1),l&&r&&r.clone?l.clone():l):(l=e.create(this.prototype),h&&(l.__read=!0),l=l.initialize.apply(l,u>0||s<n.length?Array.prototype.slice.call(n,u,u+s):n)||l,h&&(n.__index=u+l.__read,l.__read=t),l)},peek:function(t,e){return t[t.__index=e||t.__index||0]},remain:function(t){return t.length-(t.__index||0)},readAll:function(t,e,n){for(var i,r=[],s=e||0,a=t.length;a>s;s++)r.push(Array.isArray(i=t[s])?this.read(i,0,n):this.read(t,s,n,1));return r},readNamed:function(n,i,r,s,a){var o=this.getNamed(n,i),h=o!==t;if(h){var u=n._filtered;u||(u=n._filtered=e.create(n[0]),u._filtering=n[0]),u[i]=t}return this.read(h?[o]:n,r,s,a)},getNamed:function(n,i){var r=n[0];return n._hasObject===t&&(n._hasObject=1===n.length&&e.isPlainObject(r)),n._hasObject?i?r[i]:n._filtered||r:t},hasNamed:function(t,e){return!!this.getNamed(t,e)},isPlainValue:function(t,e){return this.isPlainObject(t)||Array.isArray(t)||e&&"string"==typeof t},serialize:function(t,n,i,r){n=n||{};var a,o=!r;if(o&&(n.formatter=new s(n.precision),r={length:0,definitions:{},references:{},add:function(t,e){var n="#"+t._id,i=this.references[n];if(!i){this.length++;var r=e.call(t),s=t._class;s&&r[0]!==s&&r.unshift(s),this.definitions[n]=r,i=this.references[n]=[n]}return i}}),t&&t._serialize){a=t._serialize(n,r);var h=t._class;!h||i||a._compact||a[0]===h||a.unshift(h)}else if(Array.isArray(t)){a=[];for(var u=0,l=t.length;l>u;u++)a[u]=e.serialize(t[u],n,i,r);i&&(a._compact=!0)}else if(e.isPlainObject(t)){a={};for(var c=Object.keys(t),u=0,l=c.length;l>u;u++){var d=c[u];a[d]=e.serialize(t[d],n,i,r)}}else a="number"==typeof t?n.formatter.number(t,n.precision):t;return o&&r.length>0?[["dictionary",r.definitions],a]:a},deserialize:function(t,n,i,r){var s=t,a=!i;if(i=i||{},Array.isArray(t)){var o=t[0],h="dictionary"===o;if(1==t.length&&/^#/.test(o))return i.dictionary[o];o=e.exports[o],s=[],r&&(i.dictionary=s);for(var u=o?1:0,l=t.length;l>u;u++)s.push(e.deserialize(t[u],n,i,h));if(o){var c=s;n?s=n(o,c):(s=e.create(o.prototype),o.apply(s,c))}}else if(e.isPlainObject(t)){s={},r&&(i.dictionary=s);for(var d in t)s[d]=e.deserialize(t[d],n,i)}return a&&t&&t.length&&"dictionary"===t[0][0]?s[1]:s},exportJSON:function(t,n){var i=e.serialize(t,n);return n&&n.asString===!1?i:JSON.stringify(i)},importJSON:function(t,n){return e.deserialize("string"==typeof t?JSON.parse(t):t,function(t,i){var r=n&&n.constructor===t?n:e.create(t.prototype),s=r===n;if(1===i.length&&r instanceof m&&(s||!(r instanceof w))){var a=i[0];e.isPlainObject(a)&&(a.insert=!1)}return t.apply(r,i),s&&(n=null),r})},splice:function(e,n,i,r){var s=n&&n.length,a=i===t;i=a?e.length:i,i>e.length&&(i=e.length);for(var o=0;s>o;o++)n[o]._index=i+o;if(a)return e.push.apply(e,n),[];var h=[i,r];n&&h.push.apply(h,n);for(var u=e.splice.apply(e,h),o=0,l=u.length;l>o;o++)u[o]._index=t;for(var o=i+s,l=e.length;l>o;o++)e[o]._index=o;return u},capitalize:function(t){return t.replace(/\b[a-z]/g,function(t){return t.toUpperCase()})},camelize:function(t){return t.replace(/-(.)/g,function(t,e){return e.toUpperCase()})},hyphenate:function(t){return t.replace(/([a-z])([A-Z])/g,"$1-$2").toLowerCase()}}});var n={on:function(t,n){if("string"!=typeof t)e.each(t,function(t,e){this.on(e,t)},this);else{var i=this._eventTypes,r=i&&i[t],s=this._callbacks=this._callbacks||{};s=s[t]=s[t]||[],-1===s.indexOf(n)&&(s.push(n),r&&r.install&&1===s.length&&r.install.call(this,t))}return this},off:function(n,i){if("string"!=typeof n)return e.each(n,function(t,e){this.off(e,t)},this),t;var r,s=this._eventTypes,a=s&&s[n],o=this._callbacks&&this._callbacks[n];return o&&(!i||-1!==(r=o.indexOf(i))&&1===o.length?(a&&a.uninstall&&a.uninstall.call(this,n),delete this._callbacks[n]):-1!==r&&o.splice(r,1)),this},once:function(t,e){return this.on(t,function(){e.apply(this,arguments),this.off(t,e)})},emit:function(t,e){var n=this._callbacks&&this._callbacks[t];if(!n)return!1;var i=[].slice.call(arguments,1);n=n.slice();for(var r=0,s=n.length;s>r;r++)if(n[r].apply(this,i)===!1){e&&e.stop&&e.stop();break}return!0},responds:function(t){return!(!this._callbacks||!this._callbacks[t])},attach:"#on",detach:"#off",fire:"#emit",_installEvents:function(t){var e=this._callbacks,n=t?"install":"uninstall";for(var i in e)if(e[i].length>0){var r=this._eventTypes,s=r&&r[i],a=s&&s[n];a&&a.call(this,i)}},statics:{inject:function nt(t){var n=t._events;if(n){var i={};e.each(n,function(n,r){var s="string"==typeof n,a=s?n:r,o=e.capitalize(a),h=a.substring(2).toLowerCase();i[h]=s?{}:n,a="_"+a,t["get"+o]=function(){return this[a]},t["set"+o]=function(t){var e=this[a];e&&this.off(h,e),t&&this.on(h,t),this[a]=t}}),t._eventTypes=i}return nt.base.apply(this,arguments)}}},i=e.extend({_class:"PaperScope",initialize:function it(){paper=this,this.settings=new e({applyMatrix:!0,handleSize:4,hitTolerance:0}),this.project=null,this.projects=[],this.tools=[],this.palettes=[],this._id=it._id++,it._scopes[this._id]=this;var t=it.prototype;if(!this.support){var n=Y.getContext(1,1);t.support={nativeDash:"setLineDash"in n||"mozDash"in n,nativeBlendModes:K.nativeModes},Y.release(n)}if(!this.browser){var i=navigator.userAgent.toLowerCase(),r=(/(win)/.exec(i)||/(mac)/.exec(i)||/(linux)/.exec(i)||[])[0],s=t.browser={platform:r};r&&(s[r]=!0),i.replace(/(opera|chrome|safari|webkit|firefox|msie|trident|atom)\/?\s*([.\d]+)(?:.*version\/([.\d]+))?(?:.*rv\:([.\d]+))?/g,function(t,e,n,i,r){if(!s.chrome){var a="opera"===e?i:n;"trident"===e&&(a=r,e="msie"),s.version=a,s.versionNumber=parseFloat(a),s.name=e,s[e]=!0}}),s.chrome&&delete s.webkit,s.atom&&delete s.chrome}},version:"0.9.25",getView:function(){return this.project&&this.project.getView()},getPaper:function(){return this},execute:function(t,e,n){paper.PaperScript.execute(t,this,e,n),V.updateFocus()},install:function(t){var n=this;e.each(["project","view","tool"],function(i){e.define(t,i,{configurable:!0,get:function(){return n[i]}})});for(var i in this)!/^_/.test(i)&&this[i]&&(t[i]=this[i])},setup:function(t){return paper=this,this.project=new v(t),this},activate:function(){paper=this},clear:function(){for(var t=this.projects.length-1;t>=0;t--)this.projects[t].remove();for(var t=this.tools.length-1;t>=0;t--)this.tools[t].remove();for(var t=this.palettes.length-1;t>=0;t--)this.palettes[t].remove()},remove:function(){this.clear(),delete i._scopes[this._id]},statics:new function(){function t(t){return t+="Attribute",function(e,n){return e[t](n)||e[t]("data-paper-"+n)}}return{_scopes:{},_id:0,get:function(t){return this._scopes[t]||null},getAttribute:t("get"),hasAttribute:t("has")}}}),r=e.extend(n,{initialize:function(t){this._scope=paper,this._index=this._scope[this._list].push(this)-1,(t||!this._scope[this._reference])&&this.activate()},activate:function(){if(!this._scope)return!1;var t=this._scope[this._reference];return t&&t!==this&&t.emit("deactivate"),this._scope[this._reference]=this,this.emit("activate",t),!0},isActive:function(){return this._scope[this._reference]===this},remove:function(){return null==this._index?!1:(e.splice(this._scope[this._list],null,this._index,1),this._scope[this._reference]==this&&(this._scope[this._reference]=null),this._scope=null,!0)}}),s=e.extend({initialize:function(t){this.precision=t||5,this.multiplier=Math.pow(10,this.precision)},number:function(t){return Math.round(t*this.multiplier)/this.multiplier},pair:function(t,e,n){return this.number(t)+(n||",")+this.number(e)},point:function(t,e){return this.number(t.x)+(e||",")+this.number(t.y)},size:function(t,e){return this.number(t.width)+(e||",")+this.number(t.height)},rectangle:function(t,e){return this.point(t,e)+(e||",")+this.size(t,e)}});s.instance=new s;var a=new function(){function t(t,e,n){return e>t?e:t>n?n:t}var e=[[.5773502691896257],[0,.7745966692414834],[.33998104358485626,.8611363115940526],[0,.5384693101056831,.906179845938664],[.2386191860831969,.6612093864662645,.932469514203152],[0,.4058451513773972,.7415311855993945,.9491079123427585],[.1834346424956498,.525532409916329,.7966664774136267,.9602898564975363],[0,.3242534234038089,.6133714327005904,.8360311073266358,.9681602395076261],[.14887433898163122,.4333953941292472,.6794095682990244,.8650633666889845,.9739065285171717],[0,.26954315595234496,.5190961292068118,.7301520055740494,.8870625997680953,.978228658146057],[.1252334085114689,.3678314989981802,.5873179542866175,.7699026741943047,.9041172563704749,.9815606342467192],[0,.2304583159551348,.44849275103644687,.6423493394403402,.8015780907333099,.9175983992229779,.9841830547185881],[.10805494870734367,.31911236892788974,.5152486363581541,.6872929048116855,.827201315069765,.9284348836635735,.9862838086968123],[0,.20119409399743451,.3941513470775634,.5709721726085388,.7244177313601701,.8482065834104272,.937273392400706,.9879925180204854],[.09501250983763744,.2816035507792589,.45801677765722737,.6178762444026438,.755404408355003,.8656312023878318,.9445750230732326,.9894009349916499]],n=[[1],[.8888888888888888,.5555555555555556],[.6521451548625461,.34785484513745385],[.5688888888888889,.47862867049936647,.23692688505618908],[.46791393457269104,.3607615730481386,.17132449237917036],[.4179591836734694,.3818300505051189,.27970539148927664,.1294849661688697],[.362683783378362,.31370664587788727,.22238103445337448,.10122853629037626],[.3302393550012598,.31234707704000286,.26061069640293544,.1806481606948574,.08127438836157441],[.29552422471475287,.26926671930999635,.21908636251598204,.1494513491505806,.06667134430868814],[.2729250867779006,.26280454451024665,.23319376459199048,.18629021092773426,.1255803694649046,.05566856711617366],[.24914704581340277,.2334925365383548,.20316742672306592,.16007832854334622,.10693932599531843,.04717533638651183],[.2325515532308739,.22628318026289723,.2078160475368885,.17814598076194574,.13887351021978725,.09212149983772845,.04048400476531588],[.2152638534631578,.2051984637212956,.18553839747793782,.15720316715819355,.12151857068790319,.08015808715976021,.03511946033175186],[.2025782419255613,.19843148532711158,.1861610000155622,.16626920581699392,.13957067792615432,.10715922046717194,.07036604748810812,.03075324199611727],[.1894506104550685,.18260341504492358,.16915651939500254,.14959598881657674,.12462897125553388,.09515851168249279,.062253523938647894,.027152459411754096]],i=Math.abs,r=Math.sqrt,s=Math.pow,o=1e-12,h=1.12e-16;return{TOLERANCE:1e-6,EPSILON:o,MACHINE_EPSILON:h,CURVETIME_EPSILON:4e-7,GEOMETRIC_EPSILON:2e-7,WINDING_EPSILON:2e-7,TRIGONOMETRIC_EPSILON:1e-7,CLIPPING_EPSILON:1e-7,KAPPA:4*(r(2)-1)/3,isZero:function(t){return t>=-o&&o>=t},integrate:function(t,i,r,s){for(var a=e[s-2],o=n[s-2],h=.5*(r-i),u=h+i,l=0,c=s+1>>1,d=1&s?o[l++]*t(u):0;c>l;){var f=h*a[l];d+=o[l++]*(t(u+f)+t(u-f))}return h*d},findRoot:function(t,e,n,r,s,a,o){for(var h=0;a>h;h++){var u=t(n),l=u/e(n),c=n-l;if(i(l)<o)return c;u>0?(s=n,n=r>=c?.5*(r+s):c):(r=n,n=c>=s?.5*(r+s):c)}return n},solveQuadratic:function(e,n,a,u,l,c){var d,f,g=0,_=l-o,v=c+o,p=1/0,m=n;if(n/=-2,f=n*n-e*a,0!==f&&i(f)<h){var y=s(i(e*n*a),1/3);if(1e-8>y){var w=s(10,i(Math.floor(Math.log(y)*Math.LOG10E)));isFinite(w)||(w=0),e*=w,n*=w,a*=w,f=n*n-e*a}}if(i(e)<o){if(i(m)<o)return i(a)<o?-1:0;d=-a/m}else if(f>=-h){var x=0>f?0:r(f),b=n+(0>n?-x:x);0===b?(d=a/e,p=-d):(d=b/e,p=a/b)}return isFinite(d)&&(null==l||d>_&&v>d)&&(u[g++]=null==l?d:t(d,l,c)),p!==d&&isFinite(p)&&(null==l||p>_&&v>p)&&(u[g++]=null==l?p:t(p,l,c)),g},solveCubic:function(e,n,u,l,c,d,f){var g,_,v,p=0;if(i(e)<o)e=n,_=u,v=l,g=1/0;else if(i(l)<o)_=n,v=u,g=0;else{var m,y,w,x,b,C,S,P=1+h;if(g=-(n/e)/3,S=e*g,_=S+n,v=_*g+u,w=(S+_)*g+v,y=v*g+l,x=y/e,b=s(i(x),1/3),C=0>x?-1:1,x=-w/e,b=x>0?1.3247179572*Math.max(b,r(x)):b,m=g-C*b,m!==g){do if(g=m,S=e*g,_=S+n,v=_*g+u,w=(S+_)*g+v,y=v*g+l,m=0===w?g:g-y/w/P,m===g){g=m;break}while(C*m>C*g);i(e)*g*g>i(l/g)&&(v=-l/g,_=(v-u)/g)}}var p=a.solveQuadratic(e,_,v,c,d,f);return isFinite(g)&&(0===p||g!==c[p-1])&&(null==d||g>d-o&&f+o>g)&&(c[p++]=null==d?g:t(g,d,f)),p}}},o={_id:1,_pools:{},get:function(t){if(t){var e=t._class,n=this._pools[e];return n||(n=this._pools[e]={_id:1}),n._id++}return this._id++}},h=e.extend({_class:"Point",_readIndex:!0,initialize:function(t,e){var n=typeof t;if("number"===n){var i="number"==typeof e;this.x=t,this.y=i?e:t,this.__read&&(this.__read=i?2:1)}else"undefined"===n||null===t?(this.x=this.y=0,this.__read&&(this.__read=null===t?1:0)):(Array.isArray(t)?(this.x=t[0],this.y=t.length>1?t[1]:t[0]):null!=t.x?(this.x=t.x,this.y=t.y):null!=t.width?(this.x=t.width,this.y=t.height):null!=t.angle?(this.x=t.length,this.y=0,this.setAngle(t.angle)):(this.x=this.y=0,this.__read&&(this.__read=0)),this.__read&&(this.__read=1))},set:function(t,e){return this.x=t,this.y=e,this},equals:function(t){return this===t||t&&(this.x===t.x&&this.y===t.y||Array.isArray(t)&&this.x===t[0]&&this.y===t[1])||!1},clone:function(){return new h(this.x,this.y)},toString:function(){var t=s.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.x),e.number(this.y)]},getLength:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},setLength:function(t){if(this.isZero()){var e=this._angle||0;this.set(Math.cos(e)*t,Math.sin(e)*t)}else{var n=t/this.getLength();a.isZero(n)&&this.getAngle(),this.set(this.x*n,this.y*n)}},getAngle:function(){return 180*this.getAngleInRadians.apply(this,arguments)/Math.PI},setAngle:function(t){this.setAngleInRadians.call(this,t*Math.PI/180)},getAngleInDegrees:"#getAngle",setAngleInDegrees:"#setAngle",getAngleInRadians:function(){if(arguments.length){var t=h.read(arguments),e=this.getLength()*t.getLength();if(a.isZero(e))return NaN;var n=this.dot(t)/e;return Math.acos(-1>n?-1:n>1?1:n)}return this.isZero()?this._angle||0:this._angle=Math.atan2(this.y,this.x)},setAngleInRadians:function(t){if(this._angle=t,!this.isZero()){var e=this.getLength();this.set(Math.cos(t)*e,Math.sin(t)*e)}},getQuadrant:function(){return this.x>=0?this.y>=0?1:4:this.y>=0?2:3}},{beans:!1,getDirectedAngle:function(){var t=h.read(arguments);return 180*Math.atan2(this.cross(t),this.dot(t))/Math.PI},getDistance:function(){var t=h.read(arguments),n=t.x-this.x,i=t.y-this.y,r=n*n+i*i,s=e.read(arguments);return s?r:Math.sqrt(r)},normalize:function(e){e===t&&(e=1);var n=this.getLength(),i=0!==n?e/n:0,r=new h(this.x*i,this.y*i);return i>=0&&(r._angle=this._angle),r},rotate:function(t,e){if(0===t)return this.clone();t=t*Math.PI/180;var n=e?this.subtract(e):this,i=Math.sin(t),r=Math.cos(t);return n=new h(n.x*r-n.y*i,n.x*i+n.y*r),e?n.add(e):n},transform:function(t){return t?t._transformPoint(this):this},add:function(){var t=h.read(arguments);return new h(this.x+t.x,this.y+t.y)},subtract:function(){var t=h.read(arguments);return new h(this.x-t.x,this.y-t.y)},multiply:function(){var t=h.read(arguments);return new h(this.x*t.x,this.y*t.y)},divide:function(){var t=h.read(arguments);return new h(this.x/t.x,this.y/t.y)},modulo:function(){var t=h.read(arguments);return new h(this.x%t.x,this.y%t.y)},negate:function(){return new h(-this.x,-this.y)},isInside:function(){return d.read(arguments).contains(this)},isClose:function(){var t=h.read(arguments),n=e.read(arguments);return this.getDistance(t)<n},isCollinear:function(){var t=h.read(arguments);return h.isCollinear(this.x,this.y,t.x,t.y)},isColinear:"#isCollinear",isOrthogonal:function(){var t=h.read(arguments);return h.isOrthogonal(this.x,this.y,t.x,t.y)},isZero:function(){return a.isZero(this.x)&&a.isZero(this.y)},isNaN:function(){return isNaN(this.x)||isNaN(this.y)},dot:function(){var t=h.read(arguments);return this.x*t.x+this.y*t.y},cross:function(){var t=h.read(arguments);return this.x*t.y-this.y*t.x},project:function(){var t=h.read(arguments),e=t.isZero()?0:this.dot(t)/t.dot(t);return new h(t.x*e,t.y*e)},statics:{min:function(){var t=h.read(arguments),e=h.read(arguments);return new h(Math.min(t.x,e.x),Math.min(t.y,e.y))},max:function(){var t=h.read(arguments),e=h.read(arguments);return new h(Math.max(t.x,e.x),Math.max(t.y,e.y))},random:function(){return new h(Math.random(),Math.random())},isCollinear:function(t,e,n,i){return Math.abs(t*i-e*n)<=1e-7*Math.sqrt((t*t+e*e)*(n*n+i*i))},isOrthogonal:function(t,e,n,i){return Math.abs(t*n+e*i)<=1e-7*Math.sqrt((t*t+e*e)*(n*n+i*i))}}},e.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new h(e(this.x),e(this.y))}},{})),u=h.extend({initialize:function(t,e,n,i){this._x=t,this._y=e,this._owner=n,this._setter=i},set:function(t,e,n){return this._x=t,this._y=e,n||this._owner[this._setter](this),this},getX:function(){return this._x},setX:function(t){this._x=t,this._owner[this._setter](this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner[this._setter](this)}}),l=e.extend({_class:"Size",_readIndex:!0,initialize:function(t,e){var n=typeof t;if("number"===n){var i="number"==typeof e;this.width=t,this.height=i?e:t,this.__read&&(this.__read=i?2:1)}else"undefined"===n||null===t?(this.width=this.height=0,this.__read&&(this.__read=null===t?1:0)):(Array.isArray(t)?(this.width=t[0],this.height=t.length>1?t[1]:t[0]):null!=t.width?(this.width=t.width,this.height=t.height):null!=t.x?(this.width=t.x,this.height=t.y):(this.width=this.height=0,this.__read&&(this.__read=0)),this.__read&&(this.__read=1))},set:function(t,e){return this.width=t,this.height=e,this},equals:function(t){return t===this||t&&(this.width===t.width&&this.height===t.height||Array.isArray(t)&&this.width===t[0]&&this.height===t[1])||!1},clone:function(){return new l(this.width,this.height)},toString:function(){var t=s.instance;return"{ width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.width),e.number(this.height)]},add:function(){var t=l.read(arguments);return new l(this.width+t.width,this.height+t.height)},subtract:function(){var t=l.read(arguments);return new l(this.width-t.width,this.height-t.height)},multiply:function(){var t=l.read(arguments);return new l(this.width*t.width,this.height*t.height)},divide:function(){var t=l.read(arguments);return new l(this.width/t.width,this.height/t.height)},modulo:function(){var t=l.read(arguments);return new l(this.width%t.width,this.height%t.height)},negate:function(){return new l(-this.width,-this.height)},isZero:function(){return a.isZero(this.width)&&a.isZero(this.height)},isNaN:function(){return isNaN(this.width)||isNaN(this.height)},statics:{min:function(t,e){return new l(Math.min(t.width,e.width),Math.min(t.height,e.height))},max:function(t,e){return new l(Math.max(t.width,e.width),Math.max(t.height,e.height))},random:function(){return new l(Math.random(),Math.random())}}},e.each(["round","ceil","floor","abs"],function(t){var e=Math[t];this[t]=function(){return new l(e(this.width),e(this.height))}},{})),c=l.extend({initialize:function(t,e,n,i){this._width=t,this._height=e,this._owner=n,this._setter=i},set:function(t,e,n){return this._width=t,this._height=e,n||this._owner[this._setter](this),this},getWidth:function(){return this._width},setWidth:function(t){this._width=t,this._owner[this._setter](this)},getHeight:function(){return this._height},setHeight:function(t){this._height=t,this._owner[this._setter](this)}}),d=e.extend({_class:"Rectangle",_readIndex:!0,beans:!0,initialize:function(n,i,r,s){var a=typeof n,o=0;if("number"===a?(this.x=n,this.y=i,this.width=r,this.height=s,o=4):"undefined"===a||null===n?(this.x=this.y=this.width=this.height=0,o=null===n?1:0):1===arguments.length&&(Array.isArray(n)?(this.x=n[0],this.y=n[1],this.width=n[2],this.height=n[3],o=1):n.x!==t||n.width!==t?(this.x=n.x||0,this.y=n.y||0,this.width=n.width||0,this.height=n.height||0,o=1):n.from===t&&n.to===t&&(this.x=this.y=this.width=this.height=0,this._set(n),o=1)),!o){var u=h.readNamed(arguments,"from"),c=e.peek(arguments);if(this.x=u.x,this.y=u.y,c&&c.x!==t||e.hasNamed(arguments,"to")){var d=h.readNamed(arguments,"to");this.width=d.x-u.x,this.height=d.y-u.y,this.width<0&&(this.x=d.x,this.width=-this.width),this.height<0&&(this.y=d.y,this.height=-this.height)}else{var f=l.read(arguments);this.width=f.width,this.height=f.height}o=arguments.__index}this.__read&&(this.__read=o)},set:function(t,e,n,i){return this.x=t,this.y=e,this.width=n,this.height=i,this},clone:function(){return new d(this.x,this.y,this.width,this.height)},equals:function(t){var n=e.isPlainValue(t)?d.read(arguments):t;return n===this||n&&this.x===n.x&&this.y===n.y&&this.width===n.width&&this.height===n.height||!1},toString:function(){var t=s.instance;return"{ x: "+t.number(this.x)+", y: "+t.number(this.y)+", width: "+t.number(this.width)+", height: "+t.number(this.height)+" }"},_serialize:function(t){var e=t.formatter;return[e.number(this.x),e.number(this.y),e.number(this.width),e.number(this.height)]},getPoint:function(t){var e=t?h:u;return new e(this.x,this.y,this,"setPoint")},setPoint:function(){var t=h.read(arguments);this.x=t.x,this.y=t.y},getSize:function(t){var e=t?l:c;return new e(this.width,this.height,this,"setSize")},setSize:function(){var t=l.read(arguments);this._fixX&&(this.x+=(this.width-t.width)*this._fixX),this._fixY&&(this.y+=(this.height-t.height)*this._fixY),this.width=t.width,this.height=t.height,this._fixW=1,this._fixH=1},getLeft:function(){return this.x},setLeft:function(t){this._fixW||(this.width-=t-this.x),this.x=t,this._fixX=0},getTop:function(){return this.y},setTop:function(t){this._fixH||(this.height-=t-this.y),this.y=t,this._fixY=0},getRight:function(){return this.x+this.width},setRight:function(e){this._fixX!==t&&1!==this._fixX&&(this._fixW=0),this._fixW?this.x=e-this.width:this.width=e-this.x,this._fixX=1},getBottom:function(){return this.y+this.height},setBottom:function(e){this._fixY!==t&&1!==this._fixY&&(this._fixH=0),this._fixH?this.y=e-this.height:this.height=e-this.y,this._fixY=1},getCenterX:function(){return this.x+.5*this.width},setCenterX:function(t){this.x=t-.5*this.width,this._fixX=.5},getCenterY:function(){return this.y+.5*this.height},setCenterY:function(t){this.y=t-.5*this.height,this._fixY=.5},getCenter:function(t){var e=t?h:u;return new e(this.getCenterX(),this.getCenterY(),this,"setCenter")},setCenter:function(){var t=h.read(arguments);return this.setCenterX(t.x),this.setCenterY(t.y),this},getArea:function(){return this.width*this.height},isEmpty:function(){return 0===this.width||0===this.height},contains:function(e){return e&&e.width!==t||4==(Array.isArray(e)?e:arguments).length?this._containsRectangle(d.read(arguments)):this._containsPoint(h.read(arguments))},_containsPoint:function(t){var e=t.x,n=t.y;return e>=this.x&&n>=this.y&&e<=this.x+this.width&&n<=this.y+this.height},_containsRectangle:function(t){var e=t.x,n=t.y;return e>=this.x&&n>=this.y&&e+t.width<=this.x+this.width&&n+t.height<=this.y+this.height},intersects:function(){var t=d.read(arguments);return t.x+t.width>this.x&&t.y+t.height>this.y&&t.x<this.x+this.width&&t.y<this.y+this.height},touches:function(){var t=d.read(arguments);return t.x+t.width>=this.x&&t.y+t.height>=this.y&&t.x<=this.x+this.width&&t.y<=this.y+this.height},intersect:function(){var t=d.read(arguments),e=Math.max(this.x,t.x),n=Math.max(this.y,t.y),i=Math.min(this.x+this.width,t.x+t.width),r=Math.min(this.y+this.height,t.y+t.height);return new d(e,n,i-e,r-n)},unite:function(){var t=d.read(arguments),e=Math.min(this.x,t.x),n=Math.min(this.y,t.y),i=Math.max(this.x+this.width,t.x+t.width),r=Math.max(this.y+this.height,t.y+t.height);return new d(e,n,i-e,r-n)},include:function(){var t=h.read(arguments),e=Math.min(this.x,t.x),n=Math.min(this.y,t.y),i=Math.max(this.x+this.width,t.x),r=Math.max(this.y+this.height,t.y);return new d(e,n,i-e,r-n)},expand:function(){var t=l.read(arguments),e=t.width,n=t.height;return new d(this.x-e/2,this.y-n/2,this.width+e,this.height+n)},scale:function(e,n){return this.expand(this.width*e-this.width,this.height*(n===t?e:n)-this.height)}},e.each([["Top","Left"],["Top","Right"],["Bottom","Left"],["Bottom","Right"],["Left","Center"],["Top","Center"],["Right","Center"],["Bottom","Center"]],function(t,e){var n=t.join(""),i=/^[RL]/.test(n);e>=4&&(t[1]+=i?"Y":"X");var r=t[i?0:1],s=t[i?1:0],a="get"+r,o="get"+s,l="set"+r,c="set"+s,d="get"+n,f="set"+n;this[d]=function(t){var e=t?h:u;return new e(this[a](),this[o](),this,f)},this[f]=function(){var t=h.read(arguments);this[l](t.x),this[c](t.y)}},{beans:!0})),f=d.extend({initialize:function(t,e,n,i,r,s){this.set(t,e,n,i,!0),this._owner=r,this._setter=s},set:function(t,e,n,i,r){return this._x=t,this._y=e,this._width=n,this._height=i,r||this._owner[this._setter](this),this}},new function(){var t=d.prototype;return e.each(["x","y","width","height"],function(t){var n=e.capitalize(t),i="_"+t;this["get"+n]=function(){return this[i]},this["set"+n]=function(t){this[i]=t,this._dontNotify||this._owner[this._setter](this)}},e.each(["Point","Size","Center","Left","Top","Right","Bottom","CenterX","CenterY","TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],function(e){var n="set"+e;this[n]=function(){this._dontNotify=!0,t[n].apply(this,arguments),this._dontNotify=!1,this._owner[this._setter](this)}},{isSelected:function(){return this._owner._boundsSelected},setSelected:function(t){var e=this._owner;e.setSelected&&(e._boundsSelected=t,e.setSelected(t||e._selectedSegmentState>0))}}))}),g=e.extend({_class:"Matrix",initialize:function rt(t){var e=arguments.length,n=!0;if(6===e?this.set.apply(this,arguments):1===e?t instanceof rt?this.set(t._a,t._c,t._b,t._d,t._tx,t._ty):Array.isArray(t)?this.set.apply(this,t):n=!1:0===e?this.reset():n=!1,!n)throw Error("Unsupported matrix parameters")},set:function(t,e,n,i,r,s,a){return this._a=t,this._c=e,this._b=n,this._d=i,this._tx=r,this._ty=s,a||this._changed(),this},_serialize:function(t){return e.serialize(this.getValues(),t)},_changed:function(){var t=this._owner;t&&(t._applyMatrix?t.transform(null,!0):t._changed(9))},clone:function(){return new g(this._a,this._c,this._b,this._d,this._tx,this._ty)},equals:function(t){return t===this||t&&this._a===t._a&&this._b===t._b&&this._c===t._c&&this._d===t._d&&this._tx===t._tx&&this._ty===t._ty||!1},toString:function(){var t=s.instance;return"[["+[t.number(this._a),t.number(this._b),t.number(this._tx)].join(", ")+"], ["+[t.number(this._c),t.number(this._d),t.number(this._ty)].join(", ")+"]]"},reset:function(t){return this._a=this._d=1,this._c=this._b=this._tx=this._ty=0,t||this._changed(),this},apply:function(t,n){var i=this._owner;return i?(i.transform(null,!0,e.pick(t,!0),n),this.isIdentity()):!1},translate:function(){var t=h.read(arguments),e=t.x,n=t.y;return this._tx+=e*this._a+n*this._b,this._ty+=e*this._c+n*this._d,this._changed(),this},scale:function(){var t=h.read(arguments),e=h.read(arguments,0,{readNull:!0});return e&&this.translate(e),this._a*=t.x,this._c*=t.x,this._b*=t.y,this._d*=t.y,e&&this.translate(e.negate()),this._changed(),this},rotate:function(t){t*=Math.PI/180;var e=h.read(arguments,1),n=e.x,i=e.y,r=Math.cos(t),s=Math.sin(t),a=n-n*r+i*s,o=i-n*s-i*r,u=this._a,l=this._b,c=this._c,d=this._d;return this._a=r*u+s*l,this._b=-s*u+r*l,this._c=r*c+s*d,this._d=-s*c+r*d,this._tx+=a*u+o*l,this._ty+=a*c+o*d,this._changed(),this},shear:function(){var t=h.read(arguments),e=h.read(arguments,0,{readNull:!0});e&&this.translate(e);var n=this._a,i=this._c;return this._a+=t.y*this._b,this._c+=t.y*this._d,this._b+=t.x*n,this._d+=t.x*i,e&&this.translate(e.negate()),this._changed(),this},skew:function(){var t=h.read(arguments),e=h.read(arguments,0,{readNull:!0}),n=Math.PI/180,i=new h(Math.tan(t.x*n),Math.tan(t.y*n));return this.shear(i,e)},concatenate:function(t){var e=this._a,n=this._b,i=this._c,r=this._d,s=t._a,a=t._b,o=t._c,h=t._d,u=t._tx,l=t._ty;return this._a=s*e+o*n,
this._b=a*e+h*n,this._c=s*i+o*r,this._d=a*i+h*r,this._tx+=u*e+l*n,this._ty+=u*i+l*r,this._changed(),this},preConcatenate:function(t){var e=this._a,n=this._b,i=this._c,r=this._d,s=this._tx,a=this._ty,o=t._a,h=t._b,u=t._c,l=t._d,c=t._tx,d=t._ty;return this._a=o*e+h*i,this._b=o*n+h*r,this._c=u*e+l*i,this._d=u*n+l*r,this._tx=o*s+h*a+c,this._ty=u*s+l*a+d,this._changed(),this},chain:function(t){var e=this._a,n=this._b,i=this._c,r=this._d,s=this._tx,a=this._ty,o=t._a,h=t._b,u=t._c,l=t._d,c=t._tx,d=t._ty;return new g(o*e+u*n,o*i+u*r,h*e+l*n,h*i+l*r,s+c*e+d*n,a+c*i+d*r)},isIdentity:function(){return 1===this._a&&0===this._c&&0===this._b&&1===this._d&&0===this._tx&&0===this._ty},orNullIfIdentity:function(){return this.isIdentity()?null:this},isInvertible:function(){return!!this._getDeterminant()},isSingular:function(){return!this._getDeterminant()},transform:function(t,e,n){return arguments.length<3?this._transformPoint(h.read(arguments)):this._transformCoordinates(t,e,n)},_transformPoint:function(t,e,n){var i=t.x,r=t.y;return e||(e=new h),e.set(i*this._a+r*this._b+this._tx,i*this._c+r*this._d+this._ty,n)},_transformCoordinates:function(t,e,n){for(var i=0,r=0,s=2*n;s>i;){var a=t[i++],o=t[i++];e[r++]=a*this._a+o*this._b+this._tx,e[r++]=a*this._c+o*this._d+this._ty}return e},_transformCorners:function(t){var e=t.x,n=t.y,i=e+t.width,r=n+t.height,s=[e,n,i,n,i,r,e,r];return this._transformCoordinates(s,s,4)},_transformBounds:function(t,e,n){for(var i=this._transformCorners(t),r=i.slice(0,2),s=r.slice(),a=2;8>a;a++){var o=i[a],h=1&a;o<r[h]?r[h]=o:o>s[h]&&(s[h]=o)}return e||(e=new d),e.set(r[0],r[1],s[0]-r[0],s[1]-r[1],n)},inverseTransform:function(){return this._inverseTransform(h.read(arguments))},_getDeterminant:function(){var t=this._a*this._d-this._b*this._c;return isFinite(t)&&!a.isZero(t)&&isFinite(this._tx)&&isFinite(this._ty)?t:null},_inverseTransform:function(t,e,n){var i=this._getDeterminant();if(!i)return null;var r=t.x-this._tx,s=t.y-this._ty;return e||(e=new h),e.set((r*this._d-s*this._b)/i,(s*this._a-r*this._c)/i,n)},decompose:function(){var t=this._a,e=this._b,n=this._c,i=this._d;if(a.isZero(t*i-e*n))return null;var r=Math.sqrt(t*t+e*e);t/=r,e/=r;var s=t*n+e*i;n-=t*s,i-=e*s;var o=Math.sqrt(n*n+i*i);return n/=o,i/=o,s/=o,e*n>t*i&&(t=-t,e=-e,s=-s,r=-r),{scaling:new h(r,o),rotation:180*-Math.atan2(e,t)/Math.PI,shearing:s}},getValues:function(){return[this._a,this._c,this._b,this._d,this._tx,this._ty]},getTranslation:function(){return new h(this._tx,this._ty)},getScaling:function(){return(this.decompose()||{}).scaling},getRotation:function(){return(this.decompose()||{}).rotation},inverted:function(){var t=this._getDeterminant();return t&&new g(this._d/t,-this._c/t,-this._b/t,this._a/t,(this._b*this._ty-this._d*this._tx)/t,(this._c*this._tx-this._a*this._ty)/t)},shiftless:function(){return new g(this._a,this._c,this._b,this._d,0,0)},applyToContext:function(t){t.transform(this._a,this._c,this._b,this._d,this._tx,this._ty)}},e.each(["a","c","b","d","tx","ty"],function(t){var n=e.capitalize(t),i="_"+t;this["get"+n]=function(){return this[i]},this["set"+n]=function(t){this[i]=t,this._changed()}},{})),_=e.extend({_class:"Line",initialize:function(t,e,n,i,r){var s=!1;arguments.length>=4?(this._px=t,this._py=e,this._vx=n,this._vy=i,s=r):(this._px=t.x,this._py=t.y,this._vx=e.x,this._vy=e.y,s=n),s||(this._vx-=this._px,this._vy-=this._py)},getPoint:function(){return new h(this._px,this._py)},getVector:function(){return new h(this._vx,this._vy)},getLength:function(){return this.getVector().getLength()},intersect:function(t,e){return _.intersect(this._px,this._py,this._vx,this._vy,t._px,t._py,t._vx,t._vy,!0,e)},getSide:function(t,e){return _.getSide(this._px,this._py,this._vx,this._vy,t.x,t.y,!0,e)},getDistance:function(t){return Math.abs(_.getSignedDistance(this._px,this._py,this._vx,this._vy,t.x,t.y,!0))},isCollinear:function(t){return h.isCollinear(this._vx,this._vy,t._vx,t._vy)},isOrthogonal:function(t){return h.isOrthogonal(this._vx,this._vy,t._vx,t._vy)},statics:{intersect:function(t,e,n,i,r,s,o,u,l,c){l||(n-=t,i-=e,o-=r,u-=s);var d=n*u-i*o;if(!a.isZero(d)){var f=t-r,g=e-s,_=(o*g-u*f)/d,v=(n*g-i*f)/d,p=1e-12,m=-p,y=1+p;if(c||_>m&&y>_&&v>m&&y>v)return c||(_=0>=_?0:_>=1?1:_),new h(t+_*n,e+_*i)}},getSide:function(t,e,n,i,r,s,a,o){a||(n-=t,i-=e);var h=r-t,u=s-e,l=h*i-u*n;return 0!==l||o||(l=(h*n+h*n)/(n*n+i*i),l>=0&&1>=l&&(l=0)),0>l?-1:l>0?1:0},getSignedDistance:function(t,e,n,i,r,s,a){return a||(n-=t,i-=e),0===n?i>0?r-t:t-r:0===i?0>n?s-e:e-s:((r-t)*i-(s-e)*n)/Math.sqrt(n*n+i*i)}}}),v=r.extend({_class:"Project",_list:"projects",_reference:"project",initialize:function(t){r.call(this,!0),this.layers=[],this._activeLayer=null,this.symbols=[],this._currentStyle=new D(null,null,this),this._view=V.create(this,t||Y.getCanvas(1,1)),this._selectedItems={},this._selectedItemCount=0,this._updateVersion=0},_serialize:function(t,n){return e.serialize(this.layers,t,!0,n)},clear:function(){for(var t=this.layers.length-1;t>=0;t--)this.layers[t].remove();this.symbols=[]},isEmpty:function(){return 0===this.layers.length},remove:function st(){return st.base.call(this)?(this._view&&this._view.remove(),!0):!1},getView:function(){return this._view},getCurrentStyle:function(){return this._currentStyle},setCurrentStyle:function(t){this._currentStyle.initialize(t)},getIndex:function(){return this._index},getOptions:function(){return this._scope.settings},getActiveLayer:function(){return this._activeLayer||new w({project:this})},getSelectedItems:function(){var t=[];for(var e in this._selectedItems){var n=this._selectedItems[e];n.isInserted()&&t.push(n)}return t},insertChild:function(t,n,i){return n instanceof w?(n._remove(!1,!0),e.splice(this.layers,[n],t,0),n._setProject(this,!0),this._changes&&n._changed(5),this._activeLayer||(this._activeLayer=n)):n instanceof m?(this._activeLayer||this.insertChild(t,new w(m.NO_INSERT))).insertChild(t,n,i):n=null,n},addChild:function(e,n){return this.insertChild(t,e,n)},_updateSelection:function(t){var e=t._id,n=this._selectedItems;t._selected?n[e]!==t&&(this._selectedItemCount++,n[e]=t):n[e]===t&&(this._selectedItemCount--,delete n[e])},selectAll:function(){for(var t=this.layers,e=0,n=t.length;n>e;e++)t[e].setFullySelected(!0)},deselectAll:function(){var t=this._selectedItems;for(var e in t)t[e].setFullySelected(!1)},hitTest:function(){for(var t=h.read(arguments),n=S.getOptions(e.read(arguments)),i=this.layers.length-1;i>=0;i--){var r=this.layers[i]._hitTest(t,n);if(r)return r}return null},getItems:function(t){return m._getItems(this.layers,t)},getItem:function(t){return m._getItems(this.layers,t,null,null,!0)[0]||null},importJSON:function(t){this.activate();var n=this._activeLayer;return e.importJSON(t,n&&n.isEmpty()&&n)},draw:function(t,n,i){this._updateVersion++,t.save(),n.applyToContext(t);for(var r=new e({offset:new h(0,0),pixelRatio:i,viewMatrix:n.isIdentity()?null:n,matrices:[new g],updateMatrix:!0}),s=0,a=this.layers,o=a.length;o>s;s++)a[s].draw(t,r);if(t.restore(),this._selectedItemCount>0){t.save(),t.strokeWidth=1;var u=this._selectedItems,l=this._scope.settings.handleSize,c=this._updateVersion;for(var d in u)u[d]._drawSelection(t,n,l,u,c);t.restore()}}}),p=e.extend({_class:"Symbol",initialize:function(t,e){this._id=o.get(),this.project=paper.project,this.project.symbols.push(this),t&&this.setDefinition(t,e)},_serialize:function(t,n){return n.add(this,function(){return e.serialize([this._class,this._definition],t,!1,n)})},_changed:function(t){8&t&&m._clearBoundsCache(this),1&t&&(this.project._needsUpdate=!0)},getDefinition:function(){return this._definition},setDefinition:function(t,e){t._parentSymbol&&(t=t.clone()),this._definition&&(this._definition._parentSymbol=null),this._definition=t,t.remove(),t.setSelected(!1),e||t.setPosition(new h),t._parentSymbol=this,this._changed(9)},place:function(t){return new C(this,t)},clone:function(){return new p(this._definition.clone(!1))},equals:function(t){return t===this||t&&this.definition.equals(t.definition)||!1}}),m=e.extend(n,{statics:{extend:function at(t){return t._serializeFields&&(t._serializeFields=new e(this.prototype._serializeFields,t._serializeFields)),at.base.apply(this,arguments)},NO_INSERT:{insert:!1}},_class:"Item",_applyMatrix:!0,_canApplyMatrix:!0,_boundsSelected:!1,_selectChildren:!1,_serializeFields:{name:null,applyMatrix:null,matrix:new g,pivot:null,locked:!1,visible:!0,blendMode:"normal",opacity:1,guide:!1,selected:!1,clipMask:!1,data:{}},initialize:function(){},_initialize:function(t,n){var i=t&&e.isPlainObject(t),r=i&&t.internal===!0,s=this._matrix=new g,a=i&&t.project||paper.project;return r||(this._id=o.get()),this._applyMatrix=this._canApplyMatrix&&paper.settings.applyMatrix,n&&s.translate(n),s._owner=this,this._style=new D(a._currentStyle,this,a),this._project||(r||i&&t.insert===!1?this._setProject(a):i&&t.parent?this.setParent(t.parent):(a._activeLayer||new w).addChild(this)),i&&t!==m.NO_INSERT&&this._set(t,{insert:!0,project:!0,parent:!0},!0),i},_events:e.each(["onMouseDown","onMouseUp","onMouseDrag","onClick","onDoubleClick","onMouseMove","onMouseEnter","onMouseLeave"],function(t){this[t]={install:function(t){this.getView()._installEvent(t)},uninstall:function(t){this.getView()._uninstallEvent(t)}}},{onFrame:{install:function(){this.getView()._animateItem(this,!0)},uninstall:function(){this.getView()._animateItem(this,!1)}},onLoad:{}}),_serialize:function(t,n){function i(i){for(var a in i){var o=s[a];e.equals(o,"leading"===a?1.2*i.fontSize:i[a])||(r[a]=e.serialize(o,t,"data"!==a,n))}}var r={},s=this;return i(this._serializeFields),this instanceof y||i(this._style._defaults),[this._class,r]},_changed:function(e){var n=this._parentSymbol,i=this._parent||n,r=this._project;if(8&e&&(this._bounds=this._position=this._decomposed=this._globalMatrix=this._currentPath=t),i&&40&e&&m._clearBoundsCache(i),2&e&&m._clearBoundsCache(this),r&&(1&e&&(r._needsUpdate=!0),r._changes)){var s=r._changesById[this._id];s?s.flags|=e:(s={item:this,flags:e},r._changesById[this._id]=s,r._changes.push(s))}n&&n._changed(e)},set:function(t){return t&&this._set(t),this},getId:function(){return this._id},getName:function(){return this._name},setName:function(e,n){if(this._name&&this._removeNamed(),e===+e+"")throw Error("Names consisting only of numbers are not supported.");var i=this._parent;if(e&&i){for(var r=i._children,s=i._namedChildren,a=e,o=1;n&&r[e];)e=a+" "+o++;(s[e]=s[e]||[]).push(this),r[e]=this}this._name=e||t,this._changed(128)},getStyle:function(){return this._style},setStyle:function(t){this.getStyle().set(t)}},e.each(["locked","visible","blendMode","opacity","guide"],function(t){var n=e.capitalize(t),t="_"+t;this["get"+n]=function(){return this[t]},this["set"+n]=function(e){e!=this[t]&&(this[t]=e,this._changed("_locked"===t?128:129))}},{}),{beans:!0,_locked:!1,_visible:!0,_blendMode:"normal",_opacity:1,_guide:!1,isSelected:function(){if(this._selectChildren)for(var t=this._children,e=0,n=t.length;n>e;e++)if(t[e].isSelected())return!0;return this._selected},setSelected:function(t,e){if(!e&&this._selectChildren)for(var n=this._children,i=0,r=n.length;r>i;i++)n[i].setSelected(t);(t=!!t)^this._selected&&(this._selected=t,this._project._updateSelection(this),this._changed(129))},_selected:!1,isFullySelected:function(){var t=this._children;if(t&&this._selected){for(var e=0,n=t.length;n>e;e++)if(!t[e].isFullySelected())return!1;return!0}return this._selected},setFullySelected:function(t){var e=this._children;if(e)for(var n=0,i=e.length;i>n;n++)e[n].setFullySelected(t);this.setSelected(t,!0)},isClipMask:function(){return this._clipMask},setClipMask:function(t){this._clipMask!=(t=!!t)&&(this._clipMask=t,t&&(this.setFillColor(null),this.setStrokeColor(null)),this._changed(129),this._parent&&this._parent._changed(1024))},_clipMask:!1,getData:function(){return this._data||(this._data={}),this._data},setData:function(t){this._data=t},getPosition:function(t){var e=this._position,n=t?h:u;if(!e){var i=this._pivot;e=this._position=i?this._matrix._transformPoint(i):this.getBounds().getCenter(!0)}return new n(e.x,e.y,this,"setPosition")},setPosition:function(){this.translate(h.read(arguments).subtract(this.getPosition(!0)))},getPivot:function(t){var e=this._pivot;if(e){var n=t?h:u;e=new n(e.x,e.y,this,"setPivot")}return e},setPivot:function(){this._pivot=h.read(arguments,0,{clone:!0,readNull:!0}),this._position=t},_pivot:null},e.each(["bounds","strokeBounds","handleBounds","roughBounds","internalBounds","internalRoughBounds"],function(t){var n="get"+e.capitalize(t),i=t.match(/^internal(.*)$/),r=i?"get"+i[1]:null;this[n]=function(e){var i=this._boundsGetter,s=!r&&("string"==typeof i?i:i&&i[n])||n,a=this._getCachedBounds(s,e,this,r);return"bounds"===t?new f(a.x,a.y,a.width,a.height,this,"setBounds"):a}},{beans:!0,_getBounds:function(t,e,n){var i=this._children;if(!i||0==i.length)return new d;m._updateBoundsCache(this,n);for(var r=1/0,s=-r,a=r,o=s,h=0,u=i.length;u>h;h++){var l=i[h];if(l._visible&&!l.isEmpty()){var c=l._getCachedBounds(t,e&&e.chain(l._matrix),n);r=Math.min(c.x,r),a=Math.min(c.y,a),s=Math.max(c.x+c.width,s),o=Math.max(c.y+c.height,o)}}return isFinite(r)?new d(r,a,s-r,o-a):new d},setBounds:function(){var t=d.read(arguments),e=this.getBounds(),n=new g,i=t.getCenter();n.translate(i),(t.width!=e.width||t.height!=e.height)&&n.scale(0!=e.width?t.width/e.width:1,0!=e.height?t.height/e.height:1),i=e.getCenter(),n.translate(-i.x,-i.y),this.transform(n)},_getCachedBounds:function(t,e,n,i){e=e&&e.orNullIfIdentity();var r=i?null:this._matrix.orNullIfIdentity(),s=(!e||e.equals(r))&&t;if(m._updateBoundsCache(this._parent||this._parentSymbol,n),s&&this._bounds&&this._bounds[s])return this._bounds[s].clone();var a=this._getBounds(i||t,e||r,n);if(s){this._bounds||(this._bounds={});var o=this._bounds[s]=a.clone();o._internal=!!i}return a},statics:{_updateBoundsCache:function(t,e){if(t){var n=e._id,i=t._boundsCache=t._boundsCache||{ids:{},list:[]};i.ids[n]||(i.list.push(e),i.ids[n]=e)}},_clearBoundsCache:function(e){var n=e._boundsCache;if(n){e._bounds=e._position=e._boundsCache=t;for(var i=0,r=n.list,s=r.length;s>i;i++){var a=r[i];a!==e&&(a._bounds=a._position=t,a._boundsCache&&m._clearBoundsCache(a))}}}}}),{beans:!0,_decompose:function(){return this._decomposed=this._matrix.decompose()},getRotation:function(){var t=this._decomposed||this._decompose();return t&&t.rotation},setRotation:function(t){var e=this.getRotation();if(null!=e&&null!=t){var n=this._decomposed;this.rotate(t-e),n.rotation=t,this._decomposed=n}},getScaling:function(t){var e=this._decomposed||this._decompose(),n=e&&e.scaling,i=t?h:u;return n&&new i(n.x,n.y,this,"setScaling")},setScaling:function(){var t=this.getScaling();if(t){var e=h.read(arguments,0,{clone:!0}),n=this._decomposed;this.scale(e.x/t.x,e.y/t.y),n.scaling=e,this._decomposed=n}},getMatrix:function(){return this._matrix},setMatrix:function(){var t=this._matrix;t.initialize.apply(t,arguments),this._applyMatrix?this.transform(null,!0):this._changed(9)},getGlobalMatrix:function(t){var e=this._globalMatrix,n=this._project._updateVersion;if(e&&e._updateVersion!==n&&(e=null),!e){e=this._globalMatrix=this._matrix.clone();var i=this._parent;i&&e.preConcatenate(i.getGlobalMatrix(!0)),e._updateVersion=n}return t?e:e.clone()},getApplyMatrix:function(){return this._applyMatrix},setApplyMatrix:function(t){(this._applyMatrix=this._canApplyMatrix&&!!t)&&this.transform(null,!0)},getTransformContent:"#getApplyMatrix",setTransformContent:"#setApplyMatrix"},{getProject:function(){return this._project},_setProject:function(t,e){if(this._project!==t){this._project&&this._installEvents(!1),this._project=t;for(var n=this._children,i=0,r=n&&n.length;r>i;i++)n[i]._setProject(t);e=!0}e&&this._installEvents(!0)},getView:function(){return this._project.getView()},_installEvents:function ot(t){ot.base.call(this,t);for(var e=this._children,n=0,i=e&&e.length;i>n;n++)e[n]._installEvents(t)},getLayer:function(){for(var t=this;t=t._parent;)if(t instanceof w)return t;return null},getParent:function(){return this._parent},setParent:function(t){return t.addChild(this)},getChildren:function(){return this._children},setChildren:function(t){this.removeChildren(),this.addChildren(t)},getFirstChild:function(){return this._children&&this._children[0]||null},getLastChild:function(){return this._children&&this._children[this._children.length-1]||null},getNextSibling:function(){return this._parent&&this._parent._children[this._index+1]||null},getPreviousSibling:function(){return this._parent&&this._parent._children[this._index-1]||null},getIndex:function(){return this._index},equals:function(t){return t===this||t&&this._class===t._class&&this._style.equals(t._style)&&this._matrix.equals(t._matrix)&&this._locked===t._locked&&this._visible===t._visible&&this._blendMode===t._blendMode&&this._opacity===t._opacity&&this._clipMask===t._clipMask&&this._guide===t._guide&&this._equals(t)||!1},_equals:function(t){return e.equals(this._children,t._children)},clone:function(t){return this._clone(new this.constructor(m.NO_INSERT),t)},_clone:function(n,i,r){var s=["_locked","_visible","_blendMode","_opacity","_clipMask","_guide"],a=this._children;n.setStyle(this._style);for(var o=0,h=a&&a.length;h>o;o++)n.addChild(a[o].clone(!1),!0);for(var o=0,h=s.length;h>o;o++){var u=s[o];this.hasOwnProperty(u)&&(n[u]=this[u])}return r!==!1&&n._matrix.initialize(this._matrix),n.setApplyMatrix(this._applyMatrix),n.setPivot(this._pivot),n.setSelected(this._selected),n._data=this._data?e.clone(this._data):null,(i||i===t)&&n.insertAbove(this),this._name&&n.setName(this._name,!0),n},copyTo:function(t){return t.addChild(this.clone(!1))},rasterize:function(t){var n=this.getStrokeBounds(),i=(t||this.getView().getResolution())/72,r=n.getTopLeft().floor(),s=n.getBottomRight().ceil(),a=new l(s.subtract(r)),o=Y.getCanvas(a.multiply(i)),h=o.getContext("2d"),u=(new g).scale(i).translate(r.negate());h.save(),u.applyToContext(h),this.draw(h,new e({matrices:[u]})),h.restore();var c=new b(m.NO_INSERT);return c.setCanvas(o),c.transform((new g).translate(r.add(a.divide(2))).scale(1/i)),c.insertAbove(this),c},contains:function(){return!!this._contains(this._matrix._inverseTransform(h.read(arguments)))},_contains:function(t){if(this._children){for(var e=this._children.length-1;e>=0;e--)if(this._children[e].contains(t))return!0;return!1}return t.isInside(this.getInternalBounds())},isInside:function(){return d.read(arguments).contains(this.getBounds())},_asPathItem:function(){return new A.Rectangle({rectangle:this.getInternalBounds(),matrix:this._matrix,insert:!1})},intersects:function(t,e){return t instanceof m?this._asPathItem().getIntersections(t._asPathItem(),null,e||t._matrix,!0).length>0:!1},hitTest:function(){return this._hitTest(h.read(arguments),S.getOptions(e.read(arguments)))},_hitTest:function(n,i){function r(i,r){var s=g["get"+r]();return n.subtract(s).divide(u).length<=1?new S(i,f,{name:e.hyphenate(r),point:s}):t}if(this._locked||!this._visible||this._guide&&!i.guides||this.isEmpty())return null;var s=this._matrix,a=i._totalMatrix,o=this.getView(),h=i._totalMatrix=a?a.chain(s):this.getGlobalMatrix().preConcatenate(o._matrix),u=i._tolerancePadding=new l(A._getPenPadding(1,h.inverted())).multiply(Math.max(i.tolerance,1e-6));if(n=s._inverseTransform(n),!this._children&&!this.getInternalRoughBounds().expand(u.multiply(2))._containsPoint(n))return null;var c,d=!(i.guides&&!this._guide||i.selected&&!this._selected||i.type&&i.type!==e.hyphenate(this._class)||i["class"]&&!(this instanceof i["class"])),f=this;if(d&&(i.center||i.bounds)&&this._parent){var g=this.getInternalBounds();if(i.center&&(c=r("center","Center")),!c&&i.bounds)for(var _=["TopLeft","TopRight","BottomLeft","BottomRight","LeftCenter","TopCenter","RightCenter","BottomCenter"],v=0;8>v&&!c;v++)c=r("bounds",_[v])}var p=!c&&this._children;if(p)for(var m=this._getChildHitTestOptions(i),v=p.length-1;v>=0&&!c;v--)c=p[v]._hitTest(n,m);return!c&&d&&(c=this._hitTestSelf(n,i)),c&&c.point&&(c.point=s.transform(c.point)),i._totalMatrix=a,c},_getChildHitTestOptions:function(t){return t},_hitTestSelf:function(e,n){return n.fill&&this.hasFill()&&this._contains(e)?new S("fill",this):t},matches:function(t,n){function i(t,n){for(var r in t)if(t.hasOwnProperty(r)){var s=t[r],a=n[r];if(e.isPlainObject(s)&&e.isPlainObject(a)){if(!i(s,a))return!1}else if(!e.equals(s,a))return!1}return!0}var r=typeof t;if("object"===r){for(var s in t)if(t.hasOwnProperty(s)&&!this.matches(s,t[s]))return!1}else{if("function"===r)return t(this);var a=/^(empty|editable)$/.test(t)?this["is"+e.capitalize(t)]():"type"===t?e.hyphenate(this._class):this[t];if(/^(constructor|class)$/.test(t)){if(!(this instanceof n))return!1}else if(n instanceof RegExp){if(!n.test(a))return!1}else if("function"==typeof n){if(!n(a))return!1}else if(e.isPlainObject(n)){if(!i(n,a))return!1}else if(!e.equals(a,n))return!1}return!0},getItems:function(t){return m._getItems(this._children,t,this._matrix)},getItem:function(t){return m._getItems(this._children,t,this._matrix,null,!0)[0]||null},statics:{_getItems:function ht(t,n,i,r,s){if(!r&&"object"==typeof n){var a=n.overlapping,o=n.inside,h=a||o,u=h&&d.read([h]);r={items:[],inside:!!o,overlapping:!!a,rect:u,path:a&&new A.Rectangle({rectangle:u,insert:!1})},h&&(n=e.set({},n,{inside:!0,overlapping:!0}))}var l=r&&r.items,u=r&&r.rect;i=u&&(i||new g);for(var c=0,f=t&&t.length;f>c;c++){var _=t[c],v=i&&i.chain(_._matrix),p=!0;if(u){var h=_.getBounds(v);if(!u.intersects(h))continue;r.inside&&u.contains(h)||r.overlapping&&(h.contains(u)||r.path.intersects(_,v))||(p=!1)}if(p&&_.matches(n)&&(l.push(_),s))break;if(ht(_._children,n,v,r,s),s&&l.length>0)break}return l}}},{importJSON:function(t){var n=e.importJSON(t,this);return n!==this?this.addChild(n):n},addChild:function(e,n){return this.insertChild(t,e,n)},insertChild:function(t,e,n){var i=e?this.insertChildren(t,[e],n):null;return i&&i[0]},addChildren:function(t,e){return this.insertChildren(this._children.length,t,e)},insertChildren:function(t,n,i,r){var s=this._children;if(s&&n&&n.length>0){n=Array.prototype.slice.apply(n);for(var a=n.length-1;a>=0;a--){var o=n[a];if(!r||o instanceof r){var h=o._parent===this&&o._index<t;o._remove(!1,!0)&&h&&t--}else n.splice(a,1)}e.splice(s,n,t,0);for(var u=this._project,l=u&&u._changes,a=0,c=n.length;c>a;a++){var o=n[a];o._parent=this,o._setProject(this._project,!0),o._name&&o.setName(o._name),l&&this._changed(5)}this._changed(11)}else n=null;return n},_insertSibling:function(t,e,n){return this._parent?this._parent.insertChild(t,e,n):null},insertAbove:function(t,e){return t._insertSibling(t._index+1,this,e)},insertBelow:function(t,e){return t._insertSibling(t._index,this,e)},sendToBack:function(){return(this._parent||this instanceof w&&this._project).insertChild(0,this)},bringToFront:function(){return(this._parent||this instanceof w&&this._project).addChild(this)},appendTop:"#addChild",appendBottom:function(t){return this.insertChild(0,t)},moveAbove:"#insertAbove",moveBelow:"#insertBelow",reduce:function(){if(this._children&&1===this._children.length){var t=this._children[0].reduce();return t.insertAbove(this),t.setStyle(this._style),this.remove(),t}return this},_removeNamed:function(){var t=this._parent;if(t){var e=t._children,n=t._namedChildren,i=this._name,r=n[i],s=r?r.indexOf(this):-1;-1!==s&&(e[i]==this&&delete e[i],r.splice(s,1),r.length?e[i]=r[r.length-1]:delete n[i])}},_remove:function(t,n){var i=this._parent;if(i){if(this._name&&this._removeNamed(),null!=this._index&&e.splice(i._children,null,this._index,1),this._installEvents(!1),t){var r=this._project;r&&r._changes&&this._changed(5)}return n&&i._changed(11),this._parent=null,!0}return!1},remove:function(){return this._remove(!0,!0)},replaceWith:function(t){var e=t&&t.insertBelow(this);return e&&this.remove(),e},removeChildren:function(t,n){if(!this._children)return null;t=t||0,n=e.pick(n,this._children.length);for(var i=e.splice(this._children,null,t,n-t),r=i.length-1;r>=0;r--)i[r]._remove(!0,!1);return i.length>0&&this._changed(11),i},clear:"#removeChildren",reverseChildren:function(){if(this._children){this._children.reverse();for(var t=0,e=this._children.length;e>t;t++)this._children[t]._index=t;this._changed(11)}},isEmpty:function(){return!this._children||0===this._children.length},isEditable:function(){for(var t=this;t;){if(!t._visible||t._locked)return!1;t=t._parent}return!0},hasFill:function(){return this.getStyle().hasFill()},hasStroke:function(){return this.getStyle().hasStroke()},hasShadow:function(){return this.getStyle().hasShadow()},_getOrder:function(t){function e(t){var e=[];do e.unshift(t);while(t=t._parent);return e}for(var n=e(this),i=e(t),r=0,s=Math.min(n.length,i.length);s>r;r++)if(n[r]!=i[r])return n[r]._index<i[r]._index?1:-1;return 0},hasChildren:function(){return this._children&&this._children.length>0},isInserted:function(){return this._parent?this._parent.isInserted():!1},isAbove:function(t){return-1===this._getOrder(t)},isBelow:function(t){return 1===this._getOrder(t)},isParent:function(t){return this._parent===t},isChild:function(t){return t&&t._parent===this},isDescendant:function(t){for(var e=this;e=e._parent;)if(e==t)return!0;return!1},isAncestor:function(t){return t?t.isDescendant(this):!1},isSibling:function(t){return this._parent===t._parent},isGroupedWith:function(t){for(var e=this._parent;e;){if(e._parent&&/^(Group|Layer|CompoundPath)$/.test(e._class)&&t.isDescendant(e))return!0;e=e._parent}return!1},translate:function(){var t=new g;return this.transform(t.translate.apply(t,arguments))},rotate:function(t){return this.transform((new g).rotate(t,h.read(arguments,1,{readNull:!0})||this.getPosition(!0)))}},e.each(["scale","shear","skew"],function(t){this[t]=function(){var e=h.read(arguments),n=h.read(arguments,0,{readNull:!0});return this.transform((new g)[t](e,n||this.getPosition(!0)))}},{}),{transform:function(t,e,n,i){t&&t.isIdentity()&&(t=null);var r=this._matrix,s=(e||this._applyMatrix)&&(!r.isIdentity()||t||e&&n&&this._children);if(!t&&!s)return this;if(t&&r.preConcatenate(t),s=s&&this._transformContent(r,n,i)){var a=this._pivot,o=this._style,h=o.getFillColor(!0),u=o.getStrokeColor(!0);a&&r._transformPoint(a,a,!0),h&&h.transform(r),u&&u.transform(r),r.reset(!0),i&&this._canApplyMatrix&&(this._applyMatrix=!0)}var l=this._bounds,c=this._position;this._changed(9);var d=l&&t&&t.decompose();if(d&&!d.shearing&&d.rotation%90===0){for(var f in l){var g=l[f];(s||!g._internal)&&t._transformBounds(g,g)}var _=this._boundsGetter,g=l[_&&_.getBounds||_||"getBounds"];g&&(this._position=g.getCenter(!0)),this._bounds=l}else t&&c&&(this._position=t._transformPoint(c,c));return this},_transformContent:function(t,e,n){var i=this._children;if(i){for(var r=0,s=i.length;s>r;r++)i[r].transform(t,!0,e,n);return!0}},globalToLocal:function(){return this.getGlobalMatrix(!0)._inverseTransform(h.read(arguments))},localToGlobal:function(){return this.getGlobalMatrix(!0)._transformPoint(h.read(arguments))},parentToLocal:function(){return this._matrix._inverseTransform(h.read(arguments))},localToParent:function(){return this._matrix._transformPoint(h.read(arguments))},fitBounds:function(t,e){t=d.read(arguments);var n=this.getBounds(),i=n.height/n.width,r=t.height/t.width,s=(e?i>r:r>i)?t.width/n.width:t.height/n.height,a=new d(new h,new l(n.width*s,n.height*s));a.setCenter(t.getCenter()),this.setBounds(a)},_setStyles:function(t){var e=this._style,n=e.getFillColor(),i=e.getStrokeColor(),r=e.getShadowColor();if(n&&(t.fillStyle=n.toCanvasStyle(t)),i){var s=e.getStrokeWidth();if(s>0){t.strokeStyle=i.toCanvasStyle(t),t.lineWidth=s;var a=e.getStrokeJoin(),o=e.getStrokeCap(),h=e.getMiterLimit();if(a&&(t.lineJoin=a),o&&(t.lineCap=o),h&&(t.miterLimit=h),paper.support.nativeDash){var u=e.getDashArray(),l=e.getDashOffset();u&&u.length&&("setLineDash"in t?(t.setLineDash(u),t.lineDashOffset=l):(t.mozDash=u,t.mozDashOffset=l))}}}if(r){var c=e.getShadowBlur();if(c>0){t.shadowColor=r.toCanvasStyle(t),t.shadowBlur=c;var d=this.getShadowOffset();t.shadowOffsetX=d.x,t.shadowOffsetY=d.y}}},draw:function(t,e,n){function i(t){return a?a.chain(t):t}var r=this._updateVersion=this._project._updateVersion;if(this._visible&&0!==this._opacity){var s=e.matrices,a=e.viewMatrix,o=this._matrix,h=s[s.length-1].chain(o);if(h.isInvertible()){s.push(h),e.updateMatrix&&(h._updateVersion=r,this._globalMatrix=h);var u,l,c,d=this._blendMode,f=this._opacity,g="normal"===d,_=K.nativeModes[d],v=g&&1===f||e.dontStart||e.clip||(_||g&&1>f)&&this._canComposite(),p=e.pixelRatio||1;if(!v){var m=this.getStrokeBounds(i(h));if(!m.width||!m.height)return;c=e.offset,l=e.offset=m.getTopLeft().floor(),u=t,t=Y.getContext(m.getSize().ceil().add(1).multiply(p)),1!==p&&t.scale(p,p)}t.save();var y=n?n.chain(o):!this.getStrokeScaling(!0)&&i(h),w=!v&&e.clipItem,x=!y||w;if(v?(t.globalAlpha=f,_&&(t.globalCompositeOperation=d)):x&&t.translate(-l.x,-l.y),x&&(v?o:i(h)).applyToContext(t),w&&e.clipItem.draw(t,e.extend({clip:!0})),y){t.setTransform(p,0,0,p,0,0);var b=e.offset;b&&t.translate(-b.x,-b.y)}this._draw(t,e,y),t.restore(),s.pop(),e.clip&&!e.dontFinish&&t.clip(),v||(K.process(d,t,u,f,l.subtract(c).multiply(p)),Y.release(t),e.offset=c)}}},_isUpdated:function(t){var e=this._parent;if(e instanceof O)return e._isUpdated(t);var n=this._updateVersion===t;return!n&&e&&e._visible&&e._isUpdated(t)&&(this._updateVersion=t,n=!0),n},_drawSelection:function(t,e,n,i,r){if((this._drawSelected||this._boundsSelected)&&this._isUpdated(r)){var s=this.getSelectedColor(!0)||this.getLayer().getSelectedColor(!0),a=e.chain(this.getGlobalMatrix(!0));if(t.strokeStyle=t.fillStyle=s?s.toCanvasStyle(t):"#009dec",this._drawSelected&&this._drawSelected(t,a,i),this._boundsSelected){var o=n/2,h=a._transformCorners(this.getInternalBounds());t.beginPath();for(var u=0;8>u;u++)t[0===u?"moveTo":"lineTo"](h[u],h[++u]);t.closePath(),t.stroke();for(var u=0;8>u;u++)t.fillRect(h[u]-o,h[++u]-o,n,n)}}},_canComposite:function(){return!1}},e.each(["down","drag","up","move"],function(t){this["removeOn"+e.capitalize(t)]=function(){var e={};return e[t]=!0,this.removeOn(e)}},{removeOn:function(t){for(var e in t)if(t[e]){var n="mouse"+e,i=this._project,r=i._removeSets=i._removeSets||{};r[n]=r[n]||{},r[n][this._id]=this}return this}})),y=m.extend({_class:"Group",_selectChildren:!0,_serializeFields:{children:[]},initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||this.addChildren(Array.isArray(t)?t:arguments)},_changed:function ut(e){ut.base.call(this,e),1026&e&&(this._clipItem=t)},_getClipItem:function(){var e=this._clipItem;if(e===t){e=null;for(var n=0,i=this._children.length;i>n;n++){var r=this._children[n];if(r._clipMask){e=r;break}}this._clipItem=e}return e},isClipped:function(){return!!this._getClipItem()},setClipped:function(t){var e=this.getFirstChild();e&&e.setClipMask(t)},_draw:function(t,e){var n=e.clip,i=!n&&this._getClipItem(),r=!0;if(e=e.extend({clipItem:i,clip:!1}),n?this._currentPath?(t.currentPath=this._currentPath,r=!1):(t.beginPath(),e.dontStart=e.dontFinish=!0):i&&i.draw(t,e.extend({clip:!0})),r)for(var s=0,a=this._children.length;a>s;s++){var o=this._children[s];o!==i&&o.draw(t,e)}n&&(this._currentPath=t.currentPath)}}),w=y.extend({_class:"Layer",initialize:function(n){var i=e.isPlainObject(n)?new e(n):{children:Array.isArray(n)?n:arguments},r=i.insert;i.insert=!1,y.call(this,i),(r||r===t)&&(this._project.addChild(this),this.activate())},_remove:function lt(t,n){if(this._parent)return lt.base.call(this,t,n);if(null!=this._index){var i=this._project;return i._activeLayer===this&&(i._activeLayer=this.getNextSibling()||this.getPreviousSibling()),e.splice(i.layers,null,this._index,1),this._installEvents(!1),t&&i._changes&&this._changed(5),n&&(i._needsUpdate=!0),!0}return!1},getNextSibling:function ct(){return this._parent?ct.base.call(this):this._project.layers[this._index+1]||null},getPreviousSibling:function dt(){return this._parent?dt.base.call(this):this._project.layers[this._index-1]||null;
},isInserted:function ft(){return this._parent?ft.base.call(this):null!=this._index},activate:function(){this._project._activeLayer=this},_insertSibling:function gt(t,e,n){return this._parent?gt.base.call(this,t,e,n):this._project.insertChild(t,e,n)}}),x=m.extend({_class:"Shape",_applyMatrix:!1,_canApplyMatrix:!1,_boundsSelected:!0,_serializeFields:{type:null,size:null,radius:null},initialize:function(t){this._initialize(t)},_equals:function(t){return this._type===t._type&&this._size.equals(t._size)&&e.equals(this._radius,t._radius)},clone:function(t){var e=new x(m.NO_INSERT);return e.setType(this._type),e.setSize(this._size),e.setRadius(this._radius),this._clone(e,t)},getType:function(){return this._type},setType:function(t){this._type=t},getShape:"#getType",setShape:"#setType",getSize:function(){var t=this._size;return new c(t.width,t.height,this,"setSize")},setSize:function(){var t=l.read(arguments);if(this._size){if(!this._size.equals(t)){var e=this._type,n=t.width,i=t.height;if("rectangle"===e){var r=l.min(this._radius,t.divide(2));this._radius.set(r.width,r.height)}else"circle"===e?(n=i=(n+i)/2,this._radius=n/2):"ellipse"===e&&this._radius.set(n/2,i/2);this._size.set(n,i),this._changed(9)}}else this._size=t.clone()},getRadius:function(){var t=this._radius;return"circle"===this._type?t:new c(t.width,t.height,this,"setRadius")},setRadius:function(t){var e=this._type;if("circle"===e){if(t===this._radius)return;var n=2*t;this._radius=t,this._size.set(n,n)}else if(t=l.read(arguments),this._radius){if(this._radius.equals(t))return;if(this._radius.set(t.width,t.height),"rectangle"===e){var n=l.max(this._size,t.multiply(2));this._size.set(n.width,n.height)}else"ellipse"===e&&this._size.set(2*t.width,2*t.height)}else this._radius=t.clone();this._changed(9)},isEmpty:function(){return!1},toPath:function(t){var n=this._clone(new(A[e.capitalize(this._type)])({center:new h,size:this._size,radius:this._radius,insert:!1}),t);return paper.settings.applyMatrix&&n.setApplyMatrix(!0),n},_draw:function(t,e,n){var i=this._style,r=i.hasFill(),s=i.hasStroke(),a=e.dontFinish||e.clip,o=!n;if(r||s||a){var h=this._type,u=this._radius,l="circle"===h;if(e.dontStart||t.beginPath(),o&&l)t.arc(0,0,u,0,2*Math.PI,!0);else{var c=l?u:u.width,d=l?u:u.height,f=this._size,g=f.width,_=f.height;if(o&&"rectangle"===h&&0===c&&0===d)t.rect(-g/2,-_/2,g,_);else{var v=g/2,p=_/2,m=.44771525016920644,y=c*m,w=d*m,x=[-v,-p+d,-v,-p+w,-v+y,-p,-v+c,-p,v-c,-p,v-y,-p,v,-p+w,v,-p+d,v,p-d,v,p-w,v-y,p,v-c,p,-v+c,p,-v+y,p,-v,p-w,-v,p-d];n&&n.transform(x,x,32),t.moveTo(x[0],x[1]),t.bezierCurveTo(x[2],x[3],x[4],x[5],x[6],x[7]),v!==c&&t.lineTo(x[8],x[9]),t.bezierCurveTo(x[10],x[11],x[12],x[13],x[14],x[15]),p!==d&&t.lineTo(x[16],x[17]),t.bezierCurveTo(x[18],x[19],x[20],x[21],x[22],x[23]),v!==c&&t.lineTo(x[24],x[25]),t.bezierCurveTo(x[26],x[27],x[28],x[29],x[30],x[31])}}t.closePath()}a||!r&&!s||(this._setStyles(t),r&&(t.fill(i.getWindingRule()),t.shadowColor="rgba(0,0,0,0)"),s&&t.stroke())},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_getBounds:function(t,e){var n=new d(this._size).setCenter(0,0);return"getBounds"!==t&&this.hasStroke()&&(n=n.expand(this.getStrokeWidth())),e?e._transformBounds(n):n}},new function(){function t(t,e,n){var i=t._radius;if(!i.isZero())for(var r=t._size.divide(2),s=0;4>s;s++){var a=new h(1&s?1:-1,s>1?1:-1),o=a.multiply(r),u=o.subtract(a.multiply(i)),l=new d(o,u);if((n?l.expand(n):l).contains(e))return u}}function e(t,e){var n=t.getAngleInRadians(),i=2*e.width,r=2*e.height,s=i*Math.sin(n),a=r*Math.cos(n);return i*r/(2*Math.sqrt(s*s+a*a))}return{_contains:function n(e){if("rectangle"===this._type){var i=t(this,e);return i?e.subtract(i).divide(this._radius).getLength()<=1:n.base.call(this,e)}return e.divide(this.size).getLength()<=.5},_hitTestSelf:function i(n,r){var s=!1;if(this.hasStroke()){var a=this._type,o=this._radius,h=this.getStrokeWidth()+2*r.tolerance;if("rectangle"===a){var u=t(this,n,h);if(u){var l=n.subtract(u);s=2*Math.abs(l.getLength()-e(l,o))<=h}else{var c=new d(this._size).setCenter(0,0),f=c.expand(h),g=c.expand(-h);s=f._containsPoint(n)&&!g._containsPoint(n)}}else"ellipse"===a&&(o=e(n,o)),s=2*Math.abs(n.getLength()-o)<=h}return s?new S("stroke",this):i.base.apply(this,arguments)}}},{statics:new function(){function t(t,n,i,r,s){var a=new x(e.getNamed(s));return a._type=t,a._size=i,a._radius=r,a.translate(n)}return{Circle:function(){var n=h.readNamed(arguments,"center"),i=e.readNamed(arguments,"radius");return t("circle",n,new l(2*i),i,arguments)},Rectangle:function(){var e=d.readNamed(arguments,"rectangle"),n=l.min(l.readNamed(arguments,"radius"),e.getSize(!0).divide(2));return t("rectangle",e.getCenter(!0),e.getSize(!0),n,arguments)},Ellipse:function(){var e=x._readEllipse(arguments),n=e.radius;return t("ellipse",e.center,n.multiply(2),n,arguments)},_readEllipse:function(t){var n,i;if(e.hasNamed(t,"radius"))n=h.readNamed(t,"center"),i=l.readNamed(t,"radius");else{var r=d.readNamed(t,"rectangle");n=r.getCenter(!0),i=r.getSize(!0).divide(2)}return{center:n,radius:i}}}}}),b=m.extend({_class:"Raster",_applyMatrix:!1,_canApplyMatrix:!1,_boundsGetter:"getBounds",_boundsSelected:!0,_serializeFields:{crossOrigin:null,source:null},initialize:function(e,n){this._initialize(e,n!==t&&h.read(arguments,1))||("string"==typeof e?this.setSource(e):this.setImage(e)),this._size||(this._size=new l,this._loaded=!1)},_equals:function(t){return this.getSource()===t.getSource()},clone:function(t){var e=new b(m.NO_INSERT),n=this._image,i=this._canvas;if(n)e.setImage(n);else if(i){var r=Y.getCanvas(this._size);r.getContext("2d").drawImage(i,0,0),e.setImage(r)}return e._crossOrigin=this._crossOrigin,this._clone(e,t)},getSize:function(){var t=this._size;return new c(t?t.width:0,t?t.height:0,this,"setSize")},setSize:function(){var t=l.read(arguments);if(!t.equals(this._size))if(t.width>0&&t.height>0){var e=this.getElement();this.setImage(Y.getCanvas(t)),e&&this.getContext(!0).drawImage(e,0,0,t.width,t.height)}else this._canvas&&Y.release(this._canvas),this._size=t.clone()},getWidth:function(){return this._size?this._size.width:0},setWidth:function(t){this.setSize(t,this.getHeight())},getHeight:function(){return this._size?this._size.height:0},setHeight:function(t){this.setSize(this.getWidth(),t)},isEmpty:function(){var t=this._size;return!t||0===t.width&&0===t.height},getResolution:function(){var t=this._matrix,e=new h(0,0).transform(t),n=new h(1,0).transform(t).subtract(e),i=new h(0,1).transform(t).subtract(e);return new l(72/n.getLength(),72/i.getLength())},getPpi:"#getResolution",getImage:function(){return this._image},setImage:function(t){this._canvas&&Y.release(this._canvas),t&&t.getContext?(this._image=null,this._canvas=t,this._loaded=!0):(this._image=t,this._canvas=null,this._loaded=t&&t.complete),this._size=new l(t?t.naturalWidth||t.width:0,t?t.naturalHeight||t.height:0),this._context=null,this._changed(521)},getCanvas:function(){if(!this._canvas){var t=Y.getContext(this._size);try{this._image&&t.drawImage(this._image,0,0),this._canvas=t.canvas}catch(e){Y.release(t)}}return this._canvas},setCanvas:"#setImage",getContext:function(t){return this._context||(this._context=this.getCanvas().getContext("2d")),t&&(this._image=null,this._changed(513)),this._context},setContext:function(t){this._context=t},getSource:function(){return this._image&&this._image.src||this.toDataURL()},setSource:function(t){function e(){var t=i.getView();t&&(paper=t._scope,i.setImage(n),i.emit("load"),t.update())}var n,i=this,r=this._crossOrigin;n=document.getElementById(t)||new Image,r&&(n.crossOrigin=r),n.naturalWidth&&n.naturalHeight?setTimeout(e,0):(q.add(n,{load:e}),n.src||(n.src=t)),this.setImage(n)},getCrossOrigin:function(){return this._image&&this._image.crossOrigin||this._crossOrigin||""},setCrossOrigin:function(t){this._crossOrigin=t,this._image&&(this._image.crossOrigin=t)},getElement:function(){return this._canvas||this._loaded&&this._image}},{beans:!1,getSubCanvas:function(){var t=d.read(arguments),e=Y.getContext(t.getSize());return e.drawImage(this.getCanvas(),t.x,t.y,t.width,t.height,0,0,t.width,t.height),e.canvas},getSubRaster:function(){var t=d.read(arguments),e=new b(m.NO_INSERT);return e.setImage(this.getSubCanvas(t)),e.translate(t.getCenter().subtract(this.getSize().divide(2))),e._matrix.preConcatenate(this._matrix),e.insertAbove(this),e},toDataURL:function(){var t=this._image&&this._image.src;if(/^data:/.test(t))return t;var e=this.getCanvas();return e?e.toDataURL.apply(e,arguments):null},drawImage:function(t){var e=h.read(arguments,1);this.getContext(!0).drawImage(t,e.x,e.y)},getAverageColor:function(t){var n,i;t?t instanceof z?(i=t,n=t.getBounds()):t.width?n=new d(t):t.x&&(n=new d(t.x-.5,t.y-.5,1,1)):n=this.getBounds();var r=32,s=Math.min(n.width,r),a=Math.min(n.height,r),o=b._sampleContext;o?o.clearRect(0,0,r+1,r+1):o=b._sampleContext=Y.getContext(new l(r)),o.save();var h=(new g).scale(s/n.width,a/n.height).translate(-n.x,-n.y);h.applyToContext(o),i&&i.draw(o,new e({clip:!0,matrices:[h]})),this._matrix.applyToContext(o);var u=this.getElement(),c=this._size;u&&o.drawImage(u,-c.width/2,-c.height/2),o.restore();for(var f=o.getImageData(.5,.5,Math.ceil(s),Math.ceil(a)).data,_=[0,0,0],v=0,p=0,m=f.length;m>p;p+=4){var y=f[p+3];v+=y,y/=255,_[0]+=f[p]*y,_[1]+=f[p+1]*y,_[2]+=f[p+2]*y}for(var p=0;3>p;p++)_[p]/=v;return v?j.read(_):null},getPixel:function(){var t=h.read(arguments),e=this.getContext().getImageData(t.x,t.y,1,1).data;return new j("rgb",[e[0]/255,e[1]/255,e[2]/255],e[3]/255)},setPixel:function(){var t=h.read(arguments),e=j.read(arguments),n=e._convert("rgb"),i=e._alpha,r=this.getContext(!0),s=r.createImageData(1,1),a=s.data;a[0]=255*n[0],a[1]=255*n[1],a[2]=255*n[2],a[3]=null!=i?255*i:255,r.putImageData(s,t.x,t.y)},createImageData:function(){var t=l.read(arguments);return this.getContext().createImageData(t.width,t.height)},getImageData:function(){var t=d.read(arguments);return t.isEmpty()&&(t=new d(this._size)),this.getContext().getImageData(t.x,t.y,t.width,t.height)},setImageData:function(t){var e=h.read(arguments,1);this.getContext(!0).putImageData(t,e.x,e.y)},_getBounds:function(t,e){var n=new d(this._size).setCenter(0,0);return e?e._transformBounds(n):n},_hitTestSelf:function(t){if(this._contains(t)){var e=this;return new S("pixel",e,{offset:t.add(e._size.divide(2)).round(),color:{get:function(){return e.getPixel(this.offset)}}})}},_draw:function(t){var e=this.getElement();e&&(t.globalAlpha=this._opacity,t.drawImage(e,-this._size.width/2,-this._size.height/2))},_canComposite:function(){return!0}}),C=m.extend({_class:"PlacedSymbol",_applyMatrix:!1,_canApplyMatrix:!1,_boundsGetter:{getBounds:"getStrokeBounds"},_boundsSelected:!0,_serializeFields:{symbol:null},initialize:function(e,n){this._initialize(e,n!==t&&h.read(arguments,1))||this.setSymbol(e instanceof p?e:new p(e))},_equals:function(t){return this._symbol===t._symbol},getSymbol:function(){return this._symbol},setSymbol:function(t){this._symbol=t,this._changed(9)},clone:function(t){var e=new C(m.NO_INSERT);return e.setSymbol(this._symbol),this._clone(e,t)},isEmpty:function(){return this._symbol._definition.isEmpty()},_getBounds:function(t,e,n){var i=this.symbol._definition;return i._getCachedBounds(t,e&&e.chain(i._matrix),n)},_hitTestSelf:function(t,e){var n=this._symbol._definition._hitTest(t,e);return n&&(n.item=this),n},_draw:function(t,e){this.symbol._definition.draw(t,e)}}),S=e.extend({_class:"HitResult",initialize:function(t,e,n){this.type=t,this.item=e,n&&(n.enumerable=!0,this.inject(n))},statics:{getOptions:function(t){return new e({type:null,tolerance:paper.settings.hitTolerance,fill:!t,stroke:!t,segments:!t,handles:!1,ends:!1,center:!1,bounds:!1,guides:!1,selected:!1},t)}}}),P=e.extend({_class:"Segment",beans:!0,initialize:function(e,n,i,r,s,a){var o,h,u,l=arguments.length;0===l||(1===l?"point"in e?(o=e.point,h=e.handleIn,u=e.handleOut):o=e:2===l&&"number"==typeof e?o=arguments:3>=l?(o=e,h=n,u=i):(o=e!==t?[e,n]:null,h=i!==t?[i,r]:null,u=s!==t?[s,a]:null)),new k(o,this,"_point"),new k(h,this,"_handleIn"),new k(u,this,"_handleOut")},_serialize:function(t){return e.serialize(this.hasHandles()?[this._point,this._handleIn,this._handleOut]:this._point,t,!0)},_changed:function(t){var e=this._path;if(e){var n,i=e._curves,r=this._index;i&&(t&&t!==this._point&&t!==this._handleIn||!(n=r>0?i[r-1]:e._closed?i[i.length-1]:null)||n._changed(),t&&t!==this._point&&t!==this._handleOut||!(n=i[r])||n._changed()),e._changed(25)}},getPoint:function(){return this._point},setPoint:function(){var t=h.read(arguments);this._point.set(t.x,t.y)},getHandleIn:function(){return this._handleIn},setHandleIn:function(){var t=h.read(arguments);this._handleIn.set(t.x,t.y)},getHandleOut:function(){return this._handleOut},setHandleOut:function(){var t=h.read(arguments);this._handleOut.set(t.x,t.y)},hasHandles:function(){return!this._handleIn.isZero()||!this._handleOut.isZero()},clearHandles:function(){this._handleIn.set(0,0),this._handleOut.set(0,0)},_selectionState:0,isSelected:function(t){var e=this._selectionState;return t?t===this._point?!!(4&e):t===this._handleIn?!!(1&e):t===this._handleOut?!!(2&e):!1:!!(7&e)},setSelected:function(t,e){var n=this._path,t=!!t,i=this._selectionState,r=i,s=e?e===this._point?4:e===this._handleIn?1:e===this._handleOut?2:0:7;t?i|=s:i&=~s,this._selectionState=i,n&&i!==r&&(n._updateSelection(this,r,i),n._changed(129))},getIndex:function(){return this._index!==t?this._index:null},getPath:function(){return this._path||null},getCurve:function(){var t=this._path,e=this._index;return t?(e>0&&!t._closed&&e===t._segments.length-1&&e--,t.getCurves()[e]||null):null},getLocation:function(){var t=this.getCurve();return t?new M(t,this===t._segment1?0:1):null},getNext:function(){var t=this._path&&this._path._segments;return t&&(t[this._index+1]||this._path._closed&&t[0])||null},getPrevious:function(){var t=this._path&&this._path._segments;return t&&(t[this._index-1]||this._path._closed&&t[t.length-1])||null},isFirst:function(){return 0===this._index},isLast:function(){var t=this._path;return t&&this._index===t._segments.length-1||!1},reverse:function(){var t=this._handleIn,e=this._handleOut,n=t._x,i=t._y;t.set(e._x,e._y),e.set(n,i)},reversed:function(){return new P(this._point,this._handleOut,this._handleIn)},remove:function(){return this._path?!!this._path.removeSegment(this._index):!1},clone:function(){return new P(this._point,this._handleIn,this._handleOut)},equals:function(t){return t===this||t&&this._class===t._class&&this._point.equals(t._point)&&this._handleIn.equals(t._handleIn)&&this._handleOut.equals(t._handleOut)||!1},toString:function(){var t=["point: "+this._point];return this._handleIn.isZero()||t.push("handleIn: "+this._handleIn),this._handleOut.isZero()||t.push("handleOut: "+this._handleOut),"{ "+t.join(", ")+" }"},transform:function(t){this._transformCoordinates(t,Array(6),!0),this._changed()},_transformCoordinates:function(t,e,n){var i=this._point,r=n&&this._handleIn.isZero()?null:this._handleIn,s=n&&this._handleOut.isZero()?null:this._handleOut,a=i._x,o=i._y,h=2;return e[0]=a,e[1]=o,r&&(e[h++]=r._x+a,e[h++]=r._y+o),s&&(e[h++]=s._x+a,e[h++]=s._y+o),t&&(t._transformCoordinates(e,e,h/2),a=e[0],o=e[1],n?(i._x=a,i._y=o,h=2,r&&(r._x=e[h++]-a,r._y=e[h++]-o),s&&(s._x=e[h++]-a,s._y=e[h++]-o)):(r||(e[h++]=a,e[h++]=o),s||(e[h++]=a,e[h++]=o))),e}}),k=h.extend({initialize:function(e,n,i){var r,s,a;if(e)if((r=e[0])!==t)s=e[1];else{var o=e;(r=o.x)===t&&(o=h.read(arguments),r=o.x),s=o.y,a=o.selected}else r=s=0;this._x=r,this._y=s,this._owner=n,n[i]=this,a&&this.setSelected(!0)},set:function(t,e){return this._x=t,this._y=e,this._owner._changed(this),this},_serialize:function(t){var e=t.formatter,n=e.number(this._x),i=e.number(this._y);return this.isSelected()?{x:n,y:i,selected:!0}:[n,i]},getX:function(){return this._x},setX:function(t){this._x=t,this._owner._changed(this)},getY:function(){return this._y},setY:function(t){this._y=t,this._owner._changed(this)},isZero:function(){return a.isZero(this._x)&&a.isZero(this._y)},setSelected:function(t){this._owner.setSelected(t,this)},isSelected:function(){return this._owner.isSelected(this)}}),I=e.extend({_class:"Curve",initialize:function(t,e,n,i,r,s,a,o){var h,u,l,c,d,f,g=arguments.length;3===g?(this._path=t,h=e,u=n):0===g?(h=new P,u=new P):1===g?"segment1"in t?(h=new P(t.segment1),u=new P(t.segment2)):"point1"in t?(l=t.point1,d=t.handle1,f=t.handle2,c=t.point2):Array.isArray(t)&&(l=[t[0],t[1]],c=[t[6],t[7]],d=[t[2]-t[0],t[3]-t[1]],f=[t[4]-t[6],t[5]-t[7]]):2===g?(h=new P(t),u=new P(e)):4===g?(l=t,d=e,f=n,c=i):8===g&&(l=[t,e],c=[a,o],d=[n-t,i-e],f=[r-a,s-o]),this._segment1=h||new P(l,null,d),this._segment2=u||new P(c,f,null)},_serialize:function(t){return e.serialize(this.hasHandles()?[this.getPoint1(),this.getHandle1(),this.getHandle2(),this.getPoint2()]:[this.getPoint1(),this.getPoint2()],t,!0)},_changed:function(){this._length=this._bounds=t},clone:function(){return new I(this._segment1,this._segment2)},toString:function(){var t=["point1: "+this._segment1._point];return this._segment1._handleOut.isZero()||t.push("handle1: "+this._segment1._handleOut),this._segment2._handleIn.isZero()||t.push("handle2: "+this._segment2._handleIn),t.push("point2: "+this._segment2._point),"{ "+t.join(", ")+" }"},remove:function(){var t=!1;if(this._path){var e=this._segment2,n=e._handleOut;t=e.remove(),t&&this._segment1._handleOut.set(n.x,n.y)}return t},getPoint1:function(){return this._segment1._point},setPoint1:function(){var t=h.read(arguments);this._segment1._point.set(t.x,t.y)},getPoint2:function(){return this._segment2._point},setPoint2:function(){var t=h.read(arguments);this._segment2._point.set(t.x,t.y)},getHandle1:function(){return this._segment1._handleOut},setHandle1:function(){var t=h.read(arguments);this._segment1._handleOut.set(t.x,t.y)},getHandle2:function(){return this._segment2._handleIn},setHandle2:function(){var t=h.read(arguments);this._segment2._handleIn.set(t.x,t.y)},getSegment1:function(){return this._segment1},getSegment2:function(){return this._segment2},getPath:function(){return this._path},getIndex:function(){return this._segment1._index},getNext:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index+1]||this._path._closed&&t[0])||null},getPrevious:function(){var t=this._path&&this._path._curves;return t&&(t[this._segment1._index-1]||this._path._closed&&t[t.length-1])||null},isFirst:function(){return 0===this._segment1._index},isLast:function(){var t=this._path;return t&&this._segment1._index===t._curves.length-1||!1},isSelected:function(){return this.getPoint1().isSelected()&&this.getHandle2().isSelected()&&this.getHandle2().isSelected()&&this.getPoint2().isSelected()},setSelected:function(t){this.getPoint1().setSelected(t),this.getHandle1().setSelected(t),this.getHandle2().setSelected(t),this.getPoint2().setSelected(t)},getValues:function(t){return I.getValues(this._segment1,this._segment2,t)},getPoints:function(){for(var t=this.getValues(),e=[],n=0;8>n;n+=2)e.push(new h(t[n],t[n+1]));return e},getLength:function(){return null==this._length&&(this._length=I.getLength(this.getValues(),0,1)),this._length},getArea:function(){return I.getArea(this.getValues())},getLine:function(){return new _(this._segment1._point,this._segment2._point)},getPart:function(t,e){return new I(I.getPart(this.getValues(),t,e))},getPartLength:function(t,e){return I.getLength(this.getValues(),t,e)},getIntersections:function(t){return I._getIntersections(this.getValues(),t&&t!==this?t.getValues():null,this,t,[],{})},_getParameter:function(e,n){return n?e:e&&e.curve===this?e.parameter:e===t&&n===t?.5:this.getParameterAt(e,0)},divide:function(t,e,n){var i=this._getParameter(t,e),r=4e-7,s=1-r,a=null;if(i>=r&&s>=i){var o=I.subdivide(this.getValues(),i),u=o[0],l=o[1],c=n||this.hasHandles(),d=this._segment1,f=this._segment2,g=this._path;c&&(d._handleOut.set(u[2]-u[0],u[3]-u[1]),f._handleIn.set(l[4]-l[6],l[5]-l[7]));var _=u[6],v=u[7],p=new P(new h(_,v),c&&new h(u[4]-_,u[5]-v),c&&new h(l[2]-_,l[3]-v));g?(g.insert(d._index+1,p),a=this.getNext()):(this._segment2=p,a=new I(p,f))}return a},split:function(t,e){return this._path?this._path.split(this._segment1._index,this._getParameter(t,e)):null},reversed:function(){return new I(this._segment2.reversed(),this._segment1.reversed())},clearHandles:function(){this._segment1._handleOut.set(0,0),this._segment2._handleIn.set(0,0)},statics:{getValues:function(t,e,n){var i=t._point,r=t._handleOut,s=e._handleIn,a=e._point,o=[i._x,i._y,i._x+r._x,i._y+r._y,a._x+s._x,a._y+s._y,a._x,a._y];return n&&n._transformCoordinates(o,o,4),o},subdivide:function(e,n){var i=e[0],r=e[1],s=e[2],a=e[3],o=e[4],h=e[5],u=e[6],l=e[7];n===t&&(n=.5);var c=1-n,d=c*i+n*s,f=c*r+n*a,g=c*s+n*o,_=c*a+n*h,v=c*o+n*u,p=c*h+n*l,m=c*d+n*g,y=c*f+n*_,w=c*g+n*v,x=c*_+n*p,b=c*m+n*w,C=c*y+n*x;return[[i,r,d,f,m,y,b,C],[b,C,w,x,v,p,u,l]]},solveCubic:function(t,e,n,i,r,s){var o=t[e],h=t[e+2],u=t[e+4],l=t[e+6],c=3*(h-o),d=3*(u-h)-c,f=l-o-c-d;return a.solveCubic(f,d,c,o-n,i,r,s)},getParameterOf:function(t,e){var n=new h(t[0],t[1]),i=new h(t[6],t[7]),r=1e-12,s=e.isClose(n,r)?0:e.isClose(i,r)?1:null;if(null!==s)return s;for(var a=[e.x,e.y],o=[],u=2e-7,l=0;2>l;l++)for(var c=I.solveCubic(t,l,a[l],o,0,1),d=0;c>d;d++)if(s=o[d],e.isClose(I.getPoint(t,s),u))return s;return e.isClose(n,u)?0:e.isClose(i,u)?1:null},getNearestParameter:function(t,e){function n(n){if(n>=0&&1>=n){var i=e.getDistance(I.getPoint(t,n),!0);if(f>i)return f=i,g=n,!0}}if(I.isStraight(t)){var i=t[0],r=t[1],s=t[6],a=t[7],o=s-i,u=a-r,l=o*o+u*u;if(0===l)return 0;var c=((e.x-i)*o+(e.y-r)*u)/l;return 1e-12>c?0:c>.999999999999?1:I.getParameterOf(t,new h(i+c*o,r+c*u))}for(var d=100,f=1/0,g=0,_=0;d>=_;_++)n(_/d);for(var v=1/(2*d);v>4e-7;)n(g-v)||n(g+v)||(v/=2);return g},getPart:function(t,e,n){var i=e>n;if(i){var r=e;e=n,n=r}return e>0&&(t=I.subdivide(t,e)[1]),1>n&&(t=I.subdivide(t,(n-e)/(1-e))[0]),i?[t[6],t[7],t[4],t[5],t[2],t[3],t[0],t[1]]:t},hasHandles:function(t){var e=a.isZero;return!(e(t[0]-t[2])&&e(t[1]-t[3])&&e(t[4]-t[6])&&e(t[5]-t[7]))},isFlatEnough:function(t,e){var n=t[0],i=t[1],r=t[2],s=t[3],a=t[4],o=t[5],h=t[6],u=t[7],l=3*r-2*n-h,c=3*s-2*i-u,d=3*a-2*h-n,f=3*o-2*u-i;return Math.max(l*l,d*d)+Math.max(c*c,f*f)<10*e*e},getArea:function(t){var e=t[0],n=t[1],i=t[6],r=t[7],s=(t[2]+e)/2,a=(t[3]+n)/2,o=(t[4]+t[6])/2,h=(t[5]+t[7])/2;return 6*((e-s)*(a+n)+(s-o)*(h+a)+(o-i)*(r+h))/10},getBounds:function(t){for(var e=t.slice(0,2),n=e.slice(),i=[0,0],r=0;2>r;r++)I._addBounds(t[r],t[r+2],t[r+4],t[r+6],r,0,e,n,i);return new d(e[0],e[1],n[0]-e[0],n[1]-e[1])},_addBounds:function(t,e,n,i,r,s,o,h,u){function l(t,e){var n=t-e,i=t+e;n<o[r]&&(o[r]=n),i>h[r]&&(h[r]=i)}var c=3*(e-n)-t+i,d=2*(t+n)-4*e,f=e-t,g=a.solveQuadratic(c,d,f,u),_=4e-7,v=1-_;l(i,0);for(var p=0;g>p;p++){var m=u[p],y=1-m;m>_&&v>m&&l(y*y*y*t+3*y*y*m*e+3*y*m*m*n+m*m*m*i,s)}}}},e.each(["getBounds","getStrokeBounds","getHandleBounds","getRoughBounds"],function(t){this[t]=function(){this._bounds||(this._bounds={});var e=this._bounds[t];if(!e){var n=this._path;e=this._bounds[t]=A[t]([this._segment1,this._segment2],!1,n&&n.getStyle())}return e.clone()}},{}),e.each({isStraight:function(t,e,n){if(e.isZero()&&n.isZero())return!0;if(t.isZero())return!1;if(e.isCollinear(t)&&n.isCollinear(t)){var i=t.dot(t),r=t.dot(e)/i,s=t.dot(n)/i;return r>=0&&1>=r&&0>=s&&s>=-1}return!1},isLinear:function(t,e,n){var i=t.divide(3);return e.equals(i)&&n.negate().equals(i)}},function(t,e){this[e]=function(){var e=this._segment1,n=this._segment2;return t(n._point.subtract(e._point),e._handleOut,n._handleIn)},this.statics[e]=function(e){var n=e[0],i=e[1],r=e[6],s=e[7];return t(new h(r-n,s-i),new h(e[2]-n,e[3]-i),new h(e[4]-r,e[5]-s))}},{statics:{},hasHandles:function(){return!this._segment1._handleOut.isZero()||!this._segment2._handleIn.isZero()},isCollinear:function(t){return t&&this.isStraight()&&t.isStraight()&&this.getLine().isCollinear(t.getLine())},isHorizontal:function(){return this.isStraight()&&Math.abs(this.getTangentAt(.5,!0).y)<1e-7},isVertical:function(){return this.isStraight()&&Math.abs(this.getTangentAt(.5,!0).x)<1e-7}}),{beans:!1,getParameterAt:function(t,e){return I.getParameterAt(this.getValues(),t,e)},getParameterOf:function(){return I.getParameterOf(this.getValues(),h.read(arguments))},getLocationAt:function(t,e){var n=e?t:this.getParameterAt(t);return null!=n&&n>=0&&1>=n?new M(this,n):null},getLocationOf:function(){return this.getLocationAt(this.getParameterOf(h.read(arguments)),!0)},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getNearestLocation:function(){var t=h.read(arguments),e=this.getValues(),n=I.getNearestParameter(e,t),i=I.getPoint(e,n);return new M(this,n,i,null,t.getDistance(i))},getNearestPoint:function(){return this.getNearestLocation.apply(this,arguments).getPoint()}},new function(){var t=["getPoint","getTangent","getNormal","getWeightedTangent","getWeightedNormal","getCurvature"];return e.each(t,function(t){this[t+"At"]=function(e,n){var i=this.getValues();return I[t](i,n?e:I.getParameterAt(i,e,0))}},{statics:{evaluateMethods:t}})},new function(){function e(t){var e=t[0],n=t[1],i=t[2],r=t[3],s=t[4],a=t[5],o=t[6],h=t[7],u=9*(i-s)+3*(o-e),l=6*(e+s)-12*i,c=3*(i-e),d=9*(r-a)+3*(h-n),f=6*(n+a)-12*r,g=3*(r-n);return function(t){var e=(u*t+l)*t+c,n=(d*t+f)*t+g;return Math.sqrt(e*e+n*n)}}function n(t,e){return Math.max(2,Math.min(16,Math.ceil(32*Math.abs(e-t))))}function i(t,e,n,i){if(null==e||0>e||e>1)return null;var r,s,a=t[0],o=t[1],u=t[2],l=t[3],c=t[4],d=t[5],f=t[6],g=t[7],_=4e-7,v=1-_;if(0===n&&(_>e||e>v)){var p=_>e;r=p?a:f,s=p?o:g}else{var m=3*(u-a),y=3*(c-u)-m,w=f-a-m-y,x=3*(l-o),b=3*(d-l)-x,C=g-o-x-b;if(0===n)r=((w*e+y)*e+m)*e+a,s=((C*e+b)*e+x)*e+o;else{if(_>e?(r=m,s=x):e>v?(r=3*(f-c),s=3*(g-d)):(r=(3*w*e+2*y)*e+m,s=(3*C*e+2*b)*e+x),i){0===r&&0===s&&(_>e||e>v)&&(r=c-u,s=d-l);var S=Math.sqrt(r*r+s*s);S&&(r/=S,s/=S)}if(3===n){var P=6*w*e+2*y,k=6*C*e+2*b,I=Math.pow(r*r+s*s,1.5);r=0!==I?(r*k-s*P)/I:0,s=0}}}return 2===n?new h(s,-r):new h(r,s)}return{statics:{getLength:function(i,r,s){if(r===t&&(r=0),s===t&&(s=1),0===r&&1===s&&I.isStraight(i)){var o=i[6]-i[0],h=i[7]-i[1];return Math.sqrt(o*o+h*h)}var u=e(i);return a.integrate(u,r,s,n(r,s))},getParameterAt:function(i,r,s){function o(t){return _+=a.integrate(d,s,t,n(s,t)),s=t,_-r}if(s===t&&(s=0>r?1:0),0===r)return s;var h=Math.abs,u=r>0,l=u?s:0,c=u?1:s,d=e(i),f=a.integrate(d,l,c,n(l,c));if(h(r-f)<1e-12)return u?c:l;if(h(r)>f)return null;var g=r/f,_=0;return a.findRoot(o,d,s+g,l,c,32,1e-12)},getPoint:function(t,e){return i(t,e,0,!1)},getTangent:function(t,e){return i(t,e,1,!0)},getWeightedTangent:function(t,e){return i(t,e,1,!1)},getNormal:function(t,e){return i(t,e,2,!0)},getWeightedNormal:function(t,e){return i(t,e,2,!1)},getCurvature:function(t,e){return i(t,e,3,!1).x}}}},new function(){function t(t,e,n,i,r,s,a,o,h,u,l){var c=e.startConnected,d=e.endConnected,f=4e-7,g=1-f;if(null==r&&(r=I.getParameterOf(n,s)),null!==r&&r>=(c?f:0)&&(d?g:1)>=r&&(null==h&&(h=I.getParameterOf(a,u)),null!==h&&h>=(d?f:0)&&(c?g:1)>=h)){var _=e.renormalize;if(_){var v=_(r,h);r=v[0],h=v[1]}var p=new M(i,r,s||I.getPoint(n,r),l),m=new M(o,h,u||I.getPoint(a,h),l),y=p.getPath()===m.getPath()&&p.getIndex()>m.getIndex(),w=y?m:p,x=e.include;p._intersection=m,m._intersection=p,(!x||x(w))&&M.insert(t,w,!0)}}function e(r,s,a,o,h,u,l,c,d,f,g,v,p){if(!(++p>=24)){var m,y,w=s[0],x=s[1],b=s[6],C=s[7],S=_.getSignedDistance,P=S(w,x,b,C,s[2],s[3]),k=S(w,x,b,C,s[4],s[5]),M=P*k>0?.75:4/9,z=M*Math.min(0,P,k),A=M*Math.max(0,P,k),O=S(w,x,b,C,r[0],r[1]),T=S(w,x,b,C,r[2],r[3]),E=S(w,x,b,C,r[4],r[5]),L=S(w,x,b,C,r[6],r[7]),N=n(O,T,E,L),j=N[0],B=N[1];if(null!=(m=i(j,B,z,A))&&null!=(y=i(j.reverse(),B.reverse(),z,A))){r=I.getPart(r,m,y);var R=y-m,D=l+(c-l)*m,F=l+(c-l)*y;if(g>.5&&R>.5)if(F-D>f-d){var q=I.subdivide(r,.5),V=D+(F-D)/2;e(s,q[0],o,a,h,u,d,f,D,V,R,!v,p),e(s,q[1],o,a,h,u,d,f,V,F,R,!v,p)}else{var q=I.subdivide(s,.5),V=d+(f-d)/2;e(q[0],r,o,a,h,u,d,V,D,F,R,!v,p),e(q[1],r,o,a,h,u,V,f,D,F,R,!v,p)}else if(Math.max(f-d,F-D)<1e-7){var H=D+(F-D)/2,Z=d+(f-d)/2;r=a.getValues(),s=o.getValues(),t(h,u,v?s:r,v?o:a,v?Z:H,null,v?r:s,v?a:o,v?H:Z,null)}else R>1e-12&&e(s,r,o,a,h,u,d,f,D,F,R,!v,p)}}}function n(t,e,n,i){var r,s=[0,t],a=[1/3,e],o=[2/3,n],h=[1,i],u=e-(2*t+i)/3,l=n-(t+2*i)/3;if(0>u*l)r=[[s,a,h],[s,o,h]];else{var c=u/l;r=[c>=2?[s,a,h]:.5>=c?[s,o,h]:[s,a,o,h],[s,h]]}return 0>(u||l)?r.reverse():r}function i(t,e,n,i){return t[0][1]<n?r(t,!0,n):e[0][1]>i?r(e,!1,i):t[0][0]}function r(t,e,n){for(var i=t[0][0],r=t[0][1],s=1,a=t.length;a>s;s++){var o=t[s][0],h=t[s][1];if(e?h>=n:n>=h)return h===n?o:i+(n-r)*(o-i)/(h-r);i=o,r=h}return null}function s(e,n,i,r,s,o){for(var h=I.isStraight(e),u=h?n:e,l=h?e:n,c=l[0],d=l[1],f=l[6],g=l[7],_=f-c,v=g-d,p=Math.atan2(-v,_),m=Math.sin(p),y=Math.cos(p),w=[],x=0;8>x;x+=2){var b=u[x]-c,C=u[x+1]-d;w.push(b*y-C*m,b*m+C*y)}for(var S=[],P=I.solveCubic(w,1,0,S,0,1),x=0;P>x;x++){var k=S[x],M=I.getPoint(u,k),z=I.getParameterOf(l,M);if(null!==z){var A=I.getPoint(l,z),O=h?z:k,T=h?k:z;(!o.endConnected||T>a.CURVETIME_EPSILON)&&t(s,o,e,i,O,h?A:M,n,r,T,h?M:A)}}}function o(e,n,i,r,s,a){var o=_.intersect(e[0],e[1],e[6],e[7],n[0],n[1],n[6],n[7]);o&&t(s,a,e,i,null,o,n,r,null,o)}return{statics:{_getIntersections:function(n,i,r,a,u,l){if(!i)return I._getSelfIntersection(n,r,u,l);var c=n[0],d=n[1],f=n[6],g=n[7],_=i[0],v=i[1],p=i[6],m=i[7],y=(3*n[2]+c)/4,w=(3*n[3]+d)/4,x=(3*n[4]+f)/4,b=(3*n[5]+g)/4,C=(3*i[2]+_)/4,S=(3*i[3]+v)/4,P=(3*i[4]+p)/4,k=(3*i[5]+m)/4,M=Math.min,z=Math.max;if(!(z(c,y,x,f)>=M(_,C,P,p)&&M(c,y,x,f)<=z(_,C,P,p)&&z(d,w,b,g)>=M(v,S,k,m)&&M(d,w,b,g)<=z(v,S,k,m)))return u;if(!l.startConnected&&!l.endConnected){var A=I.getOverlaps(n,i);if(A){for(var O=0;2>O;O++){var T=A[O];t(u,l,n,r,T[0],null,i,a,T[1],null,!0)}return u}}var E=I.isStraight(n),L=I.isStraight(i),N=E&&L,j=1e-12,B=u.length;if((N?o:E||L?s:e)(n,i,r,a,u,l,0,1,0,1,0,!1,0),N&&u.length>B)return u;var R=new h(c,d),D=new h(f,g),F=new h(_,v),q=new h(p,m);return R.isClose(F,j)&&t(u,l,n,r,0,R,i,a,0,F),!l.startConnected&&R.isClose(q,j)&&t(u,l,n,r,0,R,i,a,1,q),!l.endConnected&&D.isClose(F,j)&&t(u,l,n,r,1,D,i,a,0,F),D.isClose(q,j)&&t(u,l,n,r,1,D,i,a,1,q),u},_getSelfIntersection:function(t,e,n,i){var r=t[0],s=t[1],o=t[2],u=t[3],l=t[4],c=t[5],d=t[6],f=t[7],g=new _(r,s,d,f,!1),v=g.getSide(new h(o,u),!0),p=g.getSide(new h(l,c),!0);if(v===p){var m=(r-l)*(u-f)+(o-d)*(c-s);if(m*v>0)return n}var y=d-3*l+3*o-r,w=l-2*o+r,x=o-r,b=f-3*c+3*u-s,C=c-2*u+s,S=u-s,P=b*x-y*S,k=b*w-y*C,M=C*x-w*S;if(0>P*P-4*k*M){var z,A=[],O=a.solveCubic(y*y+b*b,3*(y*w+b*C),2*(w*w+C*C)+y*x+b*S,w*x+C*S,A,0,1);if(O>0){for(var T=0,E=0;O>T;T++){var L=Math.abs(e.getCurvatureAt(A[T],!0));L>E&&(E=L,z=A[T])}var N=I.subdivide(t,z);i.endConnected=!0,i.renormalize=function(t,e){return[t*z,e*(1-z)+z]},I._getIntersections(N[0],N[1],e,e,n,i)}}return n},getOverlaps:function(t,e){function n(t){var e=t[6]-t[0],n=t[7]-t[1];return e*e+n*n}var i=Math.abs,r=4e-7,s=2e-7,a=I.isStraight(t),o=I.isStraight(e),u=a&&o;if(u){var l=n(t)<n(e),c=l?e:t,d=l?t:e,f=new _(c[0],c[1],c[6],c[7]);if(f.getDistance(new h(d[0],d[1]))>s||f.getDistance(new h(d[6],d[7]))>s)return null}else if(a^o)return null;for(var g=[t,e],v=[],p=0,m=0;2>p&&v.length<2;p+=0===m?0:1,m=1^m){var y=I.getParameterOf(g[1^p],new h(g[p][0===m?0:6],g[p][0===m?1:7]));if(null!=y){var w=0===p?[m,y]:[y,m];(0===v.length||i(w[0]-v[0][0])>r&&i(w[1]-v[0][1])>r)&&v.push(w)}if(1===p&&0===v.length)break}if(2!==v.length)v=null;else if(!u){var x=I.getPart(t,v[0][0],v[1][0]),b=I.getPart(e,v[0][1],v[1][1]);(i(b[2]-x[2])>s||i(b[3]-x[3])>s||i(b[4]-x[4])>s||i(b[5]-x[5])>s)&&(v=null)}return v}}}}),M=e.extend({_class:"CurveLocation",beans:!0,initialize:function _t(t,e,n,i,r){if(e>.9999996){var s=t.getNext();s&&(e=0,t=s)}this._id=o.get(_t),this._setCurve(t),this._parameter=e,this._point=n||t.getPointAt(e,!0),this._overlap=i,this._distance=r,this._intersection=this._next=this._prev=null},_setCurve:function(t){var e=t._path;
this._version=e?e._version:0,this._curve=t,this._segment=null,this._segment1=t._segment1,this._segment2=t._segment2},_setSegment:function(t){this._setCurve(t.getCurve()),this._segment=t,this._parameter=t===this._segment1?0:1,this._point=t._point.clone()},getSegment:function(){var t=this.getCurve(),e=this._segment;if(!e){var n=this.getParameter();0===n?e=t._segment1:1===n?e=t._segment2:null!=n&&(e=t.getPartLength(0,n)<t.getPartLength(n,1)?t._segment1:t._segment2),this._segment=e}return e},getCurve:function(){function e(e){var n=e&&e.getCurve();return n&&null!=(r._parameter=n.getParameterOf(r._point))?(r._setCurve(n),r._segment=e,n):t}var n=this._curve,i=n&&n._path,r=this;return i&&i._version!==this._version&&(n=this._parameter=this._curve=this._offset=null),n||e(this._segment)||e(this._segment1)||e(this._segment2.getPrevious())},getPath:function(){var t=this.getCurve();return t&&t._path},getIndex:function(){var t=this.getCurve();return t&&t.getIndex()},getParameter:function(){var t=this.getCurve(),e=this._parameter;return t&&null==e?this._parameter=t.getParameterOf(this._point):e},getPoint:function(){return this._point},getOffset:function(){var t=this._offset;if(null==t){t=0;var e=this.getPath(),n=this.getIndex();if(e&&null!=n)for(var i=e.getCurves(),r=0;n>r;r++)t+=i[r].getLength();this._offset=t+=this.getCurveOffset()}return t},getCurveOffset:function(){var t=this.getCurve(),e=this.getParameter();return null!=e&&t&&t.getPartLength(0,e)},getIntersection:function(){return this._intersection},getDistance:function(){return this._distance},divide:function(){var t=this.getCurve(),e=null;return t&&(e=t.divide(this.getParameter(),!0),e&&this._setSegment(e._segment1)),e},split:function(){var t=this.getCurve();return t?t.split(this.getParameter(),!0):null},equals:function(t,e){var n=this===t,i=2e-7;if(!n&&t instanceof M&&this.getPath()===t.getPath()&&this.getPoint().isClose(t.getPoint(),i)){var r=this.getCurve(),s=t.getCurve(),a=Math.abs,o=a((r.isLast()&&s.isFirst()?-1:r.getIndex())+this.getParameter()-((s.isLast()&&r.isFirst()?-1:s.getIndex())+t.getParameter()));n=(4e-7>o||(o=a(this.getOffset()-t.getOffset()))<i||a(this.getPath().getLength()-o)<i)&&(e||!this._intersection&&!t._intersection||this._intersection&&this._intersection.equals(t._intersection,!0))}return n},toString:function(){var t=[],e=this.getPoint(),n=s.instance;e&&t.push("point: "+e);var i=this.getIndex();null!=i&&t.push("index: "+i);var r=this.getParameter();return null!=r&&t.push("parameter: "+n.number(r)),null!=this._distance&&t.push("distance: "+n.number(this._distance)),"{ "+t.join(", ")+" }"},isTouching:function(){var t=this._intersection;if(t&&this.getTangent().isCollinear(t.getTangent())){var e=this.getCurve(),n=t.getCurve();return!(e.isStraight()&&n.isStraight()&&e.getLine().intersect(n.getLine()))}return!1},isCrossing:function(){function t(t,e,n){return n>e?t>e&&n>t:t>e&&l>=t||t>=-l&&n>t}var e=this._intersection;if(!e)return!1;var n=this.getParameter(),i=e.getParameter(),r=4e-7,s=1-r;if(n>=r&&s>=n||i>=r&&s>=i)return!this.isTouching();var a=this.getCurve(),o=a.getPrevious(),h=e.getCurve(),u=h.getPrevious(),l=Math.PI;if(!o||!u)return!1;var c=o.getTangentAt(s,!0).negate().getAngleInRadians(),d=a.getTangentAt(r,!0).getAngleInRadians(),f=u.getTangentAt(s,!0).negate().getAngleInRadians(),g=h.getTangentAt(r,!0).getAngleInRadians();return t(f,c,d)^t(g,c,d)&&t(f,d,c)^t(g,d,c)},isOverlap:function(){return!!this._overlap}},e.each(I.evaluateMethods,function(t){var e=t+"At";this[t]=function(){var t=this.getParameter(),n=this.getCurve();return null!=t&&n&&n[e](t,!0)}},{preserve:!0}),new function(){function t(t,e,n){function i(n,i){for(var s=n+i;s>=-1&&r>=s;s+=i){var a=t[(s%r+r)%r];if(!e.getPoint().isClose(a.getPoint(),2e-7))break;if(e.equals(a))return a}return null}for(var r=t.length,s=0,a=r-1;a>=s;){var o,h=s+a>>>1,u=t[h];if(n&&(o=e.equals(u)?u:i(h,-1)||i(h,1)))return e._overlap&&(o._overlap=o._intersection._overlap=!0),o;var l=e.getPath(),c=u.getPath(),d=l===c?e.getIndex()+e.getParameter()-(u.getIndex()+u.getParameter()):l._id-c._id;0>d?a=h-1:s=h+1}return t.splice(s,0,e),e}return{statics:{insert:t,expand:function(e){for(var n=e.slice(),i=0,r=e.length;r>i;i++)t(n,e[i]._intersection,!1);return n}}}}),z=m.extend({_class:"PathItem",initialize:function(){},getIntersections:function(t,e,n,i){var r=this===t||!t,s=this._matrix.orNullIfIdentity(),a=r?s:(n||t._matrix).orNullIfIdentity();if(!r&&!this.getBounds(s).touches(t.getBounds(a)))return[];for(var o,t,h=this.getCurves(),u=r?h:t.getCurves(),l=h.length,c=r?l:u.length,d=[],f=[],g=0;c>g;g++)d[g]=u[g].getValues(a);for(var g=0;l>g;g++){var _=h[g],v=r?d[g]:_.getValues(s),p=_.getPath();p!==t&&(t=p,o=[],f.push(o)),r&&I._getSelfIntersection(v,_,o,{include:e,startConnected:1===l&&_.getPoint1().equals(_.getPoint2())});for(var m=r?g+1:0;c>m;m++){if(i&&o.length)return o;var y=u[m];I._getIntersections(v,d[m],_,y,o,{include:e,startConnected:r&&_.getPrevious()===y,endConnected:r&&_.getNext()===y})}}o=[];for(var g=0,w=f.length;w>g;g++)o.push.apply(o,f[g]);return o},getCrossings:function(t){return this.getIntersections(t,function(t){return t.isCrossing()})},_asPathItem:function(){return this},setPathData:function(t){function e(t,e){var n=+i[t];return o&&(n+=u[e]),n}function n(t){return new h(e(t,"x"),e(t+1,"y"))}var i,r,s,a=t.match(/[mlhvcsqtaz][^mlhvcsqtaz]*/gi),o=!1,u=new h,c=new h;this.clear();for(var d=0,f=a&&a.length;f>d;d++){var g=a[d],_=g[0],v=_.toLowerCase();i=g.match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g);var p=i&&i.length;switch(o=_===v,"z"!==r||/[mz]/.test(v)||this.moveTo(u=c),v){case"m":case"l":for(var m="m"===v,y=0;p>y;y+=2)this[0===y&&m?"moveTo":"lineTo"](u=n(y));s=u,m&&(c=u);break;case"h":case"v":for(var w="h"===v?"x":"y",y=0;p>y;y++)u[w]=e(y,w),this.lineTo(u);s=u;break;case"c":for(var y=0;p>y;y+=6)this.cubicCurveTo(n(y),s=n(y+2),u=n(y+4));break;case"s":for(var y=0;p>y;y+=4)this.cubicCurveTo(/[cs]/.test(r)?u.multiply(2).subtract(s):u,s=n(y),u=n(y+2)),r=v;break;case"q":for(var y=0;p>y;y+=4)this.quadraticCurveTo(s=n(y),u=n(y+2));break;case"t":for(var y=0;p>y;y+=2)this.quadraticCurveTo(s=/[qt]/.test(r)?u.multiply(2).subtract(s):u,u=n(y)),r=v;break;case"a":for(var y=0;p>y;y+=7)this.arcTo(u=n(y+5),new l(+i[y],+i[y+1]),+i[y+2],+i[y+4],+i[y+3]);break;case"z":this.closePath(!0)}r=v}},_canComposite:function(){return!(this.hasFill()&&this.hasStroke())},_contains:function(t){var e=this._getWinding(t,!1,!0);return!!("evenodd"===this.getWindingRule()?1&e:e)}}),A=z.extend({_class:"Path",_serializeFields:{segments:[],closed:!1},initialize:function(e){this._closed=!1,this._segments=[],this._version=0;var n=Array.isArray(e)?"object"==typeof e[0]?e:arguments:!e||e.size!==t||e.x===t&&e.point===t?null:arguments;n&&n.length>0?this.setSegments(n):(this._curves=t,this._selectedSegmentState=0,n||"string"!=typeof e||(this.setPathData(e),e=null)),this._initialize(!n&&e)},_equals:function(t){return this._closed===t._closed&&e.equals(this._segments,t._segments)},clone:function(e){var n=new A(m.NO_INSERT);return n.setSegments(this._segments),n._closed=this._closed,this._clockwise!==t&&(n._clockwise=this._clockwise),this._clone(n,e)},_changed:function vt(e){if(vt.base.call(this,e),8&e){var n=this._parent;if(n&&(n._currentPath=t),this._length=this._area=this._clockwise=this._monoCurves=t,16&e)this._version++;else if(this._curves)for(var i=0,r=this._curves.length;r>i;i++)this._curves[i]._changed()}else 32&e&&(this._bounds=t)},getStyle:function(){var t=this._parent;return(t instanceof O?t:this)._style},getSegments:function(){return this._segments},setSegments:function(e){var n=this.isFullySelected();this._segments.length=0,this._selectedSegmentState=0,this._curves=t,e&&e.length>0&&this._add(P.readAll(e)),n&&this.setFullySelected(!0)},getFirstSegment:function(){return this._segments[0]},getLastSegment:function(){return this._segments[this._segments.length-1]},getCurves:function(){var t=this._curves,e=this._segments;if(!t){var n=this._countCurves();t=this._curves=Array(n);for(var i=0;n>i;i++)t[i]=new I(this,e[i],e[i+1]||e[0])}return t},getFirstCurve:function(){return this.getCurves()[0]},getLastCurve:function(){var t=this.getCurves();return t[t.length-1]},isClosed:function(){return this._closed},setClosed:function(t){if(this._closed!=(t=!!t)){if(this._closed=t,this._curves){var e=this._curves.length=this._countCurves();t&&(this._curves[e-1]=new I(this,this._segments[e-1],this._segments[0]))}this._changed(25)}}},{beans:!0,getPathData:function(t,e){function n(e,n){e._transformCoordinates(t,_,!1),i=_[0],r=_[1],v?(p.push("M"+g.pair(i,r)),v=!1):(h=_[2],u=_[3],h===i&&u===r&&l===a&&c===o?n||p.push("l"+g.pair(i-a,r-o)):p.push("c"+g.pair(l-a,c-o)+" "+g.pair(h-a,u-o)+" "+g.pair(i-a,r-o))),a=i,o=r,l=_[4],c=_[5]}var i,r,a,o,h,u,l,c,d=this._segments,f=d.length,g=new s(e),_=Array(6),v=!0,p=[];if(0===f)return"";for(var m=0;f>m;m++)n(d[m]);return this._closed&&f>0&&(n(d[0],!0),p.push("z")),p.join("")}},{isEmpty:function(){return 0===this._segments.length},_transformContent:function(t){for(var e=Array(6),n=0,i=this._segments.length;i>n;n++)this._segments[n]._transformCoordinates(t,e,!0);return!0},_add:function(t,e){for(var n=this._segments,i=this._curves,r=t.length,s=null==e,e=s?n.length:e,a=0;r>a;a++){var o=t[a];o._path&&(o=t[a]=o.clone()),o._path=this,o._index=e+a,o._selectionState&&this._updateSelection(o,0,o._selectionState)}if(s)n.push.apply(n,t);else{n.splice.apply(n,[e,0].concat(t));for(var a=e+r,h=n.length;h>a;a++)n[a]._index=a}if(i){var u=this._countCurves(),l=e+r-1===u?e-1:e,c=l,d=Math.min(l+r,u);t._curves&&(i.splice.apply(i,[l,0].concat(t._curves)),c+=t._curves.length);for(var a=c;d>a;a++)i.splice(a,0,new I(this,null,null));this._adjustCurves(l,d)}return this._changed(25),t},_adjustCurves:function(t,e){for(var n,i=this._segments,r=this._curves,s=t;e>s;s++)n=r[s],n._path=this,n._segment1=i[s],n._segment2=i[s+1]||i[0],n._changed();(n=r[this._closed&&0===t?i.length-1:t-1])&&(n._segment2=i[t]||i[0],n._changed()),(n=r[e])&&(n._segment1=i[e],n._changed())},_countCurves:function(){var t=this._segments.length;return!this._closed&&t>0?t-1:t},add:function(t){return arguments.length>1&&"number"!=typeof t?this._add(P.readAll(arguments)):this._add([P.read(arguments)])[0]},insert:function(t,e){return arguments.length>2&&"number"!=typeof e?this._add(P.readAll(arguments,1),t):this._add([P.read(arguments,1)],t)[0]},addSegment:function(){return this._add([P.read(arguments)])[0]},insertSegment:function(t){return this._add([P.read(arguments,1)],t)[0]},addSegments:function(t){return this._add(P.readAll(t))},insertSegments:function(t,e){return this._add(P.readAll(e),t)},removeSegment:function(t){return this.removeSegments(t,t+1)[0]||null},removeSegments:function(t,n,i){t=t||0,n=e.pick(n,this._segments.length);var r=this._segments,s=this._curves,a=r.length,o=r.splice(t,n-t),h=o.length;if(!h)return o;for(var u=0;h>u;u++){var l=o[u];l._selectionState&&this._updateSelection(l,l._selectionState,0),l._index=l._path=null}for(var u=t,c=r.length;c>u;u++)r[u]._index=u;if(s){var d=t>0&&n===a+(this._closed?1:0)?t-1:t,s=s.splice(d,h);i&&(o._curves=s.slice(1)),this._adjustCurves(d,d)}return this._changed(25),o},clear:"#removeSegments",hasHandles:function(){for(var t=this._segments,e=0,n=t.length;n>e;e++)if(t[e].hasHandles())return!0;return!1},clearHandles:function(){for(var t=this._segments,e=0,n=t.length;n>e;e++)t[e].clearHandles()},getLength:function(){if(null==this._length){for(var t=this.getCurves(),e=0,n=0,i=t.length;i>n;n++)e+=t[n].getLength();this._length=e}return this._length},getArea:function(){if(null==this._area){for(var t=this._segments,e=t.length,n=e-1,i=0,r=0,s=this._closed?e:n;s>r;r++)i+=I.getArea(I.getValues(t[r],t[n>r?r+1:0]));this._area=i}return this._area},isClockwise:function(){return this._clockwise!==t?this._clockwise:this.getArea()>=0},setClockwise:function(t){this.isClockwise()!=(t=!!t)&&this.reverse(),this._clockwise=t},isFullySelected:function(){var t=this._segments.length;return this._selected&&t>0&&this._selectedSegmentState===7*t},setFullySelected:function(t){t&&this._selectSegments(!0),this.setSelected(t)},setSelected:function pt(t){t||this._selectSegments(!1),pt.base.call(this,t)},_selectSegments:function(t){var e=this._segments.length;this._selectedSegmentState=t?7*e:0;for(var n=0;e>n;n++)this._segments[n]._selectionState=t?7:0},_updateSelection:function(t,e,n){t._selectionState=n;var i=this._selectedSegmentState+=n-e;i>0&&this.setSelected(!0)},flatten:function(t){for(var e=new T(this,64,.1),n=0,i=e.length/Math.ceil(e.length/t),r=e.length+(this._closed?-i:i)/2,s=[];r>=n;)s.push(new P(e.getPointAt(n))),n+=i;this.setSegments(s)},reduce:function(){for(var t=this.getCurves(),e=t.length-1;e>=0;e--){var n=t[e];n.hasHandles()||0!==n.getLength()&&!n.isCollinear(n.getNext())||n.remove()}return this},simplify:function(t){if(this._segments.length>2){var e=new E(this,t||2.5);this.setSegments(e.fit())}},split:function(t,e){if(null===e)return null;if(1===arguments.length){var n=t;if("number"==typeof n&&(n=this.getLocationAt(n)),!n)return null;t=n.index,e=n.parameter}var i=4e-7,r=1-i;e>=r&&(t++,e--);var s=this.getCurves();if(t>=0&&t<s.length){e>=i&&s[t++].divide(e,!0);var a,o=this.removeSegments(t,this._segments.length,!0);return this._closed?(this.setClosed(!1),a=this):(a=new A(m.NO_INSERT),a.insertAbove(this,!0),this._clone(a)),a._add(o,0),this.addSegment(o[0]),a}return null},reverse:function(){this._segments.reverse();for(var e=0,n=this._segments.length;n>e;e++){var i=this._segments[e],r=i._handleIn;i._handleIn=i._handleOut,i._handleOut=r,i._index=e}this._curves=null,this._clockwise!==t&&(this._clockwise=!this._clockwise),this._changed(9)},join:function(t){if(t){var e=t._segments,n=this.getLastSegment(),i=t.getLastSegment();if(!i)return this;n&&n._point.equals(i._point)&&t.reverse();var r=t.getFirstSegment();if(n&&n._point.equals(r._point))n.setHandleOut(r._handleOut),this._add(e.slice(1));else{var s=this.getFirstSegment();s&&s._point.equals(r._point)&&t.reverse(),i=t.getLastSegment(),s&&s._point.equals(i._point)?(s.setHandleIn(i._handleIn),this._add(e.slice(0,e.length-1),0)):this._add(e.slice())}t._closed&&this._add([e[0]]),t.remove()}var a=this.getFirstSegment(),o=this.getLastSegment();return a!==o&&a._point.equals(o._point)&&(a.setHandleIn(o._handleIn),o.remove(),this.setClosed(!0)),this},toShape:function(t){function e(t,e){var n=c[t],i=n.getNext(),r=c[e],s=r.getNext();return n._handleOut.isZero()&&i._handleIn.isZero()&&r._handleOut.isZero()&&s._handleIn.isZero()&&i._point.subtract(n._point).isCollinear(s._point.subtract(r._point))}function n(t){var e=c[t],n=e.getPrevious(),i=e.getNext();return n._handleOut.isZero()&&e._handleIn.isZero()&&e._handleOut.isZero()&&i._handleIn.isZero()&&e._point.subtract(n._point).isOrthogonal(i._point.subtract(e._point))}function i(t){var e=c[t],n=e.getNext(),i=e._handleOut,r=n._handleIn,s=.5522847498307936;if(i.isOrthogonal(r)){var o=e._point,h=n._point,u=new _(o,i,!0).intersect(new _(h,r,!0),!0);return u&&a.isZero(i.getLength()/u.subtract(o).getLength()-s)&&a.isZero(r.getLength()/u.subtract(h).getLength()-s)}return!1}function r(t,e){return c[t]._point.getDistance(c[e]._point)}if(!this._closed)return null;var s,o,h,u,c=this._segments;if(!this.hasHandles()&&4===c.length&&e(0,2)&&e(1,3)&&n(1)?(s=x.Rectangle,o=new l(r(0,3),r(0,1)),u=c[1]._point.add(c[2]._point).divide(2)):8===c.length&&i(0)&&i(2)&&i(4)&&i(6)&&e(1,5)&&e(3,7)?(s=x.Rectangle,o=new l(r(1,6),r(0,3)),h=o.subtract(new l(r(0,7),r(1,2))).divide(2),u=c[3]._point.add(c[4]._point).divide(2)):4===c.length&&i(0)&&i(1)&&i(2)&&i(3)&&(a.isZero(r(0,2)-r(1,3))?(s=x.Circle,h=r(0,2)/2):(s=x.Ellipse,h=new l(r(2,0)/2,r(3,1)/2)),u=c[1]._point),s){var d=this.getPosition(!0),f=this._clone(new s({center:d,size:o,radius:h,insert:!1}),t,!1);return f.rotate(u.subtract(d).getAngle()+90),f}return null},_hitTestSelf:function(t,e){function n(e,n){return t.subtract(e).divide(n).length<=1}function i(t,i,r){if(!e.selected||i.isSelected()){var s=t._point;if(i!==s&&(i=i.add(s)),n(i,w))return new S(r,g,{segment:t,point:i})}}function r(t,n){return(n||e.segments)&&i(t,t._point,"segment")||!n&&e.handles&&(i(t,t._handleIn,"handle-in")||i(t,t._handleOut,"handle-out"))}function s(t){c.add(t)}function a(e){if(("round"!==o||"round"!==u)&&(c=new A({internal:!0,closed:!0}),m||e._index>0&&e._index<p-1?"round"!==o&&(e._handleIn.isZero()||e._handleOut.isZero())&&A._addBevelJoin(e,o,P,l,s,!0):"round"!==u&&A._addSquareCap(e,u,P,s,!0),!c.isEmpty())){var i;return c.contains(t)||(i=c.getNearestLocation(t))&&n(i.getPoint(),y)}return n(e._point,w)}var o,u,l,c,d,f,g=this,_=this.getStyle(),v=this._segments,p=v.length,m=this._closed,y=e._tolerancePadding,w=y,x=e.stroke&&_.hasStroke(),b=e.fill&&_.hasFill(),C=e.curves,P=x?_.getStrokeWidth()/2:b&&e.tolerance>0||C?0:null;if(null!==P&&(P>0?(o=_.getStrokeJoin(),u=_.getStrokeCap(),l=P*_.getMiterLimit(),w=y.add(new h(P,P))):o=u="round"),!e.ends||e.segments||m){if(e.segments||e.handles)for(var k=0;p>k;k++)if(f=r(v[k]))return f}else if(f=r(v[0],!0)||r(v[p-1],!0))return f;if(null!==P){if(d=this.getNearestLocation(t)){var I=d.getParameter();0===I||1===I&&p>1?a(d.getSegment())||(d=null):n(d.getPoint(),w)||(d=null)}if(!d&&"miter"===o&&p>1)for(var k=0;p>k;k++){var M=v[k];if(t.getDistance(M._point)<=l&&a(M)){d=M.getLocation();break}}}return!d&&b&&this._contains(t)||d&&!x&&!C?new S("fill",this):d?new S(x?"stroke":"curve",this,{location:d,point:d.getPoint()}):null}},e.each(I.evaluateMethods,function(t){this[t+"At"]=function(e,n){var i=this.getLocationAt(e,n);return i&&i[t]()}},{beans:!1,getLocationOf:function(){for(var t=h.read(arguments),e=this.getCurves(),n=0,i=e.length;i>n;n++){var r=e[n].getLocationOf(t);if(r)return r}return null},getOffsetOf:function(){var t=this.getLocationOf.apply(this,arguments);return t?t.getOffset():null},getLocationAt:function(t,e){var n=this.getCurves(),i=0;if(e){var r=~~t,s=n[r];return s?s.getLocationAt(t-r,!0):null}for(var a=0,o=n.length;o>a;a++){var h=i,s=n[a];if(i+=s.getLength(),i>t)return s.getLocationAt(t-h)}return n.length>0&&t<=this.getLength()?new M(n[n.length-1],1):null},getNearestLocation:function(){for(var t=h.read(arguments),e=this.getCurves(),n=1/0,i=null,r=0,s=e.length;s>r;r++){var a=e[r].getNearestLocation(t);a._distance<n&&(n=a._distance,i=a)}return i},getNearestPoint:function(){return this.getNearestLocation.apply(this,arguments).getPoint()}}),new function(){function t(t,e,n,i){function r(e){var n=a[e],i=a[e+1];(c!=n||d!=i)&&(t.beginPath(),t.moveTo(c,d),t.lineTo(n,i),t.stroke(),t.beginPath(),t.arc(n,i,s,0,2*Math.PI,!0),t.fill())}for(var s=i/2,a=Array(6),o=0,h=e.length;h>o;o++){var u=e[o];u._transformCoordinates(n,a,!1);var l=u._selectionState,c=a[0],d=a[1];if(1&l&&r(2),2&l&&r(4),t.fillRect(c-s,d-s,i,i),!(4&l)){var f=t.fillStyle;t.fillStyle="#ffffff",t.fillRect(c-s+1,d-s+1,i-2,i-2),t.fillStyle=f}}}function e(t,e,n){function i(e){if(n)e._transformCoordinates(n,g,!1),r=g[0],s=g[1];else{var i=e._point;r=i._x,s=i._y}if(_)t.moveTo(r,s),_=!1;else{if(n)h=g[2],u=g[3];else{var d=e._handleIn;h=r+d._x,u=s+d._y}h===r&&u===s&&l===a&&c===o?t.lineTo(r,s):t.bezierCurveTo(l,c,h,u,r,s)}if(a=r,o=s,n)l=g[4],c=g[5];else{var d=e._handleOut;l=a+d._x,c=o+d._y}}for(var r,s,a,o,h,u,l,c,d=e._segments,f=d.length,g=Array(6),_=!0,v=0;f>v;v++)i(d[v]);e._closed&&f>0&&i(d[0])}return{_draw:function(t,n,i){function r(t){return l[(t%c+c)%c]}var s=n.dontStart,a=n.dontFinish||n.clip,o=this.getStyle(),h=o.hasFill(),u=o.hasStroke(),l=o.getDashArray(),c=!paper.support.nativeDash&&u&&l&&l.length;if(s||t.beginPath(),!s&&this._currentPath?t.currentPath=this._currentPath:(h||u&&!c||a)&&(e(t,this,i),this._closed&&t.closePath(),s||(this._currentPath=t.currentPath)),!a&&(h||u)&&(this._setStyles(t),h&&(t.fill(o.getWindingRule()),t.shadowColor="rgba(0,0,0,0)"),u)){if(c){s||t.beginPath();var d,f=new T(this,32,.25,i),g=f.length,_=-o.getDashOffset(),v=0;for(_%=g;_>0;)_-=r(v--)+r(v--);for(;g>_;)d=_+r(v++),(_>0||d>0)&&f.drawPart(t,Math.max(_,0),Math.max(d,0)),_=d+r(v++)}t.stroke()}},_drawSelected:function(n,i){n.beginPath(),e(n,this,i),n.stroke(),t(n,this._segments,i,paper.settings.handleSize)}}},new function(){function t(t){var e=t.length,n=[],i=[],r=2;n[0]=t[0]/r;for(var s=1;e>s;s++)i[s]=1/r,r=(e-1>s?4:2)-i[s],n[s]=(t[s]-n[s-1])/r;for(var s=1;e>s;s++)n[e-s-1]-=i[e-s]*n[e-s];return n}return{smooth:function(){var e=this._segments,n=e.length,i=this._closed,r=n,s=0;if(!(2>=n)){i&&(s=Math.min(n,4),r+=2*Math.min(n,s));for(var a=[],o=0;n>o;o++)a[o+s]=e[o]._point;if(i)for(var o=0;s>o;o++)a[o]=e[o+n-s]._point,a[o+n+s]=e[o]._point;else r--;for(var u=[],o=1;r-1>o;o++)u[o]=4*a[o]._x+2*a[o+1]._x;u[0]=a[0]._x+2*a[1]._x,u[r-1]=3*a[r-1]._x;for(var l=t(u),o=1;r-1>o;o++)u[o]=4*a[o]._y+2*a[o+1]._y;u[0]=a[0]._y+2*a[1]._y,u[r-1]=3*a[r-1]._y;var c=t(u);if(i){for(var o=0,d=n;s>o;o++,d++){var f=o/s,g=1-f,_=o+s,v=d+s;l[d]=l[o]*f+l[d]*g,c[d]=c[o]*f+c[d]*g,l[v]=l[_]*g+l[v]*f,c[v]=c[_]*g+c[v]*f}r--}for(var p=null,o=s;r-s>=o;o++){var m=e[o-s];p&&m.setHandleIn(p.subtract(m._point)),r>o&&(m.setHandleOut(new h(l[o],c[o]).subtract(m._point)),p=r-1>o?new h(2*a[o+1]._x-l[o+1],2*a[o+1]._y-c[o+1]):new h((a[r]._x+l[r-1])/2,(a[r]._y+c[r-1])/2))}if(i&&p){var m=this._segments[0];m.setHandleIn(p.subtract(m._point))}}}}},new function(){function t(t){var e=t._segments;if(0===e.length)throw Error("Use a moveTo() command first");return e[e.length-1]}return{moveTo:function(){var t=this._segments;1===t.length&&this.removeSegment(0),t.length||this._add([new P(h.read(arguments))])},moveBy:function(){throw Error("moveBy() is unsupported on Path items.")},lineTo:function(){this._add([new P(h.read(arguments))])},cubicCurveTo:function(){var e=h.read(arguments),n=h.read(arguments),i=h.read(arguments),r=t(this);r.setHandleOut(e.subtract(r._point)),this._add([new P(i,n.subtract(i))])},quadraticCurveTo:function(){var e=h.read(arguments),n=h.read(arguments),i=t(this)._point;this.cubicCurveTo(e.add(i.subtract(e).multiply(1/3)),e.add(n.subtract(e).multiply(1/3)),n)},curveTo:function(){var n=h.read(arguments),i=h.read(arguments),r=e.pick(e.read(arguments),.5),s=1-r,a=t(this)._point,o=n.subtract(a.multiply(s*s)).subtract(i.multiply(r*r)).divide(2*r*s);if(o.isNaN())throw Error("Cannot put a curve through points with parameter = "+r);this.quadraticCurveTo(o,i)},arcTo:function(){var n,i,r,s,a,o=t(this),u=o._point,c=h.read(arguments),d=e.peek(arguments),f=e.pick(d,!0);if("boolean"==typeof f)var v=u.add(c).divide(2),n=v.add(v.subtract(u).rotate(f?-90:90));else if(e.remain(arguments)<=2)n=c,c=h.read(arguments);else{var p=l.read(arguments);if(p.isZero())return this.lineTo(c);var m=e.read(arguments),f=!!e.read(arguments),y=!!e.read(arguments),v=u.add(c).divide(2),w=u.subtract(v).rotate(-m),x=w.x,b=w.y,C=Math.abs,S=C(p.width),k=C(p.height),I=S*S,M=k*k,z=x*x,A=b*b,O=Math.sqrt(z/I+A/M);if(O>1&&(S*=O,k*=O,I=S*S,M=k*k),O=(I*M-I*A-M*z)/(I*A+M*z),C(O)<1e-12&&(O=0),0>O)throw Error("Cannot create an arc with the given arguments");i=new h(S*b/k,-k*x/S).multiply((y===f?-1:1)*Math.sqrt(O)).rotate(m).add(v),a=(new g).translate(i).rotate(m).scale(S,k),s=a._inverseTransform(u),r=s.getDirectedAngle(a._inverseTransform(c)),!f&&r>0?r-=360:f&&0>r&&(r+=360)}if(n){var T=new _(u.add(n).divide(2),n.subtract(u).rotate(90),!0),E=new _(n.add(c).divide(2),c.subtract(n).rotate(90),!0),L=new _(u,c),N=L.getSide(n);if(i=T.intersect(E,!0),!i){if(!N)return this.lineTo(c);throw Error("Cannot create an arc with the given arguments")}s=u.subtract(i),r=s.getDirectedAngle(c.subtract(i));var j=L.getSide(i);0===j?r=N*Math.abs(r):N===j&&(r+=0>r?360:-360)}for(var B=Math.abs(r),R=B>=360?4:Math.ceil(B/90),D=r/R,F=D*Math.PI/360,q=4/3*Math.sin(F)/(1+Math.cos(F)),V=[],H=0;R>=H;H++){var w=c,Z=null;if(R>H&&(Z=s.rotate(90).multiply(q),a?(w=a._transformPoint(s),Z=a._transformPoint(s.add(Z)).subtract(w)):w=i.add(s)),0===H)o.setHandleOut(Z);else{var U=s.rotate(-90).multiply(q);a&&(U=a._transformPoint(s.add(U)).subtract(w)),V.push(new P(w,U,Z))}s=s.rotate(D)}this._add(V)},lineBy:function(){var e=h.read(arguments),n=t(this)._point;this.lineTo(n.add(e))},curveBy:function(){var n=h.read(arguments),i=h.read(arguments),r=e.read(arguments),s=t(this)._point;this.curveTo(s.add(n),s.add(i),r)},cubicCurveBy:function(){var e=h.read(arguments),n=h.read(arguments),i=h.read(arguments),r=t(this)._point;this.cubicCurveTo(r.add(e),r.add(n),r.add(i))},quadraticCurveBy:function(){var e=h.read(arguments),n=h.read(arguments),i=t(this)._point;this.quadraticCurveTo(i.add(e),i.add(n))},arcBy:function(){var n=t(this)._point,i=n.add(h.read(arguments)),r=e.pick(e.peek(arguments),!0);"boolean"==typeof r?this.arcTo(i,r):this.arcTo(i,n.add(h.read(arguments)))},closePath:function(t){this.setClosed(!0),t&&this.join()}}},{_getBounds:function(t,e){return A[t](this._segments,this._closed,this.getStyle(),e)},statics:{getBounds:function(t,e,n,i,r){function s(t){t._transformCoordinates(i,o,!1);for(var e=0;2>e;e++)I._addBounds(h[e],h[e+4],o[e+2],o[e],e,r?r[e]:0,u,l,c);var n=h;h=o,o=n}var a=t[0];if(!a)return new d;for(var o=Array(6),h=a._transformCoordinates(i,Array(6),!1),u=h.slice(0,2),l=u.slice(),c=Array(2),f=1,g=t.length;g>f;f++)s(t[f]);return e&&s(a),new d(u[0],u[1],l[0]-u[0],l[1]-u[1])},getStrokeBounds:function(t,e,n,i){function r(t){f=f.include(i?i._transformPoint(t,t):t)}function s(t){f=f.unite(p.setCenter(i?i._transformPoint(t._point):t._point))}function a(t,e){var n=t._handleIn,i=t._handleOut;"round"===e||!n.isZero()&&!i.isZero()&&n.isCollinear(i)?s(t):A._addBevelJoin(t,e,u,v,r)}function o(t,e){"round"===e?s(t):A._addSquareCap(t,e,u,r)}if(!n.hasStroke())return A.getBounds(t,e,n,i);for(var h=t.length-(e?0:1),u=n.getStrokeWidth()/2,c=A._getPenPadding(u,i),f=A.getBounds(t,e,n,i,c),g=n.getStrokeJoin(),_=n.getStrokeCap(),v=u*n.getMiterLimit(),p=new d(new l(c).multiply(2)),m=1;h>m;m++)a(t[m],g);return e?a(t[0],g):h>0&&(o(t[0],_),o(t[t.length-1],_)),f},_getPenPadding:function(t,e){if(!e)return[t,t];var n=e.shiftless(),i=n.transform(new h(t,0)),r=n.transform(new h(0,t)),s=i.getAngleInRadians(),a=i.getLength(),o=r.getLength(),u=Math.sin(s),l=Math.cos(s),c=Math.tan(s),d=-Math.atan(o*c/a),f=Math.atan(o/(c*a));return[Math.abs(a*Math.cos(d)*l-o*Math.sin(d)*u),Math.abs(o*Math.sin(f)*l+a*Math.cos(f)*u)]},_addBevelJoin:function(t,e,n,i,r,s){var a=t.getCurve(),o=a.getPrevious(),u=a.getPointAt(0,!0),l=o.getNormalAt(1,!0),c=a.getNormalAt(0,!0),d=l.getDirectedAngle(c)<0?-n:n;if(l.setLength(d),c.setLength(d),s&&(r(u),r(u.add(l))),"miter"===e){var f=new _(u.add(l),new h(-l.y,l.x),!0).intersect(new _(u.add(c),new h(-c.y,c.x),!0),!0);if(f&&u.getDistance(f)<=i&&(r(f),!s))return}s||r(u.add(l)),r(u.add(c))},_addSquareCap:function(t,e,n,i,r){var s=t._point,a=t.getLocation(),o=a.getNormal().multiply(n);r&&(i(s.subtract(o)),i(s.add(o))),"square"===e&&(s=s.add(o.rotate(0===a.getParameter()?-90:90))),i(s.add(o)),i(s.subtract(o))},getHandleBounds:function(t,e,n,i,r,s){for(var a=Array(6),o=1/0,h=-o,u=o,l=h,c=0,f=t.length;f>c;c++){var g=t[c];g._transformCoordinates(i,a,!1);for(var _=0;6>_;_+=2){var v=0===_?s:r,p=v?v[0]:0,m=v?v[1]:0,y=a[_],w=a[_+1],x=y-p,b=y+p,C=w-m,S=w+m;o>x&&(o=x),b>h&&(h=b),u>C&&(u=C),S>l&&(l=S)}}return new d(o,u,h-o,l-u)},getRoughBounds:function(t,e,n,i){var r=n.hasStroke()?n.getStrokeWidth()/2:0,s=r;return r>0&&("miter"===n.getStrokeJoin()&&(s=r*n.getMiterLimit()),"square"===n.getStrokeCap()&&(s=Math.max(s,r*Math.sqrt(2)))),A.getHandleBounds(t,e,n,i,A._getPenPadding(r,i),A._getPenPadding(s,i))}}});A.inject({statics:new function(){function t(t,n,i){var r=e.getNamed(i),s=new A(r&&r.insert===!1&&m.NO_INSERT);return s._add(t),s._closed=n,s.set(r)}function n(e,n,i){for(var s=Array(4),a=0;4>a;a++){var o=r[a];s[a]=new P(o._point.multiply(n).add(e),o._handleIn.multiply(n),o._handleOut.multiply(n))}return t(s,!0,i)}var i=.5522847498307936,r=[new P([-1,0],[0,i],[0,-i]),new P([0,-1],[-i,0],[i,0]),new P([1,0],[0,-i],[0,i]),new P([0,1],[i,0],[-i,0])];return{Line:function(){return t([new P(h.readNamed(arguments,"from")),new P(h.readNamed(arguments,"to"))],!1,arguments)},Circle:function(){var t=h.readNamed(arguments,"center"),i=e.readNamed(arguments,"radius");return n(t,new l(i),arguments)},Rectangle:function(){var e,n=d.readNamed(arguments,"rectangle"),r=l.readNamed(arguments,"radius",0,{readNull:!0}),s=n.getBottomLeft(!0),a=n.getTopLeft(!0),o=n.getTopRight(!0),h=n.getBottomRight(!0);if(!r||r.isZero())e=[new P(s),new P(a),new P(o),new P(h)];else{r=l.min(r,n.getSize(!0).divide(2));var u=r.width,c=r.height,f=u*i,g=c*i;e=[new P(s.add(u,0),null,[-f,0]),new P(s.subtract(0,c),[0,g]),new P(a.add(0,c),null,[0,-g]),new P(a.add(u,0),[-f,0],null),new P(o.subtract(u,0),null,[f,0]),new P(o.add(0,c),[0,-g],null),new P(h.subtract(0,c),null,[0,g]),new P(h.subtract(u,0),[f,0])]}return t(e,!0,arguments)},RoundRectangle:"#Rectangle",Ellipse:function(){var t=x._readEllipse(arguments);return n(t.center,t.radius,arguments)},Oval:"#Ellipse",Arc:function(){var t=h.readNamed(arguments,"from"),n=h.readNamed(arguments,"through"),i=h.readNamed(arguments,"to"),r=e.getNamed(arguments),s=new A(r&&r.insert===!1&&m.NO_INSERT);return s.moveTo(t),s.arcTo(n,i),s.set(r)},RegularPolygon:function(){for(var n=h.readNamed(arguments,"center"),i=e.readNamed(arguments,"sides"),r=e.readNamed(arguments,"radius"),s=360/i,a=!(i%3),o=new h(0,a?-r:r),u=a?-1:.5,l=Array(i),c=0;i>c;c++)l[c]=new P(n.add(o.rotate((c+u)*s)));return t(l,!0,arguments)},Star:function(){for(var n=h.readNamed(arguments,"center"),i=2*e.readNamed(arguments,"points"),r=e.readNamed(arguments,"radius1"),s=e.readNamed(arguments,"radius2"),a=360/i,o=new h(0,-1),u=Array(i),l=0;i>l;l++)u[l]=new P(n.add(o.rotate(a*l).multiply(l%2?s:r)));return t(u,!0,arguments)}}}});var O=z.extend({_class:"CompoundPath",_serializeFields:{children:[]},initialize:function(t){this._children=[],this._namedChildren={},this._initialize(t)||("string"==typeof t?this.setPathData(t):this.addChildren(Array.isArray(t)?t:arguments))},insertChildren:function mt(e,n,i){for(var r=n.length-1;r>=0;r--){var s=n[r];s instanceof O&&(n.splice.apply(n,[r,1].concat(s.removeChildren())),s.remove())}n=mt.base.call(this,e,n,i,A);for(var r=0,a=!i&&n&&n.length;a>r;r++){var s=n[r];s._clockwise===t&&s.setClockwise(0===s._index)}return n},reverse:function(){for(var t=this._children,e=0,n=t.length;n>e;e++)t[e].reverse()},smooth:function(){for(var t=0,e=this._children.length;e>t;t++)this._children[t].smooth()},reduce:function yt(){for(var t=this._children,e=t.length-1;e>=0;e--){var n=t[e].reduce();n.isEmpty()&&t.splice(e,1)}if(0===t.length){var n=new A(m.NO_INSERT);return n.insertAbove(this),n.setStyle(this._style),this.remove(),n}return yt.base.call(this)},isClockwise:function(){var t=this.getFirstChild();return t&&t.isClockwise()},setClockwise:function(t){this.isClockwise()!==!!t&&this.reverse()},getFirstSegment:function(){var t=this.getFirstChild();return t&&t.getFirstSegment()},getLastSegment:function(){var t=this.getLastChild();return t&&t.getLastSegment()},getCurves:function(){for(var t=this._children,e=[],n=0,i=t.length;i>n;n++)e.push.apply(e,t[n].getCurves());return e},getFirstCurve:function(){var t=this.getFirstChild();return t&&t.getFirstCurve()},getLastCurve:function(){var t=this.getLastChild();return t&&t.getFirstCurve()},getArea:function(){for(var t=this._children,e=0,n=0,i=t.length;i>n;n++)e+=t[n].getArea();return e}},{beans:!0,getPathData:function(t,e){for(var n=this._children,i=[],r=0,s=n.length;s>r;r++){var a=n[r],o=a._matrix;i.push(a.getPathData(t&&!o.isIdentity()?t.chain(o):t,e))}return i.join(" ")}},{_getChildHitTestOptions:function(t){return t["class"]===A||"path"===t.type?t:new e(t,{fill:!1})},_draw:function(t,e,n){var i=this._children;if(0!==i.length){if(this._currentPath)t.currentPath=this._currentPath;else{e=e.extend({dontStart:!0,dontFinish:!0}),t.beginPath();for(var r=0,s=i.length;s>r;r++)i[r].draw(t,e,n);this._currentPath=t.currentPath}if(!e.clip){this._setStyles(t);var a=this._style;a.hasFill()&&(t.fill(a.getWindingRule()),t.shadowColor="rgba(0,0,0,0)"),a.hasStroke()&&t.stroke()}}},_drawSelected:function(t,e,n){for(var i=this._children,r=0,s=i.length;s>r;r++){
var a=i[r],o=a._matrix;n[a._id]||a._drawSelected(t,o.isIdentity()?e:e.chain(o))}}},new function(){function t(t,e){var n=t._children;if(e&&0===n.length)throw Error("Use a moveTo() command first");return n[n.length-1]}var n={moveTo:function(){var e=t(this),n=e&&e.isEmpty()?e:new A(m.NO_INSERT);n!==e&&this.addChild(n),n.moveTo.apply(n,arguments)},moveBy:function(){var e=t(this,!0),n=e&&e.getLastSegment(),i=h.read(arguments);this.moveTo(n?i.add(n._point):i)},closePath:function(e){t(this,!0).closePath(e)}};return e.each(["lineTo","cubicCurveTo","quadraticCurveTo","curveTo","arcTo","lineBy","cubicCurveBy","quadraticCurveBy","curveBy","arcBy"],function(e){n[e]=function(){var n=t(this,!0);n[e].apply(n,arguments)}}),n});z.inject(new function(){function e(t,e){var n=t.clone(!1).reduce().transform(null,!0,!0);return e?n.resolveCrossings().reorient():n}function n(t,e,n,i,r){var s=new t(m.NO_INSERT);return s.addChildren(e,!0),r&&(s=s.reduce()),s.insertAbove(i&&n.isSibling(i)&&n.getIndex()<i.getIndex()?i:n),s.setStyle(n._style),s}function i(t,i,s){function a(t){for(var e=0,n=t.length;n>e;e++){var i=t[e];f.push.apply(f,i._segments),g.push.apply(g,i._getMonoCurves())}}if(!t._children&&!t._closed)return r(t,i,s);var h=e(t,!0),u=i&&t!==i&&e(i,!0);u&&/^(subtract|exclude)$/.test(s)^u.isClockwise()!==h.isClockwise()&&u.reverse();var d=M.expand(h.getIntersections(u,function(t){return u&&t.isOverlap()||t.isCrossing()}));o(d);var f=[],g=[];a(h._children||[h]),u&&a(u._children||[u]);for(var _=0,v=d.length;v>_;_++)l(d[_]._segment,h,u,g,s);for(var _=0,v=f.length;v>_;_++){var p=f[_];null==p._winding&&l(p,h,u,g,s)}return n(O,c(f,s),t,i,!0)}function r(i,r,s){function a(e){return h.contains(e.getPointAt(e.getLength()/2))^l?(c.unshift(e),!0):t}if(!r||!r._children&&!r._closed||!/^(subtract|intersect)$/.test(s))return null;for(var o=e(i,!1),h=e(r,!1),u=o.getIntersections(h,function(t){return t.isOverlap()||t.isCrossing()}),l="subtract"===s,c=[],d=u.length-1;d>=0;d--){var f=u[d].split();f&&(a(f)&&f.getFirstSegment().setHandleIn(0,0),o.getLastSegment().setHandleOut(0,0))}return a(o),n(y,c,i,r)}function s(t,e){for(var n=t;n;){if(n===e)return;n=n._prev}for(;t._next&&t._next!==e;)t=t._next;if(!t._next){for(;e._prev;)e=e._prev;t._next=e,e._prev=t}}function o(t){for(var e,n,i=4e-7,r=1-i,a=!1,o=[],h=t.length-1;h>=0;h--){var u=t[h],l=u._curve,c=u._parameter,d=c;l!==e?a=!l.hasHandles():n>0&&(c/=n);var f;i>c?f=l._segment1:c>r?f=l._segment2:(f=l.divide(c,!0,!0)._segment1,a&&o.push(f)),u._setSegment(f);var g=f._intersection,_=u._intersection;if(g){s(g,_);for(var v=g;v;)s(v._intersection,g),v=v._next}else f._intersection=_;e=l,n=d}for(var h=0,p=o.length;p>h;h++)o[h].clearHandles()}function u(t,e,n,i){var r=2e-7,s=4e-7,o=1-s,l=t.x,c=t.y,d=0,f=0,g=[],_=Math.abs;if(n){for(var v=-(1/0),p=1/0,m=c-r,y=c+r,w=0,x=e.length;x>w;w++){var b=e[w].values;if(I.solveCubic(b,0,l,g,0,1)>0)for(var C=g.length-1;C>=0;C--){var S=I.getPoint(b,g[C]).y;m>S&&S>v?v=S:S>y&&p>S&&(p=S)}}v=(v+c)/2,p=(p+c)/2,v>-(1/0)&&(d=u(new h(l,v),e,!1,i)),1/0>p&&(f=u(new h(l,p),e,!1,i))}else for(var P,k,M=l-r,z=l+r,A=!1,w=0,x=e.length;x>w;w++){var O=e[w],b=O.values,T=O.winding;if(T&&(1===T&&c>=b[1]&&c<=b[7]||c>=b[7]&&c<=b[1])&&1===I.solveCubic(b,1,c,g,0,1)){var E=g[0];if(!(E>o&&A&&O.next!==e[w+1]||s>E&&k>o&&O.previous===P)){var L=I.getPoint(b,E).x,N=I.getTangent(b,E).y,j=!1;a.isZero(N)&&!I.isStraight(b)||s>E&&N*I.getTangent(O.previous.values,1).y<0||E>o&&N*I.getTangent(O.next.values,0).y<0?i&&L>=M&&z>=L&&(++d,++f,j=!0):M>=L?(d+=T,j=!0):L>=z&&(f+=T,j=!0),O.previous!==e[w-1]&&(A=s>E&&j)}P=O,k=E}}return Math.max(_(d),_(f))}function l(t,e,n,i,r){var s=2e-7,a=[],o=t,h=0,l=0;do{var c=t.getCurve(),d=c.getLength();a.push({segment:t,curve:c,length:d}),h+=d,t=t.getNext()}while(t&&!t._intersection&&t!==o);for(var f=0;3>f;f++)for(var d=h*(f+1)/4,g=0,_=a.length;_>g;g++){var v=a[g],p=v.length;if(p>=d){(s>d||s>p-d)&&(d=p/2);var c=v.curve,m=c._path,y=m._parent,w=c.getPointAt(d),x=c.isHorizontal();y instanceof O&&(m=y),l+="subtract"===r&&n&&(m===e&&n._getWinding(w,x)||m===n&&!e._getWinding(w,x))?0:u(w,i,x);break}d-=p}for(var b=Math.round(l/3),C=a.length-1;C>=0;C--)a[C].segment._winding=b}function c(t,e){function n(t,e){if(t._visited)return!1;if(!l)return!0;var n=t._winding,i=t._intersection;return i&&e&&c&&i.isOverlap()&&(n=c[n]||n),l(n)}function i(t){return t===o||t===h}function r(t,e){if(!t._next)return t;for(;t;){var r=t._segment,s=r.getNext(),a=s._intersection;if(i(s)||!r._visited&&!s._visited&&(!l||(!e||n(r))&&(!(e&&a&&a.isOverlap())&&n(s)||!e&&a&&n(a._segment))))return t;t=t._next}return null}function s(t,e){for(;t;){var n=t._segment;if(i(n))return n;t=t[e?"_next":"_prev"]}}for(var o,h,u=[],l=d[e],c={unite:{1:2},intersect:{2:1}}[e],f=0,g=t.length;g>f;f++){var _=t[f],v=null,p=!1;if(n(_,!0)){for(o=h=null;!p;){var y=_._intersection,w=v&&_._handleIn;y=y&&(r(y,!0)||r(y,!1))||y;var x=y&&y._segment;if(x&&n(x)&&(_=x),_._visited){if(p=i(_),!p&&y){var b=s(y,!0)||s(y,!1);b&&(_=b,p=!0)}break}v||(v=new A(m.NO_INSERT),o=_,h=x),v.add(new P(_._point,w,_._handleOut)),_._visited=!0,_=_.getNext(),p=i(_)}p?(v.firstSegment.setHandleIn(_._handleIn),v.setClosed(!0)):v&&(console.error("Boolean operation resulted in open path","segments =",v._segments.length,"length =",v.getLength()),v=null),v&&(v._segments.length>8||!a.isZero(v.getArea()))&&(u.push(v),v=null)}}return u}var d={unite:function(t){return 1===t||0===t},intersect:function(t){return 2===t},subtract:function(t){return 1===t},exclude:function(t){return 1===t}};return{_getWinding:function(t,e,n){return u(t,this._getMonoCurves(),e,n)},unite:function(t){return i(this,t,"unite")},intersect:function(t){return i(this,t,"intersect")},subtract:function(t){return i(this,t,"subtract")},exclude:function(t){return i(this,t,"exclude")},divide:function(t){return n(y,[this.subtract(t),this.intersect(t)],this,t,!0)},resolveCrossings:function(){var t=this.getCrossings();if(!t.length)return this;o(M.expand(t));for(var e=this._children||[this],i=[],r=0,s=e.length;s>r;r++)i.push.apply(i,e[r]._segments);return n(O,c(i),this,null,!1)}}}),A.inject({_getMonoCurves:function(){function t(t){var e=t[1],r=t[7],s={values:t,winding:e===r?0:e>r?-1:1,previous:n,next:null};n&&(n.next=s),i.push(s),n=s}function e(e){if(0!==I.getLength(e)){var n=e[1],i=e[3],r=e[5],s=e[7];if(I.isStraight(e))t(e);else{var o=3*(i-r)-n+s,h=2*(n+r)-4*i,u=i-n,l=4e-7,c=1-l,d=[],f=a.solveQuadratic(o,h,u,d,l,c);if(0===f)t(e);else{d.sort();var g=d[0],_=I.subdivide(e,g);t(_[0]),f>1&&(g=(d[1]-g)/(1-g),_=I.subdivide(_[1],g),t(_[0])),t(_[1])}}}}var n,i=this._monoCurves;if(!i){i=this._monoCurves=[];for(var r=this.getCurves(),s=this._segments,o=0,h=r.length;h>o;o++)e(r[o].getValues());if(!this._closed&&s.length>1){var u=s[s.length-1]._point,l=s[0]._point,c=u._x,d=u._y,f=l._x,g=l._y;e([c,d,c,d,f,g,f,g])}if(i.length>0){var _=i[0],v=i[i.length-1];_.previous=v,v.next=_}}return i},getInteriorPoint:function(){var t=this.getBounds(),e=t.getCenter(!0);if(!this.contains(e)){for(var n=this._getMonoCurves(),i=[],r=e.y,s=[],a=0,o=n.length;o>a;a++){var h=n[a].values;if((1===n[a].winding&&r>=h[1]&&r<=h[7]||r>=h[7]&&r<=h[1])&&I.solveCubic(h,1,r,i,0,1)>0)for(var u=i.length-1;u>=0;u--)s.push(I.getPoint(h,i[u]).x);if(s.length>1)break}e.x=(s[0]+s[1])/2}return e},reorient:function(){return this.setClockwise(!0),this}}),O.inject({_getMonoCurves:function(){for(var t=this._children,e=[],n=0,i=t.length;i>n;n++)e.push.apply(e,t[n]._getMonoCurves());return e},reorient:function(){var t=this.removeChildren().sort(function(t,e){return e.getBounds().getArea()-t.getBounds().getArea()});if(t.length>0){this.addChildren(t);for(var e=t[0].isClockwise(),n=1,i=t.length;i>n;n++){for(var r=t[n].getInteriorPoint(),s=0,a=n-1;a>=0;a--)t[a].contains(r)&&s++;t[n].setClockwise(s%2===0&&e)}}return this}});var T=e.extend({_class:"PathIterator",initialize:function(t,e,n,i){function r(t,e){var n=I.getValues(t,e,i);o.push(n),s(n,t._index,0,1)}function s(t,e,i,r){if(r-i>l&&!I.isFlatEnough(t,n||.25)){var a=I.subdivide(t,.5),o=(i+r)/2;s(a[0],e,i,o),s(a[1],e,o,r)}else{var c=t[6]-t[0],d=t[7]-t[1],f=Math.sqrt(c*c+d*d);f>1e-6&&(u+=f,h.push({offset:u,value:r,index:e}))}}for(var a,o=[],h=[],u=0,l=1/(e||32),c=t._segments,d=c[0],f=1,g=c.length;g>f;f++)a=c[f],r(d,a),d=a;t._closed&&r(a,c[0]),this.curves=o,this.parts=h,this.length=u,this.index=0},getParameterAt:function(t){for(var e,n=this.index;e=n,!(0==n||this.parts[--n].offset<t););for(var i=this.parts.length;i>e;e++){var r=this.parts[e];if(r.offset>=t){this.index=e;var s=this.parts[e-1],a=s&&s.index==r.index?s.value:0,o=s?s.offset:0;return{value:a+(r.value-a)*(t-o)/(r.offset-o),index:r.index}}}var r=this.parts[this.parts.length-1];return{value:1,index:r.index}},drawPart:function(t,e,n){e=this.getParameterAt(e),n=this.getParameterAt(n);for(var i=e.index;i<=n.index;i++){var r=I.getPart(this.curves[i],i==e.index?e.value:0,i==n.index?n.value:1);i==e.index&&t.moveTo(r[0],r[1]),t.bezierCurveTo.apply(t,r.slice(2))}}},e.each(I.evaluateMethods,function(t){this[t+"At"]=function(e,n){var i=this.getParameterAt(e);return I[t](this.curves[i.index],i.value,n)}},{})),E=e.extend({initialize:function(t,e){for(var n,i=this.points=[],r=t._segments,s=0,a=r.length;a>s;s++){var o=r[s].point.clone();n&&n.equals(o)||(i.push(o),n=o)}t._closed&&(this.closed=!0,i.unshift(i[i.length-1]),i.push(i[1])),this.error=e},fit:function(){var t=this.points,e=t.length,n=this.segments=e>0?[new P(t[0])]:[];return e>1&&this.fitCubic(0,e-1,t[1].subtract(t[0]).normalize(),t[e-2].subtract(t[e-1]).normalize()),this.closed&&(n.shift(),n.pop()),n},fitCubic:function(e,n,i,r){if(n-e==1){var s=this.points[e],a=this.points[n],o=s.getDistance(a)/3;return this.addCurve([s,s.add(i.normalize(o)),a.add(r.normalize(o)),a]),t}for(var h,u=this.chordLengthParameterize(e,n),l=Math.max(this.error,this.error*this.error),c=!0,d=0;4>=d;d++){var f=this.generateBezier(e,n,u,i,r),g=this.findMaxError(e,n,f,u);if(g.error<this.error&&c)return this.addCurve(f),t;if(h=g.index,g.error>=l)break;c=this.reparameterize(e,n,u,f),l=g.error}var _=this.points[h-1].subtract(this.points[h]),v=this.points[h].subtract(this.points[h+1]),p=_.add(v).divide(2).normalize();this.fitCubic(e,h,i,p),this.fitCubic(h,n,p.negate(),r)},addCurve:function(t){var e=this.segments[this.segments.length-1];e.setHandleOut(t[1].subtract(t[0])),this.segments.push(new P(t[3],t[2].subtract(t[3])))},generateBezier:function(t,e,n,i,r){for(var s=1e-12,a=this.points[t],o=this.points[e],h=[[0,0],[0,0]],u=[0,0],l=0,c=e-t+1;c>l;l++){var d=n[l],f=1-d,g=3*d*f,_=f*f*f,v=g*f,p=g*d,m=d*d*d,y=i.normalize(v),w=r.normalize(p),x=this.points[t+l].subtract(a.multiply(_+v)).subtract(o.multiply(p+m));h[0][0]+=y.dot(y),h[0][1]+=y.dot(w),h[1][0]=h[0][1],h[1][1]+=w.dot(w),u[0]+=y.dot(x),u[1]+=w.dot(x)}var b,C,S=h[0][0]*h[1][1]-h[1][0]*h[0][1];if(Math.abs(S)>s){var P=h[0][0]*u[1]-h[1][0]*u[0],k=u[0]*h[1][1]-u[1]*h[0][1];b=k/S,C=P/S}else{var I=h[0][0]+h[0][1],M=h[1][0]+h[1][1];b=C=Math.abs(I)>s?u[0]/I:Math.abs(M)>s?u[1]/M:0}var z,A,O=o.getDistance(a),T=s*O;if(T>b||T>C)b=C=O/3;else{var E=o.subtract(a);z=i.normalize(b),A=r.normalize(C),z.dot(E)-A.dot(E)>O*O&&(b=C=O/3,z=A=null)}return[a,a.add(z||i.normalize(b)),o.add(A||r.normalize(C)),o]},reparameterize:function(t,e,n,i){for(var r=t;e>=r;r++)n[r-t]=this.findRoot(i,this.points[r],n[r-t]);for(var r=1,s=n.length;s>r;r++)if(n[r]<=n[r-1])return!1;return!0},findRoot:function(t,e,n){for(var i=[],r=[],s=0;2>=s;s++)i[s]=t[s+1].subtract(t[s]).multiply(3);for(var s=0;1>=s;s++)r[s]=i[s+1].subtract(i[s]).multiply(2);var a=this.evaluate(3,t,n),o=this.evaluate(2,i,n),h=this.evaluate(1,r,n),u=a.subtract(e),l=o.dot(o)+u.dot(h);return Math.abs(l)<1e-6?n:n-u.dot(o)/l},evaluate:function(t,e,n){for(var i=e.slice(),r=1;t>=r;r++)for(var s=0;t-r>=s;s++)i[s]=i[s].multiply(1-n).add(i[s+1].multiply(n));return i[0]},chordLengthParameterize:function(t,e){for(var n=[0],i=t+1;e>=i;i++)n[i-t]=n[i-t-1]+this.points[i].getDistance(this.points[i-1]);for(var i=1,r=e-t;r>=i;i++)n[i]/=n[r];return n},findMaxError:function(t,e,n,i){for(var r=Math.floor((e-t+1)/2),s=0,a=t+1;e>a;a++){var o=this.evaluate(3,n,i[a-t]),h=o.subtract(this.points[a]),u=h.x*h.x+h.y*h.y;u>=s&&(s=u,r=a)}return{error:s,index:r}}}),L=m.extend({_class:"TextItem",_boundsSelected:!0,_applyMatrix:!1,_canApplyMatrix:!1,_serializeFields:{content:null},_boundsGetter:"getBounds",initialize:function(n){this._content="",this._lines=[];var i=n&&e.isPlainObject(n)&&n.x===t&&n.y===t;this._initialize(i&&n,!i&&h.read(arguments))},_equals:function(t){return this._content===t._content},_clone:function wt(t,e,n){return t.setContent(this._content),wt.base.call(this,t,e,n)},getContent:function(){return this._content},setContent:function(t){this._content=""+t,this._lines=this._content.split(/\r\n|\n|\r/gm),this._changed(265)},isEmpty:function(){return!this._content},getCharacterStyle:"#getStyle",setCharacterStyle:"#setStyle",getParagraphStyle:"#getStyle",setParagraphStyle:"#setStyle"}),N=L.extend({_class:"PointText",initialize:function(){L.apply(this,arguments)},clone:function(t){return this._clone(new N(m.NO_INSERT),t)},getPoint:function(){var t=this._matrix.getTranslation();return new u(t.x,t.y,this,"setPoint")},setPoint:function(){var t=h.read(arguments);this.translate(t.subtract(this._matrix.getTranslation()))},_draw:function(t){if(this._content){this._setStyles(t);var e=this._style,n=this._lines,i=e.getLeading(),r=t.shadowColor;t.font=e.getFontStyle(),t.textAlign=e.getJustification();for(var s=0,a=n.length;a>s;s++){t.shadowColor=r;var o=n[s];e.hasFill()&&(t.fillText(o,0,0),t.shadowColor="rgba(0,0,0,0)"),e.hasStroke()&&t.strokeText(o,0,0),t.translate(0,i)}}},_getBounds:function(t,e){var n=this._style,i=this._lines,r=i.length,s=n.getJustification(),a=n.getLeading(),o=this.getView().getTextWidth(n.getFontStyle(),i),h=0;"left"!==s&&(h-=o/("center"===s?2:1));var u=new d(h,r?-.75*a:0,o,r*a);return e?e._transformBounds(u,u):u}}),j=e.extend(new function(){function t(t){var e,i=t.match(/^#(\w{1,2})(\w{1,2})(\w{1,2})$/);if(i){e=[0,0,0];for(var r=0;3>r;r++){var s=i[r+1];e[r]=parseInt(1==s.length?s+s:s,16)/255}}else if(i=t.match(/^rgba?\((.*)\)$/)){e=i[1].split(",");for(var r=0,o=e.length;o>r;r++){var s=+e[r];e[r]=3>r?s/255:s}}else{var h=a[t];if(!h){n||(n=Y.getContext(1,1),n.globalCompositeOperation="copy"),n.fillStyle="rgba(0,0,0,0)",n.fillStyle=t,n.fillRect(0,0,1,1);var u=n.getImageData(0,0,1,1).data;h=a[t]=[u[0]/255,u[1]/255,u[2]/255]}e=h.slice()}return e}var n,i={gray:["gray"],rgb:["red","green","blue"],hsb:["hue","saturation","brightness"],hsl:["hue","saturation","lightness"],gradient:["gradient","origin","destination","highlight"]},r={},a={},u=[[0,3,1],[2,0,1],[1,0,3],[1,2,0],[3,1,0],[0,1,2]],l={"rgb-hsb":function(t,e,n){var i=Math.max(t,e,n),r=Math.min(t,e,n),s=i-r,a=0===s?0:60*(i==t?(e-n)/s+(n>e?6:0):i==e?(n-t)/s+2:(t-e)/s+4);return[a,0===i?0:s/i,i]},"hsb-rgb":function(t,e,n){t=(t/60%6+6)%6;var i=Math.floor(t),r=t-i,i=u[i],s=[n,n*(1-e),n*(1-e*r),n*(1-e*(1-r))];return[s[i[0]],s[i[1]],s[i[2]]]},"rgb-hsl":function(t,e,n){var i=Math.max(t,e,n),r=Math.min(t,e,n),s=i-r,a=0===s,o=a?0:60*(i==t?(e-n)/s+(n>e?6:0):i==e?(n-t)/s+2:(t-e)/s+4),h=(i+r)/2,u=a?0:.5>h?s/(i+r):s/(2-i-r);return[o,u,h]},"hsl-rgb":function(t,e,n){if(t=(t/360%1+1)%1,0===e)return[n,n,n];for(var i=[t+1/3,t,t-1/3],r=.5>n?n*(1+e):n+e-n*e,s=2*n-r,a=[],o=0;3>o;o++){var h=i[o];0>h&&(h+=1),h>1&&(h-=1),a[o]=1>6*h?s+6*(r-s)*h:1>2*h?r:2>3*h?s+(r-s)*(2/3-h)*6:s}return a},"rgb-gray":function(t,e,n){return[.2989*t+.587*e+.114*n]},"gray-rgb":function(t){return[t,t,t]},"gray-hsb":function(t){return[0,0,t]},"gray-hsl":function(t){return[0,0,t]},"gradient-rgb":function(){return[]},"rgb-gradient":function(){return[]}};return e.each(i,function(t,n){r[n]=[],e.each(t,function(t,s){var a=e.capitalize(t),o=/^(hue|saturation)$/.test(t),u=r[n][s]="gradient"===t?function(t){var e=this._components[0];return t=B.read(Array.isArray(t)?t:arguments,0,{readNull:!0}),e!==t&&(e&&e._removeOwner(this),t&&t._addOwner(this)),t}:"gradient"===n?function(){return h.read(arguments,0,{readNull:"highlight"===t,clone:!0})}:function(t){return null==t||isNaN(t)?0:t};this["get"+a]=function(){return this._type===n||o&&/^hs[bl]$/.test(this._type)?this._components[s]:this._convert(n)[s]},this["set"+a]=function(t){this._type===n||o&&/^hs[bl]$/.test(this._type)||(this._components=this._convert(n),this._properties=i[n],this._type=n),this._components[s]=u.call(this,t),this._changed()}},this)},{_class:"Color",_readIndex:!0,initialize:function c(e){var n,s,a,h,u=Array.prototype.slice,l=arguments,d=0;Array.isArray(e)&&(l=e,e=l[0]);var f=null!=e&&typeof e;if("string"===f&&e in i&&(n=e,e=l[1],Array.isArray(e)?(s=e,a=l[2]):(this.__read&&(d=1),l=u.call(l,1),f=typeof e)),!s){if(h="number"===f?l:"object"===f&&null!=e.length?e:null){n||(n=h.length>=3?"rgb":"gray");var g=i[n].length;a=h[g],this.__read&&(d+=h===arguments?g+(null!=a?1:0):1),h.length>g&&(h=u.call(h,0,g))}else if("string"===f)n="rgb",s=t(e),4===s.length&&(a=s[3],s.length--);else if("object"===f)if(e.constructor===c){if(n=e._type,s=e._components.slice(),a=e._alpha,"gradient"===n)for(var _=1,v=s.length;v>_;_++){var p=s[_];p&&(s[_]=p.clone())}}else if(e.constructor===B)n="gradient",h=l;else{n="hue"in e?"lightness"in e?"hsl":"hsb":"gradient"in e||"stops"in e||"radial"in e?"gradient":"gray"in e?"gray":"rgb";var m=i[n],y=r[n];this._components=s=[];for(var _=0,v=m.length;v>_;_++){var w=e[m[_]];null==w&&0===_&&"gradient"===n&&"stops"in e&&(w={stops:e.stops,radial:e.radial}),w=y[_].call(this,w),null!=w&&(s[_]=w)}a=e.alpha}this.__read&&n&&(d=1)}if(this._type=n||"rgb",this._id=o.get(c),!s){this._components=s=[];for(var y=r[this._type],_=0,v=y.length;v>_;_++){var w=y[_].call(this,h&&h[_]);null!=w&&(s[_]=w)}}this._components=s,this._properties=i[this._type],this._alpha=a,this.__read&&(this.__read=d)},_serialize:function(t,n){var i=this.getComponents();return e.serialize(/^(gray|rgb)$/.test(this._type)?i:[this._type].concat(i),t,!0,n)},_changed:function(){this._canvasStyle=null,this._owner&&this._owner._changed(65)},_convert:function(t){var e;return this._type===t?this._components.slice():(e=l[this._type+"-"+t])?e.apply(this,this._components):l["rgb-"+t].apply(this,l[this._type+"-rgb"].apply(this,this._components))},convert:function(t){return new j(t,this._convert(t),this._alpha)},getType:function(){return this._type},setType:function(t){this._components=this._convert(t),this._properties=i[t],this._type=t},getComponents:function(){var t=this._components.slice();return null!=this._alpha&&t.push(this._alpha),t},getAlpha:function(){return null!=this._alpha?this._alpha:1},setAlpha:function(t){this._alpha=null==t?null:Math.min(Math.max(t,0),1),this._changed()},hasAlpha:function(){return null!=this._alpha},equals:function(t){var n=e.isPlainValue(t,!0)?j.read(arguments):t;return n===this||n&&this._class===n._class&&this._type===n._type&&this._alpha===n._alpha&&e.equals(this._components,n._components)||!1},toString:function(){for(var t=this._properties,e=[],n="gradient"===this._type,i=s.instance,r=0,a=t.length;a>r;r++){var o=this._components[r];null!=o&&e.push(t[r]+": "+(n?o:i.number(o)))}return null!=this._alpha&&e.push("alpha: "+i.number(this._alpha)),"{ "+e.join(", ")+" }"},toCSS:function(t){function e(t){return Math.round(255*(0>t?0:t>1?1:t))}var n=this._convert("rgb"),i=t||null==this._alpha?1:this._alpha;return n=[e(n[0]),e(n[1]),e(n[2])],1>i&&n.push(0>i?0:i),t?"#"+((1<<24)+(n[0]<<16)+(n[1]<<8)+n[2]).toString(16).slice(1):(4==n.length?"rgba(":"rgb(")+n.join(",")+")"},toCanvasStyle:function(t){if(this._canvasStyle)return this._canvasStyle;if("gradient"!==this._type)return this._canvasStyle=this.toCSS();var e,n=this._components,i=n[0],r=i._stops,s=n[1],a=n[2];if(i._radial){var o=a.getDistance(s),h=n[3];if(h){var u=h.subtract(s);u.getLength()>o&&(h=s.add(u.normalize(o-.1)))}var l=h||s;e=t.createRadialGradient(l.x,l.y,0,s.x,s.y,o)}else e=t.createLinearGradient(s.x,s.y,a.x,a.y);for(var c=0,d=r.length;d>c;c++){var f=r[c];e.addColorStop(f._rampPoint,f._color.toCanvasStyle())}return this._canvasStyle=e},transform:function(t){if("gradient"===this._type){for(var e=this._components,n=1,i=e.length;i>n;n++){var r=e[n];t._transformPoint(r,r,!0)}this._changed()}},statics:{_types:i,random:function(){var t=Math.random;return new j(t(),t(),t())}}})},new function(){var t={add:function(t,e){return t+e},subtract:function(t,e){return t-e},multiply:function(t,e){return t*e},divide:function(t,e){return t/e}};return e.each(t,function(t,e){this[e]=function(e){e=j.read(arguments);for(var n=this._type,i=this._components,r=e._convert(n),s=0,a=i.length;a>s;s++)r[s]=t(i[s],r[s]);return new j(n,r,null!=this._alpha?t(this._alpha,e.getAlpha()):null)}},{})}),B=e.extend({_class:"Gradient",initialize:function(t,e){this._id=o.get(),t&&this._set(t)&&(t=e=null),this._stops||this.setStops(t||["white","black"]),null==this._radial&&this.setRadial("string"==typeof e&&"radial"===e||e||!1)},_serialize:function(t,n){return n.add(this,function(){return e.serialize([this._stops,this._radial],t,!0,n)})},_changed:function(){for(var t=0,e=this._owners&&this._owners.length;e>t;t++)this._owners[t]._changed()},_addOwner:function(t){this._owners||(this._owners=[]),this._owners.push(t)},_removeOwner:function(e){var n=this._owners?this._owners.indexOf(e):-1;-1!=n&&(this._owners.splice(n,1),0===this._owners.length&&(this._owners=t))},clone:function(){for(var t=[],e=0,n=this._stops.length;n>e;e++)t[e]=this._stops[e].clone();return new B(t,this._radial)},getStops:function(){return this._stops},setStops:function(e){if(this.stops)for(var n=0,i=this._stops.length;i>n;n++)this._stops[n]._owner=t;if(e.length<2)throw Error("Gradient stop list needs to contain at least two stops.");this._stops=R.readAll(e,0,{clone:!0});for(var n=0,i=this._stops.length;i>n;n++){var r=this._stops[n];r._owner=this,r._defaultRamp&&r.setRampPoint(n/(i-1))}this._changed()},getRadial:function(){return this._radial},setRadial:function(t){this._radial=t,this._changed()},equals:function(t){if(t===this)return!0;if(t&&this._class===t._class&&this._stops.length===t._stops.length){for(var e=0,n=this._stops.length;n>e;e++)if(!this._stops[e].equals(t._stops[e]))return!1;return!0}return!1}}),R=e.extend({_class:"GradientStop",initialize:function(e,n){if(e){var i,r;n===t&&Array.isArray(e)?(i=e[0],r=e[1]):e.color?(i=e.color,r=e.rampPoint):(i=e,r=n),this.setColor(i),this.setRampPoint(r)}},clone:function(){return new R(this._color.clone(),this._rampPoint)},_serialize:function(t,n){return e.serialize([this._color,this._rampPoint],t,!0,n)},_changed:function(){this._owner&&this._owner._changed(65)},getRampPoint:function(){return this._rampPoint},setRampPoint:function(t){this._defaultRamp=null==t,this._rampPoint=t||0,this._changed()},getColor:function(){return this._color},setColor:function(t){this._color=j.read(arguments),this._color===t&&(this._color=t.clone()),this._color._owner=this,this._changed()},equals:function(t){return t===this||t&&this._class===t._class&&this._color.equals(t._color)&&this._rampPoint==t._rampPoint||!1}}),D=e.extend(new function(){var n={fillColor:t,strokeColor:t,strokeWidth:1,strokeCap:"butt",strokeJoin:"miter",strokeScaling:!0,miterLimit:10,dashOffset:0,dashArray:[],windingRule:"nonzero",shadowColor:t,shadowBlur:0,shadowOffset:new h,selectedColor:t,fontFamily:"sans-serif",fontWeight:"normal",fontSize:12,font:"sans-serif",leading:null,justification:"left"},i={strokeWidth:97,strokeCap:97,strokeJoin:97,strokeScaling:105,miterLimit:97,fontFamily:9,fontWeight:9,fontSize:9,font:9,leading:9,justification:9},r={beans:!0},s={_defaults:n,_textDefaults:new e(n,{fillColor:new j}),beans:!0};return e.each(n,function(n,a){var o=/Color$/.test(a),u="shadowOffset"===a,l=e.capitalize(a),c=i[a],d="set"+l,f="get"+l;s[d]=function(e){var n=this._owner,i=n&&n._children;if(i&&i.length>0&&!(n instanceof O))for(var r=0,s=i.length;s>r;r++)i[r]._style[d](e);else{var h=this._values[a];h!==e&&(o&&(h&&(h._owner=t),e&&e.constructor===j&&(e._owner&&(e=e.clone()),e._owner=n)),this._values[a]=e,n&&n._changed(c||65))}},s[f]=function(n){var i,r=this._owner,s=r&&r._children;if(!s||0===s.length||n||r instanceof O){var i=this._values[a];if(i===t)i=this._defaults[a],i&&i.clone&&(i=i.clone());else{var l=o?j:u?h:null;!l||i&&i.constructor===l||(this._values[a]=i=l.read([i],0,{readNull:!0,clone:!0}),i&&o&&(i._owner=r))}return i}for(var c=0,d=s.length;d>c;c++){var g=s[c]._style[f]();if(0===c)i=g;else if(!e.equals(i,g))return t}return i},r[f]=function(t){return this._style[f](t)},r[d]=function(t){this._style[d](t)}}),m.inject(r),s},{_class:"Style",initialize:function(t,e,n){this._values={},this._owner=e,this._project=e&&e._project||n||paper.project,e instanceof L&&(this._defaults=this._textDefaults),t&&this.set(t)},set:function(t){var e=t instanceof D,n=e?t._values:t;if(n)for(var i in n)if(i in this._defaults){var r=n[i];this[i]=r&&e&&r.clone?r.clone():r}},equals:function(t){return t===this||t&&this._class===t._class&&e.equals(this._values,t._values)||!1},hasFill:function(){return!!this.getFillColor()},hasStroke:function(){return!!this.getStrokeColor()&&this.getStrokeWidth()>0},hasShadow:function(){return!!this.getShadowColor()&&this.getShadowBlur()>0},getView:function(){return this._project.getView()},getFontStyle:function(){var t=this.getFontSize();return this.getFontWeight()+" "+t+(/[a-z]/i.test(t+"")?" ":"px ")+this.getFontFamily()},getFont:"#getFontFamily",setFont:"#setFontFamily",getLeading:function xt(){var t=xt.base.call(this),e=this.getFontSize();return/pt|em|%|px/.test(e)&&(e=this.getView().getPixelSize(e)),null!=t?t:1.2*e}}),F=new function(){function t(t,e,n,i){for(var r=["","webkit","moz","Moz","ms","o"],s=e[0].toUpperCase()+e.substring(1),a=0;6>a;a++){var o=r[a],h=o?o+s:e;if(h in t){if(!n)return t[h];t[h]=i;break}}}return{getStyles:function(t){var e=t&&9!==t.nodeType?t.ownerDocument:t,n=e&&e.defaultView;return n&&n.getComputedStyle(t,"")},getBounds:function(t,e){var n,i=t.ownerDocument,r=i.body,s=i.documentElement;try{n=t.getBoundingClientRect()}catch(a){n={left:0,top:0,width:0,height:0}}var o=n.left-(s.clientLeft||r.clientLeft||0),h=n.top-(s.clientTop||r.clientTop||0);if(!e){var u=i.defaultView;o+=u.pageXOffset||s.scrollLeft||r.scrollLeft,h+=u.pageYOffset||s.scrollTop||r.scrollTop}return new d(o,h,n.width,n.height)},getViewportBounds:function(t){var e=t.ownerDocument,n=e.defaultView,i=e.documentElement;return new d(0,0,n.innerWidth||i.clientWidth,n.innerHeight||i.clientHeight)},getOffset:function(t,e){return F.getBounds(t,e).getPoint()},getSize:function(t){return F.getBounds(t,!0).getSize()},isInvisible:function(t){return F.getSize(t).equals(new l(0,0))},isInView:function(t){return!F.isInvisible(t)&&F.getViewportBounds(t).intersects(F.getBounds(t,!0))},getPrefixed:function(e,n){return t(e,n)},setPrefixed:function(e,n,i){if("object"==typeof n)for(var r in n)t(e,r,!0,n[r]);else t(e,n,!0,i)}}},q={add:function(t,e){for(var n in e)for(var i=e[n],r=n.split(/[\s,]+/g),s=0,a=r.length;a>s;s++)t.addEventListener(r[s],i,!1)},remove:function(t,e){for(var n in e)for(var i=e[n],r=n.split(/[\s,]+/g),s=0,a=r.length;a>s;s++)t.removeEventListener(r[s],i,!1)},getPoint:function(t){var e=t.targetTouches?t.targetTouches.length?t.targetTouches[0]:t.changedTouches[0]:t;return new h(e.pageX||e.clientX+document.documentElement.scrollLeft,e.pageY||e.clientY+document.documentElement.scrollTop)},getTarget:function(t){return t.target||t.srcElement},getRelatedTarget:function(t){return t.relatedTarget||t.toElement},getOffset:function(t,e){return q.getPoint(t).subtract(F.getOffset(e||q.getTarget(t)))},stop:function(t){t.stopPropagation(),t.preventDefault()}};q.requestAnimationFrame=new function(){function t(){for(var e=s.length-1;e>=0;e--){var o=s[e],h=o[0],u=o[1];(!u||("true"==i.getAttribute(u,"keepalive")||a)&&F.isInView(u))&&(s.splice(e,1),h())}n&&(s.length?n(t):r=!1)}var e,n=F.getPrefixed(window,"requestAnimationFrame"),r=!1,s=[],a=!0;return q.add(window,{focus:function(){a=!0},blur:function(){a=!1}}),function(i,a){s.push([i,a]),n?r||(n(t),r=!0):e||(e=setInterval(t,1e3/60))}};var V=e.extend(n,{_class:"View",initialize:function bt(t,e){function n(t){return e[t]||parseInt(e.getAttribute(t),10)}function r(){var t=F.getSize(e);return t.isNaN()||t.isZero()?new l(n("width"),n("height")):t}this._project=t,this._scope=t._scope,this._element=e;var s;this._pixelRatio||(this._pixelRatio=window.devicePixelRatio||1),this._id=e.getAttribute("id"),null==this._id&&e.setAttribute("id",this._id="view-"+bt._id++),q.add(e,this._viewEvents);var a="none";if(F.setPrefixed(e.style,{userSelect:a,touchAction:a,touchCallout:a,contentZooming:a,userDrag:a,tapHighlightColor:"rgba(0,0,0,0)"}),i.hasAttribute(e,"resize")){var o=this;q.add(window,this._windowEvents={resize:function(){o.setViewSize(r())}})}if(this._setViewSize(s=r()),i.hasAttribute(e,"stats")&&"undefined"!=typeof Stats){this._stats=new Stats;var h=this._stats.domElement,u=h.style,c=F.getOffset(e);u.position="absolute",u.left=c.x+"px",u.top=c.y+"px",document.body.appendChild(h)}bt._views.push(this),bt._viewsById[this._id]=this,this._viewSize=s,(this._matrix=new g)._owner=this,this._zoom=1,bt._focused||(bt._focused=this),this._frameItems={},this._frameItemCount=0},remove:function(){return this._project?(V._focused===this&&(V._focused=null),V._views.splice(V._views.indexOf(this),1),delete V._viewsById[this._id],this._project._view===this&&(this._project._view=null),q.remove(this._element,this._viewEvents),q.remove(window,this._windowEvents),this._element=this._project=null,this.off("frame"),this._animate=!1,this._frameItems={},!0):!1},_events:e.each(["onResize","onMouseDown","onMouseUp","onMouseMove"],function(t){this[t]={install:function(t){this._installEvent(t)},uninstall:function(t){this._uninstallEvent(t)}}},{onFrame:{install:function(){this.play()},uninstall:function(){this.pause()}}}),_animate:!1,_time:0,_count:0,_requestFrame:function(){var t=this;q.requestAnimationFrame(function(){t._requested=!1,t._animate&&(t._requestFrame(),t._handleFrame())},this._element),this._requested=!0},_handleFrame:function(){paper=this._scope;var t=Date.now()/1e3,n=this._before?t-this._before:0;this._before=t,this._handlingFrame=!0,this.emit("frame",new e({delta:n,time:this._time+=n,count:this._count++})),this._stats&&this._stats.update(),this._handlingFrame=!1,this.update()},_animateItem:function(t,e){var n=this._frameItems;e?(n[t._id]={item:t,time:0,count:0},1===++this._frameItemCount&&this.on("frame",this._handleFrameItems)):(delete n[t._id],0===--this._frameItemCount&&this.off("frame",this._handleFrameItems))},_handleFrameItems:function(t){for(var n in this._frameItems){var i=this._frameItems[n];i.item.emit("frame",new e(t,{time:i.time+=t.delta,count:i.count++}))}},_update:function(){this._project._needsUpdate=!0,this._handlingFrame||(this._animate?this._handleFrame():this.update())},_changed:function(t){1&t&&(this._project._needsUpdate=!0)},_transform:function(t){this._matrix.concatenate(t),this._bounds=null,this._update()},getElement:function(){return this._element},getPixelRatio:function(){return this._pixelRatio},getResolution:function(){return 72*this._pixelRatio},getViewSize:function(){var t=this._viewSize;return new c(t.width,t.height,this,"setViewSize")},setViewSize:function(){var t=l.read(arguments),e=t.subtract(this._viewSize);e.isZero()||(this._viewSize.set(t.width,t.height),this._setViewSize(t),this._bounds=null,this.emit("resize",{size:t,delta:e}),this._update())},_setViewSize:function(t){var e=this._element;e.width=t.width,e.height=t.height},getBounds:function(){return this._bounds||(this._bounds=this._matrix.inverted()._transformBounds(new d(new h,this._viewSize))),this._bounds},getSize:function(){return this.getBounds().getSize()},getCenter:function(){return this.getBounds().getCenter()},setCenter:function(){var t=h.read(arguments);this.scrollBy(t.subtract(this.getCenter()))},getZoom:function(){return this._zoom},setZoom:function(t){this._transform((new g).scale(t/this._zoom,this.getCenter())),this._zoom=t},isVisible:function(){return F.isInView(this._element)},scrollBy:function(){
this._transform((new g).translate(h.read(arguments).negate()))},play:function(){this._animate=!0,this._requested||this._requestFrame()},pause:function(){this._animate=!1},draw:function(){this.update()},projectToView:function(){return this._matrix._transformPoint(h.read(arguments))},viewToProject:function(){return this._matrix._inverseTransform(h.read(arguments))}},{statics:{_views:[],_viewsById:{},_id:0,create:function(t,e){return"string"==typeof e&&(e=document.getElementById(e)),new H(t,e)}}},new function(){function t(t){var e=q.getTarget(t);return e.getAttribute&&V._viewsById[e.getAttribute("id")]}function e(t,e){return t.viewToProject(q.getOffset(e,t._element))}function n(){if(!V._focused||!V._focused.isVisible())for(var t=0,e=V._views.length;e>t;t++){var n=V._views[t];if(n&&n.isVisible()){V._focused=a=n;break}}}function i(t,e,n){t._handleEvent("mousemove",e,n);var i=t._scope.tool;return i&&i._handleEvent(l&&i.responds("mousedrag")?"mousedrag":"mousemove",e,n),t.update(),i}var r,s,a,o,h,u,l=!1,c=window.navigator;c.pointerEnabled||c.msPointerEnabled?(o="pointerdown MSPointerDown",h="pointermove MSPointerMove",u="pointerup pointercancel MSPointerUp MSPointerCancel"):(o="touchstart",h="touchmove",u="touchend touchcancel","ontouchstart"in window&&c.userAgent.match(/mobile|tablet|ip(ad|hone|od)|android|silk/i)||(o+=" mousedown",h+=" mousemove",u+=" mouseup"));var d={"selectstart dragstart":function(t){l&&t.preventDefault()}},f={mouseout:function(t){var n=V._focused,r=q.getRelatedTarget(t);!n||r&&"HTML"!==r.nodeName||i(n,e(n,t),t)},scroll:n};d[o]=function(n){var i=V._focused=t(n),s=e(i,n);l=!0,i._handleEvent("mousedown",s,n),(r=i._scope.tool)&&r._handleEvent("mousedown",s,n),i.update()},f[h]=function(o){var h=V._focused;if(!l){var u=t(o);u?(h!==u&&i(h,e(h,o),o),s=h,h=V._focused=a=u):a&&a===h&&(h=V._focused=s,n())}if(h){var c=e(h,o);(l||h.getBounds().contains(c))&&(r=i(h,c,o))}},f[u]=function(t){var n=V._focused;if(n&&l){var i=e(n,t);l=!1,n._handleEvent("mouseup",i,t),r&&r._handleEvent("mouseup",i,t),n.update()}},q.add(document,f),q.add(window,{load:n});var g={mousedown:{mousedown:1,mousedrag:1,click:1,doubleclick:1},mouseup:{mouseup:1,mousedrag:1,click:1,doubleclick:1},mousemove:{mousedrag:1,mousemove:1,mouseenter:1,mouseleave:1}};return{_viewEvents:d,_handleEvent:function(){},_installEvent:function(t){var e=this._eventCounters;if(e)for(var n in g)e[n]=(e[n]||0)+(g[n][t]||0)},_uninstallEvent:function(t){var e=this._eventCounters;if(e)for(var n in g)e[n]-=g[n][t]||0},statics:{updateFocus:n}}}),H=V.extend({_class:"CanvasView",initialize:function(t,e){if(!(e instanceof HTMLCanvasElement)){var n=l.read(arguments,1);if(n.isZero())throw Error("Cannot create CanvasView with the provided argument: "+[].slice.call(arguments,1));e=Y.getCanvas(n)}if(this._context=e.getContext("2d"),this._eventCounters={},this._pixelRatio=1,!/^off|false$/.test(i.getAttribute(e,"hidpi"))){var r=window.devicePixelRatio||1,s=F.getPrefixed(this._context,"backingStorePixelRatio")||1;this._pixelRatio=r/s}V.call(this,t,e)},_setViewSize:function(t){var e=this._element,n=this._pixelRatio,r=t.width,s=t.height;if(e.width=r*n,e.height=s*n,1!==n){if(!i.hasAttribute(e,"resize")){var a=e.style;a.width=r+"px",a.height=s+"px"}this._context.scale(n,n)}},getPixelSize:function(t){var e,n=paper.browser;if(n&&n.firefox){var i=this._element.parentNode,r=document.createElement("div");r.style.fontSize=t,i.appendChild(r),e=parseFloat(F.getStyles(r).fontSize),i.removeChild(r)}else{var s=this._context,a=s.font;s.font=t+" serif",e=parseFloat(s.font),s.font=a}return e},getTextWidth:function(t,e){var n=this._context,i=n.font,r=0;n.font=t;for(var s=0,a=e.length;a>s;s++)r=Math.max(r,n.measureText(e[s]).width);return n.font=i,r},update:function(t){var e=this._project;if(!e||!t&&!e._needsUpdate)return!1;var n=this._context,i=this._viewSize;return n.clearRect(0,0,i.width+1,i.height+1),e.draw(n,this._matrix,this._pixelRatio),e._needsUpdate=!1,!0}},new function(){function e(e,n,i,r,s,a){function o(e){return e.responds(n)&&(h||(h=new G(n,i,r,s,a?r.subtract(a):null)),e.emit(n,h)&&h.isStopped)?(i.preventDefault(),!0):t}for(var h,u=s;u;){if(o(u))return!0;u=u.getParent()}return o(e)?!0:!1}var n,i,r,s,a,o,h,u,l;return{_handleEvent:function(t,c,d){if(this._eventCounters[t]){var f=this._project,g=f.hitTest(c,{tolerance:0,fill:!0,stroke:!0}),_=g&&g.item,v=!1;switch(t){case"mousedown":for(v=e(this,t,d,c,_),u=a==_&&Date.now()-l<300,s=a=_,n=i=r=c,h=!v&&_;h&&!h.responds("mousedrag");)h=h._parent;break;case"mouseup":v=e(this,t,d,c,_,n),h&&(i&&!i.equals(c)&&e(this,"mousedrag",d,c,h,i),_!==h&&(r=c,e(this,"mousemove",d,c,_,r))),!v&&_&&_===s&&(l=Date.now(),e(this,u&&s.responds("doubleclick")?"doubleclick":"click",d,n,_),u=!1),s=h=null;break;case"mousemove":h&&(v=e(this,"mousedrag",d,c,h,i)),v||(_!==o&&(r=c),v=e(this,t,d,c,_,r)),i=r=c,_!==o&&(e(this,"mouseleave",d,c,o),o=_,e(this,"mouseenter",d,c,_))}return v}}}}),Z=e.extend({_class:"Event",initialize:function(t){this.event=t},isPrevented:!1,isStopped:!1,preventDefault:function(){this.isPrevented=!0,this.event.preventDefault()},stopPropagation:function(){this.isStopped=!0,this.event.stopPropagation()},stop:function(){this.stopPropagation(),this.preventDefault()},getModifiers:function(){return W.modifiers}}),U=Z.extend({_class:"KeyEvent",initialize:function(t,e,n,i){Z.call(this,i),this.type=t?"keydown":"keyup",this.key=e,this.character=n},toString:function(){return"{ type: '"+this.type+"', key: '"+this.key+"', character: '"+this.character+"', modifiers: "+this.getModifiers()+" }"}}),W=new function(){function t(i,s,u,l){var c,d=u?String.fromCharCode(u):"",f=r[s],g=f||d.toLowerCase(),_=i?"keydown":"keyup",v=V._focused,p=v&&v.isVisible()&&v._scope,m=p&&p.tool;if(h[g]=i,i?o[s]=u:delete o[s],f&&(c=e.camelize(f))in a){a[c]=i;var y=paper.browser;if("command"===c&&y&&y.mac)if(i)n={};else{for(var w in n)w in o&&t(!1,w,n[w],l);n=null}}else i&&n&&(n[s]=u);m&&m.responds(_)&&(paper=p,m.emit(_,new U(i,g,d,l)),v&&v.update())}var n,i,r={8:"backspace",9:"tab",13:"enter",16:"shift",17:"control",18:"option",19:"pause",20:"caps-lock",27:"escape",32:"space",35:"end",36:"home",37:"left",38:"up",39:"right",40:"down",46:"delete",91:"command",93:"command",224:"command"},s={9:!0,13:!0,32:!0},a=new e({shift:!1,control:!1,option:!1,command:!1,capsLock:!1,space:!1}),o={},h={};return q.add(document,{keydown:function(e){var n=e.which||e.keyCode;n in r||a.command?t(!0,n,n in s||a.command?n:0,e):i=n},keypress:function(e){null!=i&&(t(!0,i,e.which||e.keyCode,e),i=null)},keyup:function(e){var n=e.which||e.keyCode;n in o&&t(!1,n,o[n],e)}}),q.add(window,{blur:function(e){for(var n in o)t(!1,n,o[n],e)}}),{modifiers:a,isDown:function(t){return!!h[t]}}},G=Z.extend({_class:"MouseEvent",initialize:function(t,e,n,i,r){Z.call(this,e),this.type=t,this.point=n,this.target=i,this.delta=r},toString:function(){return"{ type: '"+this.type+"', point: "+this.point+", target: "+this.target+(this.delta?", delta: "+this.delta:"")+", modifiers: "+this.getModifiers()+" }"}}),$=Z.extend({_class:"ToolEvent",_item:null,initialize:function(t,e,n){this.tool=t,this.type=e,this.event=n},_choosePoint:function(t,e){return t?t:e?e.clone():null},getPoint:function(){return this._choosePoint(this._point,this.tool._point)},setPoint:function(t){this._point=t},getLastPoint:function(){return this._choosePoint(this._lastPoint,this.tool._lastPoint)},setLastPoint:function(t){this._lastPoint=t},getDownPoint:function(){return this._choosePoint(this._downPoint,this.tool._downPoint)},setDownPoint:function(t){this._downPoint=t},getMiddlePoint:function(){return!this._middlePoint&&this.tool._lastPoint?this.tool._point.add(this.tool._lastPoint).divide(2):this._middlePoint},setMiddlePoint:function(t){this._middlePoint=t},getDelta:function(){return!this._delta&&this.tool._lastPoint?this.tool._point.subtract(this.tool._lastPoint):this._delta},setDelta:function(t){this._delta=t},getCount:function(){return/^mouse(down|up)$/.test(this.type)?this.tool._downCount:this.tool._count},setCount:function(t){this.tool[/^mouse(down|up)$/.test(this.type)?"downCount":"count"]=t},getItem:function(){if(!this._item){var t=this.tool._scope.project.hitTest(this.getPoint());if(t){for(var e=t.item,n=e._parent;/^(Group|CompoundPath)$/.test(n._class);)e=n,n=n._parent;this._item=e}}return this._item},setItem:function(t){this._item=t},toString:function(){return"{ type: "+this.type+", point: "+this.getPoint()+", count: "+this.getCount()+", modifiers: "+this.getModifiers()+" }"}}),X=r.extend({_class:"Tool",_list:"tools",_reference:"tool",_events:["onActivate","onDeactivate","onEditOptions","onMouseDown","onMouseUp","onMouseDrag","onMouseMove","onKeyDown","onKeyUp"],initialize:function(t){r.call(this),this._firstMove=!0,this._count=0,this._downCount=0,this._set(t)},getMinDistance:function(){return this._minDistance},setMinDistance:function(t){this._minDistance=t,null!=t&&null!=this._maxDistance&&t>this._maxDistance&&(this._maxDistance=t)},getMaxDistance:function(){return this._maxDistance},setMaxDistance:function(t){this._maxDistance=t,null!=this._minDistance&&null!=t&&t<this._minDistance&&(this._minDistance=t)},getFixedDistance:function(){return this._minDistance==this._maxDistance?this._minDistance:null},setFixedDistance:function(t){this._minDistance=this._maxDistance=t},_updateEvent:function(t,e,n,i,r,s,a){if(!r){if(null!=n||null!=i){var o=null!=n?n:0,h=e.subtract(this._point),u=h.getLength();if(o>u)return!1;if(null!=i&&0!=i)if(u>i)e=this._point.add(h.normalize(i));else if(a)return!1}if(s&&e.equals(this._point))return!1}switch(this._lastPoint=r&&"mousemove"==t?e:this._point,this._point=e,t){case"mousedown":this._lastPoint=this._downPoint,this._downPoint=this._point,this._downCount++;break;case"mouseup":this._lastPoint=this._downPoint}return this._count=r?0:this._count+1,!0},_fireEvent:function(t,e){var n=paper.project._removeSets;if(n){"mouseup"===t&&(n.mousedrag=null);var i=n[t];if(i){for(var r in i){var s=i[r];for(var a in n){var o=n[a];o&&o!=i&&delete o[s._id]}s.remove()}n[t]=null}}return this.responds(t)&&this.emit(t,new $(this,t,e))},_handleEvent:function(t,e,n){paper=this._scope;var i=!1;switch(t){case"mousedown":this._updateEvent(t,e,null,null,!0,!1,!1),i=this._fireEvent(t,n);break;case"mousedrag":for(var r=!1,s=!1;this._updateEvent(t,e,this.minDistance,this.maxDistance,!1,r,s);)i=this._fireEvent(t,n)||i,r=!0,s=!0;break;case"mouseup":!e.equals(this._point)&&this._updateEvent("mousedrag",e,this.minDistance,this.maxDistance,!1,!1,!1)&&(i=this._fireEvent("mousedrag",n)),this._updateEvent(t,e,null,this.maxDistance,!1,!1,!1),i=this._fireEvent(t,n)||i,this._updateEvent(t,e,null,null,!0,!1,!1),this._firstMove=!0;break;case"mousemove":for(;this._updateEvent(t,e,this.minDistance,this.maxDistance,this._firstMove,!0,!1);)i=this._fireEvent(t,n)||i,this._firstMove=!1}return i&&n.preventDefault(),i}}),J={request:function(e,n,i,r){r=r===t?!0:r;var s=new(window.ActiveXObject||XMLHttpRequest)("Microsoft.XMLHTTP");return s.open(e.toUpperCase(),n,r),"overrideMimeType"in s&&s.overrideMimeType("text/plain"),s.onreadystatechange=function(){if(4===s.readyState){var t=s.status;if(0!==t&&200!==t)throw Error("Could not load "+n+" (Error "+t+")");i.call(s,s.responseText)}},s.send(null)}},Y={canvases:[],getCanvas:function(t,e){var n,i=!0;"object"==typeof t&&(e=t.height,t=t.width),n=this.canvases.length?this.canvases.pop():document.createElement("canvas");var r=n.getContext("2d");return n.width===t&&n.height===e?i&&r.clearRect(0,0,t+1,e+1):(n.width=t,n.height=e),r.save(),n},getContext:function(t,e){return this.getCanvas(t,e).getContext("2d")},release:function(t){var e=t.canvas?t.canvas:t;e.getContext("2d").restore(),this.canvases.push(e)}},K=new function(){function t(t,e,n){return.2989*t+.587*e+.114*n}function n(e,n,i,r){var s=r-t(e,n,i);f=e+s,g=n+s,_=i+s;var r=t(f,g,_),a=v(f,g,_),o=p(f,g,_);if(0>a){var h=r-a;f=r+(f-r)*r/h,g=r+(g-r)*r/h,_=r+(_-r)*r/h}if(o>255){var u=255-r,l=o-r;f=r+(f-r)*u/l,g=r+(g-r)*u/l,_=r+(_-r)*u/l}}function i(t,e,n){return p(t,e,n)-v(t,e,n)}function r(t,e,n,i){var r,s=[t,e,n],a=p(t,e,n),o=v(t,e,n);o=o===t?0:o===e?1:2,a=a===t?0:a===e?1:2,r=0===v(o,a)?1===p(o,a)?2:1:0,s[a]>s[o]?(s[r]=(s[r]-s[o])*i/(s[a]-s[o]),s[a]=i):s[r]=s[a]=0,s[o]=0,f=s[0],g=s[1],_=s[2]}var s,a,o,h,u,l,c,d,f,g,_,v=Math.min,p=Math.max,m=Math.abs,y={multiply:function(){f=u*s/255,g=l*a/255,_=c*o/255},screen:function(){f=u+s-u*s/255,g=l+a-l*a/255,_=c+o-c*o/255},overlay:function(){f=128>u?2*u*s/255:255-2*(255-u)*(255-s)/255,g=128>l?2*l*a/255:255-2*(255-l)*(255-a)/255,_=128>c?2*c*o/255:255-2*(255-c)*(255-o)/255},"soft-light":function(){var t=s*u/255;f=t+u*(255-(255-u)*(255-s)/255-t)/255,t=a*l/255,g=t+l*(255-(255-l)*(255-a)/255-t)/255,t=o*c/255,_=t+c*(255-(255-c)*(255-o)/255-t)/255},"hard-light":function(){f=128>s?2*s*u/255:255-2*(255-s)*(255-u)/255,g=128>a?2*a*l/255:255-2*(255-a)*(255-l)/255,_=128>o?2*o*c/255:255-2*(255-o)*(255-c)/255},"color-dodge":function(){f=0===u?0:255===s?255:v(255,255*u/(255-s)),g=0===l?0:255===a?255:v(255,255*l/(255-a)),_=0===c?0:255===o?255:v(255,255*c/(255-o))},"color-burn":function(){f=255===u?255:0===s?0:p(0,255-255*(255-u)/s),g=255===l?255:0===a?0:p(0,255-255*(255-l)/a),_=255===c?255:0===o?0:p(0,255-255*(255-c)/o)},darken:function(){f=s>u?u:s,g=a>l?l:a,_=o>c?c:o},lighten:function(){f=u>s?u:s,g=l>a?l:a,_=c>o?c:o},difference:function(){f=u-s,0>f&&(f=-f),g=l-a,0>g&&(g=-g),_=c-o,0>_&&(_=-_)},exclusion:function(){f=u+s*(255-u-u)/255,g=l+a*(255-l-l)/255,_=c+o*(255-c-c)/255},hue:function(){r(s,a,o,i(u,l,c)),n(f,g,_,t(u,l,c))},saturation:function(){r(u,l,c,i(s,a,o)),n(f,g,_,t(u,l,c))},luminosity:function(){n(u,l,c,t(s,a,o))},color:function(){n(s,a,o,t(u,l,c))},add:function(){f=v(u+s,255),g=v(l+a,255),_=v(c+o,255)},subtract:function(){f=p(u-s,0),g=p(l-a,0),_=p(c-o,0)},average:function(){f=(u+s)/2,g=(l+a)/2,_=(c+o)/2},negation:function(){f=255-m(255-s-u),g=255-m(255-a-l),_=255-m(255-o-c)}},w=this.nativeModes=e.each(["source-over","source-in","source-out","source-atop","destination-over","destination-in","destination-out","destination-atop","lighter","darker","copy","xor"],function(t){this[t]=!0},{}),x=Y.getContext(1,1);e.each(y,function(t,e){var n="darken"===e,i=!1;x.save();try{x.fillStyle=n?"#300":"#a00",x.fillRect(0,0,1,1),x.globalCompositeOperation=e,x.globalCompositeOperation===e&&(x.fillStyle=n?"#a00":"#300",x.fillRect(0,0,1,1),i=x.getImageData(0,0,1,1).data[0]!==n?170:51)}catch(r){}x.restore(),w[e]=i}),Y.release(x),this.process=function(t,e,n,i,r){var v=e.canvas,p="normal"===t;if(p||w[t])n.save(),n.setTransform(1,0,0,1,0,0),n.globalAlpha=i,p||(n.globalCompositeOperation=t),n.drawImage(v,r.x,r.y),n.restore();else{var m=y[t];if(!m)return;for(var x=n.getImageData(r.x,r.y,v.width,v.height),b=x.data,C=e.getImageData(0,0,v.width,v.height).data,S=0,P=b.length;P>S;S+=4){s=C[S],u=b[S],a=C[S+1],l=b[S+1],o=C[S+2],c=b[S+2],h=C[S+3],d=b[S+3],m();var k=h*i/255,I=1-k;b[S]=k*f+I*u,b[S+1]=k*g+I*l,b[S+2]=k*_+I*c,b[S+3]=h*i+I*d}n.putImageData(x,r.x,r.y)}}},Q=e.each({fillColor:["fill","color"],strokeColor:["stroke","color"],strokeWidth:["stroke-width","number"],strokeCap:["stroke-linecap","string"],strokeJoin:["stroke-linejoin","string"],strokeScaling:["vector-effect","lookup",{"true":"none","false":"non-scaling-stroke"},function(t,e){return!e&&(t instanceof z||t instanceof x||t instanceof L)}],miterLimit:["stroke-miterlimit","number"],dashArray:["stroke-dasharray","array"],dashOffset:["stroke-dashoffset","number"],fontFamily:["font-family","string"],fontWeight:["font-weight","string"],fontSize:["font-size","number"],justification:["text-anchor","lookup",{left:"start",center:"middle",right:"end"}],opacity:["opacity","number"],blendMode:["mix-blend-mode","string"]},function(t,n){var i=e.capitalize(n),r=t[2];this[n]={type:t[1],property:n,attribute:t[0],toSVG:r,fromSVG:r&&e.each(r,function(t,e){this[t]=e},{}),exportFilter:t[3],get:"get"+i,set:"set"+i}},{}),tt={href:"http://www.w3.org/1999/xlink",xlink:"http://www.w3.org/2000/xmlns"};return new function(){function t(t,e){for(var n in e){var i=e[n],r=tt[n];"number"==typeof i&&(i=b.number(i)),r?t.setAttributeNS(r,n,i):t.setAttribute(n,i)}return t}function n(e,n){return t(document.createElementNS("http://www.w3.org/2000/svg",e),n)}function i(t,n,i){var r=new e,s=t.getTranslation();if(n){t=t.shiftless();var o=t._inverseTransform(s);r[i?"cx":"x"]=o.x,r[i?"cy":"y"]=o.y,s=null}if(!t.isIdentity()){var h=t.decompose();if(h&&!h.shearing){var u=[],l=h.rotation,c=h.scaling;s&&!s.isZero()&&u.push("translate("+b.point(s)+")"),a.isZero(c.x-1)&&a.isZero(c.y-1)||u.push("scale("+b.point(c)+")"),l&&u.push("rotate("+b.number(l)+")"),r.transform=u.join(" ")}else r.transform="matrix("+t.getValues().join(",")+")"}return r}function r(e,r){for(var s=i(e._matrix),a=e._children,o=n("g",s),h=0,u=a.length;u>h;h++){var l=a[h],c=w(l,r);if(c)if(l.isClipMask()){var d=n("clipPath");d.appendChild(c),p(l,d,"clip"),t(o,{"clip-path":"url(#"+d.id+")"})}else o.appendChild(c)}return o}function o(t,e){var r=i(t._matrix,!0),s=t.getSize(),a=t.getImage();return r.x-=s.width/2,r.y-=s.height/2,r.width=s.width,r.height=s.height,r.href=e.embedImages===!1&&a&&a.src||t.toDataURL(),n("image",r)}function h(t,e){var r=e.matchShapes;if(r){var s=t.toShape(!1);if(s)return u(s,e)}var a,o=t._segments,h=i(t._matrix);if(0===o.length)return null;if(r&&!t.hasHandles())if(o.length>=3){a=t._closed?"polygon":"polyline";for(var l=[],c=0,d=o.length;d>c;c++)l.push(b.point(o[c]._point));h.points=l.join(" ")}else{a="line";var f=o[0]._point,g=o[o.length-1]._point;h.set({x1:f.x,y1:f.y,x2:g.x,y2:g.y})}else a="path",h.d=t.getPathData(null,e.precision);return n(a,h)}function u(t){var e=t._type,r=t._radius,s=i(t._matrix,!0,"rectangle"!==e);if("rectangle"===e){e="rect";var a=t._size,o=a.width,h=a.height;s.x-=o/2,s.y-=h/2,s.width=o,s.height=h,r.isZero()&&(r=null)}return r&&("circle"===e?s.r=r:(s.rx=r.width,s.ry=r.height)),n(e,s)}function l(t,e){var r=i(t._matrix),s=t.getPathData(null,e.precision);return s&&(r.d=s),n("path",r)}function c(t,e){var r=i(t._matrix,!0),s=t.getSymbol(),a=_(s,"symbol"),o=s.getDefinition(),h=o.getBounds();return a||(a=n("symbol",{viewBox:b.rectangle(h)}),a.appendChild(w(o,e)),p(s,a,"symbol")),r.href="#"+a.id,r.x+=h.x,r.y+=h.y,r.width=b.number(h.width),r.height=b.number(h.height),r.overflow="visible",n("use",r)}function d(t){var e=_(t,"color");if(!e){var i,r=t.getGradient(),s=r._radial,a=t.getOrigin().transform(),o=t.getDestination().transform();if(s){i={cx:a.x,cy:a.y,r:a.getDistance(o)};var h=t.getHighlight();h&&(h=h.transform(),i.fx=h.x,i.fy=h.y)}else i={x1:a.x,y1:a.y,x2:o.x,y2:o.y};i.gradientUnits="userSpaceOnUse",e=n((s?"radial":"linear")+"Gradient",i);for(var u=r._stops,l=0,c=u.length;c>l;l++){var d=u[l],f=d._color,g=f.getAlpha();i={offset:d._rampPoint,"stop-color":f.toCSS(!0)},1>g&&(i["stop-opacity"]=g),e.appendChild(n("stop",i))}p(t,e,"color")}return"url(#"+e.id+")"}function f(t){var e=n("text",i(t._matrix,!0));return e.textContent=t._content,e}function g(n,i,r){var s={},a=!r&&n.getParent();return null!=n._name&&(s.id=n._name),e.each(Q,function(t){var i=t.get,r=t.type,o=n[i]();if(t.exportFilter?t.exportFilter(n,o):!a||!e.equals(a[i](),o)){if("color"===r&&null!=o){var h=o.getAlpha();1>h&&(s[t.attribute+"-opacity"]=h)}s[t.attribute]=null==o?"none":"number"===r?b.number(o):"color"===r?o.gradient?d(o,n):o.toCSS(!0):"array"===r?o.join(","):"lookup"===r?t.toSVG[o]:o}}),1===s.opacity&&delete s.opacity,n._visible||(s.visibility="hidden"),t(i,s)}function _(t,e){return C||(C={ids:{},svgs:{}}),t&&C.svgs[e+"-"+t._id]}function p(t,e,n){C||_();var i=C.ids[n]=(C.ids[n]||0)+1;e.id=n+"-"+i,C.svgs[n+"-"+t._id]=e}function y(t,e){var i=t,r=null;if(C){i="svg"===t.nodeName.toLowerCase()&&t;for(var s in C.svgs)r||(i||(i=n("svg"),i.appendChild(t)),r=i.insertBefore(n("defs"),i.firstChild)),r.appendChild(C.svgs[s]);C=null}return e.asString?(new XMLSerializer).serializeToString(i):i}function w(t,e,n){var i=S[t._class],r=i&&i(t,e);if(r){var s=e.onExport;s&&(r=s(t,r,e)||r);var a=JSON.stringify(t._data);a&&"{}"!==a&&"null"!==a&&r.setAttribute("data-paper-data",a)}return r&&g(t,r,n)}function x(t){return t||(t={}),b=new s(t.precision),t}var b,C,S={Group:r,Layer:r,Raster:o,Path:h,Shape:u,CompoundPath:l,PlacedSymbol:c,PointText:f};m.inject({exportSVG:function(t){return t=x(t),y(w(this,t,!0),t)}}),v.inject({exportSVG:function(t){t=x(t);var e=this.layers,r=this.getView(),s=r.getViewSize(),a=n("svg",{x:0,y:0,width:s.width,height:s.height,version:"1.1",xmlns:"http://www.w3.org/2000/svg","xmlns:xlink":"http://www.w3.org/1999/xlink"}),o=a,h=r._matrix;h.isIdentity()||(o=a.appendChild(n("g",i(h))));for(var u=0,l=e.length;l>u;u++)o.appendChild(w(e[u],t,!0));return y(a,t)}})},new function(){function n(t,e,n,i){var r=tt[e],s=r?t.getAttributeNS(r,e):t.getAttribute(e);return"null"===s&&(s=null),null==s?i?null:n?"":0:n?s:parseFloat(s)}function i(t,e,i,r){return e=n(t,e,!1,r),i=n(t,i,!1,r),!r||null!=e&&null!=i?new h(e,i):null}function r(t,e,i,r){return e=n(t,e,!1,r),i=n(t,i,!1,r),!r||null!=e&&null!=i?new l(e,i):null}function s(t,e,n){return"none"===t?null:"number"===e?parseFloat(t):"array"===e?t?t.split(/[\s,]+/g).map(parseFloat):[]:"color"===e?S(t)||t:"lookup"===e?n[t]:t}function a(t,e,n,i){var r=t.childNodes,s="clippath"===e,a=new y,o=a._project,h=o._currentStyle,u=[];if(s||(a=C(a,t,i),o._currentStyle=a._style.clone()),i)for(var l=t.querySelectorAll("defs"),c=0,d=l.length;d>c;c++)P(l[c],n,!1);for(var c=0,d=r.length;d>c;c++){var f,g=r[c];1!==g.nodeType||"defs"===g.nodeName.toLowerCase()||!(f=P(g,n,!1))||f instanceof p||u.push(f)}return a.addChildren(u),s&&(a=C(a.reduce(),t,i)),o._currentStyle=h,(s||"defs"===e)&&(a.remove(),a=null),a}function o(t,e){for(var n=t.getAttribute("points").match(/[+-]?(?:\d*\.\d+|\d+\.?)(?:[eE][+-]?\d+)?/g),i=[],r=0,s=n.length;s>r;r+=2)i.push(new h(parseFloat(n[r]),parseFloat(n[r+1])));var a=new A(i);return"polygon"===e&&a.closePath(),a}function u(t){var e=t.getAttribute("d"),n={pathData:e};return(e.match(/m/gi)||[]).length>1||/z\S+/i.test(e)?new O(n):new A(n)}function c(t,e){var r,s=(n(t,"href",!0)||"").substring(1),a="radialgradient"===e;if(s)r=M[s].getGradient();else{for(var o=t.childNodes,h=[],u=0,l=o.length;l>u;u++){var c=o[u];1===c.nodeType&&h.push(C(new R,c))}r=new B(h,a)}var d,f,g;return a?(d=i(t,"cx","cy"),f=d.add(n(t,"r"),0),g=i(t,"fx","fy",!0)):(d=i(t,"x1","y1"),f=i(t,"x2","y2")),C(new j(r,d,f,g),t),null}function f(t,e,n,i){for(var r=(i.getAttribute(n)||"").split(/\)\s*/g),s=new g,a=0,o=r.length;o>a;a++){var h=r[a];if(!h)break;for(var u=h.split(/\(\s*/),l=u[0],c=u[1].split(/[\s,]+/g),d=0,f=c.length;f>d;d++)c[d]=parseFloat(c[d]);switch(l){case"matrix":s.concatenate(new g(c[0],c[1],c[2],c[3],c[4],c[5]));break;case"rotate":s.rotate(c[0],c[1],c[2]);break;case"translate":s.translate(c[0],c[1]);break;case"scale":s.scale(c);break;case"skewX":s.skew(c[0],0);break;case"skewY":s.skew(0,c[0])}}t.transform(s)}function _(t,e,n){var i=t["fill-opacity"===n?"getFillColor":"getStrokeColor"]();i&&i.setAlpha(parseFloat(e))}function w(n,i,r){var s=n.attributes[i],a=s&&s.value;if(!a){var o=e.camelize(i);a=n.style[o],a||r.node[o]===r.parent[o]||(a=r.node[o])}return a?"none"===a?null:a:t}function C(n,i,r){var s={node:F.getStyles(i)||{},parent:!r&&F.getStyles(i.parentNode)||{}};return e.each(I,function(r,a){var o=w(i,a,s);o!==t&&(n=e.pick(r(n,o,a,i,s),n))}),n}function S(t){var e=t&&t.match(/\((?:#|)([^)']+)/);return e&&M[e[1]]}function P(t,n,i){function r(t){paper=a;var e=P(t,n,i),r=n.onLoad,s=a.project&&a.getView();r&&r.call(this,e),s.update()}if(!t)return null;n?"function"==typeof n&&(n={onLoad:n}):n={};var s=t,a=paper;if(i)if("string"!=typeof t||/^.*</.test(t)){if("undefined"!=typeof File&&t instanceof File){var o=new FileReader;return o.onload=function(){r(o.result)},o.readAsText(t)}}else{if(s=document.getElementById(t),!s)return J.request("get",t,r);t=null}if("string"==typeof t&&(s=(new DOMParser).parseFromString(t,"image/svg+xml")),!s.nodeName)throw Error("Unsupported SVG source: "+t);var h,u=s.nodeName.toLowerCase(),l=k[u],c=s.getAttribute&&s.getAttribute("data-paper-data"),d=a.settings,f=d.applyMatrix;if(d.applyMatrix=!1,h=l&&l(s,u,n,i)||null,d.applyMatrix=f,h){"#document"===u||h instanceof y||(h=C(h,s,i));var g=n.onImport;g&&(h=g(s,h,n)||h),n.expandShapes&&h instanceof x&&(h.remove(),h=h.toPath()),c&&(h._data=JSON.parse(c))}return i&&(M={},h&&e.pick(n.applyMatrix,f)&&h.matrix.apply(!0,!0)),h}var k={"#document":function(t,e,n,i){for(var r=t.childNodes,s=0,a=r.length;a>s;s++){var o=r[s];if(1===o.nodeType){var h=o.nextSibling;document.body.appendChild(o);var u=P(o,n,i);return h?t.insertBefore(o,h):t.appendChild(o),u}}},g:a,svg:a,clippath:a,polygon:o,polyline:o,path:u,lineargradient:c,radialgradient:c,image:function(t){var e=new b(n(t,"href",!0));return e.on("load",function(){var e=r(t,"width","height");this.setSize(e);var n=this._matrix._transformPoint(i(t,"x","y").add(e.divide(2)));this.translate(n)}),e},symbol:function(t,e,n,i){return new p(a(t,e,n,i),!0)},defs:a,use:function(t){var e=(n(t,"href",!0)||"").substring(1),r=M[e],s=i(t,"x","y");return r?r instanceof p?r.place(s):r.clone().translate(s):null},circle:function(t){return new x.Circle(i(t,"cx","cy"),n(t,"r"))},ellipse:function(t){return new x.Ellipse({center:i(t,"cx","cy"),radius:r(t,"rx","ry")})},rect:function(t){var e=i(t,"x","y"),n=r(t,"width","height"),s=r(t,"rx","ry");return new x.Rectangle(new d(e,n),s)},line:function(t){return new A.Line(i(t,"x1","y1"),i(t,"x2","y2"))},text:function(t){var e=new N(i(t,"x","y").add(i(t,"dx","dy")));return e.setContent(t.textContent.trim()||""),e}},I=e.set(e.each(Q,function(t){this[t.attribute]=function(e,n){if(e[t.set](s(n,t.type,t.fromSVG)),"color"===t.type&&e instanceof x){var i=e[t.get]();i&&i.transform((new g).translate(e.getPosition(!0).negate()))}}},{}),{id:function(t,e){M[e]=t,t.setName&&t.setName(e)},"clip-path":function(t,e){var n=S(e);if(n){if(n=n.clone(),n.setClipMask(!0),!(t instanceof y))return new y(n,t);t.insertChild(0,n)}},gradientTransform:f,transform:f,"fill-opacity":_,"stroke-opacity":_,visibility:function(t,e){t.setVisible("visible"===e)},display:function(t,e){t.setVisible(null!==e)},"stop-color":function(t,e){t.setColor&&t.setColor(e)},"stop-opacity":function(t,e){t._color&&t._color.setAlpha(parseFloat(e))},offset:function(t,e){var n=e.match(/(.*)%$/);t.setRampPoint(n?n[1]/100:parseFloat(e))},viewBox:function(t,e,n,i,a){var o=new d(s(e,"array")),h=r(i,"width","height",!0);if(t instanceof y){var u=h?o.getSize().divide(h):1,l=(new g).translate(o.getPoint()).scale(u);t.transform(l.inverted())}else if(t instanceof p){h&&o.setSize(h);var c="visible"!=w(i,"overflow",a),f=t._definition;c&&!o.contains(f.getBounds())&&(c=new x.Rectangle(o).transform(f._matrix),c.setClipMask(!0),f.addChild(c))}}}),M={};m.inject({importSVG:function(t,e){return this.addChild(P(t,e,!0))}}),v.inject({importSVG:function(t,e){return this.activate(),P(t,e,!0)}})},e.exports.PaperScript=function(){function t(t,e,n){var i=_[e];if(t&&t[i]){var r=t[i](n);return"!="===e?!r:r}switch(e){case"+":return t+n;case"-":return t-n;case"*":return t*n;case"/":return t/n;case"%":return t%n;case"==":return t==n;case"!=":return t!=n}}function n(t,e){var n=v[t];if(n&&e&&e[n])return e[n]();switch(t){case"+":return+e;case"-":return-e}}function r(t,e){return g.acorn.parse(t,e)}function s(t,e,n){function i(t){for(var e=0,n=u.length;n>e;e++){var i=u[e];if(i[0]>=t)break;t+=i[1]}return t}function s(e){return t.substring(i(e.range[0]),i(e.range[1]))}function a(e,n){return t.substring(i(e.range[1]),i(n.range[0]))}function o(e,n){for(var r=i(e.range[0]),s=i(e.range[1]),a=0,o=u.length-1;o>=0;o--)if(r>u[o][0]){a=o+1;break}u.splice(a,0,[r,n.length-s+r]),t=t.substring(0,r)+n+t.substring(s)}function h(t,e){if(t){for(var n in t)if("range"!==n&&"loc"!==n){var i=t[n];if(Array.isArray(i))for(var r=0,u=i.length;u>r;r++)h(i[r],t);else i&&"object"==typeof i&&h(i,t)}switch(t.type){case"UnaryExpression":if(t.operator in v&&"Literal"!==t.argument.type){var l=s(t.argument);o(t,'$__("'+t.operator+'", '+l+")")}break;case"BinaryExpression":if(t.operator in _&&"Literal"!==t.left.type){var c=s(t.left),d=s(t.right),f=a(t.left,t.right),g=t.operator;o(t,"__$__("+c+","+f.replace(RegExp("\\"+g),'"'+g+'"')+", "+d+")")}break;case"UpdateExpression":case"AssignmentExpression":var p=e&&e.type;if(!("ForStatement"===p||"BinaryExpression"===p&&/^[=!<>]/.test(e.operator)||"MemberExpression"===p&&e.computed))if("UpdateExpression"===t.type){var l=s(t.argument),m="__$__("+l+', "'+t.operator[0]+'", 1)',y=l+" = "+m;t.prefix||"AssignmentExpression"!==p&&"VariableDeclarator"!==p||(s(e.left||e.id)===l&&(y=m),y=l+"; "+y),o(t,y)}else if(/^.=$/.test(t.operator)&&"Literal"!==t.left.type){var c=s(t.left),d=s(t.right);o(t,c+" = __$__("+c+', "'+t.operator[0]+'", '+d+")")}}}}if(!t)return"";n=n||{},e=e||"";var u=[],l=null,c=paper.browser,d=c.versionNumber,f=/\r\n|\n|\r/gm;if(c.chrome&&d>=30||c.webkit&&d>=537.76||c.firefox&&d>=23){var g=0;if(0===window.location.href.indexOf(e)){var p=document.getElementsByTagName("html")[0].innerHTML;g=p.substr(0,p.indexOf(t)+1).match(f).length+1}var m=["AAAA"];m.length=(t.match(f)||[]).length+1+g,l={version:3,file:e,names:[],mappings:m.join(";AACA"),sourceRoot:"",sources:[e]};var y=n.source||!e&&t;y&&(l.sourcesContent=[y])}return h(r(t,{ranges:!0})),l&&(t=Array(g+1).join("\n")+t+"\n//# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(l))))+"\n//# sourceURL="+(e||"paperscript")),t}function a(i,r,a,o){function u(t,e){for(var n in t)!e&&/^_/.test(n)||!RegExp("([\\b\\s\\W]|^)"+n.replace(/\$/g,"\\$")+"\\b").test(i)||(_.push(n),v.push(t[n]))}paper=r;var l,c=r.getView(),d=/\s+on(?:Key|Mouse)(?:Up|Down|Move|Drag)\b/.test(i)?new X:null,f=d?d._events:[],g=["onFrame","onResize"].concat(f),_=[],v=[];i=s(i,a,o),u({__$__:t,$__:n,paper:r,view:c,tool:d},!0),u(r),g=e.each(g,function(t){RegExp("\\s+"+t+"\\b").test(i)&&(_.push(t),this.push(t+": "+t))},[]).join(", "),g&&(i+="\nreturn { "+g+" };");var p=paper.browser;if(p.chrome||p.firefox){var m=document.createElement("script"),y=document.head||document.getElementsByTagName("head")[0];p.firefox&&(i="\n"+i),m.appendChild(document.createTextNode("paper._execute = function("+_+") {"+i+"\n}")),y.appendChild(m),l=paper._execute,delete paper._execute,y.removeChild(m)}else l=Function(_,i);var w=l.apply(r,v)||{};e.each(f,function(t){var e=w[t];e&&(d[t]=e)}),c&&(w.onResize&&c.setOnResize(w.onResize),c.emit("resize",{size:c.size,delta:new h}),w.onFrame&&c.setOnFrame(w.onFrame),c.update())}function o(t){if(/^text\/(?:x-|)paperscript$/.test(t.type)&&"true"!==i.getAttribute(t,"ignore")){var e=i.getAttribute(t,"canvas"),n=document.getElementById(e),r=t.src||t.getAttribute("data-src"),s=i.hasAttribute(t,"async"),o="data-paper-scope";if(!n)throw Error('Unable to find canvas with id "'+e+'"');var h=i.get(n.getAttribute(o))||(new i).setup(n);return n.setAttribute(o,h._id),r?J.request("get",r,function(t){a(t,h,r)},s):a(t.innerHTML,h,t.baseURI),t.setAttribute("data-paper-ignore","true"),h}}function u(){e.each(document.getElementsByTagName("script"),o)}function c(t){return t?o(t):u()}var d,f,g=this;!function(t,e){return"object"==typeof d&&"object"==typeof module?e(d):"function"==typeof f&&f.amd?f(["exports"],e):void e(t.acorn||(t.acorn={}))}(this,function(t){"use strict";function e(t){ct=t||{};for(var e in _t)Object.prototype.hasOwnProperty.call(ct,e)||(ct[e]=_t[e]);gt=ct.sourceFile||null}function n(t,e){var n=vt(dt,t);e+=" ("+n.line+":"+n.column+")";var i=new SyntaxError(e);throw i.pos=t,i.loc=n,i.raisedAt=pt,i}function i(t){function e(t){if(1==t.length)return n+="return str === "+JSON.stringify(t[0])+";";n+="switch(str){";for(var e=0;e<t.length;++e)n+="case "+JSON.stringify(t[e])+":";n+="return true}return false;"}t=t.split(" ");var n="",i=[];t:for(var r=0;r<t.length;++r){for(var s=0;s<i.length;++s)if(i[s][0].length==t[r].length){i[s].push(t[r]);continue t}i.push([t[r]])}if(i.length>3){i.sort(function(t,e){return e.length-t.length}),n+="switch(str.length){";for(var r=0;r<i.length;++r){var a=i[r];n+="case "+a[0].length+":",
e(a)}n+="}"}else e(t);return Function("str",n)}function r(){this.line=Pt,this.column=pt-kt}function s(){Pt=1,pt=kt=0,St=!0,u()}function a(t,e){yt=pt,ct.locations&&(xt=new r),bt=t,u(),Ct=e,St=t.beforeExpr}function o(){var t=ct.onComment&&ct.locations&&new r,e=pt,i=dt.indexOf("*/",pt+=2);if(-1===i&&n(pt-2,"Unterminated comment"),pt=i+2,ct.locations){Je.lastIndex=e;for(var s;(s=Je.exec(dt))&&s.index<pt;)++Pt,kt=s.index+s[0].length}ct.onComment&&ct.onComment(!0,dt.slice(e+2,i),e,pt,t,ct.locations&&new r)}function h(){for(var t=pt,e=ct.onComment&&ct.locations&&new r,n=dt.charCodeAt(pt+=2);ft>pt&&10!==n&&13!==n&&8232!==n&&8233!==n;)++pt,n=dt.charCodeAt(pt);ct.onComment&&ct.onComment(!1,dt.slice(t+2,pt),t,pt,e,ct.locations&&new r)}function u(){for(;ft>pt;){var t=dt.charCodeAt(pt);if(32===t)++pt;else if(13===t){++pt;var e=dt.charCodeAt(pt);10===e&&++pt,ct.locations&&(++Pt,kt=pt)}else if(10===t||8232===t||8233===t)++pt,ct.locations&&(++Pt,kt=pt);else if(t>8&&14>t)++pt;else if(47===t){var e=dt.charCodeAt(pt+1);if(42===e)o();else{if(47!==e)break;h()}}else if(160===t)++pt;else{if(!(t>=5760&&Ze.test(String.fromCharCode(t))))break;++pt}}}function l(){var t=dt.charCodeAt(pt+1);return t>=48&&57>=t?S(!0):(++pt,a(we))}function c(){var t=dt.charCodeAt(pt+1);return St?(++pt,x()):61===t?w(Se,2):w(be,1)}function d(){var t=dt.charCodeAt(pt+1);return 61===t?w(Se,2):w(je,1)}function f(t){var e=dt.charCodeAt(pt+1);return e===t?w(124===t?Me:ze,2):61===e?w(Se,2):w(124===t?Ae:Te,1)}function g(){var t=dt.charCodeAt(pt+1);return 61===t?w(Se,2):w(Oe,1)}function _(t){var e=dt.charCodeAt(pt+1);return e===t?45==e&&62==dt.charCodeAt(pt+2)&&Xe.test(dt.slice(Mt,pt))?(pt+=3,h(),u(),y()):w(ke,2):61===e?w(Se,2):w(Pe,1)}function v(t){var e=dt.charCodeAt(pt+1),n=1;return e===t?(n=62===t&&62===dt.charCodeAt(pt+2)?3:2,61===dt.charCodeAt(pt+n)?w(Se,n+1):w(Ne,n)):33==e&&60==t&&45==dt.charCodeAt(pt+2)&&45==dt.charCodeAt(pt+3)?(pt+=4,h(),u(),y()):(61===e&&(n=61===dt.charCodeAt(pt+2)?3:2),w(Le,n))}function p(t){var e=dt.charCodeAt(pt+1);return 61===e?w(Ee,61===dt.charCodeAt(pt+2)?3:2):w(61===t?Ce:Ie,1)}function m(t){switch(t){case 46:return l();case 40:return++pt,a(_e);case 41:return++pt,a(ve);case 59:return++pt,a(me);case 44:return++pt,a(pe);case 91:return++pt,a(ce);case 93:return++pt,a(de);case 123:return++pt,a(fe);case 125:return++pt,a(ge);case 58:return++pt,a(ye);case 63:return++pt,a(xe);case 48:var e=dt.charCodeAt(pt+1);if(120===e||88===e)return C();case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:return S(!1);case 34:case 39:return P(t);case 47:return c(t);case 37:case 42:return d();case 124:case 38:return f(t);case 94:return g();case 43:case 45:return _(t);case 60:case 62:return v(t);case 61:case 33:return p(t);case 126:return w(Ie,1)}return!1}function y(t){if(t?pt=mt+1:mt=pt,ct.locations&&(wt=new r),t)return x();if(pt>=ft)return a(Rt);var e=dt.charCodeAt(pt);if(Ye(e)||92===e)return M();var i=m(e);if(i===!1){var s=String.fromCharCode(e);if("\\"===s||Ge.test(s))return M();n(pt,"Unexpected character '"+s+"'")}return i}function w(t,e){var n=dt.slice(pt,pt+e);pt+=e,a(t,n)}function x(){for(var t,e,i="",r=pt;;){pt>=ft&&n(r,"Unterminated regular expression");var s=dt.charAt(pt);if(Xe.test(s)&&n(r,"Unterminated regular expression"),t)t=!1;else{if("["===s)e=!0;else if("]"===s&&e)e=!1;else if("/"===s&&!e)break;t="\\"===s}++pt}var i=dt.slice(r,pt);++pt;var o=I();return o&&!/^[gmsiy]*$/.test(o)&&n(r,"Invalid regexp flag"),a(Nt,RegExp(i,o))}function b(t,e){for(var n=pt,i=0,r=0,s=null==e?1/0:e;s>r;++r){var a,o=dt.charCodeAt(pt);if(a=o>=97?o-97+10:o>=65?o-65+10:o>=48&&57>=o?o-48:1/0,a>=t)break;++pt,i=i*t+a}return pt===n||null!=e&&pt-n!==e?null:i}function C(){pt+=2;var t=b(16);return null==t&&n(mt+2,"Expected hexadecimal number"),Ye(dt.charCodeAt(pt))&&n(pt,"Identifier directly after number"),a(Lt,t)}function S(t){var e=pt,i=!1,r=48===dt.charCodeAt(pt);t||null!==b(10)||n(e,"Invalid number"),46===dt.charCodeAt(pt)&&(++pt,b(10),i=!0);var s=dt.charCodeAt(pt);(69===s||101===s)&&(s=dt.charCodeAt(++pt),(43===s||45===s)&&++pt,null===b(10)&&n(e,"Invalid number"),i=!0),Ye(dt.charCodeAt(pt))&&n(pt,"Identifier directly after number");var o,h=dt.slice(e,pt);return i?o=parseFloat(h):r&&1!==h.length?/[89]/.test(h)||Tt?n(e,"Invalid number"):o=parseInt(h,8):o=parseInt(h,10),a(Lt,o)}function P(t){pt++;for(var e="";;){pt>=ft&&n(mt,"Unterminated string constant");var i=dt.charCodeAt(pt);if(i===t)return++pt,a(jt,e);if(92===i){i=dt.charCodeAt(++pt);var r=/^[0-7]+/.exec(dt.slice(pt,pt+3));for(r&&(r=r[0]);r&&parseInt(r,8)>255;)r=r.slice(0,r.length-1);if("0"===r&&(r=null),++pt,r)Tt&&n(pt-2,"Octal literal in strict mode"),e+=String.fromCharCode(parseInt(r,8)),pt+=r.length-1;else switch(i){case 110:e+="\n";break;case 114:e+="\r";break;case 120:e+=String.fromCharCode(k(2));break;case 117:e+=String.fromCharCode(k(4));break;case 85:e+=String.fromCharCode(k(8));break;case 116:e+="	";break;case 98:e+="\b";break;case 118:e+="";break;case 102:e+="\f";break;case 48:e+="\x00";break;case 13:10===dt.charCodeAt(pt)&&++pt;case 10:ct.locations&&(kt=pt,++Pt);break;default:e+=String.fromCharCode(i)}}else(13===i||10===i||8232===i||8233===i)&&n(mt,"Unterminated string constant"),e+=String.fromCharCode(i),++pt}}function k(t){var e=b(16,t);return null===e&&n(mt,"Bad character escape sequence"),e}function I(){Re=!1;for(var t,e=!0,i=pt;;){var r=dt.charCodeAt(pt);if(Ke(r))Re&&(t+=dt.charAt(pt)),++pt;else{if(92!==r)break;Re||(t=dt.slice(i,pt)),Re=!0,117!=dt.charCodeAt(++pt)&&n(pt,"Expecting Unicode escape sequence \\uXXXX"),++pt;var s=k(4),a=String.fromCharCode(s);a||n(pt-1,"Invalid Unicode escape"),(e?Ye(s):Ke(s))||n(pt-4,"Invalid Unicode escape"),t+=a}e=!1}return Re?t:dt.slice(i,pt)}function M(){var t=I(),e=Bt;return Re||(He(t)?e=le[t]:(ct.forbidReserved&&(3===ct.ecmaVersion?De:Fe)(t)||Tt&&qe(t))&&n(mt,"The keyword '"+t+"' is reserved")),a(e,t)}function z(){It=mt,Mt=yt,zt=xt,y()}function A(t){if(Tt=t,pt=Mt,ct.locations)for(;kt>pt;)kt=dt.lastIndexOf("\n",kt-2)+1,--Pt;u(),y()}function O(){this.type=null,this.start=mt,this.end=null}function T(){this.start=wt,this.end=null,null!==gt&&(this.source=gt)}function E(){var t=new O;return ct.locations&&(t.loc=new T),ct.ranges&&(t.range=[mt,0]),t}function L(t){var e=new O;return e.start=t.start,ct.locations&&(e.loc=new T,e.loc.start=t.loc.start),ct.ranges&&(e.range=[t.range[0],0]),e}function N(t,e){return t.type=e,t.end=Mt,ct.locations&&(t.loc.end=zt),ct.ranges&&(t.range[1]=Mt),t}function j(t){return ct.ecmaVersion>=5&&"ExpressionStatement"===t.type&&"Literal"===t.expression.type&&"use strict"===t.expression.value}function B(t){return bt===t?(z(),!0):void 0}function R(){return!ct.strictSemicolons&&(bt===Rt||bt===ge||Xe.test(dt.slice(Mt,mt)))}function D(){B(me)||R()||q()}function F(t){bt===t?z():q()}function q(){n(mt,"Unexpected token")}function V(t){"Identifier"!==t.type&&"MemberExpression"!==t.type&&n(t.start,"Assigning to rvalue"),Tt&&"Identifier"===t.type&&Ve(t.name)&&n(t.start,"Assigning to "+t.name+" in strict mode")}function H(t){It=Mt=pt,ct.locations&&(zt=new r),At=Tt=null,Ot=[],y();var e=t||E(),n=!0;for(t||(e.body=[]);bt!==Rt;){var i=Z();e.body.push(i),n&&j(i)&&A(!0),n=!1}return N(e,"Program")}function Z(){(bt===be||bt===Se&&"/="==Ct)&&y(!0);var t=bt,e=E();switch(t){case Dt:case Vt:z();var i=t===Dt;B(me)||R()?e.label=null:bt!==Bt?q():(e.label=lt(),D());for(var r=0;r<Ot.length;++r){var s=Ot[r];if(null==e.label||s.name===e.label.name){if(null!=s.kind&&(i||"loop"===s.kind))break;if(e.label&&i)break}}return r===Ot.length&&n(e.start,"Unsyntactic "+t.keyword),N(e,i?"BreakStatement":"ContinueStatement");case Ht:return z(),D(),N(e,"DebuggerStatement");case Ut:return z(),Ot.push(Qe),e.body=Z(),Ot.pop(),F(ne),e.test=U(),D(),N(e,"DoWhileStatement");case $t:if(z(),Ot.push(Qe),F(_e),bt===me)return G(e,null);if(bt===ee){var a=E();return z(),X(a,!0),N(a,"VariableDeclaration"),1===a.declarations.length&&B(ue)?$(e,a):G(e,a)}var a=J(!1,!0);return B(ue)?(V(a),$(e,a)):G(e,a);case Xt:return z(),ht(e,!0);case Jt:return z(),e.test=U(),e.consequent=Z(),e.alternate=B(Wt)?Z():null,N(e,"IfStatement");case Yt:return At||n(mt,"'return' outside of function"),z(),B(me)||R()?e.argument=null:(e.argument=J(),D()),N(e,"ReturnStatement");case Kt:z(),e.discriminant=U(),e.cases=[],F(fe),Ot.push(tn);for(var o,h;bt!=ge;)if(bt===Ft||bt===Zt){var u=bt===Ft;o&&N(o,"SwitchCase"),e.cases.push(o=E()),o.consequent=[],z(),u?o.test=J():(h&&n(It,"Multiple default clauses"),h=!0,o.test=null),F(ye)}else o||q(),o.consequent.push(Z());return o&&N(o,"SwitchCase"),z(),Ot.pop(),N(e,"SwitchStatement");case Qt:return z(),Xe.test(dt.slice(Mt,mt))&&n(Mt,"Illegal newline after throw"),e.argument=J(),D(),N(e,"ThrowStatement");case te:if(z(),e.block=W(),e.handler=null,bt===qt){var l=E();z(),F(_e),l.param=lt(),Tt&&Ve(l.param.name)&&n(l.param.start,"Binding "+l.param.name+" in strict mode"),F(ve),l.guard=null,l.body=W(),e.handler=N(l,"CatchClause")}return e.guardedHandlers=Et,e.finalizer=B(Gt)?W():null,e.handler||e.finalizer||n(e.start,"Missing catch or finally clause"),N(e,"TryStatement");case ee:return z(),X(e),D(),N(e,"VariableDeclaration");case ne:return z(),e.test=U(),Ot.push(Qe),e.body=Z(),Ot.pop(),N(e,"WhileStatement");case ie:return Tt&&n(mt,"'with' in strict mode"),z(),e.object=U(),e.body=Z(),N(e,"WithStatement");case fe:return W();case me:return z(),N(e,"EmptyStatement");default:var c=Ct,d=J();if(t===Bt&&"Identifier"===d.type&&B(ye)){for(var r=0;r<Ot.length;++r)Ot[r].name===c&&n(d.start,"Label '"+c+"' is already declared");var f=bt.isLoop?"loop":bt===Kt?"switch":null;return Ot.push({name:c,kind:f}),e.body=Z(),Ot.pop(),e.label=d,N(e,"LabeledStatement")}return e.expression=d,D(),N(e,"ExpressionStatement")}}function U(){F(_e);var t=J();return F(ve),t}function W(t){var e,n=E(),i=!0,r=!1;for(n.body=[],F(fe);!B(ge);){var s=Z();n.body.push(s),i&&t&&j(s)&&(e=r,A(r=!0)),i=!1}return r&&!e&&A(!1),N(n,"BlockStatement")}function G(t,e){return t.init=e,F(me),t.test=bt===me?null:J(),F(me),t.update=bt===ve?null:J(),F(ve),t.body=Z(),Ot.pop(),N(t,"ForStatement")}function $(t,e){return t.left=e,t.right=J(),F(ve),t.body=Z(),Ot.pop(),N(t,"ForInStatement")}function X(t,e){for(t.declarations=[],t.kind="var";;){var i=E();if(i.id=lt(),Tt&&Ve(i.id.name)&&n(i.id.start,"Binding "+i.id.name+" in strict mode"),i.init=B(Ce)?J(!0,e):null,t.declarations.push(N(i,"VariableDeclarator")),!B(pe))break}return t}function J(t,e){var n=Y(e);if(!t&&bt===pe){var i=L(n);for(i.expressions=[n];B(pe);)i.expressions.push(Y(e));return N(i,"SequenceExpression")}return n}function Y(t){var e=K(t);if(bt.isAssign){var n=L(e);return n.operator=Ct,n.left=e,z(),n.right=Y(t),V(e),N(n,"AssignmentExpression")}return e}function K(t){var e=Q(t);if(B(xe)){var n=L(e);return n.test=e,n.consequent=J(!0),F(ye),n.alternate=J(!0,t),N(n,"ConditionalExpression")}return e}function Q(t){return tt(et(),-1,t)}function tt(t,e,n){var i=bt.binop;if(null!=i&&(!n||bt!==ue)&&i>e){var r=L(t);r.left=t,r.operator=Ct,z(),r.right=tt(et(),i,n);var s=N(r,/&&|\|\|/.test(r.operator)?"LogicalExpression":"BinaryExpression");return tt(s,e,n)}return t}function et(){if(bt.prefix){var t=E(),e=bt.isUpdate;return t.operator=Ct,t.prefix=!0,St=!0,z(),t.argument=et(),e?V(t.argument):Tt&&"delete"===t.operator&&"Identifier"===t.argument.type&&n(t.start,"Deleting local variable in strict mode"),N(t,e?"UpdateExpression":"UnaryExpression")}for(var i=nt();bt.postfix&&!R();){var t=L(i);t.operator=Ct,t.prefix=!1,t.argument=i,V(i),z(),i=N(t,"UpdateExpression")}return i}function nt(){return it(rt())}function it(t,e){if(B(we)){var n=L(t);return n.object=t,n.property=lt(!0),n.computed=!1,it(N(n,"MemberExpression"),e)}if(B(ce)){var n=L(t);return n.object=t,n.property=J(),n.computed=!0,F(de),it(N(n,"MemberExpression"),e)}if(!e&&B(_e)){var n=L(t);return n.callee=t,n.arguments=ut(ve,!1),it(N(n,"CallExpression"),e)}return t}function rt(){switch(bt){case se:var t=E();return z(),N(t,"ThisExpression");case Bt:return lt();case Lt:case jt:case Nt:var t=E();return t.value=Ct,t.raw=dt.slice(mt,yt),z(),N(t,"Literal");case ae:case oe:case he:var t=E();return t.value=bt.atomValue,t.raw=bt.keyword,z(),N(t,"Literal");case _e:var e=wt,n=mt;z();var i=J();return i.start=n,i.end=yt,ct.locations&&(i.loc.start=e,i.loc.end=xt),ct.ranges&&(i.range=[n,yt]),F(ve),i;case ce:var t=E();return z(),t.elements=ut(de,!0,!0),N(t,"ArrayExpression");case fe:return at();case Xt:var t=E();return z(),ht(t,!1);case re:return st();default:q()}}function st(){var t=E();return z(),t.callee=it(rt(),!0),t.arguments=B(_e)?ut(ve,!1):Et,N(t,"NewExpression")}function at(){var t=E(),e=!0,i=!1;for(t.properties=[],z();!B(ge);){if(e)e=!1;else if(F(pe),ct.allowTrailingCommas&&B(ge))break;var r,s={key:ot()},a=!1;if(B(ye)?(s.value=J(!0),r=s.kind="init"):ct.ecmaVersion>=5&&"Identifier"===s.key.type&&("get"===s.key.name||"set"===s.key.name)?(a=i=!0,r=s.kind=s.key.name,s.key=ot(),bt!==_e&&q(),s.value=ht(E(),!1)):q(),"Identifier"===s.key.type&&(Tt||i))for(var o=0;o<t.properties.length;++o){var h=t.properties[o];if(h.key.name===s.key.name){var u=r==h.kind||a&&"init"===h.kind||"init"===r&&("get"===h.kind||"set"===h.kind);u&&!Tt&&"init"===r&&"init"===h.kind&&(u=!1),u&&n(s.key.start,"Redefinition of property")}}t.properties.push(s)}return N(t,"ObjectExpression")}function ot(){return bt===Lt||bt===jt?rt():lt(!0)}function ht(t,e){bt===Bt?t.id=lt():e?q():t.id=null,t.params=[];var i=!0;for(F(_e);!B(ve);)i?i=!1:F(pe),t.params.push(lt());var r=At,s=Ot;if(At=!0,Ot=[],t.body=W(!0),At=r,Ot=s,Tt||t.body.body.length&&j(t.body.body[0]))for(var a=t.id?-1:0;a<t.params.length;++a){var o=0>a?t.id:t.params[a];if((qe(o.name)||Ve(o.name))&&n(o.start,"Defining '"+o.name+"' in strict mode"),a>=0)for(var h=0;a>h;++h)o.name===t.params[h].name&&n(o.start,"Argument name clash in strict mode")}return N(t,e?"FunctionDeclaration":"FunctionExpression")}function ut(t,e,n){for(var i=[],r=!0;!B(t);){if(r)r=!1;else if(F(pe),e&&ct.allowTrailingCommas&&B(t))break;n&&bt===pe?i.push(null):i.push(J(!0))}return i}function lt(t){var e=E();return e.name=bt===Bt?Ct:t&&!ct.forbidReserved&&bt.keyword||q(),St=!1,z(),N(e,"Identifier")}t.version="0.4.0";var ct,dt,ft,gt;t.parse=function(t,n){return dt=t+"",ft=dt.length,e(n),s(),H(ct.program)};var _t=t.defaultOptions={ecmaVersion:5,strictSemicolons:!1,allowTrailingCommas:!0,forbidReserved:!1,locations:!1,onComment:null,ranges:!1,program:null,sourceFile:null},vt=t.getLineInfo=function(t,e){for(var n=1,i=0;;){Je.lastIndex=i;var r=Je.exec(t);if(!(r&&r.index<e))break;++n,i=r.index+r[0].length}return{line:n,column:e-i}};t.tokenize=function(t,n){function i(t){return y(t),r.start=mt,r.end=yt,r.startLoc=wt,r.endLoc=xt,r.type=bt,r.value=Ct,r}dt=t+"",ft=dt.length,e(n),s();var r={};return i.jumpTo=function(t,e){if(pt=t,ct.locations){Pt=1,kt=Je.lastIndex=0;for(var n;(n=Je.exec(dt))&&n.index<t;)++Pt,kt=n.index+n[0].length}St=e,u()},i};var pt,mt,yt,wt,xt,bt,Ct,St,Pt,kt,It,Mt,zt,At,Ot,Tt,Et=[],Lt={type:"num"},Nt={type:"regexp"},jt={type:"string"},Bt={type:"name"},Rt={type:"eof"},Dt={keyword:"break"},Ft={keyword:"case",beforeExpr:!0},qt={keyword:"catch"},Vt={keyword:"continue"},Ht={keyword:"debugger"},Zt={keyword:"default"},Ut={keyword:"do",isLoop:!0},Wt={keyword:"else",beforeExpr:!0},Gt={keyword:"finally"},$t={keyword:"for",isLoop:!0},Xt={keyword:"function"},Jt={keyword:"if"},Yt={keyword:"return",beforeExpr:!0},Kt={keyword:"switch"},Qt={keyword:"throw",beforeExpr:!0},te={keyword:"try"},ee={keyword:"var"},ne={keyword:"while",isLoop:!0},ie={keyword:"with"},re={keyword:"new",beforeExpr:!0},se={keyword:"this"},ae={keyword:"null",atomValue:null},oe={keyword:"true",atomValue:!0},he={keyword:"false",atomValue:!1},ue={keyword:"in",binop:7,beforeExpr:!0},le={"break":Dt,"case":Ft,"catch":qt,"continue":Vt,"debugger":Ht,"default":Zt,"do":Ut,"else":Wt,"finally":Gt,"for":$t,"function":Xt,"if":Jt,"return":Yt,"switch":Kt,"throw":Qt,"try":te,"var":ee,"while":ne,"with":ie,"null":ae,"true":oe,"false":he,"new":re,"in":ue,"instanceof":{keyword:"instanceof",binop:7,beforeExpr:!0},"this":se,"typeof":{keyword:"typeof",prefix:!0,beforeExpr:!0},"void":{keyword:"void",prefix:!0,beforeExpr:!0},"delete":{keyword:"delete",prefix:!0,beforeExpr:!0}},ce={type:"[",beforeExpr:!0},de={type:"]"},fe={type:"{",beforeExpr:!0},ge={type:"}"},_e={type:"(",beforeExpr:!0},ve={type:")"},pe={type:",",beforeExpr:!0},me={type:";",beforeExpr:!0},ye={type:":",beforeExpr:!0},we={type:"."},xe={type:"?",beforeExpr:!0},be={binop:10,beforeExpr:!0},Ce={isAssign:!0,beforeExpr:!0},Se={isAssign:!0,beforeExpr:!0},Pe={binop:9,prefix:!0,beforeExpr:!0},ke={postfix:!0,prefix:!0,isUpdate:!0},Ie={prefix:!0,beforeExpr:!0},Me={binop:1,beforeExpr:!0},ze={binop:2,beforeExpr:!0},Ae={binop:3,beforeExpr:!0},Oe={binop:4,beforeExpr:!0},Te={binop:5,beforeExpr:!0},Ee={binop:6,beforeExpr:!0},Le={binop:7,beforeExpr:!0},Ne={binop:8,beforeExpr:!0},je={binop:10,beforeExpr:!0};t.tokTypes={bracketL:ce,bracketR:de,braceL:fe,braceR:ge,parenL:_e,parenR:ve,comma:pe,semi:me,colon:ye,dot:we,question:xe,slash:be,eq:Ce,name:Bt,eof:Rt,num:Lt,regexp:Nt,string:jt};for(var Be in le)t.tokTypes["_"+Be]=le[Be];var Re,De=i("abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile"),Fe=i("class enum extends super const export import"),qe=i("implements interface let package private protected public static yield"),Ve=i("eval arguments"),He=i("break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this"),Ze=/[\u1680\u180e\u2000-\u200a\u202f\u205f\u3000\ufeff]/,Ue="\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05d0-\u05ea\u05f0-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u08a0\u08a2-\u08ac\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0977\u0979-\u097f\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3d\u0c58\u0c59\u0c60\u0c61\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d60\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e87\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa\u0eab\u0ead-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f4\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f0\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1877\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191c\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19c1-\u19c7\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1ce9-\u1cec\u1cee-\u1cf1\u1cf5\u1cf6\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u212d\u212f-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2e2f\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309d-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312d\u3131-\u318e\u31a0-\u31ba\u31f0-\u31ff\u3400-\u4db5\u4e00-\u9fcc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua697\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua78e\ua790-\ua793\ua7a0-\ua7aa\ua7f8-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa80-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uabc0-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc",We="\u0300-\u036f\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u0620-\u0649\u0672-\u06d3\u06e7-\u06e8\u06fb-\u06fc\u0730-\u074a\u0800-\u0814\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0840-\u0857\u08e4-\u08fe\u0900-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962-\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09d7\u09df-\u09e0\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2-\u0ae3\u0ae6-\u0aef\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b56\u0b57\u0b5f-\u0b60\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c01-\u0c03\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62-\u0c63\u0c66-\u0c6f\u0c82\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2-\u0ce3\u0ce6-\u0cef\u0d02\u0d03\u0d46-\u0d48\u0d57\u0d62-\u0d63\u0d66-\u0d6f\u0d82\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0df2\u0df3\u0e34-\u0e3a\u0e40-\u0e45\u0e50-\u0e59\u0eb4-\u0eb9\u0ec8-\u0ecd\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f41-\u0f47\u0f71-\u0f84\u0f86-\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u1000-\u1029\u1040-\u1049\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u170e-\u1710\u1720-\u1730\u1740-\u1750\u1772\u1773\u1780-\u17b2\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u1920-\u192b\u1930-\u193b\u1951-\u196d\u19b0-\u19c0\u19c8-\u19c9\u19d0-\u19d9\u1a00-\u1a15\u1a20-\u1a53\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1b46-\u1b4b\u1b50-\u1b59\u1b6b-\u1b73\u1bb0-\u1bb9\u1be6-\u1bf3\u1c00-\u1c22\u1c40-\u1c49\u1c5b-\u1c7d\u1cd0-\u1cd2\u1d00-\u1dbe\u1e01-\u1f15\u200c\u200d\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2d81-\u2d96\u2de0-\u2dff\u3021-\u3028\u3099\u309a\ua640-\ua66d\ua674-\ua67d\ua69f\ua6f0-\ua6f1\ua7f8-\ua800\ua806\ua80b\ua823-\ua827\ua880-\ua881\ua8b4-\ua8c4\ua8d0-\ua8d9\ua8f3-\ua8f7\ua900-\ua909\ua926-\ua92d\ua930-\ua945\ua980-\ua983\ua9b3-\ua9c0\uaa00-\uaa27\uaa40-\uaa41\uaa4c-\uaa4d\uaa50-\uaa59\uaa7b\uaae0-\uaae9\uaaf2-\uaaf3\uabc0-\uabe1\uabec\uabed\uabf0-\uabf9\ufb20-\ufb28\ufe00-\ufe0f\ufe20-\ufe26\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f",Ge=RegExp("["+Ue+"]"),$e=RegExp("["+Ue+We+"]"),Xe=/[\n\r\u2028\u2029]/,Je=/\r\n|[\n\r\u2028\u2029]/g,Ye=t.isIdentifierStart=function(t){return 65>t?36===t:91>t?!0:97>t?95===t:123>t?!0:t>=170&&Ge.test(String.fromCharCode(t))},Ke=t.isIdentifierChar=function(t){return 48>t?36===t:58>t?!0:65>t?!1:91>t?!0:97>t?95===t:123>t?!0:t>=170&&$e.test(String.fromCharCode(t))},Qe={kind:"loop"},tn={kind:"switch"}});var _={"+":"__add","-":"__subtract","*":"__multiply","/":"__divide","%":"__modulo","==":"equals","!=":"equals"},v={"-":"__negate","+":null},p=e.each(["add","subtract","multiply","divide","modulo","negate"],function(t){this["__"+t]="#"+t},{});return h.inject(p),l.inject(p),j.inject(p),"complete"===document.readyState?setTimeout(u):q.add(window,{load:u}),{compile:s,execute:a,load:c,parse:r}}.call(this),paper=new(i.inject(e.exports,{enumerable:!0,Base:e,Numerical:a,Key:W})),"function"==typeof define&&define.amd?define("paper",paper):"object"==typeof module&&module&&(module.exports=paper),paper};