{
  "package": "vector_tile",
  "imports": [],
  "enums": [],
  "messages": [
    {
      "name": "Tile",
      "enums": [
        {
          "name": "GeomType",
          "values": {
            "UNKNOWN": 0,
            "POINT": 1,
            "LINESTRING": 2,
            "POLYGON": 3
          }
        }
      ],
      "oneof": [],
      "messages": [
        {
          "name": "Value",
          "enums": [],
          "oneof": [],
          "messages": [],
          "fields": [
            {
              "name": "string_value",
              "type": "string",
              "tag": 1,
              "required": false,
              "repeated": false,
              "options": {}
            },
            {
              "name": "float_value",
              "type": "float",
              "tag": 2,
              "required": false,
              "repeated": false,
              "options": {}
            },
            {
              "name": "double_value",
              "type": "double",
              "tag": 3,
              "required": false,
              "repeated": false,
              "options": {}
            },
            {
              "name": "int_value",
              "type": "int64",
              "tag": 4,
              "required": false,
              "repeated": false,
              "options": {}
            },
            {
              "name": "uint_value",
              "type": "uint64",
              "tag": 5,
              "required": false,
              "repeated": false,
              "options": {}
            },
            {
              "name": "sint_value",
              "type": "sint64",
              "tag": 6,
              "required": false,
              "repeated": false,
              "options": {}
            },
            {
              "name": "bool_value",
              "type": "bool",
              "tag": 7,
              "required": false,
              "repeated": false,
              "options": {}
            }
          ],
          "extensions": {
            "from": 8,
            "to": 536870911
          }
        },
        {
          "name": "Feature",
          "enums": [],
          "oneof": [],
          "messages": [],
          "fields": [
            {
              "name": "id",
              "type": "uint64",
              "tag": 1,
              "required": false,
              "repeated": false,
              "options": {
                "default": "0"
              }
            },
            {
              "name": "tags",
              "type": "uint32",
              "tag": 2,
              "required": false,
              "repeated": true,
              "options": {
                "packed": "true"
              }
            },
            {
              "name": "type",
              "type": "GeomType",
              "tag": 3,
              "required": false,
              "repeated": false,
              "options": {
                "default": "UNKNOWN"
              }
            },
            {
              "name": "geometry",
              "type": "uint32",
              "tag": 4,
              "required": false,
              "repeated": true,
              "options": {
                "packed": "true"
              }
            }
          ],
          "extensions": null
        },
        {
          "name": "Layer",
          "enums": [],
          "oneof": [],
          "messages": [],
          "fields": [
            {
              "name": "version",
              "type": "uint32",
              "tag": 15,
              "required": true,
              "repeated": false,
              "options": {
                "default": "1"
              }
            },
            {
              "name": "name",
              "type": "string",
              "tag": 1,
              "required": true,
              "repeated": false,
              "options": {}
            },
            {
              "name": "features",
              "type": "Feature",
              "tag": 2,
              "required": false,
              "repeated": true,
              "options": {}
            },
            {
              "name": "keys",
              "type": "string",
              "tag": 3,
              "required": false,
              "repeated": true,
              "options": {}
            },
            {
              "name": "values",
              "type": "Value",
              "tag": 4,
              "required": false,
              "repeated": true,
              "options": {}
            },
            {
              "name": "extent",
              "type": "uint32",
              "tag": 5,
              "required": false,
              "repeated": false,
              "options": {
                "default": "4096"
              }
            }
          ],
          "extensions": {
            "from": 16,
            "to": 536870911
          }
        }
      ],
      "fields": [
        {
          "name": "layers",
          "type": "Layer",
          "tag": 3,
          "required": false,
          "repeated": true,
          "options": {}
        }
      ],
      "extensions": {
        "from": 16,
        "to": 8191
      }
    }
  ],
  "options": {
    "optimize_for": "LITE_RUNTIME"
  },
  "extends": []
}
