'use strict';

// glyph ========================================

exports.glyph = {read: readGlyph};

function readGlyph(pbf, end) {
    return pbf.readFields(readGlyphField, {}, end);
}

function readGlyphField(tag, glyph, pbf) {
    if (tag === 1) glyph.id = pbf.readVarint();
    else if (tag === 2) glyph.bitmap = pbf.readBytes();
    else if (tag === 3) glyph.width = pbf.readVarint();
    else if (tag === 4) glyph.height = pbf.readVarint();
    else if (tag === 5) glyph.left = pbf.readSVarint();
    else if (tag === 6) glyph.top = pbf.readSVarint();
    else if (tag === 7) glyph.advance = pbf.readVarint();
}

// fontstack ========================================

exports.fontstack = {read: readFontstack};

function readFontstack(pbf, end) {
    return pbf.readFields(readFontstackField, {"glyphs": []}, end);
}

function readFontstackField(tag, fontstack, pbf) {
    if (tag === 1) fontstack.name = pbf.readString();
    else if (tag === 2) fontstack.range = pbf.readString();
    else if (tag === 3) fontstack.glyphs.push(readGlyph(pbf, pbf.readVarint() + pbf.pos));
}

// glyphs ========================================

exports.glyphs = {read: readGlyphs};

function readGlyphs(pbf, end) {
    return pbf.readFields(readGlyphsField, {"stacks": []}, end);
}

function readGlyphsField(tag, glyphs, pbf) {
    if (tag === 1) glyphs.stacks.push(readFontstack(pbf, pbf.readVarint() + pbf.pos));
}
