'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _StoreAdapter = require('./adapter/StoreAdapter');

var _StoreAdapter2 = _interopRequireDefault(_StoreAdapter);

var _LocalStoreAdapter = require('./adapter/LocalStoreAdapter');

var _LocalStoreAdapter2 = _interopRequireDefault(_LocalStoreAdapter);

var _render = require('./render');

var _render2 = _interopRequireDefault(_render);

var _UI = require('./UI');

var _UI2 = _interopRequireDefault(_UI);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  /**
   * Abstract class that needs to be defined so PDFJSAnnotate
   * knows how to communicate with your server.
   */
  StoreAdapter: _StoreAdapter2.default,

  /**
   * Implementation of StoreAdapter that stores annotation data to localStorage.
   */
  LocalStoreAdapter: _LocalStoreAdapter2.default,

  /**
   * Abstract instance of StoreAdapter
   */
  __storeAdapter: new _StoreAdapter2.default(),

  /**
   * Getter for the underlying StoreAdapter property
   *
   * @return {StoreAdapter}
   */
  getStoreAdapter: function getStoreAdapter() {
    return this.__storeAdapter;
  },


  /**
   * Setter for the underlying StoreAdapter property
   *
   * @param {StoreAdapter} adapter The StoreAdapter implementation to be used.
   */
  setStoreAdapter: function setStoreAdapter(adapter) {
    // TODO this throws an error when bundled
    // if (!(adapter instanceof StoreAdapter)) {
    //   throw new Error('adapter must be an instance of StoreAdapter');
    // }

    this.__storeAdapter = adapter;
  },


  /**
   * UI is a helper for instrumenting UI interactions for creating,
   * editing, and deleting annotations in the browser.
   */
  UI: _UI2.default,

  /**
   * Render the annotations for a page in the PDF Document
   *
   * @param {SVGElement} svg The SVG element that annotations should be rendered to
   * @param {PageViewport} viewport The PDFPage.getViewport data
   * @param {Object} data The StoreAdapter.getAnnotations data
   * @return {Promise}
   */
  render: _render2.default,

  /**
   * Convenience method for getting annotation data
   *
   * @alias StoreAdapter.getAnnotations
   * @param {String} documentId The ID of the document
   * @param {String} pageNumber The page number
   * @return {Promise}
   */
  getAnnotations: function getAnnotations(documentId, pageNumber) {
    var _getStoreAdapter;

    return (_getStoreAdapter = this.getStoreAdapter()).getAnnotations.apply(_getStoreAdapter, arguments);
  }
};