'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

exports.enableEdit = enableEdit;
exports.disableEdit = disableEdit;

var _PDFJSAnnotate = require('../PDFJSAnnotate');

var _PDFJSAnnotate2 = _interopRequireDefault(_PDFJSAnnotate);

var _appendChild = require('../render/appendChild');

var _appendChild2 = _interopRequireDefault(_appendChild);

var _event = require('./event');

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var _enabled = false;
var isDragging = false,
    overlay = void 0;
var dragOffsetX = void 0,
    dragOffsetY = void 0,
    dragStartX = void 0,
    dragStartY = void 0;
var OVERLAY_BORDER_SIZE = 3;

/**
 * Create an overlay for editing an annotation.
 *
 * @param {Element} target The annotation element to apply overlay for
 */
function createEditOverlay(target) {
  destroyEditOverlay();

  overlay = document.createElement('div');
  var anchor = document.createElement('a');
  var parentNode = (0, _utils.findSVGContainer)(target).parentNode;
  var id = target.getAttribute('data-pdf-annotate-id');
  var rect = (0, _utils.getAnnotationRect)(target);
  var styleLeft = rect.left - OVERLAY_BORDER_SIZE;
  var styleTop = rect.top - OVERLAY_BORDER_SIZE;

  overlay.setAttribute('id', 'pdf-annotate-edit-overlay');
  overlay.setAttribute('data-target-id', id);
  overlay.style.boxSizing = 'content-box';
  overlay.style.position = 'absolute';
  overlay.style.top = styleTop + 'px';
  overlay.style.left = styleLeft + 'px';
  overlay.style.width = rect.width + 'px';
  overlay.style.height = rect.height + 'px';
  overlay.style.border = OVERLAY_BORDER_SIZE + 'px solid ' + _utils.BORDER_COLOR;
  overlay.style.borderRadius = OVERLAY_BORDER_SIZE + 'px';

  anchor.innerHTML = '×';
  anchor.setAttribute('href', 'javascript://');
  anchor.style.background = '#fff';
  anchor.style.borderRadius = '20px';
  anchor.style.border = '1px solid #bbb';
  anchor.style.color = '#bbb';
  anchor.style.fontSize = '16px';
  anchor.style.padding = '2px';
  anchor.style.textAlign = 'center';
  anchor.style.textDecoration = 'none';
  anchor.style.position = 'absolute';
  anchor.style.top = '-13px';
  anchor.style.right = '-13px';
  anchor.style.width = '25px';
  anchor.style.height = '25px';

  overlay.appendChild(anchor);
  parentNode.appendChild(overlay);
  document.addEventListener('click', handleDocumentClick);
  document.addEventListener('keyup', handleDocumentKeyup);
  document.addEventListener('mousedown', handleDocumentMousedown);
  anchor.addEventListener('click', deleteAnnotation);
  anchor.addEventListener('mouseover', function () {
    anchor.style.color = '#35A4DC';
    anchor.style.borderColor = '#999';
    anchor.style.boxShadow = '0 1px 1px #ccc';
  });
  anchor.addEventListener('mouseout', function () {
    anchor.style.color = '#bbb';
    anchor.style.borderColor = '#bbb';
    anchor.style.boxShadow = '';
  });
  overlay.addEventListener('mouseover', function () {
    if (!isDragging) {
      anchor.style.display = '';
    }
  });
  overlay.addEventListener('mouseout', function () {
    anchor.style.display = 'none';
  });
}

/**
 * Destroy the edit overlay if it exists.
 */
function destroyEditOverlay() {
  if (overlay) {
    overlay.parentNode.removeChild(overlay);
    overlay = null;
  }

  document.removeEventListener('click', handleDocumentClick);
  document.removeEventListener('keyup', handleDocumentKeyup);
  document.removeEventListener('mousedown', handleDocumentMousedown);
  document.removeEventListener('mousemove', handleDocumentMousemove);
  document.removeEventListener('mouseup', handleDocumentMouseup);
  (0, _utils.enableUserSelect)();
}

/**
 * Delete currently selected annotation
 */
function deleteAnnotation() {
  if (!overlay) {
    return;
  }

  var annotationId = overlay.getAttribute('data-target-id');
  var nodes = document.querySelectorAll('[data-pdf-annotate-id="' + annotationId + '"]');
  var svg = overlay.parentNode.querySelector('svg.annotationLayer');

  var _getMetadata = (0, _utils.getMetadata)(svg);

  var documentId = _getMetadata.documentId;


  [].concat(_toConsumableArray(nodes)).forEach(function (n) {
    n.parentNode.removeChild(n);
  });

  _PDFJSAnnotate2.default.getStoreAdapter().deleteAnnotation(documentId, annotationId);

  destroyEditOverlay();
}

/**
 * Handle document.click event
 *
 * @param {Event} e The DOM event that needs to be handled
 */
function handleDocumentClick(e) {
  if (!(0, _utils.findSVGAtPoint)(e.clientX, e.clientY)) {
    return;
  }

  // Remove current overlay
  var overlay = document.getElementById('pdf-annotate-edit-overlay');
  if (overlay) {
    if (isDragging || e.target === overlay) {
      return;
    }

    destroyEditOverlay();
  }
}

/**
 * Handle document.keyup event
 *
 * @param {Event} e The DOM event that needs to be handled
 */
function handleDocumentKeyup(e) {
  if (overlay && e.keyCode === 46 && e.target.nodeName.toLowerCase() !== 'textarea' && e.target.nodeName.toLowerCase() !== 'input') {
    deleteAnnotation();
  }
}

/**
 * Handle document.mousedown event
 *
 * @param {Event} e The DOM event that needs to be handled
 */
function handleDocumentMousedown(e) {
  if (e.target !== overlay) {
    return;
  }

  // Highlight and strikeout annotations are bound to text within the document.
  // It doesn't make sense to allow repositioning these types of annotations.
  var annotationId = overlay.getAttribute('data-target-id');
  var target = document.querySelector('[data-pdf-annotate-id="' + annotationId + '"]');
  var type = target.getAttribute('data-pdf-annotate-type');

  if (type === 'highlight' || type === 'strikeout') {
    return;
  }

  isDragging = true;
  dragOffsetX = e.clientX;
  dragOffsetY = e.clientY;
  dragStartX = overlay.offsetLeft;
  dragStartY = overlay.offsetTop;

  overlay.style.background = 'rgba(255, 255, 255, 0.7)';
  overlay.style.cursor = 'move';
  overlay.querySelector('a').style.display = 'none';

  document.addEventListener('mousemove', handleDocumentMousemove);
  document.addEventListener('mouseup', handleDocumentMouseup);
  (0, _utils.disableUserSelect)();
}

/**
 * Handle document.mousemove event
 *
 * @param {Event} e The DOM event that needs to be handled
 */
function handleDocumentMousemove(e) {
  var annotationId = overlay.getAttribute('data-target-id');
  var parentNode = overlay.parentNode;
  var rect = parentNode.getBoundingClientRect();
  var y = dragStartY + (e.clientY - dragOffsetY);
  var x = dragStartX + (e.clientX - dragOffsetX);
  var minY = 0;
  var maxY = rect.height;
  var minX = 0;
  var maxX = rect.width;

  if (y > minY && y + overlay.offsetHeight < maxY) {
    overlay.style.top = y + 'px';
  }

  if (x > minX && x + overlay.offsetWidth < maxX) {
    overlay.style.left = x + 'px';
  }
}

/**
 * Handle document.mouseup event
 *
 * @param {Event} e The DOM event that needs to be handled
 */
function handleDocumentMouseup(e) {
  var annotationId = overlay.getAttribute('data-target-id');
  var target = document.querySelectorAll('[data-pdf-annotate-id="' + annotationId + '"]');
  var type = target[0].getAttribute('data-pdf-annotate-type');
  var svg = overlay.parentNode.querySelector('svg.annotationLayer');

  var _getMetadata2 = (0, _utils.getMetadata)(svg);

  var documentId = _getMetadata2.documentId;


  overlay.querySelector('a').style.display = '';

  function getDelta(propX, propY) {
    return calcDelta(parseInt(target[0].getAttribute(propX), 10), parseInt(target[0].getAttribute(propY), 10));
  }

  function calcDelta(x, y) {
    return {
      deltaX: OVERLAY_BORDER_SIZE + (0, _utils.scaleDown)(svg, { x: overlay.offsetLeft }).x - x,
      deltaY: OVERLAY_BORDER_SIZE + (0, _utils.scaleDown)(svg, { y: overlay.offsetTop }).y - y
    };
  }

  _PDFJSAnnotate2.default.getStoreAdapter().getAnnotation(documentId, annotationId).then(function (annotation) {
    if (['area', 'highlight', 'point', 'textbox'].indexOf(type) > -1) {
      (function () {
        var _getDelta = getDelta('x', 'y');

        var deltaX = _getDelta.deltaX;
        var deltaY = _getDelta.deltaY;

        [].concat(_toConsumableArray(target)).forEach(function (t, i) {
          if (deltaY !== 0) {
            var modelY = parseInt(t.getAttribute('y'), 10) + deltaY;
            var viewY = modelY;

            if (type === 'textbox') {
              viewY += annotation.size;
            }

            if (type === 'point') {
              viewY = (0, _utils.scaleUp)(svg, { viewY: viewY }).viewY;
            }

            t.setAttribute('y', viewY);
            if (annotation.rectangles) {
              annotation.rectangles[i].y = modelY;
            } else if (annotation.y) {
              annotation.y = modelY;
            }
          }
          if (deltaX !== 0) {
            var modelX = parseInt(t.getAttribute('x'), 10) + deltaX;
            var viewX = modelX;

            if (type === 'point') {
              viewX = (0, _utils.scaleUp)(svg, { viewX: viewX }).viewX;
            }

            t.setAttribute('x', viewX);
            if (annotation.rectangles) {
              annotation.rectangles[i].x = modelX;
            } else if (annotation.x) {
              annotation.x = modelX;
            }
          }
        });
        // } else if (type === 'strikeout') {
        //   let { deltaX, deltaY } = getDelta('x1', 'y1');
        //   [...target].forEach(target, (t, i) => {
        //     if (deltaY !== 0) {
        //       t.setAttribute('y1', parseInt(t.getAttribute('y1'), 10) + deltaY);
        //       t.setAttribute('y2', parseInt(t.getAttribute('y2'), 10) + deltaY);
        //       annotation.rectangles[i].y = parseInt(t.getAttribute('y1'), 10);
        //     }
        //     if (deltaX !== 0) {
        //       t.setAttribute('x1', parseInt(t.getAttribute('x1'), 10) + deltaX);
        //       t.setAttribute('x2', parseInt(t.getAttribute('x2'), 10) + deltaX);
        //       annotation.rectangles[i].x = parseInt(t.getAttribute('x1'), 10);
        //     }
        //   });
      })();
    } else if (type === 'drawing') {
      (function () {
        var rect = (0, _utils.scaleDown)(svg, (0, _utils.getAnnotationRect)(target[0]));

        var _annotation$lines$ = _slicedToArray(annotation.lines[0], 2);

        var originX = _annotation$lines$[0];
        var originY = _annotation$lines$[1];

        var _calcDelta = calcDelta(originX, originY);

        var deltaX = _calcDelta.deltaX;
        var deltaY = _calcDelta.deltaY;

        // origin isn't necessarily at 0/0 in relation to overlay x/y
        // adjust the difference between overlay and drawing coords

        deltaY += originY - rect.top;
        deltaX += originX - rect.left;

        annotation.lines.forEach(function (line, i) {
          var _annotation$lines$i = _slicedToArray(annotation.lines[i], 2);

          var x = _annotation$lines$i[0];
          var y = _annotation$lines$i[1];

          annotation.lines[i][0] = x + deltaX;
          annotation.lines[i][1] = y + deltaY;
        });

        target[0].parentNode.removeChild(target[0]);
        (0, _appendChild2.default)(svg, annotation);
      })();
    }

    _PDFJSAnnotate2.default.getStoreAdapter().editAnnotation(documentId, annotationId, annotation);
  });

  setTimeout(function () {
    isDragging = false;
  }, 0);

  overlay.style.background = '';
  overlay.style.cursor = '';

  document.removeEventListener('mousemove', handleDocumentMousemove);
  document.removeEventListener('mouseup', handleDocumentMouseup);
  (0, _utils.enableUserSelect)();
}

/**
 * Handle annotation.click event
 *
 * @param {Element} e The annotation element that was clicked
 */
function handleAnnotationClick(target) {
  createEditOverlay(target);
}

/**
 * Enable edit mode behavior.
 */
function enableEdit() {
  if (_enabled) {
    return;
  }

  _enabled = true;
  (0, _event.addEventListener)('annotation:click', handleAnnotationClick);
};

/**
 * Disable edit mode behavior.
 */
function disableEdit() {
  destroyEditOverlay();

  if (!_enabled) {
    return;
  }

  _enabled = false;
  (0, _event.removeEventListener)('annotation:click', handleAnnotationClick);
};