'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fireEvent = fireEvent;
exports.addEventListener = addEventListener;
exports.removeEventListener = removeEventListener;

var _events = require('events');

var _events2 = _interopRequireDefault(_events);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var emitter = new _events2.default();

var clickNode = void 0;

/**
 * Handle document.click event
 *
 * @param {Event} e The DOM event to be handled
 */
document.addEventListener('click', function handleDocumentClick(e) {
  if (!(0, _utils.findSVGAtPoint)(e.clientX, e.clientY)) {
    return;
  }

  var target = (0, _utils.findAnnotationAtPoint)(e.clientX, e.clientY);

  // Emit annotation:blur if clickNode is no longer clicked
  if (clickNode && clickNode !== target) {
    emitter.emit('annotation:blur', clickNode);
  }

  // Emit annotation:click if target was clicked
  if (target) {
    emitter.emit('annotation:click', target);
  }

  clickNode = target;
});

// let mouseOverNode;
// document.addEventListener('mousemove', function handleDocumentMousemove(e) {
//   let target = findAnnotationAtPoint(e.clientX, e.clientY);
//
//   // Emit annotation:mouseout if target was mouseout'd
//   if (mouseOverNode && !target) {
//     emitter.emit('annotation:mouseout', mouseOverNode);
//   }
//
//   // Emit annotation:mouseover if target was mouseover'd
//   if (target && mouseOverNode !== target) {
//     emitter.emit('annotation:mouseover', target);
//   }
//
//   mouseOverNode = target;
// });

function fireEvent() {
  emitter.emit.apply(emitter, arguments);
};
function addEventListener() {
  emitter.on.apply(emitter, arguments);
};
function removeEventListener() {
  emitter.removeListener.apply(emitter, arguments);
};