'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

exports.enablePoint = enablePoint;
exports.disablePoint = disablePoint;

var _PDFJSAnnotate = require('../PDFJSAnnotate');

var _PDFJSAnnotate2 = _interopRequireDefault(_PDFJSAnnotate);

var _appendChild = require('../render/appendChild');

var _appendChild2 = _interopRequireDefault(_appendChild);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _enabled = false;
var input = void 0;

/**
 * Handle document.mouseup event
 *
 * @param {Event} The DOM event to be handled
 */
function handleDocumentMouseup(e) {
  if (input || !(0, _utils.findSVGAtPoint)(e.clientX, e.clientY)) {
    return;
  }

  input = document.createElement('input');
  input.setAttribute('id', 'pdf-annotate-point-input');
  input.setAttribute('placeholder', 'Enter comment');
  input.style.border = '3px solid ' + _utils.BORDER_COLOR;
  input.style.borderRadius = '3px';
  input.style.position = 'absolute';
  input.style.top = e.clientY + 'px';
  input.style.left = e.clientX + 'px';

  input.addEventListener('blur', handleInputBlur);
  input.addEventListener('keyup', handleInputKeyup);

  document.body.appendChild(input);
  input.focus();
}

/**
 * Handle input.blur event
 */
function handleInputBlur() {
  savePoint();
}

/**
 * Handle input.keyup event
 *
 * @param {Event} e The DOM event to handle
 */
function handleInputKeyup(e) {
  if (e.keyCode === 27) {
    closeInput();
  } else if (e.keyCode === 13) {
    savePoint();
  }
}

/**
 * Save a new point annotation from input
 */
function savePoint() {
  if (input.value.trim().length > 0) {
    var _ret = function () {
      var clientX = parseInt(input.style.left, 10);
      var clientY = parseInt(input.style.top, 10);
      var content = input.value.trim();
      var svg = (0, _utils.findSVGAtPoint)(clientX, clientY);
      if (!svg) {
        return {
          v: void 0
        };
      }

      var rect = svg.getBoundingClientRect();

      var _getMetadata = (0, _utils.getMetadata)(svg);

      var documentId = _getMetadata.documentId;
      var pageNumber = _getMetadata.pageNumber;

      var annotation = Object.assign({
        type: 'point'
      }, (0, _utils.scaleDown)(svg, {
        x: clientX - rect.left,
        y: clientY - rect.top
      }));

      _PDFJSAnnotate2.default.getStoreAdapter().addAnnotation(documentId, pageNumber, annotation).then(function (annotation) {
        _PDFJSAnnotate2.default.getStoreAdapter().addComment(documentId, annotation.uuid, content);

        (0, _appendChild2.default)(svg, annotation);
      });
    }();

    if ((typeof _ret === 'undefined' ? 'undefined' : _typeof(_ret)) === "object") return _ret.v;
  }

  closeInput();
}

/**
 * Close the input element
 */
function closeInput() {
  input.removeEventListener('blur', handleInputBlur);
  input.removeEventListener('keyup', handleInputKeyup);
  document.body.removeChild(input);
  input = null;
}

/**
 * Enable point annotation behavior
 */
function enablePoint() {
  if (_enabled) {
    return;
  }

  _enabled = true;
  document.addEventListener('mouseup', handleDocumentMouseup);
}

/**
 * Disable point annotation behavior
 */
function disablePoint() {
  if (!_enabled) {
    return;
  }

  _enabled = false;
  document.removeEventListener('mouseup', handleDocumentMouseup);
}