'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = initEventHandlers;

var _insertScreenReaderHint = require('./insertScreenReaderHint');

var _insertScreenReaderHint2 = _interopRequireDefault(_insertScreenReaderHint);

var _renderScreenReaderHints = require('./renderScreenReaderHints');

var _renderScreenReaderHints2 = _interopRequireDefault(_renderScreenReaderHints);

var _insertScreenReaderComment = require('./insertScreenReaderComment');

var _insertScreenReaderComment2 = _interopRequireDefault(_insertScreenReaderComment);

var _renderScreenReaderComments = require('./renderScreenReaderComments');

var _renderScreenReaderComments2 = _interopRequireDefault(_renderScreenReaderComments);

var _event = require('../UI/event');

var _PDFJSAnnotate = require('../PDFJSAnnotate');

var _PDFJSAnnotate2 = _interopRequireDefault(_PDFJSAnnotate);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Initialize the event handlers for keeping screen reader hints synced with data
 */
function initEventHandlers() {
  (0, _event.addEventListener)('annotation:add', function (documentId, pageNumber, annotation) {
    reorderAnnotationsByType(documentId, pageNumber, annotation.type);
  });
  (0, _event.addEventListener)('annotation:edit', function (documentId, annotationId, annotation) {
    reorderAnnotationsByType(documentId, annotation.page, annotation.type);
  });
  (0, _event.addEventListener)('annotation:delete', removeAnnotation);
  (0, _event.addEventListener)('comment:add', insertComment);
  (0, _event.addEventListener)('comment:delete', removeComment);
}

/**
 * Reorder the annotation numbers by annotation type
 *
 * @param {String} documentId The ID of the document
 * @param {Number} pageNumber The page number of the annotations
 * @param {Strig} type The annotation type
 */
function reorderAnnotationsByType(documentId, pageNumber, type) {
  _PDFJSAnnotate2.default.getStoreAdapter().getAnnotations(documentId, pageNumber).then(function (annotations) {
    return annotations.annotations.filter(function (a) {
      return a.type === type;
    });
  }).then(function (annotations) {
    annotations.forEach(function (a) {
      removeAnnotation(documentId, a.uuid);
    });

    return annotations;
  }).then(_renderScreenReaderHints2.default);
}

/**
 * Remove the screen reader hint for an annotation
 *
 * @param {String} documentId The ID of the document
 * @param {String} annotationId The Id of the annotation
 */
function removeAnnotation(documentId, annotationId) {
  removeElementById('pdf-annotate-screenreader-' + annotationId);
  removeElementById('pdf-annotate-screenreader-' + annotationId + '-end');
}

/**
 * Insert a screen reader hint for a comment
 *
 * @param {String} documentId The ID of the document
 * @param {String} annotationId The ID of tha assocated annotation
 * @param {Object} comment The comment to insert a hint for
 */
function insertComment(documentId, annotationId, comment) {
  var list = document.querySelector('pdf-annotate-screenreader-comment-list-' + annotationId);
  var promise = void 0;

  if (!list) {
    promise = (0, _renderScreenReaderComments2.default)(documentId, annotationId, []).then(function () {
      list = document.querySelector('pdf-annotate-screenreader-comment-list-' + annotationId);
      return true;
    });
  } else {
    promise = Promise.resolve(true);
  }

  promise.then(function () {
    (0, _insertScreenReaderComment2.default)(comment);
  });
}

/**
 * Remove a screen reader hint for a comment
 *
 * @param {String} documentId The ID of the document
 * @param {String} commentId The ID of the comment
 */
function removeComment(documentId, commentId) {
  removeElementById('pdf-annotate-screenreader-comment-' + commentId);
}

/**
 * Remove an element from the DOM by it's ID if it exists
 *
 * @param {String} elementID The ID of the element to be removed
 */
function removeElementById(elementId) {
  var el = document.getElementById(elementId);
  if (el) {
    el.parentNode.removeChild(el);
  }
}