'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = insertElementWithinChildren;

var _insertElementWithinElement = require('./insertElementWithinElement');

var _insertElementWithinElement2 = _interopRequireDefault(_insertElementWithinElement);

var _utils = require('../UI/utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

/**
 * Insert an element at a point within the document.
 * This algorithm will try to insert between elements if possible.
 * It will however use `insertElementWithinElement` if it is more accurate.
 *
 * @param {Element} el The element to be inserted
 * @param {Number} x The x coordinate of the point
 * @param {Number} y The y coordinate of the point
 * @param {Number} pageNumber The page number to limit elements to
 * @return {Boolean} True if element was able to be inserted, otherwise false
 */
function insertElementWithinChildren(el, x, y, pageNumber) {
  // Try and use most accurate method of inserting within an element
  if ((0, _insertElementWithinElement2.default)(el, x, y, pageNumber, true)) {
    return true;
  }

  // Fall back to inserting between elements
  var svg = document.querySelector('svg[data-pdf-annotate-page="' + pageNumber + '"]');
  var rect = svg.getBoundingClientRect();
  var nodes = [].concat(_toConsumableArray(svg.parentNode.querySelectorAll('.textLayer > div')));

  y = (0, _utils.scaleUp)(svg, { y: y }).y + rect.top;
  x = (0, _utils.scaleUp)(svg, { x: x }).x + rect.left;

  // Find the best node to insert before
  for (var i = 0, l = nodes.length; i < l; i++) {
    var n = nodes[i];
    var r = n.getBoundingClientRect();
    if (y <= r.top) {
      n.parentNode.insertBefore(el, n);
      return true;
    }
  }

  // If all else fails try to append to the bottom
  var textLayer = svg.parentNode.querySelector('.textLayer');
  if (textLayer) {
    var textRect = textLayer.getBoundingClientRect();
    if ((0, _utils.pointIntersectsRect)(x, y, textRect)) {
      textLayer.appendChild(el);
      return true;
    }
  }

  return false;
}