'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = insertScreenReaderComment;
/**
 * Insert a comment into the DOM to be available by screen reader
 *
 * @param {Object} comment The comment to be inserted
 */
function insertScreenReaderComment(comment) {
  if (!comment) {
    return;
  }

  var list = document.querySelector('#pdf-annotate-screenreader-' + comment.annotation + ' ol');
  if (list) {
    var item = document.createElement('li');
    item.setAttribute('id', 'pdf-annotate-screenreader-comment-' + comment.uuid);
    item.appendChild(document.createTextNode('' + comment.content));
    list.appendChild(item);
  }
}