'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = insertScreenReaderHint;

var _createScreenReaderOnly = require('./createScreenReaderOnly');

var _createScreenReaderOnly2 = _interopRequireDefault(_createScreenReaderOnly);

var _insertElementWithinChildren = require('./insertElementWithinChildren');

var _insertElementWithinChildren2 = _interopRequireDefault(_insertElementWithinChildren);

var _insertElementWithinElement = require('./insertElementWithinElement');

var _insertElementWithinElement2 = _interopRequireDefault(_insertElementWithinElement);

var _renderScreenReaderComments = require('./renderScreenReaderComments');

var _renderScreenReaderComments2 = _interopRequireDefault(_renderScreenReaderComments);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Annotation types that support comments
var COMMENT_TYPES = ['highlight', 'point', 'area'];

/**
 * Insert a hint into the DOM for screen readers for a specific annotation.
 *
 * @param {Object} annotation The annotation to insert a hint for
 * @param {Number} num The number of the annotation out of all annotations of the same type
 */
function insertScreenReaderHint(annotation) {
  var num = arguments.length <= 1 || arguments[1] === undefined ? 0 : arguments[1];

  switch (annotation.type) {
    case 'highlight':
    case 'strikeout':
      var rects = annotation.rectangles;
      var first = rects[0];
      var last = rects[rects.length - 1];

      (0, _insertElementWithinElement2.default)((0, _createScreenReaderOnly2.default)('Begin ' + annotation.type + ' annotation ' + num, annotation.uuid), first.x, first.y, annotation.page, true);

      (0, _insertElementWithinElement2.default)((0, _createScreenReaderOnly2.default)('End ' + annotation.type + ' annotation ' + num, annotation.uuid + '-end'), last.x + last.width, last.y, annotation.page, false);
      break;

    case 'textbox':
    case 'point':
      var text = annotation.type === 'textbox' ? ' (content: ' + annotation.content + ')' : '';

      (0, _insertElementWithinChildren2.default)((0, _createScreenReaderOnly2.default)(annotation.type + ' annotation ' + num + text, annotation.uuid), annotation.x, annotation.y, annotation.page);
      break;

    case 'drawing':
    case 'area':
      var x = typeof annotation.x !== 'undefined' ? annotation.x : annotation.lines[0][0];
      var y = typeof annotation.y !== 'undefined' ? annotation.y : annotation.lines[0][1];

      (0, _insertElementWithinChildren2.default)((0, _createScreenReaderOnly2.default)('Unlabeled drawing', annotation.uuid), x, y, annotation.page);
      break;
  }

  // Include comments in screen reader hint
  if (COMMENT_TYPES.includes(annotation.type)) {
    (0, _renderScreenReaderComments2.default)(annotation.documentId, annotation.uuid);
  }
}