'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderScreenReaderComments;

var _PDFJSAnnotate = require('../PDFJSAnnotate');

var _PDFJSAnnotate2 = _interopRequireDefault(_PDFJSAnnotate);

var _insertScreenReaderComment = require('./insertScreenReaderComment');

var _insertScreenReaderComment2 = _interopRequireDefault(_insertScreenReaderComment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Insert the comments into the DOM to be available by screen reader
 *
 * Example output:
 *   <div class="screenReaderOnly">
 *    <div>Begin highlight 1</div>
 *    <ol aria-label="Comments">
 *      <li>Foo</li>
 *      <li>Bar</li>
 *      <li>Baz</li>
 *      <li>Qux</li>
 *    </ol>
 *  </div>
 *  <div>Some highlighted text goes here...</div>
 *  <div class="screenReaderOnly">End highlight 1</div>
 *
 * NOTE: `screenReaderOnly` is not a real class, just used for brevity
 *
 * @param {String} documentId The ID of the document
 * @param {String} annotationId The ID of the annotation
 * @param {Array} [comments] Optionally preloaded comments to be rendered
 * @return {Promise}
 */
function renderScreenReaderComments(documentId, annotationId, comments) {
  var promise = void 0;

  if (Array.isArray(comments)) {
    promise = Promise.resolve(comments);
  } else {
    promise = _PDFJSAnnotate2.default.getStoreAdapter().getComments(documentId, annotationId);
  }

  return promise.then(function (comments) {
    // Node needs to be found by querying DOM as it may have been inserted as innerHTML
    // leaving `screenReaderNode` as an invalid reference (see `insertElementWithinElement`).
    var node = document.getElementById('pdf-annotate-screenreader-' + annotationId);
    if (node) {
      var list = document.createElement('ol');
      list.setAttribute('id', 'pdf-annotate-screenreader-comment-list-' + annotationId);
      list.setAttribute('aria-label', 'Comments');
      node.appendChild(list);
      comments.forEach(_insertScreenReaderComment2.default);
    }
  });
}