'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderScreenReaderHints;

var _insertScreenReaderHint = require('./insertScreenReaderHint');

var _insertScreenReaderHint2 = _interopRequireDefault(_insertScreenReaderHint);

var _initEventHandlers = require('./initEventHandlers');

var _initEventHandlers2 = _interopRequireDefault(_initEventHandlers);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// TODO This is not the right place for this to live
(0, _initEventHandlers2.default)();

/**
 * Insert hints into the DOM for screen readers.
 *
 * @param {Array} annotations The annotations that hints are inserted for
 */
function renderScreenReaderHints(annotations) {
  annotations = Array.isArray(annotations) ? annotations : [];

  // Insert hints for each type
  Object.keys(SORT_TYPES).forEach(function (type) {
    var sortBy = SORT_TYPES[type];
    annotations.filter(function (a) {
      return a.type === type;
    }).sort(sortBy).forEach(function (a, i) {
      return (0, _insertScreenReaderHint2.default)(a, i + 1);
    });
  });
}

// Sort annotations first by y, then by x.
// This allows hints to be injected in the order they appear,
// which makes numbering them easier.
function sortByPoint(a, b) {
  if (a.y < b.y) {
    return a.x - b.x;
  } else {
    return 1;
  }
}

// Sort annotation by it's first rectangle
function sortByRectPoint(a, b) {
  return sortByPoint(a.rectangles[0], b.rectangles[0]);
}

// Sort annotation by it's first line
function sortByLinePoint(a, b) {
  var lineA = a.lines[0];
  var lineB = b.lines[0];
  return sortByPoint({ x: lineA[0], y: lineA[1] }, { x: lineB[0], y: lineB[1] });
}

// Arrange supported types and associated sort methods
var SORT_TYPES = {
  'highlight': sortByRectPoint,
  'strikeout': sortByRectPoint,
  'drawing': sortByLinePoint,
  'textbox': sortByPoint,
  'point': sortByPoint,
  'area': sortByPoint
};