'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _uuid = require('../utils/uuid');

var _uuid2 = _interopRequireDefault(_uuid);

var _StoreAdapter2 = require('./StoreAdapter');

var _StoreAdapter3 = _interopRequireDefault(_StoreAdapter2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// StoreAdapter for working with localStorage
// This is ideal for testing, examples, and prototyping
var LocalStoreAdapter = function (_StoreAdapter) {
  _inherits(LocalStoreAdapter, _StoreAdapter);

  function LocalStoreAdapter() {
    _classCallCheck(this, LocalStoreAdapter);

    return _possibleConstructorReturn(this, Object.getPrototypeOf(LocalStoreAdapter).call(this, {
      getAnnotations: function getAnnotations(documentId, pageNumber) {
        return new Promise(function (resolve, reject) {
          var annotations = _getAnnotations(documentId).filter(function (i) {
            return i.page === pageNumber && i.class === 'Annotation';
          });

          resolve({
            documentId: documentId,
            pageNumber: pageNumber,
            annotations: annotations
          });
        });
      },
      getAnnotation: function getAnnotation(documentId, annotationId) {
        return Promise.resolve(_getAnnotations(documentId)[findAnnotation(documentId, annotationId)]);
      },
      addAnnotation: function addAnnotation(documentId, pageNumber, annotation) {
        return new Promise(function (resolve, reject) {
          annotation.class = 'Annotation';
          annotation.uuid = (0, _uuid2.default)();
          annotation.page = pageNumber;

          var annotations = _getAnnotations(documentId);
          annotations.push(annotation);
          updateAnnotations(documentId, annotations);

          resolve(annotation);
        });
      },
      editAnnotation: function editAnnotation(documentId, annotationId, annotation) {
        return new Promise(function (resolve, reject) {
          var annotations = _getAnnotations(documentId);
          annotations[findAnnotation(documentId, annotationId)] = annotation;
          updateAnnotations(documentId, annotations);

          resolve(annotation);
        });
      },
      deleteAnnotation: function deleteAnnotation(documentId, annotationId) {
        return new Promise(function (resolve, reject) {
          var index = findAnnotation(documentId, annotationId);
          if (index > -1) {
            var annotations = _getAnnotations(documentId);
            annotations.splice(index, 1);
            updateAnnotations(documentId, annotations);
          }

          resolve(true);
        });
      },
      getComments: function getComments(documentId, annotationId) {
        return new Promise(function (resolve, reject) {
          resolve(_getAnnotations(documentId).filter(function (i) {
            return i.class === 'Comment' && i.annotation === annotationId;
          }));
        });
      },
      addComment: function addComment(documentId, annotationId, content) {
        return new Promise(function (resolve, reject) {
          var comment = {
            class: 'Comment',
            uuid: (0, _uuid2.default)(),
            annotation: annotationId,
            content: content
          };

          var annotations = _getAnnotations(documentId);
          annotations.push(comment);
          updateAnnotations(documentId, annotations);

          resolve(comment);
        });
      },
      deleteComment: function deleteComment(documentId, commentId) {
        return new Promise(function (resolve, reject) {
          _getAnnotations(documentId);
          var index = -1;
          var annotations = _getAnnotations(documentId);
          for (var i = 0, l = annotations.length; i < l; i++) {
            if (annotations[i].uuid === commentId) {
              index = i;
              break;
            }
          }

          if (index > -1) {
            annotations.splice(index, 1);
            updateAnnotations(documentId, annotations);
          }

          resolve(true);
        });
      }
    }));
  }

  return LocalStoreAdapter;
}(_StoreAdapter3.default);

exports.default = LocalStoreAdapter;


function _getAnnotations(documentId) {
  return JSON.parse(localStorage.getItem(documentId + '/annotations')) || [];
}

function updateAnnotations(documentId, annotations) {
  localStorage.setItem(documentId + '/annotations', JSON.stringify(annotations));
}

function findAnnotation(documentId, annotationId) {
  var index = -1;
  var annotations = _getAnnotations(documentId);
  for (var i = 0, l = annotations.length; i < l; i++) {
    if (annotations[i].uuid === annotationId) {
      index = i;
      break;
    }
  }
  return index;
}