'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _abstractFunction = require('../utils/abstractFunction');

var _abstractFunction2 = _interopRequireDefault(_abstractFunction);

var _event = require('../UI/event');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Adapter should never be invoked publicly
var StoreAdapter = function () {
  /**
   * Create a new StoreAdapter instance
   *
   * @param {Object} [definition] The definition to use for overriding abstract methods
   */
  function StoreAdapter() {
    var _this = this;

    var definition = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    _classCallCheck(this, StoreAdapter);

    // Copy each function from definition if it is a function we know about
    Object.keys(definition).forEach(function (key) {
      if (typeof definition[key] === 'function' && typeof _this[key] === 'function') {
        _this[key] = definition[key];
      }
    });
  }

  /**
   * Get all the annotations for a given document and page number.
   *
   * @param {String} documentId The ID for the document the annotations belong to
   * @param {Number} pageNumber The number of the page the annotations belong to
   * @return {Promise}
   */


  _createClass(StoreAdapter, [{
    key: '__getAnnotations',
    value: function __getAnnotations(documentId, pageNumber) {
      (0, _abstractFunction2.default)('getAnnotations');
    }
  }, {
    key: 'getAnnotation',


    /**
     * Get the definition for a specific annotation.
     *
     * @param {String} documentId The ID for the document the annotation belongs to
     * @param {String} annotationId The ID for the annotation
     * @return {Promise}
     */
    value: function getAnnotation(documentId, annotationId) {
      (0, _abstractFunction2.default)('getAnnotation');
    }

    /**
     * Add an annotation
     *
     * @param {String} documentId The ID for the document to add the annotation to
     * @param {String} pageNumber The page number to add the annotation to
     * @param {Object} annotation The definition for the new annotation
     * @return {Promise}
     */

  }, {
    key: '__addAnnotation',
    value: function __addAnnotation(documentId, pageNumber, annotation) {
      (0, _abstractFunction2.default)('addAnnotation');
    }
  }, {
    key: '__editAnnotation',


    /**
     * Edit an annotation
     *
     * @param {String} documentId The ID for the document
     * @param {String} pageNumber the page number of the annotation
     * @param {Object} annotation The definition of the modified annotation
     * @return {Promise}
     */
    value: function __editAnnotation(documentId, pageNumber, annotation) {
      (0, _abstractFunction2.default)('editAnnotation');
    }
  }, {
    key: '__deleteAnnotation',


    /**
     * Delete an annotation
     *
     * @param {String} documentId The ID for the document
     * @param {String} annotationId The ID for the annotation
     * @return {Promise}
     */
    value: function __deleteAnnotation(documentId, annotationId) {
      (0, _abstractFunction2.default)('deleteAnnotation');
    }
  }, {
    key: 'getComments',


    /**
     * Get all the comments for an annotation
     *
     * @param {String} documentId The ID for the document
     * @param {String} annotationId The ID for the annotation
     * @return {Promise}
     */
    value: function getComments(documentId, annotationId) {
      (0, _abstractFunction2.default)('getComments');
    }

    /**
     * Add a new comment
     *
     * @param {String} documentId The ID for the document
     * @param {String} annotationId The ID for the annotation
     * @param {Object} content The definition of the comment
     * @return {Promise}
     */

  }, {
    key: '__addComment',
    value: function __addComment(documentId, annotationId, content) {
      (0, _abstractFunction2.default)('addComment');
    }
  }, {
    key: '__deleteComment',


    /**
     * Delete a comment
     *
     * @param {String} documentId The ID for the document
     * @param {String} commentId The ID for the comment
     * @return {Promise}
     */
    value: function __deleteComment(documentId, commentId) {
      (0, _abstractFunction2.default)('deleteComment');
    }
  }, {
    key: 'getAnnotations',
    get: function get() {
      return this.__getAnnotations;
    },
    set: function set(fn) {
      this.__getAnnotations = function getAnnotations(documentId, pageNumber) {
        return fn.apply(undefined, arguments).then(function (annotations) {
          // TODO may be best to have this happen on the server
          if (annotations.annotations) {
            annotations.annotations.forEach(function (a) {
              a.documentId = documentId;
            });
          }
          return annotations;
        });
      };
    }
  }, {
    key: 'addAnnotation',
    get: function get() {
      return this.__addAnnotation;
    },
    set: function set(fn) {
      this.__addAnnotation = function addAnnotation(documentId, pageNumber, annotation) {
        return fn.apply(undefined, arguments).then(function (annotation) {
          (0, _event.fireEvent)('annotation:add', documentId, pageNumber, annotation);
          return annotation;
        });
      };
    }
  }, {
    key: 'editAnnotation',
    get: function get() {
      return this.__editAnnotation;
    },
    set: function set(fn) {
      this.__editAnnotation = function editAnnotation(documentId, annotationId, annotation) {
        return fn.apply(undefined, arguments).then(function (annotation) {
          (0, _event.fireEvent)('annotation:edit', documentId, annotationId, annotation);
          return annotation;
        });
      };
    }
  }, {
    key: 'deleteAnnotation',
    get: function get() {
      return this.__deleteAnnotation;
    },
    set: function set(fn) {
      this.__deleteAnnotation = function deleteAnnotation(documentId, annotationId) {
        return fn.apply(undefined, arguments).then(function (success) {
          if (success) {
            (0, _event.fireEvent)('annotation:delete', documentId, annotationId);
          }
          return success;
        });
      };
    }
  }, {
    key: 'addComment',
    get: function get() {
      return this.__addComment;
    },
    set: function set(fn) {
      this.__addComment = function addComment(documentId, annotationId, content) {
        return fn.apply(undefined, arguments).then(function (comment) {
          (0, _event.fireEvent)('comment:add', documentId, annotationId, comment);
          return comment;
        });
      };
    }
  }, {
    key: 'deleteComment',
    get: function get() {
      return this.__deleteComment;
    },
    set: function set(fn) {
      this.__deleteComment = function deleteComment(documentId, commentId) {
        return fn.apply(undefined, arguments).then(function (success) {
          if (success) {
            (0, _event.fireEvent)('comment:delete', documentId, commentId);
          }
          return success;
        });
      };
    }
  }]);

  return StoreAdapter;
}();

exports.default = StoreAdapter;