'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = render;

var _PDFJSAnnotate = require('../PDFJSAnnotate');

var _PDFJSAnnotate2 = _interopRequireDefault(_PDFJSAnnotate);

var _appendChild = require('./appendChild');

var _appendChild2 = _interopRequireDefault(_appendChild);

var _renderScreenReaderHints = require('../a11y/renderScreenReaderHints');

var _renderScreenReaderHints2 = _interopRequireDefault(_renderScreenReaderHints);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Render the response from PDFJSAnnotate.getStoreAdapter().getAnnotations to SVG
 *
 * @param {SVGElement} svg The SVG element to render the annotations to
 * @param {Object} viewport The page viewport data
 * @param {Object} data The response from PDFJSAnnotate.getStoreAdapter().getAnnotations
 * @return {Promise} Settled once rendering has completed
 *  A settled Promise will be either:
 *    - fulfilled: SVGElement
 *    - rejected: Error
 */
function render(svg, viewport, data) {
  return new Promise(function (resolve, reject) {
    // Reset the content of the SVG
    svg.innerHTML = '';
    svg.setAttribute('data-pdf-annotate-container', true);
    svg.setAttribute('data-pdf-annotate-viewport', JSON.stringify(viewport));
    svg.removeAttribute('data-pdf-annotate-document');
    svg.removeAttribute('data-pdf-annotate-page');

    // If there's no data nothing can be done
    if (!data) {
      return resolve(svg);
    }

    svg.setAttribute('data-pdf-annotate-document', data.documentId);
    svg.setAttribute('data-pdf-annotate-page', data.pageNumber);

    // Make sure annotations is an array
    if (!Array.isArray(data.annotations) || data.annotations.length === 0) {
      return resolve(svg);
    }

    // Append annotation to svg
    data.annotations.forEach(function (a) {
      (0, _appendChild2.default)(svg, a, viewport);
    });

    resolve(svg);
  });
}