'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderLine;

var _setAttributes = require('../utils/setAttributes');

var _setAttributes2 = _interopRequireDefault(_setAttributes);

var _normalizeColor = require('../utils/normalizeColor');

var _normalizeColor2 = _interopRequireDefault(_normalizeColor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Create SVGLineElements from an annotation definition.
 * This is used for anntations of type `strikeout`.
 *
 * @param {Object} a The annotation definition
 * @return {SVGGElement} A group of all lines to be rendered
 */
function renderLine(a) {
  var group = document.createElementNS('http://www.w3.org/2000/svg', 'g');
  (0, _setAttributes2.default)(group, {
    stroke: (0, _normalizeColor2.default)(a.color || '#f00'),
    strokeWidth: 1
  });

  a.rectangles.forEach(function (r) {
    var line = document.createElementNS('http://www.w3.org/2000/svg', 'line');

    (0, _setAttributes2.default)(line, {
      x1: r.x,
      y1: r.y,
      x2: r.x + r.width,
      y2: r.y
    });

    group.appendChild(line);
  });

  return group;
}