'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderPath;

var _setAttributes = require('../utils/setAttributes');

var _setAttributes2 = _interopRequireDefault(_setAttributes);

var _normalizeColor = require('../utils/normalizeColor');

var _normalizeColor2 = _interopRequireDefault(_normalizeColor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Create SVGPathElement from an annotation definition.
 * This is used for anntations of type `drawing`.
 *
 * @param {Object} a The annotation definition
 * @return {SVGPathElement} The path to be rendered
 */
function renderPath(a) {
  var d = [];
  var path = document.createElementNS('http://www.w3.org/2000/svg', 'path');

  for (var i = 0, l = a.lines.length; i < l; i++) {
    var p1 = a.lines[i];
    var p2 = a.lines[i + 1];
    if (p2) {
      d.push('M' + p1[0] + ' ' + p1[1] + ' ' + p2[0] + ' ' + p2[1]);
    }
  }

  (0, _setAttributes2.default)(path, {
    d: d.join(' ') + 'Z',
    stroke: (0, _normalizeColor2.default)(a.color || '#000'),
    strokeWidth: a.width || 1,
    fill: 'none'
  });

  return path;
}