'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderText;

var _setAttributes = require('../utils/setAttributes');

var _setAttributes2 = _interopRequireDefault(_setAttributes);

var _normalizeColor = require('../utils/normalizeColor');

var _normalizeColor2 = _interopRequireDefault(_normalizeColor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Create SVGTextElement from an annotation definition.
 * This is used for anntations of type `textbox`.
 *
 * @param {Object} a The annotation definition
 * @return {SVGTextElement} A text to be rendered
 */
function renderText(a) {
  var text = document.createElementNS('http://www.w3.org/2000/svg', 'text');

  (0, _setAttributes2.default)(text, {
    x: a.x,
    y: a.y + parseInt(a.size, 10),
    fill: (0, _normalizeColor2.default)(a.color || '#000'),
    fontSize: a.size
  });
  text.innerHTML = a.content;

  return text;
}