'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = setAttributes;
var UPPER_REGEX = /[A-Z]/g;

// Don't convert these attributes from camelCase to hyphenated-attributes
var BLACKLIST = ['viewBox'];

var keyCase = function keyCase(key) {
  if (BLACKLIST.indexOf(key) === -1) {
    key = key.replace(UPPER_REGEX, function (match) {
      return '-' + match.toLowerCase();
    });
  }
  return key;
};

/**
 * Set attributes for a node from a map
 *
 * @param {Node} node The node to set attributes on
 * @param {Object} attributes The map of key/value pairs to use for attributes
 */
function setAttributes(node, attributes) {
  Object.keys(attributes).forEach(function (key) {
    node.setAttribute(keyCase(key), attributes[key]);
  });
}