'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = uuid;
var REGEXP = /[xy]/g;
var PATTERN = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx';

function replacement(c) {
  var r = Math.random() * 16 | 0;
  var v = c == 'x' ? r : r & 0x3 | 0x8;
  return v.toString(16);
}

/**
 * Generate a univierally unique identifier
 *
 * @return {String}
 */
function uuid() {
  return PATTERN.replace(REGEXP, replacement);
}