import PDFDocument from '../pdf-document/PDFDocument';
import { PDFIndirectReference, PDFObject } from '../pdf-objects';
import { IParsedPDF } from '../pdf-parser/PDFParser';
declare class PDFDocumentFactory {
    /**
     * Creates a new [[PDFDocument]] object. Useful for creating new PDF documents.
     *
     * @returns The new [[PDFDocument]] object.
     */
    static create: () => PDFDocument;
    /**
     * Loads an existing PDF document contained from the specified `Uint8Array`
     * into a [[PDFDocument]] object. Useful for modifying existing PDF documents.
     *
     * @param data A `Uint8Array` containing the raw bytes of a PDF document.
     *
     * @returns A [[PDFDocument]] object initialized from the provided document.
     */
    static load: (data: Uint8Array) => PDFDocument;
    /** @hidden */
    protected static normalize: ({ dictionaries, arrays, original: { body }, updates, }: IParsedPDF) => Map<PDFIndirectReference<PDFObject>, PDFObject>;
}
export default PDFDocumentFactory;
