import { PDFObjectIndex } from '../pdf-document';
import { PDFObject } from '../pdf-objects';
/**
 * PDFObjectCopier copies PDFObjects from a src index to a dest index.
 * The primary use case for this is to copy pages between PDFs.
 *
 * _Copying_ an object with a PDFObjectCopier is different from _cloning_ an
 * object with its [[PDFObject.clone]] method:
 *
 * ```
 *   const origObject = ...
 *   const copiedObject = PDFObjectCopier.for(srcIndex, destIndex).copy(origObject);
 *   const clonedObject = originalObject.clone();
 * ```
 *
 * Copying an object is equivalent to cloning it and then copying over any other
 * objects that it references. Note that only dictionaries, arrays, and streams
 * (or structures build from them) can contain indirect references to other
 * objects. Copying a PDFObject that is not a dictionary, array, or stream is
 * supported, but is equivalent to cloning it.
 */
declare class PDFObjectCopier {
    static for: (srcIndex: PDFObjectIndex, destIndex: PDFObjectIndex) => PDFObjectCopier;
    private readonly src;
    private readonly dest;
    private readonly traversedObjects;
    constructor(srcIndex: PDFObjectIndex, destIndex: PDFObjectIndex);
    copy: <T extends PDFObject>(object: T) => T;
    private copyPDFPage;
    private copyPDFDict;
    private copyPDFArray;
    private copyPDFStream;
    private copyPDFIndirectObject;
}
export default PDFObjectCopier;
