import { PDFIndirectReference, PDFObject } from '../pdf-objects';
import { error } from '../../utils';
import { isInstance, validate } from '../../utils/validate';
var PDFObjectIndex = /** @class */ (function () {
    function PDFObjectIndex() {
        var _this = this;
        this.index = new Map();
        this.highestObjectNumber = -1;
        this.assign = function (key, val) {
            validate(key, isInstance(PDFIndirectReference), '"key" must be a PDFIndirectReference');
            validate(val, isInstance(PDFObject), '"val" must be a PDFObject');
            if (key.objectNumber > _this.highestObjectNumber) {
                _this.highestObjectNumber = key.objectNumber;
            }
            _this.index.set(key, val);
            return _this;
        };
        this.nextObjectNumber = function () {
            _this.highestObjectNumber += 1;
            var ref = PDFIndirectReference.forNumbers(_this.highestObjectNumber, 0);
            return ref;
        };
        this.assignNextObjectNumberTo = function (val) {
            var ref = _this.nextObjectNumber();
            _this.assign(ref, val);
            return ref;
        };
        this.lookupMaybe = function (ref) {
            if (ref instanceof PDFIndirectReference)
                return _this.index.get(ref);
            return ref;
        };
        this.lookup = function (ref) {
            return _this.lookupMaybe(ref) || error("Failed to lookup ref: " + ref);
        };
    }
    PDFObjectIndex.create = function () { return new PDFObjectIndex(); };
    return PDFObjectIndex;
}());
export default PDFObjectIndex;
