var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import add from 'lodash/add';
import isNumber from 'lodash/isNumber';
import { addStringToBuffer, arrayToString, error } from '../../utils';
import { isInstance, validate, validateArr } from '../../utils/validate';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
import { PDFIndirectObject } from '.';
import PDFObject from './PDFObject';
var PDFArray = /** @class */ (function (_super) {
    __extends(PDFArray, _super);
    function PDFArray(array, index) {
        var _this = _super.call(this) || this;
        _this.push = function () {
            var val = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                val[_i] = arguments[_i];
            }
            validateArr(val, isInstance(PDFObject), 'PDFArray.push() requires arguments to be PDFObjects');
            (_a = _this.array).push.apply(_a, val);
            return _this;
            var _a;
        };
        _this.set = function (idx, val) {
            validate(idx, isNumber, 'PDFArray.set() requires indexes to be numbers');
            validate(val, isInstance(PDFObject), 'PDFArray.set() requires values to be PDFObjects');
            _this.array[idx] = val;
            return _this;
        };
        _this.get = function (idx) {
            validate(idx, isNumber, 'PDFArray.get() requires indexes to be numbers');
            return _this.array[idx];
        };
        _this.forEach = function (fn) {
            return _this.array.forEach(fn);
        };
        _this.map = function (fn) {
            return _this.array.map(fn);
        };
        _this.splice = function (start, deleteCount) {
            return _this.array.splice(start, deleteCount);
        };
        _this.clone = function () { return PDFArray.fromArray(_this.array.slice(), _this.index); };
        _this.toString = function () {
            var bufferSize = _this.bytesSize();
            var buffer = new Uint8Array(bufferSize);
            _this.copyBytesInto(buffer);
            return arrayToString(buffer);
        };
        _this.bytesSize = function () {
            return 2 + // "[ "
                _this.array
                    .map(function (e) {
                    if (e instanceof PDFIndirectObject)
                        return e.toReference().length + 1;
                    else if (e instanceof PDFObject)
                        return e.bytesSize() + 1;
                    return error("Not a PDFObject: " + e);
                })
                    .reduce(add, 0) +
                1;
        }; // "]";
        _this.copyBytesInto = function (buffer) {
            var remaining = addStringToBuffer('[ ', buffer);
            _this.array.forEach(function (e, idx) {
                if (e instanceof PDFIndirectObject) {
                    remaining = addStringToBuffer(e.toReference(), remaining);
                }
                else if (e instanceof PDFObject) {
                    remaining = e.copyBytesInto(remaining);
                }
                else {
                    error("Not a PDFObject: " + e);
                }
                remaining = addStringToBuffer(' ', remaining);
            });
            remaining = addStringToBuffer(']', remaining);
            return remaining;
        };
        _this.size = function () { return _this.array.length; };
        validateArr(array, isInstance(PDFObject), 'Cannot construct PDFArray from array whose elements are not PDFObjects');
        validate(index, isInstance(PDFObjectIndex), '"index" must be a an instance of PDFObjectIndex');
        _this.array = array;
        _this.index = index;
        return _this;
    }
    PDFArray.fromArray = function (array, index) {
        return new PDFArray(array, index);
    };
    return PDFArray;
}(PDFObject));
export default PDFArray;
