var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import isBoolean from 'lodash/isBoolean';
import { addStringToBuffer, toBoolean } from '../../utils';
import { validate } from '../../utils/validate';
import PDFObject from './PDFObject';
var PDFBoolean = /** @class */ (function (_super) {
    __extends(PDFBoolean, _super);
    function PDFBoolean(bool) {
        var _this = _super.call(this) || this;
        _this.clone = function () { return PDFBoolean.fromBool(_this.boolean); };
        _this.toString = function () { return _this.boolean.toString(); };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(bool, isBoolean, 'Can only construct PDFBooleans from Booleans');
        _this.boolean = bool;
        return _this;
    }
    PDFBoolean.fromBool = function (bool) { return new PDFBoolean(bool); };
    PDFBoolean.fromString = function (boolStr) { return new PDFBoolean(toBoolean(boolStr)); };
    return PDFBoolean;
}(PDFObject));
export default PDFBoolean;
