import { PDFName } from '../pdf-objects';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
import PDFObject from './PDFObject';
declare class PDFDictionary extends PDFObject {
    static from: (object: {
        [key: string]: PDFObject;
    } | Map<PDFName, any>, index: PDFObjectIndex) => PDFDictionary;
    map: Map<PDFName, any>;
    index: PDFObjectIndex;
    validKeys?: ReadonlyArray<string>;
    constructor(object: {
        [key: string]: PDFObject;
    } | Map<PDFName, any>, index: PDFObjectIndex, validKeys?: ReadonlyArray<string>);
    filter: (predicate: (o: PDFObject, n: PDFName) => boolean) => [PDFName, any][];
    getMaybe: <T extends PDFObject>(key: string | PDFName) => void | T;
    get: <T extends PDFObject>(key: string | PDFName) => T;
    set: (key: string | PDFName, val: PDFObject, validateKeys?: boolean) => this;
    delete: (key: string | PDFName) => this;
    clone: () => PDFDictionary;
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default PDFDictionary;
