var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import add from 'lodash/add';
import forEach from 'lodash/forEach';
import isNil from 'lodash/isNil';
import isPlainObject from 'lodash/isPlainObject';
import isString from 'lodash/isString';
import { PDFIndirectObject, PDFName } from '../pdf-objects';
import { addStringToBuffer, and, arrayToString, error, not, or } from '../../utils';
import { isInstance, validate } from '../../utils/validate';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
import PDFObject from './PDFObject';
var PDFDictionary = /** @class */ (function (_super) {
    __extends(PDFDictionary, _super);
    function PDFDictionary(object, index, validKeys) {
        var _this = _super.call(this) || this;
        _this.filter = function (predicate) {
            return Array.from(_this.map.entries()).filter(function (_a) {
                var key = _a[0], val = _a[1];
                return predicate(val, key);
            });
        };
        _this.getMaybe = function (key) {
            validate(key, or(isString, isInstance(PDFName)), 'PDFDictionary.set() requires keys to be strings or PDFNames');
            var keyName = key instanceof PDFName ? key : PDFName.from(key);
            return _this.map.get(keyName);
        };
        _this.get = function (key) {
            return _this.getMaybe(key) || error("Missing PDFDictionary entry \"" + key + "\".");
        };
        _this.set = function (key, val, validateKeys) {
            if (validateKeys === void 0) { validateKeys = true; }
            validate(key, or(isString, isInstance(PDFName)), 'PDFDictionary.set() requires keys to be strings or PDFNames');
            validate(val, isInstance(PDFObject), 'PDFDictionary.set() requires values to be PDFObjects');
            var keyName = key instanceof PDFName ? key : PDFName.from(key);
            if (validateKeys &&
                _this.validKeys &&
                !_this.validKeys.includes(keyName.key)) {
                error("Invalid key: \"" + keyName.key + "\"");
            }
            _this.map.set(keyName, val);
            return _this;
        };
        _this.delete = function (key) {
            validate(key, or(isString, isInstance(PDFName)), 'PDFDictionary.set() requires keys to be strings or PDFNames');
            var keyName = key instanceof PDFName ? key : PDFName.from(key);
            _this.map.delete(keyName);
            return _this;
        };
        _this.clone = function () { return PDFDictionary.from(new Map(_this.map), _this.index); };
        _this.toString = function () {
            var buffer = new Uint8Array(_this.bytesSize());
            _this.copyBytesInto(buffer);
            return arrayToString(buffer);
        };
        _this.bytesSize = function () {
            return 3 + // "<<\n"
                Array.from(_this.map.entries())
                    .map(function (_a) {
                    var key = _a[0], val = _a[1];
                    var keySize = (key.toString() + " ").length;
                    if (val instanceof PDFIndirectObject) {
                        return keySize + val.toReference().length + 1;
                    }
                    else if (val instanceof PDFObject) {
                        return keySize + val.bytesSize() + 1;
                    }
                    throw new Error("Not a PDFObject: " + val.constructor.name);
                })
                    .reduce(add, 0) +
                2;
        }; // ">>"
        _this.copyBytesInto = function (buffer) {
            var remaining = addStringToBuffer('<<\n', buffer);
            _this.map.forEach(function (val, key) {
                remaining = addStringToBuffer(key.toString() + " ", remaining);
                if (val instanceof PDFIndirectObject) {
                    remaining = addStringToBuffer(val.toReference(), remaining);
                }
                else if (val instanceof PDFObject) {
                    remaining = val.copyBytesInto(remaining);
                }
                else {
                    throw new Error("Not a PDFObject: " + val.constructor.name);
                }
                remaining = addStringToBuffer('\n', remaining);
            });
            remaining = addStringToBuffer('>>', remaining);
            return remaining;
        };
        validate(object, and(not(isNil), or(isPlainObject, isInstance(Map))), 'PDFDictionary can only be constructed from an Object or a Map');
        validate(index, isInstance(PDFObjectIndex), '"index" must be an instance of PDFObjectIndex');
        _this.index = index;
        _this.validKeys = validKeys;
        if (object instanceof Map) {
            _this.map = object;
        }
        else {
            _this.map = new Map();
            forEach(object, function (val, key) { return _this.set(key, val, false); });
        }
        return _this;
    }
    PDFDictionary.from = function (object, index) { return new PDFDictionary(object, index); };
    return PDFDictionary;
}(PDFObject));
export default PDFDictionary;
