var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import isNumber from 'lodash/isNumber';
import { addStringToBuffer, arrayToString } from '../../utils';
import { isInstance, validate } from '../../utils/validate';
import PDFIndirectReference from './PDFIndirectReference';
import PDFObject from './PDFObject';
var PDFIndirectObject = /** @class */ (function (_super) {
    __extends(PDFIndirectObject, _super);
    function PDFIndirectObject(pdfObject) {
        var _this = _super.call(this) || this;
        _this.getReference = function () { return _this.reference; };
        _this.setReferenceNumbers = function (objectNumber, generationNumber) {
            validate(objectNumber, isNumber, 'objectNumber must be a Number');
            validate(generationNumber, isNumber, 'generationNumber must be a Number');
            _this.reference = PDFIndirectReference.forNumbers(objectNumber, generationNumber);
            return _this;
        };
        _this.setReference = function (reference) {
            validate(reference, isInstance(PDFIndirectReference), '"reference" must be a PDFIndirectReference object');
            _this.reference = reference;
            return _this;
        };
        _this.toReference = function () { return _this.reference.toString(); };
        _this.clone = function () {
            return PDFIndirectObject.of(_this.pdfObject).setReference(_this.reference);
        };
        _this.toString = function () {
            var buffer = new Uint8Array(_this.bytesSize());
            _this.copyBytesInto(buffer);
            return arrayToString(buffer);
        };
        _this.bytesSize = function () {
            return (_this.reference.objectNumber + " " + _this.reference.generationNumber + " obj\n")
                .length +
                _this.pdfObject.bytesSize() +
                9;
        }; // "\nendobj\n\n"
        _this.copyBytesInto = function (buffer) {
            var remaining = addStringToBuffer(_this.reference.objectNumber + " " + _this.reference.generationNumber + " obj\n", buffer);
            remaining = _this.pdfObject.copyBytesInto(remaining);
            remaining = addStringToBuffer('\nendobj\n\n', remaining);
            return remaining;
        };
        validate(pdfObject, isInstance(PDFObject), 'PDFIndirectObject.pdfObject must be of type PDFObject');
        _this.pdfObject = pdfObject;
        return _this;
    }
    PDFIndirectObject.of = function (pdfObject) {
        return new PDFIndirectObject(pdfObject);
    };
    return PDFIndirectObject;
}(PDFObject));
export default PDFIndirectObject;
