var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import isString from 'lodash/isString';
import { addStringToBuffer, and, toCharCode, toHexString } from '../../utils';
import { isIdentity, isNotIdentity, validate } from '../../utils/validate';
import PDFObject from './PDFObject';
// const pdfNameEnforcer = Symbol('PDF_NAME_ENFORCER');
// Using a Symbol is ideal here, but React Native doesn't current support them,
// so we'll use a string instead.
var pdfNameEnforcer = '@@__PDF_NAME_ENFORCER';
var pdfNamePool = new Map();
var PDFName = /** @class */ (function (_super) {
    __extends(PDFName, _super);
    function PDFName(enforcer, key) {
        var _this = _super.call(this) || this;
        _this.clone = function () { return _this; };
        _this.toString = function () {
            return ("/" + _this.key)
                .replace('#', '#23')
                .split('')
                .map(function (char) {
                return PDFName.isRegularChar(char)
                    ? char
                    : "#" + toHexString(toCharCode(char));
            })
                .join('');
        };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(enforcer, isIdentity(pdfNameEnforcer), 'Cannot create PDFName via constructor. Use PDFName.from instead.');
        validate(key.charAt(0), and(isNotIdentity(' '), isNotIdentity('/')), 'PDFName objects may not begin with a space or slash character.');
        _this.key = key;
        return _this;
    }
    PDFName.isRegularChar = function (char) {
        return toCharCode(char) >= toCharCode('!') && toCharCode(char) <= toCharCode('~');
    };
    PDFName.from = function (str) {
        validate(str, isString, 'PDFName.from() requires string as argument');
        var pdfName = pdfNamePool.get(str);
        if (!pdfName) {
            pdfName = new PDFName(pdfNameEnforcer, str);
            pdfNamePool.set(str, pdfName);
        }
        return pdfName;
    };
    PDFName.fromEncoded = function (str) {
        validate(str, isString, 'PDFName.fromEncoded() requires string as argument');
        var decoded = str.replace(/(#\d{2})/g, function (match) {
            return String.fromCharCode(parseInt(match.slice(1), 16));
        });
        return PDFName.from(decoded);
    };
    return PDFName;
}(PDFObject));
export default PDFName;
