var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { addStringToBuffer } from '../../utils';
import { isIdentity, validate } from '../../utils/validate';
import PDFObject from './PDFObject';
// const PDF_NULL_ENFORCER = Symbol('PDF_NULL_ENFORCER');
// Using a Symbol is ideal here, but React Native doesn't current support them,
// so we'll use a string instead.
var PDF_NULL_ENFORCER = '@@__PDF_NULL_ENFORCER';
var PDFNull = /** @class */ (function (_super) {
    __extends(PDFNull, _super);
    function PDFNull(enforcer) {
        var _this = _super.call(this) || this;
        _this.clone = function () { return _this; };
        _this.toString = function () { return 'null'; };
        _this.bytesSize = function () { return 4; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer('null', buffer);
        };
        validate(enforcer, isIdentity(PDF_NULL_ENFORCER), 'Cannot create new PDFNull objects - use PDFNull.instance');
        return _this;
    }
    PDFNull.instance = new PDFNull(PDF_NULL_ENFORCER);
    return PDFNull;
}(PDFObject));
export default PDFNull;
