var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import isFinite from 'lodash/isFinite';
import isString from 'lodash/isString';
import { addStringToBuffer } from '../../utils';
import { validate } from '../../utils/validate';
import PDFObject from './PDFObject';
var PDFNumber = /** @class */ (function (_super) {
    __extends(PDFNumber, _super);
    function PDFNumber(num) {
        var _this = _super.call(this) || this;
        _this.clone = function () { return PDFNumber.fromNumber(_this.number); };
        _this.toString = function () { return _this.number.toString(); };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(num, isFinite, 'Can only construct PDFNumbers from Numbers');
        _this.number = num;
        return _this;
    }
    PDFNumber.fromNumber = function (num) { return new PDFNumber(num); };
    PDFNumber.fromString = function (numberStr) {
        validate(numberStr, isString, 'PDFNumber.fromString requires a string as a parameter.');
        return new PDFNumber(Number(numberStr));
    };
    return PDFNumber;
}(PDFObject));
export default PDFNumber;
