var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { addStringToBuffer } from '../../utils';
import { isInstance, validate } from '../../utils/validate';
import { PDFStream } from '.';
var PDFRawStream = /** @class */ (function (_super) {
    __extends(PDFRawStream, _super);
    function PDFRawStream(dictionary, content) {
        var _this = _super.call(this, dictionary) || this;
        _this.clone = function () {
            return PDFRawStream.from(_this.dictionary.clone(), _this.content.slice());
        };
        _this.bytesSize = function () {
            return _this.dictionary.bytesSize() +
                1 + // "\n"
                7 + // "stream\n"
                _this.content.length +
                10;
        }; // "\nendstream"
        _this.copyBytesInto = function (buffer) {
            _this.validateDictionary();
            var remaining = _this.dictionary.copyBytesInto(buffer);
            remaining = addStringToBuffer('\nstream\n', remaining);
            remaining.set(_this.content, 0);
            remaining = remaining.subarray(_this.content.length);
            remaining = addStringToBuffer('\nendstream', remaining);
            return remaining;
        };
        validate(content, isInstance(Uint8Array), 'PDFRawStream.content must be a Uint8Array');
        _this.content = content;
        return _this;
    }
    PDFRawStream.from = function (dictionary, content) {
        return new PDFRawStream(dictionary, content);
    };
    return PDFRawStream;
}(PDFStream));
export default PDFRawStream;
