var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { PDFDictionary, PDFObject } from '../pdf-objects';
import { error } from '../../utils';
import { isInstance, validate } from '../../utils/validate';
var PDFStream = /** @class */ (function (_super) {
    __extends(PDFStream, _super);
    function PDFStream(dictionary) {
        var _this = _super.call(this) || this;
        _this.validateDictionary = function () {
            if (!_this.dictionary.getMaybe('Length')) {
                error('"Length" is a required field for PDFStream dictionaries');
            }
        };
        _this.clone = function () { return error('"clone" is not implemented on PDFStream.'); };
        validate(dictionary, isInstance(PDFDictionary), 'PDFStream.dictionary must be of type PDFDictionary');
        _this.dictionary = dictionary;
        return _this;
    }
    return PDFStream;
}(PDFObject));
export default PDFStream;
