var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import isString from 'lodash/isString';
import { addStringToBuffer } from '../../utils';
import { validate } from '../../utils/validate';
import PDFObject from './PDFObject';
var PDFString = /** @class */ (function (_super) {
    __extends(PDFString, _super);
    function PDFString(str) {
        var _this = _super.call(this) || this;
        _this.clone = function () { return PDFString.fromString(_this.string); };
        _this.toString = function () { return "(" + _this.string + ")"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(str, isString, 'Can only construct PDFStrings from Strings');
        _this.string = str;
        return _this;
    }
    PDFString.fromString = function (str) { return new PDFString(str); };
    return PDFString;
}(PDFObject));
export default PDFString;
