var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* eslint-disable new-cap */
import isString from 'lodash/isString';
import { PDFName } from '../pdf-objects';
import PDFOperator from '../pdf-operators/PDFOperator';
import { addStringToBuffer, or } from '../../utils';
import { isInstance, validate } from '../../utils/validate';
/**
 * Draws the XObject with the given name in the current Page's Resource dictionary.
 */
var Do = /** @class */ (function (_super) {
    __extends(Do, _super);
    function Do(name) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.name + " Do\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(name, or(isString, isInstance(PDFName)), 'Do operator arg "name" must be a string or PDFName.');
        _this.name = isString(name) ? PDFName.from(name) : name;
        return _this;
    }
    Do.of = function (name) { return new Do(name); };
    return Do;
}(PDFOperator));
export default Do;
