var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file */
import { addStringToBuffer, error } from '../../utils';
import { isIdentity, validate } from '../../utils/validate';
var IPDFOperatorSingleton = /** @class */ (function () {
    function IPDFOperatorSingleton() {
    }
    return IPDFOperatorSingleton;
}());
export { IPDFOperatorSingleton };
var PDFOperator = /** @class */ (function () {
    function PDFOperator() {
        var _this = this;
        this.toString = function () {
            return error("toString() is not implemented on " + _this.constructor.name);
        };
        this.bytesSize = function () {
            return error("bytesSize() is not implemented on " + _this.constructor.name);
        };
        this.copyBytesInto = function (buffer) {
            return error("copyBytesInto() is not implemented on " + _this.constructor.name);
        };
    }
    PDFOperator.createSingletonOp = function (op) {
        // const ENFORCER = Symbol(`${op}_ENFORCER`);
        // Using a Symbol is ideal here, but React Native doesn't current support
        // them, so we'll use a string instead.
        var ENFORCER = "@@__" + op + "_ENFORCER";
        var Singleton = /** @class */ (function (_super) {
            __extends(Singleton, _super);
            function Singleton(enforcer) {
                var _this = _super.call(this) || this;
                _this.toString = function () { return op + "\n"; };
                _this.bytesSize = function () { return _this.toString().length; };
                _this.copyBytesInto = function (buffer) {
                    return addStringToBuffer(_this.toString(), buffer);
                };
                validate(enforcer, isIdentity(ENFORCER), "Cannot instantiate PDFOperator." + op + " - use \"" + op + ".operator\" instead");
                return _this;
            }
            return Singleton;
        }(PDFOperator));
        Singleton.operator = new Singleton(ENFORCER);
        return Singleton;
    };
    return PDFOperator;
}());
export default PDFOperator;
