import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Set the stroking colour space to DeviceGray (or the DefaultGray colour space)
 * and set the gray level to use for stroking operations. gray shall be a number
 * between 0.0 (black) and 1.0 (white).
 */
export declare class G extends PDFOperator {
    static of: (gray: number) => G;
    gray: number;
    constructor(gray: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
/**
 * Same as G but used for nonstroking operations.
 */
export declare class g extends PDFOperator {
    static of: (gray: number) => g;
    gray: number;
    constructor(gray: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
