var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer, and } from '../../../../utils';
import { isInRange, isNumber, validate } from '../../../../utils/validate';
/**
 * Set the stroking colour space to DeviceGray (or the DefaultGray colour space)
 * and set the gray level to use for stroking operations. gray shall be a number
 * between 0.0 (black) and 1.0 (white).
 */
var G = /** @class */ (function (_super) {
    __extends(G, _super);
    function G(gray) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.gray + " G\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(gray, and(isNumber, isInRange(0.0, 1.0)), 'G operator arg "gray" must be a number between 0.0 and 1.0.');
        _this.gray = gray;
        return _this;
    }
    G.of = function (gray) { return new G(gray); };
    return G;
}(PDFOperator));
export { G };
/**
 * Same as G but used for nonstroking operations.
 */
var g = /** @class */ (function (_super) {
    __extends(g, _super);
    function g(gray) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.gray + " g\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(gray, and(isNumber, isInRange(0.0, 1.0)), 'g operator arg "gray" must be a number between 0.0 and 1.0.');
        _this.gray = gray;
        return _this;
    }
    g.of = function (gray) { return new g(gray); };
    return g;
}(PDFOperator));
export { g };
