import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Set the stroking colour space to DeviceRGB (or the DefaultRGB colour space) and
 * set the colour to use for stroking operations. Each operand shall be a number
 * between 0.0 (minimum intensity) and 1.0 (maximum intensity).
 */
export declare class RG extends PDFOperator {
    static of: (r: number, g: number, b: number) => RG;
    r: number;
    g: number;
    b: number;
    constructor(r: number, g: number, b: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
/**
 * Same as RG but used for nonstroking operations.
 */
export declare class rg extends PDFOperator {
    static of: (r: number, g: number, b: number) => rg;
    r: number;
    g: number;
    b: number;
    constructor(r: number, g: number, b: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
