import { PDFName } from '../../../pdf-objects';
import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Same as SC but also supports Pattern, Separation, DeviceN and ICCBased colour
 * spaces.
 *
 * If the current stroking colour space is a Separation, DeviceN, or ICCBased
 * colour space, the operands c1...cn shall be numbers. The number of operands and
 * their interpretation depends on the colour space.
 *
 * If the current stroking colour space is a Pattern colour space, name shall be
 * the name of an entry in the Pattern subdictionary of the current resource
 * dictionary. For an uncoloured tiling pattern
 * (PatternType = 1 and PaintType = 2), c1...cn
 * shall be component values specifying a colour in the pattern’s underlying colour
 * space. For other types of patterns, these operands shall not be specified.
 */
export declare class SCN extends PDFOperator {
    static of: (c: number[], name?: string | PDFName | undefined) => SCN;
    c: number[];
    name?: PDFName;
    constructor(c: number[], name?: string | PDFName);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
/**
 * Same as SCN but used for nonstroking operations.
 */
export declare class scn extends PDFOperator {
    static of: (c: number[], name?: string | PDFName | undefined) => scn;
    c: number[];
    name?: PDFName;
    constructor(c: number[], name?: string | PDFName);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
