var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { oneOf, validate } from '../../../../utils/validate';
/**
 * Set the line cap style in the graphics state
 */
var J = /** @class */ (function (_super) {
    __extends(J, _super);
    function J(lineCap) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.lineCap + " J\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(lineCap, oneOf(0, 1, 2), 'J operator arg "lineCap" must be 0, 1, or 2.');
        _this.lineCap = lineCap;
        return _this;
    }
    J.of = function (lineCap) { return new J(lineCap); };
    return J;
}(PDFOperator));
export { J };
/**
 * Set the line join style in the graphics state
 */
var j = /** @class */ (function (_super) {
    __extends(j, _super);
    function j(lineJoin) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.lineJoin + " j\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(lineJoin, oneOf(0, 1, 2), 'j operator arg "lineJoin" must be 0, 1, or 2.');
        _this.lineJoin = lineJoin;
        return _this;
    }
    j.of = function (lineJoin) { return new j(lineJoin); };
    return j;
}(PDFOperator));
export { j };
