var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* eslint-disable new-cap */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { isNumber, validate } from '../../../../utils/validate';
/**
 * Set the miter limit in the graphics state
 */
var M = /** @class */ (function (_super) {
    __extends(M, _super);
    function M(miterLimit) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.miterLimit + " M\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(miterLimit, isNumber, 'M operator arg "miterLimit" must be a number.');
        _this.miterLimit = miterLimit;
        return _this;
    }
    M.of = function (miterLimit) { return new M(miterLimit); };
    return M;
}(PDFOperator));
export default M;
