var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { isNumber, validateArr } from '../../../../utils/validate';
/**
 * Modify the current transformation matrix (CTM) by concatenating the specified
 * matrix. Although the operands specify a matrix, they shall be written as six
 * separate numbers, not as an array.
 */
var cm = /** @class */ (function (_super) {
    __extends(cm, _super);
    function cm(a, b, c, d, e, f) {
        var _this = _super.call(this) || this;
        _this.toString = function () {
            return _this.a + " " + _this.b + " " + _this.c + " " + _this.d + " " + _this.e + " " + _this.f + " cm\n";
        };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validateArr([a, b, c, d, e, f], isNumber, 'cm operator args "a, b, c, d, e, f" must be all be numbers.');
        _this.a = a;
        _this.b = b;
        _this.c = c;
        _this.d = d;
        _this.e = e;
        _this.f = f;
        return _this;
    }
    cm.of = function (a, b, c, d, e, f) { return new cm(a, b, c, d, e, f); };
    return cm;
}(PDFOperator));
export default cm;
