var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import isNil from 'lodash/isNil';
import { addStringToBuffer, or } from '../../../../utils';
import { isNumber, validate } from '../../../../utils/validate';
/**
 * Set the line dash pattern in the graphics state
 */
var d = /** @class */ (function (_super) {
    __extends(d, _super);
    // TODO: Looks like the dashArray can actually be an array of arbitrary size,
    //       so shouldn't be restricting it here.
    function d(dashArray, dashPhase) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return "[" + _this.dashArray.join(' ') + "] " + _this.dashPhase + " d\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(dashArray[0], or(isNumber, isNil), 'dashArray[0] must be a number or undefined.');
        validate(dashArray[1], or(isNumber, isNil), 'dashArray[1] must be a number or undefined.');
        validate(dashPhase, or(isNumber, isNil), 'd operator arg "dashPhase" must be a number.');
        _this.dashArray = dashArray;
        _this.dashPhase = dashPhase;
        return _this;
    }
    d.of = function (dashArray, dashPhase) {
        return new d(dashArray, dashPhase);
    };
    return d;
}(PDFOperator));
export default d;
