import { PDFName } from '../../../pdf-objects';
import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Set the specified parameters in the graphics state.
 * dictName shall be the name of a graphics state parameter dictionary in the
 *  ExtGState subdictionary of the current resource dictionary.
 */
declare class gs extends PDFOperator {
    static of: (dictName: string | PDFName) => gs;
    dictName: PDFName;
    constructor(dictName: string | PDFName);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default gs;
