var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import isString from 'lodash/isString';
import { PDFName } from '../../../pdf-objects';
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { validate } from '../../../../utils/validate';
/**
 * Set the specified parameters in the graphics state.
 * dictName shall be the name of a graphics state parameter dictionary in the
 *  ExtGState subdictionary of the current resource dictionary.
 */
var gs = /** @class */ (function (_super) {
    __extends(gs, _super);
    function gs(dictName) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.dictName + " gs\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(dictName, isString, 'gs operator arg "dictName" must be a string or PDFName.');
        _this.dictName = isString(dictName) ? PDFName.from(dictName) : dictName;
        return _this;
    }
    gs.of = function (dictName) { return new gs(dictName); };
    return gs;
}(PDFOperator));
export default gs;
