var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { oneOf, validate } from '../../../../utils/validate';
/**
 * Set the colour rendering intent in the graphics state. The rendering intent
 * must be one of the following values:
 *  - AbsoluteColorimetric
 *  - RelativeColorimetric
 *  - Saturation
 *  - Perceptual
 */
var ri = /** @class */ (function (_super) {
    __extends(ri, _super);
    // TODO: Should this be a PDFName?
    function ri(intent) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.intent + " ri\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(intent, oneOf('/AbsoluteColorimetric', '/RelativeColorimetric', '/Saturation', '/Perceptual'), "ri operator arg \"intent\" must be one of: \"AbsoluteColorimetric\", \"RelativeColorimetric\", \"Saturation\", \"Perceptual\"");
        _this.intent = intent;
        return _this;
    }
    ri.of = function (intent) { return new ri(intent); };
    return ri;
}(PDFOperator));
export default ri;
